/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("pdfjs-dist/build/pdf.worker",[],t):"object"==typeof exports?exports["pdfjs-dist/build/pdf.worker"]=t():e["pdfjs-dist/build/pdf.worker"]=e.pdfjsWorker=t()}(this,(function(){return(()=>{"use strict";var e=[,(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.WorkerTask=t.WorkerMessageHandler=void 0;var a,i=r(2),n=r(5),s=r(6),o=r(48),c=r(4),l=r(69),h=r(70),u=r(8);class d{constructor(e){this.name=e,this.terminated=!1,this._capability=(0,i.createPromiseCapability)()}get finished(){return this._capability.promise}finish(){this._capability.resolve()}terminate(){this.terminated=!0}ensureNotTerminated(){if(this.terminated)throw new Error("Worker task was terminated")}}t.WorkerTask=d;class f{static setup(e,t){var r=!1;e.on("test",(function(t){if(r)return;if(r=!0,!(t instanceof Uint8Array))return void e.send("test",null);const a=255===t[0];e.postMessageTransfers=a,e.send("test",{supportTransfers:a})})),e.on("configure",(function(e){(0,i.setVerbosityLevel)(e.verbosity)})),e.on("GetDocRequest",(function(e){return f.createDocumentHandler(e,t)}))}static createDocumentHandler(e,t){var r,a=!1,c=null,f=[];const g=(0,i.getVerbosityLevel)(),p=e.apiVersion,m="2.8.335";if(p!==m)throw new Error(`The API version "${p}" does not match the Worker version "2.8.335".`);const b=[];for(const e in[])b.push(e);if(b.length)throw new Error("The `Array.prototype` contains unexpected enumerable properties: "+b.join(", ")+"; thus breaking e.g. `for...in` iteration of `Array`s.");if("undefined"==typeof ReadableStream)throw new Error("The browser/environment lacks native support for critical functionality used by the PDF.js library (e.g. `ReadableStream`); please use a `legacy`-build instead.");var y=e.docId,w=e.docBaseUrl,v=e.docId+"_worker",S=new l.MessageHandler(v,y,t);function k(){if(a)throw new Error("Worker was terminated")}function x(e){f.push(e)}function A(e){e.finish();var t=f.indexOf(e);f.splice(t,1)}async function C(e){await r.ensureDoc("checkHeader"),await r.ensureDoc("parseStartXRef"),await r.ensureDoc("parse",[e]),e||await r.ensureDoc("checkFirstPage");const[t,a,i]=await Promise.all([r.ensureDoc("numPages"),r.ensureDoc("fingerprint"),r.ensureDoc("isPureXfa")]);return{numPages:t,fingerprint:a,isPureXfa:i}}function O(e,t,r){var a=(0,i.createPromiseCapability)();let n;var o=e.source;if(o.data){try{n=new s.LocalPdfManager(y,o.data,o.password,t,r,w),a.resolve(n)}catch(e){a.reject(e)}return a.promise}var l,u=[];try{l=new h.PDFWorkerStream(S)}catch(e){return a.reject(e),a.promise}var d=l.getFullReader();d.headersReady.then((function(){if(d.isRangeSupported){var e=o.disableAutoFetch||d.isStreamingSupported;n=new s.NetworkPdfManager(y,l,{msgHandler:S,password:o.password,length:d.contentLength,disableAutoFetch:e,rangeChunkSize:o.rangeChunkSize},t,r,w);for(let e=0;e<u.length;e++)n.sendProgressiveData(u[e]);u=[],a.resolve(n),c=null}})).catch((function(e){a.reject(e),c=null}));var f=0;return new Promise((function(e,l){var h=function({value:e,done:g}){try{if(k(),g)return n||function(){var e=(0,i.arraysToBytes)(u);o.length&&e.length!==o.length&&(0,i.warn)("reported HTTP length is different from actual");try{n=new s.LocalPdfManager(y,e,o.password,t,r,w),a.resolve(n)}catch(e){a.reject(e)}u=[]}(),void(c=null);f+=(0,i.arrayByteLength)(e),d.isStreamingSupported||S.send("DocProgress",{loaded:f,total:Math.max(f,d.contentLength||0)}),n?n.sendProgressiveData(e):u.push(e),d.read().then(h,l)}catch(e){l(e)}};d.read().then(h,l)})).catch((function(e){a.reject(e),c=null})),c=function(e){l.cancelAllRequests(e)},a.promise}return S.postMessageTransfers=e.postMessageTransfers,S.on("GetPage",(function(e){return r.getPage(e.pageIndex).then((function(e){return Promise.all([r.ensure(e,"rotate"),r.ensure(e,"ref"),r.ensure(e,"userUnit"),r.ensure(e,"view")]).then((function([e,t,r,a]){return{rotate:e,ref:t,userUnit:r,view:a}}))}))})),S.on("GetPageIndex",(function({ref:e}){const t=n.Ref.get(e.num,e.gen);return r.ensureCatalog("getPageIndex",[t])})),S.on("GetDestinations",(function(e){return r.ensureCatalog("destinations")})),S.on("GetDestination",(function(e){return r.ensureCatalog("getDestination",[e.id])})),S.on("GetPageLabels",(function(e){return r.ensureCatalog("pageLabels")})),S.on("GetPageLayout",(function(e){return r.ensureCatalog("pageLayout")})),S.on("GetPageMode",(function(e){return r.ensureCatalog("pageMode")})),S.on("GetViewerPreferences",(function(e){return r.ensureCatalog("viewerPreferences")})),S.on("GetOpenAction",(function(e){return r.ensureCatalog("openAction")})),S.on("GetAttachments",(function(e){return r.ensureCatalog("attachments")})),S.on("GetJavaScript",(function(e){return r.ensureCatalog("javaScript")})),S.on("GetDocJSActions",(function(e){return r.ensureCatalog("jsActions")})),S.on("GetPageJSActions",(function({pageIndex:e}){return r.getPage(e).then((function(e){return e.jsActions}))})),S.on("GetPageXfa",(function({pageIndex:e}){return r.getPage(e).then((function(e){return r.ensure(e,"xfaData")}))})),S.on("GetIsPureXfa",(function(e){return r.ensureDoc("isPureXfa")})),S.on("GetOutline",(function(e){return r.ensureCatalog("documentOutline")})),S.on("GetOptionalContentConfig",(function(e){return r.ensureCatalog("optionalContentConfig")})),S.on("GetPermissions",(function(e){return r.ensureCatalog("permissions")})),S.on("GetMetadata",(function(e){return Promise.all([r.ensureDoc("documentInfo"),r.ensureCatalog("metadata")])})),S.on("GetMarkInfo",(function(e){return r.ensureCatalog("markInfo")})),S.on("GetData",(function(e){return r.requestLoadedStream(),r.onLoadedStream().then((function(e){return e.bytes}))})),S.on("GetStats",(function(e){return r.ensureXRef("stats")})),S.on("GetAnnotations",(function({pageIndex:e,intent:t}){return r.getPage(e).then((function(e){return e.getAnnotationsData(t)}))})),S.on("GetFieldObjects",(function(e){return r.ensureDoc("fieldObjects")})),S.on("HasJSActions",(function(e){return r.ensureDoc("hasJSActions")})),S.on("GetCalculationOrderIds",(function(e){return r.ensureDoc("calculationOrderIds")})),S.on("SaveDocument",(function({numPages:e,annotationStorage:t,filename:a}){r.requestLoadedStream();const s=[r.onLoadedStream(),r.ensureCatalog("acroForm"),r.ensureDoc("xref"),r.ensureDoc("startXRef")];for(let a=0;a<e;a++)s.push(r.getPage(a).then((function(e){const r=new d(`Save: page ${a}`);return x(r),e.save(S,r,t).finally((function(){A(r)}))})));return Promise.all(s).then((function([e,t,r,s,...c]){let l=[];for(const e of c)l=e.filter((e=>null!==e)).reduce(((e,t)=>e.concat(t)),l);if(0===l.length)return e.bytes;const h=t instanceof n.Dict&&t.get("XFA")||[];let u=null;if(Array.isArray(h))for(let e=0,t=h.length;e<t;e+=2)"datasets"===h[e]&&(u=h[e+1]);else(0,i.warn)("Unsupported XFA type.");let d=Object.create(null);if(r.trailer){const e=Object.create(null),t=r.trailer.get("Info")||null;t instanceof n.Dict&&t.forEach(((t,r)=>{(0,i.isString)(t)&&(0,i.isString)(r)&&(e[t]=(0,i.stringToPDFString)(r))})),d={rootRef:r.trailer.getRaw("Root")||null,encrypt:r.trailer.getRaw("Encrypt")||null,newRef:r.getNewRef(),infoRef:r.trailer.getRaw("Info")||null,info:e,fileIds:r.trailer.getRaw("ID")||null,startXRef:s,filename:a}}return r.resetNewRef(),(0,o.incrementalUpdate)({originalData:e.bytes,xrefInfo:d,newRefs:l,xref:r,datasetsRef:u})}))})),S.on("GetOperatorList",(function(e,t){var a=e.pageIndex;r.getPage(a).then((function(r){var n=new d(`GetOperatorList: page ${a}`);x(n);const s=g>=i.VerbosityLevel.INFOS?Date.now():0;r.getOperatorList({handler:S,sink:t,task:n,intent:e.intent,renderInteractiveForms:e.renderInteractiveForms,annotationStorage:e.annotationStorage}).then((function(e){A(n),s&&(0,i.info)(`page=${a+1} - getOperatorList: time=${Date.now()-s}ms, len=${e.length}`),t.close()}),(function(e){A(n),n.terminated||(S.send("UnsupportedFeature",{featureId:i.UNSUPPORTED_FEATURES.errorOperatorList}),t.error(e))}))}))})),S.on("GetTextContent",(function(e,t){var a=e.pageIndex;t.onPull=function(e){},t.onCancel=function(e){},r.getPage(a).then((function(r){var n=new d("GetTextContent: page "+a);x(n);const s=g>=i.VerbosityLevel.INFOS?Date.now():0;r.extractTextContent({handler:S,task:n,sink:t,normalizeWhitespace:e.normalizeWhitespace,combineTextItems:e.combineTextItems}).then((function(){A(n),s&&(0,i.info)(`page=${a+1} - getTextContent: time=`+(Date.now()-s)+"ms"),t.close()}),(function(e){A(n),n.terminated||t.error(e)}))}))})),S.on("FontFallback",(function(e){return r.fontFallback(e.id,S)})),S.on("Cleanup",(function(e){return r.cleanup(!0)})),S.on("Terminate",(function(e){a=!0;const t=[];if(r){r.terminate(new i.AbortException("Worker was terminated."));const e=r.cleanup();t.push(e),r=null}else(0,n.clearPrimitiveCaches)();return c&&c(new i.AbortException("Worker was terminated.")),f.forEach((function(e){t.push(e.finished),e.terminate()})),Promise.all(t).then((function(){S.destroy(),S=null}))})),S.on("Ready",(function(t){!function(e){function t(e){k(),S.send("GetDoc",{pdfInfo:e})}function n(e){if(k(),e instanceof i.PasswordException){var t=new d(`PasswordException: response ${e.code}`);x(t),S.sendWithPromise("PasswordRequest",e).then((function({password:e}){A(t),r.updatePassword(e),s()})).catch((function(){A(t),S.send("DocException",e)}))}else e instanceof i.InvalidPDFException||e instanceof i.MissingPDFException||e instanceof i.UnexpectedResponseException||e instanceof i.UnknownErrorException?S.send("DocException",e):S.send("DocException",new i.UnknownErrorException(e.message,e.toString()))}function s(){k(),C(!1).then(t,(function(e){k(),e instanceof u.XRefParseException?(r.requestLoadedStream(),r.onLoadedStream().then((function(){k(),C(!0).then(t,n)}))):n(e)}))}k(),O(e,{maxImageSize:e.maxImageSize,disableFontFace:e.disableFontFace,ignoreErrors:e.ignoreErrors,isEvalSupported:e.isEvalSupported,fontExtraProperties:e.fontExtraProperties},e.enableXfa).then((function(e){if(a)throw e.terminate(new i.AbortException("Worker was terminated.")),new Error("Worker was terminated");(r=e).onLoadedStream().then((function(e){S.send("DataLoaded",{length:e.bytes.byteLength})}))})).then(s,n)}(e),e=null})),v}static initializeFromPort(e){var t=new l.MessageHandler("worker","main",e);f.setup(t,e),t.send("ready",null)}}t.WorkerMessageHandler=f,"undefined"==typeof window&&!c.isNodeJS&&"undefined"!=typeof self&&("function"==typeof(a=self).postMessage&&"onmessage"in a)&&f.initializeFromPort(self)},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.arrayByteLength=d,t.arraysToBytes=function(e){const t=e.length;if(1===t&&e[0]instanceof Uint8Array)return e[0];let r=0;for(let a=0;a<t;a++)r+=d(e[a]);let a=0;const i=new Uint8Array(r);for(let r=0;r<t;r++){let t=e[r];t instanceof Uint8Array||(t="string"==typeof t?u(t):new Uint8Array(t));const n=t.byteLength;i.set(t,a),a+=n}return i},t.assert=o,t.bytesToString=function(e){o(null!==e&&"object"==typeof e&&void 0!==e.length,"Invalid argument for bytesToString");const t=e.length,r=8192;if(t<r)return String.fromCharCode.apply(null,e);const a=[];for(let i=0;i<t;i+=r){const n=Math.min(i+r,t),s=e.subarray(i,n);a.push(String.fromCharCode.apply(null,s))}return a.join("")},t.createObjectURL=function(e,t="",r=!1){if(URL.createObjectURL&&!r)return URL.createObjectURL(new Blob([e],{type:t}));const a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";let i=`data:${t};base64,`;for(let t=0,r=e.length;t<r;t+=3){const n=255&e[t],s=255&e[t+1],o=255&e[t+2];i+=a[n>>2]+a[(3&n)<<4|s>>4]+a[t+1<r?(15&s)<<2|o>>6:64]+a[t+2<r?63&o:64]}return i},t.createPromiseCapability=function(){const e=Object.create(null);let t=!1;return Object.defineProperty(e,"settled",{get:()=>t}),e.promise=new Promise((function(r,a){e.resolve=function(e){t=!0,r(e)},e.reject=function(e){t=!0,a(e)}})),e},t.createValidAbsoluteUrl=function(e,t){if(!e)return null;try{const r=t?new URL(e,t):new URL(e);if(function(e){if(!e)return!1;switch(e.protocol){case"http:":case"https:":case"ftp:":case"mailto:":case"tel:":return!0;default:return!1}}(r))return r}catch(e){}return null},t.escapeString=function(e){return e.replace(/([()\\\n\r])/g,(e=>"\n"===e?"\\n":"\r"===e?"\\r":`\\${e}`))},t.getModificationDate=function(e=new Date){return[e.getUTCFullYear().toString(),(e.getUTCMonth()+1).toString().padStart(2,"0"),e.getUTCDate().toString().padStart(2,"0"),e.getUTCHours().toString().padStart(2,"0"),e.getUTCMinutes().toString().padStart(2,"0"),e.getUTCSeconds().toString().padStart(2,"0")].join("")},t.getVerbosityLevel=function(){return i},t.info=function(e){},t.isArrayBuffer=function(e){return"object"==typeof e&&null!==e&&void 0!==e.byteLength},t.isArrayEqual=function(e,t){if(e.length!==t.length)return!1;for(let r=0,a=e.length;r<a;r++)if(e[r]!==t[r])return!1;return!0},t.isAscii=function(e){return/^[\x00-\x7F]*$/.test(e)},t.isBool=function(e){return"boolean"==typeof e},t.isNum=function(e){return"number"==typeof e},t.isSameOrigin=function(e,t){let r;try{if(r=new URL(e),!r.origin||"null"===r.origin)return!1}catch(e){return!1}const a=new URL(t,r);return r.origin===a.origin},t.isString=function(e){return"string"==typeof e},t.objectFromMap=function(e){const t=Object.create(null);for(const[r,a]of e)t[r]=a;return t},t.objectSize=function(e){return Object.keys(e).length},t.removeNullCharacters=function(e){if("string"!=typeof e)return n("The argument for removeNullCharacters must be a string."),e;return e.replace(h,"")},t.setVerbosityLevel=function(e){Number.isInteger(e)&&(i=e)},t.shadow=c,t.string32=function(e){return String.fromCharCode(e>>24&255,e>>16&255,e>>8&255,255&e)},t.stringToBytes=u,t.stringToPDFString=function(e){const t=e.length,r=[];if("þ"===e[0]&&"ÿ"===e[1])for(let a=2;a<t;a+=2)r.push(String.fromCharCode(e.charCodeAt(a)<<8|e.charCodeAt(a+1)));else if("ÿ"===e[0]&&"þ"===e[1])for(let a=2;a<t;a+=2)r.push(String.fromCharCode(e.charCodeAt(a+1)<<8|e.charCodeAt(a)));else for(let a=0;a<t;++a){const t=b[e.charCodeAt(a)];r.push(t?String.fromCharCode(t):e.charAt(a))}return r.join("")},t.stringToUTF16BEString=function(e){const t=["þÿ"];for(let r=0,a=e.length;r<a;r++){const a=e.charCodeAt(r);t.push(String.fromCharCode(a>>8&255)),t.push(String.fromCharCode(255&a))}return t.join("")},t.stringToUTF8String=function(e){return decodeURIComponent(escape(e))},t.unreachable=s,t.utf8StringToString=function(e){return unescape(encodeURIComponent(e))},t.warn=n,t.VerbosityLevel=t.Util=t.UNSUPPORTED_FEATURES=t.UnknownErrorException=t.UnexpectedResponseException=t.TextRenderingMode=t.StreamType=t.PermissionFlag=t.PasswordResponses=t.PasswordException=t.PageActionEventType=t.OPS=t.MissingPDFException=t.IsLittleEndianCached=t.IsEvalSupportedCached=t.InvalidPDFException=t.ImageKind=t.IDENTITY_MATRIX=t.FormatError=t.FontType=t.FONT_IDENTITY_MATRIX=t.DocumentActionEventType=t.CMapCompressionType=t.BaseException=t.AnnotationType=t.AnnotationStateModelType=t.AnnotationReviewState=t.AnnotationReplyType=t.AnnotationMarkedState=t.AnnotationFlag=t.AnnotationFieldFlag=t.AnnotationBorderStyleType=t.AnnotationActionEventType=t.AbortException=void 0,r(3);t.IDENTITY_MATRIX=[1,0,0,1,0,0];t.FONT_IDENTITY_MATRIX=[.001,0,0,.001,0,0];t.PermissionFlag={PRINT:4,MODIFY_CONTENTS:8,COPY:16,MODIFY_ANNOTATIONS:32,FILL_INTERACTIVE_FORMS:256,COPY_FOR_ACCESSIBILITY:512,ASSEMBLE:1024,PRINT_HIGH_QUALITY:2048};t.TextRenderingMode={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4};t.ImageKind={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3};t.AnnotationType={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26};t.AnnotationStateModelType={MARKED:"Marked",REVIEW:"Review"};t.AnnotationMarkedState={MARKED:"Marked",UNMARKED:"Unmarked"};t.AnnotationReviewState={ACCEPTED:"Accepted",REJECTED:"Rejected",CANCELLED:"Cancelled",COMPLETED:"Completed",NONE:"None"};t.AnnotationReplyType={GROUP:"Group",REPLY:"R"};t.AnnotationFlag={INVISIBLE:1,HIDDEN:2,PRINT:4,NOZOOM:8,NOROTATE:16,NOVIEW:32,READONLY:64,LOCKED:128,TOGGLENOVIEW:256,LOCKEDCONTENTS:512};t.AnnotationFieldFlag={READONLY:1,REQUIRED:2,NOEXPORT:4,MULTILINE:4096,PASSWORD:8192,NOTOGGLETOOFF:16384,RADIO:32768,PUSHBUTTON:65536,COMBO:131072,EDIT:262144,SORT:524288,FILESELECT:1048576,MULTISELECT:2097152,DONOTSPELLCHECK:4194304,DONOTSCROLL:8388608,COMB:16777216,RICHTEXT:33554432,RADIOSINUNISON:33554432,COMMITONSELCHANGE:67108864};t.AnnotationBorderStyleType={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5};t.AnnotationActionEventType={E:"Mouse Enter",X:"Mouse Exit",D:"Mouse Down",U:"Mouse Up",Fo:"Focus",Bl:"Blur",PO:"PageOpen",PC:"PageClose",PV:"PageVisible",PI:"PageInvisible",K:"Keystroke",F:"Format",V:"Validate",C:"Calculate"};t.DocumentActionEventType={WC:"WillClose",WS:"WillSave",DS:"DidSave",WP:"WillPrint",DP:"DidPrint"};t.PageActionEventType={O:"PageOpen",C:"PageClose"};t.StreamType={UNKNOWN:"UNKNOWN",FLATE:"FLATE",LZW:"LZW",DCT:"DCT",JPX:"JPX",JBIG:"JBIG",A85:"A85",AHX:"AHX",CCF:"CCF",RLX:"RLX"};t.FontType={UNKNOWN:"UNKNOWN",TYPE1:"TYPE1",TYPE1C:"TYPE1C",CIDFONTTYPE0:"CIDFONTTYPE0",CIDFONTTYPE0C:"CIDFONTTYPE0C",TRUETYPE:"TRUETYPE",CIDFONTTYPE2:"CIDFONTTYPE2",TYPE3:"TYPE3",OPENTYPE:"OPENTYPE",TYPE0:"TYPE0",MMTYPE1:"MMTYPE1"};const a={ERRORS:0,WARNINGS:1,INFOS:5};t.VerbosityLevel=a;t.CMapCompressionType={NONE:0,BINARY:1,STREAM:2};t.OPS={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotations:78,endAnnotations:79,beginAnnotation:80,endAnnotation:81,paintJpegXObject:82,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91};t.UNSUPPORTED_FEATURES={unknown:"unknown",forms:"forms",javaScript:"javaScript",smask:"smask",shadingPattern:"shadingPattern",font:"font",errorTilingPattern:"errorTilingPattern",errorExtGState:"errorExtGState",errorXObject:"errorXObject",errorFontLoadType3:"errorFontLoadType3",errorFontState:"errorFontState",errorFontMissing:"errorFontMissing",errorFontTranslate:"errorFontTranslate",errorColorSpace:"errorColorSpace",errorOperatorList:"errorOperatorList",errorFontToUnicode:"errorFontToUnicode",errorFontLoadNative:"errorFontLoadNative",errorFontGetPath:"errorFontGetPath",errorMarkedContent:"errorMarkedContent"};t.PasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2};let i=a.WARNINGS;function n(e){}function s(e){throw new Error(e)}function o(e,t){e||s(t)}function c(e,t,r){return Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!1}),r}const l=function(){function e(t){this.constructor===e&&s("Cannot initialize BaseException."),this.message=t,this.name=this.constructor.name}return e.prototype=new Error,e.constructor=e,e}();t.BaseException=l;t.PasswordException=class extends l{constructor(e,t){super(e),this.code=t}};t.UnknownErrorException=class extends l{constructor(e,t){super(e),this.details=t}};t.InvalidPDFException=class extends l{};t.MissingPDFException=class extends l{};t.UnexpectedResponseException=class extends l{constructor(e,t){super(e),this.status=t}};t.FormatError=class extends l{};t.AbortException=class extends l{};const h=/\x00/g;function u(e){o("string"==typeof e,"Invalid argument for stringToBytes");const t=e.length,r=new Uint8Array(t);for(let a=0;a<t;++a)r[a]=255&e.charCodeAt(a);return r}function d(e){return void 0!==e.length?e.length:(o(void 0!==e.byteLength,"arrayByteLength - invalid argument."),e.byteLength)}const f={get value(){return c(this,"value",function(){const e=new Uint8Array(4);return e[0]=1,1===new Uint32Array(e.buffer,0,1)[0]}())}};t.IsLittleEndianCached=f;const g={get value(){return c(this,"value",function(){try{return new Function(""),!0}catch(e){return!1}}())}};t.IsEvalSupportedCached=g;const p=[...Array(256).keys()].map((e=>e.toString(16).padStart(2,"0")));class m{static makeHexColor(e,t,r){return`#${p[e]}${p[t]}${p[r]}`}static transform(e,t){return[e[0]*t[0]+e[2]*t[1],e[1]*t[0]+e[3]*t[1],e[0]*t[2]+e[2]*t[3],e[1]*t[2]+e[3]*t[3],e[0]*t[4]+e[2]*t[5]+e[4],e[1]*t[4]+e[3]*t[5]+e[5]]}static applyTransform(e,t){return[e[0]*t[0]+e[1]*t[2]+t[4],e[0]*t[1]+e[1]*t[3]+t[5]]}static applyInverseTransform(e,t){const r=t[0]*t[3]-t[1]*t[2];return[(e[0]*t[3]-e[1]*t[2]+t[2]*t[5]-t[4]*t[3])/r,(-e[0]*t[1]+e[1]*t[0]+t[4]*t[1]-t[5]*t[0])/r]}static getAxialAlignedBoundingBox(e,t){const r=m.applyTransform(e,t),a=m.applyTransform(e.slice(2,4),t),i=m.applyTransform([e[0],e[3]],t),n=m.applyTransform([e[2],e[1]],t);return[Math.min(r[0],a[0],i[0],n[0]),Math.min(r[1],a[1],i[1],n[1]),Math.max(r[0],a[0],i[0],n[0]),Math.max(r[1],a[1],i[1],n[1])]}static inverseTransform(e){const t=e[0]*e[3]-e[1]*e[2];return[e[3]/t,-e[1]/t,-e[2]/t,e[0]/t,(e[2]*e[5]-e[4]*e[3])/t,(e[4]*e[1]-e[5]*e[0])/t]}static apply3dTransform(e,t){return[e[0]*t[0]+e[1]*t[1]+e[2]*t[2],e[3]*t[0]+e[4]*t[1]+e[5]*t[2],e[6]*t[0]+e[7]*t[1]+e[8]*t[2]]}static singularValueDecompose2dScale(e){const t=[e[0],e[2],e[1],e[3]],r=e[0]*t[0]+e[1]*t[2],a=e[0]*t[1]+e[1]*t[3],i=e[2]*t[0]+e[3]*t[2],n=e[2]*t[1]+e[3]*t[3],s=(r+n)/2,o=Math.sqrt((r+n)**2-4*(r*n-i*a))/2,c=s+o||1,l=s-o||1;return[Math.sqrt(c),Math.sqrt(l)]}static normalizeRect(e){const t=e.slice(0);return e[0]>e[2]&&(t[0]=e[2],t[2]=e[0]),e[1]>e[3]&&(t[1]=e[3],t[3]=e[1]),t}static intersect(e,t){function r(e,t){return e-t}const a=[e[0],e[2],t[0],t[2]].sort(r),i=[e[1],e[3],t[1],t[3]].sort(r),n=[];return e=m.normalizeRect(e),t=m.normalizeRect(t),a[0]===e[0]&&a[1]===t[0]||a[0]===t[0]&&a[1]===e[0]?(n[0]=a[1],n[2]=a[2],i[0]===e[1]&&i[1]===t[1]||i[0]===t[1]&&i[1]===e[1]?(n[1]=i[1],n[3]=i[2],n):null):null}}t.Util=m;const b=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,710,729,733,731,730,732,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8226,8224,8225,8230,8212,8211,402,8260,8249,8250,8722,8240,8222,8220,8221,8216,8217,8218,8482,64257,64258,321,338,352,376,381,305,322,339,353,382,0,8364]},(e,t,r)=>{r(4)},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.isNodeJS=void 0;const r=!("object"!=typeof process||process+""!="[object process]"||process.versions.nw||process.versions.electron&&process.type&&"browser"!==process.type);t.isNodeJS=r},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.clearPrimitiveCaches=function(){s._clearCache(),n._clearCache(),c._clearCache()},t.isCmd=function(e,t){return e instanceof s&&(void 0===t||e.cmd===t)},t.isDict=function(e,t){return e instanceof o&&(void 0===t||l(e.get("Type"),t))},t.isEOF=function(e){return e===i},t.isName=l,t.isRef=function(e){return e instanceof c},t.isRefsEqual=function(e,t){return e.num===t.num&&e.gen===t.gen},t.isStream=function(e){return"object"==typeof e&&null!==e&&void 0!==e.getBytes},t.RefSetCache=t.RefSet=t.Ref=t.Name=t.EOF=t.Dict=t.Cmd=void 0;var a=r(2);const i={};t.EOF=i;const n=function(){let e=Object.create(null);function t(e){this.name=e}return t.prototype={},t.get=function(r){const a=e[r];return a||(e[r]=new t(r))},t._clearCache=function(){e=Object.create(null)},t}();t.Name=n;const s=function(){let e=Object.create(null);function t(e){this.cmd=e}return t.prototype={},t.get=function(r){const a=e[r];return a||(e[r]=new t(r))},t._clearCache=function(){e=Object.create(null)},t}();t.Cmd=s;const o=function(){const e=function(){return e};function t(t){this._map=Object.create(null),this.xref=t,this.objId=null,this.suppressEncryption=!1,this.__nonSerializable__=e}return t.prototype={assignXref:function(e){this.xref=e},get size(){return Object.keys(this._map).length},get(e,t,r){let a=this._map[e];return void 0===a&&void 0!==t&&(a=this._map[t],void 0===a&&void 0!==r&&(a=this._map[r])),a instanceof c&&this.xref?this.xref.fetch(a,this.suppressEncryption):a},async getAsync(e,t,r){let a=this._map[e];return void 0===a&&void 0!==t&&(a=this._map[t],void 0===a&&void 0!==r&&(a=this._map[r])),a instanceof c&&this.xref?this.xref.fetchAsync(a,this.suppressEncryption):a},getArray(e,t,r){let a=this.get(e,t,r);if(!Array.isArray(a)||!this.xref)return a;a=a.slice();for(let e=0,t=a.length;e<t;e++)a[e]instanceof c&&(a[e]=this.xref.fetch(a[e],this.suppressEncryption));return a},getRaw:function(e){return this._map[e]},getKeys:function(){return Object.keys(this._map)},getRawValues:function(){return Object.values(this._map)},set:function(e,t){this._map[e]=t},has:function(e){return void 0!==this._map[e]},forEach:function(e){for(const t in this._map)e(t,this.get(t))}},t.empty=function(){const e=new t(null);return e.set=(e,t)=>{(0,a.unreachable)("Should not call `set` on the empty dictionary.")},e}(),t.merge=function({xref:e,dictArray:r,mergeSubDicts:a=!1}){const i=new t(e);if(!a){for(const e of r)if(e instanceof t)for(const[t,r]of Object.entries(e._map))void 0===i._map[t]&&(i._map[t]=r);return i.size>0?i:t.empty}const n=new Map;for(const e of r)if(e instanceof t)for(const[t,r]of Object.entries(e._map)){let e=n.get(t);void 0===e&&(e=[],n.set(t,e)),e.push(r)}for(const[r,a]of n){if(1===a.length||!(a[0]instanceof t)){i._map[r]=a[0];continue}const n=new t(e);for(const e of a)if(e instanceof t)for(const[t,r]of Object.entries(e._map))void 0===n._map[t]&&(n._map[t]=r);n.size>0&&(i._map[r]=n)}return n.clear(),i.size>0?i:t.empty},t}();t.Dict=o;const c=function(){let e=Object.create(null);function t(e,t){this.num=e,this.gen=t}return t.prototype={toString:function(){return 0===this.gen?`${this.num}R`:`${this.num}R${this.gen}`}},t.get=function(r,a){const i=0===a?`${r}R`:`${r}R${a}`,n=e[i];return n||(e[i]=new t(r,a))},t._clearCache=function(){e=Object.create(null)},t}();t.Ref=c;t.RefSet=class{constructor(e=null){this._set=new Set(e&&e._set)}has(e){return this._set.has(e.toString())}put(e){this._set.add(e.toString())}remove(e){this._set.delete(e.toString())}forEach(e){for(const t of this._set.values())e(t)}clear(){this._set.clear()}};function l(e,t){return e instanceof n&&(void 0===t||e.name===t)}t.RefSetCache=class{constructor(){this._map=new Map}get size(){return this._map.size}get(e){return this._map.get(e.toString())}has(e){return this._map.has(e.toString())}put(e,t){this._map.set(e.toString(),t)}putAlias(e,t){this._map.set(e.toString(),this.get(t))}forEach(e){for(const t of this._map.values())e(t)}clear(){this._map.clear()}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.NetworkPdfManager=t.LocalPdfManager=void 0;var a=r(2),i=r(7),n=r(8),s=r(9),o=r(12);function c(e){if(e){const t=(0,a.createValidAbsoluteUrl)(e);if(t)return t.href;(0,a.warn)(`Invalid absolute docBaseUrl: "${e}".`)}return null}class l{constructor(){this.constructor===l&&(0,a.unreachable)("Cannot initialize BasePdfManager.")}get docId(){return this._docId}get password(){return this._password}get docBaseUrl(){return this._docBaseUrl}onLoadedStream(){(0,a.unreachable)("Abstract method `onLoadedStream` called")}ensureDoc(e,t){return this.ensure(this.pdfDocument,e,t)}ensureXRef(e,t){return this.ensure(this.pdfDocument.xref,e,t)}ensureCatalog(e,t){return this.ensure(this.pdfDocument.catalog,e,t)}getPage(e){return this.pdfDocument.getPage(e)}fontFallback(e,t){return this.pdfDocument.fontFallback(e,t)}cleanup(e=!1){return this.pdfDocument.cleanup(e)}async ensure(e,t,r){(0,a.unreachable)("Abstract method `ensure` called")}requestRange(e,t){(0,a.unreachable)("Abstract method `requestRange` called")}requestLoadedStream(){(0,a.unreachable)("Abstract method `requestLoadedStream` called")}sendProgressiveData(e){(0,a.unreachable)("Abstract method `sendProgressiveData` called")}updatePassword(e){this._password=e}terminate(e){(0,a.unreachable)("Abstract method `terminate` called")}}t.LocalPdfManager=class extends l{constructor(e,t,r,a,i,n){super(),this._docId=e,this._password=r,this._docBaseUrl=c(n),this.evaluatorOptions=a,this.enableXfa=i;const l=new o.Stream(t);this.pdfDocument=new s.PDFDocument(this,l),this._loadedStreamPromise=Promise.resolve(l)}async ensure(e,t,r){const a=e[t];return"function"==typeof a?a.apply(e,r):a}requestRange(e,t){return Promise.resolve()}requestLoadedStream(){}onLoadedStream(){return this._loadedStreamPromise}terminate(e){}};t.NetworkPdfManager=class extends l{constructor(e,t,r,a,n,o){super(),this._docId=e,this._password=r.password,this._docBaseUrl=c(o),this.msgHandler=r.msgHandler,this.evaluatorOptions=a,this.enableXfa=n,this.streamManager=new i.ChunkedStreamManager(t,{msgHandler:r.msgHandler,length:r.length,disableAutoFetch:r.disableAutoFetch,rangeChunkSize:r.rangeChunkSize}),this.pdfDocument=new s.PDFDocument(this,this.streamManager.getStream())}async ensure(e,t,r){try{const a=e[t];return"function"==typeof a?a.apply(e,r):a}catch(a){if(!(a instanceof n.MissingDataException))throw a;return await this.requestRange(a.begin,a.end),this.ensure(e,t,r)}}requestRange(e,t){return this.streamManager.requestRange(e,t)}requestLoadedStream(){this.streamManager.requestAllChunks()}sendProgressiveData(e){this.streamManager.onReceiveData({chunk:e})}onLoadedStream(){return this.streamManager.onLoadedStream()}terminate(e){this.streamManager.abort(e)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ChunkedStreamManager=t.ChunkedStream=void 0;var a=r(2),i=r(8);class n{constructor(e,t,r){this.bytes=new Uint8Array(e),this.start=0,this.pos=0,this.end=e,this.chunkSize=t,this._loadedChunks=new Set,this.numChunks=Math.ceil(e/t),this.manager=r,this.progressiveDataLength=0,this.lastSuccessfulEnsureByteChunk=-1}getMissingChunks(){const e=[];for(let t=0,r=this.numChunks;t<r;++t)this._loadedChunks.has(t)||e.push(t);return e}getBaseStreams(){return[this]}get numChunksLoaded(){return this._loadedChunks.size}allChunksLoaded(){return this.numChunksLoaded===this.numChunks}onReceiveData(e,t){const r=this.chunkSize;if(e%r!=0)throw new Error(`Bad begin offset: ${e}`);const a=e+t.byteLength;if(a%r!=0&&a!==this.bytes.length)throw new Error(`Bad end offset: ${a}`);this.bytes.set(new Uint8Array(t),e);const i=Math.floor(e/r),n=Math.floor((a-1)/r)+1;for(let e=i;e<n;++e)this._loadedChunks.add(e)}onReceiveProgressiveData(e){let t=this.progressiveDataLength;const r=Math.floor(t/this.chunkSize);this.bytes.set(new Uint8Array(e),t),t+=e.byteLength,this.progressiveDataLength=t;const a=t>=this.end?this.numChunks:Math.floor(t/this.chunkSize);for(let e=r;e<a;++e)this._loadedChunks.add(e)}ensureByte(e){if(e<this.progressiveDataLength)return;const t=Math.floor(e/this.chunkSize);if(t!==this.lastSuccessfulEnsureByteChunk){if(!this._loadedChunks.has(t))throw new i.MissingDataException(e,e+1);this.lastSuccessfulEnsureByteChunk=t}}ensureRange(e,t){if(e>=t)return;if(t<=this.progressiveDataLength)return;const r=this.chunkSize,a=Math.floor(e/r),n=Math.floor((t-1)/r)+1;for(let r=a;r<n;++r)if(!this._loadedChunks.has(r))throw new i.MissingDataException(e,t)}nextEmptyChunk(e){const t=this.numChunks;for(let r=0;r<t;++r){const a=(e+r)%t;if(!this._loadedChunks.has(a))return a}return null}hasChunk(e){return this._loadedChunks.has(e)}get length(){return this.end-this.start}get isEmpty(){return 0===this.length}getByte(){const e=this.pos;return e>=this.end?-1:(e>=this.progressiveDataLength&&this.ensureByte(e),this.bytes[this.pos++])}getUint16(){const e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t}getInt32(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()}getBytes(e,t=!1){const r=this.bytes,a=this.pos,i=this.end;if(!e){i>this.progressiveDataLength&&this.ensureRange(a,i);const e=r.subarray(a,i);return t?new Uint8ClampedArray(e):e}let n=a+e;n>i&&(n=i),n>this.progressiveDataLength&&this.ensureRange(a,n),this.pos=n;const s=r.subarray(a,n);return t?new Uint8ClampedArray(s):s}peekByte(){const e=this.getByte();return-1!==e&&this.pos--,e}peekBytes(e,t=!1){const r=this.getBytes(e,t);return this.pos-=r.length,r}getByteRange(e,t){return e<0&&(e=0),t>this.end&&(t=this.end),t>this.progressiveDataLength&&this.ensureRange(e,t),this.bytes.subarray(e,t)}skip(e){e||(e=1),this.pos+=e}reset(){this.pos=this.start}moveStart(){this.start=this.pos}makeSubStream(e,t,r){function a(){}t?e+t>this.progressiveDataLength&&this.ensureRange(e,e+t):e>=this.progressiveDataLength&&this.ensureByte(e),a.prototype=Object.create(this),a.prototype.getMissingChunks=function(){const e=this.chunkSize,t=Math.floor(this.start/e),r=Math.floor((this.end-1)/e)+1,a=[];for(let e=t;e<r;++e)this._loadedChunks.has(e)||a.push(e);return a},a.prototype.allChunksLoaded=function(){return this.numChunksLoaded===this.numChunks||0===this.getMissingChunks().length};const i=new a;return i.pos=i.start=e,i.end=e+t||this.end,i.dict=r,i}}t.ChunkedStream=n;t.ChunkedStreamManager=class{constructor(e,t){this.length=t.length,this.chunkSize=t.rangeChunkSize,this.stream=new n(this.length,this.chunkSize,this),this.pdfNetworkStream=e,this.disableAutoFetch=t.disableAutoFetch,this.msgHandler=t.msgHandler,this.currRequestId=0,this._chunksNeededByRequest=new Map,this._requestsByChunk=new Map,this._promisesByRequest=new Map,this.progressiveDataLength=0,this.aborted=!1,this._loadedStreamCapability=(0,a.createPromiseCapability)()}onLoadedStream(){return this._loadedStreamCapability.promise}sendRequest(e,t){const r=this.pdfNetworkStream.getRangeReader(e,t);r.isStreamingSupported||(r.onProgress=this.onProgress.bind(this));let i=[],n=0;new Promise(((e,t)=>{const s=o=>{try{if(!o.done){const e=o.value;return i.push(e),n+=(0,a.arrayByteLength)(e),r.isStreamingSupported&&this.onProgress({loaded:n}),void r.read().then(s,t)}const c=(0,a.arraysToBytes)(i);i=null,e(c)}catch(e){t(e)}};r.read().then(s,t)})).then((t=>{this.aborted||this.onReceiveData({chunk:t,begin:e})}))}requestAllChunks(){const e=this.stream.getMissingChunks();return this._requestChunks(e),this._loadedStreamCapability.promise}_requestChunks(e){const t=this.currRequestId++,r=new Set;this._chunksNeededByRequest.set(t,r);for(const t of e)this.stream.hasChunk(t)||r.add(t);if(0===r.size)return Promise.resolve();const i=(0,a.createPromiseCapability)();this._promisesByRequest.set(t,i);const n=[];for(const e of r){let r=this._requestsByChunk.get(e);r||(r=[],this._requestsByChunk.set(e,r),n.push(e)),r.push(t)}if(n.length>0){const e=this.groupChunks(n);for(const t of e){const e=t.beginChunk*this.chunkSize,r=Math.min(t.endChunk*this.chunkSize,this.length);this.sendRequest(e,r)}}return i.promise.catch((e=>{if(!this.aborted)throw e}))}getStream(){return this.stream}requestRange(e,t){t=Math.min(t,this.length);const r=this.getBeginChunk(e),a=this.getEndChunk(t),i=[];for(let e=r;e<a;++e)i.push(e);return this._requestChunks(i)}requestRanges(e=[]){const t=[];for(const r of e){const e=this.getBeginChunk(r.begin),a=this.getEndChunk(r.end);for(let r=e;r<a;++r)t.includes(r)||t.push(r)}return t.sort((function(e,t){return e-t})),this._requestChunks(t)}groupChunks(e){const t=[];let r=-1,a=-1;for(let i=0,n=e.length;i<n;++i){const n=e[i];r<0&&(r=n),a>=0&&a+1!==n&&(t.push({beginChunk:r,endChunk:a+1}),r=n),i+1===e.length&&t.push({beginChunk:r,endChunk:n+1}),a=n}return t}onProgress(e){this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize+e.loaded,total:this.length})}onReceiveData(e){const t=e.chunk,r=void 0===e.begin,a=r?this.progressiveDataLength:e.begin,i=a+t.byteLength,n=Math.floor(a/this.chunkSize),s=i<this.length?Math.floor(i/this.chunkSize):Math.ceil(i/this.chunkSize);r?(this.stream.onReceiveProgressiveData(t),this.progressiveDataLength=i):this.stream.onReceiveData(a,t),this.stream.allChunksLoaded()&&this._loadedStreamCapability.resolve(this.stream);const o=[];for(let e=n;e<s;++e){const t=this._requestsByChunk.get(e);if(t){this._requestsByChunk.delete(e);for(const r of t){const t=this._chunksNeededByRequest.get(r);t.has(e)&&t.delete(e),t.size>0||o.push(r)}}}if(!this.disableAutoFetch&&0===this._requestsByChunk.size){let e;if(1===this.stream.numChunksLoaded){const t=this.stream.numChunks-1;this.stream.hasChunk(t)||(e=t)}else e=this.stream.nextEmptyChunk(s);Number.isInteger(e)&&this._requestChunks([e])}for(const e of o){const t=this._promisesByRequest.get(e);this._promisesByRequest.delete(e),t.resolve()}this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize,total:this.length})}onError(e){this._loadedStreamCapability.reject(e)}getBeginChunk(e){return Math.floor(e/this.chunkSize)}getEndChunk(e){return Math.floor((e-1)/this.chunkSize)+1}abort(e){this.aborted=!0,this.pdfNetworkStream&&this.pdfNetworkStream.cancelAllRequests(e);for(const t of this._promisesByRequest.values())t.reject(e)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.collectActions=function(e,t,r){const n=Object.create(null),s=c({dict:t,key:"AA",stopWhenFound:!1});if(s)for(let t=s.length-1;t>=0;t--){const a=s[t];if(a instanceof i.Dict)for(const t of a.getKeys()){const s=r[t];if(!s)continue;const o=a.getRaw(t),c=new i.RefSet,l=[];h(o,e,l,c),l.length>0&&(n[s]=l)}}if(t.has("A")){const r=t.get("A"),a=new i.RefSet,s=[];h(r,e,s,a),s.length>0&&(n.Action=s)}return(0,a.objectSize)(n)>0?n:null},t.encodeToXmlString=function(e){const t=[];let r=0;for(let a=0,i=e.length;a<i;a++){const i=e.codePointAt(a);if(32<=i&&i<=126){const n=u[i];n&&(r<a&&t.push(e.substring(r,a)),t.push(n),r=a+1)}else r<a&&t.push(e.substring(r,a)),t.push(`&#x${i.toString(16).toUpperCase()};`),i>55295&&(i<57344||i>65533)&&a++,r=a+1}if(0===t.length)return e;r<e.length&&t.push(e.substring(r,e.length));return t.join("")},t.escapePDFName=function(e){const t=[];let r=0;for(let a=0,i=e.length;a<i;a++){const i=e.charCodeAt(a);(i<33||i>126||35===i||40===i||41===i||60===i||62===i||91===i||93===i||123===i||125===i||47===i||37===i)&&(r<a&&t.push(e.substring(r,a)),t.push(`#${i.toString(16)}`),r=a+1)}if(0===t.length)return e;r<e.length&&t.push(e.substring(r,e.length));return t.join("")},t.getArrayLookupTableFactory=function(e){let t;return function(){if(e){let r=e();e=null,t=Object.create(null);for(let e=0,a=r.length;e<a;e+=2)t[r[e]]=r[e+1];r=null}return t}},t.getInheritableProperty=c,t.getLookupTableFactory=function(e){let t;return function(){return e&&(t=Object.create(null),e(t),e=null),t}},t.isWhiteSpace=function(e){return 32===e||9===e||13===e||10===e},t.log2=function(e){if(e<=0)return 0;return Math.ceil(Math.log2(e))},t.parseXFAPath=function(e){const t=/(.+)\[([0-9]+)\]$/;return e.split(".").map((e=>{const r=e.match(t);return r?{name:r[1],pos:parseInt(r[2],10)}:{name:e,pos:0}}))},t.readInt8=function(e,t){return e[t]<<24>>24},t.readUint16=function(e,t){return e[t]<<8|e[t+1]},t.readUint32=function(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0},t.toRomanNumerals=function(e,t=!1){(0,a.assert)(Number.isInteger(e)&&e>0,"The number should be a positive integer.");const r=[];let i;for(;e>=1e3;)e-=1e3,r.push("M");i=e/100|0,e%=100,r.push(l[i]),i=e/10|0,e%=10,r.push(l[10+i]),r.push(l[20+e]);const n=r.join("");return t?n.toLowerCase():n},t.XRefParseException=t.XRefEntryException=t.MissingDataException=void 0;var a=r(2),i=r(5);class n extends a.BaseException{constructor(e,t){super(`Missing data [${e}, ${t})`),this.begin=e,this.end=t}}t.MissingDataException=n;class s extends a.BaseException{}t.XRefEntryException=s;class o extends a.BaseException{}function c({dict:e,key:t,getArray:r=!1,stopWhenFound:a=!0}){let n;const s=new i.RefSet;for(;e instanceof i.Dict&&(!e.objId||!s.has(e.objId));){e.objId&&s.put(e.objId);const i=r?e.getArray(t):e.get(t);if(void 0!==i){if(a)return i;n||(n=[]),n.push(i)}e=e.get("Parent")}return n}t.XRefParseException=o;const l=["","C","CC","CCC","CD","D","DC","DCC","DCCC","CM","","X","XX","XXX","XL","L","LX","LXX","LXXX","XC","","I","II","III","IV","V","VI","VII","VIII","IX"];function h(e,t,r,n){if(!e)return;let s=null;if((0,i.isRef)(e)){if(n.has(e))return;s=e,n.put(s),e=t.fetch(e)}if(Array.isArray(e))for(const a of e)h(a,t,r,n);else if(e instanceof i.Dict){if((0,i.isName)(e.get("S"),"JavaScript")&&e.has("JS")){const t=e.get("JS");let n;n=(0,i.isStream)(t)?(0,a.bytesToString)(t.getBytes()):t,n=(0,a.stringToPDFString)(n),n&&r.push(n)}h(e.getRaw("Next"),t,r,n)}s&&n.remove(s)}const u={60:"&lt;",62:"&gt;",38:"&amp;",34:"&quot;",39:"&apos;"}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFDocument=t.Page=void 0;var a=r(2),i=r(10),n=r(5),s=r(8),o=r(12),c=r(27),l=r(22),h=r(11),u=r(46),d=r(29),f=r(49);const g=[0,0,612,792];function p(e,t){return"display"===t&&e.viewable||"print"===t&&e.printable}class m{constructor({pdfManager:e,xref:t,pageIndex:r,pageDict:a,ref:i,globalIdFactory:n,fontCache:s,builtInCMapCache:o,globalImageCache:c,nonBlendModesSet:l,xfaFactory:h}){this.pdfManager=e,this.pageIndex=r,this.pageDict=a,this.xref=t,this.ref=i,this.fontCache=s,this.builtInCMapCache=o,this.globalImageCache=c,this.nonBlendModesSet=l,this.evaluatorOptions=e.evaluatorOptions,this.resourcesPromise=null,this.xfaFactory=h;const u={obj:0};this._localIdFactory=class extends n{static createObjId(){return`p${r}_${++u.obj}`}}}_getInheritableProperty(e,t=!1){const r=(0,s.getInheritableProperty)({dict:this.pageDict,key:e,getArray:t,stopWhenFound:!1});return Array.isArray(r)?1!==r.length&&(0,n.isDict)(r[0])?n.Dict.merge({xref:this.xref,dictArray:r}):r[0]:r}get content(){return this.pageDict.get("Contents")}get resources(){return(0,a.shadow)(this,"resources",this._getInheritableProperty("Resources")||n.Dict.empty)}_getBoundingBox(e){if(this.xfaData){const{width:e,height:t}=this.xfaData.attributes.style;return[0,0,parseInt(e),parseInt(t)]}const t=this._getInheritableProperty(e,!0);if(Array.isArray(t)&&4===t.length){if(t[2]-t[0]!=0&&t[3]-t[1]!=0)return t;(0,a.warn)(`Empty /${e} entry.`)}return null}get mediaBox(){return(0,a.shadow)(this,"mediaBox",this._getBoundingBox("MediaBox")||g)}get cropBox(){return(0,a.shadow)(this,"cropBox",this._getBoundingBox("CropBox")||this.mediaBox)}get userUnit(){let e=this.pageDict.get("UserUnit");return(!(0,a.isNum)(e)||e<=0)&&(e=1),(0,a.shadow)(this,"userUnit",e)}get view(){const{cropBox:e,mediaBox:t}=this;let r;if(e===t||(0,a.isArrayEqual)(e,t))r=t;else{const i=a.Util.intersect(e,t);i&&i[2]-i[0]!=0&&i[3]-i[1]!=0?r=i:(0,a.warn)("Empty /CropBox and /MediaBox intersection.")}return(0,a.shadow)(this,"view",r||t)}get rotate(){let e=this._getInheritableProperty("Rotate")||0;return e%90!=0?e=0:e>=360?e%=360:e<0&&(e=(e%360+360)%360),(0,a.shadow)(this,"rotate",e)}getContentStream(){const e=this.content;let t;if(Array.isArray(e)){const r=this.xref,a=[];for(const t of e)a.push(r.fetchIfRef(t));t=new o.StreamsSequenceStream(a)}else t=(0,n.isStream)(e)?e:new o.NullStream;return t}get xfaData(){return this.xfaFactory?(0,a.shadow)(this,"xfaData",this.xfaFactory.getPage(this.pageIndex)):(0,a.shadow)(this,"xfaData",null)}save(e,t,r){const i=new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,globalImageCache:this.globalImageCache,options:this.evaluatorOptions});return this._parsedAnnotations.then((function(e){const n=[];for(const s of e)p(s,"print")&&n.push(s.save(i,t,r).catch((function(e){return(0,a.warn)(`save - ignoring annotation data during "${t.name}" task: "${e}".`),null})));return Promise.all(n)}))}loadResources(e){return this.resourcesPromise||(this.resourcesPromise=this.pdfManager.ensure(this,"resources")),this.resourcesPromise.then((()=>new i.ObjectLoader(this.resources,e,this.xref).load()))}getOperatorList({handler:e,sink:t,task:r,intent:i,renderInteractiveForms:n,annotationStorage:s}){const o=this.pdfManager.ensure(this,"getContentStream"),c=this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"]),l=new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,globalImageCache:this.globalImageCache,options:this.evaluatorOptions}),h=Promise.all([o,c]).then((([a])=>{const n=new u.OperatorList(i,t);return e.send("StartRenderPage",{transparency:l.hasBlendModes(this.resources,this.nonBlendModesSet),pageIndex:this.pageIndex,intent:i}),l.getOperatorList({stream:a,task:r,resources:this.resources,operatorList:n}).then((function(){return n}))}));return Promise.all([h,this._parsedAnnotations]).then((function([e,t]){if(0===t.length)return e.flush(!0),{length:e.totalLength};const o=[];for(const e of t)p(e,i)&&!e.isHidden(s)&&o.push(e.getOperatorList(l,r,n,s).catch((function(e){return(0,a.warn)(`getOperatorList - ignoring annotation data during "${r.name}" task: "${e}".`),null})));return Promise.all(o).then((function(t){e.addOp(a.OPS.beginAnnotations,[]);for(const r of t)e.addOpList(r);return e.addOp(a.OPS.endAnnotations,[]),e.flush(!0),{length:e.totalLength}}))}))}extractTextContent({handler:e,task:t,normalizeWhitespace:r,sink:a,combineTextItems:i}){const n=this.pdfManager.ensure(this,"getContentStream"),s=this.loadResources(["ExtGState","XObject","Font"]);return Promise.all([n,s]).then((([n])=>new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,globalImageCache:this.globalImageCache,options:this.evaluatorOptions}).getTextContent({stream:n,task:t,resources:this.resources,normalizeWhitespace:r,combineTextItems:i,sink:a})))}getAnnotationsData(e){return this._parsedAnnotations.then((function(t){const r=[];for(let a=0,i=t.length;a<i;a++)e&&!p(t[a],e)||r.push(t[a].data);return r}))}get annotations(){const e=this._getInheritableProperty("Annots");return(0,a.shadow)(this,"annotations",Array.isArray(e)?e:[])}get _parsedAnnotations(){const e=this.pdfManager.ensure(this,"annotations").then((()=>{const e=[];for(const t of this.annotations)e.push(c.AnnotationFactory.create(this.xref,t,this.pdfManager,this._localIdFactory,!1).catch((function(e){return(0,a.warn)(`_parsedAnnotations: "${e}".`),null})));return Promise.all(e).then((function(e){return e.filter((e=>!!e))}))}));return(0,a.shadow)(this,"_parsedAnnotations",e)}get jsActions(){const e=(0,s.collectActions)(this.xref,this.pageDict,a.PageActionEventType);return(0,a.shadow)(this,"jsActions",e)}}t.Page=m;const b=new Uint8Array([37,80,68,70,45]),y=new Uint8Array([115,116,97,114,116,120,114,101,102]),w=new Uint8Array([101,110,100,111,98,106]),v=/^[1-9]\.[0-9]$/;function S(e,t,r=1024,a=!1){const i=t.length,n=e.peekBytes(r),s=n.length-i;if(s<=0)return!1;if(a){const r=i-1;let a=n.length-1;for(;a>=r;){let s=0;for(;s<i&&n[a-s]===t[r-s];)s++;if(s>=i)return e.pos+=a-r,!0;a--}}else{let r=0;for(;r<=s;){let a=0;for(;a<i&&n[r+a]===t[a];)a++;if(a>=i)return e.pos+=r,!0;r++}}return!1}t.PDFDocument=class{constructor(e,t){let r;if((0,n.isStream)(t))r=t;else{if(!(0,a.isArrayBuffer)(t))throw new Error("PDFDocument: Unknown argument type");r=new o.Stream(t)}if(r.length<=0)throw new a.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");this.pdfManager=e,this.stream=r,this.xref=new i.XRef(r,e),this._pagePromises=[],this._version=null;const s={font:0};this._globalIdFactory=class{static getDocId(){return`g_${e.docId}`}static createFontId(){return"f"+ ++s.font}static createObjId(){(0,a.unreachable)("Abstract method `createObjId` called.")}}}parse(e){this.xref.parse(e),this.catalog=new i.Catalog(this.pdfManager,this.xref),this.catalog.version&&(this._version=this.catalog.version)}get linearization(){let e=null;try{e=h.Linearization.create(this.stream)}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.info)(e)}return(0,a.shadow)(this,"linearization",e)}get startXRef(){const e=this.stream;let t=0;if(this.linearization)e.reset(),S(e,w)&&(t=e.pos+6-e.start);else{const r=1024,a=y.length;let i=!1,n=e.end;for(;!i&&n>0;)n-=r-a,n<0&&(n=0),e.pos=n,i=S(e,y,r,!0);if(i){let r;e.skip(9);do{r=e.getByte()}while((0,s.isWhiteSpace)(r));let a="";for(;r>=32&&r<=57;)a+=String.fromCharCode(r),r=e.getByte();t=parseInt(a,10),isNaN(t)&&(t=0)}}return(0,a.shadow)(this,"startXRef",t)}checkHeader(){const e=this.stream;if(e.reset(),!S(e,b))return;e.moveStart();let t,r="";for(;(t=e.getByte())>32&&!(r.length>=12);)r+=String.fromCharCode(t);this._version||(this._version=r.substring(5))}parseStartXRef(){this.xref.setStartXRef(this.startXRef)}get numPages(){if(this.xfaFactory)return(0,a.shadow)(this,"numPages",this.xfaFactory.numberPages);const e=this.linearization,t=e?e.numPages:this.catalog.numPages;return(0,a.shadow)(this,"numPages",t)}_hasOnlyDocumentSignatures(e,t=0){return!!Array.isArray(e)&&e.every((e=>{if(!((e=this.xref.fetchIfRef(e))instanceof n.Dict))return!1;if(e.has("Kids"))return++t>10?((0,a.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached"),!1):this._hasOnlyDocumentSignatures(e.get("Kids"),t);const r=(0,n.isName)(e.get("FT"),"Sig"),i=e.get("Rect"),s=Array.isArray(i)&&i.every((e=>0===e));return r&&s}))}get xfaData(){const e=this.catalog.acroForm;if(!e)return null;const t=e.get("XFA"),r={"xdp:xdp":"",template:"",datasets:"",config:"",connectionSet:"",localeSet:"",stylesheet:"","/xdp:xdp":""};if((0,n.isStream)(t)&&!t.isEmpty)try{return r["xdp:xdp"]=(0,a.stringToUTF8String)((0,a.bytesToString)(t.getBytes())),r}catch(e){return(0,a.warn)("XFA - Invalid utf-8 string."),null}if(!Array.isArray(t)||0===t.length)return null;for(let e=0,i=t.length;e<i;e+=2){let s;if(s=0===e?"xdp:xdp":e===i-2?"/xdp:xdp":t[e],!r.hasOwnProperty(s))continue;const o=this.xref.fetchIfRef(t[e+1]);if((0,n.isStream)(o)&&!o.isEmpty)try{r[s]=(0,a.stringToUTF8String)((0,a.bytesToString)(o.getBytes()))}catch(e){return(0,a.warn)("XFA - Invalid utf-8 string."),null}}return r}get xfaFactory(){if(this.pdfManager.enableXfa&&this.formInfo.hasXfa&&!this.formInfo.hasAcroForm){const e=this.xfaData;return(0,a.shadow)(this,"xfaFactory",e?new f.XFAFactory(e):null)}return(0,a.shadow)(this,"xfaFaxtory",null)}get isPureXfa(){return null!==this.xfaFactory}get formInfo(){const e={hasFields:!1,hasAcroForm:!1,hasXfa:!1},t=this.catalog.acroForm;if(!t)return(0,a.shadow)(this,"formInfo",e);try{const r=t.get("Fields"),a=Array.isArray(r)&&r.length>0;e.hasFields=a;const i=t.get("XFA");e.hasXfa=Array.isArray(i)&&i.length>0||(0,n.isStream)(i)&&!i.isEmpty;const s=!!(1&t.get("SigFlags"))&&this._hasOnlyDocumentSignatures(r);e.hasAcroForm=a&&!s}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.warn)(`Cannot fetch form information: "${e}".`)}return(0,a.shadow)(this,"formInfo",e)}get documentInfo(){const e={Title:a.isString,Author:a.isString,Subject:a.isString,Keywords:a.isString,Creator:a.isString,Producer:a.isString,CreationDate:a.isString,ModDate:a.isString,Trapped:n.isName};let t=this._version;"string"==typeof t&&v.test(t)||((0,a.warn)(`Invalid PDF header version number: ${t}`),t=null);const r={PDFFormatVersion:t,IsLinearized:!!this.linearization,IsAcroFormPresent:this.formInfo.hasAcroForm,IsXFAPresent:this.formInfo.hasXfa,IsCollectionPresent:!!this.catalog.collection};let i;try{i=this.xref.trailer.get("Info")}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.info)("The document information dictionary is invalid.")}if((0,n.isDict)(i))for(const t of i.getKeys()){const s=i.get(t);if(e[t])e[t](s)?r[t]="string"!=typeof s?s:(0,a.stringToPDFString)(s):(0,a.info)(`Bad value in document info for "${t}".`);else if("string"==typeof t){let e;if((0,a.isString)(s))e=(0,a.stringToPDFString)(s);else{if(!((0,n.isName)(s)||(0,a.isNum)(s)||(0,a.isBool)(s))){(0,a.info)(`Unsupported value in document info for (custom) "${t}".`);continue}e=s}r.Custom||(r.Custom=Object.create(null)),r.Custom[t]=e}}return(0,a.shadow)(this,"documentInfo",r)}get fingerprint(){let e;const t=this.xref.trailer.get("ID");e=Array.isArray(t)&&t[0]&&(0,a.isString)(t[0])&&"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"!==t[0]?(0,a.stringToBytes)(t[0]):(0,l.calculateMD5)(this.stream.getByteRange(0,1024),0,1024);const r=[];for(let t=0,a=e.length;t<a;t++){const a=e[t].toString(16);r.push(a.padStart(2,"0"))}return(0,a.shadow)(this,"fingerprint",r.join(""))}_getLinearizationPage(e){const{catalog:t,linearization:r}=this,i=n.Ref.get(r.objectNumberFirst,0);return this.xref.fetchAsync(i).then((e=>{if((0,n.isDict)(e,"Page")||(0,n.isDict)(e)&&!e.has("Type")&&e.has("Contents"))return i&&!t.pageKidsCountCache.has(i)&&t.pageKidsCountCache.put(i,1),[e,i];throw new a.FormatError("The Linearization dictionary doesn't point to a valid Page dictionary.")})).catch((r=>((0,a.info)(r),t.getPageDict(e))))}getPage(e){if(void 0!==this._pagePromises[e])return this._pagePromises[e];const{catalog:t,linearization:r}=this;if(this.xfaFactory)return Promise.resolve(new m({pdfManager:this.pdfManager,xref:this.xref,pageIndex:e,pageDict:n.Dict.empty,ref:null,globalIdFactory:this._globalIdFactory,fontCache:t.fontCache,builtInCMapCache:t.builtInCMapCache,globalImageCache:t.globalImageCache,nonBlendModesSet:t.nonBlendModesSet,xfaFactory:this.xfaFactory}));const a=r&&r.pageFirst===e?this._getLinearizationPage(e):t.getPageDict(e);return this._pagePromises[e]=a.then((([r,a])=>new m({pdfManager:this.pdfManager,xref:this.xref,pageIndex:e,pageDict:r,ref:a,globalIdFactory:this._globalIdFactory,fontCache:t.fontCache,builtInCMapCache:t.builtInCMapCache,globalImageCache:t.globalImageCache,nonBlendModesSet:t.nonBlendModesSet,xfaFactory:null})))}checkFirstPage(){return this.getPage(0).catch((async e=>{if(e instanceof s.XRefEntryException)throw this._pagePromises.length=0,await this.cleanup(),new s.XRefParseException}))}fontFallback(e,t){return this.catalog.fontFallback(e,t)}async cleanup(e=!1){return this.catalog?this.catalog.cleanup(e):(0,n.clearPrimitiveCaches)()}_collectFieldObjects(e,t,r){const i=this.xref.fetchIfRef(t);if(i.has("T")){const t=(0,a.stringToPDFString)(i.get("T"));e=""===e?t:`${e}.${t}`}if(r.has(e)||r.set(e,[]),r.get(e).push(c.AnnotationFactory.create(this.xref,t,this.pdfManager,this._localIdFactory,!0).then((e=>e&&e.getFieldObject())).catch((function(e){return(0,a.warn)(`_collectFieldObjects: "${e}".`),null}))),i.has("Kids")){const t=i.get("Kids");for(const a of t)this._collectFieldObjects(e,a,r)}}get fieldObjects(){if(!this.formInfo.hasFields)return(0,a.shadow)(this,"fieldObjects",Promise.resolve(null));const e=Object.create(null),t=new Map;for(const e of this.catalog.acroForm.get("Fields"))this._collectFieldObjects("",e,t);const r=[];for(const[a,i]of t)r.push(Promise.all(i).then((t=>{(t=t.filter((e=>!!e))).length>0&&(e[a]=t)})));return(0,a.shadow)(this,"fieldObjects",Promise.all(r).then((()=>e)))}get hasJSActions(){return(0,a.shadow)(this,"hasJSActions",this.fieldObjects.then((e=>null!==e&&Object.values(e).some((e=>e.some((e=>null!==e.actions))))||!!this.catalog.jsActions)))}get calculationOrderIds(){const e=this.catalog.acroForm;if(!e||!e.has("CO"))return(0,a.shadow)(this,"calculationOrderIds",null);const t=e.get("CO");if(!Array.isArray(t)||0===t.length)return(0,a.shadow)(this,"calculationOrderIds",null);const r=t.filter(n.isRef).map((e=>e.toString()));return 0===r.length?(0,a.shadow)(this,"calculationOrderIds",null):(0,a.shadow)(this,"calculationOrderIds",r)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XRef=t.ObjectLoader=t.FileSpec=t.Catalog=void 0;var a=r(2),i=r(5),n=r(8),s=r(11),o=r(22),c=r(23),l=r(24),h=r(25);function u(e){return(0,i.isDict)(e)?e.get("D"):e}class d{constructor(e,t){if(this.pdfManager=e,this.xref=t,this._catDict=t.getCatalogObj(),!(0,i.isDict)(this._catDict))throw new a.FormatError("Catalog object is not a dictionary.");this.fontCache=new i.RefSetCache,this.builtInCMapCache=new Map,this.globalImageCache=new l.GlobalImageCache,this.pageKidsCountCache=new i.RefSetCache,this.nonBlendModesSet=new i.RefSet}get version(){const e=this._catDict.get("Version");return(0,i.isName)(e)?(0,a.shadow)(this,"version",e.name):(0,a.shadow)(this,"version",null)}get collection(){let e=null;try{const t=this._catDict.get("Collection");(0,i.isDict)(t)&&t.size>0&&(e=t)}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("Cannot fetch Collection entry; assuming no collection is present.")}return(0,a.shadow)(this,"collection",e)}get acroForm(){let e=null;try{const t=this._catDict.get("AcroForm");(0,i.isDict)(t)&&t.size>0&&(e=t)}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("Cannot fetch AcroForm entry; assuming no forms are present.")}return(0,a.shadow)(this,"acroForm",e)}get metadata(){const e=this._catDict.getRaw("Metadata");if(!(0,i.isRef)(e))return(0,a.shadow)(this,"metadata",null);const t=!(this.xref.encrypt&&this.xref.encrypt.encryptMetadata),r=this.xref.fetch(e,t);let s=null;if((0,i.isStream)(r)&&(0,i.isDict)(r.dict)){const e=r.dict.get("Type"),t=r.dict.get("Subtype");if((0,i.isName)(e,"Metadata")&&(0,i.isName)(t,"XML"))try{const e=(0,a.stringToUTF8String)((0,a.bytesToString)(r.getBytes()));e&&(s=new h.MetadataParser(e).serializable)}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("Skipping invalid metadata.")}}return(0,a.shadow)(this,"metadata",s)}get markInfo(){let e=null;try{e=this._readMarkInfo()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read mark info.")}return(0,a.shadow)(this,"markInfo",e)}_readMarkInfo(){const e=this._catDict.get("MarkInfo");if(!(0,i.isDict)(e))return null;const t=Object.assign(Object.create(null),{Marked:!1,UserProperties:!1,Suspects:!1});for(const r in t){if(!e.has(r))continue;const i=e.get(r);(0,a.isBool)(i)&&(t[r]=i)}return t}get toplevelPagesDict(){const e=this._catDict.get("Pages");if(!(0,i.isDict)(e))throw new a.FormatError("Invalid top-level pages dictionary.");return(0,a.shadow)(this,"toplevelPagesDict",e)}get documentOutline(){let e=null;try{e=this._readDocumentOutline()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read document outline.")}return(0,a.shadow)(this,"documentOutline",e)}_readDocumentOutline(){let e=this._catDict.get("Outlines");if(!(0,i.isDict)(e))return null;if(e=e.getRaw("First"),!(0,i.isRef)(e))return null;const t={items:[]},r=[{obj:e,parent:t}],n=new i.RefSet;n.put(e);const s=this.xref,o=new Uint8ClampedArray(3);for(;r.length>0;){const t=r.shift(),l=s.fetchIfRef(t.obj);if(null===l)continue;if(!l.has("Title"))throw new a.FormatError("Invalid outline item encountered.");const h={url:null,dest:null};d.parseDestDictionary({destDict:l,resultObj:h,docBaseUrl:this.pdfManager.docBaseUrl});const u=l.get("Title"),f=l.get("F")||0,g=l.getArray("C"),p=l.get("Count");let m=o;!Array.isArray(g)||3!==g.length||0===g[0]&&0===g[1]&&0===g[2]||(m=c.ColorSpace.singletons.rgb.getRgb(g,0));const b={dest:h.dest,url:h.url,unsafeUrl:h.unsafeUrl,newWindow:h.newWindow,title:(0,a.stringToPDFString)(u),color:m,count:Number.isInteger(p)?p:void 0,bold:!!(2&f),italic:!!(1&f),items:[]};t.parent.items.push(b),e=l.getRaw("First"),(0,i.isRef)(e)&&!n.has(e)&&(r.push({obj:e,parent:b}),n.put(e)),e=l.getRaw("Next"),(0,i.isRef)(e)&&!n.has(e)&&(r.push({obj:e,parent:t.parent}),n.put(e))}return t.items.length>0?t.items:null}get permissions(){let e=null;try{e=this._readPermissions()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read permissions.")}return(0,a.shadow)(this,"permissions",e)}_readPermissions(){const e=this.xref.trailer.get("Encrypt");if(!(0,i.isDict)(e))return null;let t=e.get("P");if(!(0,a.isNum)(t))return null;t+=2**32;const r=[];for(const e in a.PermissionFlag){const i=a.PermissionFlag[e];t&i&&r.push(i)}return r}get optionalContentConfig(){let e=null;try{const t=this._catDict.get("OCProperties");if(!t)return(0,a.shadow)(this,"optionalContentConfig",null);const r=t.get("D");if(!r)return(0,a.shadow)(this,"optionalContentConfig",null);const n=t.get("OCGs");if(!Array.isArray(n))return(0,a.shadow)(this,"optionalContentConfig",null);const s=[],o=[];for(const e of n){if(!(0,i.isRef)(e))continue;o.push(e);const t=this.xref.fetchIfRef(e);s.push({id:e.toString(),name:(0,a.isString)(t.get("Name"))?(0,a.stringToPDFString)(t.get("Name")):null,intent:(0,a.isString)(t.get("Intent"))?(0,a.stringToPDFString)(t.get("Intent")):null})}e=this._readOptionalContentConfig(r,o),e.groups=s}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)(`Unable to read optional content config: ${e}`)}return(0,a.shadow)(this,"optionalContentConfig",e)}_readOptionalContentConfig(e,t){function r(e){const r=[];if(Array.isArray(e))for(const a of e)(0,i.isRef)(a)&&t.includes(a)&&r.push(a.toString());return r}function n(e,r=0){if(!Array.isArray(e))return null;const a=[];for(const n of e){if((0,i.isRef)(n)&&t.includes(n)){c.put(n),a.push(n.toString());continue}const e=s(n,r);e&&a.push(e)}if(r>0)return a;const n=[];for(const e of t)c.has(e)||n.push(e.toString());return n.length&&a.push({name:null,order:n}),a}function s(e,t){if(++t>l)return(0,a.warn)("parseNestedOrder - reached MAX_NESTED_LEVELS."),null;const r=o.fetchIfRef(e);if(!Array.isArray(r))return null;const i=o.fetchIfRef(r[0]);if("string"!=typeof i)return null;const s=n(r.slice(1),t);return s&&s.length?{name:(0,a.stringToPDFString)(i),order:s}:null}const o=this.xref,c=new i.RefSet,l=10;return{name:(0,a.isString)(e.get("Name"))?(0,a.stringToPDFString)(e.get("Name")):null,creator:(0,a.isString)(e.get("Creator"))?(0,a.stringToPDFString)(e.get("Creator")):null,baseState:(0,i.isName)(e.get("BaseState"))?e.get("BaseState").name:null,on:r(e.get("ON")),off:r(e.get("OFF")),order:n(e.get("Order")),groups:null}}get numPages(){const e=this.toplevelPagesDict.get("Count");if(!Number.isInteger(e))throw new a.FormatError("Page count in top-level pages dictionary is not an integer.");return(0,a.shadow)(this,"numPages",e)}get destinations(){const e=this._readDests(),t=Object.create(null);if(e instanceof p){const r=e.getAll();for(const e in r)t[e]=u(r[e])}else e instanceof i.Dict&&e.forEach((function(e,r){r&&(t[e]=u(r))}));return(0,a.shadow)(this,"destinations",t)}getDestination(e){const t=this._readDests();return t instanceof p||t instanceof i.Dict?u(t.get(e)||null):null}_readDests(){const e=this._catDict.get("Names");return e&&e.has("Dests")?new p(e.getRaw("Dests"),this.xref):this._catDict.has("Dests")?this._catDict.get("Dests"):void 0}get pageLabels(){let e=null;try{e=this._readPageLabels()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read page labels.")}return(0,a.shadow)(this,"pageLabels",e)}_readPageLabels(){const e=this._catDict.getRaw("PageLabels");if(!e)return null;const t=new Array(this.numPages);let r=null,s="";const o=new m(e,this.xref).getAll();let c="",l=1;for(let e=0,h=this.numPages;e<h;e++){if(e in o){const t=o[e];if(!(0,i.isDict)(t))throw new a.FormatError("PageLabel is not a dictionary.");if(t.has("Type")&&!(0,i.isName)(t.get("Type"),"PageLabel"))throw new a.FormatError("Invalid type in PageLabel dictionary.");if(t.has("S")){const e=t.get("S");if(!(0,i.isName)(e))throw new a.FormatError("Invalid style in PageLabel dictionary.");r=e.name}else r=null;if(t.has("P")){const e=t.get("P");if(!(0,a.isString)(e))throw new a.FormatError("Invalid prefix in PageLabel dictionary.");s=(0,a.stringToPDFString)(e)}else s="";if(t.has("St")){const e=t.get("St");if(!(Number.isInteger(e)&&e>=1))throw new a.FormatError("Invalid start in PageLabel dictionary.");l=e}else l=1}switch(r){case"D":c=l;break;case"R":case"r":c=(0,n.toRomanNumerals)(l,"r"===r);break;case"A":case"a":const e=26,t=65,i=97,s="a"===r?i:t,o=l-1,h=String.fromCharCode(s+o%e),u=[];for(let t=0,r=o/e|0;t<=r;t++)u.push(h);c=u.join("");break;default:if(r)throw new a.FormatError(`Invalid style "${r}" in PageLabel dictionary.`);c=""}t[e]=s+c,l++}return t}get pageLayout(){const e=this._catDict.get("PageLayout");let t="";if((0,i.isName)(e))switch(e.name){case"SinglePage":case"OneColumn":case"TwoColumnLeft":case"TwoColumnRight":case"TwoPageLeft":case"TwoPageRight":t=e.name}return(0,a.shadow)(this,"pageLayout",t)}get pageMode(){const e=this._catDict.get("PageMode");let t="UseNone";if((0,i.isName)(e))switch(e.name){case"UseNone":case"UseOutlines":case"UseThumbs":case"FullScreen":case"UseOC":case"UseAttachments":t=e.name}return(0,a.shadow)(this,"pageMode",t)}get viewerPreferences(){const e={HideToolbar:a.isBool,HideMenubar:a.isBool,HideWindowUI:a.isBool,FitWindow:a.isBool,CenterWindow:a.isBool,DisplayDocTitle:a.isBool,NonFullScreenPageMode:i.isName,Direction:i.isName,ViewArea:i.isName,ViewClip:i.isName,PrintArea:i.isName,PrintClip:i.isName,PrintScaling:i.isName,Duplex:i.isName,PickTrayByPDFSize:a.isBool,PrintPageRange:Array.isArray,NumCopies:Number.isInteger},t=this._catDict.get("ViewerPreferences");let r=null;if((0,i.isDict)(t))for(const i in e){if(!t.has(i))continue;const n=t.get(i);if(!e[i](n)){(0,a.info)(`Bad value in ViewerPreferences for "${i}".`);continue}let s;switch(i){case"NonFullScreenPageMode":switch(n.name){case"UseNone":case"UseOutlines":case"UseThumbs":case"UseOC":s=n.name;break;default:s="UseNone"}break;case"Direction":switch(n.name){case"L2R":case"R2L":s=n.name;break;default:s="L2R"}break;case"ViewArea":case"ViewClip":case"PrintArea":case"PrintClip":switch(n.name){case"MediaBox":case"CropBox":case"BleedBox":case"TrimBox":case"ArtBox":s=n.name;break;default:s="CropBox"}break;case"PrintScaling":switch(n.name){case"None":case"AppDefault":s=n.name;break;default:s="AppDefault"}break;case"Duplex":switch(n.name){case"Simplex":case"DuplexFlipShortEdge":case"DuplexFlipLongEdge":s=n.name;break;default:s="None"}break;case"PrintPageRange":if(n.length%2!=0)break;n.every(((e,t,r)=>Number.isInteger(e)&&e>0&&(0===t||e>=r[t-1])&&e<=this.numPages))&&(s=n);break;case"NumCopies":n>0&&(s=n);break;default:if("boolean"!=typeof n)throw new a.FormatError(`viewerPreferences - expected a boolean value for: ${i}`);s=n}void 0!==s?(r||(r=Object.create(null)),r[i]=s):(0,a.info)(`Bad value in ViewerPreferences for "${i}".`)}return(0,a.shadow)(this,"viewerPreferences",r)}get openAction(){const e=this._catDict.get("OpenAction"),t=Object.create(null);if((0,i.isDict)(e)){const r=new i.Dict(this.xref);r.set("A",e);const a={url:null,dest:null,action:null};d.parseDestDictionary({destDict:r,resultObj:a}),Array.isArray(a.dest)?t.dest=a.dest:a.action&&(t.action=a.action)}else Array.isArray(e)&&(t.dest=e);return(0,a.shadow)(this,"openAction",(0,a.objectSize)(t)>0?t:null)}get attachments(){const e=this._catDict.get("Names");let t=null;if(e&&e.has("EmbeddedFiles")){const r=new p(e.getRaw("EmbeddedFiles"),this.xref).getAll();for(const e in r){const i=new b(r[e],this.xref);t||(t=Object.create(null)),t[(0,a.stringToPDFString)(e)]=i.serializable}}return(0,a.shadow)(this,"attachments",t)}_collectJavaScript(){const e=this._catDict.get("Names");let t=null;function r(e,r){const n=r.get("S");if(!(0,i.isName)(n,"JavaScript"))return;let s=r.get("JS");if((0,i.isStream)(s))s=(0,a.bytesToString)(s.getBytes());else if(!(0,a.isString)(s))return;null===t&&(t=Object.create(null)),t[e]=(0,a.stringToPDFString)(s)}if(e&&e.has("JavaScript")){const t=new p(e.getRaw("JavaScript"),this.xref).getAll();for(const e in t){const a=t[e];(0,i.isDict)(a)&&r(e,a)}}const n=this._catDict.get("OpenAction");return(0,i.isDict)(n)&&(0,i.isName)(n.get("S"),"JavaScript")&&r("OpenAction",n),t}get javaScript(){const e=this._collectJavaScript();return(0,a.shadow)(this,"javaScript",e?Object.values(e):null)}get jsActions(){const e=this._collectJavaScript();let t=(0,n.collectActions)(this.xref,this._catDict,a.DocumentActionEventType);if(!t&&e&&(t=Object.create(null)),t&&e)for(const[r,a]of Object.entries(e))r in t?t[r].push(a):t[r]=[a];return(0,a.shadow)(this,"jsActions",t)}fontFallback(e,t){const r=[];return this.fontCache.forEach((function(e){r.push(e)})),Promise.all(r).then((r=>{for(const a of r)if(a.loadedName===e)return void a.fallback(t)}))}cleanup(e=!1){(0,i.clearPrimitiveCaches)(),this.globalImageCache.clear(e),this.pageKidsCountCache.clear(),this.nonBlendModesSet.clear();const t=[];return this.fontCache.forEach((function(e){t.push(e)})),Promise.all(t).then((e=>{for(const{dict:t}of e)delete t.cacheKey;this.fontCache.clear(),this.builtInCMapCache.clear()}))}getPageDict(e){const t=(0,a.createPromiseCapability)(),r=[this._catDict.getRaw("Pages")],n=new i.RefSet,s=this.xref,o=this.pageKidsCountCache;let c,l=0;return function h(){for(;r.length;){const u=r.pop();if((0,i.isRef)(u)){if(c=o.get(u),c>0&&l+c<e){l+=c;continue}return n.has(u)?void t.reject(new a.FormatError("Pages tree contains circular reference.")):(n.put(u),void s.fetchAsync(u).then((function(a){(0,i.isDict)(a,"Page")||(0,i.isDict)(a)&&!a.has("Kids")?e===l?(u&&!o.has(u)&&o.put(u,1),t.resolve([a,u])):(l++,h()):(r.push(a),h())}),t.reject))}if(!(0,i.isDict)(u))return void t.reject(new a.FormatError("Page dictionary kid reference points to wrong type of object."));if(c=u.get("Count"),Number.isInteger(c)&&c>=0){const t=u.objId;if(t&&!o.has(t)&&o.put(t,c),l+c<=e){l+=c;continue}}const d=u.get("Kids");if(!Array.isArray(d)){if((0,i.isName)(u.get("Type"),"Page")||!u.has("Type")&&u.has("Contents")){if(l===e)return void t.resolve([u,null]);l++;continue}return void t.reject(new a.FormatError("Page dictionary kids object is not an array."))}for(let e=d.length-1;e>=0;e--)r.push(d[e])}t.reject(new Error(`Page index ${e} not found.`))}(),t.promise}getPageIndex(e){const t=this.xref;let r=0;return function n(s){return function(r){let n,s=0;return t.fetchAsync(r).then((function(t){if((0,i.isRefsEqual)(r,e)&&!(0,i.isDict)(t,"Page")&&(!(0,i.isDict)(t)||t.has("Type")||!t.has("Contents")))throw new a.FormatError("The reference does not point to a /Page dictionary.");if(!t)return null;if(!(0,i.isDict)(t))throw new a.FormatError("Node must be a dictionary.");return n=t.getRaw("Parent"),t.getAsync("Parent")})).then((function(e){if(!e)return null;if(!(0,i.isDict)(e))throw new a.FormatError("Parent must be a dictionary.");return e.getAsync("Kids")})).then((function(e){if(!e)return null;const o=[];let c=!1;for(let n=0,l=e.length;n<l;n++){const l=e[n];if(!(0,i.isRef)(l))throw new a.FormatError("Kid must be a reference.");if((0,i.isRefsEqual)(l,r)){c=!0;break}o.push(t.fetchAsync(l).then((function(e){if(!(0,i.isDict)(e))throw new a.FormatError("Kid node must be a dictionary.");e.has("Count")?s+=e.get("Count"):s++})))}if(!c)throw new a.FormatError("Kid reference not found in parent's kids.");return Promise.all(o).then((function(){return[s,n]}))}))}(s).then((function(e){if(!e)return r;const[t,a]=e;return r+=t,n(a)}))}(e)}static parseDestDictionary(e){const t=e.destDict;if(!(0,i.isDict)(t))return void(0,a.warn)("parseDestDictionary: `destDict` must be a dictionary.");const r=e.resultObj;if("object"!=typeof r)return void(0,a.warn)("parseDestDictionary: `resultObj` must be an object.");const n=e.docBaseUrl||null;let s,o,c=t.get("A");if((0,i.isDict)(c)||(t.has("Dest")?c=t.get("Dest"):(c=t.get("AA"),(0,i.isDict)(c)&&(c.has("D")?c=c.get("D"):c.has("U")&&(c=c.get("U"))))),(0,i.isDict)(c)){const e=c.get("S");if(!(0,i.isName)(e))return void(0,a.warn)("parseDestDictionary: Invalid type in Action dictionary.");const t=e.name;switch(t){case"URI":s=c.get("URI"),(0,i.isName)(s)?s="/"+s.name:(0,a.isString)(s)&&(s=function(e){return e.startsWith("www.")?`http://${e}`:e}(s));break;case"GoTo":o=c.get("D");break;case"Launch":case"GoToR":const e=c.get("F");(0,i.isDict)(e)?s=e.get("F")||null:(0,a.isString)(e)&&(s=e);let n=c.get("D");if(n&&((0,i.isName)(n)&&(n=n.name),(0,a.isString)(s))){const e=s.split("#")[0];(0,a.isString)(n)?s=e+"#"+n:Array.isArray(n)&&(s=e+"#"+JSON.stringify(n))}const l=c.get("NewWindow");(0,a.isBool)(l)&&(r.newWindow=l);break;case"Named":const h=c.get("N");(0,i.isName)(h)&&(r.action=h.name);break;case"JavaScript":const u=c.get("JS");let d;if((0,i.isStream)(u)?d=(0,a.bytesToString)(u.getBytes()):(0,a.isString)(u)&&(d=u),d){const e=new RegExp("^\\s*("+["app.launchURL","window.open"].join("|").split(".").join("\\.")+")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))","i").exec((0,a.stringToPDFString)(d));if(e&&e[2]){s=e[2],"true"===e[3]&&"app.launchURL"===e[1]&&(r.newWindow=!0);break}}default:if("JavaScript"===t||"ResetForm"===t||"SubmitForm"===t)break;(0,a.warn)(`parseDestDictionary - unsupported action: "${t}".`);break}}else t.has("Dest")&&(o=t.get("Dest"));if((0,a.isString)(s)){s=function(e){try{return(0,a.stringToUTF8String)(e)}catch(t){return e}}(s);const e=(0,a.createValidAbsoluteUrl)(s,n);e&&(r.url=e.href),r.unsafeUrl=s}o&&((0,i.isName)(o)&&(o=o.name),((0,a.isString)(o)||Array.isArray(o))&&(r.dest=o))}}t.Catalog=d;var f=function(){function e(e,t){this.stream=e,this.pdfManager=t,this.entries=[],this.xrefstms=Object.create(null),this._cacheMap=new Map,this.stats={streamTypes:Object.create(null),fontTypes:Object.create(null)},this._newRefNum=null}return e.prototype={getNewRef:function(){return null===this._newRefNum&&(this._newRefNum=this.entries.length),i.Ref.get(this._newRefNum++,0)},resetNewRef:function(){this._newRefNum=null},setStartXRef:function(e){this.startXRefQueue=[e]},parse:function(e){var t;let r,s;e?((0,a.warn)("Indexing all PDF objects"),t=this.indexObjects()):t=this.readXRef(),t.assignXref(this),this.trailer=t;try{r=t.get("Encrypt")}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)(`XRef.parse - Invalid "Encrypt" reference: "${e}".`)}if((0,i.isDict)(r)){var c=t.get("ID"),l=c&&c.length?c[0]:"";r.suppressEncryption=!0,this.encrypt=new o.CipherTransformFactory(r,l,this.pdfManager.password)}try{s=t.get("Root")}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)(`XRef.parse - Invalid "Root" reference: "${e}".`)}if(!(0,i.isDict)(s)||!s.has("Pages")){if(!e)throw new n.XRefParseException;throw new a.FormatError("Invalid root reference")}this.root=s},processXRefTable:function(e){"tableState"in this||(this.tableState={entryNum:0,streamPos:e.lexer.stream.pos,parserBuf1:e.buf1,parserBuf2:e.buf2});var t=this.readXRefTable(e);if(!(0,i.isCmd)(t,"trailer"))throw new a.FormatError("Invalid XRef table: could not find trailer dictionary");var r=e.getObj();if(!(0,i.isDict)(r)&&r.dict&&(r=r.dict),!(0,i.isDict)(r))throw new a.FormatError("Invalid XRef table: could not parse trailer dictionary");return delete this.tableState,r},readXRefTable:function(e){var t,r=e.lexer.stream,n=this.tableState;for(r.pos=n.streamPos,e.buf1=n.parserBuf1,e.buf2=n.parserBuf2;;){if(!("firstEntryNum"in n)||!("entryCount"in n)){if((0,i.isCmd)(t=e.getObj(),"trailer"))break;n.firstEntryNum=t,n.entryCount=e.getObj()}var s=n.firstEntryNum,o=n.entryCount;if(!Number.isInteger(s)||!Number.isInteger(o))throw new a.FormatError("Invalid XRef table: wrong types in subsection header");for(var c=n.entryNum;c<o;c++){n.streamPos=r.pos,n.entryNum=c,n.parserBuf1=e.buf1,n.parserBuf2=e.buf2;var l={};l.offset=e.getObj(),l.gen=e.getObj();var h=e.getObj();if(h instanceof i.Cmd)switch(h.cmd){case"f":l.free=!0;break;case"n":l.uncompressed=!0;break}if(!Number.isInteger(l.offset)||!Number.isInteger(l.gen)||!l.free&&!l.uncompressed)throw new a.FormatError(`Invalid entry in XRef subsection: ${s}, ${o}`);0===c&&l.free&&1===s&&(s=0),this.entries[c+s]||(this.entries[c+s]=l)}n.entryNum=0,n.streamPos=r.pos,n.parserBuf1=e.buf1,n.parserBuf2=e.buf2,delete n.firstEntryNum,delete n.entryCount}if(this.entries[0]&&!this.entries[0].free)throw new a.FormatError("Invalid XRef table: unexpected first object");return t},processXRefStream:function(e){if(!("streamState"in this)){var t=e.dict,r=t.get("W"),a=t.get("Index");a||(a=[0,t.get("Size")]),this.streamState={entryRanges:a,byteWidths:r,entryNum:0,streamPos:e.pos}}return this.readXRefStream(e),delete this.streamState,e.dict},readXRefStream:function(e){var t,r,i=this.streamState;e.pos=i.streamPos;for(var n=i.byteWidths,s=n[0],o=n[1],c=n[2],l=i.entryRanges;l.length>0;){var h=l[0],u=l[1];if(!Number.isInteger(h)||!Number.isInteger(u))throw new a.FormatError(`Invalid XRef range fields: ${h}, ${u}`);if(!Number.isInteger(s)||!Number.isInteger(o)||!Number.isInteger(c))throw new a.FormatError(`Invalid XRef entry fields length: ${h}, ${u}`);for(t=i.entryNum;t<u;++t){i.entryNum=t,i.streamPos=e.pos;var d=0,f=0,g=0;for(r=0;r<s;++r)d=d<<8|e.getByte();for(0===s&&(d=1),r=0;r<o;++r)f=f<<8|e.getByte();for(r=0;r<c;++r)g=g<<8|e.getByte();var p={};switch(p.offset=f,p.gen=g,d){case 0:p.free=!0;break;case 1:p.uncompressed=!0;break;case 2:break;default:throw new a.FormatError(`Invalid XRef entry type: ${d}`)}this.entries[h+t]||(this.entries[h+t]=p)}i.entryNum=0,i.streamPos=e.pos,l.splice(0,2)}},indexObjects:function(){function e(e,t){for(var r="",a=e[t];10!==a&&13!==a&&60!==a&&!(++t>=e.length);)r+=String.fromCharCode(a),a=e[t];return r}function t(e,t,r){for(var a=r.length,i=e.length,n=0;t<i;){for(var s=0;s<a&&e[t+s]===r[s];)++s;if(s>=a)break;t++,n++}return n}var r=/^(\d+)\s+(\d+)\s+obj\b/;const n=/\bendobj[\b\s]$/,o=/\s+(\d+\s+\d+\s+obj[\b\s<])$/;var c=new Uint8Array([116,114,97,105,108,101,114]),l=new Uint8Array([115,116,97,114,116,120,114,101,102]);const h=new Uint8Array([111,98,106]);var u=new Uint8Array([47,88,82,101,102]);this.entries.length=0;var d=this.stream;d.pos=0;for(var f=d.getBytes(),g=d.start,p=f.length,m=[],b=[];g<p;){var y=f[g];if(9!==y&&10!==y&&13!==y&&32!==y)if(37!==y){var w,v=e(f,g);if(v.startsWith("xref")&&(4===v.length||/\s/.test(v[4])))g+=t(f,g,c),m.push(g),g+=t(f,g,l);else if(w=r.exec(v)){const e=0|w[1],r=0|w[2];this.entries[e]&&this.entries[e].gen!==r||(this.entries[e]={offset:g-d.start,gen:r,uncompressed:!0});let i,s=g+v.length;for(;s<f.length;){const e=s+t(f,s,h)+4;i=e-g;const r=Math.max(e-25,s),c=(0,a.bytesToString)(f.subarray(r,e));if(n.test(c))break;{const e=o.exec(c);if(e&&e[1]){(0,a.warn)('indexObjects: Found new "obj" inside of another "obj", caused by missing "endobj" -- trying to recover.'),i-=e[1].length;break}}s=e}const c=f.subarray(g,g+i);var S=t(c,0,u);S<i&&c[S+5]<64&&(b.push(g-d.start),this.xrefstms[g-d.start]=1),g+=i}else v.startsWith("trailer")&&(7===v.length||/\s/.test(v[7]))?(m.push(g),g+=t(f,g,l)):g+=v.length+1}else do{if(++g>=p)break;y=f[g]}while(10!==y&&13!==y);else++g}for(let e=0,t=b.length;e<t;++e)this.startXRefQueue.push(b[e]),this.readXRef(!0);let k;for(let e=0,t=m.length;e<t;++e){d.pos=m[e];const t=new s.Parser({lexer:new s.Lexer(d),xref:this,allowStreams:!0,recoveryMode:!0});var x=t.getObj();if(!(0,i.isCmd)(x,"trailer"))continue;const r=t.getObj();if((0,i.isDict)(r)){try{const e=r.get("Root");if(!(e instanceof i.Dict))continue;const t=e.get("Pages");if(!(t instanceof i.Dict))continue;const a=t.get("Count");if(!Number.isInteger(a))continue}catch(e){continue}if(r.has("ID"))return r;k=r}}if(k)return k;throw new a.InvalidPDFException("Invalid PDF structure.")},readXRef:function(e){var t=this.stream;const r=Object.create(null);try{for(;this.startXRefQueue.length;){var o=this.startXRefQueue[0];if(r[o]){(0,a.warn)("readXRef - skipping XRef table since it was already parsed."),this.startXRefQueue.shift();continue}r[o]=!0,t.pos=o+t.start;const e=new s.Parser({lexer:new s.Lexer(t),xref:this,allowStreams:!0});var c,l=e.getObj();if((0,i.isCmd)(l,"xref")){if(c=this.processXRefTable(e),this.topDict||(this.topDict=c),l=c.get("XRefStm"),Number.isInteger(l)){var h=l;h in this.xrefstms||(this.xrefstms[h]=1,this.startXRefQueue.push(h))}}else{if(!Number.isInteger(l))throw new a.FormatError("Invalid XRef stream header");if(!Number.isInteger(e.getObj())||!(0,i.isCmd)(e.getObj(),"obj")||!(0,i.isStream)(l=e.getObj()))throw new a.FormatError("Invalid XRef stream");if(c=this.processXRefStream(l),this.topDict||(this.topDict=c),!c)throw new a.FormatError("Failed to read XRef stream")}l=c.get("Prev"),Number.isInteger(l)?this.startXRefQueue.push(l):(0,i.isRef)(l)&&this.startXRefQueue.push(l.num),this.startXRefQueue.shift()}return this.topDict}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("(while reading XRef): "+e)}if(!e)throw new n.XRefParseException},getEntry:function(e){var t=this.entries[e];return t&&!t.free&&t.offset?t:null},fetchIfRef:function(e,t){return e instanceof i.Ref?this.fetch(e,t):e},fetch:function(e,t){if(!(e instanceof i.Ref))throw new Error("ref object is not a reference");const r=e.num,a=this._cacheMap.get(r);if(void 0!==a)return a instanceof i.Dict&&!a.objId&&(a.objId=e.toString()),a;let n=this.getEntry(r);return null===n?(this._cacheMap.set(r,n),n):(n=n.uncompressed?this.fetchUncompressed(e,n,t):this.fetchCompressed(e,n,t),(0,i.isDict)(n)?n.objId=e.toString():(0,i.isStream)(n)&&(n.dict.objId=e.toString()),n)},fetchUncompressed(e,t,r=!1){var a=e.gen,o=e.num;if(t.gen!==a)throw new n.XRefEntryException(`Inconsistent generation in XRef: ${e}`);var c=this.stream.makeSubStream(t.offset+this.stream.start);const l=new s.Parser({lexer:new s.Lexer(c),xref:this,allowStreams:!0});var h=l.getObj(),u=l.getObj(),d=l.getObj();if(h!==o||u!==a||!(d instanceof i.Cmd))throw new n.XRefEntryException(`Bad (uncompressed) XRef entry: ${e}`);if("obj"!==d.cmd){if(d.cmd.startsWith("obj")&&(o=parseInt(d.cmd.substring(3),10),!Number.isNaN(o)))return o;throw new n.XRefEntryException(`Bad (uncompressed) XRef entry: ${e}`)}return t=this.encrypt&&!r?l.getObj(this.encrypt.createCipherTransform(o,a)):l.getObj(),(0,i.isStream)(t)||this._cacheMap.set(o,t),t},fetchCompressed(e,t,r=!1){const o=t.offset,c=this.fetch(i.Ref.get(o,0));if(!(0,i.isStream)(c))throw new a.FormatError("bad ObjStm stream");const l=c.dict.get("First"),h=c.dict.get("N");if(!Number.isInteger(l)||!Number.isInteger(h))throw new a.FormatError("invalid first and n parameters for ObjStm stream");let u=new s.Parser({lexer:new s.Lexer(c),xref:this,allowStreams:!0});const d=new Array(h),f=new Array(h);for(let e=0;e<h;++e){const t=u.getObj();if(!Number.isInteger(t))throw new a.FormatError(`invalid object number in the ObjStm stream: ${t}`);const r=u.getObj();if(!Number.isInteger(r))throw new a.FormatError(`invalid object offset in the ObjStm stream: ${r}`);d[e]=t,f[e]=r}const g=(c.start||0)+l,p=new Array(h);for(let e=0;e<h;++e){const t=e<h-1?f[e+1]-f[e]:void 0;if(t<0)throw new a.FormatError("Invalid offset in the ObjStm stream.");u=new s.Parser({lexer:new s.Lexer(c.makeSubStream(g+f[e],t,c.dict)),xref:this,allowStreams:!0});const r=u.getObj();if(p[e]=r,(0,i.isStream)(r))continue;const n=d[e],l=this.entries[n];l&&l.offset===o&&l.gen===e&&this._cacheMap.set(n,r)}if(void 0===(t=p[t.gen]))throw new n.XRefEntryException(`Bad (compressed) XRef entry: ${e}`);return t},async fetchIfRefAsync(e,t){return e instanceof i.Ref?this.fetchAsync(e,t):e},async fetchAsync(e,t){try{return this.fetch(e,t)}catch(r){if(!(r instanceof n.MissingDataException))throw r;return await this.pdfManager.requestRange(r.begin,r.end),this.fetchAsync(e,t)}},getCatalogObj:function(){return this.root}},e}();t.XRef=f;class g{constructor(e,t,r){this.constructor===g&&(0,a.unreachable)("Cannot initialize NameOrNumberTree."),this.root=e,this.xref=t,this._type=r}getAll(){const e=Object.create(null);if(!this.root)return e;const t=this.xref,r=new i.RefSet;r.put(this.root);const n=[this.root];for(;n.length>0;){const s=t.fetchIfRef(n.shift());if(!(0,i.isDict)(s))continue;if(s.has("Kids")){const e=s.get("Kids");for(let t=0,i=e.length;t<i;t++){const i=e[t];if(r.has(i))throw new a.FormatError(`Duplicate entry in "${this._type}" tree.`);n.push(i),r.put(i)}continue}const o=s.get(this._type);if(Array.isArray(o))for(let r=0,a=o.length;r<a;r+=2)e[t.fetchIfRef(o[r])]=t.fetchIfRef(o[r+1])}return e}get(e){if(!this.root)return null;const t=this.xref;let r=t.fetchIfRef(this.root),i=0;for(;r.has("Kids");){if(++i>10)return(0,a.warn)(`Search depth limit reached for "${this._type}" tree.`),null;const n=r.get("Kids");if(!Array.isArray(n))return null;let s=0,o=n.length-1;for(;s<=o;){const a=s+o>>1,i=t.fetchIfRef(n[a]).get("Limits");if(e<t.fetchIfRef(i[0]))o=a-1;else{if(!(e>t.fetchIfRef(i[1]))){r=t.fetchIfRef(n[a]);break}s=a+1}}if(s>o)return null}const n=r.get(this._type);if(Array.isArray(n)){let r=0,i=n.length-2;for(;r<=i;){const a=r+i>>1,s=a+(1&a),o=t.fetchIfRef(n[s]);if(e<o)i=s-2;else{if(!(e>o))return t.fetchIfRef(n[s+1]);r=s+2}}(0,a.info)(`Falling back to an exhaustive search, for key "${e}", in "${this._type}" tree.`);for(let r=0,i=n.length;r<i;r+=2){if(t.fetchIfRef(n[r])===e)return(0,a.warn)(`The "${e}" key was found at an incorrect, i.e. out-of-order, position in "${this._type}" tree.`),t.fetchIfRef(n[r+1])}}return null}}class p extends g{constructor(e,t){super(e,t,"Names")}}class m extends g{constructor(e,t){super(e,t,"Nums")}}var b=function(){function e(e,t){e&&(0,i.isDict)(e)&&(this.xref=t,this.root=e,e.has("FS")&&(this.fs=e.get("FS")),this.description=e.has("Desc")?(0,a.stringToPDFString)(e.get("Desc")):"",e.has("RF")&&(0,a.warn)("Related file specifications are not supported"),this.contentAvailable=!0,e.has("EF")||(this.contentAvailable=!1,(0,a.warn)("Non-embedded file specifications are not supported")))}function t(e){return e.has("UF")?e.get("UF"):e.has("F")?e.get("F"):e.has("Unix")?e.get("Unix"):e.has("Mac")?e.get("Mac"):e.has("DOS")?e.get("DOS"):null}return e.prototype={get filename(){if(!this._filename&&this.root){var e=t(this.root)||"unnamed";this._filename=(0,a.stringToPDFString)(e).replace(/\\\\/g,"\\").replace(/\\\//g,"/").replace(/\\/g,"/")}return this._filename},get content(){if(!this.contentAvailable)return null;!this.contentRef&&this.root&&(this.contentRef=t(this.root.get("EF")));var e=null;if(this.contentRef){var r=this.xref.fetchIfRef(this.contentRef);r&&(0,i.isStream)(r)?e=r.getBytes():(0,a.warn)("Embedded file specification points to non-existing/invalid content")}else(0,a.warn)("Embedded file specification does not have a content");return e},get serializable(){return{filename:this.filename,content:this.content}}},e}();t.FileSpec=b;const y=function(){function e(e,t){if(e instanceof i.Dict)e=e.getRawValues();else if((0,i.isStream)(e))e=e.dict.getRawValues();else if(!Array.isArray(e))return;for(const a of e)((r=a)instanceof i.Ref||r instanceof i.Dict||Array.isArray(r)||(0,i.isStream)(r))&&t.push(a);var r}function t(e,t,r){this.dict=e,this.keys=t,this.xref=r,this.refSet=null}return t.prototype={async load(){if(!this.xref.stream.allChunksLoaded||this.xref.stream.allChunksLoaded())return;const{keys:e,dict:t}=this;this.refSet=new i.RefSet;const r=[];for(let a=0,i=e.length;a<i;a++){const i=t.getRaw(e[a]);void 0!==i&&r.push(i)}return this._walk(r)},async _walk(t){const r=[],s=[];for(;t.length;){let o=t.pop();if(o instanceof i.Ref){if(this.refSet.has(o))continue;try{this.refSet.put(o),o=this.xref.fetch(o)}catch(e){if(!(e instanceof n.MissingDataException)){(0,a.warn)(`ObjectLoader._walk - requesting all data: "${e}".`),this.refSet=null;const{manager:t}=this.xref.stream;return t.requestAllChunks()}r.push(o),s.push({begin:e.begin,end:e.end})}}if(o&&o.getBaseStreams){const e=o.getBaseStreams();let t=!1;for(let r=0,a=e.length;r<a;r++){const a=e[r];a.allChunksLoaded&&!a.allChunksLoaded()&&(t=!0,s.push({begin:a.start,end:a.end}))}t&&r.push(o)}e(o,t)}if(s.length){await this.xref.stream.manager.requestRanges(s);for(let e=0,t=r.length;e<t;e++){const t=r[e];t instanceof i.Ref&&this.refSet.remove(t)}return this._walk(r)}this.refSet=null}},t}();t.ObjectLoader=y},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Parser=t.Linearization=t.Lexer=void 0;var a=r(12),i=r(2),n=r(5),s=r(8),o=r(13),c=r(15),l=r(18),h=r(20);function u(e){const t=e.length;let r=1,a=0;for(let i=0;i<t;++i)r+=255&e[i],a+=r;return a%65521<<16|r%65521}class d{constructor({lexer:e,xref:t,allowStreams:r=!1,recoveryMode:a=!1}){this.lexer=e,this.xref=t,this.allowStreams=r,this.recoveryMode=a,this.imageCache=Object.create(null),this.refill()}refill(){this.buf1=this.lexer.getObj(),this.buf2=this.lexer.getObj()}shift(){this.buf2 instanceof n.Cmd&&"ID"===this.buf2.cmd?(this.buf1=this.buf2,this.buf2=null):(this.buf1=this.buf2,this.buf2=this.lexer.getObj())}tryShift(){try{return this.shift(),!0}catch(e){if(e instanceof s.MissingDataException)throw e;return!1}}getObj(e=null){const t=this.buf1;if(this.shift(),t instanceof n.Cmd)switch(t.cmd){case"BI":return this.makeInlineImage(e);case"[":const r=[];for(;!(0,n.isCmd)(this.buf1,"]")&&!(0,n.isEOF)(this.buf1);)r.push(this.getObj(e));if((0,n.isEOF)(this.buf1)){if(!this.recoveryMode)throw new i.FormatError("End of file inside array");return r}return this.shift(),r;case"<<":const a=new n.Dict(this.xref);for(;!(0,n.isCmd)(this.buf1,">>")&&!(0,n.isEOF)(this.buf1);){if(!(0,n.isName)(this.buf1)){(0,i.info)("Malformed dictionary: key must be a name object"),this.shift();continue}const t=this.buf1.name;if(this.shift(),(0,n.isEOF)(this.buf1))break;a.set(t,this.getObj(e))}if((0,n.isEOF)(this.buf1)){if(!this.recoveryMode)throw new i.FormatError("End of file inside dictionary");return a}return(0,n.isCmd)(this.buf2,"stream")?this.allowStreams?this.makeStream(a,e):a:(this.shift(),a);default:return t}if(Number.isInteger(t)){if(Number.isInteger(this.buf1)&&(0,n.isCmd)(this.buf2,"R")){const e=n.Ref.get(t,this.buf1);return this.shift(),this.shift(),e}return t}return"string"==typeof t&&e?e.decryptString(t):t}findDefaultInlineStreamEnd(e){const t=this.lexer,r=e.pos;let a,o,c=0;for(;-1!==(a=e.getByte());)if(0===c)c=69===a?1:0;else if(1===c)c=73===a?2:0;else if((0,i.assert)(2===c,"findDefaultInlineStreamEnd - invalid state."),32===a||10===a||13===a){o=e.pos;const r=e.peekBytes(10);for(let e=0,t=r.length;e<t;e++)if(a=r[e],(0!==a||0===r[e+1])&&10!==a&&13!==a&&(a<32||a>127)){c=0;break}if(2!==c)continue;if(t.knownCommands){const e=t.peekObj();e instanceof n.Cmd&&!t.knownCommands[e.cmd]&&(c=0)}else(0,i.warn)("findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.");if(2===c)break}else c=0;-1===a&&((0,i.warn)("findDefaultInlineStreamEnd: Reached the end of the stream without finding a valid EI marker"),o&&((0,i.warn)('... trying to recover by using the last "EI" occurrence.'),e.skip(-(e.pos-o))));let l=4;return e.skip(-l),a=e.peekByte(),e.skip(l),(0,s.isWhiteSpace)(a)||l--,e.pos-l-r}findDCTDecodeInlineStreamEnd(e){const t=e.pos;let r,a,n=!1;for(;-1!==(r=e.getByte());)if(255===r){switch(e.getByte()){case 0:break;case 255:e.skip(-1);break;case 217:n=!0;break;case 192:case 193:case 194:case 195:case 197:case 198:case 199:case 201:case 202:case 203:case 205:case 206:case 207:case 196:case 204:case 218:case 219:case 220:case 221:case 222:case 223:case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 254:a=e.getUint16(),a>2?e.skip(a-2):e.skip(-2);break}if(n)break}const s=e.pos-t;return-1===r?((0,i.warn)("Inline DCTDecode image stream: EOI marker not found, searching for /EI/ instead."),e.skip(-s),this.findDefaultInlineStreamEnd(e)):(this.inlineStreamSkipEI(e),s)}findASCII85DecodeInlineStreamEnd(e){const t=e.pos;let r;for(;-1!==(r=e.getByte());)if(126===r){const t=e.pos;for(r=e.peekByte();(0,s.isWhiteSpace)(r);)e.skip(),r=e.peekByte();if(62===r){e.skip();break}if(e.pos>t){const t=e.peekBytes(2);if(69===t[0]&&73===t[1])break}}const a=e.pos-t;return-1===r?((0,i.warn)("Inline ASCII85Decode image stream: EOD marker not found, searching for /EI/ instead."),e.skip(-a),this.findDefaultInlineStreamEnd(e)):(this.inlineStreamSkipEI(e),a)}findASCIIHexDecodeInlineStreamEnd(e){const t=e.pos;let r;for(;-1!==(r=e.getByte())&&62!==r;);const a=e.pos-t;return-1===r?((0,i.warn)("Inline ASCIIHexDecode image stream: EOD marker not found, searching for /EI/ instead."),e.skip(-a),this.findDefaultInlineStreamEnd(e)):(this.inlineStreamSkipEI(e),a)}inlineStreamSkipEI(e){let t,r=0;for(;-1!==(t=e.getByte());)if(0===r)r=69===t?1:0;else if(1===r)r=73===t?2:0;else if(2===r)break}makeInlineImage(e){const t=this.lexer,r=t.stream,a=new n.Dict(this.xref);let s;for(;!(0,n.isCmd)(this.buf1,"ID")&&!(0,n.isEOF)(this.buf1);){if(!(0,n.isName)(this.buf1))throw new i.FormatError("Dictionary key must be a name object");const t=this.buf1.name;if(this.shift(),(0,n.isEOF)(this.buf1))break;a.set(t,this.getObj(e))}-1!==t.beginInlineImagePos&&(s=r.pos-t.beginInlineImagePos);const o=a.get("Filter","F");let c;if((0,n.isName)(o))c=o.name;else if(Array.isArray(o)){const e=this.xref.fetchIfRef(o[0]);(0,n.isName)(e)&&(c=e.name)}const l=r.pos;let h;h="DCTDecode"===c||"DCT"===c?this.findDCTDecodeInlineStreamEnd(r):"ASCII85Decode"===c||"A85"===c?this.findASCII85DecodeInlineStreamEnd(r):"ASCIIHexDecode"===c||"AHx"===c?this.findASCIIHexDecodeInlineStreamEnd(r):this.findDefaultInlineStreamEnd(r);let d,f=r.makeSubStream(l,h,a);if(h<1e3&&s<5552){const e=f.getBytes();f.reset();const a=r.pos;r.pos=t.beginInlineImagePos;const i=r.getBytes(s);r.pos=a,d=u(e)+"_"+u(i);const o=this.imageCache[d];if(void 0!==o)return this.buf2=n.Cmd.get("EI"),this.shift(),o.reset(),o}return e&&(f=e.createStream(f,h)),f=this.filter(f,a,h),f.dict=a,void 0!==d&&(f.cacheKey=`inline_${h}_${d}`,this.imageCache[d]=f),this.buf2=n.Cmd.get("EI"),this.shift(),f}_findStreamLength(e,t){const{stream:r}=this.lexer;r.pos=e;const a=t.length;for(;r.pos<r.end;){const i=r.peekBytes(2048),n=i.length-a;if(n<=0)break;let s=0;for(;s<n;){let n=0;for(;n<a&&i[s+n]===t[n];)n++;if(n>=a)return r.pos+=s,r.pos-e;s++}r.pos+=n}return-1}makeStream(e,t){const r=this.lexer;let a=r.stream;r.skipToNextLine();const o=a.pos-1;let c=e.get("Length");if(Number.isInteger(c)||((0,i.info)(`Bad length "${c}" in stream`),c=0),a.pos=o+c,r.nextChar(),this.tryShift()&&(0,n.isCmd)(this.buf2,"endstream"))this.shift();else{const e=new Uint8Array([101,110,100,115,116,114,101,97,109]);let t=this._findStreamLength(o,e);if(t<0){const r=1;for(let n=1;n<=r;n++){const r=e.length-n,c=e.slice(0,r),l=this._findStreamLength(o,c);if(l>=0){const e=a.peekBytes(r+1)[r];if(!(0,s.isWhiteSpace)(e))break;(0,i.info)(`Found "${(0,i.bytesToString)(c)}" when searching for endstream command.`),t=l;break}}if(t<0)throw new i.FormatError("Missing endstream command.")}c=t,r.nextChar(),this.shift(),this.shift()}return this.shift(),a=a.makeSubStream(o,c,e),t&&(a=t.createStream(a,c)),a=this.filter(a,e,c),a.dict=e,a}filter(e,t,r){let a=t.get("Filter","F"),s=t.get("DecodeParms","DP");if((0,n.isName)(a))return Array.isArray(s)&&(0,i.warn)("/DecodeParms should not contain an Array, when /Filter contains a Name."),this.makeFilter(e,a.name,r,s);let o=r;if(Array.isArray(a)){const t=a,r=s;for(let c=0,l=t.length;c<l;++c){if(a=this.xref.fetchIfRef(t[c]),!(0,n.isName)(a))throw new i.FormatError(`Bad filter name "${a}"`);s=null,Array.isArray(r)&&c in r&&(s=this.xref.fetchIfRef(r[c])),e=this.makeFilter(e,a.name,o,s),o=null}}return e}makeFilter(e,t,r,n){if(0===r)return(0,i.warn)(`Empty "${t}" stream.`),new a.NullStream;try{const s=this.xref.stats.streamTypes;if("FlateDecode"===t||"Fl"===t)return s[i.StreamType.FLATE]=!0,n?new a.PredictorStream(new a.FlateStream(e,r),r,n):new a.FlateStream(e,r);if("LZWDecode"===t||"LZW"===t){s[i.StreamType.LZW]=!0;let t=1;return n?(n.has("EarlyChange")&&(t=n.get("EarlyChange")),new a.PredictorStream(new a.LZWStream(e,r,t),r,n)):new a.LZWStream(e,r,t)}return"DCTDecode"===t||"DCT"===t?(s[i.StreamType.DCT]=!0,new l.JpegStream(e,r,e.dict,n)):"JPXDecode"===t||"JPX"===t?(s[i.StreamType.JPX]=!0,new h.JpxStream(e,r,e.dict,n)):"ASCII85Decode"===t||"A85"===t?(s[i.StreamType.A85]=!0,new a.Ascii85Stream(e,r)):"ASCIIHexDecode"===t||"AHx"===t?(s[i.StreamType.AHX]=!0,new a.AsciiHexStream(e,r)):"CCITTFaxDecode"===t||"CCF"===t?(s[i.StreamType.CCF]=!0,new o.CCITTFaxStream(e,r,n)):"RunLengthDecode"===t||"RL"===t?(s[i.StreamType.RLX]=!0,new a.RunLengthStream(e,r)):"JBIG2Decode"===t?(s[i.StreamType.JBIG]=!0,new c.Jbig2Stream(e,r,e.dict,n)):((0,i.warn)(`Filter "${t}" is not supported.`),e)}catch(e){if(e instanceof s.MissingDataException)throw e;return(0,i.warn)(`Invalid stream: "${e}"`),new a.NullStream}}}t.Parser=d;const f=[1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];function g(e){return e>=48&&e<=57?15&e:e>=65&&e<=70||e>=97&&e<=102?9+(15&e):-1}class p{constructor(e,t=null){this.stream=e,this.nextChar(),this.strBuf=[],this.knownCommands=t,this._hexStringNumWarn=0,this.beginInlineImagePos=-1}nextChar(){return this.currentChar=this.stream.getByte()}peekChar(){return this.stream.peekByte()}getNumber(){let e=this.currentChar,t=!1,r=0,a=0;if(45===e?(a=-1,e=this.nextChar(),45===e&&(e=this.nextChar())):43===e&&(a=1,e=this.nextChar()),10===e||13===e)do{e=this.nextChar()}while(10===e||13===e);if(46===e&&(r=10,e=this.nextChar()),e<48||e>57){if(10===r&&0===a&&((0,s.isWhiteSpace)(e)||-1===e))return(0,i.warn)("Lexer.getNumber - treating a single decimal point as zero."),0;throw new i.FormatError(`Invalid number: ${String.fromCharCode(e)} (charCode ${e})`)}a=a||1;let n=e-48,o=0,c=1;for(;(e=this.nextChar())>=0;)if(e>=48&&e<=57){const a=e-48;t?o=10*o+a:(0!==r&&(r*=10),n=10*n+a)}else if(46===e){if(0!==r)break;r=1}else if(45===e)(0,i.warn)("Badly formatted number: minus sign in the middle");else{if(69!==e&&101!==e)break;if(e=this.peekChar(),43===e||45===e)c=45===e?-1:1,this.nextChar();else if(e<48||e>57)break;t=!0}return 0!==r&&(n/=r),t&&(n*=10**(c*o)),a*n}getString(){let e=1,t=!1;const r=this.strBuf;r.length=0;let a=this.nextChar();for(;;){let n=!1;switch(0|a){case-1:(0,i.warn)("Unterminated string"),t=!0;break;case 40:++e,r.push("(");break;case 41:0==--e?(this.nextChar(),t=!0):r.push(")");break;case 92:switch(a=this.nextChar(),a){case-1:(0,i.warn)("Unterminated string"),t=!0;break;case 110:r.push("\n");break;case 114:r.push("\r");break;case 116:r.push("\t");break;case 98:r.push("\b");break;case 102:r.push("\f");break;case 92:case 40:case 41:r.push(String.fromCharCode(a));break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:let e=15&a;a=this.nextChar(),n=!0,a>=48&&a<=55&&(e=(e<<3)+(15&a),a=this.nextChar(),a>=48&&a<=55&&(n=!1,e=(e<<3)+(15&a))),r.push(String.fromCharCode(e));break;case 13:10===this.peekChar()&&this.nextChar();break;case 10:break;default:r.push(String.fromCharCode(a));break}break;default:r.push(String.fromCharCode(a));break}if(t)break;n||(a=this.nextChar())}return r.join("")}getName(){let e,t;const r=this.strBuf;for(r.length=0;(e=this.nextChar())>=0&&!f[e];)if(35===e){if(e=this.nextChar(),f[e]){(0,i.warn)("Lexer_getName: NUMBER SIGN (#) should be followed by a hexadecimal number."),r.push("#");break}const a=g(e);if(-1!==a){t=e,e=this.nextChar();const n=g(e);if(-1===n){if((0,i.warn)(`Lexer_getName: Illegal digit (${String.fromCharCode(e)}) in hexadecimal number.`),r.push("#",String.fromCharCode(t)),f[e])break;r.push(String.fromCharCode(e));continue}r.push(String.fromCharCode(a<<4|n))}else r.push("#",String.fromCharCode(e))}else r.push(String.fromCharCode(e));return r.length>127&&(0,i.warn)(`Name token is longer than allowed by the spec: ${r.length}`),n.Name.get(r.join(""))}_hexStringWarn(e){5!=this._hexStringNumWarn++?this._hexStringNumWarn>5||(0,i.warn)(`getHexString - ignoring invalid character: ${e}`):(0,i.warn)("getHexString - ignoring additional invalid characters.")}getHexString(){const e=this.strBuf;e.length=0;let t,r,a=this.currentChar,n=!0;for(this._hexStringNumWarn=0;;){if(a<0){(0,i.warn)("Unterminated hex string");break}if(62===a){this.nextChar();break}if(1!==f[a]){if(n){if(t=g(a),-1===t){this._hexStringWarn(a),a=this.nextChar();continue}}else{if(r=g(a),-1===r){this._hexStringWarn(a),a=this.nextChar();continue}e.push(String.fromCharCode(t<<4|r))}n=!n,a=this.nextChar()}else a=this.nextChar()}return e.join("")}getObj(){let e=!1,t=this.currentChar;for(;;){if(t<0)return n.EOF;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(1!==f[t])break;t=this.nextChar()}switch(0|t){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return this.getNumber();case 40:return this.getString();case 47:return this.getName();case 91:return this.nextChar(),n.Cmd.get("[");case 93:return this.nextChar(),n.Cmd.get("]");case 60:return t=this.nextChar(),60===t?(this.nextChar(),n.Cmd.get("<<")):this.getHexString();case 62:return t=this.nextChar(),62===t?(this.nextChar(),n.Cmd.get(">>")):n.Cmd.get(">");case 123:return this.nextChar(),n.Cmd.get("{");case 125:return this.nextChar(),n.Cmd.get("}");case 41:throw this.nextChar(),new i.FormatError(`Illegal character: ${t}`)}let r=String.fromCharCode(t);const a=this.knownCommands;let s=a&&void 0!==a[r];for(;(t=this.nextChar())>=0&&!f[t];){const e=r+String.fromCharCode(t);if(s&&void 0===a[e])break;if(128===r.length)throw new i.FormatError(`Command token too long: ${r.length}`);r=e,s=a&&void 0!==a[r]}return"true"===r||"false"!==r&&("null"===r?null:("BI"===r&&(this.beginInlineImagePos=this.stream.pos),n.Cmd.get(r)))}peekObj(){const e=this.stream.pos,t=this.currentChar,r=this.beginInlineImagePos;let a;try{a=this.getObj()}catch(e){if(e instanceof s.MissingDataException)throw e;(0,i.warn)(`peekObj: ${e}`)}return this.stream.pos=e,this.currentChar=t,this.beginInlineImagePos=r,a}skipToNextLine(){let e=this.currentChar;for(;e>=0;){if(13===e){e=this.nextChar(),10===e&&this.nextChar();break}if(10===e){this.nextChar();break}e=this.nextChar()}}}t.Lexer=p;t.Linearization=class{static create(e){function t(e,t,r=!1){const a=e.get(t);if(Number.isInteger(a)&&(r?a>=0:a>0))return a;throw new Error(`The "${t}" parameter in the linearization dictionary is invalid.`)}const r=new d({lexer:new p(e),xref:null}),a=r.getObj(),s=r.getObj(),o=r.getObj(),c=r.getObj();let l,h;if(!(Number.isInteger(a)&&Number.isInteger(s)&&(0,n.isCmd)(o,"obj")&&(0,n.isDict)(c)&&(0,i.isNum)(l=c.get("Linearized"))&&l>0))return null;if((h=t(c,"L"))!==e.length)throw new Error('The "L" parameter in the linearization dictionary does not equal the stream length.');return{length:h,hints:function(e){const t=e.get("H");let r;if(Array.isArray(t)&&(2===(r=t.length)||4===r)){for(let e=0;e<r;e++){const r=t[e];if(!(Number.isInteger(r)&&r>0))throw new Error(`Hint (${e}) in the linearization dictionary is invalid.`)}return t}throw new Error("Hint array in the linearization dictionary is invalid.")}(c),objectNumberFirst:t(c,"O"),endFirst:t(c,"E"),numPages:t(c,"N"),mainXRefEntriesOffset:t(c,"T"),pageFirst:c.has("P")?t(c,"P",!0):0}}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.StringStream=t.StreamsSequenceStream=t.Stream=t.RunLengthStream=t.PredictorStream=t.NullStream=t.LZWStream=t.FlateStream=t.DecryptStream=t.DecodeStream=t.AsciiHexStream=t.Ascii85Stream=void 0;var a=r(2),i=r(5),n=r(8),s=function(){function e(e,t,r,a){this.bytes=e instanceof Uint8Array?e:new Uint8Array(e),this.start=t||0,this.pos=this.start,this.end=t+r||this.bytes.length,this.dict=a}return e.prototype={get length(){return this.end-this.start},get isEmpty(){return 0===this.length},getByte:function(){return this.pos>=this.end?-1:this.bytes[this.pos++]},getUint16:function(){var e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t},getInt32:function(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()},getBytes(e,t=!1){var r=this.bytes,a=this.pos,i=this.end;if(!e){const e=r.subarray(a,i);return t?new Uint8ClampedArray(e):e}var n=a+e;n>i&&(n=i),this.pos=n;const s=r.subarray(a,n);return t?new Uint8ClampedArray(s):s},peekByte:function(){var e=this.getByte();return-1!==e&&this.pos--,e},peekBytes(e,t=!1){var r=this.getBytes(e,t);return this.pos-=r.length,r},getByteRange(e,t){return e<0&&(e=0),t>this.end&&(t=this.end),this.bytes.subarray(e,t)},skip:function(e){e||(e=1),this.pos+=e},reset:function(){this.pos=this.start},moveStart:function(){this.start=this.pos},makeSubStream:function(t,r,a){return new e(this.bytes.buffer,t,r,a)}},e}();t.Stream=s;var o=function(){function e(e){const t=(0,a.stringToBytes)(e);s.call(this,t)}return e.prototype=s.prototype,e}();t.StringStream=o;var c=function(){var e=new Uint8Array(0);function t(t){if(this._rawMinBufferLength=t||0,this.pos=0,this.bufferLength=0,this.eof=!1,this.buffer=e,this.minBufferLength=512,t)for(;this.minBufferLength<t;)this.minBufferLength*=2}return t.prototype={get length(){(0,a.unreachable)("Should not access DecodeStream.length")},get isEmpty(){for(;!this.eof&&0===this.bufferLength;)this.readBlock();return 0===this.bufferLength},ensureBuffer:function(e){var t=this.buffer;if(e<=t.byteLength)return t;for(var r=this.minBufferLength;r<e;)r*=2;var a=new Uint8Array(r);return a.set(t),this.buffer=a},getByte:function(){for(var e=this.pos;this.bufferLength<=e;){if(this.eof)return-1;this.readBlock()}return this.buffer[this.pos++]},getUint16:function(){var e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t},getInt32:function(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()},getBytes(e,t=!1){var r,a=this.pos;if(e){for(this.ensureBuffer(a+e),r=a+e;!this.eof&&this.bufferLength<r;)this.readBlock();var i=this.bufferLength;r>i&&(r=i)}else{for(;!this.eof;)this.readBlock();r=this.bufferLength}this.pos=r;const n=this.buffer.subarray(a,r);return!t||n instanceof Uint8ClampedArray?n:new Uint8ClampedArray(n)},peekByte:function(){var e=this.getByte();return-1!==e&&this.pos--,e},peekBytes(e,t=!1){var r=this.getBytes(e,t);return this.pos-=r.length,r},makeSubStream:function(e,t,r){if(void 0===t)for(;!this.eof;)this.readBlock();else for(var a=e+t;this.bufferLength<=a&&!this.eof;)this.readBlock();return new s(this.buffer,e,t,r)},getByteRange(e,t){(0,a.unreachable)("Should not call DecodeStream.getByteRange")},skip:function(e){e||(e=1),this.pos+=e},reset:function(){this.pos=0},getBaseStreams:function(){return this.str&&this.str.getBaseStreams?this.str.getBaseStreams():[]}},t}();t.DecodeStream=c;var l=function(){function e(e){this.streams=e;let t=0;for(let r=0,a=e.length;r<a;r++){const a=e[r];t+=a instanceof c?a._rawMinBufferLength:a.length}c.call(this,t)}return e.prototype=Object.create(c.prototype),e.prototype.readBlock=function(){var e=this.streams;if(0!==e.length){var t=e.shift().getBytes(),r=this.bufferLength,a=r+t.length;this.ensureBuffer(a).set(t,r),this.bufferLength=a}else this.eof=!0},e.prototype.getBaseStreams=function(){for(var e=[],t=0,r=this.streams.length;t<r;t++){var a=this.streams[t];a.getBaseStreams&&e.push(...a.getBaseStreams())}return e},e}();t.StreamsSequenceStream=l;var h=function(){var e=new Int32Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),t=new Int32Array([3,4,5,6,7,8,9,10,65547,65549,65551,65553,131091,131095,131099,131103,196643,196651,196659,196667,262211,262227,262243,262259,327811,327843,327875,327907,258,258,258]),r=new Int32Array([1,2,3,4,65541,65543,131081,131085,196625,196633,262177,262193,327745,327777,393345,393409,459009,459137,524801,525057,590849,591361,657409,658433,724993,727041,794625,798721,868353,876545]),i=[new Int32Array([459008,524368,524304,524568,459024,524400,524336,590016,459016,524384,524320,589984,524288,524416,524352,590048,459012,524376,524312,589968,459028,524408,524344,590032,459020,524392,524328,59e4,524296,524424,524360,590064,459010,524372,524308,524572,459026,524404,524340,590024,459018,524388,524324,589992,524292,524420,524356,590056,459014,524380,524316,589976,459030,524412,524348,590040,459022,524396,524332,590008,524300,524428,524364,590072,459009,524370,524306,524570,459025,524402,524338,590020,459017,524386,524322,589988,524290,524418,524354,590052,459013,524378,524314,589972,459029,524410,524346,590036,459021,524394,524330,590004,524298,524426,524362,590068,459011,524374,524310,524574,459027,524406,524342,590028,459019,524390,524326,589996,524294,524422,524358,590060,459015,524382,524318,589980,459031,524414,524350,590044,459023,524398,524334,590012,524302,524430,524366,590076,459008,524369,524305,524569,459024,524401,524337,590018,459016,524385,524321,589986,524289,524417,524353,590050,459012,524377,524313,589970,459028,524409,524345,590034,459020,524393,524329,590002,524297,524425,524361,590066,459010,524373,524309,524573,459026,524405,524341,590026,459018,524389,524325,589994,524293,524421,524357,590058,459014,524381,524317,589978,459030,524413,524349,590042,459022,524397,524333,590010,524301,524429,524365,590074,459009,524371,524307,524571,459025,524403,524339,590022,459017,524387,524323,589990,524291,524419,524355,590054,459013,524379,524315,589974,459029,524411,524347,590038,459021,524395,524331,590006,524299,524427,524363,590070,459011,524375,524311,524575,459027,524407,524343,590030,459019,524391,524327,589998,524295,524423,524359,590062,459015,524383,524319,589982,459031,524415,524351,590046,459023,524399,524335,590014,524303,524431,524367,590078,459008,524368,524304,524568,459024,524400,524336,590017,459016,524384,524320,589985,524288,524416,524352,590049,459012,524376,524312,589969,459028,524408,524344,590033,459020,524392,524328,590001,524296,524424,524360,590065,459010,524372,524308,524572,459026,524404,524340,590025,459018,524388,524324,589993,524292,524420,524356,590057,459014,524380,524316,589977,459030,524412,524348,590041,459022,524396,524332,590009,524300,524428,524364,590073,459009,524370,524306,524570,459025,524402,524338,590021,459017,524386,524322,589989,524290,524418,524354,590053,459013,524378,524314,589973,459029,524410,524346,590037,459021,524394,524330,590005,524298,524426,524362,590069,459011,524374,524310,524574,459027,524406,524342,590029,459019,524390,524326,589997,524294,524422,524358,590061,459015,524382,524318,589981,459031,524414,524350,590045,459023,524398,524334,590013,524302,524430,524366,590077,459008,524369,524305,524569,459024,524401,524337,590019,459016,524385,524321,589987,524289,524417,524353,590051,459012,524377,524313,589971,459028,524409,524345,590035,459020,524393,524329,590003,524297,524425,524361,590067,459010,524373,524309,524573,459026,524405,524341,590027,459018,524389,524325,589995,524293,524421,524357,590059,459014,524381,524317,589979,459030,524413,524349,590043,459022,524397,524333,590011,524301,524429,524365,590075,459009,524371,524307,524571,459025,524403,524339,590023,459017,524387,524323,589991,524291,524419,524355,590055,459013,524379,524315,589975,459029,524411,524347,590039,459021,524395,524331,590007,524299,524427,524363,590071,459011,524375,524311,524575,459027,524407,524343,590031,459019,524391,524327,589999,524295,524423,524359,590063,459015,524383,524319,589983,459031,524415,524351,590047,459023,524399,524335,590015,524303,524431,524367,590079]),9],n=[new Int32Array([327680,327696,327688,327704,327684,327700,327692,327708,327682,327698,327690,327706,327686,327702,327694,0,327681,327697,327689,327705,327685,327701,327693,327709,327683,327699,327691,327707,327687,327703,327695,0]),5];function s(e,t){this.str=e,this.dict=e.dict;var r=e.getByte(),i=e.getByte();if(-1===r||-1===i)throw new a.FormatError(`Invalid header in flate stream: ${r}, ${i}`);if(8!=(15&r))throw new a.FormatError(`Unknown compression method in flate stream: ${r}, ${i}`);if(((r<<8)+i)%31!=0)throw new a.FormatError(`Bad FCHECK in flate stream: ${r}, ${i}`);if(32&i)throw new a.FormatError(`FDICT bit set in flate stream: ${r}, ${i}`);this.codeSize=0,this.codeBuf=0,c.call(this,t)}return s.prototype=Object.create(c.prototype),s.prototype.getBits=function(e){for(var t,r=this.str,i=this.codeSize,n=this.codeBuf;i<e;){if(-1===(t=r.getByte()))throw new a.FormatError("Bad encoding in flate stream");n|=t<<i,i+=8}return t=n&(1<<e)-1,this.codeBuf=n>>e,this.codeSize=i-=e,t},s.prototype.getCode=function(e){for(var t,r=this.str,i=e[0],n=e[1],s=this.codeSize,o=this.codeBuf;s<n&&-1!==(t=r.getByte());)o|=t<<s,s+=8;var c=i[o&(1<<n)-1],l=c>>16,h=65535&c;if(l<1||s<l)throw new a.FormatError("Bad encoding in flate stream");return this.codeBuf=o>>l,this.codeSize=s-l,h},s.prototype.generateHuffmanTable=function(e){var t,r=e.length,a=0;for(t=0;t<r;++t)e[t]>a&&(a=e[t]);for(var i=1<<a,n=new Int32Array(i),s=1,o=0,c=2;s<=a;++s,o<<=1,c<<=1)for(var l=0;l<r;++l)if(e[l]===s){var h=0,u=o;for(t=0;t<s;++t)h=h<<1|1&u,u>>=1;for(t=h;t<i;t+=c)n[t]=s<<16|l;++o}return[n,a]},s.prototype.readBlock=function(){var s,o,c=this.str,l=this.getBits(3);if(1&l&&(this.eof=!0),0!==(l>>=1)){var h,u;if(1===l)h=i,u=n;else{if(2!==l)throw new a.FormatError("Unknown block type in flate stream");var d,f=this.getBits(5)+257,g=this.getBits(5)+1,p=this.getBits(4)+4,m=new Uint8Array(e.length);for(d=0;d<p;++d)m[e[d]]=this.getBits(3);var b=this.generateHuffmanTable(m);o=0,d=0;for(var y,w,v,S=f+g,k=new Uint8Array(S);d<S;){var x=this.getCode(b);if(16===x)y=2,w=3,v=o;else if(17===x)y=3,w=3,v=o=0;else{if(18!==x){k[d++]=o=x;continue}y=7,w=11,v=o=0}for(var A=this.getBits(y)+w;A-- >0;)k[d++]=v}h=this.generateHuffmanTable(k.subarray(0,f)),u=this.generateHuffmanTable(k.subarray(f,S))}for(var C=(s=this.buffer)?s.length:0,O=this.bufferLength;;){var F=this.getCode(h);if(F<256)O+1>=C&&(C=(s=this.ensureBuffer(O+1)).length),s[O++]=F;else{if(256===F)return void(this.bufferLength=O);var I=(F=t[F-=257])>>16;I>0&&(I=this.getBits(I)),o=(65535&F)+I,F=this.getCode(u),(I=(F=r[F])>>16)>0&&(I=this.getBits(I));var T=(65535&F)+I;O+o>=C&&(C=(s=this.ensureBuffer(O+o)).length);for(var P=0;P<o;++P,++O)s[O]=s[O-T]}}}else{var E;if(-1===(E=c.getByte()))throw new a.FormatError("Bad block header in flate stream");var M=E;if(-1===(E=c.getByte()))throw new a.FormatError("Bad block header in flate stream");if(M|=E<<8,-1===(E=c.getByte()))throw new a.FormatError("Bad block header in flate stream");var N=E;if(-1===(E=c.getByte()))throw new a.FormatError("Bad block header in flate stream");if((N|=E<<8)!==(65535&~M)&&(0!==M||0!==N))throw new a.FormatError("Bad uncompressed block length in flate stream");this.codeBuf=0,this.codeSize=0;const e=this.bufferLength,t=e+M;if(s=this.ensureBuffer(t),this.bufferLength=t,0===M)-1===c.peekByte()&&(this.eof=!0);else{const t=c.getBytes(M);s.set(t,e),t.length<M&&(this.eof=!0)}}},s}();t.FlateStream=h;var u=function(){function e(e,t,r){if(!(0,i.isDict)(r))return e;var n=this.predictor=r.get("Predictor")||1;if(n<=1)return e;if(2!==n&&(n<10||n>15))throw new a.FormatError(`Unsupported predictor: ${n}`);this.readBlock=2===n?this.readBlockTiff:this.readBlockPng,this.str=e,this.dict=e.dict;var s=this.colors=r.get("Colors")||1,o=this.bits=r.get("BitsPerComponent")||8,l=this.columns=r.get("Columns")||1;return this.pixBytes=s*o+7>>3,this.rowBytes=l*s*o+7>>3,c.call(this,t),this}return e.prototype=Object.create(c.prototype),e.prototype.readBlockTiff=function(){var e=this.rowBytes,t=this.bufferLength,r=this.ensureBuffer(t+e),a=this.bits,i=this.colors,n=this.str.getBytes(e);if(this.eof=!n.length,!this.eof){var s,o=0,c=0,l=0,h=0,u=t;if(1===a&&1===i)for(s=0;s<e;++s){var d=n[s]^o;d^=d>>1,d^=d>>2,o=(1&(d^=d>>4))<<7,r[u++]=d}else if(8===a){for(s=0;s<i;++s)r[u++]=n[s];for(;s<e;++s)r[u]=r[u-i]+n[s],u++}else if(16===a){var f=2*i;for(s=0;s<f;++s)r[u++]=n[s];for(;s<e;s+=2){var g=((255&n[s])<<8)+(255&n[s+1])+((255&r[u-f])<<8)+(255&r[u-f+1]);r[u++]=g>>8&255,r[u++]=255&g}}else{var p=new Uint8Array(i+1),m=(1<<a)-1,b=0,y=t,w=this.columns;for(s=0;s<w;++s)for(var v=0;v<i;++v)l<a&&(o=o<<8|255&n[b++],l+=8),p[v]=p[v]+(o>>l-a)&m,l-=a,c=c<<a|p[v],(h+=a)>=8&&(r[y++]=c>>h-8&255,h-=8);h>0&&(r[y++]=(c<<8-h)+(o&(1<<8-h)-1))}this.bufferLength+=e}},e.prototype.readBlockPng=function(){var e=this.rowBytes,t=this.pixBytes,r=this.str.getByte(),i=this.str.getBytes(e);if(this.eof=!i.length,!this.eof){var n=this.bufferLength,s=this.ensureBuffer(n+e),o=s.subarray(n-e,n);0===o.length&&(o=new Uint8Array(e));var c,l,h,u=n;switch(r){case 0:for(c=0;c<e;++c)s[u++]=i[c];break;case 1:for(c=0;c<t;++c)s[u++]=i[c];for(;c<e;++c)s[u]=s[u-t]+i[c]&255,u++;break;case 2:for(c=0;c<e;++c)s[u++]=o[c]+i[c]&255;break;case 3:for(c=0;c<t;++c)s[u++]=(o[c]>>1)+i[c];for(;c<e;++c)s[u]=(o[c]+s[u-t]>>1)+i[c]&255,u++;break;case 4:for(c=0;c<t;++c)l=o[c],h=i[c],s[u++]=l+h;for(;c<e;++c){l=o[c];var d=o[c-t],f=s[u-t],g=f+l-d,p=g-f;p<0&&(p=-p);var m=g-l;m<0&&(m=-m);var b=g-d;b<0&&(b=-b),h=i[c],s[u++]=p<=m&&p<=b?f+h:m<=b?l+h:d+h}break;default:throw new a.FormatError(`Unsupported predictor: ${r}`)}this.bufferLength+=e}},e}();t.PredictorStream=u;var d=function(){function e(e,t,r){this.str=e,this.dict=e.dict,this.decrypt=r,this.nextChunk=null,this.initialized=!1,c.call(this,t)}return e.prototype=Object.create(c.prototype),e.prototype.readBlock=function(){var e;if(this.initialized?e=this.nextChunk:(e=this.str.getBytes(512),this.initialized=!0),e&&0!==e.length){this.nextChunk=this.str.getBytes(512);var t=this.nextChunk&&this.nextChunk.length>0;e=(0,this.decrypt)(e,!t);var r,a=this.bufferLength,i=e.length,n=this.ensureBuffer(a+i);for(r=0;r<i;r++)n[a++]=e[r];this.bufferLength=a}else this.eof=!0},e}();t.DecryptStream=d;var f=function(){function e(e,t){this.str=e,this.dict=e.dict,this.input=new Uint8Array(5),t&&(t*=.8),c.call(this,t)}return e.prototype=Object.create(c.prototype),e.prototype.readBlock=function(){for(var e=this.str,t=e.getByte();(0,n.isWhiteSpace)(t);)t=e.getByte();if(-1!==t&&126!==t){var r,a,i=this.bufferLength;if(122===t){for(r=this.ensureBuffer(i+4),a=0;a<4;++a)r[i+a]=0;this.bufferLength+=4}else{var s=this.input;for(s[0]=t,a=1;a<5;++a){for(t=e.getByte();(0,n.isWhiteSpace)(t);)t=e.getByte();if(s[a]=t,-1===t||126===t)break}if(r=this.ensureBuffer(i+a-1),this.bufferLength+=a-1,a<5){for(;a<5;++a)s[a]=117;this.eof=!0}var o=0;for(a=0;a<5;++a)o=85*o+(s[a]-33);for(a=3;a>=0;--a)r[i+a]=255&o,o>>=8}}else this.eof=!0},e}();t.Ascii85Stream=f;var g=function(){function e(e,t){this.str=e,this.dict=e.dict,this.firstDigit=-1,t&&(t*=.5),c.call(this,t)}return e.prototype=Object.create(c.prototype),e.prototype.readBlock=function(){var e=this.str.getBytes(8e3);if(e.length){for(var t=e.length+1>>1,r=this.ensureBuffer(this.bufferLength+t),a=this.bufferLength,i=this.firstDigit,n=0,s=e.length;n<s;n++){var o,c=e[n];if(c>=48&&c<=57)o=15&c;else{if(!(c>=65&&c<=70||c>=97&&c<=102)){if(62===c){this.eof=!0;break}continue}o=9+(15&c)}i<0?i=o:(r[a++]=i<<4|o,i=-1)}i>=0&&this.eof&&(r[a++]=i<<4,i=-1),this.firstDigit=i,this.bufferLength=a}else this.eof=!0},e}();t.AsciiHexStream=g;var p=function(){function e(e,t){this.str=e,this.dict=e.dict,c.call(this,t)}return e.prototype=Object.create(c.prototype),e.prototype.readBlock=function(){var e=this.str.getBytes(2);if(!e||e.length<2||128===e[0])this.eof=!0;else{var t,r=this.bufferLength,a=e[0];if(a<128){if((t=this.ensureBuffer(r+a+1))[r++]=e[1],a>0){var i=this.str.getBytes(a);t.set(i,r),r+=a}}else{a=257-a;var n=e[1];t=this.ensureBuffer(r+a+1);for(var s=0;s<a;s++)t[r++]=n}this.bufferLength=r}},e}();t.RunLengthStream=p;var m=function(){function e(e,t,r){this.str=e,this.dict=e.dict,this.cachedData=0,this.bitsCached=0;for(var a=4096,i={earlyChange:r,codeLength:9,nextCode:258,dictionaryValues:new Uint8Array(a),dictionaryLengths:new Uint16Array(a),dictionaryPrevCodes:new Uint16Array(a),currentSequence:new Uint8Array(a),currentSequenceLength:0},n=0;n<256;++n)i.dictionaryValues[n]=n,i.dictionaryLengths[n]=1;this.lzwState=i,c.call(this,t)}return e.prototype=Object.create(c.prototype),e.prototype.readBits=function(e){for(var t=this.bitsCached,r=this.cachedData;t<e;){var a=this.str.getByte();if(-1===a)return this.eof=!0,null;r=r<<8|a,t+=8}return this.bitsCached=t-=e,this.cachedData=r,this.lastCode=null,r>>>t&(1<<e)-1},e.prototype.readBlock=function(){var e,t,r,a=1024,i=this.lzwState;if(i){var n=i.earlyChange,s=i.nextCode,o=i.dictionaryValues,c=i.dictionaryLengths,l=i.dictionaryPrevCodes,h=i.codeLength,u=i.prevCode,d=i.currentSequence,f=i.currentSequenceLength,g=0,p=this.bufferLength,m=this.ensureBuffer(this.bufferLength+a);for(e=0;e<512;e++){var b=this.readBits(h),y=f>0;if(b<256)d[0]=b,f=1;else{if(!(b>=258)){if(256===b){h=9,s=258,f=0;continue}this.eof=!0,delete this.lzwState;break}if(b<s)for(t=(f=c[b])-1,r=b;t>=0;t--)d[t]=o[r],r=l[r];else d[f++]=d[0]}if(y&&(l[s]=u,c[s]=c[u]+1,o[s]=d[0],h=++s+n&s+n-1?h:0|Math.min(Math.log(s+n)/.6931471805599453+1,12)),u=b,a<(g+=f)){do{a+=512}while(a<g);m=this.ensureBuffer(this.bufferLength+a)}for(t=0;t<f;t++)m[p++]=d[t]}i.nextCode=s,i.codeLength=h,i.prevCode=u,i.currentSequenceLength=f,this.bufferLength=p}},e}();t.LZWStream=m;var b=function(){function e(){s.call(this,new Uint8Array(0))}return e.prototype=s.prototype,e}();t.NullStream=b},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.CCITTFaxStream=void 0;var a=r(5),i=r(14),n=r(12);const s=function(){function e(e,t,r){this.str=e,this.dict=e.dict,(0,a.isDict)(r)||(r=a.Dict.empty);const s={next:()=>e.getByte()};this.ccittFaxDecoder=new i.CCITTFaxDecoder(s,{K:r.get("K"),EndOfLine:r.get("EndOfLine"),EncodedByteAlign:r.get("EncodedByteAlign"),Columns:r.get("Columns"),Rows:r.get("Rows"),EndOfBlock:r.get("EndOfBlock"),BlackIs1:r.get("BlackIs1")}),n.DecodeStream.call(this,t)}return e.prototype=Object.create(n.DecodeStream.prototype),e.prototype.readBlock=function(){for(;!this.eof;){const e=this.ccittFaxDecoder.readNextChar();if(-1===e)return void(this.eof=!0);this.ensureBuffer(this.bufferLength+1),this.buffer[this.bufferLength++]=e}},e}();t.CCITTFaxStream=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.CCITTFaxDecoder=void 0;var a=r(2);const i=function(){const e=-1,t=[[-1,-1],[-1,-1],[7,8],[7,7],[6,6],[6,6],[6,5],[6,5],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2]],r=[[-1,-1],[12,-2],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[11,1792],[11,1792],[12,1984],[12,2048],[12,2112],[12,2176],[12,2240],[12,2304],[11,1856],[11,1856],[11,1920],[11,1920],[12,2368],[12,2432],[12,2496],[12,2560]],i=[[-1,-1],[-1,-1],[-1,-1],[-1,-1],[8,29],[8,29],[8,30],[8,30],[8,45],[8,45],[8,46],[8,46],[7,22],[7,22],[7,22],[7,22],[7,23],[7,23],[7,23],[7,23],[8,47],[8,47],[8,48],[8,48],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[7,20],[7,20],[7,20],[7,20],[8,33],[8,33],[8,34],[8,34],[8,35],[8,35],[8,36],[8,36],[8,37],[8,37],[8,38],[8,38],[7,19],[7,19],[7,19],[7,19],[8,31],[8,31],[8,32],[8,32],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[8,53],[8,53],[8,54],[8,54],[7,26],[7,26],[7,26],[7,26],[8,39],[8,39],[8,40],[8,40],[8,41],[8,41],[8,42],[8,42],[8,43],[8,43],[8,44],[8,44],[7,21],[7,21],[7,21],[7,21],[7,28],[7,28],[7,28],[7,28],[8,61],[8,61],[8,62],[8,62],[8,63],[8,63],[8,0],[8,0],[8,320],[8,320],[8,384],[8,384],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[7,27],[7,27],[7,27],[7,27],[8,59],[8,59],[8,60],[8,60],[9,1472],[9,1536],[9,1600],[9,1728],[7,18],[7,18],[7,18],[7,18],[7,24],[7,24],[7,24],[7,24],[8,49],[8,49],[8,50],[8,50],[8,51],[8,51],[8,52],[8,52],[7,25],[7,25],[7,25],[7,25],[8,55],[8,55],[8,56],[8,56],[8,57],[8,57],[8,58],[8,58],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[8,448],[8,448],[8,512],[8,512],[9,704],[9,768],[8,640],[8,640],[8,576],[8,576],[9,832],[9,896],[9,960],[9,1024],[9,1088],[9,1152],[9,1216],[9,1280],[9,1344],[9,1408],[7,256],[7,256],[7,256],[7,256],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7]],n=[[-1,-1],[-1,-1],[12,-2],[12,-2],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[11,1792],[11,1792],[11,1792],[11,1792],[12,1984],[12,1984],[12,2048],[12,2048],[12,2112],[12,2112],[12,2176],[12,2176],[12,2240],[12,2240],[12,2304],[12,2304],[11,1856],[11,1856],[11,1856],[11,1856],[11,1920],[11,1920],[11,1920],[11,1920],[12,2368],[12,2368],[12,2432],[12,2432],[12,2496],[12,2496],[12,2560],[12,2560],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[12,52],[12,52],[13,640],[13,704],[13,768],[13,832],[12,55],[12,55],[12,56],[12,56],[13,1280],[13,1344],[13,1408],[13,1472],[12,59],[12,59],[12,60],[12,60],[13,1536],[13,1600],[11,24],[11,24],[11,24],[11,24],[11,25],[11,25],[11,25],[11,25],[13,1664],[13,1728],[12,320],[12,320],[12,384],[12,384],[12,448],[12,448],[13,512],[13,576],[12,53],[12,53],[12,54],[12,54],[13,896],[13,960],[13,1024],[13,1088],[13,1152],[13,1216],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64]],s=[[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[11,23],[11,23],[12,50],[12,51],[12,44],[12,45],[12,46],[12,47],[12,57],[12,58],[12,61],[12,256],[10,16],[10,16],[10,16],[10,16],[10,17],[10,17],[10,17],[10,17],[12,48],[12,49],[12,62],[12,63],[12,30],[12,31],[12,32],[12,33],[12,40],[12,41],[11,22],[11,22],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[12,128],[12,192],[12,26],[12,27],[12,28],[12,29],[11,19],[11,19],[11,20],[11,20],[12,34],[12,35],[12,36],[12,37],[12,38],[12,39],[11,21],[11,21],[12,42],[12,43],[10,0],[10,0],[10,0],[10,0],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12]],o=[[-1,-1],[-1,-1],[-1,-1],[-1,-1],[6,9],[6,8],[5,7],[5,7],[4,6],[4,6],[4,6],[4,6],[4,5],[4,5],[4,5],[4,5],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2]];function c(e,t={}){if(!e||"function"!=typeof e.next)throw new Error('CCITTFaxDecoder - invalid "source" parameter.');this.source=e,this.eof=!1,this.encoding=t.K||0,this.eoline=t.EndOfLine||!1,this.byteAlign=t.EncodedByteAlign||!1,this.columns=t.Columns||1728,this.rows=t.Rows||0;let r,a=t.EndOfBlock;for(null==a&&(a=!0),this.eoblock=a,this.black=t.BlackIs1||!1,this.codingLine=new Uint32Array(this.columns+1),this.refLine=new Uint32Array(this.columns+2),this.codingLine[0]=this.columns,this.codingPos=0,this.row=0,this.nextLine2D=this.encoding<0,this.inputBits=0,this.inputBuf=0,this.outputBits=0,this.rowsDone=!1;0===(r=this._lookBits(12));)this._eatBits(1);1===r&&this._eatBits(12),this.encoding>0&&(this.nextLine2D=!this._lookBits(1),this._eatBits(1))}return c.prototype={readNextChar(){if(this.eof)return-1;const t=this.refLine,r=this.codingLine,i=this.columns;let n,s,o,c,l;if(0===this.outputBits){if(this.rowsDone&&(this.eof=!0),this.eof)return-1;let o,l,h;if(this.err=!1,this.nextLine2D){for(c=0;r[c]<i;++c)t[c]=r[c];for(t[c++]=i,t[c]=i,r[0]=0,this.codingPos=0,n=0,s=0;r[this.codingPos]<i;)switch(o=this._getTwoDimCode(),o){case 0:this._addPixels(t[n+1],s),t[n+1]<i&&(n+=2);break;case 1:if(o=l=0,s){do{o+=h=this._getBlackCode()}while(h>=64);do{l+=h=this._getWhiteCode()}while(h>=64)}else{do{o+=h=this._getWhiteCode()}while(h>=64);do{l+=h=this._getBlackCode()}while(h>=64)}for(this._addPixels(r[this.codingPos]+o,s),r[this.codingPos]<i&&this._addPixels(r[this.codingPos]+l,1^s);t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 7:if(this._addPixels(t[n]+3,s),s^=1,r[this.codingPos]<i)for(++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 5:if(this._addPixels(t[n]+2,s),s^=1,r[this.codingPos]<i)for(++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 3:if(this._addPixels(t[n]+1,s),s^=1,r[this.codingPos]<i)for(++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 2:if(this._addPixels(t[n],s),s^=1,r[this.codingPos]<i)for(++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 8:if(this._addPixelsNeg(t[n]-3,s),s^=1,r[this.codingPos]<i)for(n>0?--n:++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 6:if(this._addPixelsNeg(t[n]-2,s),s^=1,r[this.codingPos]<i)for(n>0?--n:++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 4:if(this._addPixelsNeg(t[n]-1,s),s^=1,r[this.codingPos]<i)for(n>0?--n:++n;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case e:this._addPixels(i,0),this.eof=!0;break;default:(0,a.info)("bad 2d code"),this._addPixels(i,0),this.err=!0}}else for(r[0]=0,this.codingPos=0,s=0;r[this.codingPos]<i;){if(o=0,s)do{o+=h=this._getBlackCode()}while(h>=64);else do{o+=h=this._getWhiteCode()}while(h>=64);this._addPixels(r[this.codingPos]+o,s),s^=1}let u=!1;if(this.byteAlign&&(this.inputBits&=-8),this.eoblock||this.row!==this.rows-1){if(o=this._lookBits(12),this.eoline)for(;o!==e&&1!==o;)this._eatBits(1),o=this._lookBits(12);else for(;0===o;)this._eatBits(1),o=this._lookBits(12);1===o?(this._eatBits(12),u=!0):o===e&&(this.eof=!0)}else this.rowsDone=!0;if(!this.eof&&this.encoding>0&&!this.rowsDone&&(this.nextLine2D=!this._lookBits(1),this._eatBits(1)),this.eoblock&&u&&this.byteAlign){if(o=this._lookBits(12),1===o){if(this._eatBits(12),this.encoding>0&&(this._lookBits(1),this._eatBits(1)),this.encoding>=0)for(c=0;c<4;++c)o=this._lookBits(12),1!==o&&(0,a.info)("bad rtc code: "+o),this._eatBits(12),this.encoding>0&&(this._lookBits(1),this._eatBits(1));this.eof=!0}}else if(this.err&&this.eoline){for(;;){if(o=this._lookBits(13),o===e)return this.eof=!0,-1;if(o>>1==1)break;this._eatBits(1)}this._eatBits(12),this.encoding>0&&(this._eatBits(1),this.nextLine2D=!(1&o))}r[0]>0?this.outputBits=r[this.codingPos=0]:this.outputBits=r[this.codingPos=1],this.row++}if(this.outputBits>=8)l=1&this.codingPos?0:255,this.outputBits-=8,0===this.outputBits&&r[this.codingPos]<i&&(this.codingPos++,this.outputBits=r[this.codingPos]-r[this.codingPos-1]);else{o=8,l=0;do{this.outputBits>o?(l<<=o,1&this.codingPos||(l|=255>>8-o),this.outputBits-=o,o=0):(l<<=this.outputBits,1&this.codingPos||(l|=255>>8-this.outputBits),o-=this.outputBits,this.outputBits=0,r[this.codingPos]<i?(this.codingPos++,this.outputBits=r[this.codingPos]-r[this.codingPos-1]):o>0&&(l<<=o,o=0))}while(o)}return this.black&&(l^=255),l},_addPixels(e,t){const r=this.codingLine;let i=this.codingPos;e>r[i]&&(e>this.columns&&((0,a.info)("row is wrong length"),this.err=!0,e=this.columns),1&i^t&&++i,r[i]=e),this.codingPos=i},_addPixelsNeg(e,t){const r=this.codingLine;let i=this.codingPos;if(e>r[i])e>this.columns&&((0,a.info)("row is wrong length"),this.err=!0,e=this.columns),1&i^t&&++i,r[i]=e;else if(e<r[i]){for(e<0&&((0,a.info)("invalid code"),this.err=!0,e=0);i>0&&e<r[i-1];)--i;r[i]=e}this.codingPos=i},_findTableCode(t,r,a,i){const n=i||0;for(let i=t;i<=r;++i){let t=this._lookBits(i);if(t===e)return[!0,1,!1];if(i<r&&(t<<=r-i),!n||t>=n){const e=a[t-n];if(e[0]===i)return this._eatBits(i),[!0,e[1],!0]}}return[!1,0,!1]},_getTwoDimCode(){let r,i=0;if(this.eoblock){if(i=this._lookBits(7),r=t[i],r&&r[0]>0)return this._eatBits(r[0]),r[1]}else{const e=this._findTableCode(1,7,t);if(e[0]&&e[2])return e[1]}return(0,a.info)("Bad two dim code"),e},_getWhiteCode(){let t,n=0;if(this.eoblock){if(n=this._lookBits(12),n===e)return 1;if(t=n>>5==0?r[n]:i[n>>3],t[0]>0)return this._eatBits(t[0]),t[1]}else{let e=this._findTableCode(1,9,i);if(e[0])return e[1];if(e=this._findTableCode(11,12,r),e[0])return e[1]}return(0,a.info)("bad white code"),this._eatBits(1),1},_getBlackCode(){let t,r;if(this.eoblock){if(t=this._lookBits(13),t===e)return 1;if(r=t>>7==0?n[t]:t>>9==0&&t>>7!=0?s[(t>>1)-64]:o[t>>7],r[0]>0)return this._eatBits(r[0]),r[1]}else{let e=this._findTableCode(2,6,o);if(e[0])return e[1];if(e=this._findTableCode(7,12,s,64),e[0])return e[1];if(e=this._findTableCode(10,13,n),e[0])return e[1]}return(0,a.info)("bad black code"),this._eatBits(1),1},_lookBits(t){let r;for(;this.inputBits<t;){if(-1===(r=this.source.next()))return 0===this.inputBits?e:this.inputBuf<<t-this.inputBits&65535>>16-t;this.inputBuf=this.inputBuf<<8|r,this.inputBits+=8}return this.inputBuf>>this.inputBits-t&65535>>16-t},_eatBits(e){(this.inputBits-=e)<0&&(this.inputBits=0)}},c}();t.CCITTFaxDecoder=i},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Jbig2Stream=void 0;var a=r(5),i=r(12),n=r(16),s=r(2);const o=function(){function e(e,t,r,a){this.stream=e,this.maybeLength=t,this.dict=r,this.params=a,i.DecodeStream.call(this,t)}return e.prototype=Object.create(i.DecodeStream.prototype),Object.defineProperty(e.prototype,"bytes",{get(){return(0,s.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0}),e.prototype.ensureBuffer=function(e){},e.prototype.readBlock=function(){if(this.eof)return;const e=new n.Jbig2Image,t=[];if((0,a.isDict)(this.params)){const e=this.params.get("JBIG2Globals");if((0,a.isStream)(e)){const r=e.getBytes();t.push({data:r,start:0,end:r.length})}}t.push({data:this.bytes,start:0,end:this.bytes.length});const r=e.parseChunks(t),i=r.length;for(let e=0;e<i;e++)r[e]^=255;this.buffer=r,this.bufferLength=i,this.eof=!0},e}();t.Jbig2Stream=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Jbig2Image=void 0;var a=r(2),i=r(8),n=r(17),s=r(14);class o extends a.BaseException{constructor(e){super(`JBIG2 error: ${e}`)}}var c=function(){function e(){}function t(e,t,r){this.data=e,this.start=t,this.end=r}function r(e,t,r){var a=e.getContexts(t),i=1;function n(e){for(var t=0,n=0;n<e;n++){var s=r.readBit(a,i);i=i<256?i<<1|s:511&(i<<1|s)|256,t=t<<1|s}return t>>>0}var s=n(1),o=n(1)?n(1)?n(1)?n(1)?n(1)?n(32)+4436:n(12)+340:n(8)+84:n(6)+20:n(4)+4:n(2);return 0===s?o:o>0?-o:null}function c(e,t,r){for(var a=e.getContexts("IAID"),i=1,n=0;n<r;n++){i=i<<1|t.readBit(a,i)}return r<31?i&(1<<r)-1:2147483647&i}e.prototype={getContexts(e){return e in this?this[e]:this[e]=new Int8Array(65536)}},t.prototype={get decoder(){var e=new n.ArithmeticDecoder(this.data,this.start,this.end);return(0,a.shadow)(this,"decoder",e)},get contextCache(){var t=new e;return(0,a.shadow)(this,"contextCache",t)}};var l=["SymbolDictionary",null,null,null,"IntermediateTextRegion",null,"ImmediateTextRegion","ImmediateLosslessTextRegion",null,null,null,null,null,null,null,null,"PatternDictionary",null,null,null,"IntermediateHalftoneRegion",null,"ImmediateHalftoneRegion","ImmediateLosslessHalftoneRegion",null,null,null,null,null,null,null,null,null,null,null,null,"IntermediateGenericRegion",null,"ImmediateGenericRegion","ImmediateLosslessGenericRegion","IntermediateGenericRefinementRegion",null,"ImmediateGenericRefinementRegion","ImmediateLosslessGenericRefinementRegion",null,null,null,null,"PageInformation","EndOfPage","EndOfStripe","EndOfFile","Profiles","Tables",null,null,null,null,null,null,null,null,"Extension"],h=[[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:2,y:-1},{x:-4,y:0},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}],[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:2,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:2,y:-1},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}],[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-2,y:0},{x:-1,y:0}],[{x:-3,y:-1},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-4,y:0},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}]],u=[{coding:[{x:0,y:-1},{x:1,y:-1},{x:-1,y:0}],reference:[{x:0,y:-1},{x:1,y:-1},{x:-1,y:0},{x:0,y:0},{x:1,y:0},{x:-1,y:1},{x:0,y:1},{x:1,y:1}]},{coding:[{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-1,y:0}],reference:[{x:0,y:-1},{x:-1,y:0},{x:0,y:0},{x:1,y:0},{x:0,y:1},{x:1,y:1}]}],d=[39717,1941,229,405],f=[32,8];function g(e,t,r,a,i,n,s,o){if(e){return M(new T(o.data,o.start,o.end),t,r,!1)}if(0===a&&!n&&!i&&4===s.length&&3===s[0].x&&-1===s[0].y&&-3===s[1].x&&-1===s[1].y&&2===s[2].x&&-2===s[2].y&&-2===s[3].x&&-2===s[3].y)return function(e,t,r){var a,i,n,s,o,c,l,h=r.decoder,u=r.contextCache.getContexts("GB"),d=[];for(i=0;i<t;i++)for(o=d[i]=new Uint8Array(e),c=i<1?o:d[i-1],a=(l=i<2?o:d[i-2])[0]<<13|l[1]<<12|l[2]<<11|c[0]<<7|c[1]<<6|c[2]<<5|c[3]<<4,n=0;n<e;n++)o[n]=s=h.readBit(u,a),a=(31735&a)<<1|(n+3<e?l[n+3]<<11:0)|(n+4<e?c[n+4]<<4:0)|s;return d}(t,r,o);var c=!!n,l=h[a].concat(s);l.sort((function(e,t){return e.y-t.y||e.x-t.x}));var u,f,g=l.length,p=new Int8Array(g),m=new Int8Array(g),b=[],y=0,w=0,v=0,S=0;for(f=0;f<g;f++)p[f]=l[f].x,m[f]=l[f].y,w=Math.min(w,l[f].x),v=Math.max(v,l[f].x),S=Math.min(S,l[f].y),f<g-1&&l[f].y===l[f+1].y&&l[f].x===l[f+1].x-1?y|=1<<g-1-f:b.push(f);var k=b.length,x=new Int8Array(k),A=new Int8Array(k),C=new Uint16Array(k);for(u=0;u<k;u++)f=b[u],x[u]=l[f].x,A[u]=l[f].y,C[u]=1<<g-1-f;for(var O,F,I,P,E,N=-w,D=-S,B=t-v,j=d[a],L=new Uint8Array(t),R=[],_=o.decoder,U=o.contextCache.getContexts("GB"),X=0,$=0,q=0;q<r;q++){if(i)if(X^=_.readBit(U,j)){R.push(L);continue}for(L=new Uint8Array(L),R.push(L),O=0;O<t;O++)if(c&&n[q][O])L[O]=0;else{if(O>=N&&O<B&&q>=D)for($=$<<1&y,f=0;f<k;f++)F=q+A[f],I=O+x[f],(P=R[F][I])&&($|=P=C[f]);else for($=0,E=g-1,f=0;f<g;f++,E--)(I=O+p[f])>=0&&I<t&&(F=q+m[f])>=0&&(P=R[F][I])&&($|=P<<E);var z=_.readBit(U,$);L[O]=z}}return R}function p(e,t,r,a,i,n,s,c,l){var h=u[r].coding;0===r&&(h=h.concat([c[0]]));var d,g=h.length,p=new Int32Array(g),m=new Int32Array(g);for(d=0;d<g;d++)p[d]=h[d].x,m[d]=h[d].y;var b=u[r].reference;0===r&&(b=b.concat([c[1]]));var y=b.length,w=new Int32Array(y),v=new Int32Array(y);for(d=0;d<y;d++)w[d]=b[d].x,v[d]=b[d].y;for(var S=a[0].length,k=a.length,x=f[r],A=[],C=l.decoder,O=l.contextCache.getContexts("GR"),F=0,I=0;I<t;I++){if(s)if(F^=C.readBit(O,x))throw new o("prediction is not supported");var T=new Uint8Array(e);A.push(T);for(var P=0;P<e;P++){var E,M,N=0;for(d=0;d<g;d++)E=I+m[d],M=P+p[d],E<0||M<0||M>=e?N<<=1:N=N<<1|A[E][M];for(d=0;d<y;d++)E=I+v[d]-n,M=P+w[d]-i,E<0||E>=k||M<0||M>=S?N<<=1:N=N<<1|a[E][M];var D=C.readBit(O,N);T[P]=D}}return A}function m(e,t,a,i,n,s,l,h,u,d,f,g,m,b,y,w,v,S,k){if(e&&t)throw new o("refinement with Huffman is not supported");var x,A,C=[];for(x=0;x<i;x++){if(A=new Uint8Array(a),n)for(var O=0;O<a;O++)A[O]=n;C.push(A)}var F=v.decoder,I=v.contextCache,T=e?-b.tableDeltaT.decode(k):-r(I,"IADT",F),P=0;for(x=0;x<s;){T+=e?b.tableDeltaT.decode(k):r(I,"IADT",F);for(var E=P+=e?b.tableFirstS.decode(k):r(I,"IAFS",F);;){let i=0;l>1&&(i=e?k.readBits(S):r(I,"IAIT",F));var M=l*T+i,N=e?b.symbolIDTable.decode(k):c(I,F,u),D=t&&(e?k.readBit():r(I,"IARI",F)),B=h[N],j=B[0].length,L=B.length;if(D){var R=r(I,"IARDW",F),_=r(I,"IARDH",F);B=p(j+=R,L+=_,y,B,(R>>1)+r(I,"IARDX",F),(_>>1)+r(I,"IARDY",F),!1,w,v)}var U,X,$,q=M-(1&g?0:L-1),z=E-(2&g?j-1:0);if(d){for(U=0;U<L;U++)if(A=C[z+U]){$=B[U];var H=Math.min(a-q,j);switch(m){case 0:for(X=0;X<H;X++)A[q+X]|=$[X];break;case 2:for(X=0;X<H;X++)A[q+X]^=$[X];break;default:throw new o(`operator ${m} is not supported`)}}E+=L-1}else{for(X=0;X<L;X++)if(A=C[q+X])switch($=B[X],m){case 0:for(U=0;U<j;U++)A[z+U]|=$[U];break;case 2:for(U=0;U<j;U++)A[z+U]^=$[U];break;default:throw new o(`operator ${m} is not supported`)}E+=j-1}x++;var G=e?b.tableDeltaS.decode(k):r(I,"IADS",F);if(null===G)break;E+=G+f}}return C}function b(e,t){var r={};r.number=(0,i.readUint32)(e,t);var a=e[t+4],n=63&a;if(!l[n])throw new o("invalid segment type: "+n);r.type=n,r.typeName=l[n],r.deferredNonRetain=!!(128&a);var s=!!(64&a),c=e[t+5],h=c>>5&7,u=[31&c],d=t+6;if(7===c){h=536870911&(0,i.readUint32)(e,d-1),d+=3;var f=h+7>>3;for(u[0]=e[d++];--f>0;)u.push(e[d++])}else if(5===c||6===c)throw new o("invalid referred-to flags");r.retainBits=u;let g=4;r.number<=256?g=1:r.number<=65536&&(g=2);var p,m,b=[];for(p=0;p<h;p++){let t;t=1===g?e[d]:2===g?(0,i.readUint16)(e,d):(0,i.readUint32)(e,d),b.push(t),d+=g}if(r.referredTo=b,s?(r.pageAssociation=(0,i.readUint32)(e,d),d+=4):r.pageAssociation=e[d++],r.length=(0,i.readUint32)(e,d),d+=4,4294967295===r.length){if(38!==n)throw new o("invalid unknown segment length");var y=w(e,d),S=!!(1&e[d+v]),k=new Uint8Array(6);for(S||(k[0]=255,k[1]=172),k[2]=y.height>>>24&255,k[3]=y.height>>16&255,k[4]=y.height>>8&255,k[5]=255&y.height,p=d,m=e.length;p<m;p++){for(var x=0;x<6&&k[x]===e[p+x];)x++;if(6===x){r.length=p+6;break}}if(4294967295===r.length)throw new o("segment end was not found")}return r.headerEnd=d,r}function y(e,t,r,a){for(var i=[],n=r;n<a;){var s=b(t,n);n=s.headerEnd;var o={header:s,data:t};if(e.randomAccess||(o.start=n,n+=s.length,o.end=n),i.push(o),51===s.type)break}if(e.randomAccess)for(var c=0,l=i.length;c<l;c++)i[c].start=n,n+=i[c].header.length,i[c].end=n;return i}function w(e,t){return{width:(0,i.readUint32)(e,t),height:(0,i.readUint32)(e,t+4),x:(0,i.readUint32)(e,t+8),y:(0,i.readUint32)(e,t+12),combinationOperator:7&e[t+16]}}var v=17;function S(e,t){var r,a,n,s,c=e.header,l=e.data,h=e.start,u=e.end;switch(c.type){case 0:var d={},f=(0,i.readUint16)(l,h);if(d.huffman=!!(1&f),d.refinement=!!(2&f),d.huffmanDHSelector=f>>2&3,d.huffmanDWSelector=f>>4&3,d.bitmapSizeSelector=f>>6&1,d.aggregationInstancesSelector=f>>7&1,d.bitmapCodingContextUsed=!!(256&f),d.bitmapCodingContextRetained=!!(512&f),d.template=f>>10&3,d.refinementTemplate=f>>12&1,h+=2,!d.huffman){for(s=0===d.template?4:1,a=[],n=0;n<s;n++)a.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)}),h+=2;d.at=a}if(d.refinement&&!d.refinementTemplate){for(a=[],n=0;n<2;n++)a.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)}),h+=2;d.refinementAt=a}d.numberOfExportedSymbols=(0,i.readUint32)(l,h),h+=4,d.numberOfNewSymbols=(0,i.readUint32)(l,h),h+=4,r=[d,c.number,c.referredTo,l,h,u];break;case 6:case 7:var g={};g.info=w(l,h),h+=v;var p=(0,i.readUint16)(l,h);if(h+=2,g.huffman=!!(1&p),g.refinement=!!(2&p),g.logStripSize=p>>2&3,g.stripSize=1<<g.logStripSize,g.referenceCorner=p>>4&3,g.transposed=!!(64&p),g.combinationOperator=p>>7&3,g.defaultPixelValue=p>>9&1,g.dsOffset=p<<17>>27,g.refinementTemplate=p>>15&1,g.huffman){var m=(0,i.readUint16)(l,h);h+=2,g.huffmanFS=3&m,g.huffmanDS=m>>2&3,g.huffmanDT=m>>4&3,g.huffmanRefinementDW=m>>6&3,g.huffmanRefinementDH=m>>8&3,g.huffmanRefinementDX=m>>10&3,g.huffmanRefinementDY=m>>12&3,g.huffmanRefinementSizeSelector=!!(16384&m)}if(g.refinement&&!g.refinementTemplate){for(a=[],n=0;n<2;n++)a.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)}),h+=2;g.refinementAt=a}g.numberOfSymbolInstances=(0,i.readUint32)(l,h),h+=4,r=[g,c.referredTo,l,h,u];break;case 16:const e={},t=l[h++];e.mmr=!!(1&t),e.template=t>>1&3,e.patternWidth=l[h++],e.patternHeight=l[h++],e.maxPatternIndex=(0,i.readUint32)(l,h),h+=4,r=[e,c.number,l,h,u];break;case 22:case 23:const x={};x.info=w(l,h),h+=v;const A=l[h++];x.mmr=!!(1&A),x.template=A>>1&3,x.enableSkip=!!(8&A),x.combinationOperator=A>>4&7,x.defaultPixelValue=A>>7&1,x.gridWidth=(0,i.readUint32)(l,h),h+=4,x.gridHeight=(0,i.readUint32)(l,h),h+=4,x.gridOffsetX=4294967295&(0,i.readUint32)(l,h),h+=4,x.gridOffsetY=4294967295&(0,i.readUint32)(l,h),h+=4,x.gridVectorX=(0,i.readUint16)(l,h),h+=2,x.gridVectorY=(0,i.readUint16)(l,h),h+=2,r=[x,c.referredTo,l,h,u];break;case 38:case 39:var b={};b.info=w(l,h),h+=v;var y=l[h++];if(b.mmr=!!(1&y),b.template=y>>1&3,b.prediction=!!(8&y),!b.mmr){for(s=0===b.template?4:1,a=[],n=0;n<s;n++)a.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)}),h+=2;b.at=a}r=[b,l,h,u];break;case 48:var S={width:(0,i.readUint32)(l,h),height:(0,i.readUint32)(l,h+4),resolutionX:(0,i.readUint32)(l,h+8),resolutionY:(0,i.readUint32)(l,h+12)};4294967295===S.height&&delete S.height;var k=l[h+16];(0,i.readUint16)(l,h+17),S.lossless=!!(1&k),S.refinement=!!(2&k),S.defaultPixelValue=k>>2&1,S.combinationOperator=k>>3&3,S.requiresBuffer=!!(32&k),S.combinationOperatorOverride=!!(64&k),r=[S];break;case 49:break;case 50:break;case 51:break;case 53:r=[c.number,l,h,u];break;case 62:break;default:throw new o(`segment type ${c.typeName}(${c.type}) is not implemented`)}var x="on"+c.typeName;x in t&&t[x].apply(t,r)}function k(e,t){for(var r=0,a=e.length;r<a;r++)S(e[r],t)}function x(){}function A(e){2===e.length?(this.isOOB=!0,this.rangeLow=0,this.prefixLength=e[0],this.rangeLength=0,this.prefixCode=e[1],this.isLowerRange=!1):(this.isOOB=!1,this.rangeLow=e[0],this.prefixLength=e[1],this.rangeLength=e[2],this.prefixCode=e[3],this.isLowerRange="lower"===e[4])}function C(e){this.children=[],e?(this.isLeaf=!0,this.rangeLength=e.rangeLength,this.rangeLow=e.rangeLow,this.isLowerRange=e.isLowerRange,this.isOOB=e.isOOB):this.isLeaf=!1}function O(e,t){t||this.assignPrefixCodes(e),this.rootNode=new C(null);for(let t=0,r=e.length;t<r;t++){const r=e[t];r.prefixLength>0&&this.rootNode.buildTree(r,r.prefixLength-1)}}x.prototype={onPageInformation:function(e){this.currentPageInfo=e;var t=e.width+7>>3,r=new Uint8ClampedArray(t*e.height);if(e.defaultPixelValue)for(var a=0,i=r.length;a<i;a++)r[a]=255;this.buffer=r},drawBitmap:function(e,t){var r,a,i,n,s=this.currentPageInfo,c=e.width,l=e.height,h=s.width+7>>3,u=s.combinationOperatorOverride?e.combinationOperator:s.combinationOperator,d=this.buffer,f=128>>(7&e.x),g=e.y*h+(e.x>>3);switch(u){case 0:for(r=0;r<l;r++){for(i=f,n=g,a=0;a<c;a++)t[r][a]&&(d[n]|=i),(i>>=1)||(i=128,n++);g+=h}break;case 2:for(r=0;r<l;r++){for(i=f,n=g,a=0;a<c;a++)t[r][a]&&(d[n]^=i),(i>>=1)||(i=128,n++);g+=h}break;default:throw new o(`operator ${u} is not supported`)}},onImmediateGenericRegion:function(e,r,a,i){var n=e.info,s=new t(r,a,i),o=g(e.mmr,n.width,n.height,e.template,e.prediction,null,e.at,s);this.drawBitmap(n,o)},onImmediateLosslessGenericRegion:function(){this.onImmediateGenericRegion.apply(this,arguments)},onSymbolDictionary:function(e,a,n,s,l,h){let u,d;e.huffman&&(u=function(e,t,r){let a,i,n,s,c=0;switch(e.huffmanDHSelector){case 0:case 1:a=I(e.huffmanDHSelector+4);break;case 3:a=P(c,t,r),c++;break;default:throw new o("invalid Huffman DH selector")}switch(e.huffmanDWSelector){case 0:case 1:i=I(e.huffmanDWSelector+2);break;case 3:i=P(c,t,r),c++;break;default:throw new o("invalid Huffman DW selector")}e.bitmapSizeSelector?(n=P(c,t,r),c++):n=I(1);s=e.aggregationInstancesSelector?P(c,t,r):I(1);return{tableDeltaHeight:a,tableDeltaWidth:i,tableBitmapSize:n,tableAggregateInstances:s}}(e,n,this.customTables),d=new T(s,l,h));var f=this.symbols;f||(this.symbols=f={});for(var b=[],y=0,w=n.length;y<w;y++){const e=f[n[y]];e&&(b=b.concat(e))}var v=new t(s,l,h);f[a]=function(e,t,a,n,s,l,h,u,d,f,b,y){if(e&&t)throw new o("symbol refinement with Huffman is not supported");var w=[],v=0,S=(0,i.log2)(a.length+n),k=b.decoder,x=b.contextCache;let A,C;for(e&&(A=I(1),C=[],S=Math.max(S,1));w.length<n;){v+=e?l.tableDeltaHeight.decode(y):r(x,"IADH",k);let i=0,n=0;const s=e?C.length:0;for(;;){var O,F=e?l.tableDeltaWidth.decode(y):r(x,"IADW",k);if(null===F)break;if(i+=F,n+=i,t){var T=r(x,"IAAI",k);if(T>1)O=m(e,t,i,v,0,T,1,a.concat(w),S,0,0,1,0,l,d,f,b,0,y);else{var P=c(x,k,S),N=r(x,"IARDX",k),D=r(x,"IARDY",k);O=p(i,v,d,P<a.length?a[P]:w[P-a.length],N,D,!1,f,b)}w.push(O)}else e?C.push(i):(O=g(!1,i,v,h,!1,null,u,b),w.push(O))}if(e&&!t){const e=l.tableBitmapSize.decode(y);let t;if(y.byteAlign(),0===e)t=E(y,n,v);else{const r=y.end,a=y.position+e;y.end=a,t=M(y,n,v,!1),y.end=r,y.position=a}const r=C.length;if(s===r-1)w.push(t);else{let e,a,i,n,o,c=0;for(e=s;e<r;e++){for(n=C[e],i=c+n,o=[],a=0;a<v;a++)o.push(t[a].subarray(c,i));w.push(o),c=i}}}}for(var B=[],j=[],L=!1,R=a.length+n;j.length<R;){for(var _=e?A.decode(y):r(x,"IAEX",k);_--;)j.push(L);L=!L}for(var U=0,X=a.length;U<X;U++)j[U]&&B.push(a[U]);for(var $=0;$<n;U++,$++)j[U]&&B.push(w[$]);return B}(e.huffman,e.refinement,b,e.numberOfNewSymbols,e.numberOfExportedSymbols,u,e.template,e.at,e.refinementTemplate,e.refinementAt,v,d)},onImmediateTextRegion:function(e,r,a,n,s){var c=e.info;let l,h;for(var u=this.symbols,d=[],f=0,g=r.length;f<g;f++){const e=u[r[f]];e&&(d=d.concat(e))}var p=(0,i.log2)(d.length);e.huffman&&(h=new T(a,n,s),l=function(e,t,r,a,i){const n=[];for(let e=0;e<=34;e++){const t=i.readBits(4);n.push(new A([e,t,0,0]))}const s=new O(n,!1);n.length=0;for(let e=0;e<a;){const t=s.decode(i);if(t>=32){let r,a,s;switch(t){case 32:if(0===e)throw new o("no previous value in symbol ID table");a=i.readBits(2)+3,r=n[e-1].prefixLength;break;case 33:a=i.readBits(3)+3,r=0;break;case 34:a=i.readBits(7)+11,r=0;break;default:throw new o("invalid code length in symbol ID table")}for(s=0;s<a;s++)n.push(new A([e,r,0,0])),e++}else n.push(new A([e,t,0,0])),e++}i.byteAlign();const c=new O(n,!1);let l,h,u,d=0;switch(e.huffmanFS){case 0:case 1:l=I(e.huffmanFS+6);break;case 3:l=P(d,t,r),d++;break;default:throw new o("invalid Huffman FS selector")}switch(e.huffmanDS){case 0:case 1:case 2:h=I(e.huffmanDS+8);break;case 3:h=P(d,t,r),d++;break;default:throw new o("invalid Huffman DS selector")}switch(e.huffmanDT){case 0:case 1:case 2:u=I(e.huffmanDT+11);break;case 3:u=P(d,t,r),d++;break;default:throw new o("invalid Huffman DT selector")}if(e.refinement)throw new o("refinement with Huffman is not supported");return{symbolIDTable:c,tableFirstS:l,tableDeltaS:h,tableDeltaT:u}}(e,r,this.customTables,d.length,h));var b=new t(a,n,s),y=m(e.huffman,e.refinement,c.width,c.height,e.defaultPixelValue,e.numberOfSymbolInstances,e.stripSize,d,p,e.transposed,e.dsOffset,e.referenceCorner,e.combinationOperator,l,e.refinementTemplate,e.refinementAt,b,e.logStripSize,h);this.drawBitmap(c,y)},onImmediateLosslessTextRegion:function(){this.onImmediateTextRegion.apply(this,arguments)},onPatternDictionary(e,r,a,i,n){let s=this.patterns;s||(this.patterns=s={});const o=new t(a,i,n);s[r]=function(e,t,r,a,i,n){const s=[];e||(s.push({x:-t,y:0}),0===i&&(s.push({x:-3,y:-1}),s.push({x:2,y:-2}),s.push({x:-2,y:-2})));const o=g(e,(a+1)*t,r,i,!1,null,s,n),c=[];for(let e=0;e<=a;e++){const a=[],i=t*e,n=i+t;for(let e=0;e<r;e++)a.push(o[e].subarray(i,n));c.push(a)}return c}(e.mmr,e.patternWidth,e.patternHeight,e.maxPatternIndex,e.template,o)},onImmediateHalftoneRegion(e,r,a,n,s){const c=this.patterns[r[0]],l=e.info,h=new t(a,n,s),u=function(e,t,r,a,n,s,c,l,h,u,d,f,p,m,b){if(c)throw new o("skip is not supported");if(0!==l)throw new o("operator "+l+" is not supported in halftone region");const y=[];let w,v,S;for(w=0;w<n;w++){if(S=new Uint8Array(a),s)for(v=0;v<a;v++)S[v]=s;y.push(S)}const k=t.length,x=t[0],A=x[0].length,C=x.length,O=(0,i.log2)(k),F=[];e||(F.push({x:r<=1?3:2,y:-1}),0===r&&(F.push({x:-3,y:-1}),F.push({x:2,y:-2}),F.push({x:-2,y:-2})));const I=[];let P,E,N,D,B,j,L,R,_,U,X;for(e&&(P=new T(b.data,b.start,b.end)),w=O-1;w>=0;w--)E=e?M(P,h,u,!0):g(!1,h,u,r,!1,null,F,b),I[w]=E;for(N=0;N<u;N++)for(D=0;D<h;D++){for(B=0,j=0,v=O-1;v>=0;v--)B=I[v][N][D]^B,j|=B<<v;if(L=t[j],R=d+N*m+D*p>>8,_=f+N*p-D*m>>8,R>=0&&R+A<=a&&_>=0&&_+C<=n)for(w=0;w<C;w++)for(X=y[_+w],U=L[w],v=0;v<A;v++)X[R+v]|=U[v];else{let e,t;for(w=0;w<C;w++)if(t=_+w,!(t<0||t>=n))for(X=y[t],U=L[w],v=0;v<A;v++)e=R+v,e>=0&&e<a&&(X[e]|=U[v])}}return y}(e.mmr,c,e.template,l.width,l.height,e.defaultPixelValue,e.enableSkip,e.combinationOperator,e.gridWidth,e.gridHeight,e.gridOffsetX,e.gridOffsetY,e.gridVectorX,e.gridVectorY,h);this.drawBitmap(l,u)},onImmediateLosslessHalftoneRegion(){this.onImmediateHalftoneRegion.apply(this,arguments)},onTables(e,t,r,a){let n=this.customTables;n||(this.customTables=n={}),n[e]=function(e,t,r){const a=e[t],n=4294967295&(0,i.readUint32)(e,t+1),s=4294967295&(0,i.readUint32)(e,t+5),o=new T(e,t+9,r),c=1+(a>>1&7),l=1+(a>>4&7),h=[];let u,d,f=n;do{u=o.readBits(c),d=o.readBits(l),h.push(new A([f,u,d,0])),f+=1<<d}while(f<s);u=o.readBits(c),h.push(new A([n-1,u,32,0,"lower"])),u=o.readBits(c),h.push(new A([s,u,32,0])),1&a&&(u=o.readBits(c),h.push(new A([u,0])));return new O(h,!1)}(t,r,a)}},C.prototype={buildTree(e,t){const r=e.prefixCode>>t&1;if(t<=0)this.children[r]=new C(e);else{let a=this.children[r];a||(this.children[r]=a=new C(null)),a.buildTree(e,t-1)}},decodeNode(e){if(this.isLeaf){if(this.isOOB)return null;const t=e.readBits(this.rangeLength);return this.rangeLow+(this.isLowerRange?-t:t)}const t=this.children[e.readBit()];if(!t)throw new o("invalid Huffman data");return t.decodeNode(e)}},O.prototype={decode(e){return this.rootNode.decodeNode(e)},assignPrefixCodes(e){const t=e.length;let r=0;for(let a=0;a<t;a++)r=Math.max(r,e[a].prefixLength);const a=new Uint32Array(r+1);for(let r=0;r<t;r++)a[e[r].prefixLength]++;let i,n,s,o=1,c=0;for(a[0]=0;o<=r;){for(c=c+a[o-1]<<1,i=c,n=0;n<t;)s=e[n],s.prefixLength===o&&(s.prefixCode=i,i++),n++;o++}}};const F={};function I(e){let t,r=F[e];if(r)return r;switch(e){case 1:t=[[0,1,4,0],[16,2,8,2],[272,3,16,6],[65808,3,32,7]];break;case 2:t=[[0,1,0,0],[1,2,0,2],[2,3,0,6],[3,4,3,14],[11,5,6,30],[75,6,32,62],[6,63]];break;case 3:t=[[-256,8,8,254],[0,1,0,0],[1,2,0,2],[2,3,0,6],[3,4,3,14],[11,5,6,30],[-257,8,32,255,"lower"],[75,7,32,126],[6,62]];break;case 4:t=[[1,1,0,0],[2,2,0,2],[3,3,0,6],[4,4,3,14],[12,5,6,30],[76,5,32,31]];break;case 5:t=[[-255,7,8,126],[1,1,0,0],[2,2,0,2],[3,3,0,6],[4,4,3,14],[12,5,6,30],[-256,7,32,127,"lower"],[76,6,32,62]];break;case 6:t=[[-2048,5,10,28],[-1024,4,9,8],[-512,4,8,9],[-256,4,7,10],[-128,5,6,29],[-64,5,5,30],[-32,4,5,11],[0,2,7,0],[128,3,7,2],[256,3,8,3],[512,4,9,12],[1024,4,10,13],[-2049,6,32,62,"lower"],[2048,6,32,63]];break;case 7:t=[[-1024,4,9,8],[-512,3,8,0],[-256,4,7,9],[-128,5,6,26],[-64,5,5,27],[-32,4,5,10],[0,4,5,11],[32,5,5,28],[64,5,6,29],[128,4,7,12],[256,3,8,1],[512,3,9,2],[1024,3,10,3],[-1025,5,32,30,"lower"],[2048,5,32,31]];break;case 8:t=[[-15,8,3,252],[-7,9,1,508],[-5,8,1,253],[-3,9,0,509],[-2,7,0,124],[-1,4,0,10],[0,2,1,0],[2,5,0,26],[3,6,0,58],[4,3,4,4],[20,6,1,59],[22,4,4,11],[38,4,5,12],[70,5,6,27],[134,5,7,28],[262,6,7,60],[390,7,8,125],[646,6,10,61],[-16,9,32,510,"lower"],[1670,9,32,511],[2,1]];break;case 9:t=[[-31,8,4,252],[-15,9,2,508],[-11,8,2,253],[-7,9,1,509],[-5,7,1,124],[-3,4,1,10],[-1,3,1,2],[1,3,1,3],[3,5,1,26],[5,6,1,58],[7,3,5,4],[39,6,2,59],[43,4,5,11],[75,4,6,12],[139,5,7,27],[267,5,8,28],[523,6,8,60],[779,7,9,125],[1291,6,11,61],[-32,9,32,510,"lower"],[3339,9,32,511],[2,0]];break;case 10:t=[[-21,7,4,122],[-5,8,0,252],[-4,7,0,123],[-3,5,0,24],[-2,2,2,0],[2,5,0,25],[3,6,0,54],[4,7,0,124],[5,8,0,253],[6,2,6,1],[70,5,5,26],[102,6,5,55],[134,6,6,56],[198,6,7,57],[326,6,8,58],[582,6,9,59],[1094,6,10,60],[2118,7,11,125],[-22,8,32,254,"lower"],[4166,8,32,255],[2,2]];break;case 11:t=[[1,1,0,0],[2,2,1,2],[4,4,0,12],[5,4,1,13],[7,5,1,28],[9,5,2,29],[13,6,2,60],[17,7,2,122],[21,7,3,123],[29,7,4,124],[45,7,5,125],[77,7,6,126],[141,7,32,127]];break;case 12:t=[[1,1,0,0],[2,2,0,2],[3,3,1,6],[5,5,0,28],[6,5,1,29],[8,6,1,60],[10,7,0,122],[11,7,1,123],[13,7,2,124],[17,7,3,125],[25,7,4,126],[41,8,5,254],[73,8,32,255]];break;case 13:t=[[1,1,0,0],[2,3,0,4],[3,4,0,12],[4,5,0,28],[5,4,1,13],[7,3,3,5],[15,6,1,58],[17,6,2,59],[21,6,3,60],[29,6,4,61],[45,6,5,62],[77,7,6,126],[141,7,32,127]];break;case 14:t=[[-2,3,0,4],[-1,3,0,5],[0,1,0,0],[1,3,0,6],[2,3,0,7]];break;case 15:t=[[-24,7,4,124],[-8,6,2,60],[-4,5,1,28],[-2,4,0,12],[-1,3,0,4],[0,1,0,0],[1,3,0,5],[2,4,0,13],[3,5,1,29],[5,6,2,61],[9,7,4,125],[-25,7,32,126,"lower"],[25,7,32,127]];break;default:throw new o(`standard table B.${e} does not exist`)}for(let e=0,r=t.length;e<r;e++)t[e]=new A(t[e]);return r=new O(t,!0),F[e]=r,r}function T(e,t,r){this.data=e,this.start=t,this.end=r,this.position=t,this.shift=-1,this.currentByte=0}function P(e,t,r){let a=0;for(let i=0,n=t.length;i<n;i++){const n=r[t[i]];if(n){if(e===a)return n;a++}}throw new o("can't find custom Huffman table")}function E(e,t,r){const a=[];for(let i=0;i<r;i++){const r=new Uint8Array(t);a.push(r);for(let a=0;a<t;a++)r[a]=e.readBit();e.byteAlign()}return a}function M(e,t,r,a){const i={K:-1,Columns:t,Rows:r,BlackIs1:!0,EndOfBlock:a},n=new s.CCITTFaxDecoder(e,i),o=[];let c,l=!1;for(let e=0;e<r;e++){const e=new Uint8Array(t);o.push(e);let r=-1;for(let a=0;a<t;a++)r<0&&(c=n.readNextChar(),-1===c&&(c=0,l=!0),r=7),e[a]=c>>r&1,r--}if(a&&!l){const e=5;for(let t=0;t<e&&-1!==n.readNextChar();t++);}return o}function N(){}return T.prototype={readBit(){if(this.shift<0){if(this.position>=this.end)throw new o("end of data while reading bit");this.currentByte=this.data[this.position++],this.shift=7}const e=this.currentByte>>this.shift&1;return this.shift--,e},readBits(e){let t,r=0;for(t=e-1;t>=0;t--)r|=this.readBit()<<t;return r},byteAlign(){this.shift=-1},next(){return this.position>=this.end?-1:this.data[this.position++]}},N.prototype={parseChunks:e=>function(e){for(var t=new x,r=0,a=e.length;r<a;r++){var i=e[r];k(y({},i.data,i.start,i.end),t)}return t.buffer}(e),parse(e){const{imgData:t,width:r,height:a}=function(e){const t=e.length;let r=0;if(151!==e[r]||74!==e[r+1]||66!==e[r+2]||50!==e[r+3]||13!==e[r+4]||10!==e[r+5]||26!==e[r+6]||10!==e[r+7])throw new o("parseJbig2 - invalid header.");const a=Object.create(null);r+=8;const n=e[r++];a.randomAccess=!(1&n),2&n||(a.numberOfPages=(0,i.readUint32)(e,r),r+=4);const s=y(a,e,r,t),c=new x;k(s,c);const{width:l,height:h}=c.currentPageInfo,u=c.buffer,d=new Uint8ClampedArray(l*h);let f=0,g=0;for(let e=0;e<h;e++){let e,t=0;for(let r=0;r<l;r++)t||(t=128,e=u[g++]),d[f++]=e&t?0:255,t>>=1}return{imgData:d,width:l,height:h}}(e);return this.width=r,this.height=a,t}},N}();t.Jbig2Image=c},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ArithmeticDecoder=void 0;const r=[{qe:22017,nmps:1,nlps:1,switchFlag:1},{qe:13313,nmps:2,nlps:6,switchFlag:0},{qe:6145,nmps:3,nlps:9,switchFlag:0},{qe:2753,nmps:4,nlps:12,switchFlag:0},{qe:1313,nmps:5,nlps:29,switchFlag:0},{qe:545,nmps:38,nlps:33,switchFlag:0},{qe:22017,nmps:7,nlps:6,switchFlag:1},{qe:21505,nmps:8,nlps:14,switchFlag:0},{qe:18433,nmps:9,nlps:14,switchFlag:0},{qe:14337,nmps:10,nlps:14,switchFlag:0},{qe:12289,nmps:11,nlps:17,switchFlag:0},{qe:9217,nmps:12,nlps:18,switchFlag:0},{qe:7169,nmps:13,nlps:20,switchFlag:0},{qe:5633,nmps:29,nlps:21,switchFlag:0},{qe:22017,nmps:15,nlps:14,switchFlag:1},{qe:21505,nmps:16,nlps:14,switchFlag:0},{qe:20737,nmps:17,nlps:15,switchFlag:0},{qe:18433,nmps:18,nlps:16,switchFlag:0},{qe:14337,nmps:19,nlps:17,switchFlag:0},{qe:13313,nmps:20,nlps:18,switchFlag:0},{qe:12289,nmps:21,nlps:19,switchFlag:0},{qe:10241,nmps:22,nlps:19,switchFlag:0},{qe:9217,nmps:23,nlps:20,switchFlag:0},{qe:8705,nmps:24,nlps:21,switchFlag:0},{qe:7169,nmps:25,nlps:22,switchFlag:0},{qe:6145,nmps:26,nlps:23,switchFlag:0},{qe:5633,nmps:27,nlps:24,switchFlag:0},{qe:5121,nmps:28,nlps:25,switchFlag:0},{qe:4609,nmps:29,nlps:26,switchFlag:0},{qe:4353,nmps:30,nlps:27,switchFlag:0},{qe:2753,nmps:31,nlps:28,switchFlag:0},{qe:2497,nmps:32,nlps:29,switchFlag:0},{qe:2209,nmps:33,nlps:30,switchFlag:0},{qe:1313,nmps:34,nlps:31,switchFlag:0},{qe:1089,nmps:35,nlps:32,switchFlag:0},{qe:673,nmps:36,nlps:33,switchFlag:0},{qe:545,nmps:37,nlps:34,switchFlag:0},{qe:321,nmps:38,nlps:35,switchFlag:0},{qe:273,nmps:39,nlps:36,switchFlag:0},{qe:133,nmps:40,nlps:37,switchFlag:0},{qe:73,nmps:41,nlps:38,switchFlag:0},{qe:37,nmps:42,nlps:39,switchFlag:0},{qe:21,nmps:43,nlps:40,switchFlag:0},{qe:9,nmps:44,nlps:41,switchFlag:0},{qe:5,nmps:45,nlps:42,switchFlag:0},{qe:1,nmps:45,nlps:43,switchFlag:0},{qe:22017,nmps:46,nlps:46,switchFlag:0}];t.ArithmeticDecoder=class{constructor(e,t,r){this.data=e,this.bp=t,this.dataEnd=r,this.chigh=e[t],this.clow=0,this.byteIn(),this.chigh=this.chigh<<7&65535|this.clow>>9&127,this.clow=this.clow<<7&65535,this.ct-=7,this.a=32768}byteIn(){const e=this.data;let t=this.bp;255===e[t]?e[t+1]>143?(this.clow+=65280,this.ct=8):(t++,this.clow+=e[t]<<9,this.ct=7,this.bp=t):(t++,this.clow+=t<this.dataEnd?e[t]<<8:65280,this.ct=8,this.bp=t),this.clow>65535&&(this.chigh+=this.clow>>16,this.clow&=65535)}readBit(e,t){let a=e[t]>>1,i=1&e[t];const n=r[a],s=n.qe;let o,c=this.a-s;if(this.chigh<s)c<s?(c=s,o=i,a=n.nmps):(c=s,o=1^i,1===n.switchFlag&&(i=o),a=n.nlps);else{if(this.chigh-=s,0!=(32768&c))return this.a=c,i;c<s?(o=1^i,1===n.switchFlag&&(i=o),a=n.nlps):(o=i,a=n.nmps)}do{0===this.ct&&this.byteIn(),c<<=1,this.chigh=this.chigh<<1&65535|this.clow>>15&1,this.clow=this.clow<<1&65535,this.ct--}while(0==(32768&c));return this.a=c,e[t]=a<<1|i,o}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.JpegStream=void 0;var a=r(12),i=r(5),n=r(19),s=r(2);const o=function(){function e(e,t,r,i){let n;for(;-1!==(n=e.getByte());)if(255===n){e.skip(-1);break}this.stream=e,this.maybeLength=t,this.dict=r,this.params=i,a.DecodeStream.call(this,t)}return e.prototype=Object.create(a.DecodeStream.prototype),Object.defineProperty(e.prototype,"bytes",{get:function(){return(0,s.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0}),e.prototype.ensureBuffer=function(e){},e.prototype.readBlock=function(){if(this.eof)return;const e={decodeTransform:void 0,colorTransform:void 0},t=this.dict.getArray("Decode","D");if(this.forceRGB&&Array.isArray(t)){const r=this.dict.get("BitsPerComponent")||8,a=t.length,i=new Int32Array(a);let n=!1;const s=(1<<r)-1;for(let e=0;e<a;e+=2)i[e]=256*(t[e+1]-t[e])|0,i[e+1]=t[e]*s|0,256===i[e]&&0===i[e+1]||(n=!0);n&&(e.decodeTransform=i)}if((0,i.isDict)(this.params)){const t=this.params.get("ColorTransform");Number.isInteger(t)&&(e.colorTransform=t)}const r=new n.JpegImage(e);r.parse(this.bytes);const a=r.getData({width:this.drawWidth,height:this.drawHeight,forceRGB:this.forceRGB,isSourcePDF:!0});this.buffer=a,this.bufferLength=a.length,this.eof=!0},e}();t.JpegStream=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.JpegImage=void 0;var a=r(2),i=r(8);class n extends a.BaseException{constructor(e){super(`JPEG error: ${e}`)}}class s extends a.BaseException{constructor(e,t){super(e),this.scanLines=t}}class o extends a.BaseException{}var c=function(){var e=new Uint8Array([0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]),t=4017,r=799,c=3406,l=2276,h=1567,u=3784,d=5793,f=2896;function g({decodeTransform:e=null,colorTransform:t=-1}={}){this._decodeTransform=e,this._colorTransform=t}function p(e,t){for(var r,a,i=0,n=[],s=16;s>0&&!e[s-1];)s--;n.push({children:[],index:0});var o,c=n[0];for(r=0;r<s;r++){for(a=0;a<e[r];a++){for((c=n.pop()).children[c.index]=t[i];c.index>0;)c=n.pop();for(c.index++,n.push(c);n.length<=r;)n.push(o={children:[],index:0}),c.children[c.index]=o.children,c=o;i++}r+1<s&&(n.push(o={children:[],index:0}),c.children[c.index]=o.children,c=o)}return n[0].children}function m(e,t,r){return 64*((e.blocksPerLine+1)*t+r)}function b(t,r,c,l,h,u,d,f,g,p=!1){var b=c.mcusPerLine,y=c.progressive;const w=r;let S=0,k=0;function x(){if(k>0)return k--,S>>k&1;if(S=t[r++],255===S){var e=t[r++];if(e){if(220===e&&p){r+=2;const e=(0,i.readUint16)(t,r);if(r+=2,e>0&&e!==c.scanLines)throw new s("Found DNL marker (0xFFDC) while parsing scan data",e)}else if(217===e){if(p){const e=P*(8===c.precision?8:0);if(e>0&&Math.round(c.scanLines/e)>=10)throw new s("Found EOI marker (0xFFD9) while parsing scan data, possibly caused by incorrect `scanLines` parameter",e)}throw new o("Found EOI marker (0xFFD9) while parsing scan data")}throw new n(`unexpected marker ${(S<<8|e).toString(16)}`)}}return k=7,S>>>7}function A(e){for(var t=e;;){switch(typeof(t=t[x()])){case"number":return t;case"object":continue}throw new n("invalid huffman sequence")}}function C(e){for(var t=0;e>0;)t=t<<1|x(),e--;return t}function O(e){if(1===e)return 1===x()?1:-1;var t=C(e);return t>=1<<e-1?t:t+(-1<<e)+1}var F=0;var I,T=0;let P=0;function E(e,t,r,a,i){var n=r%b;P=(r/b|0)*e.v+a;var s=n*e.h+i;t(e,m(e,P,s))}function M(e,t,r){P=r/e.blocksPerLine|0;var a=r%e.blocksPerLine;t(e,m(e,P,a))}var N,D,B,j,L,R,_=l.length;R=y?0===u?0===f?function(e,t){var r=A(e.huffmanTableDC),a=0===r?0:O(r)<<g;e.blockData[t]=e.pred+=a}:function(e,t){e.blockData[t]|=x()<<g}:0===f?function(t,r){if(F>0)F--;else for(var a=u,i=d;a<=i;){var n=A(t.huffmanTableAC),s=15&n,o=n>>4;if(0!==s){var c=e[a+=o];t.blockData[r+c]=O(s)*(1<<g),a++}else{if(o<15){F=C(o)+(1<<o)-1;break}a+=16}}}:function(t,r){for(var a,i,s=u,o=d,c=0;s<=o;){const o=r+e[s],l=t.blockData[o]<0?-1:1;switch(T){case 0:if(c=(i=A(t.huffmanTableAC))>>4,0==(a=15&i))c<15?(F=C(c)+(1<<c),T=4):(c=16,T=1);else{if(1!==a)throw new n("invalid ACn encoding");I=O(a),T=c?2:3}continue;case 1:case 2:t.blockData[o]?t.blockData[o]+=l*(x()<<g):0==--c&&(T=2===T?3:0);break;case 3:t.blockData[o]?t.blockData[o]+=l*(x()<<g):(t.blockData[o]=I<<g,T=0);break;case 4:t.blockData[o]&&(t.blockData[o]+=l*(x()<<g));break}s++}4===T&&0==--F&&(T=0)}:function(t,r){var a=A(t.huffmanTableDC),i=0===a?0:O(a);t.blockData[r]=t.pred+=i;for(var n=1;n<64;){var s=A(t.huffmanTableAC),o=15&s,c=s>>4;if(0!==o){var l=e[n+=c];t.blockData[r+l]=O(o),n++}else{if(c<15)break;n+=16}}};var U,X,$,q,z=0;for(X=1===_?l[0].blocksPerLine*l[0].blocksPerColumn:b*c.mcusPerColumn;z<=X;){var H=h?Math.min(X-z,h):X;if(H>0){for(D=0;D<_;D++)l[D].pred=0;if(F=0,1===_)for(N=l[0],L=0;L<H;L++)M(N,R,z),z++;else for(L=0;L<H;L++){for(D=0;D<_;D++)for($=(N=l[D]).h,q=N.v,B=0;B<q;B++)for(j=0;j<$;j++)E(N,R,z,B,j);z++}}if(k=0,!(U=v(t,r)))break;if(U.invalid){const e=H>0?"unexpected":"excessive";(0,a.warn)(`decodeScan - ${e} MCU data, current marker is: ${U.invalid}`),r=U.offset}if(!(U.marker>=65488&&U.marker<=65495))break;r+=2}return r-w}function y(e,a,i){var s,o,g,p,m,b,y,w,v,S,k,x,A,C,O,F,I,T=e.quantizationTable,P=e.blockData;if(!T)throw new n("missing required Quantization Table.");for(var E=0;E<64;E+=8)v=P[a+E],S=P[a+E+1],k=P[a+E+2],x=P[a+E+3],A=P[a+E+4],C=P[a+E+5],O=P[a+E+6],F=P[a+E+7],v*=T[E],0!=(S|k|x|A|C|O|F)?(S*=T[E+1],k*=T[E+2],x*=T[E+3],A*=T[E+4],C*=T[E+5],O*=T[E+6],F*=T[E+7],o=(s=(s=d*v+128>>8)+(o=d*A+128>>8)+1>>1)-o,I=(g=k)*u+(p=O)*h+128>>8,g=g*h-p*u+128>>8,y=(m=(m=f*(S-F)+128>>8)+(y=C<<4)+1>>1)-y,b=(w=(w=f*(S+F)+128>>8)+(b=x<<4)+1>>1)-b,p=(s=s+(p=I)+1>>1)-p,g=(o=o+g+1>>1)-g,I=m*l+w*c+2048>>12,m=m*c-w*l+2048>>12,w=I,I=b*r+y*t+2048>>12,b=b*t-y*r+2048>>12,y=I,i[E]=s+w,i[E+7]=s-w,i[E+1]=o+y,i[E+6]=o-y,i[E+2]=g+b,i[E+5]=g-b,i[E+3]=p+m,i[E+4]=p-m):(I=d*v+512>>10,i[E]=I,i[E+1]=I,i[E+2]=I,i[E+3]=I,i[E+4]=I,i[E+5]=I,i[E+6]=I,i[E+7]=I);for(var M=0;M<8;++M)v=i[M],0!=((S=i[M+8])|(k=i[M+16])|(x=i[M+24])|(A=i[M+32])|(C=i[M+40])|(O=i[M+48])|(F=i[M+56]))?(o=(s=4112+((s=d*v+2048>>12)+(o=d*A+2048>>12)+1>>1))-o,I=(g=k)*u+(p=O)*h+2048>>12,g=g*h-p*u+2048>>12,p=I,y=(m=(m=f*(S-F)+2048>>12)+(y=C)+1>>1)-y,b=(w=(w=f*(S+F)+2048>>12)+(b=x)+1>>1)-b,I=m*l+w*c+2048>>12,m=m*c-w*l+2048>>12,w=I,I=b*r+y*t+2048>>12,b=b*t-y*r+2048>>12,(v=(s=s+p+1>>1)+w)<16?v=0:v>=4080?v=255:v>>=4,(S=(o=o+g+1>>1)+(y=I))<16?S=0:S>=4080?S=255:S>>=4,(k=(g=o-g)+b)<16?k=0:k>=4080?k=255:k>>=4,(x=(p=s-p)+m)<16?x=0:x>=4080?x=255:x>>=4,(A=p-m)<16?A=0:A>=4080?A=255:A>>=4,(C=g-b)<16?C=0:C>=4080?C=255:C>>=4,(O=o-y)<16?O=0:O>=4080?O=255:O>>=4,(F=s-w)<16?F=0:F>=4080?F=255:F>>=4,P[a+M]=v,P[a+M+8]=S,P[a+M+16]=k,P[a+M+24]=x,P[a+M+32]=A,P[a+M+40]=C,P[a+M+48]=O,P[a+M+56]=F):(I=(I=d*v+8192>>14)<-2040?0:I>=2024?255:I+2056>>4,P[a+M]=I,P[a+M+8]=I,P[a+M+16]=I,P[a+M+24]=I,P[a+M+32]=I,P[a+M+40]=I,P[a+M+48]=I,P[a+M+56]=I)}function w(e,t){for(var r=t.blocksPerLine,a=t.blocksPerColumn,i=new Int16Array(64),n=0;n<a;n++)for(var s=0;s<r;s++){y(t,m(t,n,s),i)}return t.blockData}function v(e,t,r=t){const a=e.length-1;var n=r<t?r:t;if(t>=a)return null;var s=(0,i.readUint16)(e,t);if(s>=65472&&s<=65534)return{invalid:null,marker:s,offset:t};for(var o=(0,i.readUint16)(e,n);!(o>=65472&&o<=65534);){if(++n>=a)return null;o=(0,i.readUint16)(e,n)}return{invalid:s.toString(16),marker:o,offset:n}}return g.prototype={parse(t,{dnlScanLines:r=null}={}){function c(){const e=(0,i.readUint16)(t,d);let r=(d+=2)+e-2;var n=v(t,r,d);n&&n.invalid&&((0,a.warn)("readDataBlock - incorrect length, current marker is: "+n.invalid),r=n.offset);var s=t.subarray(d,r);return d+=s.length,s}function l(e){for(var t=Math.ceil(e.samplesPerLine/8/e.maxH),r=Math.ceil(e.scanLines/8/e.maxV),a=0;a<e.components.length;a++){$=e.components[a];var i=Math.ceil(Math.ceil(e.samplesPerLine/8)*$.h/e.maxH),n=Math.ceil(Math.ceil(e.scanLines/8)*$.v/e.maxV),s=t*$.h,o=64*(r*$.v)*(s+1);$.blockData=new Int16Array(o),$.blocksPerLine=i,$.blocksPerColumn=n}e.mcusPerLine=t,e.mcusPerColumn=r}var h,u,d=0,f=null,g=null;let m=0;var y=[],S=[],k=[];let x=(0,i.readUint16)(t,d);if(d+=2,65496!==x)throw new n("SOI not found");x=(0,i.readUint16)(t,d),d+=2;e:for(;65497!==x;){var A,C,O;switch(x){case 65504:case 65505:case 65506:case 65507:case 65508:case 65509:case 65510:case 65511:case 65512:case 65513:case 65514:case 65515:case 65516:case 65517:case 65518:case 65519:case 65534:var F=c();65504===x&&74===F[0]&&70===F[1]&&73===F[2]&&70===F[3]&&0===F[4]&&(f={version:{major:F[5],minor:F[6]},densityUnits:F[7],xDensity:F[8]<<8|F[9],yDensity:F[10]<<8|F[11],thumbWidth:F[12],thumbHeight:F[13],thumbData:F.subarray(14,14+3*F[12]*F[13])}),65518===x&&65===F[0]&&100===F[1]&&111===F[2]&&98===F[3]&&101===F[4]&&(g={version:F[5]<<8|F[6],flags0:F[7]<<8|F[8],flags1:F[9]<<8|F[10],transformCode:F[11]});break;case 65499:for(var I=(0,i.readUint16)(t,d)+(d+=2)-2;d<I;){var T=t[d++],P=new Uint16Array(64);if(T>>4==0)for(C=0;C<64;C++)P[e[C]]=t[d++];else{if(T>>4!=1)throw new n("DQT - invalid table spec");for(C=0;C<64;C++)P[e[C]]=(0,i.readUint16)(t,d),d+=2}y[15&T]=P}break;case 65472:case 65473:case 65474:if(h)throw new n("Only single frame JPEGs supported");d+=2,(h={}).extended=65473===x,h.progressive=65474===x,h.precision=t[d++];const w=(0,i.readUint16)(t,d);d+=2,h.scanLines=r||w,h.samplesPerLine=(0,i.readUint16)(t,d),d+=2,h.components=[],h.componentIds={};var E,M=t[d++],N=0,D=0;for(A=0;A<M;A++){E=t[d];var B=t[d+1]>>4,j=15&t[d+1];N<B&&(N=B),D<j&&(D=j);var L=t[d+2];O=h.components.push({h:B,v:j,quantizationId:L,quantizationTable:null}),h.componentIds[E]=O-1,d+=3}h.maxH=N,h.maxV=D,l(h);break;case 65476:const J=(0,i.readUint16)(t,d);for(d+=2,A=2;A<J;){var R=t[d++],_=new Uint8Array(16),U=0;for(C=0;C<16;C++,d++)U+=_[C]=t[d];var X=new Uint8Array(U);for(C=0;C<U;C++,d++)X[C]=t[d];A+=17+U,(R>>4==0?k:S)[15&R]=p(_,X)}break;case 65501:d+=2,u=(0,i.readUint16)(t,d),d+=2;break;case 65498:const Z=1==++m&&!r;d+=2;var $,q=t[d++],z=[];for(A=0;A<q;A++){const e=t[d++];var H=h.componentIds[e];($=h.components[H]).index=e;var G=t[d++];$.huffmanTableDC=k[G>>4],$.huffmanTableAC=S[15&G],z.push($)}var V=t[d++],W=t[d++],K=t[d++];try{var Y=b(t,d,h,z,u,V,W,K>>4,15&K,Z);d+=Y}catch(e){if(e instanceof s)return(0,a.warn)(`${e.message} -- attempting to re-parse the JPEG image.`),this.parse(t,{dnlScanLines:e.scanLines});if(e instanceof o){(0,a.warn)(`${e.message} -- ignoring the rest of the image data.`);break e}throw e}break;case 65500:d+=4;break;case 65535:255!==t[d]&&d--;break;default:const Q=v(t,d-2,d-3);if(Q&&Q.invalid){(0,a.warn)("JpegImage.parse - unexpected data, current marker is: "+Q.invalid),d=Q.offset;break}if(!Q||d>=t.length-1){(0,a.warn)("JpegImage.parse - reached the end of the image data without finding an EOI marker (0xFFD9).");break e}throw new n("JpegImage.parse - unknown marker: "+x.toString(16))}x=(0,i.readUint16)(t,d),d+=2}for(this.width=h.samplesPerLine,this.height=h.scanLines,this.jfif=f,this.adobe=g,this.components=[],A=0;A<h.components.length;A++){var J=y[($=h.components[A]).quantizationId];J&&($.quantizationTable=J),this.components.push({index:$.index,output:w(0,$),scaleX:$.h/h.maxH,scaleY:$.v/h.maxV,blocksPerLine:$.blocksPerLine,blocksPerColumn:$.blocksPerColumn})}this.numComponents=this.components.length},_getLinearizedBlockData(e,t,r=!1){var a,i,n,s,o,c,l,h,u,d,f,g=this.width/e,p=this.height/t,m=0,b=this.components.length,y=e*t*b,w=new Uint8ClampedArray(y),v=new Uint32Array(e),S=4294967288;let k;for(l=0;l<b;l++){if(i=(a=this.components[l]).scaleX*g,n=a.scaleY*p,m=l,f=a.output,s=a.blocksPerLine+1<<3,i!==k){for(o=0;o<e;o++)h=0|o*i,v[o]=(h&S)<<3|7&h;k=i}for(c=0;c<t;c++)for(d=s*((h=0|c*n)&S)|(7&h)<<3,o=0;o<e;o++)w[m]=f[d+v[o]],m+=b}let x=this._decodeTransform;if(r||4!==b||x||(x=new Int32Array([-256,255,-256,255,-256,255,-256,255])),x)for(l=0;l<y;)for(h=0,u=0;h<b;h++,l++,u+=2)w[l]=(w[l]*x[u]>>8)+x[u+1];return w},get _isColorConversionNeeded(){return this.adobe?!!this.adobe.transformCode:3===this.numComponents?0!==this._colorTransform&&(82!==this.components[0].index||71!==this.components[1].index||66!==this.components[2].index):1===this._colorTransform},_convertYccToRgb:function(e){for(var t,r,a,i=0,n=e.length;i<n;i+=3)t=e[i],r=e[i+1],a=e[i+2],e[i]=t-179.456+1.402*a,e[i+1]=t+135.459-.344*r-.714*a,e[i+2]=t-226.816+1.772*r;return e},_convertYcckToRgb:function(e){for(var t,r,a,i,n=0,s=0,o=e.length;s<o;s+=4)t=e[s],r=e[s+1],a=e[s+2],i=e[s+3],e[n++]=r*(-660635669420364e-19*r+.000437130475926232*a-54080610064599e-18*t+.00048449797120281*i-.154362151871126)-122.67195406894+a*(-.000957964378445773*a+.000817076911346625*t-.00477271405408747*i+1.53380253221734)+t*(.000961250184130688*t-.00266257332283933*i+.48357088451265)+i*(-.000336197177618394*i+.484791561490776),e[n++]=107.268039397724+r*(219927104525741e-19*r-.000640992018297945*a+.000659397001245577*t+.000426105652938837*i-.176491792462875)+a*(-.000778269941513683*a+.00130872261408275*t+.000770482631801132*i-.151051492775562)+t*(.00126935368114843*t-.00265090189010898*i+.25802910206845)+i*(-.000318913117588328*i-.213742400323665),e[n++]=r*(-.000570115196973677*r-263409051004589e-19*a+.0020741088115012*t-.00288260236853442*i+.814272968359295)-20.810012546947+a*(-153496057440975e-19*a-.000132689043961446*t+.000560833691242812*i-.195152027534049)+t*(.00174418132927582*t-.00255243321439347*i+.116935020465145)+i*(-.000343531996510555*i+.24165260232407);return e.subarray(0,n)},_convertYcckToCmyk:function(e){for(var t,r,a,i=0,n=e.length;i<n;i+=4)t=e[i],r=e[i+1],a=e[i+2],e[i]=434.456-t-1.402*a,e[i+1]=119.541-t+.344*r+.714*a,e[i+2]=481.816-t-1.772*r;return e},_convertCmykToRgb:function(e){for(var t,r,a,i,n=0,s=0,o=e.length;s<o;s+=4)t=e[s],r=e[s+1],a=e[s+2],i=e[s+3],e[n++]=255+t*(-6747147073602441e-20*t+.0008379262121013727*r+.0002894718188643294*a+.003264231057537806*i-1.1185611867203937)+r*(26374107616089405e-21*r-8626949158638572e-20*a-.0002748769067499491*i-.02155688794978967)+a*(-3878099212869363e-20*a-.0003267808279485286*i+.0686742238595345)-i*(.0003361971776183937*i+.7430659151342254),e[n++]=255+t*(.00013596372813588848*t+.000924537132573585*r+.00010567359618683593*a+.0004791864687436512*i-.3109689587515875)+r*(-.00023545346108370344*r+.0002702845253534714*a+.0020200308977307156*i-.7488052167015494)+a*(6834815998235662e-20*a+.00015168452363460973*i-.09751927774728933)-i*(.0003189131175883281*i+.7364883807733168),e[n++]=255+t*(13598650411385307e-21*t+.00012423956175490851*r+.0004751985097583589*a-36729317476630422e-22*i-.05562186980264034)+r*(.00016141380598724676*r+.0009692239130725186*a+.0007782692450036253*i-.44015232367526463)+a*(5.068882914068769e-7*a+.0017778369011375071*i-.7591454649749609)-i*(.0003435319965105553*i+.7063770186160144);return e.subarray(0,n)},getData({width:e,height:t,forceRGB:r=!1,isSourcePDF:a=!1}){if(this.numComponents>4)throw new n("Unsupported color mode");var i=this._getLinearizedBlockData(e,t,a);if(1===this.numComponents&&r){for(var s=i.length,o=new Uint8ClampedArray(3*s),c=0,l=0;l<s;l++){var h=i[l];o[c++]=h,o[c++]=h,o[c++]=h}return o}if(3===this.numComponents&&this._isColorConversionNeeded)return this._convertYccToRgb(i);if(4===this.numComponents){if(this._isColorConversionNeeded)return r?this._convertYcckToRgb(i):this._convertYcckToCmyk(i);if(r)return this._convertCmykToRgb(i)}return i}},g}();t.JpegImage=c},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.JpxStream=void 0;var a=r(12),i=r(21),n=r(2);const s=function(){function e(e,t,r,i){this.stream=e,this.maybeLength=t,this.dict=r,this.params=i,a.DecodeStream.call(this,t)}return e.prototype=Object.create(a.DecodeStream.prototype),Object.defineProperty(e.prototype,"bytes",{get:function(){return(0,n.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0}),e.prototype.ensureBuffer=function(e){},e.prototype.readBlock=function(){if(this.eof)return;const e=new i.JpxImage;e.parse(this.bytes);const t=e.width,r=e.height,a=e.componentsCount,n=e.tiles.length;if(1===n)this.buffer=e.tiles[0].items;else{const i=new Uint8ClampedArray(t*r*a);for(let r=0;r<n;r++){const n=e.tiles[r],s=n.width,o=n.height,c=n.left,l=n.top,h=n.items;let u=0,d=(t*l+c)*a;const f=t*a,g=s*a;for(let e=0;e<o;e++){const e=h.subarray(u,u+g);i.set(e,d),u+=g,d+=f}}this.buffer=i}this.bufferLength=this.buffer.length,this.eof=!0},e}();t.JpxStream=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.JpxImage=void 0;var a=r(2),i=r(8),n=r(17);class s extends a.BaseException{constructor(e){super(`JPX error: ${e}`)}}var o=function(){var e={LL:0,LH:1,HL:1,HH:2};function t(){this.failOnCorruptedImage=!1}function r(e,t){e.x0=Math.ceil(t.XOsiz/e.XRsiz),e.x1=Math.ceil(t.Xsiz/e.XRsiz),e.y0=Math.ceil(t.YOsiz/e.YRsiz),e.y1=Math.ceil(t.Ysiz/e.YRsiz),e.width=e.x1-e.x0,e.height=e.y1-e.y0}function o(e,t){for(var r,a=e.SIZ,i=[],n=Math.ceil((a.Xsiz-a.XTOsiz)/a.XTsiz),s=Math.ceil((a.Ysiz-a.YTOsiz)/a.YTsiz),o=0;o<s;o++)for(var c=0;c<n;c++)(r={}).tx0=Math.max(a.XTOsiz+c*a.XTsiz,a.XOsiz),r.ty0=Math.max(a.YTOsiz+o*a.YTsiz,a.YOsiz),r.tx1=Math.min(a.XTOsiz+(c+1)*a.XTsiz,a.Xsiz),r.ty1=Math.min(a.YTOsiz+(o+1)*a.YTsiz,a.Ysiz),r.width=r.tx1-r.tx0,r.height=r.ty1-r.ty0,r.components=[],i.push(r);e.tiles=i;for(var l=0,h=a.Csiz;l<h;l++)for(var u=t[l],d=0,f=i.length;d<f;d++){var g={};r=i[d],g.tcx0=Math.ceil(r.tx0/u.XRsiz),g.tcy0=Math.ceil(r.ty0/u.YRsiz),g.tcx1=Math.ceil(r.tx1/u.XRsiz),g.tcy1=Math.ceil(r.ty1/u.YRsiz),g.width=g.tcx1-g.tcx0,g.height=g.tcy1-g.tcy0,r.components[l]=g}}function c(e,t,r){var a=t.codingStyleParameters,i={};return a.entropyCoderWithCustomPrecincts?(i.PPx=a.precinctsSizes[r].PPx,i.PPy=a.precinctsSizes[r].PPy):(i.PPx=15,i.PPy=15),i.xcb_=r>0?Math.min(a.xcb,i.PPx-1):Math.min(a.xcb,i.PPx),i.ycb_=r>0?Math.min(a.ycb,i.PPy-1):Math.min(a.ycb,i.PPy),i}function l(e,t,r){var a=1<<r.PPx,i=1<<r.PPy,n=0===t.resLevel,s=1<<r.PPx+(n?0:-1),o=1<<r.PPy+(n?0:-1),c=t.trx1>t.trx0?Math.ceil(t.trx1/a)-Math.floor(t.trx0/a):0,l=t.try1>t.try0?Math.ceil(t.try1/i)-Math.floor(t.try0/i):0,h=c*l;t.precinctParameters={precinctWidth:a,precinctHeight:i,numprecinctswide:c,numprecinctshigh:l,numprecincts:h,precinctWidthInSubband:s,precinctHeightInSubband:o}}function h(e,t,r){var a,i,n,s,o=r.xcb_,c=r.ycb_,l=1<<o,h=1<<c,u=t.tbx0>>o,d=t.tby0>>c,f=t.tbx1+l-1>>o,g=t.tby1+h-1>>c,p=t.resolution.precinctParameters,m=[],b=[];for(i=d;i<g;i++)for(a=u;a<f;a++){if((n={cbx:a,cby:i,tbx0:l*a,tby0:h*i,tbx1:l*(a+1),tby1:h*(i+1)}).tbx0_=Math.max(t.tbx0,n.tbx0),n.tby0_=Math.max(t.tby0,n.tby0),n.tbx1_=Math.min(t.tbx1,n.tbx1),n.tby1_=Math.min(t.tby1,n.tby1),s=Math.floor((n.tbx0_-t.tbx0)/p.precinctWidthInSubband)+Math.floor((n.tby0_-t.tby0)/p.precinctHeightInSubband)*p.numprecinctswide,n.precinctNumber=s,n.subbandType=t.type,n.Lblock=3,!(n.tbx1_<=n.tbx0_||n.tby1_<=n.tby0_)){m.push(n);var y=b[s];void 0!==y?(a<y.cbxMin?y.cbxMin=a:a>y.cbxMax&&(y.cbxMax=a),i<y.cbyMin?y.cbxMin=i:i>y.cbyMax&&(y.cbyMax=i)):b[s]=y={cbxMin:a,cbyMin:i,cbxMax:a,cbyMax:i},n.precinct=y}}t.codeblockParameters={codeblockWidth:o,codeblockHeight:c,numcodeblockwide:f-u+1,numcodeblockhigh:g-d+1},t.codeblocks=m,t.precincts=b}function u(e,t,r){for(var a=[],i=e.subbands,n=0,s=i.length;n<s;n++)for(var o=i[n].codeblocks,c=0,l=o.length;c<l;c++){var h=o[c];h.precinctNumber===t&&a.push(h)}return{layerNumber:r,codeblocks:a}}function d(e){for(var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=0,c=0;c<n;c++)o=Math.max(o,a.components[c].codingStyleParameters.decompositionLevelsCount);var l=0,h=0,d=0,f=0;this.nextPacket=function(){for(;l<i;l++){for(;h<=o;h++){for(;d<n;d++){var e=a.components[d];if(!(h>e.codingStyleParameters.decompositionLevelsCount)){for(var t=e.resolutions[h],r=t.precinctParameters.numprecincts;f<r;){var c=u(t,f,l);return f++,c}f=0}}d=0}h=0}throw new s("Out of packets")}}function f(e){for(var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=0,c=0;c<n;c++)o=Math.max(o,a.components[c].codingStyleParameters.decompositionLevelsCount);var l=0,h=0,d=0,f=0;this.nextPacket=function(){for(;l<=o;l++){for(;h<i;h++){for(;d<n;d++){var e=a.components[d];if(!(l>e.codingStyleParameters.decompositionLevelsCount)){for(var t=e.resolutions[l],r=t.precinctParameters.numprecincts;f<r;){var c=u(t,f,h);return f++,c}f=0}}d=0}h=0}throw new s("Out of packets")}}function g(e){var t,r,a,i,n=e.SIZ,o=e.currentTile.index,c=e.tiles[o],l=c.codingStyleDefaultParameters.layersCount,h=n.Csiz,d=0;for(a=0;a<h;a++){const e=c.components[a];d=Math.max(d,e.codingStyleParameters.decompositionLevelsCount)}var f=new Int32Array(d+1);for(r=0;r<=d;++r){var g=0;for(a=0;a<h;++a){var p=c.components[a].resolutions;r<p.length&&(g=Math.max(g,p[r].precinctParameters.numprecincts))}f[r]=g}t=0,r=0,a=0,i=0,this.nextPacket=function(){for(;r<=d;r++){for(;i<f[r];i++){for(;a<h;a++){const s=c.components[a];if(!(r>s.codingStyleParameters.decompositionLevelsCount)){var e=s.resolutions[r],n=e.precinctParameters.numprecincts;if(!(i>=n)){for(;t<l;){var o=u(e,i,t);return t++,o}t=0}}}a=0}i=0}throw new s("Out of packets")}}function p(e){var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=y(a),c=o,l=0,h=0,d=0,f=0,g=0;this.nextPacket=function(){for(;g<c.maxNumHigh;g++){for(;f<c.maxNumWide;f++){for(;d<n;d++){for(var e=a.components[d],t=e.codingStyleParameters.decompositionLevelsCount;h<=t;h++){var r=e.resolutions[h],p=o.components[d].resolutions[h],m=b(f,g,p,c,r);if(null!==m){for(;l<i;){var y=u(r,m,l);return l++,y}l=0}}h=0}d=0}f=0}throw new s("Out of packets")}}function m(e){var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=y(a),c=0,l=0,h=0,d=0,f=0;this.nextPacket=function(){for(;h<n;++h){for(var e=a.components[h],t=o.components[h],r=e.codingStyleParameters.decompositionLevelsCount;f<t.maxNumHigh;f++){for(;d<t.maxNumWide;d++){for(;l<=r;l++){var g=e.resolutions[l],p=t.resolutions[l],m=b(d,f,p,t,g);if(null!==m){for(;c<i;){var y=u(g,m,c);return c++,y}c=0}}l=0}d=0}f=0}throw new s("Out of packets")}}function b(e,t,r,a,i){var n=e*a.minWidth,s=t*a.minHeight;if(n%r.width!=0||s%r.height!=0)return null;var o=s/r.width*i.precinctParameters.numprecinctswide;return n/r.height+o}function y(e){for(var t=e.components.length,r=Number.MAX_VALUE,a=Number.MAX_VALUE,i=0,n=0,s=new Array(t),o=0;o<t;o++){for(var c=e.components[o],l=c.codingStyleParameters.decompositionLevelsCount,h=new Array(l+1),u=Number.MAX_VALUE,d=Number.MAX_VALUE,f=0,g=0,p=1,m=l;m>=0;--m){var b=c.resolutions[m],y=p*b.precinctParameters.precinctWidth,w=p*b.precinctParameters.precinctHeight;u=Math.min(u,y),d=Math.min(d,w),f=Math.max(f,b.precinctParameters.numprecinctswide),g=Math.max(g,b.precinctParameters.numprecinctshigh),h[m]={width:y,height:w},p<<=1}r=Math.min(r,u),a=Math.min(a,d),i=Math.max(i,f),n=Math.max(n,g),s[o]={resolutions:h,minWidth:u,minHeight:d,maxNumWide:f,maxNumHigh:g}}return{components:s,minWidth:r,minHeight:a,maxNumWide:i,maxNumHigh:n}}function w(e){for(var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=t.Csiz,n=0;n<i;n++){for(var o=a.components[n],u=o.codingStyleParameters.decompositionLevelsCount,b=[],y=[],w=0;w<=u;w++){var v,S=c(0,o,w),k={},x=1<<u-w;if(k.trx0=Math.ceil(o.tcx0/x),k.try0=Math.ceil(o.tcy0/x),k.trx1=Math.ceil(o.tcx1/x),k.try1=Math.ceil(o.tcy1/x),k.resLevel=w,l(0,k,S),b.push(k),0===w)(v={}).type="LL",v.tbx0=Math.ceil(o.tcx0/x),v.tby0=Math.ceil(o.tcy0/x),v.tbx1=Math.ceil(o.tcx1/x),v.tby1=Math.ceil(o.tcy1/x),v.resolution=k,h(0,v,S),y.push(v),k.subbands=[v];else{var A=1<<u-w+1,C=[];(v={}).type="HL",v.tbx0=Math.ceil(o.tcx0/A-.5),v.tby0=Math.ceil(o.tcy0/A),v.tbx1=Math.ceil(o.tcx1/A-.5),v.tby1=Math.ceil(o.tcy1/A),v.resolution=k,h(0,v,S),y.push(v),C.push(v),(v={}).type="LH",v.tbx0=Math.ceil(o.tcx0/A),v.tby0=Math.ceil(o.tcy0/A-.5),v.tbx1=Math.ceil(o.tcx1/A),v.tby1=Math.ceil(o.tcy1/A-.5),v.resolution=k,h(0,v,S),y.push(v),C.push(v),(v={}).type="HH",v.tbx0=Math.ceil(o.tcx0/A-.5),v.tby0=Math.ceil(o.tcy0/A-.5),v.tbx1=Math.ceil(o.tcx1/A-.5),v.tby1=Math.ceil(o.tcy1/A-.5),v.resolution=k,h(0,v,S),y.push(v),C.push(v),k.subbands=C}}o.resolutions=b,o.subbands=y}var O=a.codingStyleDefaultParameters.progressionOrder;switch(O){case 0:a.packetsIterator=new d(e);break;case 1:a.packetsIterator=new f(e);break;case 2:a.packetsIterator=new g(e);break;case 3:a.packetsIterator=new p(e);break;case 4:a.packetsIterator=new m(e);break;default:throw new s(`Unsupported progression order ${O}`)}}function v(e,t,r,a){var n,s=0,o=0,c=!1;function l(e){for(;o<e;){var a=t[r+s];s++,c?(n=n<<7|a,o+=7,c=!1):(n=n<<8|a,o+=8),255===a&&(c=!0)}return n>>>(o-=e)&(1<<e)-1}function h(e){return 255===t[r+s-1]&&t[r+s]===e?(u(1),!0):255===t[r+s]&&t[r+s+1]===e&&(u(2),!0)}function u(e){s+=e}function d(){o=0,c&&(s++,c=!1)}function f(){if(0===l(1))return 1;if(0===l(1))return 2;var e=l(2);return e<3?e+3:(e=l(5))<31?e+6:(e=l(7))+37}for(var g=e.currentTile.index,p=e.tiles[g],m=e.COD.sopMarkerUsed,b=e.COD.ephMarkerUsed,y=p.packetsIterator;s<a;){d(),m&&h(145)&&u(4);var w=y.nextPacket();if(l(1)){for(var v,S=w.layerNumber,k=[],x=0,O=w.codeblocks.length;x<O;x++){var F=(v=w.codeblocks[x]).precinct,I=v.cbx-F.cbxMin,T=v.cby-F.cbyMin,P=!1,E=!1;if(void 0!==v.included)P=!!l(1);else{var M,N;if(void 0!==(F=v.precinct).inclusionTree)M=F.inclusionTree;else{var D=F.cbxMax-F.cbxMin+1,B=F.cbyMax-F.cbyMin+1;M=new C(D,B,S),N=new A(D,B),F.inclusionTree=M,F.zeroBitPlanesTree=N}if(M.reset(I,T,S))for(;;){if(!l(1)){M.incrementValue(S);break}if(!M.nextLevel()){v.included=!0,P=E=!0;break}}}if(P){if(E){for((N=F.zeroBitPlanesTree).reset(I,T);;)if(l(1)){if(!N.nextLevel())break}else N.incrementValue();v.zeroBitPlanes=N.value}for(var j=f();l(1);)v.Lblock++;var L=(0,i.log2)(j),R=l((j<1<<L?L-1:L)+v.Lblock);k.push({codeblock:v,codingpasses:j,dataLength:R})}}for(d(),b&&h(146);k.length>0;){var _=k.shift();void 0===(v=_.codeblock).data&&(v.data=[]),v.data.push({data:t,start:r+s,end:r+s+_.dataLength,codingpasses:_.codingpasses}),s+=_.dataLength}}}return s}function S(e,t,r,a,i,s,o,c){for(var l=a.tbx0,h=a.tby0,u=a.tbx1-a.tbx0,d=a.codeblocks,f="H"===a.type.charAt(0)?1:0,g="H"===a.type.charAt(1)?t:0,p=0,m=d.length;p<m;++p){var b=d[p],y=b.tbx1_-b.tbx0_,w=b.tby1_-b.tby0_;if(0!==y&&0!==w&&void 0!==b.data){var v,S;v=new O(y,w,b.subbandType,b.zeroBitPlanes,s),S=2;var k,x,A,C=b.data,F=0,I=0;for(k=0,x=C.length;k<x;k++)F+=(A=C[k]).end-A.start,I+=A.codingpasses;var T=new Uint8Array(F),P=0;for(k=0,x=C.length;k<x;k++){var E=(A=C[k]).data.subarray(A.start,A.end);T.set(E,P),P+=E.length}var M=new n.ArithmeticDecoder(T,0,F);for(v.setDecoder(M),k=0;k<I;k++){switch(S){case 0:v.runSignificancePropagationPass();break;case 1:v.runMagnitudeRefinementPass();break;case 2:v.runCleanupPass(),c&&v.checkSegmentationSymbol();break}S=(S+1)%3}var N,D,B,j=b.tbx0_-l+(b.tby0_-h)*u,L=v.coefficentsSign,R=v.coefficentsMagnitude,_=v.bitsDecoded,U=o?0:.5;P=0;var X="LL"!==a.type;for(k=0;k<w;k++){var $=2*(j/u|0)*(t-u)+f+g;for(N=0;N<y;N++){if(0!==(D=R[P])){D=(D+U)*i,0!==L[P]&&(D=-D),B=_[P];var q=X?$+(j<<1):j;e[q]=o&&B>=s?D:D*(1<<s-B)}j++,P++}j+=u-y}}}}function k(t,r,a){for(var i=r.components[a],n=i.codingStyleParameters,s=i.quantizationParameters,o=n.decompositionLevelsCount,c=s.SPqcds,l=s.scalarExpounded,h=s.guardBits,u=n.segmentationSymbolUsed,d=t.components[a].precision,f=n.reversibleTransformation,g=f?new T:new I,p=[],m=0,b=0;b<=o;b++){for(var y=i.resolutions[b],w=y.trx1-y.trx0,v=y.try1-y.try0,k=new Float32Array(w*v),x=0,A=y.subbands.length;x<A;x++){var C,O;l?(C=c[m].mu,O=c[m].epsilon,m++):(C=c[0].mu,O=c[0].epsilon+(b>0?1-b:0));var F=y.subbands[x],P=e[F.type];S(k,w,0,F,f?1:2**(d+P-O)*(1+C/2048),h+O-1,f,u)}p.push({width:w,height:v,items:k})}var E=g.calculate(p,i.tcx0,i.tcy0);return{left:i.tcx0,top:i.tcy0,width:E.width,height:E.height,items:E.items}}function x(e,t){for(var r=e.SIZ.Csiz,a=e.tiles[t],i=0;i<r;i++){var n=a.components[i],s=void 0!==e.currentTile.QCC[i]?e.currentTile.QCC[i]:e.currentTile.QCD;n.quantizationParameters=s;var o=void 0!==e.currentTile.COC[i]?e.currentTile.COC[i]:e.currentTile.COD;n.codingStyleParameters=o}a.codingStyleDefaultParameters=e.currentTile.COD}t.prototype={parse:function(e){if(65359!==(0,i.readUint16)(e,0))for(var t=0,r=e.length;t<r;){var n=8,o=(0,i.readUint32)(e,t),c=(0,i.readUint32)(e,t+4);if(t+=n,1===o&&(o=4294967296*(0,i.readUint32)(e,t)+(0,i.readUint32)(e,t+4),t+=8,n+=8),0===o&&(o=r-t+n),o<n)throw new s("Invalid box field size");var l=o-n,h=!0;switch(c){case 1785737832:h=!1;break;case 1668246642:var u=e[t];if(1===u){var d=(0,i.readUint32)(e,t+3);switch(d){case 16:case 17:case 18:break;default:(0,a.warn)("Unknown colorspace "+d);break}}else 2===u&&(0,a.info)("ICC profile not supported");break;case 1785737827:this.parseCodestream(e,t,t+l);break;case 1783636e3:218793738!==(0,i.readUint32)(e,t)&&(0,a.warn)("Invalid JP2 signature");break;case 1783634458:case 1718909296:case 1920099697:case 1919251232:case 1768449138:break;default:var f=String.fromCharCode(c>>24&255,c>>16&255,c>>8&255,255&c);(0,a.warn)("Unsupported header type "+c+" ("+f+")");break}h&&(t+=l)}else this.parseCodestream(e,0,e.length)},parseImageProperties:function(e){for(var t=e.getByte();t>=0;){if(65361===(t<<8|(t=e.getByte()))){e.skip(4);var r=e.getInt32()>>>0,a=e.getInt32()>>>0,i=e.getInt32()>>>0,n=e.getInt32()>>>0;e.skip(16);var o=e.getUint16();return this.width=r-i,this.height=a-n,this.componentsCount=o,void(this.bitsPerComponent=8)}}throw new s("No size marker found in JPX stream")},parseCodestream:function(e,t,n){var c={},l=!1;try{for(var h=t;h+1<n;){var u=(0,i.readUint16)(e,h);h+=2;var d,f,g,p,m,b,y=0;switch(u){case 65359:c.mainHeader=!0;break;case 65497:break;case 65361:y=(0,i.readUint16)(e,h);var S={};S.Xsiz=(0,i.readUint32)(e,h+4),S.Ysiz=(0,i.readUint32)(e,h+8),S.XOsiz=(0,i.readUint32)(e,h+12),S.YOsiz=(0,i.readUint32)(e,h+16),S.XTsiz=(0,i.readUint32)(e,h+20),S.YTsiz=(0,i.readUint32)(e,h+24),S.XTOsiz=(0,i.readUint32)(e,h+28),S.YTOsiz=(0,i.readUint32)(e,h+32);var A=(0,i.readUint16)(e,h+36);S.Csiz=A;var C=[];d=h+38;for(var O=0;O<A;O++){var F={precision:1+(127&e[d]),isSigned:!!(128&e[d]),XRsiz:e[d+1],YRsiz:e[d+2]};d+=3,r(F,S),C.push(F)}c.SIZ=S,c.components=C,o(c,C),c.QCC=[],c.COC=[];break;case 65372:y=(0,i.readUint16)(e,h);var I={};switch(d=h+2,31&(f=e[d++])){case 0:p=8,m=!0;break;case 1:p=16,m=!1;break;case 2:p=16,m=!0;break;default:throw new Error("Invalid SQcd value "+f)}for(I.noQuantization=8===p,I.scalarExpounded=m,I.guardBits=f>>5,g=[];d<y+h;){var T={};8===p?(T.epsilon=e[d++]>>3,T.mu=0):(T.epsilon=e[d]>>3,T.mu=(7&e[d])<<8|e[d+1],d+=2),g.push(T)}I.SPqcds=g,c.mainHeader?c.QCD=I:(c.currentTile.QCD=I,c.currentTile.QCC=[]);break;case 65373:y=(0,i.readUint16)(e,h);var P,E={};switch(d=h+2,c.SIZ.Csiz<257?P=e[d++]:(P=(0,i.readUint16)(e,d),d+=2),31&(f=e[d++])){case 0:p=8,m=!0;break;case 1:p=16,m=!1;break;case 2:p=16,m=!0;break;default:throw new Error("Invalid SQcd value "+f)}for(E.noQuantization=8===p,E.scalarExpounded=m,E.guardBits=f>>5,g=[];d<y+h;)T={},8===p?(T.epsilon=e[d++]>>3,T.mu=0):(T.epsilon=e[d]>>3,T.mu=(7&e[d])<<8|e[d+1],d+=2),g.push(T);E.SPqcds=g,c.mainHeader?c.QCC[P]=E:c.currentTile.QCC[P]=E;break;case 65362:y=(0,i.readUint16)(e,h);var M={};d=h+2;var N=e[d++];M.entropyCoderWithCustomPrecincts=!!(1&N),M.sopMarkerUsed=!!(2&N),M.ephMarkerUsed=!!(4&N),M.progressionOrder=e[d++],M.layersCount=(0,i.readUint16)(e,d),d+=2,M.multipleComponentTransform=e[d++],M.decompositionLevelsCount=e[d++],M.xcb=2+(15&e[d++]),M.ycb=2+(15&e[d++]);var D=e[d++];if(M.selectiveArithmeticCodingBypass=!!(1&D),M.resetContextProbabilities=!!(2&D),M.terminationOnEachCodingPass=!!(4&D),M.verticallyStripe=!!(8&D),M.predictableTermination=!!(16&D),M.segmentationSymbolUsed=!!(32&D),M.reversibleTransformation=e[d++],M.entropyCoderWithCustomPrecincts){for(var B=[];d<y+h;){var j=e[d++];B.push({PPx:15&j,PPy:j>>4})}M.precinctsSizes=B}var L=[];M.selectiveArithmeticCodingBypass&&L.push("selectiveArithmeticCodingBypass"),M.resetContextProbabilities&&L.push("resetContextProbabilities"),M.terminationOnEachCodingPass&&L.push("terminationOnEachCodingPass"),M.verticallyStripe&&L.push("verticallyStripe"),M.predictableTermination&&L.push("predictableTermination"),L.length>0&&(l=!0,(0,a.warn)(`JPX: Unsupported COD options (${L.join(", ")}).`)),c.mainHeader?c.COD=M:(c.currentTile.COD=M,c.currentTile.COC=[]);break;case 65424:y=(0,i.readUint16)(e,h),(b={}).index=(0,i.readUint16)(e,h+2),b.length=(0,i.readUint32)(e,h+4),b.dataEnd=b.length+h-2,b.partIndex=e[h+8],b.partsCount=e[h+9],c.mainHeader=!1,0===b.partIndex&&(b.COD=c.COD,b.COC=c.COC.slice(0),b.QCD=c.QCD,b.QCC=c.QCC.slice(0)),c.currentTile=b;break;case 65427:0===(b=c.currentTile).partIndex&&(x(c,b.index),w(c)),v(c,e,h,y=b.dataEnd-h);break;case 65363:(0,a.warn)("JPX: Codestream code 0xFF53 (COC) is not implemented.");case 65365:case 65367:case 65368:case 65380:y=(0,i.readUint16)(e,h);break;default:throw new Error("Unknown codestream code: "+u.toString(16))}h+=y}}catch(e){if(l||this.failOnCorruptedImage)throw new s(e.message);(0,a.warn)(`JPX: Trying to recover from: "${e.message}".`)}this.tiles=function(e){for(var t=e.SIZ,r=e.components,a=t.Csiz,i=[],n=0,s=e.tiles.length;n<s;n++){var o,c=e.tiles[n],l=[];for(o=0;o<a;o++)l[o]=k(e,c,o);var h,u,d,f,g,p,m,b=l[0],y=new Uint8ClampedArray(b.items.length*a),w={left:b.left,top:b.top,width:b.width,height:b.height,items:y},v=0;if(c.codingStyleDefaultParameters.multipleComponentTransform){var S=4===a,x=l[0].items,A=l[1].items,C=l[2].items,O=S?l[3].items:null;u=.5+(128<<(h=r[0].precision-8));var F=c.components[0],I=a-3;if(f=x.length,F.codingStyleParameters.reversibleTransformation)for(d=0;d<f;d++,v+=I){g=x[d]+u,p=A[d];const e=g-((m=C[d])+p>>2);y[v++]=e+m>>h,y[v++]=e>>h,y[v++]=e+p>>h}else for(d=0;d<f;d++,v+=I)g=x[d]+u,p=A[d],m=C[d],y[v++]=g+1.402*m>>h,y[v++]=g-.34413*p-.71414*m>>h,y[v++]=g+1.772*p>>h;if(S)for(d=0,v=3;d<f;d++,v+=4)y[v]=O[d]+u>>h}else for(o=0;o<a;o++){var T=l[o].items;for(u=.5+(128<<(h=r[o].precision-8)),v=o,d=0,f=T.length;d<f;d++)y[v]=T[d]+u>>h,v+=a}i.push(w)}return i}(c),this.width=c.SIZ.Xsiz-c.SIZ.XOsiz,this.height=c.SIZ.Ysiz-c.SIZ.YOsiz,this.componentsCount=c.SIZ.Csiz}};var A=function(){function e(e,t){var r=(0,i.log2)(Math.max(e,t))+1;this.levels=[];for(var a=0;a<r;a++){var n={width:e,height:t,items:[]};this.levels.push(n),e=Math.ceil(e/2),t=Math.ceil(t/2)}}return e.prototype={reset:function(e,t){for(var r,a=0,i=0;a<this.levels.length;){var n=e+t*(r=this.levels[a]).width;if(void 0!==r.items[n]){i=r.items[n];break}r.index=n,e>>=1,t>>=1,a++}a--,(r=this.levels[a]).items[r.index]=i,this.currentLevel=a,delete this.value},incrementValue:function(){var e=this.levels[this.currentLevel];e.items[e.index]++},nextLevel:function(){var e=this.currentLevel,t=this.levels[e],r=t.items[t.index];return--e<0?(this.value=r,!1):(this.currentLevel=e,(t=this.levels[e]).items[t.index]=r,!0)}},e}(),C=function(){function e(e,t,r){var a=(0,i.log2)(Math.max(e,t))+1;this.levels=[];for(var n=0;n<a;n++){for(var s=new Uint8Array(e*t),o=0,c=s.length;o<c;o++)s[o]=r;var l={width:e,height:t,items:s};this.levels.push(l),e=Math.ceil(e/2),t=Math.ceil(t/2)}}return e.prototype={reset:function(e,t,r){for(var a=0;a<this.levels.length;){var i=this.levels[a],n=e+t*i.width;i.index=n;var s=i.items[n];if(255===s)break;if(s>r)return this.currentLevel=a,this.propagateValues(),!1;e>>=1,t>>=1,a++}return this.currentLevel=a-1,!0},incrementValue:function(e){var t=this.levels[this.currentLevel];t.items[t.index]=e+1,this.propagateValues()},propagateValues:function(){for(var e=this.currentLevel,t=this.levels[e],r=t.items[t.index];--e>=0;)(t=this.levels[e]).items[t.index]=r},nextLevel:function(){var e=this.currentLevel,t=this.levels[e],r=t.items[t.index];return t.items[t.index]=255,!(--e<0)&&(this.currentLevel=e,(t=this.levels[e]).items[t.index]=r,!0)}},e}(),O=function(){var e=17,t=new Uint8Array([0,5,8,0,3,7,8,0,4,7,8,0,0,0,0,0,1,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8]),r=new Uint8Array([0,3,4,0,5,7,7,0,8,8,8,0,0,0,0,0,1,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8]),a=new Uint8Array([0,1,2,0,1,2,2,0,2,2,2,0,0,0,0,0,3,4,5,0,4,5,5,0,5,5,5,0,0,0,0,0,6,7,7,0,7,7,7,0,7,7,7,0,0,0,0,0,8,8,8,0,8,8,8,0,8,8,8,0,0,0,0,0,8,8,8,0,8,8,8,0,8,8,8]);function i(e,i,n,s,o){let c;this.width=e,this.height=i,c="HH"===n?a:"HL"===n?r:t,this.contextLabelTable=c;var l=e*i;let h;this.neighborsSignificance=new Uint8Array(l),this.coefficentsSign=new Uint8Array(l),h=o>14?new Uint32Array(l):o>6?new Uint16Array(l):new Uint8Array(l),this.coefficentsMagnitude=h,this.processingFlags=new Uint8Array(l);var u=new Uint8Array(l);if(0!==s)for(var d=0;d<l;d++)u[d]=s;this.bitsDecoded=u,this.reset()}return i.prototype={setDecoder:function(e){this.decoder=e},reset:function(){this.contexts=new Int8Array(19),this.contexts[0]=8,this.contexts[17]=92,this.contexts[18]=6},setNeighborsSignificance:function(e,t,r){var a,i=this.neighborsSignificance,n=this.width,s=this.height,o=t>0,c=t+1<n;e>0&&(a=r-n,o&&(i[a-1]+=16),c&&(i[a+1]+=16),i[a]+=4),e+1<s&&(a=r+n,o&&(i[a-1]+=16),c&&(i[a+1]+=16),i[a]+=4),o&&(i[r-1]+=1),c&&(i[r+1]+=1),i[r]|=128},runSignificancePropagationPass:function(){for(var e=this.decoder,t=this.width,r=this.height,a=this.coefficentsMagnitude,i=this.coefficentsSign,n=this.neighborsSignificance,s=this.processingFlags,o=this.contexts,c=this.contextLabelTable,l=this.bitsDecoded,h=0;h<r;h+=4)for(var u=0;u<t;u++)for(var d=h*t+u,f=0;f<4;f++,d+=t){var g=h+f;if(g>=r)break;if(s[d]&=-2,!a[d]&&n[d]){var p=c[n[d]];if(e.readBit(o,p)){var m=this.decodeSignBit(g,u,d);i[d]=m,a[d]=1,this.setNeighborsSignificance(g,u,d),s[d]|=2}l[d]++,s[d]|=1}}},decodeSignBit:function(e,t,r){var a,i,n,s,o,c,l=this.width,h=this.height,u=this.coefficentsMagnitude,d=this.coefficentsSign;s=t>0&&0!==u[r-1],t+1<l&&0!==u[r+1]?(n=d[r+1],a=s?1-n-(i=d[r-1]):1-n-n):a=s?1-(i=d[r-1])-i:0;var f=3*a;return s=e>0&&0!==u[r-l],e+1<h&&0!==u[r+l]?(n=d[r+l],a=s?1-n-(i=d[r-l])+f:1-n-n+f):a=s?1-(i=d[r-l])-i+f:f,a>=0?(o=9+a,c=this.decoder.readBit(this.contexts,o)):(o=9-a,c=1^this.decoder.readBit(this.contexts,o)),c},runMagnitudeRefinementPass:function(){for(var e,t=this.decoder,r=this.width,a=this.height,i=this.coefficentsMagnitude,n=this.neighborsSignificance,s=this.contexts,o=this.bitsDecoded,c=this.processingFlags,l=r*a,h=4*r,u=0;u<l;u=e){e=Math.min(l,u+h);for(var d=0;d<r;d++)for(var f=u+d;f<e;f+=r)if(i[f]&&0==(1&c[f])){var g=16;if(0!=(2&c[f]))c[f]^=2,g=0===(127&n[f])?15:14;var p=t.readBit(s,g);i[f]=i[f]<<1|p,o[f]++,c[f]|=1}}},runCleanupPass:function(){for(var t,r=this.decoder,a=this.width,i=this.height,n=this.neighborsSignificance,s=this.coefficentsMagnitude,o=this.coefficentsSign,c=this.contexts,l=this.contextLabelTable,h=this.bitsDecoded,u=this.processingFlags,d=a,f=2*a,g=3*a,p=0;p<i;p=t){t=Math.min(p+4,i);for(var m=p*a,b=p+3<i,y=0;y<a;y++){var w,v=m+y,S=0,k=v,x=p;if(b&&0===u[v]&&0===u[v+d]&&0===u[v+f]&&0===u[v+g]&&0===n[v]&&0===n[v+d]&&0===n[v+f]&&0===n[v+g]){if(!r.readBit(c,18)){h[v]++,h[v+d]++,h[v+f]++,h[v+g]++;continue}0!==(S=r.readBit(c,e)<<1|r.readBit(c,e))&&(x=p+S,k+=S*a),w=this.decodeSignBit(x,y,k),o[k]=w,s[k]=1,this.setNeighborsSignificance(x,y,k),u[k]|=2,k=v;for(var A=p;A<=x;A++,k+=a)h[k]++;S++}for(x=p+S;x<t;x++,k+=a)if(!s[k]&&0==(1&u[k])){var C=l[n[k]];1===r.readBit(c,C)&&(w=this.decodeSignBit(x,y,k),o[k]=w,s[k]=1,this.setNeighborsSignificance(x,y,k),u[k]|=2),h[k]++}}}},checkSegmentationSymbol:function(){var t=this.decoder,r=this.contexts;if(10!==(t.readBit(r,e)<<3|t.readBit(r,e)<<2|t.readBit(r,e)<<1|t.readBit(r,e)))throw new s("Invalid segmentation symbol")}},i}(),F=function(){function e(){}return e.prototype.calculate=function(e,t,r){for(var a=e[0],i=1,n=e.length;i<n;i++)a=this.iterate(a,e[i],t,r);return a},e.prototype.extend=function(e,t,r){var a=t-1,i=t+1,n=t+r-2,s=t+r;e[a--]=e[i++],e[s++]=e[n--],e[a--]=e[i++],e[s++]=e[n--],e[a--]=e[i++],e[s++]=e[n--],e[a]=e[i],e[s]=e[n]},e.prototype.iterate=function(e,t,r,a){var i,n,s,o,c,l,h=e.width,u=e.height,d=e.items,f=t.width,g=t.height,p=t.items;for(s=0,i=0;i<u;i++)for(o=2*i*f,n=0;n<h;n++,s++,o+=2)p[o]=d[s];d=e.items=null;var m=new Float32Array(f+8);if(1===f){if(0!=(1&r))for(l=0,s=0;l<g;l++,s+=f)p[s]*=.5}else for(l=0,s=0;l<g;l++,s+=f)m.set(p.subarray(s,s+f),4),this.extend(m,4,f),this.filter(m,4,f),p.set(m.subarray(4,4+f),s);var b=16,y=[];for(i=0;i<b;i++)y.push(new Float32Array(g+8));var w,v=0;if(e=4+g,1===g){if(0!=(1&a))for(c=0;c<f;c++)p[c]*=.5}else for(c=0;c<f;c++){if(0===v){for(b=Math.min(f-c,b),s=c,o=4;o<e;s+=f,o++)for(w=0;w<b;w++)y[w][o]=p[s+w];v=b}var S=y[--v];if(this.extend(S,4,g),this.filter(S,4,g),0===v)for(s=c-b+1,o=4;o<e;s+=f,o++)for(w=0;w<b;w++)p[s+w]=y[w][o]}return{width:f,height:g,items:p}},e}(),I=function(){function e(){F.call(this)}return e.prototype=Object.create(F.prototype),e.prototype.filter=function(e,t,r){var a,i,n,s,o=r>>1,c=-1.586134342059924,l=-.052980118572961,h=.882911075530934,u=.443506852043971,d=1.230174104914001;for(a=(t|=0)-3,i=o+4;i--;a+=2)e[a]*=.8128930661159609;for(n=u*e[(a=t-2)-1],i=o+3;i--&&(s=u*e[a+1],e[a]=d*e[a]-n-s,i--);a+=2)n=u*e[(a+=2)+1],e[a]=d*e[a]-n-s;for(n=h*e[(a=t-1)-1],i=o+2;i--&&(s=h*e[a+1],e[a]-=n+s,i--);a+=2)n=h*e[(a+=2)+1],e[a]-=n+s;for(n=l*e[(a=t)-1],i=o+1;i--&&(s=l*e[a+1],e[a]-=n+s,i--);a+=2)n=l*e[(a+=2)+1],e[a]-=n+s;if(0!==o)for(n=c*e[(a=t+1)-1],i=o;i--&&(s=c*e[a+1],e[a]-=n+s,i--);a+=2)n=c*e[(a+=2)+1],e[a]-=n+s},e}(),T=function(){function e(){F.call(this)}return e.prototype=Object.create(F.prototype),e.prototype.filter=function(e,t,r){var a,i,n=r>>1;for(a=t|=0,i=n+1;i--;a+=2)e[a]-=e[a-1]+e[a+1]+2>>2;for(a=t+1,i=n;i--;a+=2)e[a]+=e[a-1]+e[a+1]>>1},e}();return t}();t.JpxImage=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.calculateSHA384=f,t.PDF20=t.PDF17=t.CipherTransformFactory=t.calculateSHA512=t.calculateSHA256=t.calculateMD5=t.ARCFourCipher=t.AES256Cipher=t.AES128Cipher=void 0;var a=r(2),i=r(5),n=r(12);class s{constructor(e){this.a=0,this.b=0;var t,r,a=new Uint8Array(256),i=0,n=e.length;for(t=0;t<256;++t)a[t]=t;for(t=0;t<256;++t)i=i+(r=a[t])+e[t%n]&255,a[t]=a[i],a[i]=r;this.s=a}encryptBlock(e){var t,r,a,i=e.length,n=this.a,s=this.b,o=this.s,c=new Uint8Array(i);for(t=0;t<i;++t)a=o[s=s+(r=o[n=n+1&255])&255],o[n]=a,o[s]=r,c[t]=e[t]^o[r+a&255];return this.a=n,this.b=s,c}decryptBlock(e){return this.encryptBlock(e)}encrypt(e){return this.encryptBlock(e)}}t.ARCFourCipher=s;var o,c,l=(o=new Uint8Array([7,12,17,22,7,12,17,22,7,12,17,22,7,12,17,22,5,9,14,20,5,9,14,20,5,9,14,20,5,9,14,20,4,11,16,23,4,11,16,23,4,11,16,23,4,11,16,23,6,10,15,21,6,10,15,21,6,10,15,21,6,10,15,21]),c=new Int32Array([-680876936,-389564586,606105819,-1044525330,-176418897,1200080426,-1473231341,-45705983,1770035416,-1958414417,-42063,-1990404162,1804603682,-40341101,-1502002290,1236535329,-165796510,-1069501632,643717713,-373897302,-701558691,38016083,-660478335,-405537848,568446438,-1019803690,-187363961,1163531501,-1444681467,-51403784,1735328473,-1926607734,-378558,-2022574463,1839030562,-35309556,-1530992060,1272893353,-155497632,-1094730640,681279174,-358537222,-722521979,76029189,-640364487,-421815835,530742520,-995338651,-198630844,1126891415,-1416354905,-57434055,1700485571,-1894986606,-1051523,-2054922799,1873313359,-30611744,-1560198380,1309151649,-145523070,-1120210379,718787259,-343485551]),function(e,t,r){var a,i,n,s=1732584193,l=-271733879,h=-1732584194,u=271733878,d=r+72&-64,f=new Uint8Array(d);for(a=0;a<r;++a)f[a]=e[t++];for(f[a++]=128,n=d-8;a<n;)f[a++]=0;f[a++]=r<<3&255,f[a++]=r>>5&255,f[a++]=r>>13&255,f[a++]=r>>21&255,f[a++]=r>>>29&255,f[a++]=0,f[a++]=0,f[a++]=0;var g=new Int32Array(16);for(a=0;a<d;){for(i=0;i<16;++i,a+=4)g[i]=f[a]|f[a+1]<<8|f[a+2]<<16|f[a+3]<<24;var p,m,b=s,y=l,w=h,v=u;for(i=0;i<64;++i){i<16?(p=y&w|~y&v,m=i):i<32?(p=v&y|~v&w,m=5*i+1&15):i<48?(p=y^w^v,m=3*i+5&15):(p=w^(y|~v),m=7*i&15);var S=v,k=b+p+c[i]+g[m]|0,x=o[i];v=w,w=y,y=y+(k<<x|k>>>32-x)|0,b=S}s=s+b|0,l=l+y|0,h=h+w|0,u=u+v|0}return new Uint8Array([255&s,s>>8&255,s>>16&255,s>>>24&255,255&l,l>>8&255,l>>16&255,l>>>24&255,255&h,h>>8&255,h>>16&255,h>>>24&255,255&u,u>>8&255,u>>16&255,u>>>24&255])});t.calculateMD5=l;class h{constructor(e,t){this.high=0|e,this.low=0|t}and(e){this.high&=e.high,this.low&=e.low}xor(e){this.high^=e.high,this.low^=e.low}or(e){this.high|=e.high,this.low|=e.low}shiftRight(e){e>=32?(this.low=this.high>>>e-32|0,this.high=0):(this.low=this.low>>>e|this.high<<32-e,this.high=this.high>>>e|0)}shiftLeft(e){e>=32?(this.high=this.low<<e-32,this.low=0):(this.high=this.high<<e|this.low>>>32-e,this.low=this.low<<e)}rotateRight(e){var t,r;32&e?(r=this.low,t=this.high):(t=this.low,r=this.high),e&=31,this.low=t>>>e|r<<32-e,this.high=r>>>e|t<<32-e}not(){this.high=~this.high,this.low=~this.low}add(e){var t=(this.low>>>0)+(e.low>>>0),r=(this.high>>>0)+(e.high>>>0);t>4294967295&&(r+=1),this.low=0|t,this.high=0|r}copyTo(e,t){e[t]=this.high>>>24&255,e[t+1]=this.high>>16&255,e[t+2]=this.high>>8&255,e[t+3]=255&this.high,e[t+4]=this.low>>>24&255,e[t+5]=this.low>>16&255,e[t+6]=this.low>>8&255,e[t+7]=255&this.low}assign(e){this.high=e.high,this.low=e.low}}var u=function(){function e(e,t){return e>>>t|e<<32-t}function t(e,t,r){return e&t^~e&r}function r(e,t,r){return e&t^e&r^t&r}function a(t){return e(t,2)^e(t,13)^e(t,22)}function i(t){return e(t,6)^e(t,11)^e(t,25)}function n(t){return e(t,7)^e(t,18)^t>>>3}var s=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];return function(o,c,l){var h,u,d,f=1779033703,g=3144134277,p=1013904242,m=2773480762,b=1359893119,y=2600822924,w=528734635,v=1541459225,S=64*Math.ceil((l+9)/64),k=new Uint8Array(S);for(h=0;h<l;++h)k[h]=o[c++];for(k[h++]=128,d=S-8;h<d;)k[h++]=0;k[h++]=0,k[h++]=0,k[h++]=0,k[h++]=l>>>29&255,k[h++]=l>>21&255,k[h++]=l>>13&255,k[h++]=l>>5&255,k[h++]=l<<3&255;var x,A=new Uint32Array(64);for(h=0;h<S;){for(u=0;u<16;++u)A[u]=k[h]<<24|k[h+1]<<16|k[h+2]<<8|k[h+3],h+=4;for(u=16;u<64;++u)A[u]=0|(e(x=A[u-2],17)^e(x,19)^x>>>10)+A[u-7]+n(A[u-15])+A[u-16];var C,O,F=f,I=g,T=p,P=m,E=b,M=y,N=w,D=v;for(u=0;u<64;++u)C=D+i(E)+t(E,M,N)+s[u]+A[u],O=a(F)+r(F,I,T),D=N,N=M,M=E,E=P+C|0,P=T,T=I,I=F,F=C+O|0;f=f+F|0,g=g+I|0,p=p+T|0,m=m+P|0,b=b+E|0,y=y+M|0,w=w+N|0,v=v+D|0}return new Uint8Array([f>>24&255,f>>16&255,f>>8&255,255&f,g>>24&255,g>>16&255,g>>8&255,255&g,p>>24&255,p>>16&255,p>>8&255,255&p,m>>24&255,m>>16&255,m>>8&255,255&m,b>>24&255,b>>16&255,b>>8&255,255&b,y>>24&255,y>>16&255,y>>8&255,255&y,w>>24&255,w>>16&255,w>>8&255,255&w,v>>24&255,v>>16&255,v>>8&255,255&v])}}();t.calculateSHA256=u;var d=function(){function e(e,t,r,a,i){e.assign(t),e.and(r),i.assign(t),i.not(),i.and(a),e.xor(i)}function t(e,t,r,a,i){e.assign(t),e.and(r),i.assign(t),i.and(a),e.xor(i),i.assign(r),i.and(a),e.xor(i)}function r(e,t,r){e.assign(t),e.rotateRight(28),r.assign(t),r.rotateRight(34),e.xor(r),r.assign(t),r.rotateRight(39),e.xor(r)}function a(e,t,r){e.assign(t),e.rotateRight(14),r.assign(t),r.rotateRight(18),e.xor(r),r.assign(t),r.rotateRight(41),e.xor(r)}function i(e,t,r){e.assign(t),e.rotateRight(1),r.assign(t),r.rotateRight(8),e.xor(r),r.assign(t),r.shiftRight(7),e.xor(r)}function n(e,t,r){e.assign(t),e.rotateRight(19),r.assign(t),r.rotateRight(61),e.xor(r),r.assign(t),r.shiftRight(6),e.xor(r)}var s=[new h(1116352408,3609767458),new h(1899447441,602891725),new h(3049323471,3964484399),new h(3921009573,2173295548),new h(961987163,4081628472),new h(1508970993,3053834265),new h(2453635748,2937671579),new h(2870763221,3664609560),new h(3624381080,2734883394),new h(310598401,1164996542),new h(607225278,1323610764),new h(1426881987,3590304994),new h(1925078388,4068182383),new h(2162078206,991336113),new h(2614888103,633803317),new h(3248222580,3479774868),new h(3835390401,2666613458),new h(4022224774,944711139),new h(264347078,2341262773),new h(604807628,2007800933),new h(770255983,1495990901),new h(1249150122,1856431235),new h(1555081692,3175218132),new h(1996064986,2198950837),new h(2554220882,3999719339),new h(2821834349,766784016),new h(2952996808,2566594879),new h(3210313671,3203337956),new h(3336571891,1034457026),new h(3584528711,2466948901),new h(113926993,3758326383),new h(338241895,168717936),new h(666307205,1188179964),new h(773529912,1546045734),new h(1294757372,1522805485),new h(1396182291,2643833823),new h(1695183700,2343527390),new h(1986661051,1014477480),new h(2177026350,1206759142),new h(2456956037,344077627),new h(2730485921,1290863460),new h(2820302411,3158454273),new h(3259730800,3505952657),new h(3345764771,106217008),new h(3516065817,3606008344),new h(3600352804,1432725776),new h(4094571909,1467031594),new h(275423344,851169720),new h(430227734,3100823752),new h(506948616,1363258195),new h(659060556,3750685593),new h(883997877,3785050280),new h(958139571,3318307427),new h(1322822218,3812723403),new h(1537002063,2003034995),new h(1747873779,3602036899),new h(1955562222,1575990012),new h(2024104815,1125592928),new h(2227730452,2716904306),new h(2361852424,442776044),new h(2428436474,593698344),new h(2756734187,3733110249),new h(3204031479,2999351573),new h(3329325298,3815920427),new h(3391569614,3928383900),new h(3515267271,566280711),new h(3940187606,3454069534),new h(4118630271,4000239992),new h(116418474,1914138554),new h(174292421,2731055270),new h(289380356,3203993006),new h(460393269,320620315),new h(685471733,587496836),new h(852142971,1086792851),new h(1017036298,365543100),new h(1126000580,2618297676),new h(1288033470,3409855158),new h(1501505948,4234509866),new h(1607167915,987167468),new h(1816402316,1246189591)];return function(o,c,l,u=!1){var d,f,g,p,m,b,y,w;u?(d=new h(3418070365,3238371032),f=new h(1654270250,914150663),g=new h(2438529370,812702999),p=new h(355462360,4144912697),m=new h(1731405415,4290775857),b=new h(2394180231,1750603025),y=new h(3675008525,1694076839),w=new h(1203062813,3204075428)):(d=new h(1779033703,4089235720),f=new h(3144134277,2227873595),g=new h(1013904242,4271175723),p=new h(2773480762,1595750129),m=new h(1359893119,2917565137),b=new h(2600822924,725511199),y=new h(528734635,4215389547),w=new h(1541459225,327033209));var v,S,k,x=128*Math.ceil((l+17)/128),A=new Uint8Array(x);for(v=0;v<l;++v)A[v]=o[c++];for(A[v++]=128,k=x-16;v<k;)A[v++]=0;A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=0,A[v++]=l>>>29&255,A[v++]=l>>21&255,A[v++]=l>>13&255,A[v++]=l>>5&255,A[v++]=l<<3&255;var C=new Array(80);for(v=0;v<80;v++)C[v]=new h(0,0);var O,F,I=new h(0,0),T=new h(0,0),P=new h(0,0),E=new h(0,0),M=new h(0,0),N=new h(0,0),D=new h(0,0),B=new h(0,0),j=new h(0,0),L=new h(0,0),R=new h(0,0),_=new h(0,0);for(v=0;v<x;){for(S=0;S<16;++S)C[S].high=A[v]<<24|A[v+1]<<16|A[v+2]<<8|A[v+3],C[S].low=A[v+4]<<24|A[v+5]<<16|A[v+6]<<8|A[v+7],v+=8;for(S=16;S<80;++S)n(O=C[S],C[S-2],_),O.add(C[S-7]),i(R,C[S-15],_),O.add(R),O.add(C[S-16]);for(I.assign(d),T.assign(f),P.assign(g),E.assign(p),M.assign(m),N.assign(b),D.assign(y),B.assign(w),S=0;S<80;++S)j.assign(B),a(R,M,_),j.add(R),e(R,M,N,D,_),j.add(R),j.add(s[S]),j.add(C[S]),r(L,I,_),t(R,I,T,P,_),L.add(R),O=B,B=D,D=N,N=M,E.add(j),M=E,E=P,P=T,T=I,O.assign(j),O.add(L),I=O;d.add(I),f.add(T),g.add(P),p.add(E),m.add(M),b.add(N),y.add(D),w.add(B)}return u?(F=new Uint8Array(48),d.copyTo(F,0),f.copyTo(F,8),g.copyTo(F,16),p.copyTo(F,24),m.copyTo(F,32),b.copyTo(F,40)):(F=new Uint8Array(64),d.copyTo(F,0),f.copyTo(F,8),g.copyTo(F,16),p.copyTo(F,24),m.copyTo(F,32),b.copyTo(F,40),y.copyTo(F,48),w.copyTo(F,56)),F}}();function f(e,t,r){return d(e,t,r,!0)}t.calculateSHA512=d;class g{decryptBlock(e){return e}encrypt(e){return e}}class p{constructor(){this.constructor===p&&(0,a.unreachable)("Cannot initialize AESBaseCipher."),this._s=new Uint8Array([99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22]),this._inv_s=new Uint8Array([82,9,106,213,48,54,165,56,191,64,163,158,129,243,215,251,124,227,57,130,155,47,255,135,52,142,67,68,196,222,233,203,84,123,148,50,166,194,35,61,238,76,149,11,66,250,195,78,8,46,161,102,40,217,36,178,118,91,162,73,109,139,209,37,114,248,246,100,134,104,152,22,212,164,92,204,93,101,182,146,108,112,72,80,253,237,185,218,94,21,70,87,167,141,157,132,144,216,171,0,140,188,211,10,247,228,88,5,184,179,69,6,208,44,30,143,202,63,15,2,193,175,189,3,1,19,138,107,58,145,17,65,79,103,220,234,151,242,207,206,240,180,230,115,150,172,116,34,231,173,53,133,226,249,55,232,28,117,223,110,71,241,26,113,29,41,197,137,111,183,98,14,170,24,190,27,252,86,62,75,198,210,121,32,154,219,192,254,120,205,90,244,31,221,168,51,136,7,199,49,177,18,16,89,39,128,236,95,96,81,127,169,25,181,74,13,45,229,122,159,147,201,156,239,160,224,59,77,174,42,245,176,200,235,187,60,131,83,153,97,23,43,4,126,186,119,214,38,225,105,20,99,85,33,12,125]),this._mix=new Uint32Array([0,235474187,470948374,303765277,941896748,908933415,607530554,708780849,1883793496,2118214995,1817866830,1649639237,1215061108,1181045119,1417561698,1517767529,3767586992,4003061179,4236429990,4069246893,3635733660,3602770327,3299278474,3400528769,2430122216,2664543715,2362090238,2193862645,2835123396,2801107407,3035535058,3135740889,3678124923,3576870512,3341394285,3374361702,3810496343,3977675356,4279080257,4043610186,2876494627,2776292904,3076639029,3110650942,2472011535,2640243204,2403728665,2169303058,1001089995,899835584,666464733,699432150,59727847,226906860,530400753,294930682,1273168787,1172967064,1475418501,1509430414,1942435775,2110667444,1876241833,1641816226,2910219766,2743034109,2976151520,3211623147,2505202138,2606453969,2302690252,2269728455,3711829422,3543599269,3240894392,3475313331,3843699074,3943906441,4178062228,4144047775,1306967366,1139781709,1374988112,1610459739,1975683434,2076935265,1775276924,1742315127,1034867998,866637845,566021896,800440835,92987698,193195065,429456164,395441711,1984812685,2017778566,1784663195,1683407248,1315562145,1080094634,1383856311,1551037884,101039829,135050206,437757123,337553864,1042385657,807962610,573804783,742039012,2531067453,2564033334,2328828971,2227573024,2935566865,2700099354,3001755655,3168937228,3868552805,3902563182,4203181171,4102977912,3736164937,3501741890,3265478751,3433712980,1106041591,1340463100,1576976609,1408749034,2043211483,2009195472,1708848333,1809054150,832877231,1068351396,766945465,599762354,159417987,126454664,361929877,463180190,2709260871,2943682380,3178106961,3009879386,2572697195,2538681184,2236228733,2336434550,3509871135,3745345300,3441850377,3274667266,3910161971,3877198648,4110568485,4211818798,2597806476,2497604743,2261089178,2295101073,2733856160,2902087851,3202437046,2968011453,3936291284,3835036895,4136440770,4169408201,3535486456,3702665459,3467192302,3231722213,2051518780,1951317047,1716890410,1750902305,1113818384,1282050075,1584504582,1350078989,168810852,67556463,371049330,404016761,841739592,1008918595,775550814,540080725,3969562369,3801332234,4035489047,4269907996,3569255213,3669462566,3366754619,3332740144,2631065433,2463879762,2160117071,2395588676,2767645557,2868897406,3102011747,3069049960,202008497,33778362,270040487,504459436,875451293,975658646,675039627,641025152,2084704233,1917518562,1615861247,1851332852,1147550661,1248802510,1484005843,1451044056,933301370,967311729,733156972,632953703,260388950,25965917,328671808,496906059,1206477858,1239443753,1543208500,1441952575,2144161806,1908694277,1675577880,1842759443,3610369226,3644379585,3408119516,3307916247,4011190502,3776767469,4077384432,4245618683,2809771154,2842737049,3144396420,3043140495,2673705150,2438237621,2203032232,2370213795]),this._mixCol=new Uint8Array(256);for(let e=0;e<256;e++)this._mixCol[e]=e<128?e<<1:e<<1^27;this.buffer=new Uint8Array(16),this.bufferPosition=0}_expandKey(e){(0,a.unreachable)("Cannot call `_expandKey` on the base class")}_decrypt(e,t){let r,a,i;const n=new Uint8Array(16);n.set(e);for(let e=0,r=this._keySize;e<16;++e,++r)n[e]^=t[r];for(let e=this._cyclesOfRepetition-1;e>=1;--e){r=n[13],n[13]=n[9],n[9]=n[5],n[5]=n[1],n[1]=r,r=n[14],a=n[10],n[14]=n[6],n[10]=n[2],n[6]=r,n[2]=a,r=n[15],a=n[11],i=n[7],n[15]=n[3],n[11]=r,n[7]=a,n[3]=i;for(let e=0;e<16;++e)n[e]=this._inv_s[n[e]];for(let r=0,a=16*e;r<16;++r,++a)n[r]^=t[a];for(let e=0;e<16;e+=4){const t=this._mix[n[e]],a=this._mix[n[e+1]],i=this._mix[n[e+2]],s=this._mix[n[e+3]];r=t^a>>>8^a<<24^i>>>16^i<<16^s>>>24^s<<8,n[e]=r>>>24&255,n[e+1]=r>>16&255,n[e+2]=r>>8&255,n[e+3]=255&r}}r=n[13],n[13]=n[9],n[9]=n[5],n[5]=n[1],n[1]=r,r=n[14],a=n[10],n[14]=n[6],n[10]=n[2],n[6]=r,n[2]=a,r=n[15],a=n[11],i=n[7],n[15]=n[3],n[11]=r,n[7]=a,n[3]=i;for(let e=0;e<16;++e)n[e]=this._inv_s[n[e]],n[e]^=t[e];return n}_encrypt(e,t){const r=this._s;let a,i,n;const s=new Uint8Array(16);s.set(e);for(let e=0;e<16;++e)s[e]^=t[e];for(let e=1;e<this._cyclesOfRepetition;e++){for(let e=0;e<16;++e)s[e]=r[s[e]];n=s[1],s[1]=s[5],s[5]=s[9],s[9]=s[13],s[13]=n,n=s[2],i=s[6],s[2]=s[10],s[6]=s[14],s[10]=n,s[14]=i,n=s[3],i=s[7],a=s[11],s[3]=s[15],s[7]=n,s[11]=i,s[15]=a;for(let e=0;e<16;e+=4){const t=s[e+0],r=s[e+1],i=s[e+2],n=s[e+3];a=t^r^i^n,s[e+0]^=a^this._mixCol[t^r],s[e+1]^=a^this._mixCol[r^i],s[e+2]^=a^this._mixCol[i^n],s[e+3]^=a^this._mixCol[n^t]}for(let r=0,a=16*e;r<16;++r,++a)s[r]^=t[a]}for(let e=0;e<16;++e)s[e]=r[s[e]];n=s[1],s[1]=s[5],s[5]=s[9],s[9]=s[13],s[13]=n,n=s[2],i=s[6],s[2]=s[10],s[6]=s[14],s[10]=n,s[14]=i,n=s[3],i=s[7],a=s[11],s[3]=s[15],s[7]=n,s[11]=i,s[15]=a;for(let e=0,r=this._keySize;e<16;++e,++r)s[e]^=t[r];return s}_decryptBlock2(e,t){const r=e.length;let a=this.buffer,i=this.bufferPosition;const n=[];let s=this.iv;for(let t=0;t<r;++t){if(a[i]=e[t],++i,i<16)continue;const r=this._decrypt(a,this._key);for(let e=0;e<16;++e)r[e]^=s[e];s=a,n.push(r),a=new Uint8Array(16),i=0}if(this.buffer=a,this.bufferLength=i,this.iv=s,0===n.length)return new Uint8Array(0);let o=16*n.length;if(t){const e=n[n.length-1];let t=e[15];if(t<=16){for(let r=15,a=16-t;r>=a;--r)if(e[r]!==t){t=0;break}o-=t,n[n.length-1]=e.subarray(0,16-t)}}const c=new Uint8Array(o);for(let e=0,t=0,r=n.length;e<r;++e,t+=16)c.set(n[e],t);return c}decryptBlock(e,t,r=null){const a=e.length,i=this.buffer;let n=this.bufferPosition;if(r)this.iv=r;else{for(let t=0;n<16&&t<a;++t,++n)i[n]=e[t];if(n<16)return this.bufferLength=n,new Uint8Array(0);this.iv=i,e=e.subarray(16)}return this.buffer=new Uint8Array(16),this.bufferLength=0,this.decryptBlock=this._decryptBlock2,this.decryptBlock(e,t)}encrypt(e,t){const r=e.length;let a=this.buffer,i=this.bufferPosition;const n=[];t||(t=new Uint8Array(16));for(let s=0;s<r;++s){if(a[i]=e[s],++i,i<16)continue;for(let e=0;e<16;++e)a[e]^=t[e];const r=this._encrypt(a,this._key);t=r,n.push(r),a=new Uint8Array(16),i=0}if(this.buffer=a,this.bufferLength=i,this.iv=t,0===n.length)return new Uint8Array(0);const s=16*n.length,o=new Uint8Array(s);for(let e=0,t=0,r=n.length;e<r;++e,t+=16)o.set(n[e],t);return o}}class m extends p{constructor(e){super(),this._cyclesOfRepetition=10,this._keySize=160,this._rcon=new Uint8Array([141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141]),this._key=this._expandKey(e)}_expandKey(e){const t=this._s,r=this._rcon,a=new Uint8Array(176);a.set(e);for(let e=16,i=1;e<176;++i){let n=a[e-3],s=a[e-2],o=a[e-1],c=a[e-4];n=t[n],s=t[s],o=t[o],c=t[c],n^=r[i];for(let t=0;t<4;++t)a[e]=n^=a[e-16],e++,a[e]=s^=a[e-16],e++,a[e]=o^=a[e-16],e++,a[e]=c^=a[e-16],e++}return a}}t.AES128Cipher=m;class b extends p{constructor(e){super(),this._cyclesOfRepetition=14,this._keySize=224,this._key=this._expandKey(e)}_expandKey(e){const t=this._s,r=new Uint8Array(240);r.set(e);let a,i,n,s,o=1;for(let e=32,c=1;e<240;++c){e%32==16?(a=t[a],i=t[i],n=t[n],s=t[s]):e%32==0&&(a=r[e-3],i=r[e-2],n=r[e-1],s=r[e-4],a=t[a],i=t[i],n=t[n],s=t[s],a^=o,(o<<=1)>=256&&(o=255&(27^o)));for(let t=0;t<4;++t)r[e]=a^=r[e-32],e++,r[e]=i^=r[e-32],e++,r[e]=n^=r[e-32],e++,r[e]=s^=r[e-32],e++}return r}}t.AES256Cipher=b;class y{checkOwnerPassword(e,t,r,i){var n=new Uint8Array(e.length+56);n.set(e,0),n.set(t,e.length),n.set(r,e.length+t.length);var s=u(n,0,n.length);return(0,a.isArrayEqual)(s,i)}checkUserPassword(e,t,r){var i=new Uint8Array(e.length+8);i.set(e,0),i.set(t,e.length);var n=u(i,0,i.length);return(0,a.isArrayEqual)(n,r)}getOwnerKey(e,t,r,a){var i=new Uint8Array(e.length+56);i.set(e,0),i.set(t,e.length),i.set(r,e.length+t.length);var n=u(i,0,i.length);return new b(n).decryptBlock(a,!1,new Uint8Array(16))}getUserKey(e,t,r){var a=new Uint8Array(e.length+8);a.set(e,0),a.set(t,e.length);var i=u(a,0,a.length);return new b(i).decryptBlock(r,!1,new Uint8Array(16))}}t.PDF17=y;var w=function(){function e(e,t,r){for(var a=u(t,0,t.length).subarray(0,32),i=[0],n=0;n<64||i[i.length-1]>n-32;){const t=e.length+a.length+r.length,g=new Uint8Array(t);let p=0;g.set(e,p),p+=e.length,g.set(a,p),p+=a.length,g.set(r,p);for(var s=new Uint8Array(64*t),o=0,c=0;o<64;o++,c+=t)s.set(g,c);i=new m(a.subarray(0,16)).encrypt(s,a.subarray(16,32));for(var l=0,h=0;h<16;h++)l*=1,l%=3,l+=(i[h]>>>0)%3,l%=3;0===l?a=u(i,0,i.length):1===l?a=f(i,0,i.length):2===l&&(a=d(i,0,i.length)),n++}return a.subarray(0,32)}return class{hash(t,r,a){return e(t,r,a)}checkOwnerPassword(t,r,i,n){var s=new Uint8Array(t.length+56);s.set(t,0),s.set(r,t.length),s.set(i,t.length+r.length);var o=e(t,s,i);return(0,a.isArrayEqual)(o,n)}checkUserPassword(t,r,i){var n=new Uint8Array(t.length+8);n.set(t,0),n.set(r,t.length);var s=e(t,n,[]);return(0,a.isArrayEqual)(s,i)}getOwnerKey(t,r,a,i){var n=new Uint8Array(t.length+56);n.set(t,0),n.set(r,t.length),n.set(a,t.length+r.length);var s=e(t,n,a);return new b(s).decryptBlock(i,!1,new Uint8Array(16))}getUserKey(t,r,a){var i=new Uint8Array(t.length+8);i.set(t,0),i.set(r,t.length);var n=e(t,i,[]);return new b(n).decryptBlock(a,!1,new Uint8Array(16))}}}();t.PDF20=w;class v{constructor(e,t){this.StringCipherConstructor=e,this.StreamCipherConstructor=t}createStream(e,t){var r=new this.StreamCipherConstructor;return new n.DecryptStream(e,t,(function(e,t){return r.decryptBlock(e,t)}))}decryptString(e){var t=new this.StringCipherConstructor,r=(0,a.stringToBytes)(e);return r=t.decryptBlock(r,!0),(0,a.bytesToString)(r)}encryptString(e){const t=new this.StringCipherConstructor;if(t instanceof p){const r=e.length,i=16-r%16;16!==i&&(e=e.padEnd(16*Math.ceil(r/16),String.fromCharCode(i)));const n=new Uint8Array(16);if("undefined"!=typeof crypto)crypto.getRandomValues(n);else for(let e=0;e<16;e++)n[e]=Math.floor(256*Math.random());let s=(0,a.stringToBytes)(e);s=t.encrypt(s,n);const o=new Uint8Array(16+s.length);return o.set(n),o.set(s,16),(0,a.bytesToString)(o)}let r=(0,a.stringToBytes)(e);return r=t.encrypt(r),(0,a.bytesToString)(r)}}var S=function(){var e=new Uint8Array([40,191,78,94,78,117,138,65,100,0,78,86,255,250,1,8,46,46,0,182,208,104,62,128,47,12,169,254,100,83,105,122]);function t(t,r,a,i,n,o,c,h){var u,d,f=40+a.length+t.length,g=new Uint8Array(f),p=0;if(r)for(d=Math.min(32,r.length);p<d;++p)g[p]=r[p];for(u=0;p<32;)g[p++]=e[u++];for(u=0,d=a.length;u<d;++u)g[p++]=a[u];for(g[p++]=255&n,g[p++]=n>>8&255,g[p++]=n>>16&255,g[p++]=n>>>24&255,u=0,d=t.length;u<d;++u)g[p++]=t[u];o>=4&&!h&&(g[p++]=255,g[p++]=255,g[p++]=255,g[p++]=255);var m=l(g,0,p),b=c>>3;if(o>=3)for(u=0;u<50;++u)m=l(m,0,b);var y,w=m.subarray(0,b);if(o>=3){for(p=0;p<32;++p)g[p]=e[p];for(u=0,d=t.length;u<d;++u)g[p++]=t[u];y=new s(w).encryptBlock(l(g,0,p)),d=w.length;var v,S=new Uint8Array(d);for(u=1;u<=19;++u){for(v=0;v<d;++v)S[v]=w[v]^u;y=new s(S).encryptBlock(y)}for(u=0,d=y.length;u<d;++u)if(i[u]!==y[u])return null}else for(u=0,d=(y=new s(w).encryptBlock(e)).length;u<d;++u)if(i[u]!==y[u])return null;return w}var r=i.Name.get("Identity");function n(e,t,r,a=!1){var i,n,s=new Uint8Array(r.length+9);for(i=0,n=r.length;i<n;++i)s[i]=r[i];return s[i++]=255&e,s[i++]=e>>8&255,s[i++]=e>>16&255,s[i++]=255&t,s[i++]=t>>8&255,a&&(s[i++]=115,s[i++]=65,s[i++]=108,s[i++]=84),l(s,0,i).subarray(0,Math.min(r.length+5,16))}function o(e,t,r,o,c){if(!(0,i.isName)(t))throw new a.FormatError("Invalid crypt filter name.");var l,h=e.get(t.name);if(null!=h&&(l=h.get("CFM")),!l||"None"===l.name)return function(){return new g};if("V2"===l.name)return function(){return new s(n(r,o,c,!1))};if("AESV2"===l.name)return function(){return new m(n(r,o,c,!0))};if("AESV3"===l.name)return function(){return new b(c)};throw new a.FormatError("Unknown crypto method")}return class{constructor(n,o,c){var h=n.get("Filter");if(!(0,i.isName)(h,"Standard"))throw new a.FormatError("unknown encryption method");this.dict=n;var u=n.get("V");if(!Number.isInteger(u)||1!==u&&2!==u&&4!==u&&5!==u)throw new a.FormatError("unsupported encryption algorithm");this.algorithm=u;var d=n.get("Length");if(!d)if(u<=3)d=40;else{var f=n.get("CF"),g=n.get("StmF");if((0,i.isDict)(f)&&(0,i.isName)(g)){f.suppressEncryption=!0;var p=f.get(g.name);(d=p&&p.get("Length")||128)<40&&(d<<=3)}}if(!Number.isInteger(d)||d<40||d%8!=0)throw new a.FormatError("invalid key length");var m=(0,a.stringToBytes)(n.get("O")).subarray(0,32),b=(0,a.stringToBytes)(n.get("U")).subarray(0,32),v=n.get("P"),S=n.get("R"),k=(4===u||5===u)&&!1!==n.get("EncryptMetadata");this.encryptMetadata=k;var x,A,C=(0,a.stringToBytes)(o);if(c){if(6===S)try{c=(0,a.utf8StringToString)(c)}catch(e){(0,a.warn)("CipherTransformFactory: Unable to convert UTF8 encoded password.")}x=(0,a.stringToBytes)(c)}if(5!==u)A=t(C,x,m,b,v,S,d,k);else{var O=(0,a.stringToBytes)(n.get("O")).subarray(32,40),F=(0,a.stringToBytes)(n.get("O")).subarray(40,48),I=(0,a.stringToBytes)(n.get("U")).subarray(0,48),T=(0,a.stringToBytes)(n.get("U")).subarray(32,40),P=(0,a.stringToBytes)(n.get("U")).subarray(40,48),E=(0,a.stringToBytes)(n.get("OE")),M=(0,a.stringToBytes)(n.get("UE"));(0,a.stringToBytes)(n.get("Perms"));A=function(e,t,r,a,i,n,s,o,c,l,h,u){if(t){var d=Math.min(127,t.length);t=t.subarray(0,d)}else t=[];var f;return(f=6===e?new w:new y).checkUserPassword(t,o,s)?f.getUserKey(t,c,h):t.length&&f.checkOwnerPassword(t,a,n,r)?f.getOwnerKey(t,i,n,l):null}(S,x,m,O,F,I,b,T,P,E,M)}if(!A&&!c)throw new a.PasswordException("No password given",a.PasswordResponses.NEED_PASSWORD);if(!A&&c&&(A=t(C,function(t,r,a,i){var n,o,c=new Uint8Array(32),h=0;for(o=Math.min(32,t.length);h<o;++h)c[h]=t[h];for(n=0;h<32;)c[h++]=e[n++];var u,d=l(c,0,h),f=i>>3;if(a>=3)for(n=0;n<50;++n)d=l(d,0,d.length);if(a>=3){u=r;var g,p=new Uint8Array(f);for(n=19;n>=0;n--){for(g=0;g<f;++g)p[g]=d[g]^n;u=new s(p).encryptBlock(u)}}else u=new s(d.subarray(0,f)).encryptBlock(r);return u}(x,m,S,d),m,b,v,S,d,k)),!A)throw new a.PasswordException("Incorrect Password",a.PasswordResponses.INCORRECT_PASSWORD);if(this.encryptionKey=A,u>=4){var N=n.get("CF");(0,i.isDict)(N)&&(N.suppressEncryption=!0),this.cf=N,this.stmf=n.get("StmF")||r,this.strf=n.get("StrF")||r,this.eff=n.get("EFF")||this.stmf}}createCipherTransform(e,t){if(4===this.algorithm||5===this.algorithm)return new v(o(this.cf,this.stmf,e,t,this.encryptionKey),o(this.cf,this.strf,e,t,this.encryptionKey));var r=n(e,t,this.encryptionKey,!1),a=function(){return new s(r)};return new v(a,a)}}}();t.CipherTransformFactory=S},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ColorSpace=void 0;var a=r(2),i=r(5),n=r(8);class s{constructor(e,t){this.constructor===s&&(0,a.unreachable)("Cannot initialize ColorSpace."),this.name=e,this.numComps=t}getRgb(e,t){const r=new Uint8ClampedArray(3);return this.getRgbItem(e,t,r,0),r}getRgbItem(e,t,r,i){(0,a.unreachable)("Should not call ColorSpace.getRgbItem")}getRgbBuffer(e,t,r,i,n,s,o){(0,a.unreachable)("Should not call ColorSpace.getRgbBuffer")}getOutputLength(e,t){(0,a.unreachable)("Should not call ColorSpace.getOutputLength")}isPassthrough(e){return!1}isDefaultDecode(e,t){return s.isDefaultDecode(e,this.numComps)}fillRgb(e,t,r,a,i,n,s,o,c){const l=t*r;let h=null;const u=1<<s,d=r!==i||t!==a;if(this.isPassthrough(s))h=o;else if(1===this.numComps&&l>u&&"DeviceGray"!==this.name&&"DeviceRGB"!==this.name){const t=s<=8?new Uint8Array(u):new Uint16Array(u);for(let e=0;e<u;e++)t[e]=e;const r=new Uint8ClampedArray(3*u);if(this.getRgbBuffer(t,0,u,r,0,s,0),d){h=new Uint8Array(3*l);let e=0;for(let t=0;t<l;++t){const a=3*o[t];h[e++]=r[a],h[e++]=r[a+1],h[e++]=r[a+2]}}else{let t=0;for(let a=0;a<l;++a){const i=3*o[a];e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i+2],t+=c}}}else d?(h=new Uint8ClampedArray(3*l),this.getRgbBuffer(o,0,l,h,0,s,0)):this.getRgbBuffer(o,0,a*n,e,0,s,c);if(h)if(d)!function(e,t,r,a,i,n,s){s=1!==s?0:s;const o=r/i,c=a/n;let l,h=0;const u=new Uint16Array(i),d=3*r;for(let e=0;e<i;e++)u[e]=3*Math.floor(e*o);for(let r=0;r<n;r++){const a=Math.floor(r*c)*d;for(let r=0;r<i;r++)l=a+u[r],t[h++]=e[l++],t[h++]=e[l++],t[h++]=e[l++],h+=s}}(h,e,t,r,a,i,c);else{let t=0,r=0;for(let i=0,s=a*n;i<s;i++)e[t++]=h[r++],e[t++]=h[r++],e[t++]=h[r++],t+=c}}get usesZeroToOneRange(){return(0,a.shadow)(this,"usesZeroToOneRange",!0)}static _cache(e,t,r,a){if(!r)throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');if(!a)throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');let n,s;e instanceof i.Ref&&(s=e,e=t.fetch(e)),e instanceof i.Name&&(n=e.name),(n||s)&&r.set(n,s,a)}static getCached(e,t,r){if(!r)throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');if(e instanceof i.Ref){const a=r.getByRef(e);if(a)return a;try{e=t.fetch(e)}catch(e){if(e instanceof n.MissingDataException)throw e}}if(e instanceof i.Name){const t=r.getByName(e.name);if(t)return t}return null}static async parseAsync({cs:e,xref:t,resources:r=null,pdfFunctionFactory:a,localColorSpaceCache:i}){const n=this._parse(e,t,r,a);return this._cache(e,t,i,n),n}static parse({cs:e,xref:t,resources:r=null,pdfFunctionFactory:a,localColorSpaceCache:i}){const n=this.getCached(e,t,i);if(n)return n;const s=this._parse(e,t,r,a);return this._cache(e,t,i,s),s}static _parse(e,t,r=null,n){if(e=t.fetchIfRef(e),(0,i.isName)(e))switch(e.name){case"DeviceGray":case"G":return this.singletons.gray;case"DeviceRGB":case"RGB":return this.singletons.rgb;case"DeviceCMYK":case"CMYK":return this.singletons.cmyk;case"Pattern":return new c(null);default:if((0,i.isDict)(r)){const a=r.get("ColorSpace");if((0,i.isDict)(a)){const s=a.get(e.name);if(s){if((0,i.isName)(s))return this._parse(s,t,r,n);e=s;break}}}throw new a.FormatError(`Unrecognized ColorSpace: ${e.name}`)}if(Array.isArray(e)){const i=t.fetchIfRef(e[0]).name;let s,h,u,d,m,b;switch(i){case"DeviceGray":case"G":return this.singletons.gray;case"DeviceRGB":case"RGB":return this.singletons.rgb;case"DeviceCMYK":case"CMYK":return this.singletons.cmyk;case"CalGray":return s=t.fetchIfRef(e[1]),d=s.getArray("WhitePoint"),m=s.getArray("BlackPoint"),b=s.get("Gamma"),new f(d,m,b);case"CalRGB":s=t.fetchIfRef(e[1]),d=s.getArray("WhitePoint"),m=s.getArray("BlackPoint"),b=s.getArray("Gamma");const y=s.getArray("Matrix");return new g(d,m,b,y);case"ICCBased":const w=t.fetchIfRef(e[1]).dict;h=w.get("N");const v=w.get("Alternate");if(v){const e=this._parse(v,t,r,n);if(e.numComps===h)return e;(0,a.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.")}if(1===h)return this.singletons.gray;if(3===h)return this.singletons.rgb;if(4===h)return this.singletons.cmyk;break;case"Pattern":return u=e[1]||null,u&&(u=this._parse(u,t,r,n)),new c(u);case"Indexed":case"I":u=this._parse(e[1],t,r,n);const S=t.fetchIfRef(e[2])+1,k=t.fetchIfRef(e[3]);return new l(u,S,k);case"Separation":case"DeviceN":const x=t.fetchIfRef(e[1]);h=Array.isArray(x)?x.length:1,u=this._parse(e[2],t,r,n);const A=n.create(e[3]);return new o(h,u,A);case"Lab":s=t.fetchIfRef(e[1]),d=s.getArray("WhitePoint"),m=s.getArray("BlackPoint");const C=s.getArray("Range");return new p(d,m,C);default:throw new a.FormatError(`Unimplemented ColorSpace object: ${i}`)}}throw new a.FormatError(`Unrecognized ColorSpace object: ${e}`)}static isDefaultDecode(e,t){if(!Array.isArray(e))return!0;if(2*t!==e.length)return(0,a.warn)("The decode map is not the correct length"),!0;for(let t=0,r=e.length;t<r;t+=2)if(0!==e[t]||1!==e[t+1])return!1;return!0}static get singletons(){return(0,a.shadow)(this,"singletons",{get gray(){return(0,a.shadow)(this,"gray",new h)},get rgb(){return(0,a.shadow)(this,"rgb",new u)},get cmyk(){return(0,a.shadow)(this,"cmyk",new d)}})}}t.ColorSpace=s;class o extends s{constructor(e,t,r){super("Alternate",e),this.base=t,this.tintFn=r,this.tmpBuf=new Float32Array(t.numComps)}getRgbItem(e,t,r,a){const i=this.tmpBuf;this.tintFn(e,t,i,0),this.base.getRgbItem(i,0,r,a)}getRgbBuffer(e,t,r,a,i,n,s){const o=this.tintFn,c=this.base,l=1/((1<<n)-1),h=c.numComps,u=c.usesZeroToOneRange,d=(c.isPassthrough(8)||!u)&&0===s;let f=d?i:0;const g=d?a:new Uint8ClampedArray(h*r),p=this.numComps,m=new Float32Array(p),b=new Float32Array(h);let y,w;for(y=0;y<r;y++){for(w=0;w<p;w++)m[w]=e[t++]*l;if(o(m,0,b,0),u)for(w=0;w<h;w++)g[f++]=255*b[w];else c.getRgbItem(b,0,g,f),f+=h}d||c.getRgbBuffer(g,0,r,a,i,8,s)}getOutputLength(e,t){return this.base.getOutputLength(e*this.base.numComps/this.numComps,t)}}class c extends s{constructor(e){super("Pattern",null),this.base=e}isDefaultDecode(e,t){(0,a.unreachable)("Should not call PatternCS.isDefaultDecode")}}class l extends s{constructor(e,t,r){super("Indexed",1),this.base=e,this.highVal=t;const n=e.numComps*t;if(this.lookup=new Uint8Array(n),(0,i.isStream)(r)){const e=r.getBytes(n);this.lookup.set(e)}else{if("string"!=typeof r)throw new a.FormatError(`IndexedCS - unrecognized lookup table: ${r}`);for(let e=0;e<n;++e)this.lookup[e]=255&r.charCodeAt(e)}}getRgbItem(e,t,r,a){const i=this.base.numComps,n=e[t]*i;this.base.getRgbBuffer(this.lookup,n,1,r,a,8,0)}getRgbBuffer(e,t,r,a,i,n,s){const o=this.base,c=o.numComps,l=o.getOutputLength(c,s),h=this.lookup;for(let n=0;n<r;++n){const r=e[t++]*c;o.getRgbBuffer(h,r,1,a,i,8,s),i+=l}}getOutputLength(e,t){return this.base.getOutputLength(e*this.base.numComps,t)}isDefaultDecode(e,t){return!Array.isArray(e)||(2!==e.length?((0,a.warn)("Decode map length is not correct"),!0):!Number.isInteger(t)||t<1?((0,a.warn)("Bits per component is not correct"),!0):0===e[0]&&e[1]===(1<<t)-1)}}class h extends s{constructor(){super("DeviceGray",1)}getRgbItem(e,t,r,a){const i=255*e[t];r[a]=r[a+1]=r[a+2]=i}getRgbBuffer(e,t,r,a,i,n,s){const o=255/((1<<n)-1);let c=t,l=i;for(let t=0;t<r;++t){const t=o*e[c++];a[l++]=t,a[l++]=t,a[l++]=t,l+=s}}getOutputLength(e,t){return e*(3+t)}}class u extends s{constructor(){super("DeviceRGB",3)}getRgbItem(e,t,r,a){r[a]=255*e[t],r[a+1]=255*e[t+1],r[a+2]=255*e[t+2]}getRgbBuffer(e,t,r,a,i,n,s){if(8===n&&0===s)return void a.set(e.subarray(t,t+3*r),i);const o=255/((1<<n)-1);let c=t,l=i;for(let t=0;t<r;++t)a[l++]=o*e[c++],a[l++]=o*e[c++],a[l++]=o*e[c++],l+=s}getOutputLength(e,t){return e*(3+t)/3|0}isPassthrough(e){return 8===e}}const d=function(){function e(e,t,r,a,i){const n=e[t]*r,s=e[t+1]*r,o=e[t+2]*r,c=e[t+3]*r;a[i]=255+n*(-4.387332384609988*n+54.48615194189176*s+18.82290502165302*o+212.25662451639585*c-285.2331026137004)+s*(1.7149763477362134*s-5.6096736904047315*o+-17.873870861415444*c-5.497006427196366)+o*(-2.5217340131683033*o-21.248923337353073*c+17.5119270841813)+c*(-21.86122147463605*c-189.48180835922747),a[i+1]=255+n*(8.841041422036149*n+60.118027045597366*s+6.871425592049007*o+31.159100130055922*c-79.2970844816548)+s*(-15.310361306967817*s+17.575251261109482*o+131.35250912493976*c-190.9453302588951)+o*(4.444339102852739*o+9.8632861493405*c-24.86741582555878)+c*(-20.737325471181034*c-187.80453709719578),a[i+2]=255+n*(.8842522430003296*n+8.078677503112928*s+30.89978309703729*o-.23883238689178934*c-14.183576799673286)+s*(10.49593273432072*s+63.02378494754052*o+50.606957656360734*c-112.23884253719248)+o*(.03296041114873217*o+115.60384449646641*c-193.58209356861505)+c*(-22.33816807309886*c-180.12613974708367)}return class extends s{constructor(){super("DeviceCMYK",4)}getRgbItem(t,r,a,i){e(t,r,1,a,i)}getRgbBuffer(t,r,a,i,n,s,o){const c=1/((1<<s)-1);for(let s=0;s<a;s++)e(t,r,c,i,n),r+=4,n+=3+o}getOutputLength(e,t){return e/4*(3+t)|0}}}(),f=function(){function e(e,t,r,a,i,n){const s=(t[r]*n)**e.G,o=e.YW*s,c=Math.max(295.8*o**.3333333333333333-40.8,0);a[i]=c,a[i+1]=c,a[i+2]=c}return class extends s{constructor(e,t,r){if(super("CalGray",1),!e)throw new a.FormatError("WhitePoint missing - required for color space CalGray");if(t=t||[0,0,0],r=r||1,this.XW=e[0],this.YW=e[1],this.ZW=e[2],this.XB=t[0],this.YB=t[1],this.ZB=t[2],this.G=r,this.XW<0||this.ZW<0||1!==this.YW)throw new a.FormatError(`Invalid WhitePoint components for ${this.name}, no fallback available`);(this.XB<0||this.YB<0||this.ZB<0)&&((0,a.info)(`Invalid BlackPoint for ${this.name}, falling back to default.`),this.XB=this.YB=this.ZB=0),0===this.XB&&0===this.YB&&0===this.ZB||(0,a.warn)(`${this.name}, BlackPoint: XB: ${this.XB}, YB: ${this.YB}, ZB: ${this.ZB}, only default values are supported.`),this.G<1&&((0,a.info)(`Invalid Gamma: ${this.G} for ${this.name}, falling back to default.`),this.G=1)}getRgbItem(t,r,a,i){e(this,t,r,a,i,1)}getRgbBuffer(t,r,a,i,n,s,o){const c=1/((1<<s)-1);for(let s=0;s<a;++s)e(this,t,r,i,n,c),r+=1,n+=3+o}getOutputLength(e,t){return e*(3+t)}}}(),g=function(){const e=new Float32Array([.8951,.2664,-.1614,-.7502,1.7135,.0367,.0389,-.0685,1.0296]),t=new Float32Array([.9869929,-.1470543,.1599627,.4323053,.5183603,.0492912,-.0085287,.0400428,.9684867]),r=new Float32Array([3.2404542,-1.5371385,-.4985314,-.969266,1.8760108,.041556,.0556434,-.2040259,1.0572252]),i=new Float32Array([1,1,1]),n=new Float32Array(3),o=new Float32Array(3),c=new Float32Array(3);function l(e,t,r){r[0]=e[0]*t[0]+e[1]*t[1]+e[2]*t[2],r[1]=e[3]*t[0]+e[4]*t[1]+e[5]*t[2],r[2]=e[6]*t[0]+e[7]*t[1]+e[8]*t[2]}function h(e){return e<=.0031308?u(0,1,12.92*e):e>=.99554525?1:u(0,1,1.055*e**(1/2.4)-.055)}function u(e,t,r){return Math.max(e,Math.min(t,r))}function d(e){return e<0?-d(-e):e>8?((e+16)/116)**3:.0011070564598794539*e}function f(a,s,f,g,p,m){const b=u(0,1,s[f]*m),y=u(0,1,s[f+1]*m),w=u(0,1,s[f+2]*m),v=1===b?1:b**a.GR,S=1===y?1:y**a.GG,k=1===w?1:w**a.GB,x=a.MXA*v+a.MXB*S+a.MXC*k,A=a.MYA*v+a.MYB*S+a.MYC*k,C=a.MZA*v+a.MZB*S+a.MZC*k,O=o;O[0]=x,O[1]=A,O[2]=C;const F=c;!function(r,a,i){if(1===r[0]&&1===r[2])return i[0]=a[0],i[1]=a[1],void(i[2]=a[2]);const s=i;l(e,a,s);const o=n;!function(e,t,r){r[0]=1*t[0]/e[0],r[1]=1*t[1]/e[1],r[2]=1*t[2]/e[2]}(r,s,o),l(t,o,i)}(a.whitePoint,O,F);const I=o;!function(e,t,r){if(0===e[0]&&0===e[1]&&0===e[2])return r[0]=t[0],r[1]=t[1],void(r[2]=t[2]);const a=d(0),i=(1-a)/(1-d(e[0])),n=1-i,s=(1-a)/(1-d(e[1])),o=1-s,c=(1-a)/(1-d(e[2])),l=1-c;r[0]=t[0]*i+n,r[1]=t[1]*s+o,r[2]=t[2]*c+l}(a.blackPoint,F,I);const T=c;!function(r,a,i){const s=i;l(e,a,s);const o=n;!function(e,t,r){r[0]=.95047*t[0]/e[0],r[1]=1*t[1]/e[1],r[2]=1.08883*t[2]/e[2]}(r,s,o),l(t,o,i)}(i,I,T);const P=o;l(r,T,P),g[p]=255*h(P[0]),g[p+1]=255*h(P[1]),g[p+2]=255*h(P[2])}return class extends s{constructor(e,t,r,i){if(super("CalRGB",3),!e)throw new a.FormatError("WhitePoint missing - required for color space CalRGB");t=t||new Float32Array(3),r=r||new Float32Array([1,1,1]),i=i||new Float32Array([1,0,0,0,1,0,0,0,1]);const n=e[0],s=e[1],o=e[2];this.whitePoint=e;const c=t[0],l=t[1],h=t[2];if(this.blackPoint=t,this.GR=r[0],this.GG=r[1],this.GB=r[2],this.MXA=i[0],this.MYA=i[1],this.MZA=i[2],this.MXB=i[3],this.MYB=i[4],this.MZB=i[5],this.MXC=i[6],this.MYC=i[7],this.MZC=i[8],n<0||o<0||1!==s)throw new a.FormatError(`Invalid WhitePoint components for ${this.name}, no fallback available`);(c<0||l<0||h<0)&&((0,a.info)(`Invalid BlackPoint for ${this.name} [${c}, ${l}, ${h}], falling back to default.`),this.blackPoint=new Float32Array(3)),(this.GR<0||this.GG<0||this.GB<0)&&((0,a.info)(`Invalid Gamma [${this.GR}, ${this.GG}, ${this.GB}] for ${this.name}, falling back to default.`),this.GR=this.GG=this.GB=1)}getRgbItem(e,t,r,a){f(this,e,t,r,a,1)}getRgbBuffer(e,t,r,a,i,n,s){const o=1/((1<<n)-1);for(let n=0;n<r;++n)f(this,e,t,a,i,o),t+=3,i+=3+s}getOutputLength(e,t){return e*(3+t)/3|0}}}(),p=function(){function e(e){let t;return t=e>=6/29?e**3:108/841*(e-4/29),t}function t(e,t,r,a){return r+e*(a-r)/t}function r(r,a,i,n,s,o){let c=a[i],l=a[i+1],h=a[i+2];!1!==n&&(c=t(c,n,0,100),l=t(l,n,r.amin,r.amax),h=t(h,n,r.bmin,r.bmax)),l>r.amax?l=r.amax:l<r.amin&&(l=r.amin),h>r.bmax?h=r.bmax:h<r.bmin&&(h=r.bmin);const u=(c+16)/116,d=u+l/500,f=u-h/200,g=r.XW*e(d),p=r.YW*e(u),m=r.ZW*e(f);let b,y,w;r.ZW<1?(b=3.1339*g+-1.617*p+-.4906*m,y=-.9785*g+1.916*p+.0333*m,w=.072*g+-.229*p+1.4057*m):(b=3.2406*g+-1.5372*p+-.4986*m,y=-.9689*g+1.8758*p+.0415*m,w=.0557*g+-.204*p+1.057*m),s[o]=255*Math.sqrt(b),s[o+1]=255*Math.sqrt(y),s[o+2]=255*Math.sqrt(w)}return class extends s{constructor(e,t,r){if(super("Lab",3),!e)throw new a.FormatError("WhitePoint missing - required for color space Lab");if(t=t||[0,0,0],r=r||[-100,100,-100,100],this.XW=e[0],this.YW=e[1],this.ZW=e[2],this.amin=r[0],this.amax=r[1],this.bmin=r[2],this.bmax=r[3],this.XB=t[0],this.YB=t[1],this.ZB=t[2],this.XW<0||this.ZW<0||1!==this.YW)throw new a.FormatError("Invalid WhitePoint components, no fallback available");(this.XB<0||this.YB<0||this.ZB<0)&&((0,a.info)("Invalid BlackPoint, falling back to default"),this.XB=this.YB=this.ZB=0),(this.amin>this.amax||this.bmin>this.bmax)&&((0,a.info)("Invalid Range, falling back to defaults"),this.amin=-100,this.amax=100,this.bmin=-100,this.bmax=100)}getRgbItem(e,t,a,i){r(this,e,t,!1,a,i)}getRgbBuffer(e,t,a,i,n,s,o){const c=(1<<s)-1;for(let s=0;s<a;s++)r(this,e,t,c,i,n),t+=3,n+=3+o}getOutputLength(e,t){return e*(3+t)/3|0}isDefaultDecode(e,t){return!0}get usesZeroToOneRange(){return(0,a.shadow)(this,"usesZeroToOneRange",!1)}}}()},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.LocalTilingPatternCache=t.LocalImageCache=t.LocalGStateCache=t.LocalFunctionCache=t.LocalColorSpaceCache=t.GlobalImageCache=void 0;var a=r(2),i=r(5);class n{constructor(e){this.constructor===n&&(0,a.unreachable)("Cannot initialize BaseLocalCache."),e&&e.onlyRefs||(this._nameRefMap=new Map,this._imageMap=new Map),this._imageCache=new i.RefSetCache}getByName(e){const t=this._nameRefMap.get(e);return t?this.getByRef(t):this._imageMap.get(e)||null}getByRef(e){return this._imageCache.get(e)||null}set(e,t,r){(0,a.unreachable)("Abstract method `set` called.")}}t.LocalImageCache=class extends n{set(e,t=null,r){if(!e)throw new Error('LocalImageCache.set - expected "name" argument.');if(t){if(this._imageCache.has(t))return;return this._nameRefMap.set(e,t),void this._imageCache.put(t,r)}this._imageMap.has(e)||this._imageMap.set(e,r)}};t.LocalColorSpaceCache=class extends n{set(e=null,t=null,r){if(!e&&!t)throw new Error('LocalColorSpaceCache.set - expected "name" and/or "ref" argument.');if(t){if(this._imageCache.has(t))return;return e&&this._nameRefMap.set(e,t),void this._imageCache.put(t,r)}this._imageMap.has(e)||this._imageMap.set(e,r)}};t.LocalFunctionCache=class extends n{constructor(e){super({onlyRefs:!0})}getByName(e){(0,a.unreachable)("Should not call `getByName` method.")}set(e=null,t,r){if(!t)throw new Error('LocalFunctionCache.set - expected "ref" argument.');this._imageCache.has(t)||this._imageCache.put(t,r)}};t.LocalGStateCache=class extends n{set(e,t=null,r){if(!e)throw new Error('LocalGStateCache.set - expected "name" argument.');if(t){if(this._imageCache.has(t))return;return this._nameRefMap.set(e,t),void this._imageCache.put(t,r)}this._imageMap.has(e)||this._imageMap.set(e,r)}};t.LocalTilingPatternCache=class extends n{set(e,t=null,r){if(!e)throw new Error('LocalTilingPatternCache.set - expected "name" argument.');if(t){if(this._imageCache.has(t))return;return this._nameRefMap.set(e,t),void this._imageCache.put(t,r)}this._imageMap.has(e)||this._imageMap.set(e,r)}};class s{static get NUM_PAGES_THRESHOLD(){return(0,a.shadow)(this,"NUM_PAGES_THRESHOLD",2)}static get MIN_IMAGES_TO_CACHE(){return(0,a.shadow)(this,"MIN_IMAGES_TO_CACHE",10)}static get MAX_BYTE_SIZE(){return(0,a.shadow)(this,"MAX_BYTE_SIZE",4e7)}constructor(){this._refCache=new i.RefSetCache,this._imageCache=new i.RefSetCache}get _byteSize(){let e=0;return this._imageCache.forEach((t=>{e+=t.byteSize})),e}get _cacheLimitReached(){return!(this._imageCache.size<s.MIN_IMAGES_TO_CACHE)&&!(this._byteSize<s.MAX_BYTE_SIZE)}shouldCache(e,t){const r=this._refCache.get(e);return!((r?r.size+(r.has(t)?0:1):1)<s.NUM_PAGES_THRESHOLD)&&!(!this._imageCache.has(e)&&this._cacheLimitReached)}addPageIndex(e,t){let r=this._refCache.get(e);r||(r=new Set,this._refCache.put(e,r)),r.add(t)}addByteSize(e,t){const r=this._imageCache.get(e);r&&(r.byteSize||(r.byteSize=t))}getData(e,t){const r=this._refCache.get(e);if(!r)return null;if(r.size<s.NUM_PAGES_THRESHOLD)return null;const a=this._imageCache.get(e);return a?(r.add(t),a):null}setData(e,t){if(!this._refCache.has(e))throw new Error('GlobalImageCache.setData - expected "addPageIndex" to have been called.');this._imageCache.has(e)||(this._cacheLimitReached?(0,a.warn)("GlobalImageCache.setData - cache limit reached."):this._imageCache.put(e,t))}clear(e=!1){e||this._refCache.clear(),this._imageCache.clear()}}t.GlobalImageCache=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.MetadataParser=void 0;var a=r(26);t.MetadataParser=class{constructor(e){e=this._repair(e);const t=new a.SimpleXMLParser({lowerCaseName:!0}).parseFromString(e);this._metadataMap=new Map,this._data=e,t&&this._parse(t)}_repair(e){return e.replace(/^[^<]+/,"").replace(/>\\376\\377([^<]+)/g,(function(e,t){const r=t.replace(/\\([0-3])([0-7])([0-7])/g,(function(e,t,r,a){return String.fromCharCode(64*t+8*r+1*a)})).replace(/&(amp|apos|gt|lt|quot);/g,(function(e,t){switch(t){case"amp":return"&";case"apos":return"'";case"gt":return">";case"lt":return"<";case"quot":return'"'}throw new Error(`_repair: ${t} isn't defined.`)})),a=[];for(let e=0,t=r.length;e<t;e+=2){const t=256*r.charCodeAt(e)+r.charCodeAt(e+1);t>=32&&t<127&&60!==t&&62!==t&&38!==t?a.push(String.fromCharCode(t)):a.push("&#x"+(65536+t).toString(16).substring(1)+";")}return">"+a.join("")}))}_getSequence(e){const t=e.nodeName;return"rdf:bag"!==t&&"rdf:seq"!==t&&"rdf:alt"!==t?null:e.childNodes.filter((e=>"rdf:li"===e.nodeName))}_parseArray(e){if(!e.hasChildNodes())return;const[t]=e.childNodes,r=this._getSequence(t)||[];this._metadataMap.set(e.nodeName,r.map((e=>e.textContent.trim())))}_parse(e){let t=e.documentElement;if("rdf:rdf"!==t.nodeName)for(t=t.firstChild;t&&"rdf:rdf"!==t.nodeName;)t=t.nextSibling;if(t&&"rdf:rdf"===t.nodeName&&t.hasChildNodes())for(const e of t.childNodes)if("rdf:description"===e.nodeName)for(const t of e.childNodes){const e=t.nodeName;switch(e){case"#text":continue;case"dc:creator":case"dc:subject":this._parseArray(t);continue}this._metadataMap.set(e,t.textContent.trim())}}get serializable(){return{parsedData:this._metadataMap,rawData:this._data}}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XMLParserErrorCode=t.XMLParserBase=t.SimpleXMLParser=t.SimpleDOMNode=void 0;var a=r(8);const i={NoError:0,EndOfDocument:-1,UnterminatedCdat:-2,UnterminatedXmlDeclaration:-3,UnterminatedDoctypeDeclaration:-4,UnterminatedComment:-5,MalformedElement:-6,OutOfMemory:-7,UnterminatedAttributeValue:-8,UnterminatedElement:-9,ElementNeverBegun:-10};function n(e,t){const r=e[t];return" "===r||"\n"===r||"\r"===r||"\t"===r}t.XMLParserErrorCode=i;class s{_resolveEntities(e){return e.replace(/&([^;]+);/g,((e,t)=>{if("#x"===t.substring(0,2))return String.fromCodePoint(parseInt(t.substring(2),16));if("#"===t.substring(0,1))return String.fromCodePoint(parseInt(t.substring(1),10));switch(t){case"lt":return"<";case"gt":return">";case"amp":return"&";case"quot":return'"';case"apos":return"'"}return this.onResolveEntity(t)}))}_parseContent(e,t){const r=[];let a=t;function i(){for(;a<e.length&&n(e,a);)++a}for(;a<e.length&&!n(e,a)&&">"!==e[a]&&"/"!==e[a];)++a;const s=e.substring(t,a);for(i();a<e.length&&">"!==e[a]&&"/"!==e[a]&&"?"!==e[a];){i();let t="",s="";for(;a<e.length&&!n(e,a)&&"="!==e[a];)t+=e[a],++a;if(i(),"="!==e[a])return null;++a,i();const o=e[a];if('"'!==o&&"'"!==o)return null;const c=e.indexOf(o,++a);if(c<0)return null;s=e.substring(a,c),r.push({name:t,value:this._resolveEntities(s)}),a=c+1,i()}return{name:s,attributes:r,parsed:a-t}}_parseProcessingInstruction(e,t){let r=t;for(;r<e.length&&!n(e,r)&&">"!==e[r]&&"/"!==e[r];)++r;const a=e.substring(t,r);!function(){for(;r<e.length&&n(e,r);)++r}();const i=r;for(;r<e.length&&("?"!==e[r]||">"!==e[r+1]);)++r;return{name:a,value:e.substring(i,r),parsed:r-t}}parseXml(e){let t=0;for(;t<e.length;){let r=t;if("<"===e[t]){++r;let t;switch(e[r]){case"/":if(++r,t=e.indexOf(">",r),t<0)return void this.onError(i.UnterminatedElement);this.onEndElement(e.substring(r,t)),r=t+1;break;case"?":++r;const a=this._parseProcessingInstruction(e,r);if("?>"!==e.substring(r+a.parsed,r+a.parsed+2))return void this.onError(i.UnterminatedXmlDeclaration);this.onPi(a.name,a.value),r+=a.parsed+2;break;case"!":if("--"===e.substring(r+1,r+3)){if(t=e.indexOf("--\x3e",r+3),t<0)return void this.onError(i.UnterminatedComment);this.onComment(e.substring(r+3,t)),r=t+3}else if("[CDATA["===e.substring(r+1,r+8)){if(t=e.indexOf("]]>",r+8),t<0)return void this.onError(i.UnterminatedCdat);this.onCdata(e.substring(r+8,t)),r=t+3}else{if("DOCTYPE"!==e.substring(r+1,r+8))return void this.onError(i.MalformedElement);{const a=e.indexOf("[",r+8);let n=!1;if(t=e.indexOf(">",r+8),t<0)return void this.onError(i.UnterminatedDoctypeDeclaration);if(a>0&&t>a){if(t=e.indexOf("]>",r+8),t<0)return void this.onError(i.UnterminatedDoctypeDeclaration);n=!0}const s=e.substring(r+8,t+(n?1:0));this.onDoctype(s),r=t+(n?2:1)}}break;default:const n=this._parseContent(e,r);if(null===n)return void this.onError(i.MalformedElement);let s=!1;if("/>"===e.substring(r+n.parsed,r+n.parsed+2))s=!0;else if(">"!==e.substring(r+n.parsed,r+n.parsed+1))return void this.onError(i.UnterminatedElement);this.onBeginElement(n.name,n.attributes,s),r+=n.parsed+(s?2:1);break}}else{for(;r<e.length&&"<"!==e[r];)r++;const a=e.substring(t,r);this.onText(this._resolveEntities(a))}t=r}}onResolveEntity(e){return`&${e};`}onPi(e,t){}onComment(e){}onCdata(e){}onDoctype(e){}onText(e){}onBeginElement(e,t,r){}onEndElement(e){}onError(e){}}t.XMLParserBase=s;class o{constructor(e,t){this.nodeName=e,this.nodeValue=t,Object.defineProperty(this,"parentNode",{value:null,writable:!0})}get firstChild(){return this.childNodes&&this.childNodes[0]}get nextSibling(){const e=this.parentNode.childNodes;if(!e)return;const t=e.indexOf(this);return-1!==t?e[t+1]:void 0}get textContent(){return this.childNodes?this.childNodes.map((function(e){return e.textContent})).join(""):this.nodeValue||""}hasChildNodes(){return this.childNodes&&this.childNodes.length>0}searchNode(e,t){if(t>=e.length)return this;const r=e[t],a=[];let i=this;for(;;){if(r.name===i.nodeName){if(0!==r.pos){if(0===a.length)return null;{const[n]=a.pop();let s=0;for(const a of n.childNodes)if(r.name===a.nodeName){if(s===r.pos)return a.searchNode(e,t+1);s++}return i.searchNode(e,t+1)}}{const r=i.searchNode(e,t+1);if(null!==r)return r}}if(i.childNodes&&0!==i.childNodes.length)a.push([i,0]),i=i.childNodes[0];else{if(0===a.length)return null;for(;0!==a.length;){const[e,t]=a.pop(),r=t+1;if(r<e.childNodes.length){a.push([e,r]),i=e.childNodes[r];break}}if(0===a.length)return null}}}dump(e){if("#text"!==this.nodeName){if(e.push(`<${this.nodeName}`),this.attributes)for(const t of this.attributes)e.push(` ${t.name}="${(0,a.encodeToXmlString)(t.value)}"`);if(this.hasChildNodes()){e.push(">");for(const t of this.childNodes)t.dump(e);e.push(`</${this.nodeName}>`)}else this.nodeValue?e.push(`>${(0,a.encodeToXmlString)(this.nodeValue)}</${this.nodeName}>`):e.push("/>")}else e.push((0,a.encodeToXmlString)(this.nodeValue))}}t.SimpleDOMNode=o;t.SimpleXMLParser=class extends s{constructor({hasAttributes:e=!1,lowerCaseName:t=!1}){super(),this._currentFragment=null,this._stack=null,this._errorCode=i.NoError,this._hasAttributes=e,this._lowerCaseName=t}parseFromString(e){if(this._currentFragment=[],this._stack=[],this._errorCode=i.NoError,this.parseXml(e),this._errorCode!==i.NoError)return;const[t]=this._currentFragment;return t?{documentElement:t}:void 0}onText(e){if(function(e){for(let t=0,r=e.length;t<r;t++)if(!n(e,t))return!1;return!0}(e))return;const t=new o("#text",e);this._currentFragment.push(t)}onCdata(e){const t=new o("#text",e);this._currentFragment.push(t)}onBeginElement(e,t,r){this._lowerCaseName&&(e=e.toLowerCase());const a=new o(e);a.childNodes=[],this._hasAttributes&&(a.attributes=t),this._currentFragment.push(a),r||(this._stack.push(this._currentFragment),this._currentFragment=a.childNodes)}onEndElement(e){this._currentFragment=this._stack.pop()||[];const t=this._currentFragment[this._currentFragment.length-1];if(t)for(let e=0,r=t.childNodes.length;e<r;e++)t.childNodes[e].parentNode=t}onError(e){this._errorCode=e}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getQuadPoints=f,t.MarkupAnnotation=t.AnnotationFactory=t.AnnotationBorderStyle=t.Annotation=void 0;var a=r(2),i=r(10),n=r(8),s=r(28),o=r(5),c=r(23),l=r(46),h=r(12),u=r(48);function d(e){const t=new Uint8ClampedArray(3);if(!Array.isArray(e))return t;switch(e.length){case 0:return null;case 1:return c.ColorSpace.singletons.gray.getRgbItem(e,0,t,0),t;case 3:return c.ColorSpace.singletons.rgb.getRgbItem(e,0,t,0),t;case 4:return c.ColorSpace.singletons.cmyk.getRgbItem(e,0,t,0),t;default:return t}}function f(e,t){if(!e.has("QuadPoints"))return null;const r=e.getArray("QuadPoints");if(!Array.isArray(r)||0===r.length||r.length%8>0)return null;const a=[];for(let e=0,i=r.length/8;e<i;e++){a.push([]);for(let i=8*e,n=8*e+8;i<n;i+=2){const n=r[i],s=r[i+1];if(null!==t&&(n<t[0]||n>t[2]||s<t[1]||s>t[3]))return null;a[e].push({x:n,y:s})}}return a.map((e=>{const[t,r,a,i]=e.reduce((([e,t,r,a],i)=>[Math.min(e,i.x),Math.max(t,i.x),Math.min(r,i.y),Math.max(a,i.y)]),[Number.MAX_VALUE,Number.MIN_VALUE,Number.MAX_VALUE,Number.MIN_VALUE]);return[{x:t,y:i},{x:r,y:i},{x:t,y:a},{x:r,y:a}]}))}function g(e,t,r){const[i,n,s,o]=a.Util.getAxialAlignedBoundingBox(t,r);if(i===s||n===o)return[1,0,0,1,e[0],e[1]];const c=(e[2]-e[0])/(s-i),l=(e[3]-e[1])/(o-n);return[c,0,0,l,e[0]-i*c,e[1]-n*l]}t.AnnotationFactory=class{static create(e,t,r,a,i){return r.ensureCatalog("acroForm").then((n=>r.ensure(this,"_create",[e,t,r,a,n,i])))}static _create(e,t,r,i,s,c){const l=e.fetchIfRef(t);if(!(0,o.isDict)(l))return;const h=(0,o.isRef)(t)?t.toString():`annot_${i.createObjId()}`;let u=l.get("Subtype");u=(0,o.isName)(u)?u.name:null;const d={xref:e,ref:t,dict:l,subtype:u,id:h,pdfManager:r,acroForm:s instanceof o.Dict?s:o.Dict.empty,collectFields:c};switch(u){case"Link":return new x(d);case"Text":return new k(d);case"Widget":let e=(0,n.getInheritableProperty)({dict:l,key:"FT"});switch(e=(0,o.isName)(e)?e.name:null,e){case"Tx":return new w(d);case"Btn":return new v(d);case"Ch":return new S(d)}return(0,a.warn)(`Unimplemented widget field type "${e}", falling back to base field type.`),new y(d);case"Popup":return new A(d);case"FreeText":return new C(d);case"Line":return new O(d);case"Square":return new F(d);case"Circle":return new I(d);case"PolyLine":return new T(d);case"Polygon":return new P(d);case"Caret":return new E(d);case"Ink":return new M(d);case"Highlight":return new N(d);case"Underline":return new D(d);case"Squiggly":return new B(d);case"StrikeOut":return new j(d);case"Stamp":return new L(d);case"FileAttachment":return new R(d);default:return c||(u?(0,a.warn)(`Unimplemented annotation type "${u}", falling back to base annotation.`):(0,a.warn)("Annotation is missing the required /Subtype.")),new p(d)}}};class p{constructor(e){const t=e.dict;if(this.setContents(t.get("Contents")),this.setModificationDate(t.get("M")),this.setFlags(t.get("F")),this.setRectangle(t.getArray("Rect")),this.setColor(t.getArray("C")),this.setBorderStyle(t),this.setAppearance(t),this._streams=[],this.appearance&&this._streams.push(this.appearance),this.data={annotationFlags:this.flags,borderStyle:this.borderStyle,color:this.color,contents:this.contents,hasAppearance:!!this.appearance,id:e.id,modificationDate:this.modificationDate,rect:this.rectangle,subtype:e.subtype},e.collectFields){const r=t.get("Kids");if(Array.isArray(r)){const e=[];for(const t of r)(0,o.isRef)(t)&&e.push(t.toString());0!==e.length&&(this.data.kidIds=e)}this.data.actions=(0,n.collectActions)(e.xref,t,a.AnnotationActionEventType),this.data.fieldName=this._constructFieldName(t)}this._fallbackFontDict=null}_hasFlag(e,t){return!!(e&t)}_isViewable(e){return!this._hasFlag(e,a.AnnotationFlag.INVISIBLE)&&!this._hasFlag(e,a.AnnotationFlag.NOVIEW)}_isPrintable(e){return this._hasFlag(e,a.AnnotationFlag.PRINT)&&!this._hasFlag(e,a.AnnotationFlag.INVISIBLE)}isHidden(e){const t=e&&e.get(this.data.id);return t&&void 0!==t.hidden?t.hidden:this._hasFlag(this.flags,a.AnnotationFlag.HIDDEN)}get viewable(){return null!==this.data.quadPoints&&(0===this.flags||this._isViewable(this.flags))}get printable(){return null!==this.data.quadPoints&&(0!==this.flags&&this._isPrintable(this.flags))}setContents(e){this.contents=(0,a.stringToPDFString)(e||"")}setModificationDate(e){this.modificationDate=(0,a.isString)(e)?e:null}setFlags(e){this.flags=Number.isInteger(e)&&e>0?e:0}hasFlag(e){return this._hasFlag(this.flags,e)}setRectangle(e){Array.isArray(e)&&4===e.length?this.rectangle=a.Util.normalizeRect(e):this.rectangle=[0,0,0,0]}setColor(e){this.color=d(e)}setBorderStyle(e){if(this.borderStyle=new m,(0,o.isDict)(e))if(e.has("BS")){const t=e.get("BS"),r=t.get("Type");r&&!(0,o.isName)(r,"Border")||(this.borderStyle.setWidth(t.get("W"),this.rectangle),this.borderStyle.setStyle(t.get("S")),this.borderStyle.setDashArray(t.getArray("D")))}else if(e.has("Border")){const t=e.getArray("Border");Array.isArray(t)&&t.length>=3&&(this.borderStyle.setHorizontalCornerRadius(t[0]),this.borderStyle.setVerticalCornerRadius(t[1]),this.borderStyle.setWidth(t[2],this.rectangle),4===t.length&&this.borderStyle.setDashArray(t[3]))}else this.borderStyle.setWidth(0)}setAppearance(e){this.appearance=null;const t=e.get("AP");if(!(0,o.isDict)(t))return;const r=t.get("N");if((0,o.isStream)(r))return void(this.appearance=r);if(!(0,o.isDict)(r))return;const a=e.get("AS");(0,o.isName)(a)&&r.has(a.name)&&(this.appearance=r.get(a.name))}loadResources(e){return this.appearance.dict.getAsync("Resources").then((t=>{if(!t)return;return new i.ObjectLoader(t,e,t.xref).load().then((function(){return t}))}))}getOperatorList(e,t,r,i){if(!this.appearance)return Promise.resolve(new l.OperatorList);const n=this.appearance,s=this.data,o=n.dict,c=this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"]),h=o.getArray("BBox")||[0,0,1,1],u=o.getArray("Matrix")||[1,0,0,1,0,0],d=g(s.rect,h,u);return c.then((r=>{const i=new l.OperatorList;return i.addOp(a.OPS.beginAnnotation,[s.rect,d,u]),e.getOperatorList({stream:n,task:t,resources:r,operatorList:i,fallbackFontDict:this._fallbackFontDict}).then((()=>(i.addOp(a.OPS.endAnnotation,[]),this.reset(),i)))}))}async save(e,t,r){return null}getFieldObject(){return this.data.kidIds?{id:this.data.id,actions:this.data.actions,name:this.data.fieldName,type:"",kidIds:this.data.kidIds}:null}reset(){for(const e of this._streams)e.reset()}_constructFieldName(e){if(!e.has("T")&&!e.has("Parent"))return(0,a.warn)("Unknown field name, falling back to empty field name."),"";if(!e.has("Parent"))return(0,a.stringToPDFString)(e.get("T"));const t=[];e.has("T")&&t.unshift((0,a.stringToPDFString)(e.get("T")));let r=e;const i=new o.RefSet;for(e.objId&&i.put(e.objId);r.has("Parent")&&(r=r.get("Parent"),r instanceof o.Dict&&(!r.objId||!i.has(r.objId)));)r.objId&&i.put(r.objId),r.has("T")&&t.unshift((0,a.stringToPDFString)(r.get("T")));return t.join(".")}}t.Annotation=p;class m{constructor(){this.width=1,this.style=a.AnnotationBorderStyleType.SOLID,this.dashArray=[3],this.horizontalCornerRadius=0,this.verticalCornerRadius=0}setWidth(e,t=[0,0,0,0]){if((0,o.isName)(e))this.width=0;else if(Number.isInteger(e)){if(e>0){const r=(t[2]-t[0])/2,i=(t[3]-t[1])/2;r>0&&i>0&&(e>r||e>i)&&((0,a.warn)(`AnnotationBorderStyle.setWidth - ignoring width: ${e}`),e=1)}this.width=e}}setStyle(e){if((0,o.isName)(e))switch(e.name){case"S":this.style=a.AnnotationBorderStyleType.SOLID;break;case"D":this.style=a.AnnotationBorderStyleType.DASHED;break;case"B":this.style=a.AnnotationBorderStyleType.BEVELED;break;case"I":this.style=a.AnnotationBorderStyleType.INSET;break;case"U":this.style=a.AnnotationBorderStyleType.UNDERLINE;break;default:break}}setDashArray(e){if(Array.isArray(e)&&e.length>0){let t=!0,r=!0;for(const a of e){if(!(+a>=0)){t=!1;break}a>0&&(r=!1)}t&&!r?this.dashArray=e:this.width=0}else e&&(this.width=0)}setHorizontalCornerRadius(e){Number.isInteger(e)&&(this.horizontalCornerRadius=e)}setVerticalCornerRadius(e){Number.isInteger(e)&&(this.verticalCornerRadius=e)}}t.AnnotationBorderStyle=m;class b extends p{constructor(e){super(e);const t=e.dict;if(t.has("IRT")){const e=t.getRaw("IRT");this.data.inReplyTo=(0,o.isRef)(e)?e.toString():null;const r=t.get("RT");this.data.replyType=(0,o.isName)(r)?r.name:a.AnnotationReplyType.REPLY}if(this.data.replyType===a.AnnotationReplyType.GROUP){const e=t.get("IRT");this.data.title=(0,a.stringToPDFString)(e.get("T")||""),this.setContents(e.get("Contents")),this.data.contents=this.contents,e.has("CreationDate")?(this.setCreationDate(e.get("CreationDate")),this.data.creationDate=this.creationDate):this.data.creationDate=null,e.has("M")?(this.setModificationDate(e.get("M")),this.data.modificationDate=this.modificationDate):this.data.modificationDate=null,this.data.hasPopup=e.has("Popup"),e.has("C")?(this.setColor(e.getArray("C")),this.data.color=this.color):this.data.color=null}else this.data.title=(0,a.stringToPDFString)(t.get("T")||""),this.setCreationDate(t.get("CreationDate")),this.data.creationDate=this.creationDate,this.data.hasPopup=t.has("Popup"),t.has("C")||(this.data.color=null)}setCreationDate(e){this.creationDate=(0,a.isString)(e)?e:null}_setDefaultAppearance({xref:e,extra:t,strokeColor:r,fillColor:a,blendMode:i,pointsCallback:n}){let s=Number.MAX_VALUE,c=Number.MAX_VALUE,l=Number.MIN_VALUE,u=Number.MIN_VALUE;const d=["q"];t&&d.push(t),r&&d.push(`${r[0]} ${r[1]} ${r[2]} RG`),a&&d.push(`${a[0]} ${a[1]} ${a[2]} rg`);let f=this.data.quadPoints;f||(f=[[{x:this.rectangle[0],y:this.rectangle[3]},{x:this.rectangle[2],y:this.rectangle[3]},{x:this.rectangle[0],y:this.rectangle[1]},{x:this.rectangle[2],y:this.rectangle[1]}]]);for(const e of f){const[t,r,a,i]=n(d,e);s=Math.min(s,t),l=Math.max(l,r),c=Math.min(c,a),u=Math.max(u,i)}d.push("Q");const g=new o.Dict(e),p=new o.Dict(e);p.set("Subtype",o.Name.get("Form"));const m=new h.StringStream(d.join(" "));m.dict=p,g.set("Fm0",m);const b=new o.Dict(e);i&&b.set("BM",o.Name.get(i));const y=new o.Dict(e);y.set("GS0",b);const w=new o.Dict(e);w.set("ExtGState",y),w.set("XObject",g);const v=new o.Dict(e);v.set("Resources",w);const S=this.data.rect=[s,c,l,u];v.set("BBox",S),this.appearance=new h.StringStream("/GS0 gs /Fm0 Do"),this.appearance.dict=v,this._streams.push(this.appearance,m)}}t.MarkupAnnotation=b;class y extends p{constructor(e){super(e);const t=e.dict,r=this.data;this.ref=e.ref,r.annotationType=a.AnnotationType.WIDGET,void 0===r.fieldName&&(r.fieldName=this._constructFieldName(t)),void 0===r.actions&&(r.actions=(0,n.collectActions)(e.xref,t,a.AnnotationActionEventType));const i=(0,n.getInheritableProperty)({dict:t,key:"V",getArray:!0});r.fieldValue=this._decodeFormValue(i);const c=(0,n.getInheritableProperty)({dict:t,key:"DV",getArray:!0});r.defaultFieldValue=this._decodeFormValue(c),r.alternativeText=(0,a.stringToPDFString)(t.get("TU")||"");const l=(0,n.getInheritableProperty)({dict:t,key:"DA"})||e.acroForm.get("DA");this._defaultAppearance=(0,a.isString)(l)?l:"",r.defaultAppearanceData=(0,s.parseDefaultAppearance)(this._defaultAppearance);const h=(0,n.getInheritableProperty)({dict:t,key:"FT"});r.fieldType=(0,o.isName)(h)?h.name:null;const u=(0,n.getInheritableProperty)({dict:t,key:"DR"}),d=e.acroForm.get("DR"),f=this.appearance&&this.appearance.dict.get("Resources");this._fieldResources={localResources:u,acroFormResources:d,appearanceResources:f,mergedResources:o.Dict.merge({xref:e.xref,dictArray:[u,f,d],mergeSubDicts:!0})},r.fieldFlags=(0,n.getInheritableProperty)({dict:t,key:"Ff"}),(!Number.isInteger(r.fieldFlags)||r.fieldFlags<0)&&(r.fieldFlags=0),r.readOnly=this.hasFieldFlag(a.AnnotationFieldFlag.READONLY),r.hidden=this._hasFlag(r.annotationFlags,a.AnnotationFlag.HIDDEN),"Sig"===r.fieldType&&(r.fieldValue=null,this.setFlags(a.AnnotationFlag.HIDDEN),r.hidden=!0)}_decodeFormValue(e){return Array.isArray(e)?e.filter((e=>(0,a.isString)(e))).map((e=>(0,a.stringToPDFString)(e))):(0,o.isName)(e)?(0,a.stringToPDFString)(e.name):(0,a.isString)(e)?(0,a.stringToPDFString)(e):null}hasFieldFlag(e){return!!(this.data.fieldFlags&e)}getOperatorList(e,t,r,i){return r?Promise.resolve(new l.OperatorList):this._hasText?this._getAppearance(e,t,i).then((n=>{if(this.appearance&&null===n)return super.getOperatorList(e,t,r,i);const s=new l.OperatorList;if(!this._defaultAppearance||null===n)return s;const o=[1,0,0,1,0,0],c=[0,0,this.data.rect[2]-this.data.rect[0],this.data.rect[3]-this.data.rect[1]],u=g(this.data.rect,c,o);s.addOp(a.OPS.beginAnnotation,[this.data.rect,u,o]);const d=new h.StringStream(n);return e.getOperatorList({stream:d,task:t,resources:this._fieldResources.mergedResources,operatorList:s}).then((function(){return s.addOp(a.OPS.endAnnotation,[]),s}))})):super.getOperatorList(e,t,r,i)}async save(e,t,r){if(!r)return null;const i=r.get(this.data.id),n=i&&i.value;if(n===this.data.fieldValue||void 0===n)return null;let s=await this._getAppearance(e,t,r);if(null===s)return null;const{xref:c}=e,l=c.fetchIfRef(this.ref);if(!(0,o.isDict)(l))return null;const h=[0,0,this.data.rect[2]-this.data.rect[0],this.data.rect[3]-this.data.rect[1]],d={path:(0,a.stringToPDFString)(l.get("T")||""),value:n},f=c.getNewRef(),g=new o.Dict(c);g.set("N",f);const p=c.encrypt;let m=null,b=null;p&&(m=p.createCipherTransform(this.ref.num,this.ref.gen),b=p.createCipherTransform(f.num,f.gen),s=b.encryptString(s)),l.set("V",(0,a.isAscii)(n)?n:(0,a.stringToUTF16BEString)(n)),l.set("AP",g),l.set("M",`D:${(0,a.getModificationDate)()}`);const y=new o.Dict(c);y.set("Length",s.length),y.set("Subtype",o.Name.get("Form")),y.set("Resources",this._getSaveFieldResources(c)),y.set("BBox",h);const w=[`${this.ref.num} ${this.ref.gen} obj\n`];(0,u.writeDict)(l,w,m),w.push("\nendobj\n");const v=[`${f.num} ${f.gen} obj\n`];return(0,u.writeDict)(y,v,b),v.push(" stream\n"),v.push(s),v.push("\nendstream\nendobj\n"),[{ref:this.ref,data:w.join(""),xfa:d},{ref:f,data:v.join(""),xfa:null}]}async _getAppearance(e,t,r){const i=this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD);if(!r||i)return null;const n=r.get(this.data.id);let o=n&&n.value;if(void 0===o)return null;if(o=o.trim(),""===o)return"";let c=-1;this.data.multiLine&&(c=o.split(/\r\n|\r|\n/).length);const l=this.data.rect[3]-this.data.rect[1],h=this.data.rect[2]-this.data.rect[0];this._defaultAppearance||(this.data.defaultAppearanceData=(0,s.parseDefaultAppearance)(this._defaultAppearance="/Helvetica 0 Tf 0 g"));const[u,d]=this._computeFontSize(l,c),f=await this._getFontData(e,t);let g=f.descent;isNaN(g)&&(g=0);const p=2+Math.abs(g)*d,m=this.data.textAlignment;if(this.data.multiLine)return this._getMultilineAppearance(u,o,f,d,h,l,m,2,p);const b=f.encodeString(o).join("");if(this.data.comb)return this._getCombAppearance(u,f,b,h,2,p);if(0===m||m>2)return"/Tx BMC q BT "+u+` 1 0 0 1 2 ${p} Tm (${(0,a.escapeString)(b)}) Tj ET Q EMC`;return"/Tx BMC q BT "+u+` 1 0 0 1 0 0 Tm ${this._renderText(b,f,d,h,m,2,p)} ET Q EMC`}async _getFontData(e,t){const r=new l.OperatorList,a={font:null,clone(){return this}},{fontName:i,fontSize:n}=this.data.defaultAppearanceData;return await e.handleSetFont(this._fieldResources.mergedResources,[i&&o.Name.get(i),n],null,r,t,a,null),a.font}_computeFontSize(e,t){let{fontSize:r}=this.data.defaultAppearanceData;if(!r){const a=e=>Math.round(10*e)/10,i=.8;if(-1===t)r=a(i*e);else{r=10;let n=r/i,s=Math.round(e/n);s=Math.max(s,t),n=e/s,r=a(i*n)}const{fontName:n,fontColor:o}=this.data.defaultAppearanceData;this._defaultAppearance=(0,s.createDefaultAppearance)({fontSize:r,fontName:n,fontColor:o})}return[this._defaultAppearance,r]}_renderText(e,t,r,i,n,s,o){const c=t.charsToGlyphs(e),l=r/1e3;let h,u=0;for(const e of c)u+=e.width*l;return h=1===n?(i-u)/2:2===n?i-u-s:s,h=h.toFixed(2),`${h} ${o=o.toFixed(2)} Td (${(0,a.escapeString)(e)}) Tj`}_getSaveFieldResources(e){const{localResources:t,appearanceResources:r,acroFormResources:a}=this._fieldResources,i=this.data.defaultAppearanceData&&this.data.defaultAppearanceData.fontName;if(!i)return t||o.Dict.empty;for(const e of[t,r])if(e instanceof o.Dict){const t=e.get("Font");if(t instanceof o.Dict&&t.has(i))return e}if(a instanceof o.Dict){const r=a.get("Font");if(r instanceof o.Dict&&r.has(i)){const a=new o.Dict(e);a.set(i,r.getRaw(i));const n=new o.Dict(e);return n.set("Font",a),o.Dict.merge({xref:e,dictArray:[n,t],mergeSubDicts:!0})}}return t||o.Dict.empty}getFieldObject(){return"Sig"===this.data.fieldType?{id:this.data.id,value:null,type:"signature"}:null}}class w extends y{constructor(e){super(e),this._hasText=!0;const t=e.dict;(0,a.isString)(this.data.fieldValue)||(this.data.fieldValue="");let r=(0,n.getInheritableProperty)({dict:t,key:"Q"});(!Number.isInteger(r)||r<0||r>2)&&(r=null),this.data.textAlignment=r;let i=(0,n.getInheritableProperty)({dict:t,key:"MaxLen"});(!Number.isInteger(i)||i<0)&&(i=null),this.data.maxLen=i,this.data.multiLine=this.hasFieldFlag(a.AnnotationFieldFlag.MULTILINE),this.data.comb=this.hasFieldFlag(a.AnnotationFieldFlag.COMB)&&!this.hasFieldFlag(a.AnnotationFieldFlag.MULTILINE)&&!this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD)&&!this.hasFieldFlag(a.AnnotationFieldFlag.FILESELECT)&&null!==this.data.maxLen}_getCombAppearance(e,t,r,i,n,s){const o=(i/this.data.maxLen).toFixed(2),c=[],l=t.getCharPositions(r);for(const[e,t]of l)c.push(`(${(0,a.escapeString)(r.substring(e,t))}) Tj`);return"/Tx BMC q BT "+e+` 1 0 0 1 ${n} ${s} Tm ${c.join(` ${o} 0 Td `)} ET Q EMC`}_getMultilineAppearance(e,t,r,a,i,n,s,o,c){const l=t.split(/\r\n|\r|\n/),h=[],u=i-2*o;for(const e of l){const t=this._splitLine(e,r,a,u);for(const e of t){const t=0===h.length?o:0;h.push(this._renderText(e,r,a,i,s,t,-a))}}return"/Tx BMC q BT "+e+` 1 0 0 1 0 ${n} Tm ${h.join("\n")} ET Q EMC`}_splitLine(e,t,r,a){e=t.encodeString(e).join("");const i=t.charsToGlyphs(e);if(i.length<=1)return[e];const n=t.getCharPositions(e),s=r/1e3,o=[];let c=-1,l=-1,h=-1,u=0,d=0;for(let t=0,r=i.length;t<r;t++){const[r,f]=n[t],g=i[t],p=g.width*s;" "===g.unicode?d+p>a?(o.push(e.substring(u,r)),u=r,d=p,c=-1,h=-1):(d+=p,c=r,l=f,h=t):d+p>a?-1!==c?(o.push(e.substring(u,l)),u=l,t=h+1,c=-1,d=0):(o.push(e.substring(u,r)),u=r,d=p):d+=p}return u<e.length&&o.push(e.substring(u,e.length)),o}getFieldObject(){return{id:this.data.id,value:this.data.fieldValue,defaultValue:this.data.defaultFieldValue,multiline:this.data.multiLine,password:this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD),charLimit:this.data.maxLen,comb:this.data.comb,editable:!this.data.readOnly,hidden:this.data.hidden,name:this.data.fieldName,rect:this.data.rect,actions:this.data.actions,type:"text"}}}class v extends y{constructor(e){super(e),this.checkedAppearance=null,this.uncheckedAppearance=null,this.data.checkBox=!this.hasFieldFlag(a.AnnotationFieldFlag.RADIO)&&!this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON),this.data.radioButton=this.hasFieldFlag(a.AnnotationFieldFlag.RADIO)&&!this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON),this.data.pushButton=this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON),this.data.isTooltipOnly=!1,this.data.checkBox?this._processCheckBox(e):this.data.radioButton?this._processRadioButton(e):this.data.pushButton?this._processPushButton(e):(0,a.warn)("Invalid field flags for button widget annotation")}getOperatorList(e,t,r,a){if(this.data.pushButton)return super.getOperatorList(e,t,!1,a);if(a){const i=a.get(this.data.id),n=i&&i.value;if(void 0===n)return super.getOperatorList(e,t,r,a);let s;if(s=n?this.checkedAppearance:this.uncheckedAppearance,s){const i=this.appearance;this.appearance=s;const n=super.getOperatorList(e,t,r,a);return this.appearance=i,n}return Promise.resolve(new l.OperatorList)}return super.getOperatorList(e,t,r,a)}async save(e,t,r){return this.data.checkBox?this._saveCheckbox(e,t,r):this.data.radioButton?this._saveRadioButton(e,t,r):null}async _saveCheckbox(e,t,r){if(!r)return null;const i=r.get(this.data.id),n=i&&i.value;if(void 0===n)return null;if((this.data.fieldValue&&"Off"!==this.data.fieldValue)===n)return null;const s=e.xref.fetchIfRef(this.ref);if(!(0,o.isDict)(s))return null;const c={path:(0,a.stringToPDFString)(s.get("T")||""),value:n?this.data.exportValue:""},l=o.Name.get(n?this.data.exportValue:"Off");s.set("V",l),s.set("AS",l),s.set("M",`D:${(0,a.getModificationDate)()}`);const h=e.xref.encrypt;let d=null;h&&(d=h.createCipherTransform(this.ref.num,this.ref.gen));const f=[`${this.ref.num} ${this.ref.gen} obj\n`];return(0,u.writeDict)(s,f,d),f.push("\nendobj\n"),[{ref:this.ref,data:f.join(""),xfa:c}]}async _saveRadioButton(e,t,r){if(!r)return null;const i=r.get(this.data.id),n=i&&i.value;if(void 0===n)return null;if(this.data.fieldValue===this.data.buttonValue===n)return null;const s=e.xref.fetchIfRef(this.ref);if(!(0,o.isDict)(s))return null;const c={path:(0,a.stringToPDFString)(s.get("T")||""),value:n?this.data.buttonValue:""},l=o.Name.get(n?this.data.buttonValue:"Off");let h=null;const d=e.xref.encrypt;if(n)if((0,o.isRef)(this.parent)){const t=e.xref.fetch(this.parent);let r=null;d&&(r=d.createCipherTransform(this.parent.num,this.parent.gen)),t.set("V",l),h=[`${this.parent.num} ${this.parent.gen} obj\n`],(0,u.writeDict)(t,h,r),h.push("\nendobj\n")}else(0,o.isDict)(this.parent)&&this.parent.set("V",l);s.set("AS",l),s.set("M",`D:${(0,a.getModificationDate)()}`);let f=null;d&&(f=d.createCipherTransform(this.ref.num,this.ref.gen));const g=[`${this.ref.num} ${this.ref.gen} obj\n`];(0,u.writeDict)(s,g,f),g.push("\nendobj\n");const p=[{ref:this.ref,data:g.join(""),xfa:c}];return null!==h&&p.push({ref:this.parent,data:h.join(""),xfa:null}),p}_processCheckBox(e){const t=e.dict.get("AP");if(!(0,o.isDict)(t))return;const r=t.get("N");if(!(0,o.isDict)(r))return;const a=r.getKeys();a.includes("Off")||a.push("Off"),2===a.length&&(this.data.exportValue="Off"===a[0]?a[1]:a[0],this.checkedAppearance=r.get(this.data.exportValue),this.uncheckedAppearance=r.get("Off")||null,this._streams.push(this.checkedAppearance),this.uncheckedAppearance&&this._streams.push(this.uncheckedAppearance),this._fallbackFontDict=this.fallbackFontDict)}_processRadioButton(e){this.data.fieldValue=this.data.buttonValue=null;const t=e.dict.get("Parent");if((0,o.isDict)(t)){this.parent=e.dict.getRaw("Parent");const r=t.get("V");(0,o.isName)(r)&&(this.data.fieldValue=this._decodeFormValue(r))}const r=e.dict.get("AP");if(!(0,o.isDict)(r))return;const a=r.get("N");if((0,o.isDict)(a)){for(const e of a.getKeys())if("Off"!==e){this.data.buttonValue=this._decodeFormValue(e);break}this.checkedAppearance=a.get(this.data.buttonValue),this.uncheckedAppearance=a.get("Off")||null,this._streams.push(this.checkedAppearance),this.uncheckedAppearance&&this._streams.push(this.uncheckedAppearance),this._fallbackFontDict=this.fallbackFontDict}}_processPushButton(e){e.dict.has("A")||e.dict.has("AA")||this.data.alternativeText?(this.data.isTooltipOnly=!e.dict.has("A")&&!e.dict.has("AA"),i.Catalog.parseDestDictionary({destDict:e.dict,resultObj:this.data,docBaseUrl:e.pdfManager.docBaseUrl})):(0,a.warn)("Push buttons without action dictionaries are not supported")}getFieldObject(){let e,t="button";return this.data.checkBox?(t="checkbox",e=this.data.exportValue):this.data.radioButton&&(t="radiobutton",e=this.data.buttonValue),{id:this.data.id,value:this.data.fieldValue||"Off",defaultValue:this.data.defaultFieldValue,exportValues:e,editable:!this.data.readOnly,name:this.data.fieldName,rect:this.data.rect,hidden:this.data.hidden,actions:this.data.actions,type:t}}get fallbackFontDict(){const e=new o.Dict;return e.set("BaseFont",o.Name.get("ZapfDingbats")),e.set("Type",o.Name.get("FallbackType")),e.set("Subtype",o.Name.get("FallbackType")),e.set("Encoding",o.Name.get("ZapfDingbatsEncoding")),(0,a.shadow)(this,"fallbackFontDict",e)}}class S extends y{constructor(e){super(e),this.data.options=[];const t=(0,n.getInheritableProperty)({dict:e.dict,key:"Opt"});if(Array.isArray(t)){const r=e.xref;for(let e=0,a=t.length;e<a;e++){const a=r.fetchIfRef(t[e]),i=Array.isArray(a);this.data.options[e]={exportValue:this._decodeFormValue(i?r.fetchIfRef(a[0]):a),displayValue:this._decodeFormValue(i?r.fetchIfRef(a[1]):a)}}}(0,a.isString)(this.data.fieldValue)?this.data.fieldValue=[this.data.fieldValue]:this.data.fieldValue||(this.data.fieldValue=[]),this.data.combo=this.hasFieldFlag(a.AnnotationFieldFlag.COMBO),this.data.multiSelect=this.hasFieldFlag(a.AnnotationFieldFlag.MULTISELECT),this._hasText=!0}getFieldObject(){const e=this.data.combo?"combobox":"listbox",t=this.data.fieldValue.length>0?this.data.fieldValue[0]:null;return{id:this.data.id,value:t,defaultValue:this.data.defaultFieldValue,editable:!this.data.readOnly,name:this.data.fieldName,rect:this.data.rect,numItems:this.data.fieldValue.length,multipleSelection:this.data.multiSelect,hidden:this.data.hidden,actions:this.data.actions,items:this.data.options,type:e}}}class k extends b{constructor(e){super(e);const t=e.dict;this.data.annotationType=a.AnnotationType.TEXT,this.data.hasAppearance?this.data.name="NoIcon":(this.data.rect[1]=this.data.rect[3]-22,this.data.rect[2]=this.data.rect[0]+22,this.data.name=t.has("Name")?t.get("Name").name:"Note"),t.has("State")?(this.data.state=t.get("State")||null,this.data.stateModel=t.get("StateModel")||null):(this.data.state=null,this.data.stateModel=null)}}class x extends p{constructor(e){super(e),this.data.annotationType=a.AnnotationType.LINK;const t=f(e.dict,this.rectangle);t&&(this.data.quadPoints=t),i.Catalog.parseDestDictionary({destDict:e.dict,resultObj:this.data,docBaseUrl:e.pdfManager.docBaseUrl})}}class A extends p{constructor(e){super(e),this.data.annotationType=a.AnnotationType.POPUP;let t=e.dict.get("Parent");if(!t)return void(0,a.warn)("Popup annotation has a missing or invalid parent annotation.");const r=t.get("Subtype");this.data.parentType=(0,o.isName)(r)?r.name:null;const i=e.dict.getRaw("Parent");this.data.parentId=(0,o.isRef)(i)?i.toString():null;const n=t.getArray("Rect");Array.isArray(n)&&4===n.length?this.data.parentRect=a.Util.normalizeRect(n):this.data.parentRect=[0,0,0,0];const s=t.get("RT");if((0,o.isName)(s,a.AnnotationReplyType.GROUP)&&(t=t.get("IRT")),t.has("M")?(this.setModificationDate(t.get("M")),this.data.modificationDate=this.modificationDate):this.data.modificationDate=null,t.has("C")?(this.setColor(t.getArray("C")),this.data.color=this.color):this.data.color=null,!this.viewable){const e=t.get("F");this._isViewable(e)&&this.setFlags(e)}this.data.title=(0,a.stringToPDFString)(t.get("T")||""),this.data.contents=(0,a.stringToPDFString)(t.get("Contents")||"")}}class C extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.FREETEXT}}class O extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.LINE;const t=e.dict.getArray("L");if(this.data.lineCoordinates=a.Util.normalizeRect(t),!this.appearance){const r=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0],i=this.borderStyle.width;(0,a.isArrayEqual)(this.rectangle,[0,0,0,0])&&(this.rectangle=[this.data.lineCoordinates[0]-2*i,this.data.lineCoordinates[1]-2*i,this.data.lineCoordinates[2]+2*i,this.data.lineCoordinates[3]+2*i]),this._setDefaultAppearance({xref:e.xref,extra:`${i} w`,strokeColor:r,pointsCallback:(e,r)=>(e.push(`${t[0]} ${t[1]} m`),e.push(`${t[2]} ${t[3]} l`),e.push("S"),[r[0].x-i,r[1].x+i,r[3].y-i,r[1].y+i])})}}}class F extends b{constructor(e){if(super(e),this.data.annotationType=a.AnnotationType.SQUARE,!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];let r=null,a=e.dict.getArray("IC");a&&(a=d(a),r=a?Array.from(a).map((e=>e/255)):null),this._setDefaultAppearance({xref:e.xref,extra:`${this.borderStyle.width} w`,strokeColor:t,fillColor:r,pointsCallback:(e,t)=>{const a=t[2].x+this.borderStyle.width/2,i=t[2].y+this.borderStyle.width/2,n=t[3].x-t[2].x-this.borderStyle.width,s=t[1].y-t[3].y-this.borderStyle.width;return e.push(`${a} ${i} ${n} ${s} re`),r?e.push("B"):e.push("S"),[t[0].x,t[1].x,t[3].y,t[1].y]}})}}}class I extends b{constructor(e){if(super(e),this.data.annotationType=a.AnnotationType.CIRCLE,!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];let r=null,a=e.dict.getArray("IC");a&&(a=d(a),r=a?Array.from(a).map((e=>e/255)):null);const i=4/3*Math.tan(Math.PI/8);this._setDefaultAppearance({xref:e.xref,extra:`${this.borderStyle.width} w`,strokeColor:t,fillColor:r,pointsCallback:(e,t)=>{const a=t[0].x+this.borderStyle.width/2,n=t[0].y-this.borderStyle.width/2,s=t[3].x-this.borderStyle.width/2,o=t[3].y+this.borderStyle.width/2,c=a+(s-a)/2,l=n+(o-n)/2,h=(s-a)/2*i,u=(o-n)/2*i;return e.push(`${c} ${o} m`),e.push(`${c+h} ${o} ${s} ${l+u} ${s} ${l} c`),e.push(`${s} ${l-u} ${c+h} ${n} ${c} ${n} c`),e.push(`${c-h} ${n} ${a} ${l-u} ${a} ${l} c`),e.push(`${a} ${l+u} ${c-h} ${o} ${c} ${o} c`),e.push("h"),r?e.push("B"):e.push("S"),[t[0].x,t[1].x,t[3].y,t[1].y]}})}}}class T extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.POLYLINE,this.data.vertices=[];const t=e.dict.getArray("Vertices");if(Array.isArray(t))for(let e=0,r=t.length;e<r;e+=2)this.data.vertices.push({x:t[e],y:t[e+1]})}}class P extends T{constructor(e){super(e),this.data.annotationType=a.AnnotationType.POLYGON}}class E extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.CARET}}class M extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.INK,this.data.inkLists=[];const t=e.dict.getArray("InkList");if(!Array.isArray(t))return;const r=e.xref;for(let e=0,a=t.length;e<a;++e){this.data.inkLists.push([]);for(let a=0,i=t[e].length;a<i;a+=2)this.data.inkLists[e].push({x:r.fetchIfRef(t[e][a]),y:r.fetchIfRef(t[e][a+1])})}}}class N extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.HIGHLIGHT;if(this.data.quadPoints=f(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[1,1,0];this._setDefaultAppearance({xref:e.xref,fillColor:t,blendMode:"Multiply",pointsCallback:(e,t)=>(e.push(`${t[0].x} ${t[0].y} m`),e.push(`${t[1].x} ${t[1].y} l`),e.push(`${t[3].x} ${t[3].y} l`),e.push(`${t[2].x} ${t[2].y} l`),e.push("f"),[t[0].x,t[1].x,t[3].y,t[1].y])})}}else this.data.hasPopup=!1}}class D extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.UNDERLINE;if(this.data.quadPoints=f(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];this._setDefaultAppearance({xref:e.xref,extra:"[] 0 d 1 w",strokeColor:t,pointsCallback:(e,t)=>(e.push(`${t[2].x} ${t[2].y} m`),e.push(`${t[3].x} ${t[3].y} l`),e.push("S"),[t[0].x,t[1].x,t[3].y,t[1].y])})}}else this.data.hasPopup=!1}}class B extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.SQUIGGLY;if(this.data.quadPoints=f(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];this._setDefaultAppearance({xref:e.xref,extra:"[] 0 d 1 w",strokeColor:t,pointsCallback:(e,t)=>{const r=(t[0].y-t[2].y)/6;let a=r,i=t[2].x;const n=t[2].y,s=t[3].x;e.push(`${i} ${n+a} m`);do{i+=2,a=0===a?r:0,e.push(`${i} ${n+a} l`)}while(i<s);return e.push("S"),[t[2].x,s,n-2*r,n+2*r]}})}}else this.data.hasPopup=!1}}class j extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.STRIKEOUT;if(this.data.quadPoints=f(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];this._setDefaultAppearance({xref:e.xref,extra:"[] 0 d 1 w",strokeColor:t,pointsCallback:(e,t)=>(e.push((t[0].x+t[2].x)/2+` ${(t[0].y+t[2].y)/2} m`),e.push((t[1].x+t[3].x)/2+` ${(t[1].y+t[3].y)/2} l`),e.push("S"),[t[0].x,t[1].x,t[3].y,t[1].y])})}}else this.data.hasPopup=!1}}class L extends b{constructor(e){super(e),this.data.annotationType=a.AnnotationType.STAMP}}class R extends b{constructor(e){super(e);const t=new i.FileSpec(e.dict.get("FS"),e.xref);this.data.annotationType=a.AnnotationType.FILEATTACHMENT,this.data.file=t.serializable}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.createDefaultAppearance=function({fontSize:e,fontName:t,fontColor:r}){let a;a=r.every((e=>0===e))?"0 g":Array.from(r).map((e=>(e/255).toFixed(2))).join(" ")+" rg";return`/${(0,n.escapePDFName)(t)} ${e} Tf ${a}`},t.parseDefaultAppearance=function(e){return new l(e).parse()};var a=r(2),i=r(23),n=r(8),s=r(29),o=r(5),c=r(12);class l extends s.EvaluatorPreprocessor{constructor(e){super(new c.StringStream(e))}parse(){const e={fn:0,args:[]},t={fontSize:0,fontName:"",fontColor:new Uint8ClampedArray(3)};try{for(;e.args.length=0,this.read(e);){if(0!==this.savedStatesDepth)continue;const{fn:r,args:n}=e;switch(0|r){case a.OPS.setFont:const[e,r]=n;e instanceof o.Name&&(t.fontName=e.name),"number"==typeof r&&r>0&&(t.fontSize=r);break;case a.OPS.setFillRGBColor:i.ColorSpace.singletons.rgb.getRgbItem(n,0,t.fontColor,0);break;case a.OPS.setFillGray:i.ColorSpace.singletons.gray.getRgbItem(n,0,t.fontColor,0);break;case a.OPS.setFillColorSpace:i.ColorSpace.singletons.cmyk.getRgbItem(n,0,t.fontColor,0);break}}}catch(e){(0,a.warn)(`parseDefaultAppearance - ignoring errors: "${e}".`)}return t}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PartialEvaluator=t.EvaluatorPreprocessor=void 0;var a=r(2),i=r(30),n=r(5),s=r(12),o=r(31),c=r(34),l=r(37),h=r(36),u=r(40),d=r(41),f=r(11),g=r(24),p=r(43),m=r(23),b=r(35),y=r(8),w=r(44),v=r(45),S=r(46),k=r(47);const x=Object.freeze({maxImageSize:-1,disableFontFace:!1,ignoreErrors:!1,isEvalSupported:!0,fontExtraProperties:!1}),A=1,C=2,O=Promise.resolve();function F(e,t=!1){if(Array.isArray(e)){for(let t=0,r=e.length;t<r;t++){const r=F(e[t],!0);if(r)return r}return(0,a.warn)(`Unsupported blend mode Array: ${e}`),"source-over"}if(!(0,n.isName)(e))return t?null:"source-over";switch(e.name){case"Normal":case"Compatible":return"source-over";case"Multiply":return"multiply";case"Screen":return"screen";case"Overlay":return"overlay";case"Darken":return"darken";case"Lighten":return"lighten";case"ColorDodge":return"color-dodge";case"ColorBurn":return"color-burn";case"HardLight":return"hard-light";case"SoftLight":return"soft-light";case"Difference":return"difference";case"Exclusion":return"exclusion";case"Hue":return"hue";case"Saturation":return"saturation";case"Color":return"color";case"Luminosity":return"luminosity"}return t?null:((0,a.warn)(`Unsupported blend mode: ${e.name}`),"source-over")}class I{static get TIME_SLOT_DURATION_MS(){return(0,a.shadow)(this,"TIME_SLOT_DURATION_MS",20)}static get CHECK_TIME_EVERY(){return(0,a.shadow)(this,"CHECK_TIME_EVERY",100)}constructor(){this.reset()}check(){return!(++this.checked<I.CHECK_TIME_EVERY)&&(this.checked=0,this.endTime<=Date.now())}reset(){this.endTime=Date.now()+I.TIME_SLOT_DURATION_MS,this.checked=0}}class T{constructor({xref:e,handler:t,pageIndex:r,idFactory:a,fontCache:i,builtInCMapCache:n,globalImageCache:s,options:o=null}){this.xref=e,this.handler=t,this.pageIndex=r,this.idFactory=a,this.fontCache=i,this.builtInCMapCache=n,this.globalImageCache=s,this.options=o||x,this.parsingType3Font=!1,this._fetchBuiltInCMapBound=this.fetchBuiltInCMap.bind(this)}get _pdfFunctionFactory(){const e=new d.PDFFunctionFactory({xref:this.xref,isEvalSupported:this.options.isEvalSupported});return(0,a.shadow)(this,"_pdfFunctionFactory",e)}clone(e=x){var t=Object.create(this);return t.options=e,t}hasBlendModes(e,t){if(!(e instanceof n.Dict))return!1;if(e.objId&&t.has(e.objId))return!1;const r=new n.RefSet(t);e.objId&&r.put(e.objId);for(var i=[e],s=this.xref;i.length;){var o=i.shift(),c=o.get("ExtGState");if(c instanceof n.Dict)for(let e of c.getRawValues()){if(e instanceof n.Ref){if(r.has(e))continue;try{e=s.fetch(e)}catch(t){r.put(e),(0,a.info)(`hasBlendModes - ignoring ExtGState: "${t}".`);continue}}if(!(e instanceof n.Dict))continue;e.objId&&r.put(e.objId);const t=e.get("BM");if(t instanceof n.Name){if("Normal"!==t.name)return!0}else if(void 0!==t&&Array.isArray(t))for(const e of t)if(e instanceof n.Name&&"Normal"!==e.name)return!0}var l=o.get("XObject");if(l instanceof n.Dict)for(let e of l.getRawValues()){if(e instanceof n.Ref){if(r.has(e))continue;try{e=s.fetch(e)}catch(t){r.put(e),(0,a.info)(`hasBlendModes - ignoring XObject: "${t}".`);continue}}if((0,n.isStream)(e)){e.dict.objId&&r.put(e.dict.objId);var h=e.dict.get("Resources");h instanceof n.Dict&&(h.objId&&r.has(h.objId)||(i.push(h),h.objId&&r.put(h.objId)))}}}return r.forEach((e=>{t.put(e)})),!1}async fetchBuiltInCMap(e){const t=this.builtInCMapCache.get(e);if(t)return t;const r=this.handler.sendWithStream("FetchBuiltInCMap",{name:e}).getReader(),i=await new Promise((function(e,t){!function a(){r.read().then((function({value:t,done:r}){r||(e(t),a())}),t)}()}));return i.compressionType!==a.CMapCompressionType.NONE&&this.builtInCMapCache.set(e,i),i}async buildFormXObject(e,t,r,i,s,o,c){var l=t.dict,h=l.getArray("Matrix"),u=l.getArray("BBox");u=Array.isArray(u)&&4===u.length?a.Util.normalizeRect(u):null;let d=null;l.has("OC")&&(d=await this.parseMarkedContentProps(l.get("OC"),e),i.addOp(a.OPS.beginMarkedContentProps,["OC",d]));var f=l.get("Group");if(f){var g={matrix:h,bbox:u,smask:r,isolated:!1,knockout:!1},p=f.get("S"),b=null;if((0,n.isName)(p,"Transparency")&&(g.isolated=f.get("I")||!1,g.knockout=f.get("K")||!1,f.has("CS"))){const t=f.getRaw("CS"),r=m.ColorSpace.getCached(t,this.xref,c);b=r||await this.parseColorSpace({cs:t,resources:e,localColorSpaceCache:c})}r&&r.backdrop&&(b=b||m.ColorSpace.singletons.rgb,r.backdrop=b.getRgb(r.backdrop,0)),i.addOp(a.OPS.beginGroup,[g])}return i.addOp(a.OPS.paintFormXObjectBegin,[h,u]),this.getOperatorList({stream:t,task:s,resources:l.get("Resources")||e,operatorList:i,initialState:o}).then((function(){i.addOp(a.OPS.paintFormXObjectEnd,[]),f&&i.addOp(a.OPS.endGroup,[g]),d&&i.addOp(a.OPS.endMarkedContent,[])}))}_sendImgData(e,t,r=!1){const a=t?[t.data.buffer]:null;return this.parsingType3Font||r?this.handler.send("commonobj",[e,"Image",t],a):this.handler.send("obj",[e,this.pageIndex,"Image",t],a)}async buildPaintImageXObject({resources:e,image:t,isInline:r=!1,operatorList:i,cacheKey:n,localImageCache:o,localColorSpaceCache:c}){var l=t.dict;const h=l.objId;var u=l.get("Width","W"),d=l.get("Height","H");if(!(u&&(0,a.isNum)(u)&&d&&(0,a.isNum)(d)))return void(0,a.warn)("Image dimensions are missing, or not numbers.");var f,g,p=this.options.maxImageSize;if(-1!==p&&u*d>p)return void(0,a.warn)("Image exceeded maximum allowed size and was removed.");if(l.get("ImageMask","IM")||!1){var m=l.get("Width","W"),b=l.get("Height","H"),y=m+7>>3,w=t.getBytes(y*b,!0),v=l.getArray("Decode","D");return(f=k.PDFImage.createMask({imgArray:w,width:m,height:b,imageIsFromDecodeStream:t instanceof s.DecodeStream,inverseDecode:!!v&&v[0]>0})).cached=!!n,g=[f],i.addOp(a.OPS.paintImageMaskXObject,g),void(n&&o.set(n,h,{fn:a.OPS.paintImageMaskXObject,args:g}))}var S=l.get("SMask","SM")||!1,x=l.get("Mask")||!1;if(r&&!S&&!x&&u+d<200){const n=new k.PDFImage({xref:this.xref,res:e,image:t,isInline:r,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:c});return f=n.createImageData(!0),void i.addOp(a.OPS.paintInlineImageXObject,[f])}let A=`img_${this.idFactory.createObjId()}`,C=!1;this.parsingType3Font?A=`${this.idFactory.getDocId()}_type3_${A}`:h&&(C=this.globalImageCache.shouldCache(h,this.pageIndex),C&&(A=`${this.idFactory.getDocId()}_${A}`)),i.addDependency(A),g=[A,u,d],k.PDFImage.buildImage({xref:this.xref,res:e,image:t,isInline:r,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:c}).then((e=>(f=e.createImageData(!1),n&&h&&C&&this.globalImageCache.addByteSize(h,f.data.length),this._sendImgData(A,f,C)))).catch((e=>((0,a.warn)(`Unable to decode image "${A}": "${e}".`),this._sendImgData(A,null,C)))),i.addOp(a.OPS.paintImageXObject,g),n&&(o.set(n,h,{fn:a.OPS.paintImageXObject,args:g}),h&&((0,a.assert)(!r,"Cannot cache an inline image globally."),this.globalImageCache.addPageIndex(h,this.pageIndex),C&&this.globalImageCache.setData(h,{objId:A,fn:a.OPS.paintImageXObject,args:g,byteSize:0})))}handleSMask(e,t,r,a,i,n){var s=e.get("G"),o={subtype:e.get("S").name,backdrop:e.get("BC")},c=e.get("TR");if((0,d.isPDFFunction)(c)){const e=this._pdfFunctionFactory.create(c);for(var l=new Uint8Array(256),h=new Float32Array(1),u=0;u<256;u++)h[0]=u/255,e(h,0,h,0),l[u]=255*h[0]|0;o.transferMap=l}return this.buildFormXObject(t,s,o,r,a,i.state.clone(),n)}handleTransferFunction(e){let t;if(Array.isArray(e))t=e;else{if(!(0,d.isPDFFunction)(e))return null;t=[e]}const r=[];let a=0,i=0;for(const e of t){const t=this.xref.fetchIfRef(e);if(a++,(0,n.isName)(t,"Identity")){r.push(null);continue}if(!(0,d.isPDFFunction)(t))return null;const s=this._pdfFunctionFactory.create(t),o=new Uint8Array(256),c=new Float32Array(1);for(let e=0;e<256;e++)c[0]=e/255,s(c,0,c,0),o[e]=255*c[0]|0;r.push(o),i++}return 1!==a&&4!==a||0===i?null:r}handleTilingType(e,t,r,i,s,o,c,l,h){const d=new S.OperatorList,f=n.Dict.merge({xref:this.xref,dictArray:[s.get("Resources"),r]});return this.getOperatorList({stream:i,task:c,resources:f,operatorList:d}).then((function(){const r=d.getIR(),a=(0,u.getTilingPatternIR)(r,s,t);o.addDependencies(d.dependencies),o.addOp(e,a),l&&h.set(l,s.objId,{operatorListIR:r,dict:s})})).catch((e=>{if(!(e instanceof a.AbortException)){if(this.options.ignoreErrors)return this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorTilingPattern}),void(0,a.warn)(`handleTilingType - ignoring pattern: "${e}".`);throw e}}))}handleSetFont(e,t,r,i,s,c,l=null){const h=t&&t[0]instanceof n.Name?t[0].name:null;return this.loadFont(h,r,e,l).then((t=>t.font.isType3Font?t.loadType3Data(this,e,s).then((function(){return i.addDependencies(t.type3Dependencies),t})).catch((e=>(this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontLoadType3}),new P({loadedName:"g_font_error",font:new o.ErrorFont(`Type3 font load error: ${e}`),dict:t.font,extraProperties:this.options.fontExtraProperties})))):t)).then((e=>(c.font=e.font,e.send(this.handler),e.loadedName)))}handleText(e,t){const r=t.font,i=r.charsToGlyphs(e);if(r.data){(!!(t.textRenderingMode&a.TextRenderingMode.ADD_TO_PATH_FLAG)||"Pattern"===t.fillColorSpace.name||r.disableFontFace||this.options.disableFontFace)&&T.buildFontPaths(r,i,this.handler)}return i}ensureStateFont(e){if(e.font)return;const t=new a.FormatError("Missing setFont (Tf) operator before text rendering operator.");if(this.options.ignoreErrors)return this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontState}),void(0,a.warn)(`ensureStateFont: "${t}".`);throw t}async setGState({resources:e,gState:t,operatorList:r,cacheKey:i,task:s,stateManager:o,localGStateCache:c,localColorSpaceCache:l}){const h=t.objId;let u=!0;for(var d=[],f=t.getKeys(),g=Promise.resolve(),p=0,m=f.length;p<m;p++){const i=f[p],c=t.get(i);switch(i){case"Type":break;case"LW":case"LC":case"LJ":case"ML":case"D":case"RI":case"FL":case"CA":case"ca":d.push([i,c]);break;case"Font":u=!1,g=g.then((()=>this.handleSetFont(e,null,c[0],r,s,o.state).then((function(e){r.addDependency(e),d.push([i,[e,c[1]]])}))));break;case"BM":d.push([i,F(c)]);break;case"SMask":if((0,n.isName)(c,"None")){d.push([i,!1]);break}(0,n.isDict)(c)?(u=!1,g=g.then((()=>this.handleSMask(c,e,r,s,o,l))),d.push([i,!0])):(0,a.warn)("Unsupported SMask type");break;case"TR":const t=this.handleTransferFunction(c);d.push([i,t]);break;case"OP":case"op":case"OPM":case"BG":case"BG2":case"UCR":case"UCR2":case"TR2":case"HT":case"SM":case"SA":case"AIS":case"TK":(0,a.info)("graphic state operator "+i);break;default:(0,a.info)("Unknown graphic state operator "+i);break}}return g.then((function(){d.length>0&&r.addOp(a.OPS.setGState,[d]),u&&c.set(i,h,d)}))}loadFont(e,t,r,i=null){const s=async()=>new P({loadedName:"g_font_error",font:new o.ErrorFont(`Font "${e}" is not available.`),dict:t,extraProperties:this.options.fontExtraProperties});var c,l=this.xref;if(t){if(!(0,n.isRef)(t))throw new a.FormatError('The "font" object should be a reference.');c=t}else{var h=r.get("Font");h&&(c=h.getRaw(e))}if(!c){const r=`Font "${e||t&&t.toString()}" is not available`;if(!this.options.ignoreErrors&&!this.parsingType3Font)return(0,a.warn)(`${r}.`),s();this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontMissing}),(0,a.warn)(`${r} -- attempting to fallback to a default font.`),c=i||T.fallbackFontDict}if(this.fontCache.has(c))return this.fontCache.get(c);if(t=l.fetchIfRef(c),!(0,n.isDict)(t))return s();if(t.cacheKey&&this.fontCache.has(t.cacheKey))return this.fontCache.get(t.cacheKey);var u=(0,a.createPromiseCapability)();let d;try{d=this.preEvaluateFont(t)}catch(e){return(0,a.warn)(`loadFont - preEvaluateFont failed: "${e}".`),s()}const{descriptor:f,hash:g}=d;var p,m=(0,n.isRef)(c);if(m&&(p=`f${c.toString()}`),g&&(0,n.isDict)(f)){f.fontAliases||(f.fontAliases=Object.create(null));var b=f.fontAliases;if(b[g]){var y=b[g].aliasRef;if(m&&y&&this.fontCache.has(y))return this.fontCache.putAlias(c,y),this.fontCache.get(c)}else b[g]={fontID:this.idFactory.createFontId()};m&&(b[g].aliasRef=c),p=b[g].fontID}return m?this.fontCache.put(c,u.promise):(p||(p=this.idFactory.createFontId()),t.cacheKey=`cacheKey_${p}`,this.fontCache.put(t.cacheKey,u.promise)),(0,a.assert)(p&&p.startsWith("f"),'The "fontID" must be (correctly) defined.'),t.loadedName=`${this.idFactory.getDocId()}_${p}`,this.translateFont(d).then((e=>{void 0!==e.fontType&&(l.stats.fontTypes[e.fontType]=!0);u.resolve(new P({loadedName:t.loadedName,font:e,dict:t,extraProperties:this.options.fontExtraProperties}))})).catch((e=>{this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontTranslate}),(0,a.warn)(`loadFont - translateFont failed: "${e}".`);try{var r=f&&f.get("FontFile3"),i=r&&r.get("Subtype"),n=(0,o.getFontType)(d.type,i&&i.name);l.stats.fontTypes[n]=!0}catch(e){}u.resolve(new P({loadedName:t.loadedName,font:new o.ErrorFont(e instanceof Error?e.message:e),dict:t,extraProperties:this.options.fontExtraProperties}))})),u.promise}buildPath(e,t,r,i=!1){var n=e.length-1;if(r||(r=[]),n<0||e.fnArray[n]!==a.OPS.constructPath)i&&((0,a.warn)(`Encountered path operator "${t}" inside of a text object.`),e.addOp(a.OPS.save,null)),e.addOp(a.OPS.constructPath,[[t],r]),i&&e.addOp(a.OPS.restore,null);else{var s=e.argsArray[n];s[0].push(t),Array.prototype.push.apply(s[1],r)}}parseColorSpace({cs:e,resources:t,localColorSpaceCache:r}){return m.ColorSpace.parseAsync({cs:e,xref:this.xref,resources:t,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:r}).catch((e=>{if(e instanceof a.AbortException)return null;if(this.options.ignoreErrors)return this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorColorSpace}),(0,a.warn)(`parseColorSpace - ignoring ColorSpace: "${e}".`),null;throw e}))}handleColorN(e,t,r,i,s,o,c,l,h){const d=r.pop();if(d instanceof n.Name){const b=d.name,y=h.getByName(b);if(y)try{const a=i.base?i.base.getRgb(r,0):null,n=(0,u.getTilingPatternIR)(y.operatorListIR,y.dict,a);return void e.addOp(t,n)}catch(e){}let w=s.get(b);if(w){var f=(0,n.isStream)(w)?w.dict:w,g=f.get("PatternType");if(g===A){const a=i.base?i.base.getRgb(r,0):null;return this.handleTilingType(t,a,o,w,f,e,c,b,h)}if(g===C){var p=f.get("Shading"),m=f.getArray("Matrix");return w=u.Pattern.parseShading(p,m,this.xref,o,this.handler,this._pdfFunctionFactory,l),void e.addOp(t,w.getIR())}throw new a.FormatError(`Unknown PatternType: ${g}`)}}throw new a.FormatError(`Unknown PatternName: ${d}`)}async parseMarkedContentProps(e,t){let r;if((0,n.isName)(e)){r=t.get("Properties").get(e.name)}else{if(!(0,n.isDict)(e))throw new a.FormatError("Optional content properties malformed.");r=e}const i=r.get("Type").name;if("OCG"===i)return{type:i,id:r.objId};if("OCMD"===i){const e=r.get("OCGs");if(Array.isArray(e)||(0,n.isDict)(e)){const t=[];Array.isArray(e)?r.get("OCGs").forEach((e=>{t.push(e.toString())})):t.push(e.objId);let a=null;return r.get("VE")&&(a=!0),{type:i,ids:t,policy:(0,n.isName)(r.get("P"))?r.get("P").name:null,expression:a}}if((0,n.isRef)(e))return{type:i,id:e.toString()}}return null}getOperatorList({stream:e,task:t,resources:r,operatorList:i,initialState:s=null,fallbackFontDict:o=null}){if(r=r||n.Dict.empty,s=s||new N,!i)throw new Error('getOperatorList: missing "operatorList" parameter');var c=this,l=this.xref;let h=!1;const d=new g.LocalImageCache,f=new g.LocalColorSpaceCache,p=new g.LocalGStateCache,b=new g.LocalTilingPatternCache;var y=r.get("XObject")||n.Dict.empty,w=r.get("Pattern")||n.Dict.empty,v=new E(s),S=new D(e,l,v),k=new I;function x(e){for(var t=0,r=S.savedStatesDepth;t<r;t++)i.addOp(a.OPS.restore,[])}return new Promise((function e(s,g){const A=function(t){Promise.all([t,i.ready]).then((function(){try{e(s,g)}catch(e){g(e)}}),g)};t.ensureNotTerminated(),k.reset();for(var C,F,I,T,P,E={};!(C=k.check())&&(E.args=null,S.read(E));){var M=E.args,N=E.fn;switch(0|N){case a.OPS.paintXObject:if(P=M[0].name){const e=d.getByName(P);if(e){i.addOp(e.fn,e.args),M=null;continue}}return void A(new Promise((function(e,s){if(!P)throw new a.FormatError("XObject must be referred to by name.");let o=y.getRaw(P);if(o instanceof n.Ref){const t=d.getByRef(o);if(t)return i.addOp(t.fn,t.args),void e();const r=c.globalImageCache.getData(o,c.pageIndex);if(r)return i.addDependency(r.objId),i.addOp(r.fn,r.args),void e();o=l.fetch(o)}if(!(0,n.isStream)(o))throw new a.FormatError("XObject should be a stream");const h=o.dict.get("Subtype");if(!(0,n.isName)(h))throw new a.FormatError("XObject should have a Name subtype");if("Form"===h.name)return v.save(),void c.buildFormXObject(r,o,null,i,t,v.state.clone(),f).then((function(){v.restore(),e()}),s);if("Image"!==h.name){if("PS"!==h.name)throw new a.FormatError(`Unhandled XObject subtype ${h.name}`);(0,a.info)("Ignored XObject subtype PS"),e()}else c.buildPaintImageXObject({resources:r,image:o,operatorList:i,cacheKey:P,localImageCache:d,localColorSpaceCache:f}).then(e,s)})).catch((function(e){if(!(e instanceof a.AbortException)){if(c.options.ignoreErrors)return c.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorXObject}),void(0,a.warn)(`getOperatorList - ignoring XObject: "${e}".`);throw e}})));case a.OPS.setFont:var D=M[1];return void A(c.handleSetFont(r,M,null,i,t,v.state,o).then((function(e){i.addDependency(e),i.addOp(a.OPS.setFont,[e,D])})));case a.OPS.beginText:h=!0;break;case a.OPS.endText:h=!1;break;case a.OPS.endInlineImage:var B=M[0].cacheKey;if(B){const e=d.getByName(B);if(e){i.addOp(e.fn,e.args),M=null;continue}}return void A(c.buildPaintImageXObject({resources:r,image:M[0],isInline:!0,operatorList:i,cacheKey:B,localImageCache:d,localColorSpaceCache:f}));case a.OPS.showText:if(!v.state.font){c.ensureStateFont(v.state);continue}M[0]=c.handleText(M[0],v.state);break;case a.OPS.showSpacedText:if(!v.state.font){c.ensureStateFont(v.state);continue}var j=M[0],L=[],R=j.length,_=v.state;for(F=0;F<R;++F){var U=j[F];(0,a.isString)(U)?Array.prototype.push.apply(L,c.handleText(U,_)):(0,a.isNum)(U)&&L.push(U)}M[0]=L,N=a.OPS.showText;break;case a.OPS.nextLineShowText:if(!v.state.font){c.ensureStateFont(v.state);continue}i.addOp(a.OPS.nextLine),M[0]=c.handleText(M[0],v.state),N=a.OPS.showText;break;case a.OPS.nextLineSetSpacingShowText:if(!v.state.font){c.ensureStateFont(v.state);continue}i.addOp(a.OPS.nextLine),i.addOp(a.OPS.setWordSpacing,[M.shift()]),i.addOp(a.OPS.setCharSpacing,[M.shift()]),M[0]=c.handleText(M[0],v.state),N=a.OPS.showText;break;case a.OPS.setTextRenderingMode:v.state.textRenderingMode=M[0];break;case a.OPS.setFillColorSpace:{const e=m.ColorSpace.getCached(M[0],l,f);if(e){v.state.fillColorSpace=e;continue}return void A(c.parseColorSpace({cs:M[0],resources:r,localColorSpaceCache:f}).then((function(e){e&&(v.state.fillColorSpace=e)})))}case a.OPS.setStrokeColorSpace:{const e=m.ColorSpace.getCached(M[0],l,f);if(e){v.state.strokeColorSpace=e;continue}return void A(c.parseColorSpace({cs:M[0],resources:r,localColorSpaceCache:f}).then((function(e){e&&(v.state.strokeColorSpace=e)})))}case a.OPS.setFillColor:M=(T=v.state.fillColorSpace).getRgb(M,0),N=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeColor:M=(T=v.state.strokeColorSpace).getRgb(M,0),N=a.OPS.setStrokeRGBColor;break;case a.OPS.setFillGray:v.state.fillColorSpace=m.ColorSpace.singletons.gray,M=m.ColorSpace.singletons.gray.getRgb(M,0),N=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeGray:v.state.strokeColorSpace=m.ColorSpace.singletons.gray,M=m.ColorSpace.singletons.gray.getRgb(M,0),N=a.OPS.setStrokeRGBColor;break;case a.OPS.setFillCMYKColor:v.state.fillColorSpace=m.ColorSpace.singletons.cmyk,M=m.ColorSpace.singletons.cmyk.getRgb(M,0),N=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeCMYKColor:v.state.strokeColorSpace=m.ColorSpace.singletons.cmyk,M=m.ColorSpace.singletons.cmyk.getRgb(M,0),N=a.OPS.setStrokeRGBColor;break;case a.OPS.setFillRGBColor:v.state.fillColorSpace=m.ColorSpace.singletons.rgb,M=m.ColorSpace.singletons.rgb.getRgb(M,0);break;case a.OPS.setStrokeRGBColor:v.state.strokeColorSpace=m.ColorSpace.singletons.rgb,M=m.ColorSpace.singletons.rgb.getRgb(M,0);break;case a.OPS.setFillColorN:if("Pattern"===(T=v.state.fillColorSpace).name)return void A(c.handleColorN(i,a.OPS.setFillColorN,M,T,w,r,t,f,b));M=T.getRgb(M,0),N=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeColorN:if("Pattern"===(T=v.state.strokeColorSpace).name)return void A(c.handleColorN(i,a.OPS.setStrokeColorN,M,T,w,r,t,f,b));M=T.getRgb(M,0),N=a.OPS.setStrokeRGBColor;break;case a.OPS.shadingFill:var X=r.get("Shading");if(!X)throw new a.FormatError("No shading resource found");var $=X.get(M[0].name);if(!$)throw new a.FormatError("No shading object found");M=[u.Pattern.parseShading($,null,l,r,c.handler,c._pdfFunctionFactory,f).getIR()],N=a.OPS.shadingFill;break;case a.OPS.setGState:if(P=M[0].name){const e=p.getByName(P);if(e){e.length>0&&i.addOp(a.OPS.setGState,[e]),M=null;continue}}return void A(new Promise((function(e,s){if(!P)throw new a.FormatError("GState must be referred to by name.");const o=r.get("ExtGState");if(!(o instanceof n.Dict))throw new a.FormatError("ExtGState should be a dictionary.");const l=o.get(P);if(!(l instanceof n.Dict))throw new a.FormatError("GState should be a dictionary.");c.setGState({resources:r,gState:l,operatorList:i,cacheKey:P,task:t,stateManager:v,localGStateCache:p,localColorSpaceCache:f}).then(e,s)})).catch((function(e){if(!(e instanceof a.AbortException)){if(c.options.ignoreErrors)return c.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorExtGState}),void(0,a.warn)(`getOperatorList - ignoring ExtGState: "${e}".`);throw e}})));case a.OPS.moveTo:case a.OPS.lineTo:case a.OPS.curveTo:case a.OPS.curveTo2:case a.OPS.curveTo3:case a.OPS.closePath:case a.OPS.rectangle:c.buildPath(i,N,M,h);continue;case a.OPS.markPoint:case a.OPS.markPointProps:case a.OPS.beginCompat:case a.OPS.endCompat:continue;case a.OPS.beginMarkedContentProps:if(!(0,n.isName)(M[0])){(0,a.warn)(`Expected name for beginMarkedContentProps arg0=${M[0]}`);continue}if("OC"===M[0].name)return void A(c.parseMarkedContentProps(M[1],r).then((e=>{i.addOp(a.OPS.beginMarkedContentProps,["OC",e])})).catch((e=>{if(!(e instanceof a.AbortException)){if(c.options.ignoreErrors)return c.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorMarkedContent}),void(0,a.warn)(`getOperatorList - ignoring beginMarkedContentProps: "${e}".`);throw e}})));M=[M[0].name];break;case a.OPS.beginMarkedContent:case a.OPS.endMarkedContent:default:if(null!==M){for(F=0,I=M.length;F<I&&!(M[F]instanceof n.Dict);F++);if(F<I){(0,a.warn)("getOperatorList - ignoring operator: "+N);continue}}}i.addOp(N,M)}C?A(O):(x(),s())})).catch((e=>{if(!(e instanceof a.AbortException)){if(this.options.ignoreErrors)return this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorOperatorList}),(0,a.warn)(`getOperatorList - ignoring errors during "${t.name}" task: "${e}".`),void x();throw e}}))}getTextContent({stream:e,task:t,resources:r,stateManager:i=null,normalizeWhitespace:s=!1,combineTextItems:o=!1,sink:c,seenStyles:h=new Set}){r=r||n.Dict.empty,i=i||new E(new M);var u=/\s/g,d={items:[],styles:Object.create(null)},f={initialized:!1,str:[],width:0,height:0,vertical:!1,lastAdvanceWidth:0,lastAdvanceHeight:0,textAdvanceScale:0,spaceWidth:0,fakeSpaceMin:1/0,fakeMultiSpaceMin:1/0,fakeMultiSpaceMax:-0,textRunBreakAllowed:!1,transform:null,fontName:null},m=this,b=this.xref,y=null;const w=new g.LocalImageCache,v=new g.LocalGStateCache;var S,k=new D(e,b,i);function x(){if(f.initialized)return f;const e=S.font,t=e.loadedName;h.has(t)||(h.add(t),d.styles[t]={fontFamily:e.fallbackName,ascent:e.ascent,descent:e.descent,vertical:e.vertical}),f.fontName=t;var r=[S.fontSize*S.textHScale,0,0,S.fontSize,0,S.textRise];if(e.isType3Font&&S.fontSize<=1&&!(0,a.isArrayEqual)(S.fontMatrix,a.FONT_IDENTITY_MATRIX)){const t=e.bbox[3]-e.bbox[1];t>0&&(r[3]*=t*S.fontMatrix[3])}var i=a.Util.transform(S.ctm,a.Util.transform(S.textMatrix,r));f.transform=i,e.vertical?(f.width=Math.hypot(i[0],i[1]),f.height=0,f.vertical=!0):(f.width=0,f.height=Math.hypot(i[2],i[3]),f.vertical=!1);const n=Math.hypot(S.textLineMatrix[0],S.textLineMatrix[1]),s=Math.hypot(S.ctm[0],S.ctm[1]);f.textAdvanceScale=s*n,f.lastAdvanceWidth=0,f.lastAdvanceHeight=0;var o=e.spaceWidth/1e3*S.fontSize;return o?(f.spaceWidth=o,f.fakeSpaceMin=.3*o,f.fakeMultiSpaceMin=1.5*o,f.fakeMultiSpaceMax=4*o,f.textRunBreakAllowed=!e.isMonospace):(f.spaceWidth=0,f.fakeSpaceMin=1/0,f.fakeMultiSpaceMin=1/0,f.fakeMultiSpaceMax=0,f.textRunBreakAllowed=!1),f.initialized=!0,f}function A(e){for(var t,r=0,a=e.length;r<a&&(t=e.charCodeAt(r))>=32&&t<=127;)r++;return r<a?e.replace(u," "):e}function C(e,t){return m.loadFont(e,t,r).then((function(e){S.font=e.font,S.fontMatrix=e.font.fontMatrix||a.FONT_IDENTITY_MATRIX}))}function F(e){for(var t=S.font,r=x(),a=0,i=0,n=t.charsToGlyphs(e),s=0;s<n.length;s++){var o=n[s],c=null;c=t.vertical&&o.vmetric?o.vmetric[0]:o.width;var h=o.unicode,u=(0,l.getNormalizedUnicodes)();void 0!==u[h]&&(h=u[h]),h=(0,l.reverseIfRtl)(h);var d=S.charSpacing;if(o.isSpace){var f=S.wordSpacing;d+=f,f>0&&T(f,r.str)}var g=0,p=0;if(t.vertical)i+=p=c*S.fontMatrix[0]*S.fontSize+d;else a+=g=(c*S.fontMatrix[0]*S.fontSize+d)*S.textHScale;S.translateTextMatrix(g,p),r.str.push(h)}return t.vertical?(r.lastAdvanceHeight=i,r.height+=Math.abs(i)):(r.lastAdvanceWidth=a,r.width+=a),r}function T(e,t){if(!(e<f.fakeSpaceMin))if(e<f.fakeMultiSpaceMin)t.push(" ");else for(var r=Math.round(e/f.spaceWidth);r-- >0;)t.push(" ")}function P(){var e,t,r;f.initialized&&(f.vertical?f.height*=f.textAdvanceScale:f.width*=f.textAdvanceScale,d.items.push((t=(e=f).str.join(""),r=(0,p.bidi)(t,-1,e.vertical),{str:s?A(r.str):r.str,dir:r.dir,width:e.width,height:e.height,transform:e.transform,fontName:e.fontName})),f.initialized=!1,f.str.length=0)}function N(){const e=d.items.length;e>0&&(c.enqueue(d,e),d.items=[],d.styles=Object.create(null))}var B=new I;return new Promise((function e(l,u){const g=function(t){N(),Promise.all([t,c.ready]).then((function(){try{e(l,u)}catch(e){u(e)}}),u)};t.ensureNotTerminated(),B.reset();for(var p,A={},I=[];!(p=B.check())&&(I.length=0,A.args=I,k.read(A));){S=i.state;var M,D=A.fn;switch(I=A.args,0|D){case a.OPS.setFont:var j=I[0].name,L=I[1];if(S.font&&j===S.fontName&&L===S.fontSize)break;return P(),S.fontName=j,S.fontSize=L,void g(C(j,null));case a.OPS.setTextRise:P(),S.textRise=I[0];break;case a.OPS.setHScale:P(),S.textHScale=I[0]/100;break;case a.OPS.setLeading:P(),S.leading=I[0];break;case a.OPS.moveText:var R=!!S.font&&0===(S.font.vertical?I[0]:I[1]);if(M=I[0]-I[1],o&&R&&f.initialized&&M>0&&M<=f.fakeMultiSpaceMax){S.translateTextLineMatrix(I[0],I[1]),f.width+=I[0]-f.lastAdvanceWidth,f.height+=I[1]-f.lastAdvanceHeight,T(I[0]-f.lastAdvanceWidth-(I[1]-f.lastAdvanceHeight),f.str);break}P(),S.translateTextLineMatrix(I[0],I[1]),S.textMatrix=S.textLineMatrix.slice();break;case a.OPS.setLeadingMoveText:P(),S.leading=-I[1],S.translateTextLineMatrix(I[0],I[1]),S.textMatrix=S.textLineMatrix.slice();break;case a.OPS.nextLine:P(),S.carriageReturn();break;case a.OPS.setTextMatrix:if(M=S.calcTextLineMatrixAdvance(I[0],I[1],I[2],I[3],I[4],I[5]),o&&null!==M&&f.initialized&&M.value>0&&M.value<=f.fakeMultiSpaceMax){S.translateTextLineMatrix(M.width,M.height),f.width+=M.width-f.lastAdvanceWidth,f.height+=M.height-f.lastAdvanceHeight,T(M.width-f.lastAdvanceWidth-(M.height-f.lastAdvanceHeight),f.str);break}P(),S.setTextMatrix(I[0],I[1],I[2],I[3],I[4],I[5]),S.setTextLineMatrix(I[0],I[1],I[2],I[3],I[4],I[5]);break;case a.OPS.setCharSpacing:S.charSpacing=I[0];break;case a.OPS.setWordSpacing:S.wordSpacing=I[0];break;case a.OPS.beginText:P(),S.textMatrix=a.IDENTITY_MATRIX.slice(),S.textLineMatrix=a.IDENTITY_MATRIX.slice();break;case a.OPS.showSpacedText:if(!i.state.font){m.ensureStateFont(i.state);continue}for(var _,U=I[0],X=0,$=U.length;X<$;X++)if("string"==typeof U[X])F(U[X]);else if((0,a.isNum)(U[X])){x(),M=U[X]*S.fontSize/1e3;var q=!1;S.font.vertical?(_=M,S.translateTextMatrix(0,_),(q=f.textRunBreakAllowed&&M>f.fakeMultiSpaceMax)||(f.height+=_)):(_=(M=-M)*S.textHScale,S.translateTextMatrix(_,0),(q=f.textRunBreakAllowed&&M>f.fakeMultiSpaceMax)||(f.width+=_)),q?P():M>0&&T(M,f.str)}break;case a.OPS.showText:if(!i.state.font){m.ensureStateFont(i.state);continue}F(I[0]);break;case a.OPS.nextLineShowText:if(!i.state.font){m.ensureStateFont(i.state);continue}P(),S.carriageReturn(),F(I[0]);break;case a.OPS.nextLineSetSpacingShowText:if(!i.state.font){m.ensureStateFont(i.state);continue}P(),S.wordSpacing=I[0],S.charSpacing=I[1],S.carriageReturn(),F(I[2]);break;case a.OPS.paintXObject:P(),y||(y=r.get("XObject")||n.Dict.empty);var z=I[0].name;if(z&&w.getByName(z))break;return void g(new Promise((function(e,l){if(!z)throw new a.FormatError("XObject must be referred to by name.");let u=y.getRaw(z);if(u instanceof n.Ref){if(w.getByRef(u))return void e();if(m.globalImageCache.getData(u,m.pageIndex))return void e();u=b.fetch(u)}if(!(0,n.isStream)(u))throw new a.FormatError("XObject should be a stream");const d=u.dict.get("Subtype");if(!(0,n.isName)(d))throw new a.FormatError("XObject should have a Name subtype");if("Form"!==d.name)return w.set(z,u.dict.objId,!0),void e();const f=i.state.clone(),g=new E(f),p=u.dict.getArray("Matrix");Array.isArray(p)&&6===p.length&&g.transform(p),N();const v={enqueueInvoked:!1,enqueue(e,t){this.enqueueInvoked=!0,c.enqueue(e,t)},get desiredSize(){return c.desiredSize},get ready(){return c.ready}};m.getTextContent({stream:u,task:t,resources:u.dict.get("Resources")||r,stateManager:g,normalizeWhitespace:s,combineTextItems:o,sink:v,seenStyles:h}).then((function(){v.enqueueInvoked||w.set(z,u.dict.objId,!0),e()}),l)})).catch((function(e){if(!(e instanceof a.AbortException)){if(!m.options.ignoreErrors)throw e;(0,a.warn)(`getTextContent - ignoring XObject: "${e}".`)}})));case a.OPS.setGState:if((z=I[0].name)&&v.getByName(z))break;return void g(new Promise((function(e,t){if(!z)throw new a.FormatError("GState must be referred to by name.");const i=r.get("ExtGState");if(!(i instanceof n.Dict))throw new a.FormatError("ExtGState should be a dictionary.");const s=i.get(z);if(!(s instanceof n.Dict))throw new a.FormatError("GState should be a dictionary.");const o=s.get("Font");if(!o)return v.set(z,s.objId,!0),void e();P(),S.fontName=null,S.fontSize=o[1],C(null,o[0]).then(e,t)})).catch((function(e){if(!(e instanceof a.AbortException)){if(!m.options.ignoreErrors)throw e;(0,a.warn)(`getTextContent - ignoring ExtGState: "${e}".`)}})))}if(d.items.length>=c.desiredSize){p=!0;break}}p?g(O):(P(),N(),l())})).catch((e=>{if(!(e instanceof a.AbortException)){if(this.options.ignoreErrors)return(0,a.warn)(`getTextContent - ignoring errors during "${t.name}" task: "${e}".`),P(),void N();throw e}}))}extractDataStructures(e,t,r){const i=this.xref;let s;var l=e.get("ToUnicode")||t.get("ToUnicode"),h=l?this.readToUnicode(l):Promise.resolve(void 0);if(r.composite){var u=e.get("CIDSystemInfo");(0,n.isDict)(u)&&(r.cidSystemInfo={registry:(0,a.stringToPDFString)(u.get("Registry")),ordering:(0,a.stringToPDFString)(u.get("Ordering")),supplement:u.get("Supplement")});var d=e.get("CIDToGIDMap");(0,n.isStream)(d)&&(s=d.getBytes())}var f,g=[],p=null;if(e.has("Encoding")){if(f=e.get("Encoding"),(0,n.isDict)(f)){if(p=f.get("BaseEncoding"),p=(0,n.isName)(p)?p.name:null,f.has("Differences"))for(var m=f.get("Differences"),b=0,y=0,w=m.length;y<w;y++){var v=i.fetchIfRef(m[y]);if((0,a.isNum)(v))b=v;else{if(!(0,n.isName)(v))throw new a.FormatError(`Invalid entry in 'Differences' array: ${v}`);g[b++]=v.name}}}else{if(!(0,n.isName)(f))throw new a.FormatError("Encoding is not a Name nor a Dict");p=f.name}"MacRomanEncoding"!==p&&"MacExpertEncoding"!==p&&"WinAnsiEncoding"!==p&&(p=null)}if(p)r.defaultEncoding=(0,c.getEncoding)(p).slice();else{var S=!!(r.flags&o.FontFlags.Symbolic),k=!!(r.flags&o.FontFlags.Nonsymbolic);f=c.StandardEncoding,"TrueType"!==r.type||k||(f=c.WinAnsiEncoding),S&&(f=c.MacRomanEncoding,r.file||(/Symbol/i.test(r.name)?f=c.SymbolSetEncoding:/Dingbats|Wingdings/i.test(r.name)&&(f=c.ZapfDingbatsEncoding))),r.defaultEncoding=f}return r.differences=g,r.baseEncodingName=p,r.hasEncoding=!!p||g.length>0,r.dict=e,h.then((e=>(r.toUnicode=e,this.buildToUnicode(r)))).then((e=>(r.toUnicode=e,s&&(r.cidToGidMap=this.readCidToGidMap(s,e)),r)))}_buildSimpleFontToUnicode(e,t=!1){(0,a.assert)(!e.composite,"Must be a simple font.");const r=[],i=e.defaultEncoding.slice(),n=e.baseEncodingName,s=e.differences;for(const e in s){const t=s[e];".notdef"!==t&&(i[e]=t)}const h=(0,b.getGlyphsUnicode)();for(const a in i){let s=i[a];if(""!==s)if(void 0!==h[s])r[a]=String.fromCharCode(h[s]);else{let i=0;switch(s[0]){case"G":3===s.length&&(i=parseInt(s.substring(1),16));break;case"g":5===s.length&&(i=parseInt(s.substring(1),16));break;case"C":case"c":if(s.length>=3&&s.length<=4){const r=s.substring(1);if(t){i=parseInt(r,16);break}if(i=+r,Number.isNaN(i)&&Number.isInteger(parseInt(r,16)))return this._buildSimpleFontToUnicode(e,!0)}break;default:const r=(0,l.getUnicodeForGlyph)(s,h);-1!==r&&(i=r)}if(i>0&&i<=1114111&&Number.isInteger(i)){if(n&&i===+a){const e=(0,c.getEncoding)(n);if(e&&(s=e[a])){r[a]=String.fromCharCode(h[s]);continue}}r[a]=String.fromCodePoint(i)}}}return new o.ToUnicodeMap(r)}buildToUnicode(e){if(e.hasIncludedToUnicodeMap=!!e.toUnicode&&e.toUnicode.length>0,e.hasIncludedToUnicodeMap)return!e.composite&&e.hasEncoding&&(e.fallbackToUnicode=this._buildSimpleFontToUnicode(e)),Promise.resolve(e.toUnicode);if(!e.composite)return Promise.resolve(this._buildSimpleFontToUnicode(e));if(e.composite&&(e.cMap.builtInCMap&&!(e.cMap instanceof i.IdentityCMap)||"Adobe"===e.cidSystemInfo.registry&&("GB1"===e.cidSystemInfo.ordering||"CNS1"===e.cidSystemInfo.ordering||"Japan1"===e.cidSystemInfo.ordering||"Korea1"===e.cidSystemInfo.ordering))){const t=e.cidSystemInfo.registry,r=e.cidSystemInfo.ordering,s=n.Name.get(t+"-"+r+"-UCS2");return i.CMapFactory.create({encoding:s,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then((function(t){const r=e.cMap,i=[];return r.forEach((function(e,r){if(r>65535)throw new a.FormatError("Max size of CID is 65,535");const n=t.lookup(r);n&&(i[e]=String.fromCharCode((n.charCodeAt(0)<<8)+n.charCodeAt(1)))})),new o.ToUnicodeMap(i)}))}return Promise.resolve(new o.IdentityToUnicodeMap(e.firstChar,e.lastChar))}readToUnicode(e){var t=e;return(0,n.isName)(t)?i.CMapFactory.create({encoding:t,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then((function(e){return e instanceof i.IdentityCMap?new o.IdentityToUnicodeMap(0,65535):new o.ToUnicodeMap(e.getMap())})):(0,n.isStream)(t)?i.CMapFactory.create({encoding:t,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then((function(e){if(e instanceof i.IdentityCMap)return new o.IdentityToUnicodeMap(0,65535);var t=new Array(e.length);return e.forEach((function(e,r){for(var a=[],i=0;i<r.length;i+=2){var n=r.charCodeAt(i)<<8|r.charCodeAt(i+1);if(55296==(63488&n)){i+=2;var s=r.charCodeAt(i)<<8|r.charCodeAt(i+1);a.push(((1023&n)<<10)+(1023&s)+65536)}else a.push(n)}t[e]=String.fromCodePoint.apply(String,a)})),new o.ToUnicodeMap(t)}),(e=>{if(e instanceof a.AbortException)return null;if(this.options.ignoreErrors)return this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontToUnicode}),(0,a.warn)(`readToUnicode - ignoring ToUnicode data: "${e}".`),null;throw e})):Promise.resolve(null)}readCidToGidMap(e,t){for(var r=[],a=0,i=e.length;a<i;a++){var n=e[a++]<<8|e[a];const i=a>>1;(0!==n||t.has(i))&&(r[i]=n)}return r}extractWidths(e,t,r){var a,i,s,c,l,h,u,d,f=this.xref,g=[],p=0,m=[];if(r.composite){if(p=e.has("DW")?e.get("DW"):1e3,d=e.get("W"))for(i=0,s=d.length;i<s;i++)if(h=f.fetchIfRef(d[i++]),u=f.fetchIfRef(d[i]),Array.isArray(u))for(c=0,l=u.length;c<l;c++)g[h++]=f.fetchIfRef(u[c]);else{var b=f.fetchIfRef(d[++i]);for(c=h;c<=u;c++)g[c]=b}if(r.vertical){var y=e.getArray("DW2")||[880,-1e3];if(a=[y[1],.5*p,y[0]],y=e.get("W2"))for(i=0,s=y.length;i<s;i++)if(h=f.fetchIfRef(y[i++]),u=f.fetchIfRef(y[i]),Array.isArray(u))for(c=0,l=u.length;c<l;c++)m[h++]=[f.fetchIfRef(u[c++]),f.fetchIfRef(u[c++]),f.fetchIfRef(u[c])];else{var w=[f.fetchIfRef(y[++i]),f.fetchIfRef(y[++i]),f.fetchIfRef(y[++i])];for(c=h;c<=u;c++)m[c]=w}}}else{var v=r.firstChar;if(d=e.get("Widths")){for(c=v,i=0,s=d.length;i<s;i++)g[c++]=f.fetchIfRef(d[i]);p=parseFloat(t.get("MissingWidth"))||0}else{var S=e.get("BaseFont");if((0,n.isName)(S)){var k=this.getBaseFontMetrics(S.name);g=this.buildCharCodeToWidth(k.widths,r),p=k.defaultWidth}}}var x=!0,A=p;for(var C in g){var O=g[C];if(O)if(A){if(A!==O){x=!1;break}}else A=O}x&&(r.flags|=o.FontFlags.FixedPitch),r.defaultWidth=p,r.widths=g,r.defaultVMetrics=a,r.vmetrics=m}isSerifFont(e){var t=e.split("-")[0];return t in(0,h.getSerifFonts)()||-1!==t.search(/serif/gi)}getBaseFontMetrics(e){var t=0,r=Object.create(null),i=!1,n=(0,h.getStdFontMap)()[e]||e,s=(0,w.getMetrics)();n in s||(n=this.isSerifFont(e)?"Times-Roman":"Helvetica");var o=s[n];return(0,a.isNum)(o)?(t=o,i=!0):r=o(),{defaultWidth:t,monospace:i,widths:r}}buildCharCodeToWidth(e,t){for(var r=Object.create(null),a=t.differences,i=t.defaultEncoding,n=0;n<256;n++)n in a&&e[a[n]]?r[n]=e[a[n]]:n in i&&e[i[n]]&&(r[n]=e[i[n]]);return r}preEvaluateFont(e){var t=e,r=e.get("Subtype");if(!(0,n.isName)(r))throw new a.FormatError("invalid font Subtype");var i,s=!1;if("Type0"===r.name){var o=e.get("DescendantFonts");if(!o)throw new a.FormatError("Descendant fonts are not specified");if(!((e=Array.isArray(o)?this.xref.fetchIfRef(o[0]):o)instanceof n.Dict))throw new a.FormatError("Descendant font is not a dictionary.");if(r=e.get("Subtype"),!(0,n.isName)(r))throw new a.FormatError("invalid font Subtype");s=!0}var c=e.get("FontDescriptor");if(c){var l=new v.MurmurHash3_64,h=t.getRaw("Encoding");if((0,n.isName)(h))l.update(h.name);else if((0,n.isRef)(h))l.update(h.toString());else if((0,n.isDict)(h))for(const e of h.getRawValues())if((0,n.isName)(e))l.update(e.name);else if((0,n.isRef)(e))l.update(e.toString());else if(Array.isArray(e)){for(var u=e.length,d=new Array(u),f=0;f<u;f++){var g=e[f];(0,n.isName)(g)?d[f]=g.name:((0,a.isNum)(g)||(0,n.isRef)(g))&&(d[f]=g.toString())}l.update(d.join())}const r=e.get("FirstChar")||0,o=e.get("LastChar")||(s?65535:255);l.update(`${r}-${o}`);var p=e.get("ToUnicode")||t.get("ToUnicode");if((0,n.isStream)(p)){var m=p.str||p;i=m.buffer?new Uint8Array(m.buffer.buffer,0,m.bufferLength):new Uint8Array(m.bytes.buffer,m.start,m.end-m.start),l.update(i)}else(0,n.isName)(p)&&l.update(p.name);var b=e.get("Widths")||t.get("Widths");b&&(i=new Uint8Array(new Uint32Array(b).buffer),l.update(i))}return{descriptor:c,dict:e,baseDict:t,composite:s,type:r.name,hash:l?l.hexdigest():""}}async translateFont(e){var t,r=e.baseDict,c=e.dict,l=e.composite,u=e.descriptor,d=e.type,f=l?65535:255;const g=c.get("FirstChar")||0,p=c.get("LastChar")||f;if(!u){if("Type3"!==d){var m=c.get("BaseFont");if(!(0,n.isName)(m))throw new a.FormatError("Base font is not specified");m=m.name.replace(/[,_]/g,"-");var b=this.getBaseFontMetrics(m),y=m.split("-")[0],w=(this.isSerifFont(y)?o.FontFlags.Serif:0)|(b.monospace?o.FontFlags.FixedPitch:0)|((0,h.getSymbolsFonts)()[y]?o.FontFlags.Symbolic:o.FontFlags.Nonsymbolic);t={type:d,name:m,widths:b.widths,defaultWidth:b.defaultWidth,flags:w,firstChar:g,lastChar:p};const e=c.get("Widths");return this.extractDataStructures(c,c,t).then((t=>{if(e){const r=[];let a=g;for(let t=0,i=e.length;t<i;t++)r[a++]=this.xref.fetchIfRef(e[t]);t.widths=r}else t.widths=this.buildCharCodeToWidth(b.widths,t);return new o.Font(m,null,t)}))}(u=new n.Dict(null)).set("FontName",n.Name.get(d)),u.set("FontBBox",c.getArray("FontBBox")||[0,0,0,0])}var v=u.get("FontName"),S=c.get("BaseFont");if((0,a.isString)(v)&&(v=n.Name.get(v)),(0,a.isString)(S)&&(S=n.Name.get(S)),"Type3"!==d){var k=v&&v.name,x=S&&S.name;k!==x&&((0,a.info)(`The FontDescriptor's FontName is "${k}" but should be the same as the Font's BaseFont "${x}".`),k&&x&&x.startsWith(k)&&(v=S))}if(v=v||S,!(0,n.isName)(v))throw new a.FormatError("invalid font name");let A;try{A=u.get("FontFile","FontFile2","FontFile3")}catch(e){if(!this.options.ignoreErrors)throw e;(0,a.warn)(`translateFont - fetching "${v.name}" font file: "${e}".`),A=new s.NullStream}if(A&&A.dict){var C=A.dict.get("Subtype");C&&(C=C.name);var O=A.dict.get("Length1"),F=A.dict.get("Length2"),I=A.dict.get("Length3")}if(t={type:d,name:v.name,subtype:C,file:A,length1:O,length2:F,length3:I,loadedName:r.loadedName,composite:l,fixedPitch:!1,fontMatrix:c.getArray("FontMatrix")||a.FONT_IDENTITY_MATRIX,firstChar:g||0,lastChar:p||f,bbox:u.getArray("FontBBox"),ascent:u.get("Ascent"),descent:u.get("Descent"),xHeight:u.get("XHeight"),capHeight:u.get("CapHeight"),flags:u.get("Flags"),italicAngle:u.get("ItalicAngle"),isType3Font:!1},l){const e=r.get("Encoding");(0,n.isName)(e)&&(t.cidEncoding=e.name);const a=await i.CMapFactory.create({encoding:e,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null});t.cMap=a,t.vertical=t.cMap.vertical}return this.extractDataStructures(c,r,t).then((e=>(this.extractWidths(c,u,e),"Type3"===d&&(e.isType3Font=!0),new o.Font(v.name,A,e))))}static buildFontPaths(e,t,r){function a(t){e.renderer.hasBuiltPath(t)||r.send("commonobj",[`${e.loadedName}_path_${t}`,"FontPath",e.renderer.getPathJs(t)])}for(const e of t){a(e.fontChar);const t=e.accent;t&&t.fontChar&&a(t.fontChar)}}static get fallbackFontDict(){const e=new n.Dict;return e.set("BaseFont",n.Name.get("PDFJS-FallbackFont")),e.set("Type",n.Name.get("FallbackType")),e.set("Subtype",n.Name.get("FallbackType")),e.set("Encoding",n.Name.get("WinAnsiEncoding")),(0,a.shadow)(this,"fallbackFontDict",e)}}t.PartialEvaluator=T;class P{constructor({loadedName:e,font:t,dict:r,extraProperties:a=!1}){this.loadedName=e,this.font=t,this.dict=r,this._extraProperties=a,this.type3Loaded=null,this.type3Dependencies=t.isType3Font?new Set:null,this.sent=!1}send(e){this.sent||(this.sent=!0,e.send("commonobj",[this.loadedName,"Font",this.font.exportData(this._extraProperties)]))}fallback(e){if(!this.font.data)return;this.font.disableFontFace=!0;const t=this.font.glyphCacheValues;T.buildFontPaths(this.font,t,e)}loadType3Data(e,t,r){if(this.type3Loaded)return this.type3Loaded;if(!this.font.isType3Font)throw new Error("Must be a Type3 font.");var i=Object.create(e.options);i.ignoreErrors=!1;var n=e.clone(i);n.parsingType3Font=!0;const s=this.font,o=this.type3Dependencies;var c=Promise.resolve(),l=this.dict.get("CharProcs"),h=this.dict.get("Resources")||t,u=Object.create(null);for(const e of l.getKeys())c=c.then((()=>{var t=l.get(e),i=new S.OperatorList;return n.getOperatorList({stream:t,task:r,resources:h,operatorList:i}).then((()=>{i.fnArray[0]===a.OPS.setCharWidthAndBounds&&this._removeType3ColorOperators(i),u[e]=i.getIR();for(const e of i.dependencies)o.add(e)})).catch((function(t){(0,a.warn)(`Type3 font resource "${e}" is not available.`);const r=new S.OperatorList;u[e]=r.getIR()}))}));return this.type3Loaded=c.then((function(){s.charProcOperatorList=u})),this.type3Loaded}_removeType3ColorOperators(e){let t=1,r=e.length;for(;t<r;){switch(e.fnArray[t]){case a.OPS.setStrokeColorSpace:case a.OPS.setFillColorSpace:case a.OPS.setStrokeColor:case a.OPS.setStrokeColorN:case a.OPS.setFillColor:case a.OPS.setFillColorN:case a.OPS.setStrokeGray:case a.OPS.setFillGray:case a.OPS.setStrokeRGBColor:case a.OPS.setFillRGBColor:case a.OPS.setStrokeCMYKColor:case a.OPS.setFillCMYKColor:case a.OPS.shadingFill:case a.OPS.setRenderingIntent:e.fnArray.splice(t,1),e.argsArray.splice(t,1),r--;continue;case a.OPS.setGState:const[i]=e.argsArray[t];let n=0,s=i.length;for(;n<s;){const[e]=i[n];switch(e){case"TR":case"TR2":case"HT":case"BG":case"BG2":case"UCR":case"UCR2":i.splice(n,1),s--;continue}n++}break}t++}}}class E{constructor(e=new N){this.state=e,this.stateStack=[]}save(){var e=this.state;this.stateStack.push(this.state),this.state=e.clone()}restore(){var e=this.stateStack.pop();e&&(this.state=e)}transform(e){this.state.ctm=a.Util.transform(this.state.ctm,e)}}class M{constructor(){this.ctm=new Float32Array(a.IDENTITY_MATRIX),this.fontName=null,this.fontSize=0,this.font=null,this.fontMatrix=a.FONT_IDENTITY_MATRIX,this.textMatrix=a.IDENTITY_MATRIX.slice(),this.textLineMatrix=a.IDENTITY_MATRIX.slice(),this.charSpacing=0,this.wordSpacing=0,this.leading=0,this.textHScale=1,this.textRise=0}setTextMatrix(e,t,r,a,i,n){var s=this.textMatrix;s[0]=e,s[1]=t,s[2]=r,s[3]=a,s[4]=i,s[5]=n}setTextLineMatrix(e,t,r,a,i,n){var s=this.textLineMatrix;s[0]=e,s[1]=t,s[2]=r,s[3]=a,s[4]=i,s[5]=n}translateTextMatrix(e,t){var r=this.textMatrix;r[4]=r[0]*e+r[2]*t+r[4],r[5]=r[1]*e+r[3]*t+r[5]}translateTextLineMatrix(e,t){var r=this.textLineMatrix;r[4]=r[0]*e+r[2]*t+r[4],r[5]=r[1]*e+r[3]*t+r[5]}calcTextLineMatrixAdvance(e,t,r,a,i,n){var s=this.font;if(!s)return null;var o=this.textLineMatrix;if(e!==o[0]||t!==o[1]||r!==o[2]||a!==o[3])return null;var c=i-o[4],l=n-o[5];if(s.vertical&&0!==c||!s.vertical&&0!==l)return null;var h,u,d=e*a-t*r;return s.vertical?(h=-l*r/d,u=l*e/d):(h=c*a/d,u=-c*t/d),{width:h,height:u,value:s.vertical?u:h}}calcRenderMatrix(e){var t=[this.fontSize*this.textHScale,0,0,this.fontSize,0,this.textRise];return a.Util.transform(e,a.Util.transform(this.textMatrix,t))}carriageReturn(){this.translateTextLineMatrix(0,-this.leading),this.textMatrix=this.textLineMatrix.slice()}clone(){var e=Object.create(this);return e.textMatrix=this.textMatrix.slice(),e.textLineMatrix=this.textLineMatrix.slice(),e.fontMatrix=this.fontMatrix.slice(),e}}class N{constructor(){this.ctm=new Float32Array(a.IDENTITY_MATRIX),this.font=null,this.textRenderingMode=a.TextRenderingMode.FILL,this.fillColorSpace=m.ColorSpace.singletons.gray,this.strokeColorSpace=m.ColorSpace.singletons.gray}clone(){return Object.create(this)}}class D{static get opMap(){const e=(0,y.getLookupTableFactory)((function(e){e.w={id:a.OPS.setLineWidth,numArgs:1,variableArgs:!1},e.J={id:a.OPS.setLineCap,numArgs:1,variableArgs:!1},e.j={id:a.OPS.setLineJoin,numArgs:1,variableArgs:!1},e.M={id:a.OPS.setMiterLimit,numArgs:1,variableArgs:!1},e.d={id:a.OPS.setDash,numArgs:2,variableArgs:!1},e.ri={id:a.OPS.setRenderingIntent,numArgs:1,variableArgs:!1},e.i={id:a.OPS.setFlatness,numArgs:1,variableArgs:!1},e.gs={id:a.OPS.setGState,numArgs:1,variableArgs:!1},e.q={id:a.OPS.save,numArgs:0,variableArgs:!1},e.Q={id:a.OPS.restore,numArgs:0,variableArgs:!1},e.cm={id:a.OPS.transform,numArgs:6,variableArgs:!1},e.m={id:a.OPS.moveTo,numArgs:2,variableArgs:!1},e.l={id:a.OPS.lineTo,numArgs:2,variableArgs:!1},e.c={id:a.OPS.curveTo,numArgs:6,variableArgs:!1},e.v={id:a.OPS.curveTo2,numArgs:4,variableArgs:!1},e.y={id:a.OPS.curveTo3,numArgs:4,variableArgs:!1},e.h={id:a.OPS.closePath,numArgs:0,variableArgs:!1},e.re={id:a.OPS.rectangle,numArgs:4,variableArgs:!1},e.S={id:a.OPS.stroke,numArgs:0,variableArgs:!1},e.s={id:a.OPS.closeStroke,numArgs:0,variableArgs:!1},e.f={id:a.OPS.fill,numArgs:0,variableArgs:!1},e.F={id:a.OPS.fill,numArgs:0,variableArgs:!1},e["f*"]={id:a.OPS.eoFill,numArgs:0,variableArgs:!1},e.B={id:a.OPS.fillStroke,numArgs:0,variableArgs:!1},e["B*"]={id:a.OPS.eoFillStroke,numArgs:0,variableArgs:!1},e.b={id:a.OPS.closeFillStroke,numArgs:0,variableArgs:!1},e["b*"]={id:a.OPS.closeEOFillStroke,numArgs:0,variableArgs:!1},e.n={id:a.OPS.endPath,numArgs:0,variableArgs:!1},e.W={id:a.OPS.clip,numArgs:0,variableArgs:!1},e["W*"]={id:a.OPS.eoClip,numArgs:0,variableArgs:!1},e.BT={id:a.OPS.beginText,numArgs:0,variableArgs:!1},e.ET={id:a.OPS.endText,numArgs:0,variableArgs:!1},e.Tc={id:a.OPS.setCharSpacing,numArgs:1,variableArgs:!1},e.Tw={id:a.OPS.setWordSpacing,numArgs:1,variableArgs:!1},e.Tz={id:a.OPS.setHScale,numArgs:1,variableArgs:!1},e.TL={id:a.OPS.setLeading,numArgs:1,variableArgs:!1},e.Tf={id:a.OPS.setFont,numArgs:2,variableArgs:!1},e.Tr={id:a.OPS.setTextRenderingMode,numArgs:1,variableArgs:!1},e.Ts={id:a.OPS.setTextRise,numArgs:1,variableArgs:!1},e.Td={id:a.OPS.moveText,numArgs:2,variableArgs:!1},e.TD={id:a.OPS.setLeadingMoveText,numArgs:2,variableArgs:!1},e.Tm={id:a.OPS.setTextMatrix,numArgs:6,variableArgs:!1},e["T*"]={id:a.OPS.nextLine,numArgs:0,variableArgs:!1},e.Tj={id:a.OPS.showText,numArgs:1,variableArgs:!1},e.TJ={id:a.OPS.showSpacedText,numArgs:1,variableArgs:!1},e["'"]={id:a.OPS.nextLineShowText,numArgs:1,variableArgs:!1},e['"']={id:a.OPS.nextLineSetSpacingShowText,numArgs:3,variableArgs:!1},e.d0={id:a.OPS.setCharWidth,numArgs:2,variableArgs:!1},e.d1={id:a.OPS.setCharWidthAndBounds,numArgs:6,variableArgs:!1},e.CS={id:a.OPS.setStrokeColorSpace,numArgs:1,variableArgs:!1},e.cs={id:a.OPS.setFillColorSpace,numArgs:1,variableArgs:!1},e.SC={id:a.OPS.setStrokeColor,numArgs:4,variableArgs:!0},e.SCN={id:a.OPS.setStrokeColorN,numArgs:33,variableArgs:!0},e.sc={id:a.OPS.setFillColor,numArgs:4,variableArgs:!0},e.scn={id:a.OPS.setFillColorN,numArgs:33,variableArgs:!0},e.G={id:a.OPS.setStrokeGray,numArgs:1,variableArgs:!1},e.g={id:a.OPS.setFillGray,numArgs:1,variableArgs:!1},e.RG={id:a.OPS.setStrokeRGBColor,numArgs:3,variableArgs:!1},e.rg={id:a.OPS.setFillRGBColor,numArgs:3,variableArgs:!1},e.K={id:a.OPS.setStrokeCMYKColor,numArgs:4,variableArgs:!1},e.k={id:a.OPS.setFillCMYKColor,numArgs:4,variableArgs:!1},e.sh={id:a.OPS.shadingFill,numArgs:1,variableArgs:!1},e.BI={id:a.OPS.beginInlineImage,numArgs:0,variableArgs:!1},e.ID={id:a.OPS.beginImageData,numArgs:0,variableArgs:!1},e.EI={id:a.OPS.endInlineImage,numArgs:1,variableArgs:!1},e.Do={id:a.OPS.paintXObject,numArgs:1,variableArgs:!1},e.MP={id:a.OPS.markPoint,numArgs:1,variableArgs:!1},e.DP={id:a.OPS.markPointProps,numArgs:2,variableArgs:!1},e.BMC={id:a.OPS.beginMarkedContent,numArgs:1,variableArgs:!1},e.BDC={id:a.OPS.beginMarkedContentProps,numArgs:2,variableArgs:!1},e.EMC={id:a.OPS.endMarkedContent,numArgs:0,variableArgs:!1},e.BX={id:a.OPS.beginCompat,numArgs:0,variableArgs:!1},e.EX={id:a.OPS.endCompat,numArgs:0,variableArgs:!1},e.BM=null,e.BD=null,e.true=null,e.fa=null,e.fal=null,e.fals=null,e.false=null,e.nu=null,e.nul=null,e.null=null}));return(0,a.shadow)(this,"opMap",e())}static get MAX_INVALID_PATH_OPS(){return(0,a.shadow)(this,"MAX_INVALID_PATH_OPS",20)}constructor(e,t,r=new E){this.parser=new f.Parser({lexer:new f.Lexer(e,D.opMap),xref:t}),this.stateManager=r,this.nonProcessedArgs=[],this._numInvalidPathOPS=0}get savedStatesDepth(){return this.stateManager.stateStack.length}read(e){for(var t=e.args;;){var r=this.parser.getObj();if(r instanceof n.Cmd){var i=r.cmd,s=D.opMap[i];if(!s){(0,a.warn)(`Unknown command "${i}".`);continue}var o=s.id,c=s.numArgs,l=null!==t?t.length:0;if(s.variableArgs)l>c&&(0,a.info)(`Command ${i}: expected [0, ${c}] args, but received ${l} args.`);else{if(l!==c){for(var h=this.nonProcessedArgs;l>c;)h.push(t.shift()),l--;for(;l<c&&0!==h.length;)null===t&&(t=[]),t.unshift(h.pop()),l++}if(l<c){const e=`command ${i}: expected ${c} args, but received ${l} args.`;if(o>=a.OPS.moveTo&&o<=a.OPS.endPath&&++this._numInvalidPathOPS>D.MAX_INVALID_PATH_OPS)throw new a.FormatError(`Invalid ${e}`);(0,a.warn)(`Skipping ${e}`),null!==t&&(t.length=0);continue}}return this.preprocessCommand(o,t),e.fn=o,e.args=t,!0}if(r===n.EOF)return!1;if(null!==r&&(null===t&&(t=[]),t.push(r),t.length>33))throw new a.FormatError("Too many arguments")}}preprocessCommand(e,t){switch(0|e){case a.OPS.save:this.stateManager.save();break;case a.OPS.restore:this.stateManager.restore();break;case a.OPS.transform:this.stateManager.transform(t);break}}}t.EvaluatorPreprocessor=D},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.IdentityCMap=t.CMapFactory=t.CMap=void 0;var a=r(2),i=r(5),n=r(11),s=r(8),o=r(12),c=["Adobe-GB1-UCS2","Adobe-CNS1-UCS2","Adobe-Japan1-UCS2","Adobe-Korea1-UCS2","78-EUC-H","78-EUC-V","78-H","78-RKSJ-H","78-RKSJ-V","78-V","78ms-RKSJ-H","78ms-RKSJ-V","83pv-RKSJ-H","90ms-RKSJ-H","90ms-RKSJ-V","90msp-RKSJ-H","90msp-RKSJ-V","90pv-RKSJ-H","90pv-RKSJ-V","Add-H","Add-RKSJ-H","Add-RKSJ-V","Add-V","Adobe-CNS1-0","Adobe-CNS1-1","Adobe-CNS1-2","Adobe-CNS1-3","Adobe-CNS1-4","Adobe-CNS1-5","Adobe-CNS1-6","Adobe-GB1-0","Adobe-GB1-1","Adobe-GB1-2","Adobe-GB1-3","Adobe-GB1-4","Adobe-GB1-5","Adobe-Japan1-0","Adobe-Japan1-1","Adobe-Japan1-2","Adobe-Japan1-3","Adobe-Japan1-4","Adobe-Japan1-5","Adobe-Japan1-6","Adobe-Korea1-0","Adobe-Korea1-1","Adobe-Korea1-2","B5-H","B5-V","B5pc-H","B5pc-V","CNS-EUC-H","CNS-EUC-V","CNS1-H","CNS1-V","CNS2-H","CNS2-V","ETHK-B5-H","ETHK-B5-V","ETen-B5-H","ETen-B5-V","ETenms-B5-H","ETenms-B5-V","EUC-H","EUC-V","Ext-H","Ext-RKSJ-H","Ext-RKSJ-V","Ext-V","GB-EUC-H","GB-EUC-V","GB-H","GB-V","GBK-EUC-H","GBK-EUC-V","GBK2K-H","GBK2K-V","GBKp-EUC-H","GBKp-EUC-V","GBT-EUC-H","GBT-EUC-V","GBT-H","GBT-V","GBTpc-EUC-H","GBTpc-EUC-V","GBpc-EUC-H","GBpc-EUC-V","H","HKdla-B5-H","HKdla-B5-V","HKdlb-B5-H","HKdlb-B5-V","HKgccs-B5-H","HKgccs-B5-V","HKm314-B5-H","HKm314-B5-V","HKm471-B5-H","HKm471-B5-V","HKscs-B5-H","HKscs-B5-V","Hankaku","Hiragana","KSC-EUC-H","KSC-EUC-V","KSC-H","KSC-Johab-H","KSC-Johab-V","KSC-V","KSCms-UHC-H","KSCms-UHC-HW-H","KSCms-UHC-HW-V","KSCms-UHC-V","KSCpc-EUC-H","KSCpc-EUC-V","Katakana","NWP-H","NWP-V","RKSJ-H","RKSJ-V","Roman","UniCNS-UCS2-H","UniCNS-UCS2-V","UniCNS-UTF16-H","UniCNS-UTF16-V","UniCNS-UTF32-H","UniCNS-UTF32-V","UniCNS-UTF8-H","UniCNS-UTF8-V","UniGB-UCS2-H","UniGB-UCS2-V","UniGB-UTF16-H","UniGB-UTF16-V","UniGB-UTF32-H","UniGB-UTF32-V","UniGB-UTF8-H","UniGB-UTF8-V","UniJIS-UCS2-H","UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-V","UniJIS-UCS2-V","UniJIS-UTF16-H","UniJIS-UTF16-V","UniJIS-UTF32-H","UniJIS-UTF32-V","UniJIS-UTF8-H","UniJIS-UTF8-V","UniJIS2004-UTF16-H","UniJIS2004-UTF16-V","UniJIS2004-UTF32-H","UniJIS2004-UTF32-V","UniJIS2004-UTF8-H","UniJIS2004-UTF8-V","UniJISPro-UCS2-HW-V","UniJISPro-UCS2-V","UniJISPro-UTF8-V","UniJISX0213-UTF32-H","UniJISX0213-UTF32-V","UniJISX02132004-UTF32-H","UniJISX02132004-UTF32-V","UniKS-UCS2-H","UniKS-UCS2-V","UniKS-UTF16-H","UniKS-UTF16-V","UniKS-UTF32-H","UniKS-UTF32-V","UniKS-UTF8-H","UniKS-UTF8-V","V","WP-Symbol"];const l=2**24-1;class h{constructor(e=!1){this.codespaceRanges=[[],[],[],[]],this.numCodespaceRanges=0,this._map=[],this.name="",this.vertical=!1,this.useCMap=null,this.builtInCMap=e}addCodespaceRange(e,t,r){this.codespaceRanges[e-1].push(t,r),this.numCodespaceRanges++}mapCidRange(e,t,r){if(t-e>l)throw new Error("mapCidRange - ignoring data above MAX_MAP_RANGE.");for(;e<=t;)this._map[e++]=r++}mapBfRange(e,t,r){if(t-e>l)throw new Error("mapBfRange - ignoring data above MAX_MAP_RANGE.");for(var a=r.length-1;e<=t;)this._map[e++]=r,r=r.substring(0,a)+String.fromCharCode(r.charCodeAt(a)+1)}mapBfRangeToArray(e,t,r){if(t-e>l)throw new Error("mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.");const a=r.length;let i=0;for(;e<=t&&i<a;)this._map[e]=r[i++],++e}mapOne(e,t){this._map[e]=t}lookup(e){return this._map[e]}contains(e){return void 0!==this._map[e]}forEach(e){const t=this._map,r=t.length;if(r<=65536)for(let a=0;a<r;a++)void 0!==t[a]&&e(a,t[a]);else for(const r in t)e(r,t[r])}charCodeOf(e){const t=this._map;if(t.length<=65536)return t.indexOf(e);for(const r in t)if(t[r]===e)return 0|r;return-1}getMap(){return this._map}readCharCode(e,t,r){let a=0;const i=this.codespaceRanges;for(let n=0,s=i.length;n<s;n++){a=(a<<8|e.charCodeAt(t+n))>>>0;const s=i[n];for(let e=0,t=s.length;e<t;){const t=s[e++],i=s[e++];if(a>=t&&a<=i)return r.charcode=a,void(r.length=n+1)}}r.charcode=0,r.length=1}getCharCodeLength(e){const t=this.codespaceRanges;for(let r=0,a=t.length;r<a;r++){const a=t[r];for(let t=0,i=a.length;t<i;){const i=a[t++],n=a[t++];if(e>=i&&e<=n)return r+1}}return 1}get length(){return this._map.length}get isIdentityCMap(){if("Identity-H"!==this.name&&"Identity-V"!==this.name)return!1;if(65536!==this._map.length)return!1;for(let e=0;e<65536;e++)if(this._map[e]!==e)return!1;return!0}}t.CMap=h;class u extends h{constructor(e,t){super(),this.vertical=e,this.addCodespaceRange(t,0,65535)}mapCidRange(e,t,r){(0,a.unreachable)("should not call mapCidRange")}mapBfRange(e,t,r){(0,a.unreachable)("should not call mapBfRange")}mapBfRangeToArray(e,t,r){(0,a.unreachable)("should not call mapBfRangeToArray")}mapOne(e,t){(0,a.unreachable)("should not call mapCidOne")}lookup(e){return Number.isInteger(e)&&e<=65535?e:void 0}contains(e){return Number.isInteger(e)&&e<=65535}forEach(e){for(let t=0;t<=65535;t++)e(t,t)}charCodeOf(e){return Number.isInteger(e)&&e<=65535?e:-1}getMap(){const e=new Array(65536);for(let t=0;t<=65535;t++)e[t]=t;return e}get length(){return 65536}get isIdentityCMap(){(0,a.unreachable)("should not access .isIdentityCMap")}}t.IdentityCMap=u;var d=function(){function e(e,t){for(var r=0,a=0;a<=t;a++)r=r<<8|e[a];return r>>>0}function t(e,t){return 1===t?String.fromCharCode(e[0],e[1]):3===t?String.fromCharCode(e[0],e[1],e[2],e[3]):String.fromCharCode.apply(null,e.subarray(0,t+1))}function r(e,t,r){for(var a=0,i=r;i>=0;i--)a+=e[i]+t[i],e[i]=255&a,a>>=8}function i(e,t){for(var r=1,a=t;a>=0&&r>0;a--)r+=e[a],e[a]=255&r,r>>=8}var n=16;class s{constructor(e){this.buffer=e,this.pos=0,this.end=e.length,this.tmpBuf=new Uint8Array(19)}readByte(){return this.pos>=this.end?-1:this.buffer[this.pos++]}readNumber(){var e,t=0;do{var r=this.readByte();if(r<0)throw new a.FormatError("unexpected EOF in bcmap");e=!(128&r),t=t<<7|127&r}while(!e);return t}readSigned(){var e=this.readNumber();return 1&e?~(e>>>1):e>>>1}readHex(e,t){e.set(this.buffer.subarray(this.pos,this.pos+t+1)),this.pos+=t+1}readHexNumber(e,t){var r,i=this.tmpBuf,n=0;do{var s=this.readByte();if(s<0)throw new a.FormatError("unexpected EOF in bcmap");r=!(128&s),i[n++]=127&s}while(!r);for(var o=t,c=0,l=0;o>=0;){for(;l<8&&i.length>0;)c=i[--n]<<l|c,l+=7;e[o]=255&c,o--,c>>=8,l-=8}}readHexSigned(e,t){this.readHexNumber(e,t);for(var r=1&e[t]?255:0,a=0,i=0;i<=t;i++)a=(1&a)<<8|e[i],e[i]=a>>1^r}readString(){for(var e=this.readNumber(),t="",r=0;r<e;r++)t+=String.fromCharCode(this.readNumber());return t}}return class{async process(a,o,c){var l=new s(a),h=l.readByte();o.vertical=!!(1&h);for(var u,d,f=null,g=new Uint8Array(n),p=new Uint8Array(n),m=new Uint8Array(n),b=new Uint8Array(n),y=new Uint8Array(n);(d=l.readByte())>=0;){var w=d>>5;if(7!==w){var v=!!(16&d),S=15&d;if(S+1>n)throw new Error("BinaryCMapReader.process: Invalid dataSize.");var k,x=l.readNumber();switch(w){case 0:for(l.readHex(g,S),l.readHexNumber(p,S),r(p,g,S),o.addCodespaceRange(S+1,e(g,S),e(p,S)),k=1;k<x;k++)i(p,S),l.readHexNumber(g,S),r(g,p,S),l.readHexNumber(p,S),r(p,g,S),o.addCodespaceRange(S+1,e(g,S),e(p,S));break;case 1:for(l.readHex(g,S),l.readHexNumber(p,S),r(p,g,S),l.readNumber(),k=1;k<x;k++)i(p,S),l.readHexNumber(g,S),r(g,p,S),l.readHexNumber(p,S),r(p,g,S),l.readNumber();break;case 2:for(l.readHex(m,S),u=l.readNumber(),o.mapOne(e(m,S),u),k=1;k<x;k++)i(m,S),v||(l.readHexNumber(y,S),r(m,y,S)),u=l.readSigned()+(u+1),o.mapOne(e(m,S),u);break;case 3:for(l.readHex(g,S),l.readHexNumber(p,S),r(p,g,S),u=l.readNumber(),o.mapCidRange(e(g,S),e(p,S),u),k=1;k<x;k++)i(p,S),v?g.set(p):(l.readHexNumber(g,S),r(g,p,S)),l.readHexNumber(p,S),r(p,g,S),u=l.readNumber(),o.mapCidRange(e(g,S),e(p,S),u);break;case 4:for(l.readHex(m,1),l.readHex(b,S),o.mapOne(e(m,1),t(b,S)),k=1;k<x;k++)i(m,1),v||(l.readHexNumber(y,1),r(m,y,1)),i(b,S),l.readHexSigned(y,S),r(b,y,S),o.mapOne(e(m,1),t(b,S));break;case 5:for(l.readHex(g,1),l.readHexNumber(p,1),r(p,g,1),l.readHex(b,S),o.mapBfRange(e(g,1),e(p,1),t(b,S)),k=1;k<x;k++)i(p,1),v?g.set(p):(l.readHexNumber(g,1),r(g,p,1)),l.readHexNumber(p,1),r(p,g,1),l.readHex(b,S),o.mapBfRange(e(g,1),e(p,1),t(b,S));break;default:throw new Error(`BinaryCMapReader.process - unknown type: ${w}`)}}else switch(31&d){case 0:l.readString();break;case 1:f=l.readString();break}}return f?c(f):o}}}(),f=function(){function e(e){for(var t=0,r=0;r<e.length;r++)t=t<<8|e.charCodeAt(r);return t>>>0}function t(e){if(!(0,a.isString)(e))throw new a.FormatError("Malformed CMap: expected string.")}function r(e){if(!Number.isInteger(e))throw new a.FormatError("Malformed CMap: expected int.")}function l(r,a){for(;;){var n=a.getObj();if((0,i.isEOF)(n))break;if((0,i.isCmd)(n,"endbfchar"))return;t(n);var s=e(n);t(n=a.getObj());var o=n;r.mapOne(s,o)}}function f(r,n){for(;;){var s=n.getObj();if((0,i.isEOF)(s))break;if((0,i.isCmd)(s,"endbfrange"))return;t(s);var o=e(s);t(s=n.getObj());var c=e(s);if(s=n.getObj(),Number.isInteger(s)||(0,a.isString)(s)){var l=Number.isInteger(s)?String.fromCharCode(s):s;r.mapBfRange(o,c,l)}else{if(!(0,i.isCmd)(s,"["))break;s=n.getObj();for(var h=[];!(0,i.isCmd)(s,"]")&&!(0,i.isEOF)(s);)h.push(s),s=n.getObj();r.mapBfRangeToArray(o,c,h)}}throw new a.FormatError("Invalid bf range.")}function g(a,n){for(;;){var s=n.getObj();if((0,i.isEOF)(s))break;if((0,i.isCmd)(s,"endcidchar"))return;t(s);var o=e(s);r(s=n.getObj());var c=s;a.mapOne(o,c)}}function p(a,n){for(;;){var s=n.getObj();if((0,i.isEOF)(s))break;if((0,i.isCmd)(s,"endcidrange"))return;t(s);var o=e(s);t(s=n.getObj());var c=e(s);r(s=n.getObj());var l=s;a.mapCidRange(o,c,l)}}function m(t,r){for(;;){var n=r.getObj();if((0,i.isEOF)(n))break;if((0,i.isCmd)(n,"endcodespacerange"))return;if(!(0,a.isString)(n))break;var s=e(n);if(n=r.getObj(),!(0,a.isString)(n))break;var o=e(n);t.addCodespaceRange(n.length,s,o)}throw new a.FormatError("Invalid codespace range.")}function b(e,t){var r=t.getObj();Number.isInteger(r)&&(e.vertical=!!r)}function y(e,t){var r=t.getObj();(0,i.isName)(r)&&(0,a.isString)(r.name)&&(e.name=r.name)}async function w(e,t,r,n){var o,c;e:for(;;)try{var h=t.getObj();if((0,i.isEOF)(h))break;if((0,i.isName)(h))"WMode"===h.name?b(e,t):"CMapName"===h.name&&y(e,t),o=h;else if((0,i.isCmd)(h))switch(h.cmd){case"endcmap":break e;case"usecmap":(0,i.isName)(o)&&(c=o.name);break;case"begincodespacerange":m(e,t);break;case"beginbfchar":l(e,t);break;case"begincidchar":g(e,t);break;case"beginbfrange":f(e,t);break;case"begincidrange":p(e,t);break}}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.warn)("Invalid cMap data: "+e);continue}return!n&&c&&(n=c),n?v(e,r,n):e}async function v(e,t,r){if(e.useCMap=await S(r,t),0===e.numCodespaceRanges){for(var a=e.useCMap.codespaceRanges,i=0;i<a.length;i++)e.codespaceRanges[i]=a[i].slice();e.numCodespaceRanges=e.useCMap.numCodespaceRanges}return e.useCMap.forEach((function(t,r){e.contains(t)||e.mapOne(t,e.useCMap.lookup(t))})),e}async function S(e,t){if("Identity-H"===e)return new u(!1,2);if("Identity-V"===e)return new u(!0,2);if(!c.includes(e))throw new Error("Unknown CMap name: "+e);if(!t)throw new Error("Built-in CMap parameters are not provided.");const{cMapData:r,compressionType:i}=await t(e);var s=new h(!0);if(i===a.CMapCompressionType.BINARY)return(new d).process(r,s,(e=>v(s,t,e)));if(i===a.CMapCompressionType.NONE){var l=new n.Lexer(new o.Stream(r));return w(s,l,t,null)}throw new Error("TODO: Only BINARY/NONE CMap compression is currently supported.")}return{async create(e){var t=e.encoding,r=e.fetchBuiltInCMap,a=e.useCMap;if((0,i.isName)(t))return S(t.name,r);if((0,i.isStream)(t)){const e=await w(new h,new n.Lexer(t),r,a);return e.isIdentityCMap?S(e.name,r):e}throw new Error("Encoding required.")}}}();t.CMapFactory=f},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getFontType=k,t.ToUnicodeMap=t.SEAC_ANALYSIS_ENABLED=t.IdentityToUnicodeMap=t.FontFlags=t.Font=t.ErrorFont=void 0;var a=r(2),i=r(32),n=r(35),s=r(34),o=r(36),c=r(37),l=r(8),h=r(38),u=r(30),d=r(12),f=r(39);const g=[[57344,63743],[1048576,1114109]];var p=1e3,m=!0;t.SEAC_ANALYSIS_ENABLED=m;const b=["ascent","bbox","black","bold","charProcOperatorList","composite","data","defaultVMetrics","defaultWidth","descent","fallbackName","fontMatrix","fontType","isMonospace","isSerifFont","isType3Font","italic","loadedName","mimetype","missingFile","name","remeasure","subtype","type","vertical"],y=["cMap","defaultEncoding","differences","isSymbolicFont","seacMap","toFontChar","toUnicode","vmetrics","widths"];var w={FixedPitch:1,Serif:2,Symbolic:4,Script:8,Nonsymbolic:32,Italic:64,AllCap:65536,SmallCap:131072,ForceBold:262144};t.FontFlags=w;var v=[".notdef",".null","nonmarkingreturn","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","Adieresis","Aring","Ccedilla","Eacute","Ntilde","Odieresis","Udieresis","aacute","agrave","acircumflex","adieresis","atilde","aring","ccedilla","eacute","egrave","ecircumflex","edieresis","iacute","igrave","icircumflex","idieresis","ntilde","oacute","ograve","ocircumflex","odieresis","otilde","uacute","ugrave","ucircumflex","udieresis","dagger","degree","cent","sterling","section","bullet","paragraph","germandbls","registered","copyright","trademark","acute","dieresis","notequal","AE","Oslash","infinity","plusminus","lessequal","greaterequal","yen","mu","partialdiff","summation","product","pi","integral","ordfeminine","ordmasculine","Omega","ae","oslash","questiondown","exclamdown","logicalnot","radical","florin","approxequal","Delta","guillemotleft","guillemotright","ellipsis","nonbreakingspace","Agrave","Atilde","Otilde","OE","oe","endash","emdash","quotedblleft","quotedblright","quoteleft","quoteright","divide","lozenge","ydieresis","Ydieresis","fraction","currency","guilsinglleft","guilsinglright","fi","fl","daggerdbl","periodcentered","quotesinglbase","quotedblbase","perthousand","Acircumflex","Ecircumflex","Aacute","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Oacute","Ocircumflex","apple","Ograve","Uacute","Ucircumflex","Ugrave","dotlessi","circumflex","tilde","macron","breve","dotaccent","ring","cedilla","hungarumlaut","ogonek","caron","Lslash","lslash","Scaron","scaron","Zcaron","zcaron","brokenbar","Eth","eth","Yacute","yacute","Thorn","thorn","minus","multiply","onesuperior","twosuperior","threesuperior","onehalf","onequarter","threequarters","franc","Gbreve","gbreve","Idotaccent","Scedilla","scedilla","Cacute","cacute","Ccaron","ccaron","dcroat"];function S(e){if(e.fontMatrix&&e.fontMatrix[0]!==a.FONT_IDENTITY_MATRIX[0]){var t=.001/e.fontMatrix[0],r=e.widths;for(var i in r)r[i]*=t;e.defaultWidth*=t}}function k(e,t){switch(e){case"Type1":return"Type1C"===t?a.FontType.TYPE1C:a.FontType.TYPE1;case"CIDFontType0":return"CIDFontType0C"===t?a.FontType.CIDFONTTYPE0C:a.FontType.CIDFONTTYPE0;case"OpenType":return a.FontType.OPENTYPE;case"TrueType":return a.FontType.TRUETYPE;case"CIDFontType2":return a.FontType.CIDFONTTYPE2;case"MMType1":return a.FontType.MMTYPE1;case"Type0":return a.FontType.TYPE0;default:return a.FontType.UNKNOWN}}function x(e,t){if(void 0!==t[e])return e;var r=(0,c.getUnicodeForGlyph)(e,t);if(-1!==r)for(var i in t)if(t[i]===r)return i;return(0,a.info)("Unable to recover a standard glyph name for: "+e),e}var A=function(){function e(e,t,r,a,i,n,s,o){this.fontChar=e,this.unicode=t,this.accent=r,this.width=a,this.vmetric=i,this.operatorListId=n,this.isSpace=s,this.isInFont=o}return e.prototype.matchesForCache=function(e,t,r,a,i,n,s,o){return this.fontChar===e&&this.unicode===t&&this.accent===r&&this.width===a&&this.vmetric===i&&this.operatorListId===n&&this.isSpace===s&&this.isInFont===o},e}(),C=function(){function e(e=[]){this._map=e}return e.prototype={get length(){return this._map.length},forEach(e){for(var t in this._map)e(t,this._map[t].charCodeAt(0))},has(e){return void 0!==this._map[e]},get(e){return this._map[e]},charCodeOf(e){const t=this._map;if(t.length<=65536)return t.indexOf(e);for(const r in t)if(t[r]===e)return 0|r;return-1},amend(e){for(var t in e)this._map[t]=e[t]}},e}();t.ToUnicodeMap=C;var O=function(){function e(e,t){this.firstChar=e,this.lastChar=t}return e.prototype={get length(){return this.lastChar+1-this.firstChar},forEach(e){for(var t=this.firstChar,r=this.lastChar;t<=r;t++)e(t,t)},has(e){return this.firstChar<=e&&e<=this.lastChar},get(e){if(this.firstChar<=e&&e<=this.lastChar)return String.fromCharCode(e)},charCodeOf(e){return Number.isInteger(e)&&e>=this.firstChar&&e<=this.lastChar?e:-1},amend(e){(0,a.unreachable)("Should not call amend()")}},e}();t.IdentityToUnicodeMap=O;var F=function(){function e(e,t,r){e[t]=r>>8&255,e[t+1]=255&r}function t(e,t,r){e[t]=r>>24&255,e[t+1]=r>>16&255,e[t+2]=r>>8&255,e[t+3]=255&r}function r(e,t,r){var a,i;if(r instanceof Uint8Array)e.set(r,t);else if("string"==typeof r)for(a=0,i=r.length;a<i;a++)e[t++]=255&r.charCodeAt(a);else for(a=0,i=r.length;a<i;a++)e[t++]=255&r[a]}function i(e){this.sfnt=e,this.tables=Object.create(null)}i.getSearchParams=function(e,t){for(var r=1,a=0;(r^e)>r;)r<<=1,a++;var i=r*t;return{range:i,entry:a,rangeShift:t*e-i}};return i.prototype={toArray:function(){var n=this.sfnt,s=this.tables,o=Object.keys(s);o.sort();var c,h,u,d,f,g=o.length,p=12+16*g,m=[p];for(c=0;c<g;c++){p+=((d=s[o[c]]).length+3&-4)>>>0,m.push(p)}var b=new Uint8Array(p);for(c=0;c<g;c++)d=s[o[c]],r(b,m[c],d);"true"===n&&(n=(0,a.string32)(65536)),b[0]=255&n.charCodeAt(0),b[1]=255&n.charCodeAt(1),b[2]=255&n.charCodeAt(2),b[3]=255&n.charCodeAt(3),e(b,4,g);var y=i.getSearchParams(g,16);for(e(b,6,y.range),e(b,8,y.entry),e(b,10,y.rangeShift),p=12,c=0;c<g;c++){f=o[c],b[p]=255&f.charCodeAt(0),b[p+1]=255&f.charCodeAt(1),b[p+2]=255&f.charCodeAt(2),b[p+3]=255&f.charCodeAt(3);var w=0;for(h=m[c],u=m[c+1];h<u;h+=4){w=w+(0,l.readUint32)(b,h)>>>0}t(b,p+4,w),t(b,p+8,m[c]),t(b,p+12,s[f].length),p+=16}return b},addTable:function(e,t){if(e in this.tables)throw new Error("Table "+e+" already exists");this.tables[e]=t}},i}(),I=function(){function e(e,t,r){var i;this.name=e,this.loadedName=r.loadedName,this.isType3Font=r.isType3Font,this.missingFile=!1,this.glyphCache=Object.create(null),this.isSerifFont=!!(r.flags&w.Serif),this.isSymbolicFont=!!(r.flags&w.Symbolic),this.isMonospace=!!(r.flags&w.FixedPitch);var n=r.type,s=r.subtype;this.type=n,this.subtype=s;let o="sans-serif";if(this.isMonospace?o="monospace":this.isSerifFont&&(o="serif"),this.fallbackName=o,this.differences=r.differences,this.widths=r.widths,this.defaultWidth=r.defaultWidth,this.composite=r.composite,this.cMap=r.cMap,this.capHeight=r.capHeight/p,this.ascent=r.ascent/p,this.descent=r.descent/p,this.fontMatrix=r.fontMatrix,this.bbox=r.bbox,this.defaultEncoding=r.defaultEncoding,this.toUnicode=r.toUnicode,this.fallbackToUnicode=r.fallbackToUnicode||new C,this.toFontChar=[],"Type3"!==r.type){if(this.cidEncoding=r.cidEncoding,this.vertical=!!r.vertical,this.vertical&&(this.vmetrics=r.vmetrics,this.defaultVMetrics=r.defaultVMetrics),!t||t.isEmpty)return t&&(0,a.warn)('Font file is empty in "'+e+'" ('+this.loadedName+")"),void this.fallbackToSystemFont(r);[n,s]=function(e,{type:t,subtype:r,composite:i}){let n,s;(function(e){var t=e.peekBytes(4);return 65536===(0,l.readUint32)(t,0)||"true"===(0,a.bytesToString)(t)})(e)||T(e)?n=i?"CIDFontType2":"TrueType":!function(e){var t=e.peekBytes(4);return"OTTO"===(0,a.bytesToString)(t)}(e)?!function(e){var t=e.peekBytes(2);if(37===t[0]&&33===t[1])return!0;if(128===t[0]&&1===t[1])return!0;return!1}(e)?!function(e){const t=e.peekBytes(4);if(t[0]>=1&&t[3]>=1&&t[3]<=4)return!0;return!1}(e)?((0,a.warn)("getFontFileType: Unable to detect correct font file Type/Subtype."),n=t,s=r):i?(n="CIDFontType0",s="CIDFontType0C"):(n="MMType1"===t?"MMType1":"Type1",s="Type1C"):n=i?"CIDFontType0":"MMType1"===t?"MMType1":"Type1":n=i?"CIDFontType2":"OpenType";return[n,s]}(t,r),n===this.type&&s===this.subtype||(0,a.info)(`Inconsistent font file Type/SubType, expected: ${this.type}/${this.subtype} but found: ${n}/${s}.`);try{var c;switch(n){case"MMType1":(0,a.info)("MMType1 font ("+e+"), falling back to Type1.");case"Type1":case"CIDFontType0":this.mimetype="font/opentype";var h="Type1C"===s||"CIDFontType0C"===s?new M(t,r):new E(e,t,r);S(r),c=this.convert(e,h,r);break;case"OpenType":case"TrueType":case"CIDFontType2":this.mimetype="font/opentype",c=this.checkAndRepair(e,t,r),this.isOpenType&&(S(r),n="OpenType");break;default:throw new a.FormatError(`Font ${n} is not supported`)}}catch(e){return(0,a.warn)(e),void this.fallbackToSystemFont(r)}this.data=c,this.fontType=k(n,s),this.fontMatrix=r.fontMatrix,this.widths=r.widths,this.defaultWidth=r.defaultWidth,this.toUnicode=r.toUnicode,this.seacMap=r.seacMap}else{for(i=0;i<256;i++)this.toFontChar[i]=this.differences[i]||r.defaultEncoding[i];this.fontType=a.FontType.TYPE3}}function t(e,t){return(e<<8)+t}function r(e,t){var r=(e<<8)+t;return 32768&r?r-65536:r}function f(e){return String.fromCharCode(e>>8&255,255&e)}function I(e){return e>32767?e=32767:e<-32768&&(e=-32768),String.fromCharCode(e>>8&255,255&e)}function T(e){const t=e.peekBytes(4);return"ttcf"===(0,a.bytesToString)(t)}function P(e,t,r){for(var a,i=[],n=0,s=e.length;n<s;n++)-1!==(a=(0,c.getUnicodeForGlyph)(e[n],t))&&(i[n]=a);for(var o in r)-1!==(a=(0,c.getUnicodeForGlyph)(r[o],t))&&(i[+o]=a);return i}function N(e,t,r){var i=Object.create(null),n=[],s=0,o=g[s][0],c=g[s][1];for(var l in e){var h=e[l|=0];if(t(h)){if(o>c){if(++s>=g.length){(0,a.warn)("Ran out of space in font private use area.");break}o=g[s][0],c=g[s][1]}var u=o++;0===h&&(h=r),i[u]=h,n[l]=u}}return{toFontChar:n,charCodeToGlyphId:i,nextAvailableFontCharCode:o}}function D(e,t){var r,i,n,s,o=function(e,t){var r=[];for(var a in e)e[a]>=t||r.push({fontCharCode:0|a,glyphId:e[a]});0===r.length&&r.push({fontCharCode:0,glyphId:0}),r.sort((function(e,t){return e.fontCharCode-t.fontCharCode}));for(var i=[],n=r.length,s=0;s<n;){var o=r[s].fontCharCode,c=[r[s].glyphId];++s;for(var l=o;s<n&&l+1===r[s].fontCharCode&&(c.push(r[s].glyphId),++s,65535!=++l););i.push([o,l,c])}return i}(e,t),c=o[o.length-1][1]>65535?2:1,l="\0\0"+f(c)+"\0\0"+(0,a.string32)(4+8*c);for(r=o.length-1;r>=0&&!(o[r][0]<=65535);--r);var h=r+1;o[r][0]<65535&&65535===o[r][1]&&(o[r][1]=65534);var u,d,g,p,m=o[r][1]<65535?1:0,b=h+m,y=F.getSearchParams(b,2),w="",v="",S="",k="",x="",A=0;for(r=0,i=h;r<i;r++){d=(u=o[r])[0],g=u[1],w+=f(d),v+=f(g);var C=!0;for(n=1,s=(p=u[2]).length;n<s;++n)if(p[n]!==p[n-1]+1){C=!1;break}if(C){S+=f(p[0]-d&65535),k+=f(0)}else{var O=2*(b-r)+2*A;for(A+=g-d+1,S+=f(0),k+=f(O),n=0,s=p.length;n<s;++n)x+=f(p[n])}}m>0&&(v+="ÿÿ",w+="ÿÿ",S+="\0",k+="\0\0");var I="\0\0"+f(2*b)+f(y.range)+f(y.entry)+f(y.rangeShift)+v+"\0\0"+w+S+k+x,T="",P="";if(c>1){for(l+="\0\0\n"+(0,a.string32)(4+8*c+4+I.length),T="",r=0,i=o.length;r<i;r++){d=(u=o[r])[0];var E=(p=u[2])[0];for(n=1,s=p.length;n<s;++n)p[n]!==p[n-1]+1&&(g=u[0]+n-1,T+=(0,a.string32)(d)+(0,a.string32)(g)+(0,a.string32)(E),d=g+1,E=p[n]);T+=(0,a.string32)(d)+(0,a.string32)(u[1])+(0,a.string32)(E)}P="\0\f\0\0"+(0,a.string32)(T.length+16)+"\0\0\0\0"+(0,a.string32)(T.length/12)}return l+"\0"+f(I.length+4)+I+P+T}function B(e,t,r){r=r||{unitsPerEm:0,yMax:0,yMin:0,ascent:0,descent:0};var i=0,n=0,s=0,o=0,l=null,h=0;if(t){for(var u in t){(l>(u|=0)||!l)&&(l=u),h<u&&(h=u);var d=(0,c.getUnicodeRangeFor)(u);if(d<32)i|=1<<d;else if(d<64)n|=1<<d-32;else if(d<96)s|=1<<d-64;else{if(!(d<123))throw new a.FormatError("Unicode ranges Bits > 123 are reserved for internal usage");o|=1<<d-96}}h>65535&&(h=65535)}else l=0,h=255;var g=e.bbox||[0,0,0,0],m=r.unitsPerEm||1/(e.fontMatrix||a.FONT_IDENTITY_MATRIX)[0],b=e.ascentScaled?1:m/p,y=r.ascent||Math.round(b*(e.ascent||g[3])),w=r.descent||Math.round(b*(e.descent||g[1]));w>0&&e.descent>0&&g[1]<0&&(w=-w);var v=r.yMax||y,S=-r.yMin||-w;return"\0$ô\0\0\0»\0\0\0»\0\0ß\x001\0\0\0\0"+String.fromCharCode(e.fixedPitch?9:0)+"\0\0\0\0\0\0"+(0,a.string32)(i)+(0,a.string32)(n)+(0,a.string32)(s)+(0,a.string32)(o)+"*21*"+f(e.italicAngle?1:0)+f(l||e.firstChar)+f(h||e.lastChar)+f(y)+f(w)+"\0d"+f(v)+f(S)+"\0\0\0\0\0\0\0\0"+f(e.xHeight)+f(e.capHeight)+f(0)+f(l||e.firstChar)+"\0"}function j(e){var t=Math.floor(65536*e.italicAngle);return"\0\0\0"+(0,a.string32)(t)+"\0\0\0\0"+(0,a.string32)(e.fixedPitch)+"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"}function L(e,t){t||(t=[[],[]]);var r,a,i,n,s,o=[t[0][0]||"Original licence",t[0][1]||e,t[0][2]||"Unknown",t[0][3]||"uniqueID",t[0][4]||e,t[0][5]||"Version 0.11",t[0][6]||"",t[0][7]||"Unknown",t[0][8]||"Unknown",t[0][9]||"Unknown"],c=[];for(r=0,a=o.length;r<a;r++){var l=[];for(i=0,n=(s=t[1][r]||o[r]).length;i<n;i++)l.push(f(s.charCodeAt(i)));c.push(l.join(""))}var h=[o,c],u=["\0","\0"],d=["\0\0","\0"],g=["\0\0","\t"],p=o.length*u.length,m="\0\0"+f(p)+f(12*p+6),b=0;for(r=0,a=u.length;r<a;r++){var y=h[r];for(i=0,n=y.length;i<n;i++){s=y[i],m+=u[r]+d[r]+g[r]+f(i)+f(s.length)+f(b),b+=s.length}}return m+=o.join("")+c.join("")}return e.prototype={name:null,font:null,mimetype:null,disableFontFace:!1,get renderer(){var e=h.FontRendererFactory.create(this,m);return(0,a.shadow)(this,"renderer",e)},exportData(e=!1){const t=e?[...b,...y]:b,r=Object.create(null);let a,i;for(a of t)i=this[a],void 0!==i&&(r[a]=i);return r},fallbackToSystemFont(e){this.missingFile=!0;var t=this.name,r=this.type,i=this.subtype;let l=t.replace(/[,_]/g,"-").replace(/\s/g,"");var h=(0,o.getStdFontMap)(),u=(0,o.getNonStdFontMap)();const d=!!h[l],f=!(!u[l]||!h[u[l]]);l=h[l]||u[l]||l,this.bold=-1!==l.search(/bold/gi),this.italic=-1!==l.search(/oblique/gi)||-1!==l.search(/italic/gi),this.black=-1!==t.search(/Black/g);const g=-1!==t.search(/Narrow/g);if(this.remeasure=(!d||g)&&Object.keys(this.widths).length>0,(d||f)&&"CIDFontType2"===r&&this.cidEncoding.startsWith("Identity-")){const r=(0,o.getGlyphMapForStandardFonts)(),a=e.cidToGidMap,i=[];for(const e in r)i[+e]=r[e];if(/Arial-?Black/i.test(t)){var p=(0,o.getSupplementalGlyphMapForArialBlack)();for(const e in p)i[+e]=p[e]}else if(/Calibri/i.test(t)){const e=(0,o.getSupplementalGlyphMapForCalibri)();for(const t in e)i[+t]=e[t]}if(a)for(const e in i){const t=i[e];void 0!==a[t]&&(i[+e]=a[t])}this.toUnicode instanceof O||this.toUnicode.forEach((function(e,t){i[+e]=t})),this.toFontChar=i,this.toUnicode=new C(i)}else if(/Symbol/i.test(l))this.toFontChar=P(s.SymbolSetEncoding,(0,n.getGlyphsUnicode)(),this.differences);else if(/Dingbats/i.test(l))/Wingdings/i.test(t)&&(0,a.warn)("Non-embedded Wingdings font, falling back to ZapfDingbats."),this.toFontChar=P(s.ZapfDingbatsEncoding,(0,n.getDingbatsGlyphsUnicode)(),this.differences);else if(d)this.toFontChar=P(this.defaultEncoding,(0,n.getGlyphsUnicode)(),this.differences);else{const e=(0,n.getGlyphsUnicode)(),r=[];if(this.toUnicode.forEach(((t,a)=>{if(!this.composite){var i=this.differences[t]||this.defaultEncoding[t];const r=(0,c.getUnicodeForGlyph)(i,e);-1!==r&&(a=r)}r[+t]=a})),this.composite&&this.toUnicode instanceof O&&/Verdana/i.test(t)){const e=(0,o.getGlyphMapForStandardFonts)();for(const t in e)r[+t]=e[t]}this.toFontChar=r}this.loadedName=l.split("-")[0],this.fontType=k(r,i)},checkAndRepair:function(e,o,c){const l=["OS/2","cmap","head","hhea","hmtx","maxp","name","post","loca","glyf","fpgm","prep","cvt ","CFF "];function h(e,t){const r=Object.create(null);r["OS/2"]=null,r.cmap=null,r.head=null,r.hhea=null,r.hmtx=null,r.maxp=null,r.name=null,r.post=null;for(let a=0;a<t;a++){const t=f(e);l.includes(t.tag)&&(0!==t.length&&(r[t.tag]=t))}return r}function f(e){var t=(0,a.bytesToString)(e.getBytes(4)),r=e.getInt32()>>>0,i=e.getInt32()>>>0,n=e.getInt32()>>>0,s=e.pos;e.pos=e.start?e.start:0,e.skip(i);var o=e.getBytes(n);return e.pos=s,"head"===t&&(o[8]=o[9]=o[10]=o[11]=0,o[17]|=32),{tag:t,checksum:r,length:n,offset:i,data:o}}function g(e){return{version:(0,a.bytesToString)(e.getBytes(4)),numTables:e.getUint16(),searchRange:e.getUint16(),entrySelector:e.getUint16(),rangeShift:e.getUint16()}}function p(e,t,a,i,n,s){var o={length:0,sizeOfInstructions:0};if(a-t<=12)return o;var c,l,h,u=e.subarray(t,a),d=r(u[0],u[1]);if(d<0)return h=d=-1,(c=u)[(l=0)+1]=h,c[l]=h>>>8,i.set(u,n),o.length=u.length,o;var f,g=10,p=0;for(f=0;f<d;f++){p=(u[g]<<8|u[g+1])+1,g+=2}var m=g,b=u[g]<<8|u[g+1];o.sizeOfInstructions=b;var y=g+=2+b,w=0;for(f=0;f<p;f++){var v=u[g++];192&v&&(u[g-1]=63&v);let e=2;2&v?e=1:16&v&&(e=0);let t=2;4&v?t=1:32&v&&(t=0);const r=e+t;if(w+=r,8&v){var S=u[g++];f+=S,w+=S*r}}if(0===w)return o;var k=g+w;return k>u.length?o:!s&&b>0?(i.set(u.subarray(0,m),n),i.set([0,0],n+m),i.set(u.subarray(y,k),n+m+2),k-=b,u.length-k>3&&(k=k+3&-4),o.length=k,o):u.length-k>3?(k=k+3&-4,i.set(u.subarray(0,k),n),o.length=k,o):(i.set(u,n),o.length=u.length,o)}function b(e){var t=(o.start?o.start:0)+e.offset;o.pos=t;var r=[[],[]],i=e.length,n=t+i;if(0!==o.getUint16()||i<6)return r;var s,c,l=o.getUint16(),h=o.getUint16(),u=[];for(s=0;s<l&&o.pos+12<=n;s++){var d={platform:o.getUint16(),encoding:o.getUint16(),language:o.getUint16(),name:o.getUint16(),length:o.getUint16(),offset:o.getUint16()};(1===d.platform&&0===d.encoding&&0===d.language||3===d.platform&&1===d.encoding&&1033===d.language)&&u.push(d)}for(s=0,c=u.length;s<c;s++){var f=u[s];if(!(f.length<=0)){var g=t+h+f.offset;if(!(g+f.length>n)){o.pos=g;var p=f.name;if(f.encoding){for(var m="",b=0,y=f.length;b<y;b+=2)m+=String.fromCharCode(o.getUint16());r[1][p]=m}else r[0][p]=(0,a.bytesToString)(o.getBytes(f.length))}}}return r}var y=[0,0,0,0,0,0,0,0,-2,-2,-2,-2,0,0,-2,-5,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,-1,-1,-1,-1,1,-1,-999,0,1,0,-1,-2,0,-1,-2,-1,-1,0,-1,-1,0,0,-999,-999,-1,-1,-1,-1,-2,-999,-2,-2,-999,0,-2,-2,0,0,-2,0,-2,0,0,0,-2,-1,-1,1,1,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,-1,-1,0,-999,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,-2,-999,-999,-999,-999,-999,-1,-1,-2,-2,0,0,0,0,-1,-1,-999,-2,-2,0,0,-1,-2,-2,0,0,0,-1,-1,-1,-2];function w(e,t){for(var r,i,n,s,o,c=e.data,l=0,h=0,u=0,d=[],f=[],g=[],p=t.tooComplexToFollowFunctions,m=!1,b=0,w=0,v=c.length;l<v;){var S=c[l++];if(64===S)if(i=c[l++],m||w)l+=i;else for(r=0;r<i;r++)d.push(c[l++]);else if(65===S)if(i=c[l++],m||w)l+=2*i;else for(r=0;r<i;r++)n=c[l++],d.push(n<<8|c[l++]);else if(176==(248&S))if(i=S-176+1,m||w)l+=i;else for(r=0;r<i;r++)d.push(c[l++]);else if(184==(248&S))if(i=S-184+1,m||w)l+=2*i;else for(r=0;r<i;r++)n=c[l++],d.push(n<<8|c[l++]);else if(43!==S||p)if(44!==S||p){if(45===S)if(m)m=!1,h=l;else{if(!(o=f.pop()))return(0,a.warn)("TT: ENDF bad stack"),void(t.hintsValid=!1);s=g.pop(),c=o.data,l=o.i,t.functionsStackDeltas[s]=d.length-o.stackTop}else if(137===S)(m||w)&&((0,a.warn)("TT: nested IDEFs not allowed"),p=!0),m=!0,u=l;else if(88===S)++b;else if(27===S)w=b;else if(89===S)w===b&&(w=0),--b;else if(28===S&&!m&&!w){var k=d[d.length-1];k>0&&(l+=k-1)}}else(m||w)&&((0,a.warn)("TT: nested FDEFs not allowed"),p=!0),m=!0,u=l,s=d.pop(),t.functionsDefined[s]={data:c,i:l};else if(!m&&!w)if(s=d[d.length-1],isNaN(s))(0,a.info)("TT: CALL empty stack (or invalid entry).");else if(t.functionsUsed[s]=!0,s in t.functionsStackDeltas){const e=d.length+t.functionsStackDeltas[s];if(e<0)return(0,a.warn)("TT: CALL invalid functions stack delta."),void(t.hintsValid=!1);d.length=e}else if(s in t.functionsDefined&&!g.includes(s)){if(f.push({data:c,i:l,stackTop:d.length-1}),g.push(s),!(o=t.functionsDefined[s]))return(0,a.warn)("TT: CALL non-existent function"),void(t.hintsValid=!1);c=o.data,l=o.i}if(!m&&!w){let e=0;for(S<=142?e=y[S]:S>=192&&S<=223?e=-1:S>=224&&(e=-2),S>=113&&S<=117&&(i=d.pop(),isNaN(i)||(e=2*-i));e<0&&d.length>0;)d.pop(),e++;for(;e>0;)d.push(NaN),e--}}t.tooComplexToFollowFunctions=p;var x=[c];l>c.length&&x.push(new Uint8Array(l-c.length)),u>h&&((0,a.warn)("TT: complementing a missing function tail"),x.push(new Uint8Array([34,45]))),function(e,t){if(t.length>1){var r,a,i=0;for(r=0,a=t.length;r<a;r++)i+=t[r].length;i=i+3&-4;var n=new Uint8Array(i),s=0;for(r=0,a=t.length;r<a;r++)n.set(t[r],s),s+=t[r].length;e.data=n,e.length=i}}(e,x)}let k,A,C,O;if(T(o=new d.Stream(new Uint8Array(o.getBytes())))){const e=function(e,t){const{numFonts:r,offsetTable:i}=function(e){const t=(0,a.bytesToString)(e.getBytes(4));(0,a.assert)("ttcf"===t,"Must be a TrueType Collection font.");const r=e.getUint16(),i=e.getUint16(),n=e.getInt32()>>>0,s=[];for(let t=0;t<n;t++)s.push(e.getInt32()>>>0);const o={ttcTag:t,majorVersion:r,minorVersion:i,numFonts:n,offsetTable:s};switch(r){case 1:return o;case 2:return o.dsigTag=e.getInt32()>>>0,o.dsigLength=e.getInt32()>>>0,o.dsigOffset=e.getInt32()>>>0,o}throw new a.FormatError(`Invalid TrueType Collection majorVersion: ${r}.`)}(e);for(let n=0;n<r;n++){e.pos=(e.start||0)+i[n];const r=g(e),s=h(e,r.numTables);if(!s.name)throw new a.FormatError('TrueType Collection font must contain a "name" table.');const o=b(s.name);for(let e=0,a=o.length;e<a;e++)for(let a=0,i=o[e].length;a<i;a++){const i=o[e][a];if(i&&i.replace(/\s/g,"")===t)return{header:r,tables:s}}}throw new a.FormatError(`TrueType Collection does not contain "${t}" font.`)}(o,this.name);k=e.header,A=e.tables}else k=g(o),A=h(o,k.numTables);var I=!A["CFF "];if(I){if(!A.loca)throw new a.FormatError('Required "loca" table is not found');A.glyf||((0,a.warn)('Required "glyf" table is not found -- trying to recover.'),A.glyf={tag:"glyf",data:new Uint8Array(0)}),this.isOpenType=!1}else{const t=c.composite&&((c.cidToGidMap||[]).length>0||!(c.cMap instanceof u.IdentityCMap));if("OTTO"===k.version&&!t||!A.head||!A.hhea||!A.maxp||!A.post)return O=new d.Stream(A["CFF "].data),C=new M(O,c),S(c),this.convert(e,C,c);delete A.glyf,delete A.loca,delete A.fpgm,delete A.prep,delete A["cvt "],this.isOpenType=!0}if(!A.maxp)throw new a.FormatError('Required "maxp" table is not found');o.pos=(o.start||0)+A.maxp.offset;var P=o.getInt32();const E=o.getUint16();let R=E+1,_=!0;R>65535&&(_=!1,R=E,(0,a.warn)("Not enough space in glyfs to duplicate first glyph."));var U=0,X=0;P>=65536&&A.maxp.length>=22&&(o.pos+=8,o.getUint16()>2&&(A.maxp.data[14]=0,A.maxp.data[15]=2),o.pos+=4,U=o.getUint16(),o.pos+=4,X=o.getUint16());A.maxp.data[4]=R>>8,A.maxp.data[5]=255&R;var $=function(e,t,r,i){var n={functionsDefined:[],functionsUsed:[],functionsStackDeltas:[],tooComplexToFollowFunctions:!1,hintsValid:!0};if(e&&w(e,n),t&&w(t,n),e&&function(e,t){if(!e.tooComplexToFollowFunctions){if(e.functionsDefined.length>t)return(0,a.warn)("TT: more functions defined than expected"),void(e.hintsValid=!1);for(var r=0,i=e.functionsUsed.length;r<i;r++){if(r>t)return(0,a.warn)("TT: invalid function id: "+r),void(e.hintsValid=!1);if(e.functionsUsed[r]&&!e.functionsDefined[r])return(0,a.warn)("TT: undefined function: "+r),void(e.hintsValid=!1)}}}(n,i),r&&1&r.length){var s=new Uint8Array(r.length+1);s.set(r.data),r.data=s}return n.hintsValid}(A.fpgm,A.prep,A["cvt "],U);if($||(delete A.fpgm,delete A.prep,delete A["cvt "]),function(e,t,r,i,n){if(t){e.pos=(e.start?e.start:0)+t.offset,e.pos+=4,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=2,e.pos+=8,e.pos+=2;var s=e.getUint16();s>i&&((0,a.info)("The numOfMetrics ("+s+") should not be greater than the numGlyphs ("+i+")"),s=i,t.data[34]=(65280&s)>>8,t.data[35]=255&s);var o=i-s-(r.length-4*s>>1);if(o>0){var c=new Uint8Array(r.length+2*o);c.set(r.data),n&&(c[r.length]=r.data[2],c[r.length+1]=r.data[3]),r.data=c}}else r&&(r.data=null)}(o,A.hhea,A.hmtx,R,_),!A.head)throw new a.FormatError('Required "head" table is not found');!function(e,r,i){var n,s,o,c,l=e.data,h=(n=l[0],s=l[1],o=l[2],c=l[3],(n<<24)+(s<<16)+(o<<8)+c);h>>16!=1&&((0,a.info)("Attempting to fix invalid version in head table: "+h),l[0]=0,l[1]=1,l[2]=0,l[3]=0);var u=t(l[50],l[51]);if(u<0||u>1){(0,a.info)("Attempting to fix invalid indexToLocFormat in head table: "+u);var d=r+1;if(i===d<<1)l[50]=0,l[51]=0;else{if(i!==d<<2)throw new a.FormatError("Could not fix indexToLocFormat: "+u);l[50]=0,l[51]=1}}}(A.head,E,I?A.loca.length:0);var q=Object.create(null);if(I){var z=t(A.head.data[50],A.head.data[51]),H=function(e,t,r,a,i,n,s){var o,c,l;a?(o=4,c=function(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]},l=function(e,t,r){e[t]=r>>>24&255,e[t+1]=r>>16&255,e[t+2]=r>>8&255,e[t+3]=255&r}):(o=2,c=function(e,t){return e[t]<<9|e[t+1]<<1},l=function(e,t,r){e[t]=r>>9&255,e[t+1]=r>>1&255});var h=n?r+1:r,u=o*(1+h),d=new Uint8Array(u);d.set(e.data.subarray(0,u)),e.data=d;var f,g,m=t.data,b=m.length,y=new Uint8Array(b);const w=[];for(f=0,g=0;f<r+1;f++,g+=o){let e=c(d,g);e>b&&(e=b),w.push({index:f,offset:e,endOffset:0})}for(w.sort(((e,t)=>e.offset-t.offset)),f=0;f<r;f++)w[f].endOffset=w[f+1].offset;w.sort(((e,t)=>e.index-t.index));var v=Object.create(null),S=0;for(l(d,0,S),f=0,g=o;f<r;f++,g+=o){var k=p(m,w[f].offset,w[f].endOffset,y,S,i),x=k.length;0===x&&(v[f]=!0),k.sizeOfInstructions>s&&(s=k.sizeOfInstructions),l(d,g,S+=x)}if(0===S){var A=new Uint8Array([0,1,0,0,0,0,0,0,0,0,0,0,0,0,49,0]);for(f=0,g=o;f<h;f++,g+=o)l(d,g,A.length);t.data=A}else if(n){var C=c(d,o);y.length>C+S?t.data=y.subarray(0,C+S):(t.data=new Uint8Array(C+S),t.data.set(y.subarray(0,S))),t.data.set(y.subarray(0,C),S),l(e.data,d.length-o,S+C)}else t.data=y.subarray(0,S);return{missingGlyphs:v,maxSizeOfInstructions:s}}(A.loca,A.glyf,E,z,$,_,X);q=H.missingGlyphs,P>=65536&&A.maxp.length>=22&&(A.maxp.data[26]=H.maxSizeOfInstructions>>8,A.maxp.data[27]=255&H.maxSizeOfInstructions)}if(!A.hhea)throw new a.FormatError('Required "hhea" table is not found');0===A.hhea.data[10]&&0===A.hhea.data[11]&&(A.hhea.data[10]=255,A.hhea.data[11]=255);var G={unitsPerEm:t(A.head.data[18],A.head.data[19]),yMax:t(A.head.data[42],A.head.data[43]),yMin:r(A.head.data[38],A.head.data[39]),ascent:t(A.hhea.data[4],A.hhea.data[5]),descent:r(A.hhea.data[6],A.hhea.data[7])};this.ascent=G.ascent/G.unitsPerEm,this.descent=G.descent/G.unitsPerEm,A.post&&function(e,t,r){var i=(o.start?o.start:0)+e.offset;o.pos=i;var n,s=i+e.length,c=o.getInt32();o.skip(28);var l,h=!0;switch(c){case 65536:n=v;break;case 131072:var u=o.getUint16();if(u!==r){h=!1;break}var d=[];for(l=0;l<u;++l){var f=o.getUint16();if(f>=32768){h=!1;break}d.push(f)}if(!h)break;for(var g=[],p=[];o.pos<s;){var m=o.getByte();for(p.length=m,l=0;l<m;++l)p[l]=String.fromCharCode(o.getByte());g.push(p.join(""))}for(n=[],l=0;l<u;++l){var b=d[l];b<258?n.push(v[b]):n.push(g[b-258])}break;case 196608:break;default:(0,a.warn)("Unknown/unsupported post table version "+c),h=!1,t.defaultEncoding&&(n=t.defaultEncoding);break}t.glyphNames=n}(A.post,c,E),A.post={tag:"post",data:j(c)};const V=[];function W(e){return!q[e]}if(c.composite){var K=c.cidToGidMap||[],Y=0===K.length;c.cMap.forEach((function(e,t){if(t>65535)throw new a.FormatError("Max size of CID is 65,535");var r=-1;Y?r=t:void 0!==K[t]&&(r=K[t]),r>=0&&r<E&&W(r)&&(V[e]=r)}))}else{var J=function(e,t,r,i){if(!e)return(0,a.warn)("No cmap table available."),{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1};var n,s=(t.start?t.start:0)+e.offset;t.pos=s,t.skip(2);for(var o,c=t.getUint16(),l=!1,h=0;h<c;h++){var u=t.getUint16(),d=t.getUint16(),f=t.getInt32()>>>0,g=!1;if((!o||o.platformId!==u||o.encodingId!==d)&&(0!==u||0!==d&&1!==d&&3!==d?1===u&&0===d?g=!0:3!==u||1!==d||!i&&o?r&&3===u&&0===d&&(g=!0,l=!0):(g=!0,r||(l=!0)):g=!0,g&&(o={platformId:u,encodingId:d,offset:f}),l))break}if(o&&(t.pos=s+o.offset),!o||-1===t.peekByte())return(0,a.warn)("Could not find a preferred cmap table."),{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1};var p=t.getUint16();t.skip(4);var m,b,y=!1,w=[];if(0===p){for(m=0;m<256;m++){var v=t.getByte();v&&w.push({charCode:m,glyphId:v})}y=!0}else if(4===p){var S=t.getUint16()>>1;t.skip(6);var k,x=[];for(k=0;k<S;k++)x.push({end:t.getUint16()});for(t.skip(2),k=0;k<S;k++)x[k].start=t.getUint16();for(k=0;k<S;k++)x[k].delta=t.getUint16();var A=0;for(k=0;k<S;k++){n=x[k];var C=t.getUint16();if(C){var O=(C>>1)-(S-k);n.offsetIndex=O,A=Math.max(A,O+n.end-n.start+1)}else n.offsetIndex=-1}var F=[];for(m=0;m<A;m++)F.push(t.getUint16());for(k=0;k<S;k++){s=(n=x[k]).start;var I=n.end,T=n.delta;for(O=n.offsetIndex,m=s;m<=I;m++)65535!==m&&(b=(b=O<0?m:F[O+m-s])+T&65535,w.push({charCode:m,glyphId:b}))}}else{if(6!==p)return(0,a.warn)("cmap table has unsupported format: "+p),{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1};var P=t.getUint16(),E=t.getUint16();for(m=0;m<E;m++){b=t.getUint16();var M=P+m;w.push({charCode:M,glyphId:b})}}for(w.sort((function(e,t){return e.charCode-t.charCode})),h=1;h<w.length;h++)w[h-1].charCode===w[h].charCode&&(w.splice(h,1),h--);return{platformId:o.platformId,encodingId:o.encodingId,mappings:w,hasShortCmap:y}}(A.cmap,o,this.isSymbolicFont,c.hasEncoding),Z=J.platformId,Q=J.encodingId,ee=J.mappings,te=ee.length;let e=[];if(!c.hasEncoding||"MacRomanEncoding"!==c.baseEncodingName&&"WinAnsiEncoding"!==c.baseEncodingName||(e=(0,s.getEncoding)(c.baseEncodingName)),c.hasEncoding&&!this.isSymbolicFont&&(3===Z&&1===Q||1===Z&&0===Q)){var re=(0,n.getGlyphsUnicode)();for(let t=0;t<256;t++){var ae,ie;if(ae=this.differences&&t in this.differences?this.differences[t]:t in e&&""!==e[t]?e[t]:s.StandardEncoding[t]){var ne;ie=x(ae,re),3===Z&&1===Q?ne=re[ie]:1===Z&&0===Q&&(ne=s.MacRomanEncoding.indexOf(ie));for(let e=0;e<te;++e)if(ee[e].charCode===ne){V[t]=ee[e].glyphId;break}}}}else if(0===Z)for(let e=0;e<te;++e)V[ee[e].charCode]=ee[e].glyphId;else for(let e=0;e<te;++e){let t=ee[e].charCode;3===Z&&t>=61440&&t<=61695&&(t&=255),V[t]=ee[e].glyphId}if(c.glyphNames&&(e.length||this.differences.length))for(let t=0;t<256;++t){if(void 0!==V[t])continue;if(!(ae=this.differences[t]||e[t]))continue;const r=c.glyphNames.indexOf(ae);r>0&&W(r)&&(V[t]=r)}}0===V.length&&(V[0]=0);let se=R-1;_||(se=0);var oe=N(V,W,se);if(this.toFontChar=oe.toFontChar,A.cmap={tag:"cmap",data:D(oe.charCodeToGlyphId,R)},A["OS/2"]&&function(e,t){t.pos=(t.start||0)+e.offset;var r=t.getUint16();t.skip(60);var a=t.getUint16();return!(r<4&&768&a||t.getUint16()>t.getUint16()||(t.skip(6),0===t.getUint16()||(e.data[8]=e.data[9]=0,0)))}(A["OS/2"],o)||(A["OS/2"]={tag:"OS/2",data:B(c,oe.charCodeToGlyphId,G)}),!I)try{O=new d.Stream(A["CFF "].data),C=new i.CFFParser(O,c,m).parse(),C.duplicateFirstGlyph();var ce=new i.CFFCompiler(C);A["CFF "].data=ce.compile()}catch(e){(0,a.warn)("Failed to compile font "+c.loadedName)}if(A.name){var le=b(A.name);A.name.data=L(e,le)}else A.name={tag:"name",data:L(this.name)};var he=new F(k.version);for(var ue in A)he.addTable(ue,A[ue].data);return he.toArray()},convert:function(e,t,r){r.fixedPitch=!1,r.builtInEncoding&&function(e,t){if(!e.hasIncludedToUnicodeMap&&!(e.hasEncoding||t===e.defaultEncoding||e.toUnicode instanceof O)){var r=[],a=(0,n.getGlyphsUnicode)();for(var i in t){var s=t[i],o=(0,c.getUnicodeForGlyph)(s,a);-1!==o&&(r[i]=String.fromCharCode(o))}e.toUnicode.amend(r)}}(r,r.builtInEncoding);let i=1;t instanceof M&&(i=t.numGlyphs-1);var o=t.getGlyphMapping(r),l=N(o,t.hasGlyphId.bind(t),i);this.toFontChar=l.toFontChar;var h=t.numGlyphs;function u(e,t){var r=null;for(var a in e)t===e[a]&&(r||(r=[]),r.push(0|a));return r}function d(e,t){for(var r in e)if(t===e[r])return 0|r;return l.charCodeToGlyphId[l.nextAvailableFontCharCode]=t,l.nextAvailableFontCharCode++}var g=t.seacs;if(g&&g.length){var p=r.fontMatrix||a.FONT_IDENTITY_MATRIX,m=t.getCharset(),b=Object.create(null);for(var y in g){var w=g[y|=0],v=s.StandardEncoding[w[2]],S=s.StandardEncoding[w[3]],k=m.indexOf(v),x=m.indexOf(S);if(!(k<0||x<0)){var A={x:w[0]*p[0]+w[1]*p[2]+p[4],y:w[0]*p[1]+w[1]*p[3]+p[5]},C=u(o,y);if(C)for(let e=0,t=C.length;e<t;e++){var T=C[e],P=l.charCodeToGlyphId,E=d(P,k),R=d(P,x);b[T]={baseFontCharCode:E,accentFontCharCode:R,accentOffset:A}}}}r.seacMap=b}var _=1/(r.fontMatrix||a.FONT_IDENTITY_MATRIX)[0],U=new F("OTTO");return U.addTable("CFF ",t.data),U.addTable("OS/2",B(r,l.charCodeToGlyphId)),U.addTable("cmap",D(l.charCodeToGlyphId,h)),U.addTable("head","\0\0\0\0\0\0\0\0\0\0_<õ\0\0"+I(_)+"\0\0\0\0\v~'\0\0\0\0\v~'\0\0"+I(r.descent)+"ÿ"+I(r.ascent)+f(r.italicAngle?2:0)+"\0\0\0\0\0\0\0"),U.addTable("hhea","\0\0\0"+I(r.ascent)+I(r.descent)+"\0\0ÿÿ\0\0\0\0\0\0"+I(r.capHeight)+I(Math.tan(r.italicAngle)*r.xHeight)+"\0\0\0\0\0\0\0\0\0\0\0\0"+f(h)),U.addTable("hmtx",function(){var e=t.charstrings,r=t.cff?t.cff.widths:null,a="\0\0\0\0";for(let t=1,s=h;t<s;t++){var i=0;if(e){var n=e[t-1];i="width"in n?n.width:0}else r&&(i=Math.ceil(r[t]||0));a+=f(i)+f(0)}return a}()),U.addTable("maxp","\0\0P\0"+f(h)),U.addTable("name",L(e)),U.addTable("post",j(r)),U.toArray()},get spaceWidth(){for(var e,t=["space","minus","one","i","I"],r=0,i=t.length;r<i;r++){var s=t[r];if(s in this.widths){e=this.widths[s];break}var o=(0,n.getGlyphsUnicode)()[s],c=0;if(this.composite&&this.cMap.contains(o)&&(c=this.cMap.lookup(o)),!c&&this.toUnicode&&(c=this.toUnicode.charCodeOf(o)),c<=0&&(c=o),e=this.widths[c])break}return e=e||this.defaultWidth,(0,a.shadow)(this,"spaceWidth",e)},_charToGlyph(e,t=!1){var r,i,n,s=e;this.cMap&&this.cMap.contains(e)&&(s=this.cMap.lookup(e)),i=this.widths[s],i=(0,a.isNum)(i)?i:this.defaultWidth;var o=this.vmetrics&&this.vmetrics[s];let l=this.toUnicode.get(e)||this.fallbackToUnicode.get(e)||e;"number"==typeof l&&(l=String.fromCharCode(l));var h=e in this.toFontChar;if(r=this.toFontChar[e]||e,this.missingFile){const t=this.differences[e]||this.defaultEncoding[e];".notdef"!==t&&""!==t||"Type1"!==this.type||(r=32),r=(0,c.mapSpecialUnicodeValues)(r)}this.isType3Font&&(n=r);var u=null;if(this.seacMap&&this.seacMap[e]){h=!0;var d=this.seacMap[e];r=d.baseFontCharCode,u={fontChar:String.fromCodePoint(d.accentFontCharCode),offset:d.accentOffset}}let f="";"number"==typeof r&&(r<=1114111?f=String.fromCodePoint(r):(0,a.warn)(`charToGlyph - invalid fontCharCode: ${r}`));var g=this.glyphCache[e];return g&&g.matchesForCache(f,l,u,i,o,n,t,h)||(g=new A(f,l,u,i,o,n,t,h),this.glyphCache[e]=g),g},charsToGlyphs:function(e){var t,r,a,i=this.charsCache;if(i&&(t=i[e]))return t;i||(i=this.charsCache=Object.create(null)),t=[];var n,s=e,o=0;if(this.cMap)for(var c=Object.create(null);o<e.length;){this.cMap.readCharCode(e,o,c),a=c.charcode;var l=c.length;o+=l;var h=1===l&&32===e.charCodeAt(o-1);r=this._charToGlyph(a,h),t.push(r)}else for(o=0,n=e.length;o<n;++o)a=e.charCodeAt(o),r=this._charToGlyph(a,32===a),t.push(r);return i[s]=t},getCharPositions(e){const t=[];if(this.cMap){const r=Object.create(null);let a=0;for(;a<e.length;){this.cMap.readCharCode(e,a,r);const i=r.length;t.push([a,a+i]),a+=i}}else for(let r=0,a=e.length;r<a;++r)t.push([r,r+1]);return t},get glyphCacheValues(){return Object.values(this.glyphCache)},encodeString(e){const t=[],r=[],a=()=>t.length%2==1;for(let i=0,n=e.length;i<n;i++){const n=e.codePointAt(i);if(n>55295&&(n<57344||n>65533)&&i++,this.toUnicode){const e=String.fromCodePoint(n),i=this.toUnicode.charCodeOf(e);if(-1!==i){a()&&(t.push(r.join("")),r.length=0);for(let e=(this.cMap?this.cMap.getCharCodeLength(i):1)-1;e>=0;e--)r.push(String.fromCharCode(i>>8*e&255));continue}}a()||(t.push(r.join("")),r.length=0),r.push(String.fromCodePoint(n))}return t.push(r.join("")),t}},e}();t.Font=I;var T=function(){function e(e){this.error=e,this.loadedName="g_font_error",this.missingFile=!0}return e.prototype={charsToGlyphs:function(){return[]},encodeString:function(e){return[e]},exportData(e=!1){return{error:this.error}}},e}();function P(e,t,r){var a,i,o,c=Object.create(null),l=!!(e.flags&w.Symbolic);if(e.baseEncodingName)for(o=(0,s.getEncoding)(e.baseEncodingName),i=0;i<o.length;i++)a=r.indexOf(o[i]),c[i]=a>=0?a:0;else if(l)for(i in t)c[i]=t[i];else for(o=s.StandardEncoding,i=0;i<o.length;i++)a=r.indexOf(o[i]),c[i]=a>=0?a:0;var h,u=e.differences;if(u)for(i in u){var d=u[i];if(-1===(a=r.indexOf(d))){h||(h=(0,n.getGlyphsUnicode)());var f=x(d,h);f!==d&&(a=r.indexOf(f))}c[i]=a>=0?a:0}return c}t.ErrorFont=T;var E=function(){function e(e,t,r){for(var a,i=e.length,n=t.length,s=i-n,o=r,c=!1;o<s;){for(a=0;a<n&&e[o+a]===t[a];)a++;if(a>=n){for(o+=a;o<i&&(0,l.isWhiteSpace)(e[o]);)o++;c=!0;break}o++}return{found:c,length:o}}function t(t,r,i){var n=i.length1,s=(i.length2,r.peekBytes(6)),o=128===s[0]&&1===s[1];o&&(r.skip(6),n=s[5]<<24|s[4]<<16|s[3]<<8|s[2]);var c=function(t,r){var i,n,s,o,c=[101,101,120,101,99],h=t.pos;try{n=(i=t.getBytes(r)).length}catch(e){if(e instanceof l.MissingDataException)throw e}if(n===r&&(s=e(i,c,r-2*c.length)).found&&s.length===r)return{stream:new d.Stream(i),length:r};for((0,a.warn)('Invalid "Length1" property in Type1 font -- trying to recover.'),t.pos=h;0!==(s=e(t.peekBytes(2048),c,0)).length;)if(t.pos+=s.length,s.found){o=t.pos-h;break}return t.pos=h,o?{stream:new d.Stream(t.getBytes(o)),length:o}:((0,a.warn)('Unable to recover "Length1" property in Type1 font -- using as is.'),{stream:new d.Stream(t.getBytes(r)),length:r})}(r,n);new f.Type1Parser(c.stream,!1,m).extractFontHeader(i),o&&((s=r.getBytes(6))[5],s[4],s[3],s[2]);var h,u=(h=r.getBytes(),{stream:new d.Stream(h),length:h.length}),g=new f.Type1Parser(u.stream,!0,m).extractFontProgram(i);for(const e in g.properties)i[e]=g.properties[e];var p=g.charstrings,b=this.getType2Charstrings(p),y=this.getType2Subrs(g.subrs);this.charstrings=p,this.data=this.wrap(t,b,this.charstrings,y,i),this.seacs=this.getSeacs(g.charstrings)}return t.prototype={get numGlyphs(){return this.charstrings.length+1},getCharset:function(){for(var e=[".notdef"],t=this.charstrings,r=0;r<t.length;r++)e.push(t[r].glyphName);return e},getGlyphMapping:function(e){var t=this.charstrings;if(e.composite){const r=Object.create(null);for(let a=0,i=t.length;a<i;a++){r[e.cMap.charCodeOf(a)]=a+1}return r}var r,a=[".notdef"];for(r=0;r<t.length;r++)a.push(t[r].glyphName);var i=e.builtInEncoding;if(i){var n=Object.create(null);for(var s in i)(r=a.indexOf(i[s]))>=0&&(n[s]=r)}return P(e,n,a)},hasGlyphId:function(e){return!(e<0||e>=this.numGlyphs)&&(0===e||this.charstrings[e-1].charstring.length>0)},getSeacs:function(e){var t,r,a=[];for(t=0,r=e.length;t<r;t++){var i=e[t];i.seac&&(a[t+1]=i.seac)}return a},getType2Charstrings:function(e){for(var t=[],r=0,a=e.length;r<a;r++)t.push(e[r].charstring);return t},getType2Subrs:function(e){var t=0,r=e.length;t=r<1133?107:r<33769?1131:32768;var a,i=[];for(a=0;a<t;a++)i.push([11]);for(a=0;a<r;a++)i.push(e[a]);return i},wrap:function(e,t,r,a,n){var s=new i.CFF;s.header=new i.CFFHeader(1,0,4,4),s.names=[e];var o=new i.CFFTopDict;o.setByName("version",391),o.setByName("Notice",392),o.setByName("FullName",393),o.setByName("FamilyName",394),o.setByName("Weight",395),o.setByName("Encoding",null),o.setByName("FontMatrix",n.fontMatrix),o.setByName("FontBBox",n.bbox),o.setByName("charset",null),o.setByName("CharStrings",null),o.setByName("Private",null),s.topDict=o;var c=new i.CFFStrings;c.add("Version 0.11"),c.add("See original notice"),c.add(e),c.add(e),c.add("Medium"),s.strings=c,s.globalSubrIndex=new i.CFFIndex;var l,h,u=t.length,d=[".notdef"];for(l=0;l<u;l++){const e=r[l].glyphName;-1===i.CFFStandardStrings.indexOf(e)&&c.add(e),d.push(e)}s.charset=new i.CFFCharset(!1,0,d);var f=new i.CFFIndex;for(f.add([139,14]),l=0;l<u;l++)f.add(t[l]);s.charStrings=f;var g=new i.CFFPrivateDict;g.setByName("Subrs",null);var p=["BlueValues","OtherBlues","FamilyBlues","FamilyOtherBlues","StemSnapH","StemSnapV","BlueShift","BlueFuzz","BlueScale","LanguageGroup","ExpansionFactor","ForceBold","StdHW","StdVW"];for(l=0,h=p.length;l<h;l++){var m=p[l];if(m in n.privateData){var b=n.privateData[m];if(Array.isArray(b))for(var y=b.length-1;y>0;y--)b[y]-=b[y-1];g.setByName(m,b)}}s.topDict.privateDict=g;var w=new i.CFFIndex;for(l=0,h=a.length;l<h;l++)w.add(a[l]);return g.subrsIndex=w,new i.CFFCompiler(s).compile()}},t}(),M=function(){function e(e,t){this.properties=t;var r=new i.CFFParser(e,t,m);this.cff=r.parse(),this.cff.duplicateFirstGlyph();var n=new i.CFFCompiler(this.cff);this.seacs=this.cff.seacs;try{this.data=n.compile()}catch(r){(0,a.warn)("Failed to compile font "+t.loadedName),this.data=e}}return e.prototype={get numGlyphs(){return this.cff.charStrings.count},getCharset:function(){return this.cff.charset.charset},getGlyphMapping:function(){var e,t,r=this.cff,a=this.properties,i=r.charset.charset;if(a.composite){let s;if(e=Object.create(null),r.isCIDFont)for(t=0;t<i.length;t++){var n=i[t];s=a.cMap.charCodeOf(n),e[s]=t}else for(t=0;t<r.charStrings.count;t++)s=a.cMap.charCodeOf(t),e[s]=t;return e}return e=P(a,r.encoding?r.encoding.encoding:null,i)},hasGlyphId:function(e){return this.cff.hasGlyphId(e)}},e}()},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.CFFTopDict=t.CFFStrings=t.CFFStandardStrings=t.CFFPrivateDict=t.CFFParser=t.CFFIndex=t.CFFHeader=t.CFFFDSelect=t.CFFCompiler=t.CFFCharset=t.CFF=void 0;var a=r(2),i=r(33),n=r(34);const s=[".notdef","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","endash","dagger","daggerdbl","periodcentered","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","questiondown","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","ring","cedilla","hungarumlaut","ogonek","caron","emdash","AE","ordfeminine","Lslash","Oslash","OE","ordmasculine","ae","dotlessi","lslash","oslash","oe","germandbls","onesuperior","logicalnot","mu","trademark","Eth","onehalf","plusminus","Thorn","onequarter","divide","brokenbar","degree","thorn","threequarters","twosuperior","registered","minus","eth","multiply","threesuperior","copyright","Aacute","Acircumflex","Adieresis","Agrave","Aring","Atilde","Ccedilla","Eacute","Ecircumflex","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Ntilde","Oacute","Ocircumflex","Odieresis","Ograve","Otilde","Scaron","Uacute","Ucircumflex","Udieresis","Ugrave","Yacute","Ydieresis","Zcaron","aacute","acircumflex","adieresis","agrave","aring","atilde","ccedilla","eacute","ecircumflex","edieresis","egrave","iacute","icircumflex","idieresis","igrave","ntilde","oacute","ocircumflex","odieresis","ograve","otilde","scaron","uacute","ucircumflex","udieresis","ugrave","yacute","ydieresis","zcaron","exclamsmall","Hungarumlautsmall","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","commasuperior","threequartersemdash","periodsuperior","questionsmall","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","ffi","ffl","parenleftinferior","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","exclamdownsmall","centoldstyle","Lslashsmall","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","Dotaccentsmall","Macronsmall","figuredash","hypheninferior","Ogoneksmall","Ringsmall","Cedillasmall","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall","001.000","001.001","001.002","001.003","Black","Bold","Book","Light","Medium","Regular","Roman","Semibold"];t.CFFStandardStrings=s;const o=391,c=function(){const e=[null,{id:"hstem",min:2,stackClearing:!0,stem:!0},null,{id:"vstem",min:2,stackClearing:!0,stem:!0},{id:"vmoveto",min:1,stackClearing:!0},{id:"rlineto",min:2,resetStack:!0},{id:"hlineto",min:1,resetStack:!0},{id:"vlineto",min:1,resetStack:!0},{id:"rrcurveto",min:6,resetStack:!0},null,{id:"callsubr",min:1,undefStack:!0},{id:"return",min:0,undefStack:!0},null,null,{id:"endchar",min:0,stackClearing:!0},null,null,null,{id:"hstemhm",min:2,stackClearing:!0,stem:!0},{id:"hintmask",min:0,stackClearing:!0},{id:"cntrmask",min:0,stackClearing:!0},{id:"rmoveto",min:2,stackClearing:!0},{id:"hmoveto",min:1,stackClearing:!0},{id:"vstemhm",min:2,stackClearing:!0,stem:!0},{id:"rcurveline",min:8,resetStack:!0},{id:"rlinecurve",min:8,resetStack:!0},{id:"vvcurveto",min:4,resetStack:!0},{id:"hhcurveto",min:4,resetStack:!0},null,{id:"callgsubr",min:1,undefStack:!0},{id:"vhcurveto",min:4,resetStack:!0},{id:"hvcurveto",min:4,resetStack:!0}],t=[null,null,null,{id:"and",min:2,stackDelta:-1},{id:"or",min:2,stackDelta:-1},{id:"not",min:1,stackDelta:0},null,null,null,{id:"abs",min:1,stackDelta:0},{id:"add",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]+e[t-1]}},{id:"sub",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]-e[t-1]}},{id:"div",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]/e[t-1]}},null,{id:"neg",min:1,stackDelta:0,stackFn:function(e,t){e[t-1]=-e[t-1]}},{id:"eq",min:2,stackDelta:-1},null,null,{id:"drop",min:1,stackDelta:-1},null,{id:"put",min:2,stackDelta:-2},{id:"get",min:1,stackDelta:0},{id:"ifelse",min:4,stackDelta:-3},{id:"random",min:0,stackDelta:1},{id:"mul",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]*e[t-1]}},null,{id:"sqrt",min:1,stackDelta:0},{id:"dup",min:1,stackDelta:1},{id:"exch",min:2,stackDelta:0},{id:"index",min:2,stackDelta:0},{id:"roll",min:3,stackDelta:-2},null,null,null,{id:"hflex",min:7,resetStack:!0},{id:"flex",min:13,resetStack:!0},{id:"hflex1",min:9,resetStack:!0},{id:"flex1",min:11,resetStack:!0}];return class{constructor(e,t,r){this.bytes=e.getBytes(),this.properties=t,this.seacAnalysisEnabled=!!r}parse(){const e=this.properties,t=new l;this.cff=t;const r=this.parseHeader(),a=this.parseIndex(r.endPos),i=this.parseIndex(a.endPos),n=this.parseIndex(i.endPos),s=this.parseIndex(n.endPos),o=this.parseDict(i.obj.get(0)),c=this.createDict(g,o,t.strings);t.header=r.obj,t.names=this.parseNameIndex(a.obj),t.strings=this.parseStringIndex(n.obj),t.topDict=c,t.globalSubrIndex=s.obj,this.parsePrivateDict(t.topDict),t.isCIDFont=c.hasName("ROS");const h=c.getByName("CharStrings"),u=this.parseIndex(h).obj,d=c.getByName("FontMatrix");d&&(e.fontMatrix=d);const f=c.getByName("FontBBox");let p,m;if(f&&(e.ascent=Math.max(f[3],f[1]),e.descent=Math.min(f[1],f[3]),e.ascentScaled=!0),t.isCIDFont){const e=this.parseIndex(c.getByName("FDArray")).obj;for(let r=0,a=e.count;r<a;++r){const a=e.get(r),i=this.createDict(g,this.parseDict(a),t.strings);this.parsePrivateDict(i),t.fdArray.push(i)}m=null,p=this.parseCharsets(c.getByName("charset"),u.count,t.strings,!0),t.fdSelect=this.parseFDSelect(c.getByName("FDSelect"),u.count)}else p=this.parseCharsets(c.getByName("charset"),u.count,t.strings,!1),m=this.parseEncoding(c.getByName("Encoding"),e,t.strings,p.charset);t.charset=p,t.encoding=m;const b=this.parseCharStrings({charStrings:u,localSubrIndex:c.privateDict.subrsIndex,globalSubrIndex:s.obj,fdSelect:t.fdSelect,fdArray:t.fdArray,privateDict:c.privateDict});return t.charStrings=b.charStrings,t.seacs=b.seacs,t.widths=b.widths,t}parseHeader(){let e=this.bytes;const t=e.length;let r=0;for(;r<t&&1!==e[r];)++r;if(r>=t)throw new a.FormatError("Invalid CFF header");0!==r&&((0,a.info)("cff data is shifted"),e=e.subarray(r),this.bytes=e);const i=e[0],n=e[1],s=e[2],o=e[3];return{obj:new h(i,n,s,o),endPos:s}}parseDict(e){let t=0;function r(){let r=e[t++];return 30===r?function(){let r="";const a=15,i=["0","1","2","3","4","5","6","7","8","9",".","E","E-",null,"-"],n=e.length;for(;t<n;){const n=e[t++],s=n>>4,o=15&n;if(s===a)break;if(r+=i[s],o===a)break;r+=i[o]}return parseFloat(r)}():28===r?(r=e[t++],r=(r<<24|e[t++]<<16)>>16,r):29===r?(r=e[t++],r=r<<8|e[t++],r=r<<8|e[t++],r=r<<8|e[t++],r):r>=32&&r<=246?r-139:r>=247&&r<=250?256*(r-247)+e[t++]+108:r>=251&&r<=254?-256*(r-251)-e[t++]-108:((0,a.warn)('CFFParser_parseDict: "'+r+'" is a reserved command.'),NaN)}let i=[];const n=[];t=0;const s=e.length;for(;t<s;){let a=e[t];a<=21?(12===a&&(a=a<<8|e[++t]),n.push([a,i]),i=[],++t):i.push(r())}return n}parseIndex(e){const t=new d,r=this.bytes,a=r[e++]<<8|r[e++],i=[];let n,s,o=e;if(0!==a){const t=r[e++],c=e+(a+1)*t-1;for(n=0,s=a+1;n<s;++n){let a=0;for(let i=0;i<t;++i)a<<=8,a+=r[e++];i.push(c+a)}o=i[a]}for(n=0,s=i.length-1;n<s;++n){const e=i[n],a=i[n+1];t.add(r.subarray(e,a))}return{obj:t,endPos:o}}parseNameIndex(e){const t=[];for(let r=0,i=e.count;r<i;++r){const i=e.get(r);t.push((0,a.bytesToString)(i))}return t}parseStringIndex(e){const t=new u;for(let r=0,i=e.count;r<i;++r){const i=e.get(r);t.add((0,a.bytesToString)(i))}return t}createDict(e,t,r){const a=new e(r);for(let e=0,r=t.length;e<r;++e){const r=t[e],i=r[0],n=r[1];a.setByKey(i,n)}return a}parseCharString(r,i,n,s){if(!i||r.callDepth>10)return!1;let o=r.stackSize;const c=r.stack,l=i.length;for(let h=0;h<l;){const l=i[h++];let u=null;if(12===l){const e=i[h++];0===e?(i[h-2]=139,i[h-1]=22,o=0):u=t[e]}else if(28===l)c[o]=(i[h]<<24|i[h+1]<<16)>>16,h+=2,o++;else if(14===l){if(o>=4&&(o-=4,this.seacAnalysisEnabled))return r.seac=c.slice(o,o+4),!1;u=e[l]}else if(l>=32&&l<=246)c[o]=l-139,o++;else if(l>=247&&l<=254)c[o]=l<251?(l-247<<8)+i[h]+108:-(l-251<<8)-i[h]-108,h++,o++;else if(255===l)c[o]=(i[h]<<24|i[h+1]<<16|i[h+2]<<8|i[h+3])/65536,h+=4,o++;else if(19===l||20===l)r.hints+=o>>1,h+=r.hints+7>>3,o%=2,u=e[l];else{if(10===l||29===l){let t;if(t=10===l?n:s,!t)return u=e[l],(0,a.warn)("Missing subrsIndex for "+u.id),!1;let i=32768;t.count<1240?i=107:t.count<33900&&(i=1131);const h=c[--o]+i;if(h<0||h>=t.count||isNaN(h))return u=e[l],(0,a.warn)("Out of bounds subrIndex for "+u.id),!1;r.stackSize=o,r.callDepth++;if(!this.parseCharString(r,t.get(h),n,s))return!1;r.callDepth--,o=r.stackSize;continue}if(11===l)return r.stackSize=o,!0;u=e[l]}if(u){if(u.stem&&(r.hints+=o>>1,3===l||23===l?r.hasVStems=!0:!r.hasVStems||1!==l&&18!==l||((0,a.warn)("CFF stem hints are in wrong order"),i[h-1]=1===l?3:23)),"min"in u&&!r.undefStack&&o<u.min)return(0,a.warn)("Not enough parameters for "+u.id+"; actual: "+o+", expected: "+u.min),!1;r.firstStackClearing&&u.stackClearing&&(r.firstStackClearing=!1,o-=u.min,o>=2&&u.stem?o%=2:o>1&&(0,a.warn)("Found too many parameters for stack-clearing command"),o>0&&c[o-1]>=0&&(r.width=c[o-1])),"stackDelta"in u?("stackFn"in u&&u.stackFn(c,o),o+=u.stackDelta):u.stackClearing?o=0:u.resetStack?(o=0,r.undefStack=!1):u.undefStack&&(o=0,r.undefStack=!0,r.firstStackClearing=!1)}}return r.stackSize=o,!0}parseCharStrings({charStrings:e,localSubrIndex:t,globalSubrIndex:r,fdSelect:i,fdArray:n,privateDict:s}){const o=[],c=[],l=e.count;for(let h=0;h<l;h++){const l=e.get(h),u={callDepth:0,stackSize:0,stack:[],undefStack:!0,hints:0,firstStackClearing:!0,seac:null,width:null,hasVStems:!1};let d=!0,f=null,g=s;if(i&&n.length){const e=i.getFDIndex(h);-1===e&&((0,a.warn)("Glyph index is not in fd select."),d=!1),e>=n.length&&((0,a.warn)("Invalid fd index for glyph index."),d=!1),d&&(g=n[e].privateDict,f=g.subrsIndex)}else t&&(f=t);if(d&&(d=this.parseCharString(u,l,f,r)),null!==u.width){const e=g.getByName("nominalWidthX");c[h]=e+u.width}else{const e=g.getByName("defaultWidthX");c[h]=e}null!==u.seac&&(o[h]=u.seac),d||e.set(h,new Uint8Array([14]))}return{charStrings:e,seacs:o,widths:c}}emptyPrivateDictionary(e){const t=this.createDict(p,[],e.strings);e.setByKey(18,[0,0]),e.privateDict=t}parsePrivateDict(e){if(!e.hasName("Private"))return void this.emptyPrivateDictionary(e);const t=e.getByName("Private");if(!Array.isArray(t)||2!==t.length)return void e.removeByName("Private");const r=t[0],a=t[1];if(0===r||a>=this.bytes.length)return void this.emptyPrivateDictionary(e);const i=a+r,n=this.bytes.subarray(a,i),s=this.parseDict(n),o=this.createDict(p,s,e.strings);if(e.privateDict=o,!o.getByName("Subrs"))return;const c=o.getByName("Subrs"),l=a+c;if(0===c||l>=this.bytes.length)return void this.emptyPrivateDictionary(e);const h=this.parseIndex(l);o.subrsIndex=h.obj}parseCharsets(e,t,r,n){if(0===e)return new b(!0,m.ISO_ADOBE,i.ISOAdobeCharset);if(1===e)return new b(!0,m.EXPERT,i.ExpertCharset);if(2===e)return new b(!0,m.EXPERT_SUBSET,i.ExpertSubsetCharset);const s=this.bytes,o=e,c=s[e++],l=[n?0:".notdef"];let h,u,d;switch(t-=1,c){case 0:for(d=0;d<t;d++)h=s[e++]<<8|s[e++],l.push(n?h:r.get(h));break;case 1:for(;l.length<=t;)for(h=s[e++]<<8|s[e++],u=s[e++],d=0;d<=u;d++)l.push(n?h++:r.get(h++));break;case 2:for(;l.length<=t;)for(h=s[e++]<<8|s[e++],u=s[e++]<<8|s[e++],d=0;d<=u;d++)l.push(n?h++:r.get(h++));break;default:throw new a.FormatError("Unknown charset format")}const f=e,g=s.subarray(o,f);return new b(!1,c,l,g)}parseEncoding(e,t,r,i){const s=Object.create(null),o=this.bytes;let c,l,h,u=!1,d=null;if(0===e||1===e){u=!0,c=e;const t=e?n.ExpertEncoding:n.StandardEncoding;for(l=0,h=i.length;l<h;l++){const e=t.indexOf(i[l]);-1!==e&&(s[e]=l)}}else{const t=e;switch(c=o[e++],127&c){case 0:const t=o[e++];for(l=1;l<=t;l++)s[o[e++]]=l;break;case 1:const r=o[e++];let i=1;for(l=0;l<r;l++){const t=o[e++],r=o[e++];for(let e=t;e<=t+r;e++)s[e]=i++}break;default:throw new a.FormatError(`Unknown encoding format: ${c} in CFF`)}const n=e;128&c&&(o[t]&=127,function(){const t=o[e++];for(l=0;l<t;l++){const t=o[e++],a=(o[e++]<<8)+(255&o[e++]);s[t]=i.indexOf(r.get(a))}}()),d=o.subarray(t,n)}return c&=127,new y(u,c,s,d)}parseFDSelect(e,t){const r=this.bytes,i=r[e++],n=[];let s;switch(i){case 0:for(s=0;s<t;++s){const t=r[e++];n.push(t)}break;case 3:const o=r[e++]<<8|r[e++];for(s=0;s<o;++s){let t=r[e++]<<8|r[e++];0===s&&0!==t&&((0,a.warn)("parseFDSelect: The first range must have a first GID of 0 -- trying to recover."),t=0);const i=r[e++],o=r[e]<<8|r[e+1];for(let e=t;e<o;++e)n.push(i)}e+=2;break;default:throw new a.FormatError(`parseFDSelect: Unknown format "${i}".`)}if(n.length!==t)throw new a.FormatError("parseFDSelect: Invalid font data.");return new w(i,n)}}}();t.CFFParser=c;class l{constructor(){this.header=null,this.names=[],this.topDict=null,this.strings=new u,this.globalSubrIndex=null,this.encoding=null,this.charset=null,this.charStrings=null,this.fdArray=[],this.fdSelect=null,this.isCIDFont=!1}duplicateFirstGlyph(){if(this.charStrings.count>=65535)return void(0,a.warn)("Not enough space in charstrings to duplicate first glyph.");const e=this.charStrings.get(0);this.charStrings.add(e),this.isCIDFont&&this.fdSelect.fdSelect.push(this.fdSelect.fdSelect[0])}hasGlyphId(e){if(e<0||e>=this.charStrings.count)return!1;return this.charStrings.get(e).length>0}}t.CFF=l;class h{constructor(e,t,r,a){this.major=e,this.minor=t,this.hdrSize=r,this.offSize=a}}t.CFFHeader=h;class u{constructor(){this.strings=[]}get(e){return e>=0&&e<=390?s[e]:e-o<=this.strings.length?this.strings[e-o]:s[0]}getSID(e){let t=s.indexOf(e);return-1!==t?t:(t=this.strings.indexOf(e),-1!==t?t+o:-1)}add(e){this.strings.push(e)}get count(){return this.strings.length}}t.CFFStrings=u;class d{constructor(){this.objects=[],this.length=0}add(e){this.length+=e.length,this.objects.push(e)}set(e,t){this.length+=t.length-this.objects[e].length,this.objects[e]=t}get(e){return this.objects[e]}get count(){return this.objects.length}}t.CFFIndex=d;class f{constructor(e,t){this.keyToNameMap=e.keyToNameMap,this.nameToKeyMap=e.nameToKeyMap,this.defaults=e.defaults,this.types=e.types,this.opcodes=e.opcodes,this.order=e.order,this.strings=t,this.values=Object.create(null)}setByKey(e,t){if(!(e in this.keyToNameMap))return!1;const r=t.length;if(0===r)return!0;for(let i=0;i<r;i++)if(isNaN(t[i]))return(0,a.warn)('Invalid CFFDict value: "'+t+'" for key "'+e+'".'),!0;const i=this.types[e];return"num"!==i&&"sid"!==i&&"offset"!==i||(t=t[0]),this.values[e]=t,!0}setByName(e,t){if(!(e in this.nameToKeyMap))throw new a.FormatError(`Invalid dictionary name "${e}"`);this.values[this.nameToKeyMap[e]]=t}hasName(e){return this.nameToKeyMap[e]in this.values}getByName(e){if(!(e in this.nameToKeyMap))throw new a.FormatError(`Invalid dictionary name ${e}"`);const t=this.nameToKeyMap[e];return t in this.values?this.values[t]:this.defaults[t]}removeByName(e){delete this.values[this.nameToKeyMap[e]]}static createTables(e){const t={keyToNameMap:{},nameToKeyMap:{},defaults:{},types:{},opcodes:{},order:[]};for(let r=0,a=e.length;r<a;++r){const a=e[r],i=Array.isArray(a[0])?(a[0][0]<<8)+a[0][1]:a[0];t.keyToNameMap[i]=a[1],t.nameToKeyMap[a[1]]=i,t.types[i]=a[2],t.defaults[i]=a[3],t.opcodes[i]=Array.isArray(a[0])?a[0]:[a[0]],t.order.push(i)}return t}}const g=function(){const e=[[[12,30],"ROS",["sid","sid","num"],null],[[12,20],"SyntheticBase","num",null],[0,"version","sid",null],[1,"Notice","sid",null],[[12,0],"Copyright","sid",null],[2,"FullName","sid",null],[3,"FamilyName","sid",null],[4,"Weight","sid",null],[[12,1],"isFixedPitch","num",0],[[12,2],"ItalicAngle","num",0],[[12,3],"UnderlinePosition","num",-100],[[12,4],"UnderlineThickness","num",50],[[12,5],"PaintType","num",0],[[12,6],"CharstringType","num",2],[[12,7],"FontMatrix",["num","num","num","num","num","num"],[.001,0,0,.001,0,0]],[13,"UniqueID","num",null],[5,"FontBBox",["num","num","num","num"],[0,0,0,0]],[[12,8],"StrokeWidth","num",0],[14,"XUID","array",null],[15,"charset","offset",0],[16,"Encoding","offset",0],[17,"CharStrings","offset",0],[18,"Private",["offset","offset"],null],[[12,21],"PostScript","sid",null],[[12,22],"BaseFontName","sid",null],[[12,23],"BaseFontBlend","delta",null],[[12,31],"CIDFontVersion","num",0],[[12,32],"CIDFontRevision","num",0],[[12,33],"CIDFontType","num",0],[[12,34],"CIDCount","num",8720],[[12,35],"UIDBase","num",null],[[12,37],"FDSelect","offset",null],[[12,36],"FDArray","offset",null],[[12,38],"FontName","sid",null]];let t=null;return class extends f{constructor(r){null===t&&(t=f.createTables(e)),super(t,r),this.privateDict=null}}}();t.CFFTopDict=g;const p=function(){const e=[[6,"BlueValues","delta",null],[7,"OtherBlues","delta",null],[8,"FamilyBlues","delta",null],[9,"FamilyOtherBlues","delta",null],[[12,9],"BlueScale","num",.039625],[[12,10],"BlueShift","num",7],[[12,11],"BlueFuzz","num",1],[10,"StdHW","num",null],[11,"StdVW","num",null],[[12,12],"StemSnapH","delta",null],[[12,13],"StemSnapV","delta",null],[[12,14],"ForceBold","num",0],[[12,17],"LanguageGroup","num",0],[[12,18],"ExpansionFactor","num",.06],[[12,19],"initialRandomSeed","num",0],[20,"defaultWidthX","num",0],[21,"nominalWidthX","num",0],[19,"Subrs","offset",null]];let t=null;return class extends f{constructor(r){null===t&&(t=f.createTables(e)),super(t,r),this.subrsIndex=null}}}();t.CFFPrivateDict=p;const m={ISO_ADOBE:0,EXPERT:1,EXPERT_SUBSET:2};class b{constructor(e,t,r,a){this.predefined=e,this.format=t,this.charset=r,this.raw=a}}t.CFFCharset=b;class y{constructor(e,t,r,a){this.predefined=e,this.format=t,this.encoding=r,this.raw=a}}class w{constructor(e,t){this.format=e,this.fdSelect=t}getFDIndex(e){return e<0||e>=this.fdSelect.length?-1:this.fdSelect[e]}}t.CFFFDSelect=w;class v{constructor(){this.offsets=Object.create(null)}isTracking(e){return e in this.offsets}track(e,t){if(e in this.offsets)throw new a.FormatError(`Already tracking location of ${e}`);this.offsets[e]=t}offset(e){for(const t in this.offsets)this.offsets[t]+=e}setEntryLocation(e,t,r){if(!(e in this.offsets))throw new a.FormatError(`Not tracking location of ${e}`);const i=r.data,n=this.offsets[e];for(let e=0,r=t.length;e<r;++e){const r=5*e+n,s=r+1,o=r+2,c=r+3,l=r+4;if(29!==i[r]||0!==i[s]||0!==i[o]||0!==i[c]||0!==i[l])throw new a.FormatError("writing to an offset that is not empty");const h=t[e];i[r]=29,i[s]=h>>24&255,i[o]=h>>16&255,i[c]=h>>8&255,i[l]=255&h}}}class S{constructor(e){this.cff=e}compile(){const e=this.cff,t={data:[],length:0,add:function(e){this.data=this.data.concat(e),this.length=this.data.length}},r=this.compileHeader(e.header);t.add(r);const i=this.compileNameIndex(e.names);if(t.add(i),e.isCIDFont&&e.topDict.hasName("FontMatrix")){const t=e.topDict.getByName("FontMatrix");e.topDict.removeByName("FontMatrix");for(let r=0,i=e.fdArray.length;r<i;r++){const i=e.fdArray[r];let n=t.slice(0);i.hasName("FontMatrix")&&(n=a.Util.transform(n,i.getByName("FontMatrix"))),i.setByName("FontMatrix",n)}}const n=e.topDict.getByName("XUID");n&&n.length>16&&e.topDict.removeByName("XUID"),e.topDict.setByName("charset",0);let s=this.compileTopDicts([e.topDict],t.length,e.isCIDFont);t.add(s.output);const o=s.trackers[0],c=this.compileStringIndex(e.strings.strings);t.add(c);const l=this.compileIndex(e.globalSubrIndex);if(t.add(l),e.encoding&&e.topDict.hasName("Encoding"))if(e.encoding.predefined)o.setEntryLocation("Encoding",[e.encoding.format],t);else{const r=this.compileEncoding(e.encoding);o.setEntryLocation("Encoding",[t.length],t),t.add(r)}const h=this.compileCharset(e.charset,e.charStrings.count,e.strings,e.isCIDFont);o.setEntryLocation("charset",[t.length],t),t.add(h);const u=this.compileCharStrings(e.charStrings);if(o.setEntryLocation("CharStrings",[t.length],t),t.add(u),e.isCIDFont){o.setEntryLocation("FDSelect",[t.length],t);const r=this.compileFDSelect(e.fdSelect);t.add(r),s=this.compileTopDicts(e.fdArray,t.length,!0),o.setEntryLocation("FDArray",[t.length],t),t.add(s.output);const a=s.trackers;this.compilePrivateDicts(e.fdArray,a,t)}return this.compilePrivateDicts([e.topDict],[o],t),t.add([0]),t.data}encodeNumber(e){return Number.isInteger(e)?this.encodeInteger(e):this.encodeFloat(e)}static get EncodeFloatRegExp(){return(0,a.shadow)(this,"EncodeFloatRegExp",/\.(\d*?)(?:9{5,20}|0{5,20})\d{0,2}(?:e(.+)|$)/)}encodeFloat(e){let t=e.toString();const r=S.EncodeFloatRegExp.exec(t);if(r){const a=parseFloat("1e"+((r[2]?+r[2]:0)+r[1].length));t=(Math.round(e*a)/a).toString()}let a,i,n="";for(a=0,i=t.length;a<i;++a){const e=t[a];n+="e"===e?"-"===t[++a]?"c":"b":"."===e?"a":"-"===e?"e":e}n+=1&n.length?"f":"ff";const s=[30];for(a=0,i=n.length;a<i;a+=2)s.push(parseInt(n.substring(a,a+2),16));return s}encodeInteger(e){let t;return t=e>=-107&&e<=107?[e+139]:e>=108&&e<=1131?[247+((e-=108)>>8),255&e]:e>=-1131&&e<=-108?[251+((e=-e-108)>>8),255&e]:e>=-32768&&e<=32767?[28,e>>8&255,255&e]:[29,e>>24&255,e>>16&255,e>>8&255,255&e],t}compileHeader(e){return[e.major,e.minor,4,e.offSize]}compileNameIndex(e){const t=new d;for(let r=0,i=e.length;r<i;++r){const i=e[r],n=Math.min(i.length,127);let s=new Array(n);for(let e=0;e<n;e++){let t=i[e];(t<"!"||t>"~"||"["===t||"]"===t||"("===t||")"===t||"{"===t||"}"===t||"<"===t||">"===t||"/"===t||"%"===t)&&(t="_"),s[e]=t}s=s.join(""),""===s&&(s="Bad_Font_Name"),t.add((0,a.stringToBytes)(s))}return this.compileIndex(t)}compileTopDicts(e,t,r){const a=[];let i=new d;for(let n=0,s=e.length;n<s;++n){const s=e[n];r&&(s.removeByName("CIDFontVersion"),s.removeByName("CIDFontRevision"),s.removeByName("CIDFontType"),s.removeByName("CIDCount"),s.removeByName("UIDBase"));const o=new v,c=this.compileDict(s,o);a.push(o),i.add(c),o.offset(t)}return i=this.compileIndex(i,a),{trackers:a,output:i}}compilePrivateDicts(e,t,r){for(let i=0,n=e.length;i<n;++i){const n=e[i],s=n.privateDict;if(!s||!n.hasName("Private"))throw new a.FormatError("There must be a private dictionary.");const o=new v,c=this.compileDict(s,o);let l=r.length;if(o.offset(l),c.length||(l=0),t[i].setEntryLocation("Private",[c.length,l],r),r.add(c),s.subrsIndex&&s.hasName("Subrs")){const e=this.compileIndex(s.subrsIndex);o.setEntryLocation("Subrs",[c.length],r),r.add(e)}}}compileDict(e,t){let r=[];const i=e.order;for(let n=0;n<i.length;++n){const s=i[n];if(!(s in e.values))continue;let o=e.values[s],c=e.types[s];if(Array.isArray(c)||(c=[c]),Array.isArray(o)||(o=[o]),0!==o.length){for(let i=0,n=c.length;i<n;++i){const n=c[i],l=o[i];switch(n){case"num":case"sid":r=r.concat(this.encodeNumber(l));break;case"offset":const i=e.keyToNameMap[s];t.isTracking(i)||t.track(i,r.length),r=r.concat([29,0,0,0,0]);break;case"array":case"delta":r=r.concat(this.encodeNumber(l));for(let e=1,t=o.length;e<t;++e)r=r.concat(this.encodeNumber(o[e]));break;default:throw new a.FormatError(`Unknown data type of ${n}`)}}r=r.concat(e.opcodes[s])}}return r}compileStringIndex(e){const t=new d;for(let r=0,i=e.length;r<i;++r)t.add((0,a.stringToBytes)(e[r]));return this.compileIndex(t)}compileGlobalSubrIndex(){const e=this.cff.globalSubrIndex;this.out.writeByteArray(this.compileIndex(e))}compileCharStrings(e){const t=new d;for(let r=0;r<e.count;r++){const a=e.get(r);0!==a.length?t.add(a):t.add(new Uint8Array([139,14]))}return this.compileIndex(t)}compileCharset(e,t,r,i){let n;const s=t-1;if(i)n=new Uint8Array([2,0,0,s>>8&255,255&s]);else{n=new Uint8Array(1+2*s),n[0]=0;let t=0;const i=e.charset.length;let o=!1;for(let s=1;s<n.length;s+=2){let c=0;if(t<i){const i=e.charset[t++];c=r.getSID(i),-1===c&&(c=0,o||(o=!0,(0,a.warn)(`Couldn't find ${i} in CFF strings`)))}n[s]=c>>8&255,n[s+1]=255&c}}return this.compileTypedArray(n)}compileEncoding(e){return this.compileTypedArray(e.raw)}compileFDSelect(e){const t=e.format;let r,a;switch(t){case 0:for(r=new Uint8Array(1+e.fdSelect.length),r[0]=t,a=0;a<e.fdSelect.length;a++)r[a+1]=e.fdSelect[a];break;case 3:const i=0;let n=e.fdSelect[0];const s=[t,0,0,i>>8&255,255&i,n];for(a=1;a<e.fdSelect.length;a++){const t=e.fdSelect[a];t!==n&&(s.push(a>>8&255,255&a,t),n=t)}const o=(s.length-3)/3;s[1]=o>>8&255,s[2]=255&o,s.push(a>>8&255,255&a),r=new Uint8Array(s);break}return this.compileTypedArray(r)}compileTypedArray(e){const t=[];for(let r=0,a=e.length;r<a;++r)t[r]=e[r];return t}compileIndex(e,t=[]){const r=e.objects,a=r.length;if(0===a)return[0,0,0];const i=[a>>8&255,255&a];let n,s,o=1;for(n=0;n<a;++n)o+=r[n].length;s=o<256?1:o<65536?2:o<16777216?3:4,i.push(s);let c=1;for(n=0;n<a+1;n++)1===s?i.push(255&c):2===s?i.push(c>>8&255,255&c):3===s?i.push(c>>16&255,c>>8&255,255&c):i.push(c>>>24&255,c>>16&255,c>>8&255,255&c),r[n]&&(c+=r[n].length);for(n=0;n<a;n++){t[n]&&t[n].offset(i.length);for(let e=0,t=r[n].length;e<t;e++)i.push(r[n][e])}return i}}t.CFFCompiler=S},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ISOAdobeCharset=t.ExpertSubsetCharset=t.ExpertCharset=void 0;t.ISOAdobeCharset=[".notdef","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","endash","dagger","daggerdbl","periodcentered","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","questiondown","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","ring","cedilla","hungarumlaut","ogonek","caron","emdash","AE","ordfeminine","Lslash","Oslash","OE","ordmasculine","ae","dotlessi","lslash","oslash","oe","germandbls","onesuperior","logicalnot","mu","trademark","Eth","onehalf","plusminus","Thorn","onequarter","divide","brokenbar","degree","thorn","threequarters","twosuperior","registered","minus","eth","multiply","threesuperior","copyright","Aacute","Acircumflex","Adieresis","Agrave","Aring","Atilde","Ccedilla","Eacute","Ecircumflex","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Ntilde","Oacute","Ocircumflex","Odieresis","Ograve","Otilde","Scaron","Uacute","Ucircumflex","Udieresis","Ugrave","Yacute","Ydieresis","Zcaron","aacute","acircumflex","adieresis","agrave","aring","atilde","ccedilla","eacute","ecircumflex","edieresis","egrave","iacute","icircumflex","idieresis","igrave","ntilde","oacute","ocircumflex","odieresis","ograve","otilde","scaron","uacute","ucircumflex","udieresis","ugrave","yacute","ydieresis","zcaron"];t.ExpertCharset=[".notdef","space","exclamsmall","Hungarumlautsmall","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","questionsmall","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","fi","fl","ffi","ffl","parenleftinferior","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","exclamdownsmall","centoldstyle","Lslashsmall","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","Dotaccentsmall","Macronsmall","figuredash","hypheninferior","Ogoneksmall","Ringsmall","Cedillasmall","onequarter","onehalf","threequarters","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall"];t.ExpertSubsetCharset=[".notdef","space","dollaroldstyle","dollarsuperior","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","fi","fl","ffi","ffl","parenleftinferior","parenrightinferior","hyphensuperior","colonmonetary","onefitted","rupiah","centoldstyle","figuredash","hypheninferior","onequarter","onehalf","threequarters","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior"]},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getEncoding=function(e){switch(e){case"WinAnsiEncoding":return s;case"StandardEncoding":return n;case"MacRomanEncoding":return i;case"SymbolSetEncoding":return o;case"ZapfDingbatsEncoding":return c;case"ExpertEncoding":return r;case"MacExpertEncoding":return a;default:return null}},t.ZapfDingbatsEncoding=t.WinAnsiEncoding=t.SymbolSetEncoding=t.StandardEncoding=t.MacRomanEncoding=t.ExpertEncoding=void 0;const r=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclamsmall","Hungarumlautsmall","","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","questionsmall","","asuperior","bsuperior","centsuperior","dsuperior","esuperior","","","","isuperior","","","lsuperior","msuperior","nsuperior","osuperior","","","rsuperior","ssuperior","tsuperior","","ff","fi","fl","ffi","ffl","parenleftinferior","","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","exclamdownsmall","centoldstyle","Lslashsmall","","","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","","Dotaccentsmall","","","Macronsmall","","","figuredash","hypheninferior","","","Ogoneksmall","Ringsmall","Cedillasmall","","","","onequarter","onehalf","threequarters","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","","","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall"];t.ExpertEncoding=r;const a=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclamsmall","Hungarumlautsmall","centoldstyle","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","","threequartersemdash","","questionsmall","","","","","Ethsmall","","","onequarter","onehalf","threequarters","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","","","","","","","ff","fi","fl","ffi","ffl","parenleftinferior","","parenrightinferior","Circumflexsmall","hypheninferior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","","","asuperior","centsuperior","","","","","Aacutesmall","Agravesmall","Acircumflexsmall","Adieresissmall","Atildesmall","Aringsmall","Ccedillasmall","Eacutesmall","Egravesmall","Ecircumflexsmall","Edieresissmall","Iacutesmall","Igravesmall","Icircumflexsmall","Idieresissmall","Ntildesmall","Oacutesmall","Ogravesmall","Ocircumflexsmall","Odieresissmall","Otildesmall","Uacutesmall","Ugravesmall","Ucircumflexsmall","Udieresissmall","","eightsuperior","fourinferior","threeinferior","sixinferior","eightinferior","seveninferior","Scaronsmall","","centinferior","twoinferior","","Dieresissmall","","Caronsmall","osuperior","fiveinferior","","commainferior","periodinferior","Yacutesmall","","dollarinferior","","","Thornsmall","","nineinferior","zeroinferior","Zcaronsmall","AEsmall","Oslashsmall","questiondownsmall","oneinferior","Lslashsmall","","","","","","","Cedillasmall","","","","","","OEsmall","figuredash","hyphensuperior","","","","","exclamdownsmall","","Ydieresissmall","","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","ninesuperior","zerosuperior","","esuperior","rsuperior","tsuperior","","","isuperior","ssuperior","dsuperior","","","","","","lsuperior","Ogoneksmall","Brevesmall","Macronsmall","bsuperior","nsuperior","msuperior","commasuperior","periodsuperior","Dotaccentsmall","Ringsmall","","","",""],i=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","","Adieresis","Aring","Ccedilla","Eacute","Ntilde","Odieresis","Udieresis","aacute","agrave","acircumflex","adieresis","atilde","aring","ccedilla","eacute","egrave","ecircumflex","edieresis","iacute","igrave","icircumflex","idieresis","ntilde","oacute","ograve","ocircumflex","odieresis","otilde","uacute","ugrave","ucircumflex","udieresis","dagger","degree","cent","sterling","section","bullet","paragraph","germandbls","registered","copyright","trademark","acute","dieresis","notequal","AE","Oslash","infinity","plusminus","lessequal","greaterequal","yen","mu","partialdiff","summation","product","pi","integral","ordfeminine","ordmasculine","Omega","ae","oslash","questiondown","exclamdown","logicalnot","radical","florin","approxequal","Delta","guillemotleft","guillemotright","ellipsis","space","Agrave","Atilde","Otilde","OE","oe","endash","emdash","quotedblleft","quotedblright","quoteleft","quoteright","divide","lozenge","ydieresis","Ydieresis","fraction","currency","guilsinglleft","guilsinglright","fi","fl","daggerdbl","periodcentered","quotesinglbase","quotedblbase","perthousand","Acircumflex","Ecircumflex","Aacute","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Oacute","Ocircumflex","apple","Ograve","Uacute","Ucircumflex","Ugrave","dotlessi","circumflex","tilde","macron","breve","dotaccent","ring","cedilla","hungarumlaut","ogonek","caron"];t.MacRomanEncoding=i;const n=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","","endash","dagger","daggerdbl","periodcentered","","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","","questiondown","","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","","ring","cedilla","","hungarumlaut","ogonek","caron","emdash","","","","","","","","","","","","","","","","","AE","","ordfeminine","","","","","Lslash","Oslash","OE","ordmasculine","","","","","","ae","","","","dotlessi","","","lslash","oslash","oe","germandbls","","","",""];t.StandardEncoding=n;const s=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","bullet","Euro","bullet","quotesinglbase","florin","quotedblbase","ellipsis","dagger","daggerdbl","circumflex","perthousand","Scaron","guilsinglleft","OE","bullet","Zcaron","bullet","bullet","quoteleft","quoteright","quotedblleft","quotedblright","bullet","endash","emdash","tilde","trademark","scaron","guilsinglright","oe","bullet","zcaron","Ydieresis","space","exclamdown","cent","sterling","currency","yen","brokenbar","section","dieresis","copyright","ordfeminine","guillemotleft","logicalnot","hyphen","registered","macron","degree","plusminus","twosuperior","threesuperior","acute","mu","paragraph","periodcentered","cedilla","onesuperior","ordmasculine","guillemotright","onequarter","onehalf","threequarters","questiondown","Agrave","Aacute","Acircumflex","Atilde","Adieresis","Aring","AE","Ccedilla","Egrave","Eacute","Ecircumflex","Edieresis","Igrave","Iacute","Icircumflex","Idieresis","Eth","Ntilde","Ograve","Oacute","Ocircumflex","Otilde","Odieresis","multiply","Oslash","Ugrave","Uacute","Ucircumflex","Udieresis","Yacute","Thorn","germandbls","agrave","aacute","acircumflex","atilde","adieresis","aring","ae","ccedilla","egrave","eacute","ecircumflex","edieresis","igrave","iacute","icircumflex","idieresis","eth","ntilde","ograve","oacute","ocircumflex","otilde","odieresis","divide","oslash","ugrave","uacute","ucircumflex","udieresis","yacute","thorn","ydieresis"];t.WinAnsiEncoding=s;const o=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","universal","numbersign","existential","percent","ampersand","suchthat","parenleft","parenright","asteriskmath","plus","comma","minus","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","congruent","Alpha","Beta","Chi","Delta","Epsilon","Phi","Gamma","Eta","Iota","theta1","Kappa","Lambda","Mu","Nu","Omicron","Pi","Theta","Rho","Sigma","Tau","Upsilon","sigma1","Omega","Xi","Psi","Zeta","bracketleft","therefore","bracketright","perpendicular","underscore","radicalex","alpha","beta","chi","delta","epsilon","phi","gamma","eta","iota","phi1","kappa","lambda","mu","nu","omicron","pi","theta","rho","sigma","tau","upsilon","omega1","omega","xi","psi","zeta","braceleft","bar","braceright","similar","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","Euro","Upsilon1","minute","lessequal","fraction","infinity","florin","club","diamond","heart","spade","arrowboth","arrowleft","arrowup","arrowright","arrowdown","degree","plusminus","second","greaterequal","multiply","proportional","partialdiff","bullet","divide","notequal","equivalence","approxequal","ellipsis","arrowvertex","arrowhorizex","carriagereturn","aleph","Ifraktur","Rfraktur","weierstrass","circlemultiply","circleplus","emptyset","intersection","union","propersuperset","reflexsuperset","notsubset","propersubset","reflexsubset","element","notelement","angle","gradient","registerserif","copyrightserif","trademarkserif","product","radical","dotmath","logicalnot","logicaland","logicalor","arrowdblboth","arrowdblleft","arrowdblup","arrowdblright","arrowdbldown","lozenge","angleleft","registersans","copyrightsans","trademarksans","summation","parenlefttp","parenleftex","parenleftbt","bracketlefttp","bracketleftex","bracketleftbt","bracelefttp","braceleftmid","braceleftbt","braceex","","angleright","integral","integraltp","integralex","integralbt","parenrighttp","parenrightex","parenrightbt","bracketrighttp","bracketrightex","bracketrightbt","bracerighttp","bracerightmid","bracerightbt",""];t.SymbolSetEncoding=o;const c=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","a1","a2","a202","a3","a4","a5","a119","a118","a117","a11","a12","a13","a14","a15","a16","a105","a17","a18","a19","a20","a21","a22","a23","a24","a25","a26","a27","a28","a6","a7","a8","a9","a10","a29","a30","a31","a32","a33","a34","a35","a36","a37","a38","a39","a40","a41","a42","a43","a44","a45","a46","a47","a48","a49","a50","a51","a52","a53","a54","a55","a56","a57","a58","a59","a60","a61","a62","a63","a64","a65","a66","a67","a68","a69","a70","a71","a72","a73","a74","a203","a75","a204","a76","a77","a78","a79","a81","a82","a83","a84","a97","a98","a99","a100","","a89","a90","a93","a94","a91","a92","a205","a85","a206","a86","a87","a88","a95","a96","","","","","","","","","","","","","","","","","","","","a101","a102","a103","a104","a106","a107","a108","a112","a111","a110","a109","a120","a121","a122","a123","a124","a125","a126","a127","a128","a129","a130","a131","a132","a133","a134","a135","a136","a137","a138","a139","a140","a141","a142","a143","a144","a145","a146","a147","a148","a149","a150","a151","a152","a153","a154","a155","a156","a157","a158","a159","a160","a161","a163","a164","a196","a165","a192","a166","a167","a168","a169","a170","a171","a172","a173","a162","a174","a175","a176","a177","a178","a179","a193","a180","a199","a181","a200","a182","","a201","a183","a184","a197","a185","a194","a198","a186","a195","a187","a188","a189","a190","a191",""];t.ZapfDingbatsEncoding=c},(e,t,r)=>{r.r(t),r.d(t,{getDingbatsGlyphsUnicode:()=>n,getGlyphsUnicode:()=>i});var a=r(8);const i=(0,a.getArrayLookupTableFactory)((function(){return["A",65,"AE",198,"AEacute",508,"AEmacron",482,"AEsmall",63462,"Aacute",193,"Aacutesmall",63457,"Abreve",258,"Abreveacute",7854,"Abrevecyrillic",1232,"Abrevedotbelow",7862,"Abrevegrave",7856,"Abrevehookabove",7858,"Abrevetilde",7860,"Acaron",461,"Acircle",9398,"Acircumflex",194,"Acircumflexacute",7844,"Acircumflexdotbelow",7852,"Acircumflexgrave",7846,"Acircumflexhookabove",7848,"Acircumflexsmall",63458,"Acircumflextilde",7850,"Acute",63177,"Acutesmall",63412,"Acyrillic",1040,"Adblgrave",512,"Adieresis",196,"Adieresiscyrillic",1234,"Adieresismacron",478,"Adieresissmall",63460,"Adotbelow",7840,"Adotmacron",480,"Agrave",192,"Agravesmall",63456,"Ahookabove",7842,"Aiecyrillic",1236,"Ainvertedbreve",514,"Alpha",913,"Alphatonos",902,"Amacron",256,"Amonospace",65313,"Aogonek",260,"Aring",197,"Aringacute",506,"Aringbelow",7680,"Aringsmall",63461,"Asmall",63329,"Atilde",195,"Atildesmall",63459,"Aybarmenian",1329,"B",66,"Bcircle",9399,"Bdotaccent",7682,"Bdotbelow",7684,"Becyrillic",1041,"Benarmenian",1330,"Beta",914,"Bhook",385,"Blinebelow",7686,"Bmonospace",65314,"Brevesmall",63220,"Bsmall",63330,"Btopbar",386,"C",67,"Caarmenian",1342,"Cacute",262,"Caron",63178,"Caronsmall",63221,"Ccaron",268,"Ccedilla",199,"Ccedillaacute",7688,"Ccedillasmall",63463,"Ccircle",9400,"Ccircumflex",264,"Cdot",266,"Cdotaccent",266,"Cedillasmall",63416,"Chaarmenian",1353,"Cheabkhasiancyrillic",1212,"Checyrillic",1063,"Chedescenderabkhasiancyrillic",1214,"Chedescendercyrillic",1206,"Chedieresiscyrillic",1268,"Cheharmenian",1347,"Chekhakassiancyrillic",1227,"Cheverticalstrokecyrillic",1208,"Chi",935,"Chook",391,"Circumflexsmall",63222,"Cmonospace",65315,"Coarmenian",1361,"Csmall",63331,"D",68,"DZ",497,"DZcaron",452,"Daarmenian",1332,"Dafrican",393,"Dcaron",270,"Dcedilla",7696,"Dcircle",9401,"Dcircumflexbelow",7698,"Dcroat",272,"Ddotaccent",7690,"Ddotbelow",7692,"Decyrillic",1044,"Deicoptic",1006,"Delta",8710,"Deltagreek",916,"Dhook",394,"Dieresis",63179,"DieresisAcute",63180,"DieresisGrave",63181,"Dieresissmall",63400,"Digammagreek",988,"Djecyrillic",1026,"Dlinebelow",7694,"Dmonospace",65316,"Dotaccentsmall",63223,"Dslash",272,"Dsmall",63332,"Dtopbar",395,"Dz",498,"Dzcaron",453,"Dzeabkhasiancyrillic",1248,"Dzecyrillic",1029,"Dzhecyrillic",1039,"E",69,"Eacute",201,"Eacutesmall",63465,"Ebreve",276,"Ecaron",282,"Ecedillabreve",7708,"Echarmenian",1333,"Ecircle",9402,"Ecircumflex",202,"Ecircumflexacute",7870,"Ecircumflexbelow",7704,"Ecircumflexdotbelow",7878,"Ecircumflexgrave",7872,"Ecircumflexhookabove",7874,"Ecircumflexsmall",63466,"Ecircumflextilde",7876,"Ecyrillic",1028,"Edblgrave",516,"Edieresis",203,"Edieresissmall",63467,"Edot",278,"Edotaccent",278,"Edotbelow",7864,"Efcyrillic",1060,"Egrave",200,"Egravesmall",63464,"Eharmenian",1335,"Ehookabove",7866,"Eightroman",8551,"Einvertedbreve",518,"Eiotifiedcyrillic",1124,"Elcyrillic",1051,"Elevenroman",8554,"Emacron",274,"Emacronacute",7702,"Emacrongrave",7700,"Emcyrillic",1052,"Emonospace",65317,"Encyrillic",1053,"Endescendercyrillic",1186,"Eng",330,"Enghecyrillic",1188,"Enhookcyrillic",1223,"Eogonek",280,"Eopen",400,"Epsilon",917,"Epsilontonos",904,"Ercyrillic",1056,"Ereversed",398,"Ereversedcyrillic",1069,"Escyrillic",1057,"Esdescendercyrillic",1194,"Esh",425,"Esmall",63333,"Eta",919,"Etarmenian",1336,"Etatonos",905,"Eth",208,"Ethsmall",63472,"Etilde",7868,"Etildebelow",7706,"Euro",8364,"Ezh",439,"Ezhcaron",494,"Ezhreversed",440,"F",70,"Fcircle",9403,"Fdotaccent",7710,"Feharmenian",1366,"Feicoptic",996,"Fhook",401,"Fitacyrillic",1138,"Fiveroman",8548,"Fmonospace",65318,"Fourroman",8547,"Fsmall",63334,"G",71,"GBsquare",13191,"Gacute",500,"Gamma",915,"Gammaafrican",404,"Gangiacoptic",1002,"Gbreve",286,"Gcaron",486,"Gcedilla",290,"Gcircle",9404,"Gcircumflex",284,"Gcommaaccent",290,"Gdot",288,"Gdotaccent",288,"Gecyrillic",1043,"Ghadarmenian",1346,"Ghemiddlehookcyrillic",1172,"Ghestrokecyrillic",1170,"Gheupturncyrillic",1168,"Ghook",403,"Gimarmenian",1331,"Gjecyrillic",1027,"Gmacron",7712,"Gmonospace",65319,"Grave",63182,"Gravesmall",63328,"Gsmall",63335,"Gsmallhook",667,"Gstroke",484,"H",72,"H18533",9679,"H18543",9642,"H18551",9643,"H22073",9633,"HPsquare",13259,"Haabkhasiancyrillic",1192,"Hadescendercyrillic",1202,"Hardsigncyrillic",1066,"Hbar",294,"Hbrevebelow",7722,"Hcedilla",7720,"Hcircle",9405,"Hcircumflex",292,"Hdieresis",7718,"Hdotaccent",7714,"Hdotbelow",7716,"Hmonospace",65320,"Hoarmenian",1344,"Horicoptic",1e3,"Hsmall",63336,"Hungarumlaut",63183,"Hungarumlautsmall",63224,"Hzsquare",13200,"I",73,"IAcyrillic",1071,"IJ",306,"IUcyrillic",1070,"Iacute",205,"Iacutesmall",63469,"Ibreve",300,"Icaron",463,"Icircle",9406,"Icircumflex",206,"Icircumflexsmall",63470,"Icyrillic",1030,"Idblgrave",520,"Idieresis",207,"Idieresisacute",7726,"Idieresiscyrillic",1252,"Idieresissmall",63471,"Idot",304,"Idotaccent",304,"Idotbelow",7882,"Iebrevecyrillic",1238,"Iecyrillic",1045,"Ifraktur",8465,"Igrave",204,"Igravesmall",63468,"Ihookabove",7880,"Iicyrillic",1048,"Iinvertedbreve",522,"Iishortcyrillic",1049,"Imacron",298,"Imacroncyrillic",1250,"Imonospace",65321,"Iniarmenian",1339,"Iocyrillic",1025,"Iogonek",302,"Iota",921,"Iotaafrican",406,"Iotadieresis",938,"Iotatonos",906,"Ismall",63337,"Istroke",407,"Itilde",296,"Itildebelow",7724,"Izhitsacyrillic",1140,"Izhitsadblgravecyrillic",1142,"J",74,"Jaarmenian",1345,"Jcircle",9407,"Jcircumflex",308,"Jecyrillic",1032,"Jheharmenian",1355,"Jmonospace",65322,"Jsmall",63338,"K",75,"KBsquare",13189,"KKsquare",13261,"Kabashkircyrillic",1184,"Kacute",7728,"Kacyrillic",1050,"Kadescendercyrillic",1178,"Kahookcyrillic",1219,"Kappa",922,"Kastrokecyrillic",1182,"Kaverticalstrokecyrillic",1180,"Kcaron",488,"Kcedilla",310,"Kcircle",9408,"Kcommaaccent",310,"Kdotbelow",7730,"Keharmenian",1364,"Kenarmenian",1343,"Khacyrillic",1061,"Kheicoptic",998,"Khook",408,"Kjecyrillic",1036,"Klinebelow",7732,"Kmonospace",65323,"Koppacyrillic",1152,"Koppagreek",990,"Ksicyrillic",1134,"Ksmall",63339,"L",76,"LJ",455,"LL",63167,"Lacute",313,"Lambda",923,"Lcaron",317,"Lcedilla",315,"Lcircle",9409,"Lcircumflexbelow",7740,"Lcommaaccent",315,"Ldot",319,"Ldotaccent",319,"Ldotbelow",7734,"Ldotbelowmacron",7736,"Liwnarmenian",1340,"Lj",456,"Ljecyrillic",1033,"Llinebelow",7738,"Lmonospace",65324,"Lslash",321,"Lslashsmall",63225,"Lsmall",63340,"M",77,"MBsquare",13190,"Macron",63184,"Macronsmall",63407,"Macute",7742,"Mcircle",9410,"Mdotaccent",7744,"Mdotbelow",7746,"Menarmenian",1348,"Mmonospace",65325,"Msmall",63341,"Mturned",412,"Mu",924,"N",78,"NJ",458,"Nacute",323,"Ncaron",327,"Ncedilla",325,"Ncircle",9411,"Ncircumflexbelow",7754,"Ncommaaccent",325,"Ndotaccent",7748,"Ndotbelow",7750,"Nhookleft",413,"Nineroman",8552,"Nj",459,"Njecyrillic",1034,"Nlinebelow",7752,"Nmonospace",65326,"Nowarmenian",1350,"Nsmall",63342,"Ntilde",209,"Ntildesmall",63473,"Nu",925,"O",79,"OE",338,"OEsmall",63226,"Oacute",211,"Oacutesmall",63475,"Obarredcyrillic",1256,"Obarreddieresiscyrillic",1258,"Obreve",334,"Ocaron",465,"Ocenteredtilde",415,"Ocircle",9412,"Ocircumflex",212,"Ocircumflexacute",7888,"Ocircumflexdotbelow",7896,"Ocircumflexgrave",7890,"Ocircumflexhookabove",7892,"Ocircumflexsmall",63476,"Ocircumflextilde",7894,"Ocyrillic",1054,"Odblacute",336,"Odblgrave",524,"Odieresis",214,"Odieresiscyrillic",1254,"Odieresissmall",63478,"Odotbelow",7884,"Ogoneksmall",63227,"Ograve",210,"Ogravesmall",63474,"Oharmenian",1365,"Ohm",8486,"Ohookabove",7886,"Ohorn",416,"Ohornacute",7898,"Ohorndotbelow",7906,"Ohorngrave",7900,"Ohornhookabove",7902,"Ohorntilde",7904,"Ohungarumlaut",336,"Oi",418,"Oinvertedbreve",526,"Omacron",332,"Omacronacute",7762,"Omacrongrave",7760,"Omega",8486,"Omegacyrillic",1120,"Omegagreek",937,"Omegaroundcyrillic",1146,"Omegatitlocyrillic",1148,"Omegatonos",911,"Omicron",927,"Omicrontonos",908,"Omonospace",65327,"Oneroman",8544,"Oogonek",490,"Oogonekmacron",492,"Oopen",390,"Oslash",216,"Oslashacute",510,"Oslashsmall",63480,"Osmall",63343,"Ostrokeacute",510,"Otcyrillic",1150,"Otilde",213,"Otildeacute",7756,"Otildedieresis",7758,"Otildesmall",63477,"P",80,"Pacute",7764,"Pcircle",9413,"Pdotaccent",7766,"Pecyrillic",1055,"Peharmenian",1354,"Pemiddlehookcyrillic",1190,"Phi",934,"Phook",420,"Pi",928,"Piwrarmenian",1363,"Pmonospace",65328,"Psi",936,"Psicyrillic",1136,"Psmall",63344,"Q",81,"Qcircle",9414,"Qmonospace",65329,"Qsmall",63345,"R",82,"Raarmenian",1356,"Racute",340,"Rcaron",344,"Rcedilla",342,"Rcircle",9415,"Rcommaaccent",342,"Rdblgrave",528,"Rdotaccent",7768,"Rdotbelow",7770,"Rdotbelowmacron",7772,"Reharmenian",1360,"Rfraktur",8476,"Rho",929,"Ringsmall",63228,"Rinvertedbreve",530,"Rlinebelow",7774,"Rmonospace",65330,"Rsmall",63346,"Rsmallinverted",641,"Rsmallinvertedsuperior",694,"S",83,"SF010000",9484,"SF020000",9492,"SF030000",9488,"SF040000",9496,"SF050000",9532,"SF060000",9516,"SF070000",9524,"SF080000",9500,"SF090000",9508,"SF100000",9472,"SF110000",9474,"SF190000",9569,"SF200000",9570,"SF210000",9558,"SF220000",9557,"SF230000",9571,"SF240000",9553,"SF250000",9559,"SF260000",9565,"SF270000",9564,"SF280000",9563,"SF360000",9566,"SF370000",9567,"SF380000",9562,"SF390000",9556,"SF400000",9577,"SF410000",9574,"SF420000",9568,"SF430000",9552,"SF440000",9580,"SF450000",9575,"SF460000",9576,"SF470000",9572,"SF480000",9573,"SF490000",9561,"SF500000",9560,"SF510000",9554,"SF520000",9555,"SF530000",9579,"SF540000",9578,"Sacute",346,"Sacutedotaccent",7780,"Sampigreek",992,"Scaron",352,"Scarondotaccent",7782,"Scaronsmall",63229,"Scedilla",350,"Schwa",399,"Schwacyrillic",1240,"Schwadieresiscyrillic",1242,"Scircle",9416,"Scircumflex",348,"Scommaaccent",536,"Sdotaccent",7776,"Sdotbelow",7778,"Sdotbelowdotaccent",7784,"Seharmenian",1357,"Sevenroman",8550,"Shaarmenian",1351,"Shacyrillic",1064,"Shchacyrillic",1065,"Sheicoptic",994,"Shhacyrillic",1210,"Shimacoptic",1004,"Sigma",931,"Sixroman",8549,"Smonospace",65331,"Softsigncyrillic",1068,"Ssmall",63347,"Stigmagreek",986,"T",84,"Tau",932,"Tbar",358,"Tcaron",356,"Tcedilla",354,"Tcircle",9417,"Tcircumflexbelow",7792,"Tcommaaccent",354,"Tdotaccent",7786,"Tdotbelow",7788,"Tecyrillic",1058,"Tedescendercyrillic",1196,"Tenroman",8553,"Tetsecyrillic",1204,"Theta",920,"Thook",428,"Thorn",222,"Thornsmall",63486,"Threeroman",8546,"Tildesmall",63230,"Tiwnarmenian",1359,"Tlinebelow",7790,"Tmonospace",65332,"Toarmenian",1337,"Tonefive",444,"Tonesix",388,"Tonetwo",423,"Tretroflexhook",430,"Tsecyrillic",1062,"Tshecyrillic",1035,"Tsmall",63348,"Twelveroman",8555,"Tworoman",8545,"U",85,"Uacute",218,"Uacutesmall",63482,"Ubreve",364,"Ucaron",467,"Ucircle",9418,"Ucircumflex",219,"Ucircumflexbelow",7798,"Ucircumflexsmall",63483,"Ucyrillic",1059,"Udblacute",368,"Udblgrave",532,"Udieresis",220,"Udieresisacute",471,"Udieresisbelow",7794,"Udieresiscaron",473,"Udieresiscyrillic",1264,"Udieresisgrave",475,"Udieresismacron",469,"Udieresissmall",63484,"Udotbelow",7908,"Ugrave",217,"Ugravesmall",63481,"Uhookabove",7910,"Uhorn",431,"Uhornacute",7912,"Uhorndotbelow",7920,"Uhorngrave",7914,"Uhornhookabove",7916,"Uhorntilde",7918,"Uhungarumlaut",368,"Uhungarumlautcyrillic",1266,"Uinvertedbreve",534,"Ukcyrillic",1144,"Umacron",362,"Umacroncyrillic",1262,"Umacrondieresis",7802,"Umonospace",65333,"Uogonek",370,"Upsilon",933,"Upsilon1",978,"Upsilonacutehooksymbolgreek",979,"Upsilonafrican",433,"Upsilondieresis",939,"Upsilondieresishooksymbolgreek",980,"Upsilonhooksymbol",978,"Upsilontonos",910,"Uring",366,"Ushortcyrillic",1038,"Usmall",63349,"Ustraightcyrillic",1198,"Ustraightstrokecyrillic",1200,"Utilde",360,"Utildeacute",7800,"Utildebelow",7796,"V",86,"Vcircle",9419,"Vdotbelow",7806,"Vecyrillic",1042,"Vewarmenian",1358,"Vhook",434,"Vmonospace",65334,"Voarmenian",1352,"Vsmall",63350,"Vtilde",7804,"W",87,"Wacute",7810,"Wcircle",9420,"Wcircumflex",372,"Wdieresis",7812,"Wdotaccent",7814,"Wdotbelow",7816,"Wgrave",7808,"Wmonospace",65335,"Wsmall",63351,"X",88,"Xcircle",9421,"Xdieresis",7820,"Xdotaccent",7818,"Xeharmenian",1341,"Xi",926,"Xmonospace",65336,"Xsmall",63352,"Y",89,"Yacute",221,"Yacutesmall",63485,"Yatcyrillic",1122,"Ycircle",9422,"Ycircumflex",374,"Ydieresis",376,"Ydieresissmall",63487,"Ydotaccent",7822,"Ydotbelow",7924,"Yericyrillic",1067,"Yerudieresiscyrillic",1272,"Ygrave",7922,"Yhook",435,"Yhookabove",7926,"Yiarmenian",1349,"Yicyrillic",1031,"Yiwnarmenian",1362,"Ymonospace",65337,"Ysmall",63353,"Ytilde",7928,"Yusbigcyrillic",1130,"Yusbigiotifiedcyrillic",1132,"Yuslittlecyrillic",1126,"Yuslittleiotifiedcyrillic",1128,"Z",90,"Zaarmenian",1334,"Zacute",377,"Zcaron",381,"Zcaronsmall",63231,"Zcircle",9423,"Zcircumflex",7824,"Zdot",379,"Zdotaccent",379,"Zdotbelow",7826,"Zecyrillic",1047,"Zedescendercyrillic",1176,"Zedieresiscyrillic",1246,"Zeta",918,"Zhearmenian",1338,"Zhebrevecyrillic",1217,"Zhecyrillic",1046,"Zhedescendercyrillic",1174,"Zhedieresiscyrillic",1244,"Zlinebelow",7828,"Zmonospace",65338,"Zsmall",63354,"Zstroke",437,"a",97,"aabengali",2438,"aacute",225,"aadeva",2310,"aagujarati",2694,"aagurmukhi",2566,"aamatragurmukhi",2622,"aarusquare",13059,"aavowelsignbengali",2494,"aavowelsigndeva",2366,"aavowelsigngujarati",2750,"abbreviationmarkarmenian",1375,"abbreviationsigndeva",2416,"abengali",2437,"abopomofo",12570,"abreve",259,"abreveacute",7855,"abrevecyrillic",1233,"abrevedotbelow",7863,"abrevegrave",7857,"abrevehookabove",7859,"abrevetilde",7861,"acaron",462,"acircle",9424,"acircumflex",226,"acircumflexacute",7845,"acircumflexdotbelow",7853,"acircumflexgrave",7847,"acircumflexhookabove",7849,"acircumflextilde",7851,"acute",180,"acutebelowcmb",791,"acutecmb",769,"acutecomb",769,"acutedeva",2388,"acutelowmod",719,"acutetonecmb",833,"acyrillic",1072,"adblgrave",513,"addakgurmukhi",2673,"adeva",2309,"adieresis",228,"adieresiscyrillic",1235,"adieresismacron",479,"adotbelow",7841,"adotmacron",481,"ae",230,"aeacute",509,"aekorean",12624,"aemacron",483,"afii00208",8213,"afii08941",8356,"afii10017",1040,"afii10018",1041,"afii10019",1042,"afii10020",1043,"afii10021",1044,"afii10022",1045,"afii10023",1025,"afii10024",1046,"afii10025",1047,"afii10026",1048,"afii10027",1049,"afii10028",1050,"afii10029",1051,"afii10030",1052,"afii10031",1053,"afii10032",1054,"afii10033",1055,"afii10034",1056,"afii10035",1057,"afii10036",1058,"afii10037",1059,"afii10038",1060,"afii10039",1061,"afii10040",1062,"afii10041",1063,"afii10042",1064,"afii10043",1065,"afii10044",1066,"afii10045",1067,"afii10046",1068,"afii10047",1069,"afii10048",1070,"afii10049",1071,"afii10050",1168,"afii10051",1026,"afii10052",1027,"afii10053",1028,"afii10054",1029,"afii10055",1030,"afii10056",1031,"afii10057",1032,"afii10058",1033,"afii10059",1034,"afii10060",1035,"afii10061",1036,"afii10062",1038,"afii10063",63172,"afii10064",63173,"afii10065",1072,"afii10066",1073,"afii10067",1074,"afii10068",1075,"afii10069",1076,"afii10070",1077,"afii10071",1105,"afii10072",1078,"afii10073",1079,"afii10074",1080,"afii10075",1081,"afii10076",1082,"afii10077",1083,"afii10078",1084,"afii10079",1085,"afii10080",1086,"afii10081",1087,"afii10082",1088,"afii10083",1089,"afii10084",1090,"afii10085",1091,"afii10086",1092,"afii10087",1093,"afii10088",1094,"afii10089",1095,"afii10090",1096,"afii10091",1097,"afii10092",1098,"afii10093",1099,"afii10094",1100,"afii10095",1101,"afii10096",1102,"afii10097",1103,"afii10098",1169,"afii10099",1106,"afii10100",1107,"afii10101",1108,"afii10102",1109,"afii10103",1110,"afii10104",1111,"afii10105",1112,"afii10106",1113,"afii10107",1114,"afii10108",1115,"afii10109",1116,"afii10110",1118,"afii10145",1039,"afii10146",1122,"afii10147",1138,"afii10148",1140,"afii10192",63174,"afii10193",1119,"afii10194",1123,"afii10195",1139,"afii10196",1141,"afii10831",63175,"afii10832",63176,"afii10846",1241,"afii299",8206,"afii300",8207,"afii301",8205,"afii57381",1642,"afii57388",1548,"afii57392",1632,"afii57393",1633,"afii57394",1634,"afii57395",1635,"afii57396",1636,"afii57397",1637,"afii57398",1638,"afii57399",1639,"afii57400",1640,"afii57401",1641,"afii57403",1563,"afii57407",1567,"afii57409",1569,"afii57410",1570,"afii57411",1571,"afii57412",1572,"afii57413",1573,"afii57414",1574,"afii57415",1575,"afii57416",1576,"afii57417",1577,"afii57418",1578,"afii57419",1579,"afii57420",1580,"afii57421",1581,"afii57422",1582,"afii57423",1583,"afii57424",1584,"afii57425",1585,"afii57426",1586,"afii57427",1587,"afii57428",1588,"afii57429",1589,"afii57430",1590,"afii57431",1591,"afii57432",1592,"afii57433",1593,"afii57434",1594,"afii57440",1600,"afii57441",1601,"afii57442",1602,"afii57443",1603,"afii57444",1604,"afii57445",1605,"afii57446",1606,"afii57448",1608,"afii57449",1609,"afii57450",1610,"afii57451",1611,"afii57452",1612,"afii57453",1613,"afii57454",1614,"afii57455",1615,"afii57456",1616,"afii57457",1617,"afii57458",1618,"afii57470",1607,"afii57505",1700,"afii57506",1662,"afii57507",1670,"afii57508",1688,"afii57509",1711,"afii57511",1657,"afii57512",1672,"afii57513",1681,"afii57514",1722,"afii57519",1746,"afii57534",1749,"afii57636",8362,"afii57645",1470,"afii57658",1475,"afii57664",1488,"afii57665",1489,"afii57666",1490,"afii57667",1491,"afii57668",1492,"afii57669",1493,"afii57670",1494,"afii57671",1495,"afii57672",1496,"afii57673",1497,"afii57674",1498,"afii57675",1499,"afii57676",1500,"afii57677",1501,"afii57678",1502,"afii57679",1503,"afii57680",1504,"afii57681",1505,"afii57682",1506,"afii57683",1507,"afii57684",1508,"afii57685",1509,"afii57686",1510,"afii57687",1511,"afii57688",1512,"afii57689",1513,"afii57690",1514,"afii57694",64298,"afii57695",64299,"afii57700",64331,"afii57705",64287,"afii57716",1520,"afii57717",1521,"afii57718",1522,"afii57723",64309,"afii57793",1460,"afii57794",1461,"afii57795",1462,"afii57796",1467,"afii57797",1464,"afii57798",1463,"afii57799",1456,"afii57800",1458,"afii57801",1457,"afii57802",1459,"afii57803",1474,"afii57804",1473,"afii57806",1465,"afii57807",1468,"afii57839",1469,"afii57841",1471,"afii57842",1472,"afii57929",700,"afii61248",8453,"afii61289",8467,"afii61352",8470,"afii61573",8236,"afii61574",8237,"afii61575",8238,"afii61664",8204,"afii63167",1645,"afii64937",701,"agrave",224,"agujarati",2693,"agurmukhi",2565,"ahiragana",12354,"ahookabove",7843,"aibengali",2448,"aibopomofo",12574,"aideva",2320,"aiecyrillic",1237,"aigujarati",2704,"aigurmukhi",2576,"aimatragurmukhi",2632,"ainarabic",1593,"ainfinalarabic",65226,"aininitialarabic",65227,"ainmedialarabic",65228,"ainvertedbreve",515,"aivowelsignbengali",2504,"aivowelsigndeva",2376,"aivowelsigngujarati",2760,"akatakana",12450,"akatakanahalfwidth",65393,"akorean",12623,"alef",1488,"alefarabic",1575,"alefdageshhebrew",64304,"aleffinalarabic",65166,"alefhamzaabovearabic",1571,"alefhamzaabovefinalarabic",65156,"alefhamzabelowarabic",1573,"alefhamzabelowfinalarabic",65160,"alefhebrew",1488,"aleflamedhebrew",64335,"alefmaddaabovearabic",1570,"alefmaddaabovefinalarabic",65154,"alefmaksuraarabic",1609,"alefmaksurafinalarabic",65264,"alefmaksurainitialarabic",65267,"alefmaksuramedialarabic",65268,"alefpatahhebrew",64302,"alefqamatshebrew",64303,"aleph",8501,"allequal",8780,"alpha",945,"alphatonos",940,"amacron",257,"amonospace",65345,"ampersand",38,"ampersandmonospace",65286,"ampersandsmall",63270,"amsquare",13250,"anbopomofo",12578,"angbopomofo",12580,"angbracketleft",12296,"angbracketright",12297,"angkhankhuthai",3674,"angle",8736,"anglebracketleft",12296,"anglebracketleftvertical",65087,"anglebracketright",12297,"anglebracketrightvertical",65088,"angleleft",9001,"angleright",9002,"angstrom",8491,"anoteleia",903,"anudattadeva",2386,"anusvarabengali",2434,"anusvaradeva",2306,"anusvaragujarati",2690,"aogonek",261,"apaatosquare",13056,"aparen",9372,"apostrophearmenian",1370,"apostrophemod",700,"apple",63743,"approaches",8784,"approxequal",8776,"approxequalorimage",8786,"approximatelyequal",8773,"araeaekorean",12686,"araeakorean",12685,"arc",8978,"arighthalfring",7834,"aring",229,"aringacute",507,"aringbelow",7681,"arrowboth",8596,"arrowdashdown",8675,"arrowdashleft",8672,"arrowdashright",8674,"arrowdashup",8673,"arrowdblboth",8660,"arrowdbldown",8659,"arrowdblleft",8656,"arrowdblright",8658,"arrowdblup",8657,"arrowdown",8595,"arrowdownleft",8601,"arrowdownright",8600,"arrowdownwhite",8681,"arrowheaddownmod",709,"arrowheadleftmod",706,"arrowheadrightmod",707,"arrowheadupmod",708,"arrowhorizex",63719,"arrowleft",8592,"arrowleftdbl",8656,"arrowleftdblstroke",8653,"arrowleftoverright",8646,"arrowleftwhite",8678,"arrowright",8594,"arrowrightdblstroke",8655,"arrowrightheavy",10142,"arrowrightoverleft",8644,"arrowrightwhite",8680,"arrowtableft",8676,"arrowtabright",8677,"arrowup",8593,"arrowupdn",8597,"arrowupdnbse",8616,"arrowupdownbase",8616,"arrowupleft",8598,"arrowupleftofdown",8645,"arrowupright",8599,"arrowupwhite",8679,"arrowvertex",63718,"asciicircum",94,"asciicircummonospace",65342,"asciitilde",126,"asciitildemonospace",65374,"ascript",593,"ascriptturned",594,"asmallhiragana",12353,"asmallkatakana",12449,"asmallkatakanahalfwidth",65383,"asterisk",42,"asteriskaltonearabic",1645,"asteriskarabic",1645,"asteriskmath",8727,"asteriskmonospace",65290,"asterisksmall",65121,"asterism",8258,"asuperior",63209,"asymptoticallyequal",8771,"at",64,"atilde",227,"atmonospace",65312,"atsmall",65131,"aturned",592,"aubengali",2452,"aubopomofo",12576,"audeva",2324,"augujarati",2708,"augurmukhi",2580,"aulengthmarkbengali",2519,"aumatragurmukhi",2636,"auvowelsignbengali",2508,"auvowelsigndeva",2380,"auvowelsigngujarati",2764,"avagrahadeva",2365,"aybarmenian",1377,"ayin",1506,"ayinaltonehebrew",64288,"ayinhebrew",1506,"b",98,"babengali",2476,"backslash",92,"backslashmonospace",65340,"badeva",2348,"bagujarati",2732,"bagurmukhi",2604,"bahiragana",12400,"bahtthai",3647,"bakatakana",12496,"bar",124,"barmonospace",65372,"bbopomofo",12549,"bcircle",9425,"bdotaccent",7683,"bdotbelow",7685,"beamedsixteenthnotes",9836,"because",8757,"becyrillic",1073,"beharabic",1576,"behfinalarabic",65168,"behinitialarabic",65169,"behiragana",12409,"behmedialarabic",65170,"behmeeminitialarabic",64671,"behmeemisolatedarabic",64520,"behnoonfinalarabic",64621,"bekatakana",12505,"benarmenian",1378,"bet",1489,"beta",946,"betasymbolgreek",976,"betdagesh",64305,"betdageshhebrew",64305,"bethebrew",1489,"betrafehebrew",64332,"bhabengali",2477,"bhadeva",2349,"bhagujarati",2733,"bhagurmukhi",2605,"bhook",595,"bihiragana",12403,"bikatakana",12499,"bilabialclick",664,"bindigurmukhi",2562,"birusquare",13105,"blackcircle",9679,"blackdiamond",9670,"blackdownpointingtriangle",9660,"blackleftpointingpointer",9668,"blackleftpointingtriangle",9664,"blacklenticularbracketleft",12304,"blacklenticularbracketleftvertical",65083,"blacklenticularbracketright",12305,"blacklenticularbracketrightvertical",65084,"blacklowerlefttriangle",9699,"blacklowerrighttriangle",9698,"blackrectangle",9644,"blackrightpointingpointer",9658,"blackrightpointingtriangle",9654,"blacksmallsquare",9642,"blacksmilingface",9787,"blacksquare",9632,"blackstar",9733,"blackupperlefttriangle",9700,"blackupperrighttriangle",9701,"blackuppointingsmalltriangle",9652,"blackuppointingtriangle",9650,"blank",9251,"blinebelow",7687,"block",9608,"bmonospace",65346,"bobaimaithai",3610,"bohiragana",12412,"bokatakana",12508,"bparen",9373,"bqsquare",13251,"braceex",63732,"braceleft",123,"braceleftbt",63731,"braceleftmid",63730,"braceleftmonospace",65371,"braceleftsmall",65115,"bracelefttp",63729,"braceleftvertical",65079,"braceright",125,"bracerightbt",63742,"bracerightmid",63741,"bracerightmonospace",65373,"bracerightsmall",65116,"bracerighttp",63740,"bracerightvertical",65080,"bracketleft",91,"bracketleftbt",63728,"bracketleftex",63727,"bracketleftmonospace",65339,"bracketlefttp",63726,"bracketright",93,"bracketrightbt",63739,"bracketrightex",63738,"bracketrightmonospace",65341,"bracketrighttp",63737,"breve",728,"brevebelowcmb",814,"brevecmb",774,"breveinvertedbelowcmb",815,"breveinvertedcmb",785,"breveinverteddoublecmb",865,"bridgebelowcmb",810,"bridgeinvertedbelowcmb",826,"brokenbar",166,"bstroke",384,"bsuperior",63210,"btopbar",387,"buhiragana",12406,"bukatakana",12502,"bullet",8226,"bulletinverse",9688,"bulletoperator",8729,"bullseye",9678,"c",99,"caarmenian",1390,"cabengali",2458,"cacute",263,"cadeva",2330,"cagujarati",2714,"cagurmukhi",2586,"calsquare",13192,"candrabindubengali",2433,"candrabinducmb",784,"candrabindudeva",2305,"candrabindugujarati",2689,"capslock",8682,"careof",8453,"caron",711,"caronbelowcmb",812,"caroncmb",780,"carriagereturn",8629,"cbopomofo",12568,"ccaron",269,"ccedilla",231,"ccedillaacute",7689,"ccircle",9426,"ccircumflex",265,"ccurl",597,"cdot",267,"cdotaccent",267,"cdsquare",13253,"cedilla",184,"cedillacmb",807,"cent",162,"centigrade",8451,"centinferior",63199,"centmonospace",65504,"centoldstyle",63394,"centsuperior",63200,"chaarmenian",1401,"chabengali",2459,"chadeva",2331,"chagujarati",2715,"chagurmukhi",2587,"chbopomofo",12564,"cheabkhasiancyrillic",1213,"checkmark",10003,"checyrillic",1095,"chedescenderabkhasiancyrillic",1215,"chedescendercyrillic",1207,"chedieresiscyrillic",1269,"cheharmenian",1395,"chekhakassiancyrillic",1228,"cheverticalstrokecyrillic",1209,"chi",967,"chieuchacirclekorean",12919,"chieuchaparenkorean",12823,"chieuchcirclekorean",12905,"chieuchkorean",12618,"chieuchparenkorean",12809,"chochangthai",3594,"chochanthai",3592,"chochingthai",3593,"chochoethai",3596,"chook",392,"cieucacirclekorean",12918,"cieucaparenkorean",12822,"cieuccirclekorean",12904,"cieuckorean",12616,"cieucparenkorean",12808,"cieucuparenkorean",12828,"circle",9675,"circlecopyrt",169,"circlemultiply",8855,"circleot",8857,"circleplus",8853,"circlepostalmark",12342,"circlewithlefthalfblack",9680,"circlewithrighthalfblack",9681,"circumflex",710,"circumflexbelowcmb",813,"circumflexcmb",770,"clear",8999,"clickalveolar",450,"clickdental",448,"clicklateral",449,"clickretroflex",451,"club",9827,"clubsuitblack",9827,"clubsuitwhite",9831,"cmcubedsquare",13220,"cmonospace",65347,"cmsquaredsquare",13216,"coarmenian",1409,"colon",58,"colonmonetary",8353,"colonmonospace",65306,"colonsign",8353,"colonsmall",65109,"colontriangularhalfmod",721,"colontriangularmod",720,"comma",44,"commaabovecmb",787,"commaaboverightcmb",789,"commaaccent",63171,"commaarabic",1548,"commaarmenian",1373,"commainferior",63201,"commamonospace",65292,"commareversedabovecmb",788,"commareversedmod",701,"commasmall",65104,"commasuperior",63202,"commaturnedabovecmb",786,"commaturnedmod",699,"compass",9788,"congruent",8773,"contourintegral",8750,"control",8963,"controlACK",6,"controlBEL",7,"controlBS",8,"controlCAN",24,"controlCR",13,"controlDC1",17,"controlDC2",18,"controlDC3",19,"controlDC4",20,"controlDEL",127,"controlDLE",16,"controlEM",25,"controlENQ",5,"controlEOT",4,"controlESC",27,"controlETB",23,"controlETX",3,"controlFF",12,"controlFS",28,"controlGS",29,"controlHT",9,"controlLF",10,"controlNAK",21,"controlNULL",0,"controlRS",30,"controlSI",15,"controlSO",14,"controlSOT",2,"controlSTX",1,"controlSUB",26,"controlSYN",22,"controlUS",31,"controlVT",11,"copyright",169,"copyrightsans",63721,"copyrightserif",63193,"cornerbracketleft",12300,"cornerbracketlefthalfwidth",65378,"cornerbracketleftvertical",65089,"cornerbracketright",12301,"cornerbracketrighthalfwidth",65379,"cornerbracketrightvertical",65090,"corporationsquare",13183,"cosquare",13255,"coverkgsquare",13254,"cparen",9374,"cruzeiro",8354,"cstretched",663,"curlyand",8911,"curlyor",8910,"currency",164,"cyrBreve",63185,"cyrFlex",63186,"cyrbreve",63188,"cyrflex",63189,"d",100,"daarmenian",1380,"dabengali",2470,"dadarabic",1590,"dadeva",2342,"dadfinalarabic",65214,"dadinitialarabic",65215,"dadmedialarabic",65216,"dagesh",1468,"dageshhebrew",1468,"dagger",8224,"daggerdbl",8225,"dagujarati",2726,"dagurmukhi",2598,"dahiragana",12384,"dakatakana",12480,"dalarabic",1583,"dalet",1491,"daletdagesh",64307,"daletdageshhebrew",64307,"dalethebrew",1491,"dalfinalarabic",65194,"dammaarabic",1615,"dammalowarabic",1615,"dammatanaltonearabic",1612,"dammatanarabic",1612,"danda",2404,"dargahebrew",1447,"dargalefthebrew",1447,"dasiapneumatacyrilliccmb",1157,"dblGrave",63187,"dblanglebracketleft",12298,"dblanglebracketleftvertical",65085,"dblanglebracketright",12299,"dblanglebracketrightvertical",65086,"dblarchinvertedbelowcmb",811,"dblarrowleft",8660,"dblarrowright",8658,"dbldanda",2405,"dblgrave",63190,"dblgravecmb",783,"dblintegral",8748,"dbllowline",8215,"dbllowlinecmb",819,"dbloverlinecmb",831,"dblprimemod",698,"dblverticalbar",8214,"dblverticallineabovecmb",782,"dbopomofo",12553,"dbsquare",13256,"dcaron",271,"dcedilla",7697,"dcircle",9427,"dcircumflexbelow",7699,"dcroat",273,"ddabengali",2465,"ddadeva",2337,"ddagujarati",2721,"ddagurmukhi",2593,"ddalarabic",1672,"ddalfinalarabic",64393,"dddhadeva",2396,"ddhabengali",2466,"ddhadeva",2338,"ddhagujarati",2722,"ddhagurmukhi",2594,"ddotaccent",7691,"ddotbelow",7693,"decimalseparatorarabic",1643,"decimalseparatorpersian",1643,"decyrillic",1076,"degree",176,"dehihebrew",1453,"dehiragana",12391,"deicoptic",1007,"dekatakana",12487,"deleteleft",9003,"deleteright",8998,"delta",948,"deltaturned",397,"denominatorminusonenumeratorbengali",2552,"dezh",676,"dhabengali",2471,"dhadeva",2343,"dhagujarati",2727,"dhagurmukhi",2599,"dhook",599,"dialytikatonos",901,"dialytikatonoscmb",836,"diamond",9830,"diamondsuitwhite",9826,"dieresis",168,"dieresisacute",63191,"dieresisbelowcmb",804,"dieresiscmb",776,"dieresisgrave",63192,"dieresistonos",901,"dihiragana",12386,"dikatakana",12482,"dittomark",12291,"divide",247,"divides",8739,"divisionslash",8725,"djecyrillic",1106,"dkshade",9619,"dlinebelow",7695,"dlsquare",13207,"dmacron",273,"dmonospace",65348,"dnblock",9604,"dochadathai",3598,"dodekthai",3604,"dohiragana",12393,"dokatakana",12489,"dollar",36,"dollarinferior",63203,"dollarmonospace",65284,"dollaroldstyle",63268,"dollarsmall",65129,"dollarsuperior",63204,"dong",8363,"dorusquare",13094,"dotaccent",729,"dotaccentcmb",775,"dotbelowcmb",803,"dotbelowcomb",803,"dotkatakana",12539,"dotlessi",305,"dotlessj",63166,"dotlessjstrokehook",644,"dotmath",8901,"dottedcircle",9676,"doubleyodpatah",64287,"doubleyodpatahhebrew",64287,"downtackbelowcmb",798,"downtackmod",725,"dparen",9375,"dsuperior",63211,"dtail",598,"dtopbar",396,"duhiragana",12389,"dukatakana",12485,"dz",499,"dzaltone",675,"dzcaron",454,"dzcurl",677,"dzeabkhasiancyrillic",1249,"dzecyrillic",1109,"dzhecyrillic",1119,"e",101,"eacute",233,"earth",9793,"ebengali",2447,"ebopomofo",12572,"ebreve",277,"ecandradeva",2317,"ecandragujarati",2701,"ecandravowelsigndeva",2373,"ecandravowelsigngujarati",2757,"ecaron",283,"ecedillabreve",7709,"echarmenian",1381,"echyiwnarmenian",1415,"ecircle",9428,"ecircumflex",234,"ecircumflexacute",7871,"ecircumflexbelow",7705,"ecircumflexdotbelow",7879,"ecircumflexgrave",7873,"ecircumflexhookabove",7875,"ecircumflextilde",7877,"ecyrillic",1108,"edblgrave",517,"edeva",2319,"edieresis",235,"edot",279,"edotaccent",279,"edotbelow",7865,"eegurmukhi",2575,"eematragurmukhi",2631,"efcyrillic",1092,"egrave",232,"egujarati",2703,"eharmenian",1383,"ehbopomofo",12573,"ehiragana",12360,"ehookabove",7867,"eibopomofo",12575,"eight",56,"eightarabic",1640,"eightbengali",2542,"eightcircle",9319,"eightcircleinversesansserif",10129,"eightdeva",2414,"eighteencircle",9329,"eighteenparen",9349,"eighteenperiod",9369,"eightgujarati",2798,"eightgurmukhi",2670,"eighthackarabic",1640,"eighthangzhou",12328,"eighthnotebeamed",9835,"eightideographicparen",12839,"eightinferior",8328,"eightmonospace",65304,"eightoldstyle",63288,"eightparen",9339,"eightperiod",9359,"eightpersian",1784,"eightroman",8567,"eightsuperior",8312,"eightthai",3672,"einvertedbreve",519,"eiotifiedcyrillic",1125,"ekatakana",12456,"ekatakanahalfwidth",65396,"ekonkargurmukhi",2676,"ekorean",12628,"elcyrillic",1083,"element",8712,"elevencircle",9322,"elevenparen",9342,"elevenperiod",9362,"elevenroman",8570,"ellipsis",8230,"ellipsisvertical",8942,"emacron",275,"emacronacute",7703,"emacrongrave",7701,"emcyrillic",1084,"emdash",8212,"emdashvertical",65073,"emonospace",65349,"emphasismarkarmenian",1371,"emptyset",8709,"enbopomofo",12579,"encyrillic",1085,"endash",8211,"endashvertical",65074,"endescendercyrillic",1187,"eng",331,"engbopomofo",12581,"enghecyrillic",1189,"enhookcyrillic",1224,"enspace",8194,"eogonek",281,"eokorean",12627,"eopen",603,"eopenclosed",666,"eopenreversed",604,"eopenreversedclosed",606,"eopenreversedhook",605,"eparen",9376,"epsilon",949,"epsilontonos",941,"equal",61,"equalmonospace",65309,"equalsmall",65126,"equalsuperior",8316,"equivalence",8801,"erbopomofo",12582,"ercyrillic",1088,"ereversed",600,"ereversedcyrillic",1101,"escyrillic",1089,"esdescendercyrillic",1195,"esh",643,"eshcurl",646,"eshortdeva",2318,"eshortvowelsigndeva",2374,"eshreversedloop",426,"eshsquatreversed",645,"esmallhiragana",12359,"esmallkatakana",12455,"esmallkatakanahalfwidth",65386,"estimated",8494,"esuperior",63212,"eta",951,"etarmenian",1384,"etatonos",942,"eth",240,"etilde",7869,"etildebelow",7707,"etnahtafoukhhebrew",1425,"etnahtafoukhlefthebrew",1425,"etnahtahebrew",1425,"etnahtalefthebrew",1425,"eturned",477,"eukorean",12641,"euro",8364,"evowelsignbengali",2503,"evowelsigndeva",2375,"evowelsigngujarati",2759,"exclam",33,"exclamarmenian",1372,"exclamdbl",8252,"exclamdown",161,"exclamdownsmall",63393,"exclammonospace",65281,"exclamsmall",63265,"existential",8707,"ezh",658,"ezhcaron",495,"ezhcurl",659,"ezhreversed",441,"ezhtail",442,"f",102,"fadeva",2398,"fagurmukhi",2654,"fahrenheit",8457,"fathaarabic",1614,"fathalowarabic",1614,"fathatanarabic",1611,"fbopomofo",12552,"fcircle",9429,"fdotaccent",7711,"feharabic",1601,"feharmenian",1414,"fehfinalarabic",65234,"fehinitialarabic",65235,"fehmedialarabic",65236,"feicoptic",997,"female",9792,"ff",64256,"f_f",64256,"ffi",64259,"ffl",64260,"fi",64257,"fifteencircle",9326,"fifteenparen",9346,"fifteenperiod",9366,"figuredash",8210,"filledbox",9632,"filledrect",9644,"finalkaf",1498,"finalkafdagesh",64314,"finalkafdageshhebrew",64314,"finalkafhebrew",1498,"finalmem",1501,"finalmemhebrew",1501,"finalnun",1503,"finalnunhebrew",1503,"finalpe",1507,"finalpehebrew",1507,"finaltsadi",1509,"finaltsadihebrew",1509,"firsttonechinese",713,"fisheye",9673,"fitacyrillic",1139,"five",53,"fivearabic",1637,"fivebengali",2539,"fivecircle",9316,"fivecircleinversesansserif",10126,"fivedeva",2411,"fiveeighths",8541,"fivegujarati",2795,"fivegurmukhi",2667,"fivehackarabic",1637,"fivehangzhou",12325,"fiveideographicparen",12836,"fiveinferior",8325,"fivemonospace",65301,"fiveoldstyle",63285,"fiveparen",9336,"fiveperiod",9356,"fivepersian",1781,"fiveroman",8564,"fivesuperior",8309,"fivethai",3669,"fl",64258,"florin",402,"fmonospace",65350,"fmsquare",13209,"fofanthai",3615,"fofathai",3613,"fongmanthai",3663,"forall",8704,"four",52,"fourarabic",1636,"fourbengali",2538,"fourcircle",9315,"fourcircleinversesansserif",10125,"fourdeva",2410,"fourgujarati",2794,"fourgurmukhi",2666,"fourhackarabic",1636,"fourhangzhou",12324,"fourideographicparen",12835,"fourinferior",8324,"fourmonospace",65300,"fournumeratorbengali",2551,"fouroldstyle",63284,"fourparen",9335,"fourperiod",9355,"fourpersian",1780,"fourroman",8563,"foursuperior",8308,"fourteencircle",9325,"fourteenparen",9345,"fourteenperiod",9365,"fourthai",3668,"fourthtonechinese",715,"fparen",9377,"fraction",8260,"franc",8355,"g",103,"gabengali",2455,"gacute",501,"gadeva",2327,"gafarabic",1711,"gaffinalarabic",64403,"gafinitialarabic",64404,"gafmedialarabic",64405,"gagujarati",2711,"gagurmukhi",2583,"gahiragana",12364,"gakatakana",12460,"gamma",947,"gammalatinsmall",611,"gammasuperior",736,"gangiacoptic",1003,"gbopomofo",12557,"gbreve",287,"gcaron",487,"gcedilla",291,"gcircle",9430,"gcircumflex",285,"gcommaaccent",291,"gdot",289,"gdotaccent",289,"gecyrillic",1075,"gehiragana",12370,"gekatakana",12466,"geometricallyequal",8785,"gereshaccenthebrew",1436,"gereshhebrew",1523,"gereshmuqdamhebrew",1437,"germandbls",223,"gershayimaccenthebrew",1438,"gershayimhebrew",1524,"getamark",12307,"ghabengali",2456,"ghadarmenian",1394,"ghadeva",2328,"ghagujarati",2712,"ghagurmukhi",2584,"ghainarabic",1594,"ghainfinalarabic",65230,"ghaininitialarabic",65231,"ghainmedialarabic",65232,"ghemiddlehookcyrillic",1173,"ghestrokecyrillic",1171,"gheupturncyrillic",1169,"ghhadeva",2394,"ghhagurmukhi",2650,"ghook",608,"ghzsquare",13203,"gihiragana",12366,"gikatakana",12462,"gimarmenian",1379,"gimel",1490,"gimeldagesh",64306,"gimeldageshhebrew",64306,"gimelhebrew",1490,"gjecyrillic",1107,"glottalinvertedstroke",446,"glottalstop",660,"glottalstopinverted",662,"glottalstopmod",704,"glottalstopreversed",661,"glottalstopreversedmod",705,"glottalstopreversedsuperior",740,"glottalstopstroke",673,"glottalstopstrokereversed",674,"gmacron",7713,"gmonospace",65351,"gohiragana",12372,"gokatakana",12468,"gparen",9378,"gpasquare",13228,"gradient",8711,"grave",96,"gravebelowcmb",790,"gravecmb",768,"gravecomb",768,"gravedeva",2387,"gravelowmod",718,"gravemonospace",65344,"gravetonecmb",832,"greater",62,"greaterequal",8805,"greaterequalorless",8923,"greatermonospace",65310,"greaterorequivalent",8819,"greaterorless",8823,"greateroverequal",8807,"greatersmall",65125,"gscript",609,"gstroke",485,"guhiragana",12368,"guillemotleft",171,"guillemotright",187,"guilsinglleft",8249,"guilsinglright",8250,"gukatakana",12464,"guramusquare",13080,"gysquare",13257,"h",104,"haabkhasiancyrillic",1193,"haaltonearabic",1729,"habengali",2489,"hadescendercyrillic",1203,"hadeva",2361,"hagujarati",2745,"hagurmukhi",2617,"haharabic",1581,"hahfinalarabic",65186,"hahinitialarabic",65187,"hahiragana",12399,"hahmedialarabic",65188,"haitusquare",13098,"hakatakana",12495,"hakatakanahalfwidth",65418,"halantgurmukhi",2637,"hamzaarabic",1569,"hamzalowarabic",1569,"hangulfiller",12644,"hardsigncyrillic",1098,"harpoonleftbarbup",8636,"harpoonrightbarbup",8640,"hasquare",13258,"hatafpatah",1458,"hatafpatah16",1458,"hatafpatah23",1458,"hatafpatah2f",1458,"hatafpatahhebrew",1458,"hatafpatahnarrowhebrew",1458,"hatafpatahquarterhebrew",1458,"hatafpatahwidehebrew",1458,"hatafqamats",1459,"hatafqamats1b",1459,"hatafqamats28",1459,"hatafqamats34",1459,"hatafqamatshebrew",1459,"hatafqamatsnarrowhebrew",1459,"hatafqamatsquarterhebrew",1459,"hatafqamatswidehebrew",1459,"hatafsegol",1457,"hatafsegol17",1457,"hatafsegol24",1457,"hatafsegol30",1457,"hatafsegolhebrew",1457,"hatafsegolnarrowhebrew",1457,"hatafsegolquarterhebrew",1457,"hatafsegolwidehebrew",1457,"hbar",295,"hbopomofo",12559,"hbrevebelow",7723,"hcedilla",7721,"hcircle",9431,"hcircumflex",293,"hdieresis",7719,"hdotaccent",7715,"hdotbelow",7717,"he",1492,"heart",9829,"heartsuitblack",9829,"heartsuitwhite",9825,"hedagesh",64308,"hedageshhebrew",64308,"hehaltonearabic",1729,"heharabic",1607,"hehebrew",1492,"hehfinalaltonearabic",64423,"hehfinalalttwoarabic",65258,"hehfinalarabic",65258,"hehhamzaabovefinalarabic",64421,"hehhamzaaboveisolatedarabic",64420,"hehinitialaltonearabic",64424,"hehinitialarabic",65259,"hehiragana",12408,"hehmedialaltonearabic",64425,"hehmedialarabic",65260,"heiseierasquare",13179,"hekatakana",12504,"hekatakanahalfwidth",65421,"hekutaarusquare",13110,"henghook",615,"herutusquare",13113,"het",1495,"hethebrew",1495,"hhook",614,"hhooksuperior",689,"hieuhacirclekorean",12923,"hieuhaparenkorean",12827,"hieuhcirclekorean",12909,"hieuhkorean",12622,"hieuhparenkorean",12813,"hihiragana",12402,"hikatakana",12498,"hikatakanahalfwidth",65419,"hiriq",1460,"hiriq14",1460,"hiriq21",1460,"hiriq2d",1460,"hiriqhebrew",1460,"hiriqnarrowhebrew",1460,"hiriqquarterhebrew",1460,"hiriqwidehebrew",1460,"hlinebelow",7830,"hmonospace",65352,"hoarmenian",1392,"hohipthai",3627,"hohiragana",12411,"hokatakana",12507,"hokatakanahalfwidth",65422,"holam",1465,"holam19",1465,"holam26",1465,"holam32",1465,"holamhebrew",1465,"holamnarrowhebrew",1465,"holamquarterhebrew",1465,"holamwidehebrew",1465,"honokhukthai",3630,"hookabovecomb",777,"hookcmb",777,"hookpalatalizedbelowcmb",801,"hookretroflexbelowcmb",802,"hoonsquare",13122,"horicoptic",1001,"horizontalbar",8213,"horncmb",795,"hotsprings",9832,"house",8962,"hparen",9379,"hsuperior",688,"hturned",613,"huhiragana",12405,"huiitosquare",13107,"hukatakana",12501,"hukatakanahalfwidth",65420,"hungarumlaut",733,"hungarumlautcmb",779,"hv",405,"hyphen",45,"hypheninferior",63205,"hyphenmonospace",65293,"hyphensmall",65123,"hyphensuperior",63206,"hyphentwo",8208,"i",105,"iacute",237,"iacyrillic",1103,"ibengali",2439,"ibopomofo",12583,"ibreve",301,"icaron",464,"icircle",9432,"icircumflex",238,"icyrillic",1110,"idblgrave",521,"ideographearthcircle",12943,"ideographfirecircle",12939,"ideographicallianceparen",12863,"ideographiccallparen",12858,"ideographiccentrecircle",12965,"ideographicclose",12294,"ideographiccomma",12289,"ideographiccommaleft",65380,"ideographiccongratulationparen",12855,"ideographiccorrectcircle",12963,"ideographicearthparen",12847,"ideographicenterpriseparen",12861,"ideographicexcellentcircle",12957,"ideographicfestivalparen",12864,"ideographicfinancialcircle",12950,"ideographicfinancialparen",12854,"ideographicfireparen",12843,"ideographichaveparen",12850,"ideographichighcircle",12964,"ideographiciterationmark",12293,"ideographiclaborcircle",12952,"ideographiclaborparen",12856,"ideographicleftcircle",12967,"ideographiclowcircle",12966,"ideographicmedicinecircle",12969,"ideographicmetalparen",12846,"ideographicmoonparen",12842,"ideographicnameparen",12852,"ideographicperiod",12290,"ideographicprintcircle",12958,"ideographicreachparen",12867,"ideographicrepresentparen",12857,"ideographicresourceparen",12862,"ideographicrightcircle",12968,"ideographicsecretcircle",12953,"ideographicselfparen",12866,"ideographicsocietyparen",12851,"ideographicspace",12288,"ideographicspecialparen",12853,"ideographicstockparen",12849,"ideographicstudyparen",12859,"ideographicsunparen",12848,"ideographicsuperviseparen",12860,"ideographicwaterparen",12844,"ideographicwoodparen",12845,"ideographiczero",12295,"ideographmetalcircle",12942,"ideographmooncircle",12938,"ideographnamecircle",12948,"ideographsuncircle",12944,"ideographwatercircle",12940,"ideographwoodcircle",12941,"ideva",2311,"idieresis",239,"idieresisacute",7727,"idieresiscyrillic",1253,"idotbelow",7883,"iebrevecyrillic",1239,"iecyrillic",1077,"ieungacirclekorean",12917,"ieungaparenkorean",12821,"ieungcirclekorean",12903,"ieungkorean",12615,"ieungparenkorean",12807,"igrave",236,"igujarati",2695,"igurmukhi",2567,"ihiragana",12356,"ihookabove",7881,"iibengali",2440,"iicyrillic",1080,"iideva",2312,"iigujarati",2696,"iigurmukhi",2568,"iimatragurmukhi",2624,"iinvertedbreve",523,"iishortcyrillic",1081,"iivowelsignbengali",2496,"iivowelsigndeva",2368,"iivowelsigngujarati",2752,"ij",307,"ikatakana",12452,"ikatakanahalfwidth",65394,"ikorean",12643,"ilde",732,"iluyhebrew",1452,"imacron",299,"imacroncyrillic",1251,"imageorapproximatelyequal",8787,"imatragurmukhi",2623,"imonospace",65353,"increment",8710,"infinity",8734,"iniarmenian",1387,"integral",8747,"integralbottom",8993,"integralbt",8993,"integralex",63733,"integraltop",8992,"integraltp",8992,"intersection",8745,"intisquare",13061,"invbullet",9688,"invcircle",9689,"invsmileface",9787,"iocyrillic",1105,"iogonek",303,"iota",953,"iotadieresis",970,"iotadieresistonos",912,"iotalatin",617,"iotatonos",943,"iparen",9380,"irigurmukhi",2674,"ismallhiragana",12355,"ismallkatakana",12451,"ismallkatakanahalfwidth",65384,"issharbengali",2554,"istroke",616,"isuperior",63213,"iterationhiragana",12445,"iterationkatakana",12541,"itilde",297,"itildebelow",7725,"iubopomofo",12585,"iucyrillic",1102,"ivowelsignbengali",2495,"ivowelsigndeva",2367,"ivowelsigngujarati",2751,"izhitsacyrillic",1141,"izhitsadblgravecyrillic",1143,"j",106,"jaarmenian",1393,"jabengali",2460,"jadeva",2332,"jagujarati",2716,"jagurmukhi",2588,"jbopomofo",12560,"jcaron",496,"jcircle",9433,"jcircumflex",309,"jcrossedtail",669,"jdotlessstroke",607,"jecyrillic",1112,"jeemarabic",1580,"jeemfinalarabic",65182,"jeeminitialarabic",65183,"jeemmedialarabic",65184,"jeharabic",1688,"jehfinalarabic",64395,"jhabengali",2461,"jhadeva",2333,"jhagujarati",2717,"jhagurmukhi",2589,"jheharmenian",1403,"jis",12292,"jmonospace",65354,"jparen",9381,"jsuperior",690,"k",107,"kabashkircyrillic",1185,"kabengali",2453,"kacute",7729,"kacyrillic",1082,"kadescendercyrillic",1179,"kadeva",2325,"kaf",1499,"kafarabic",1603,"kafdagesh",64315,"kafdageshhebrew",64315,"kaffinalarabic",65242,"kafhebrew",1499,"kafinitialarabic",65243,"kafmedialarabic",65244,"kafrafehebrew",64333,"kagujarati",2709,"kagurmukhi",2581,"kahiragana",12363,"kahookcyrillic",1220,"kakatakana",12459,"kakatakanahalfwidth",65398,"kappa",954,"kappasymbolgreek",1008,"kapyeounmieumkorean",12657,"kapyeounphieuphkorean",12676,"kapyeounpieupkorean",12664,"kapyeounssangpieupkorean",12665,"karoriisquare",13069,"kashidaautoarabic",1600,"kashidaautonosidebearingarabic",1600,"kasmallkatakana",12533,"kasquare",13188,"kasraarabic",1616,"kasratanarabic",1613,"kastrokecyrillic",1183,"katahiraprolongmarkhalfwidth",65392,"kaverticalstrokecyrillic",1181,"kbopomofo",12558,"kcalsquare",13193,"kcaron",489,"kcedilla",311,"kcircle",9434,"kcommaaccent",311,"kdotbelow",7731,"keharmenian",1412,"kehiragana",12369,"kekatakana",12465,"kekatakanahalfwidth",65401,"kenarmenian",1391,"kesmallkatakana",12534,"kgreenlandic",312,"khabengali",2454,"khacyrillic",1093,"khadeva",2326,"khagujarati",2710,"khagurmukhi",2582,"khaharabic",1582,"khahfinalarabic",65190,"khahinitialarabic",65191,"khahmedialarabic",65192,"kheicoptic",999,"khhadeva",2393,"khhagurmukhi",2649,"khieukhacirclekorean",12920,"khieukhaparenkorean",12824,"khieukhcirclekorean",12906,"khieukhkorean",12619,"khieukhparenkorean",12810,"khokhaithai",3586,"khokhonthai",3589,"khokhuatthai",3587,"khokhwaithai",3588,"khomutthai",3675,"khook",409,"khorakhangthai",3590,"khzsquare",13201,"kihiragana",12365,"kikatakana",12461,"kikatakanahalfwidth",65399,"kiroguramusquare",13077,"kiromeetorusquare",13078,"kirosquare",13076,"kiyeokacirclekorean",12910,"kiyeokaparenkorean",12814,"kiyeokcirclekorean",12896,"kiyeokkorean",12593,"kiyeokparenkorean",12800,"kiyeoksioskorean",12595,"kjecyrillic",1116,"klinebelow",7733,"klsquare",13208,"kmcubedsquare",13222,"kmonospace",65355,"kmsquaredsquare",13218,"kohiragana",12371,"kohmsquare",13248,"kokaithai",3585,"kokatakana",12467,"kokatakanahalfwidth",65402,"kooposquare",13086,"koppacyrillic",1153,"koreanstandardsymbol",12927,"koroniscmb",835,"kparen",9382,"kpasquare",13226,"ksicyrillic",1135,"ktsquare",13263,"kturned",670,"kuhiragana",12367,"kukatakana",12463,"kukatakanahalfwidth",65400,"kvsquare",13240,"kwsquare",13246,"l",108,"labengali",2482,"lacute",314,"ladeva",2354,"lagujarati",2738,"lagurmukhi",2610,"lakkhangyaothai",3653,"lamaleffinalarabic",65276,"lamalefhamzaabovefinalarabic",65272,"lamalefhamzaaboveisolatedarabic",65271,"lamalefhamzabelowfinalarabic",65274,"lamalefhamzabelowisolatedarabic",65273,"lamalefisolatedarabic",65275,"lamalefmaddaabovefinalarabic",65270,"lamalefmaddaaboveisolatedarabic",65269,"lamarabic",1604,"lambda",955,"lambdastroke",411,"lamed",1500,"lameddagesh",64316,"lameddageshhebrew",64316,"lamedhebrew",1500,"lamfinalarabic",65246,"lamhahinitialarabic",64714,"laminitialarabic",65247,"lamjeeminitialarabic",64713,"lamkhahinitialarabic",64715,"lamlamhehisolatedarabic",65010,"lammedialarabic",65248,"lammeemhahinitialarabic",64904,"lammeeminitialarabic",64716,"largecircle",9711,"lbar",410,"lbelt",620,"lbopomofo",12556,"lcaron",318,"lcedilla",316,"lcircle",9435,"lcircumflexbelow",7741,"lcommaaccent",316,"ldot",320,"ldotaccent",320,"ldotbelow",7735,"ldotbelowmacron",7737,"leftangleabovecmb",794,"lefttackbelowcmb",792,"less",60,"lessequal",8804,"lessequalorgreater",8922,"lessmonospace",65308,"lessorequivalent",8818,"lessorgreater",8822,"lessoverequal",8806,"lesssmall",65124,"lezh",622,"lfblock",9612,"lhookretroflex",621,"lira",8356,"liwnarmenian",1388,"lj",457,"ljecyrillic",1113,"ll",63168,"lladeva",2355,"llagujarati",2739,"llinebelow",7739,"llladeva",2356,"llvocalicbengali",2529,"llvocalicdeva",2401,"llvocalicvowelsignbengali",2531,"llvocalicvowelsigndeva",2403,"lmiddletilde",619,"lmonospace",65356,"lmsquare",13264,"lochulathai",3628,"logicaland",8743,"logicalnot",172,"logicalnotreversed",8976,"logicalor",8744,"lolingthai",3621,"longs",383,"lowlinecenterline",65102,"lowlinecmb",818,"lowlinedashed",65101,"lozenge",9674,"lparen",9383,"lslash",322,"lsquare",8467,"lsuperior",63214,"ltshade",9617,"luthai",3622,"lvocalicbengali",2444,"lvocalicdeva",2316,"lvocalicvowelsignbengali",2530,"lvocalicvowelsigndeva",2402,"lxsquare",13267,"m",109,"mabengali",2478,"macron",175,"macronbelowcmb",817,"macroncmb",772,"macronlowmod",717,"macronmonospace",65507,"macute",7743,"madeva",2350,"magujarati",2734,"magurmukhi",2606,"mahapakhhebrew",1444,"mahapakhlefthebrew",1444,"mahiragana",12414,"maichattawalowleftthai",63637,"maichattawalowrightthai",63636,"maichattawathai",3659,"maichattawaupperleftthai",63635,"maieklowleftthai",63628,"maieklowrightthai",63627,"maiekthai",3656,"maiekupperleftthai",63626,"maihanakatleftthai",63620,"maihanakatthai",3633,"maitaikhuleftthai",63625,"maitaikhuthai",3655,"maitholowleftthai",63631,"maitholowrightthai",63630,"maithothai",3657,"maithoupperleftthai",63629,"maitrilowleftthai",63634,"maitrilowrightthai",63633,"maitrithai",3658,"maitriupperleftthai",63632,"maiyamokthai",3654,"makatakana",12510,"makatakanahalfwidth",65423,"male",9794,"mansyonsquare",13127,"maqafhebrew",1470,"mars",9794,"masoracirclehebrew",1455,"masquare",13187,"mbopomofo",12551,"mbsquare",13268,"mcircle",9436,"mcubedsquare",13221,"mdotaccent",7745,"mdotbelow",7747,"meemarabic",1605,"meemfinalarabic",65250,"meeminitialarabic",65251,"meemmedialarabic",65252,"meemmeeminitialarabic",64721,"meemmeemisolatedarabic",64584,"meetorusquare",13133,"mehiragana",12417,"meizierasquare",13182,"mekatakana",12513,"mekatakanahalfwidth",65426,"mem",1502,"memdagesh",64318,"memdageshhebrew",64318,"memhebrew",1502,"menarmenian",1396,"merkhahebrew",1445,"merkhakefulahebrew",1446,"merkhakefulalefthebrew",1446,"merkhalefthebrew",1445,"mhook",625,"mhzsquare",13202,"middledotkatakanahalfwidth",65381,"middot",183,"mieumacirclekorean",12914,"mieumaparenkorean",12818,"mieumcirclekorean",12900,"mieumkorean",12609,"mieumpansioskorean",12656,"mieumparenkorean",12804,"mieumpieupkorean",12654,"mieumsioskorean",12655,"mihiragana",12415,"mikatakana",12511,"mikatakanahalfwidth",65424,"minus",8722,"minusbelowcmb",800,"minuscircle",8854,"minusmod",727,"minusplus",8723,"minute",8242,"miribaarusquare",13130,"mirisquare",13129,"mlonglegturned",624,"mlsquare",13206,"mmcubedsquare",13219,"mmonospace",65357,"mmsquaredsquare",13215,"mohiragana",12418,"mohmsquare",13249,"mokatakana",12514,"mokatakanahalfwidth",65427,"molsquare",13270,"momathai",3617,"moverssquare",13223,"moverssquaredsquare",13224,"mparen",9384,"mpasquare",13227,"mssquare",13235,"msuperior",63215,"mturned",623,"mu",181,"mu1",181,"muasquare",13186,"muchgreater",8811,"muchless",8810,"mufsquare",13196,"mugreek",956,"mugsquare",13197,"muhiragana",12416,"mukatakana",12512,"mukatakanahalfwidth",65425,"mulsquare",13205,"multiply",215,"mumsquare",13211,"munahhebrew",1443,"munahlefthebrew",1443,"musicalnote",9834,"musicalnotedbl",9835,"musicflatsign",9837,"musicsharpsign",9839,"mussquare",13234,"muvsquare",13238,"muwsquare",13244,"mvmegasquare",13241,"mvsquare",13239,"mwmegasquare",13247,"mwsquare",13245,"n",110,"nabengali",2472,"nabla",8711,"nacute",324,"nadeva",2344,"nagujarati",2728,"nagurmukhi",2600,"nahiragana",12394,"nakatakana",12490,"nakatakanahalfwidth",65413,"napostrophe",329,"nasquare",13185,"nbopomofo",12555,"nbspace",160,"ncaron",328,"ncedilla",326,"ncircle",9437,"ncircumflexbelow",7755,"ncommaaccent",326,"ndotaccent",7749,"ndotbelow",7751,"nehiragana",12397,"nekatakana",12493,"nekatakanahalfwidth",65416,"newsheqelsign",8362,"nfsquare",13195,"ngabengali",2457,"ngadeva",2329,"ngagujarati",2713,"ngagurmukhi",2585,"ngonguthai",3591,"nhiragana",12435,"nhookleft",626,"nhookretroflex",627,"nieunacirclekorean",12911,"nieunaparenkorean",12815,"nieuncieuckorean",12597,"nieuncirclekorean",12897,"nieunhieuhkorean",12598,"nieunkorean",12596,"nieunpansioskorean",12648,"nieunparenkorean",12801,"nieunsioskorean",12647,"nieuntikeutkorean",12646,"nihiragana",12395,"nikatakana",12491,"nikatakanahalfwidth",65414,"nikhahitleftthai",63641,"nikhahitthai",3661,"nine",57,"ninearabic",1641,"ninebengali",2543,"ninecircle",9320,"ninecircleinversesansserif",10130,"ninedeva",2415,"ninegujarati",2799,"ninegurmukhi",2671,"ninehackarabic",1641,"ninehangzhou",12329,"nineideographicparen",12840,"nineinferior",8329,"ninemonospace",65305,"nineoldstyle",63289,"nineparen",9340,"nineperiod",9360,"ninepersian",1785,"nineroman",8568,"ninesuperior",8313,"nineteencircle",9330,"nineteenparen",9350,"nineteenperiod",9370,"ninethai",3673,"nj",460,"njecyrillic",1114,"nkatakana",12531,"nkatakanahalfwidth",65437,"nlegrightlong",414,"nlinebelow",7753,"nmonospace",65358,"nmsquare",13210,"nnabengali",2467,"nnadeva",2339,"nnagujarati",2723,"nnagurmukhi",2595,"nnnadeva",2345,"nohiragana",12398,"nokatakana",12494,"nokatakanahalfwidth",65417,"nonbreakingspace",160,"nonenthai",3603,"nonuthai",3609,"noonarabic",1606,"noonfinalarabic",65254,"noonghunnaarabic",1722,"noonghunnafinalarabic",64415,"nooninitialarabic",65255,"noonjeeminitialarabic",64722,"noonjeemisolatedarabic",64587,"noonmedialarabic",65256,"noonmeeminitialarabic",64725,"noonmeemisolatedarabic",64590,"noonnoonfinalarabic",64653,"notcontains",8716,"notelement",8713,"notelementof",8713,"notequal",8800,"notgreater",8815,"notgreaternorequal",8817,"notgreaternorless",8825,"notidentical",8802,"notless",8814,"notlessnorequal",8816,"notparallel",8742,"notprecedes",8832,"notsubset",8836,"notsucceeds",8833,"notsuperset",8837,"nowarmenian",1398,"nparen",9385,"nssquare",13233,"nsuperior",8319,"ntilde",241,"nu",957,"nuhiragana",12396,"nukatakana",12492,"nukatakanahalfwidth",65415,"nuktabengali",2492,"nuktadeva",2364,"nuktagujarati",2748,"nuktagurmukhi",2620,"numbersign",35,"numbersignmonospace",65283,"numbersignsmall",65119,"numeralsigngreek",884,"numeralsignlowergreek",885,"numero",8470,"nun",1504,"nundagesh",64320,"nundageshhebrew",64320,"nunhebrew",1504,"nvsquare",13237,"nwsquare",13243,"nyabengali",2462,"nyadeva",2334,"nyagujarati",2718,"nyagurmukhi",2590,"o",111,"oacute",243,"oangthai",3629,"obarred",629,"obarredcyrillic",1257,"obarreddieresiscyrillic",1259,"obengali",2451,"obopomofo",12571,"obreve",335,"ocandradeva",2321,"ocandragujarati",2705,"ocandravowelsigndeva",2377,"ocandravowelsigngujarati",2761,"ocaron",466,"ocircle",9438,"ocircumflex",244,"ocircumflexacute",7889,"ocircumflexdotbelow",7897,"ocircumflexgrave",7891,"ocircumflexhookabove",7893,"ocircumflextilde",7895,"ocyrillic",1086,"odblacute",337,"odblgrave",525,"odeva",2323,"odieresis",246,"odieresiscyrillic",1255,"odotbelow",7885,"oe",339,"oekorean",12634,"ogonek",731,"ogonekcmb",808,"ograve",242,"ogujarati",2707,"oharmenian",1413,"ohiragana",12362,"ohookabove",7887,"ohorn",417,"ohornacute",7899,"ohorndotbelow",7907,"ohorngrave",7901,"ohornhookabove",7903,"ohorntilde",7905,"ohungarumlaut",337,"oi",419,"oinvertedbreve",527,"okatakana",12458,"okatakanahalfwidth",65397,"okorean",12631,"olehebrew",1451,"omacron",333,"omacronacute",7763,"omacrongrave",7761,"omdeva",2384,"omega",969,"omega1",982,"omegacyrillic",1121,"omegalatinclosed",631,"omegaroundcyrillic",1147,"omegatitlocyrillic",1149,"omegatonos",974,"omgujarati",2768,"omicron",959,"omicrontonos",972,"omonospace",65359,"one",49,"onearabic",1633,"onebengali",2535,"onecircle",9312,"onecircleinversesansserif",10122,"onedeva",2407,"onedotenleader",8228,"oneeighth",8539,"onefitted",63196,"onegujarati",2791,"onegurmukhi",2663,"onehackarabic",1633,"onehalf",189,"onehangzhou",12321,"oneideographicparen",12832,"oneinferior",8321,"onemonospace",65297,"onenumeratorbengali",2548,"oneoldstyle",63281,"oneparen",9332,"oneperiod",9352,"onepersian",1777,"onequarter",188,"oneroman",8560,"onesuperior",185,"onethai",3665,"onethird",8531,"oogonek",491,"oogonekmacron",493,"oogurmukhi",2579,"oomatragurmukhi",2635,"oopen",596,"oparen",9386,"openbullet",9702,"option",8997,"ordfeminine",170,"ordmasculine",186,"orthogonal",8735,"oshortdeva",2322,"oshortvowelsigndeva",2378,"oslash",248,"oslashacute",511,"osmallhiragana",12361,"osmallkatakana",12457,"osmallkatakanahalfwidth",65387,"ostrokeacute",511,"osuperior",63216,"otcyrillic",1151,"otilde",245,"otildeacute",7757,"otildedieresis",7759,"oubopomofo",12577,"overline",8254,"overlinecenterline",65098,"overlinecmb",773,"overlinedashed",65097,"overlinedblwavy",65100,"overlinewavy",65099,"overscore",175,"ovowelsignbengali",2507,"ovowelsigndeva",2379,"ovowelsigngujarati",2763,"p",112,"paampssquare",13184,"paasentosquare",13099,"pabengali",2474,"pacute",7765,"padeva",2346,"pagedown",8671,"pageup",8670,"pagujarati",2730,"pagurmukhi",2602,"pahiragana",12401,"paiyannoithai",3631,"pakatakana",12497,"palatalizationcyrilliccmb",1156,"palochkacyrillic",1216,"pansioskorean",12671,"paragraph",182,"parallel",8741,"parenleft",40,"parenleftaltonearabic",64830,"parenleftbt",63725,"parenleftex",63724,"parenleftinferior",8333,"parenleftmonospace",65288,"parenleftsmall",65113,"parenleftsuperior",8317,"parenlefttp",63723,"parenleftvertical",65077,"parenright",41,"parenrightaltonearabic",64831,"parenrightbt",63736,"parenrightex",63735,"parenrightinferior",8334,"parenrightmonospace",65289,"parenrightsmall",65114,"parenrightsuperior",8318,"parenrighttp",63734,"parenrightvertical",65078,"partialdiff",8706,"paseqhebrew",1472,"pashtahebrew",1433,"pasquare",13225,"patah",1463,"patah11",1463,"patah1d",1463,"patah2a",1463,"patahhebrew",1463,"patahnarrowhebrew",1463,"patahquarterhebrew",1463,"patahwidehebrew",1463,"pazerhebrew",1441,"pbopomofo",12550,"pcircle",9439,"pdotaccent",7767,"pe",1508,"pecyrillic",1087,"pedagesh",64324,"pedageshhebrew",64324,"peezisquare",13115,"pefinaldageshhebrew",64323,"peharabic",1662,"peharmenian",1402,"pehebrew",1508,"pehfinalarabic",64343,"pehinitialarabic",64344,"pehiragana",12410,"pehmedialarabic",64345,"pekatakana",12506,"pemiddlehookcyrillic",1191,"perafehebrew",64334,"percent",37,"percentarabic",1642,"percentmonospace",65285,"percentsmall",65130,"period",46,"periodarmenian",1417,"periodcentered",183,"periodhalfwidth",65377,"periodinferior",63207,"periodmonospace",65294,"periodsmall",65106,"periodsuperior",63208,"perispomenigreekcmb",834,"perpendicular",8869,"perthousand",8240,"peseta",8359,"pfsquare",13194,"phabengali",2475,"phadeva",2347,"phagujarati",2731,"phagurmukhi",2603,"phi",966,"phi1",981,"phieuphacirclekorean",12922,"phieuphaparenkorean",12826,"phieuphcirclekorean",12908,"phieuphkorean",12621,"phieuphparenkorean",12812,"philatin",632,"phinthuthai",3642,"phisymbolgreek",981,"phook",421,"phophanthai",3614,"phophungthai",3612,"phosamphaothai",3616,"pi",960,"pieupacirclekorean",12915,"pieupaparenkorean",12819,"pieupcieuckorean",12662,"pieupcirclekorean",12901,"pieupkiyeokkorean",12658,"pieupkorean",12610,"pieupparenkorean",12805,"pieupsioskiyeokkorean",12660,"pieupsioskorean",12612,"pieupsiostikeutkorean",12661,"pieupthieuthkorean",12663,"pieuptikeutkorean",12659,"pihiragana",12404,"pikatakana",12500,"pisymbolgreek",982,"piwrarmenian",1411,"plus",43,"plusbelowcmb",799,"pluscircle",8853,"plusminus",177,"plusmod",726,"plusmonospace",65291,"plussmall",65122,"plussuperior",8314,"pmonospace",65360,"pmsquare",13272,"pohiragana",12413,"pointingindexdownwhite",9759,"pointingindexleftwhite",9756,"pointingindexrightwhite",9758,"pointingindexupwhite",9757,"pokatakana",12509,"poplathai",3611,"postalmark",12306,"postalmarkface",12320,"pparen",9387,"precedes",8826,"prescription",8478,"primemod",697,"primereversed",8245,"product",8719,"projective",8965,"prolongedkana",12540,"propellor",8984,"propersubset",8834,"propersuperset",8835,"proportion",8759,"proportional",8733,"psi",968,"psicyrillic",1137,"psilipneumatacyrilliccmb",1158,"pssquare",13232,"puhiragana",12407,"pukatakana",12503,"pvsquare",13236,"pwsquare",13242,"q",113,"qadeva",2392,"qadmahebrew",1448,"qafarabic",1602,"qaffinalarabic",65238,"qafinitialarabic",65239,"qafmedialarabic",65240,"qamats",1464,"qamats10",1464,"qamats1a",1464,"qamats1c",1464,"qamats27",1464,"qamats29",1464,"qamats33",1464,"qamatsde",1464,"qamatshebrew",1464,"qamatsnarrowhebrew",1464,"qamatsqatanhebrew",1464,"qamatsqatannarrowhebrew",1464,"qamatsqatanquarterhebrew",1464,"qamatsqatanwidehebrew",1464,"qamatsquarterhebrew",1464,"qamatswidehebrew",1464,"qarneyparahebrew",1439,"qbopomofo",12561,"qcircle",9440,"qhook",672,"qmonospace",65361,"qof",1511,"qofdagesh",64327,"qofdageshhebrew",64327,"qofhebrew",1511,"qparen",9388,"quarternote",9833,"qubuts",1467,"qubuts18",1467,"qubuts25",1467,"qubuts31",1467,"qubutshebrew",1467,"qubutsnarrowhebrew",1467,"qubutsquarterhebrew",1467,"qubutswidehebrew",1467,"question",63,"questionarabic",1567,"questionarmenian",1374,"questiondown",191,"questiondownsmall",63423,"questiongreek",894,"questionmonospace",65311,"questionsmall",63295,"quotedbl",34,"quotedblbase",8222,"quotedblleft",8220,"quotedblmonospace",65282,"quotedblprime",12318,"quotedblprimereversed",12317,"quotedblright",8221,"quoteleft",8216,"quoteleftreversed",8219,"quotereversed",8219,"quoteright",8217,"quoterightn",329,"quotesinglbase",8218,"quotesingle",39,"quotesinglemonospace",65287,"r",114,"raarmenian",1404,"rabengali",2480,"racute",341,"radeva",2352,"radical",8730,"radicalex",63717,"radoverssquare",13230,"radoverssquaredsquare",13231,"radsquare",13229,"rafe",1471,"rafehebrew",1471,"ragujarati",2736,"ragurmukhi",2608,"rahiragana",12425,"rakatakana",12521,"rakatakanahalfwidth",65431,"ralowerdiagonalbengali",2545,"ramiddlediagonalbengali",2544,"ramshorn",612,"ratio",8758,"rbopomofo",12566,"rcaron",345,"rcedilla",343,"rcircle",9441,"rcommaaccent",343,"rdblgrave",529,"rdotaccent",7769,"rdotbelow",7771,"rdotbelowmacron",7773,"referencemark",8251,"reflexsubset",8838,"reflexsuperset",8839,"registered",174,"registersans",63720,"registerserif",63194,"reharabic",1585,"reharmenian",1408,"rehfinalarabic",65198,"rehiragana",12428,"rekatakana",12524,"rekatakanahalfwidth",65434,"resh",1512,"reshdageshhebrew",64328,"reshhebrew",1512,"reversedtilde",8765,"reviahebrew",1431,"reviamugrashhebrew",1431,"revlogicalnot",8976,"rfishhook",638,"rfishhookreversed",639,"rhabengali",2525,"rhadeva",2397,"rho",961,"rhook",637,"rhookturned",635,"rhookturnedsuperior",693,"rhosymbolgreek",1009,"rhotichookmod",734,"rieulacirclekorean",12913,"rieulaparenkorean",12817,"rieulcirclekorean",12899,"rieulhieuhkorean",12608,"rieulkiyeokkorean",12602,"rieulkiyeoksioskorean",12649,"rieulkorean",12601,"rieulmieumkorean",12603,"rieulpansioskorean",12652,"rieulparenkorean",12803,"rieulphieuphkorean",12607,"rieulpieupkorean",12604,"rieulpieupsioskorean",12651,"rieulsioskorean",12605,"rieulthieuthkorean",12606,"rieultikeutkorean",12650,"rieulyeorinhieuhkorean",12653,"rightangle",8735,"righttackbelowcmb",793,"righttriangle",8895,"rihiragana",12426,"rikatakana",12522,"rikatakanahalfwidth",65432,"ring",730,"ringbelowcmb",805,"ringcmb",778,"ringhalfleft",703,"ringhalfleftarmenian",1369,"ringhalfleftbelowcmb",796,"ringhalfleftcentered",723,"ringhalfright",702,"ringhalfrightbelowcmb",825,"ringhalfrightcentered",722,"rinvertedbreve",531,"rittorusquare",13137,"rlinebelow",7775,"rlongleg",636,"rlonglegturned",634,"rmonospace",65362,"rohiragana",12429,"rokatakana",12525,"rokatakanahalfwidth",65435,"roruathai",3619,"rparen",9389,"rrabengali",2524,"rradeva",2353,"rragurmukhi",2652,"rreharabic",1681,"rrehfinalarabic",64397,"rrvocalicbengali",2528,"rrvocalicdeva",2400,"rrvocalicgujarati",2784,"rrvocalicvowelsignbengali",2500,"rrvocalicvowelsigndeva",2372,"rrvocalicvowelsigngujarati",2756,"rsuperior",63217,"rtblock",9616,"rturned",633,"rturnedsuperior",692,"ruhiragana",12427,"rukatakana",12523,"rukatakanahalfwidth",65433,"rupeemarkbengali",2546,"rupeesignbengali",2547,"rupiah",63197,"ruthai",3620,"rvocalicbengali",2443,"rvocalicdeva",2315,"rvocalicgujarati",2699,"rvocalicvowelsignbengali",2499,"rvocalicvowelsigndeva",2371,"rvocalicvowelsigngujarati",2755,"s",115,"sabengali",2488,"sacute",347,"sacutedotaccent",7781,"sadarabic",1589,"sadeva",2360,"sadfinalarabic",65210,"sadinitialarabic",65211,"sadmedialarabic",65212,"sagujarati",2744,"sagurmukhi",2616,"sahiragana",12373,"sakatakana",12469,"sakatakanahalfwidth",65403,"sallallahoualayhewasallamarabic",65018,"samekh",1505,"samekhdagesh",64321,"samekhdageshhebrew",64321,"samekhhebrew",1505,"saraaathai",3634,"saraaethai",3649,"saraaimaimalaithai",3652,"saraaimaimuanthai",3651,"saraamthai",3635,"saraathai",3632,"saraethai",3648,"saraiileftthai",63622,"saraiithai",3637,"saraileftthai",63621,"saraithai",3636,"saraothai",3650,"saraueeleftthai",63624,"saraueethai",3639,"saraueleftthai",63623,"sarauethai",3638,"sarauthai",3640,"sarauuthai",3641,"sbopomofo",12569,"scaron",353,"scarondotaccent",7783,"scedilla",351,"schwa",601,"schwacyrillic",1241,"schwadieresiscyrillic",1243,"schwahook",602,"scircle",9442,"scircumflex",349,"scommaaccent",537,"sdotaccent",7777,"sdotbelow",7779,"sdotbelowdotaccent",7785,"seagullbelowcmb",828,"second",8243,"secondtonechinese",714,"section",167,"seenarabic",1587,"seenfinalarabic",65202,"seeninitialarabic",65203,"seenmedialarabic",65204,"segol",1462,"segol13",1462,"segol1f",1462,"segol2c",1462,"segolhebrew",1462,"segolnarrowhebrew",1462,"segolquarterhebrew",1462,"segoltahebrew",1426,"segolwidehebrew",1462,"seharmenian",1405,"sehiragana",12379,"sekatakana",12475,"sekatakanahalfwidth",65406,"semicolon",59,"semicolonarabic",1563,"semicolonmonospace",65307,"semicolonsmall",65108,"semivoicedmarkkana",12444,"semivoicedmarkkanahalfwidth",65439,"sentisquare",13090,"sentosquare",13091,"seven",55,"sevenarabic",1639,"sevenbengali",2541,"sevencircle",9318,"sevencircleinversesansserif",10128,"sevendeva",2413,"seveneighths",8542,"sevengujarati",2797,"sevengurmukhi",2669,"sevenhackarabic",1639,"sevenhangzhou",12327,"sevenideographicparen",12838,"seveninferior",8327,"sevenmonospace",65303,"sevenoldstyle",63287,"sevenparen",9338,"sevenperiod",9358,"sevenpersian",1783,"sevenroman",8566,"sevensuperior",8311,"seventeencircle",9328,"seventeenparen",9348,"seventeenperiod",9368,"seventhai",3671,"sfthyphen",173,"shaarmenian",1399,"shabengali",2486,"shacyrillic",1096,"shaddaarabic",1617,"shaddadammaarabic",64609,"shaddadammatanarabic",64606,"shaddafathaarabic",64608,"shaddakasraarabic",64610,"shaddakasratanarabic",64607,"shade",9618,"shadedark",9619,"shadelight",9617,"shademedium",9618,"shadeva",2358,"shagujarati",2742,"shagurmukhi",2614,"shalshelethebrew",1427,"shbopomofo",12565,"shchacyrillic",1097,"sheenarabic",1588,"sheenfinalarabic",65206,"sheeninitialarabic",65207,"sheenmedialarabic",65208,"sheicoptic",995,"sheqel",8362,"sheqelhebrew",8362,"sheva",1456,"sheva115",1456,"sheva15",1456,"sheva22",1456,"sheva2e",1456,"shevahebrew",1456,"shevanarrowhebrew",1456,"shevaquarterhebrew",1456,"shevawidehebrew",1456,"shhacyrillic",1211,"shimacoptic",1005,"shin",1513,"shindagesh",64329,"shindageshhebrew",64329,"shindageshshindot",64300,"shindageshshindothebrew",64300,"shindageshsindot",64301,"shindageshsindothebrew",64301,"shindothebrew",1473,"shinhebrew",1513,"shinshindot",64298,"shinshindothebrew",64298,"shinsindot",64299,"shinsindothebrew",64299,"shook",642,"sigma",963,"sigma1",962,"sigmafinal",962,"sigmalunatesymbolgreek",1010,"sihiragana",12375,"sikatakana",12471,"sikatakanahalfwidth",65404,"siluqhebrew",1469,"siluqlefthebrew",1469,"similar",8764,"sindothebrew",1474,"siosacirclekorean",12916,"siosaparenkorean",12820,"sioscieuckorean",12670,"sioscirclekorean",12902,"sioskiyeokkorean",12666,"sioskorean",12613,"siosnieunkorean",12667,"siosparenkorean",12806,"siospieupkorean",12669,"siostikeutkorean",12668,"six",54,"sixarabic",1638,"sixbengali",2540,"sixcircle",9317,"sixcircleinversesansserif",10127,"sixdeva",2412,"sixgujarati",2796,"sixgurmukhi",2668,"sixhackarabic",1638,"sixhangzhou",12326,"sixideographicparen",12837,"sixinferior",8326,"sixmonospace",65302,"sixoldstyle",63286,"sixparen",9337,"sixperiod",9357,"sixpersian",1782,"sixroman",8565,"sixsuperior",8310,"sixteencircle",9327,"sixteencurrencydenominatorbengali",2553,"sixteenparen",9347,"sixteenperiod",9367,"sixthai",3670,"slash",47,"slashmonospace",65295,"slong",383,"slongdotaccent",7835,"smileface",9786,"smonospace",65363,"sofpasuqhebrew",1475,"softhyphen",173,"softsigncyrillic",1100,"sohiragana",12381,"sokatakana",12477,"sokatakanahalfwidth",65407,"soliduslongoverlaycmb",824,"solidusshortoverlaycmb",823,"sorusithai",3625,"sosalathai",3624,"sosothai",3595,"sosuathai",3626,"space",32,"spacehackarabic",32,"spade",9824,"spadesuitblack",9824,"spadesuitwhite",9828,"sparen",9390,"squarebelowcmb",827,"squarecc",13252,"squarecm",13213,"squarediagonalcrosshatchfill",9641,"squarehorizontalfill",9636,"squarekg",13199,"squarekm",13214,"squarekmcapital",13262,"squareln",13265,"squarelog",13266,"squaremg",13198,"squaremil",13269,"squaremm",13212,"squaremsquared",13217,"squareorthogonalcrosshatchfill",9638,"squareupperlefttolowerrightfill",9639,"squareupperrighttolowerleftfill",9640,"squareverticalfill",9637,"squarewhitewithsmallblack",9635,"srsquare",13275,"ssabengali",2487,"ssadeva",2359,"ssagujarati",2743,"ssangcieuckorean",12617,"ssanghieuhkorean",12677,"ssangieungkorean",12672,"ssangkiyeokkorean",12594,"ssangnieunkorean",12645,"ssangpieupkorean",12611,"ssangsioskorean",12614,"ssangtikeutkorean",12600,"ssuperior",63218,"sterling",163,"sterlingmonospace",65505,"strokelongoverlaycmb",822,"strokeshortoverlaycmb",821,"subset",8834,"subsetnotequal",8842,"subsetorequal",8838,"succeeds",8827,"suchthat",8715,"suhiragana",12377,"sukatakana",12473,"sukatakanahalfwidth",65405,"sukunarabic",1618,"summation",8721,"sun",9788,"superset",8835,"supersetnotequal",8843,"supersetorequal",8839,"svsquare",13276,"syouwaerasquare",13180,"t",116,"tabengali",2468,"tackdown",8868,"tackleft",8867,"tadeva",2340,"tagujarati",2724,"tagurmukhi",2596,"taharabic",1591,"tahfinalarabic",65218,"tahinitialarabic",65219,"tahiragana",12383,"tahmedialarabic",65220,"taisyouerasquare",13181,"takatakana",12479,"takatakanahalfwidth",65408,"tatweelarabic",1600,"tau",964,"tav",1514,"tavdages",64330,"tavdagesh",64330,"tavdageshhebrew",64330,"tavhebrew",1514,"tbar",359,"tbopomofo",12554,"tcaron",357,"tccurl",680,"tcedilla",355,"tcheharabic",1670,"tchehfinalarabic",64379,"tchehinitialarabic",64380,"tchehmedialarabic",64381,"tcircle",9443,"tcircumflexbelow",7793,"tcommaaccent",355,"tdieresis",7831,"tdotaccent",7787,"tdotbelow",7789,"tecyrillic",1090,"tedescendercyrillic",1197,"teharabic",1578,"tehfinalarabic",65174,"tehhahinitialarabic",64674,"tehhahisolatedarabic",64524,"tehinitialarabic",65175,"tehiragana",12390,"tehjeeminitialarabic",64673,"tehjeemisolatedarabic",64523,"tehmarbutaarabic",1577,"tehmarbutafinalarabic",65172,"tehmedialarabic",65176,"tehmeeminitialarabic",64676,"tehmeemisolatedarabic",64526,"tehnoonfinalarabic",64627,"tekatakana",12486,"tekatakanahalfwidth",65411,"telephone",8481,"telephoneblack",9742,"telishagedolahebrew",1440,"telishaqetanahebrew",1449,"tencircle",9321,"tenideographicparen",12841,"tenparen",9341,"tenperiod",9361,"tenroman",8569,"tesh",679,"tet",1496,"tetdagesh",64312,"tetdageshhebrew",64312,"tethebrew",1496,"tetsecyrillic",1205,"tevirhebrew",1435,"tevirlefthebrew",1435,"thabengali",2469,"thadeva",2341,"thagujarati",2725,"thagurmukhi",2597,"thalarabic",1584,"thalfinalarabic",65196,"thanthakhatlowleftthai",63640,"thanthakhatlowrightthai",63639,"thanthakhatthai",3660,"thanthakhatupperleftthai",63638,"theharabic",1579,"thehfinalarabic",65178,"thehinitialarabic",65179,"thehmedialarabic",65180,"thereexists",8707,"therefore",8756,"theta",952,"theta1",977,"thetasymbolgreek",977,"thieuthacirclekorean",12921,"thieuthaparenkorean",12825,"thieuthcirclekorean",12907,"thieuthkorean",12620,"thieuthparenkorean",12811,"thirteencircle",9324,"thirteenparen",9344,"thirteenperiod",9364,"thonangmonthothai",3601,"thook",429,"thophuthaothai",3602,"thorn",254,"thothahanthai",3607,"thothanthai",3600,"thothongthai",3608,"thothungthai",3606,"thousandcyrillic",1154,"thousandsseparatorarabic",1644,"thousandsseparatorpersian",1644,"three",51,"threearabic",1635,"threebengali",2537,"threecircle",9314,"threecircleinversesansserif",10124,"threedeva",2409,"threeeighths",8540,"threegujarati",2793,"threegurmukhi",2665,"threehackarabic",1635,"threehangzhou",12323,"threeideographicparen",12834,"threeinferior",8323,"threemonospace",65299,"threenumeratorbengali",2550,"threeoldstyle",63283,"threeparen",9334,"threeperiod",9354,"threepersian",1779,"threequarters",190,"threequartersemdash",63198,"threeroman",8562,"threesuperior",179,"threethai",3667,"thzsquare",13204,"tihiragana",12385,"tikatakana",12481,"tikatakanahalfwidth",65409,"tikeutacirclekorean",12912,"tikeutaparenkorean",12816,"tikeutcirclekorean",12898,"tikeutkorean",12599,"tikeutparenkorean",12802,"tilde",732,"tildebelowcmb",816,"tildecmb",771,"tildecomb",771,"tildedoublecmb",864,"tildeoperator",8764,"tildeoverlaycmb",820,"tildeverticalcmb",830,"timescircle",8855,"tipehahebrew",1430,"tipehalefthebrew",1430,"tippigurmukhi",2672,"titlocyrilliccmb",1155,"tiwnarmenian",1407,"tlinebelow",7791,"tmonospace",65364,"toarmenian",1385,"tohiragana",12392,"tokatakana",12488,"tokatakanahalfwidth",65412,"tonebarextrahighmod",741,"tonebarextralowmod",745,"tonebarhighmod",742,"tonebarlowmod",744,"tonebarmidmod",743,"tonefive",445,"tonesix",389,"tonetwo",424,"tonos",900,"tonsquare",13095,"topatakthai",3599,"tortoiseshellbracketleft",12308,"tortoiseshellbracketleftsmall",65117,"tortoiseshellbracketleftvertical",65081,"tortoiseshellbracketright",12309,"tortoiseshellbracketrightsmall",65118,"tortoiseshellbracketrightvertical",65082,"totaothai",3605,"tpalatalhook",427,"tparen",9391,"trademark",8482,"trademarksans",63722,"trademarkserif",63195,"tretroflexhook",648,"triagdn",9660,"triaglf",9668,"triagrt",9658,"triagup",9650,"ts",678,"tsadi",1510,"tsadidagesh",64326,"tsadidageshhebrew",64326,"tsadihebrew",1510,"tsecyrillic",1094,"tsere",1461,"tsere12",1461,"tsere1e",1461,"tsere2b",1461,"tserehebrew",1461,"tserenarrowhebrew",1461,"tserequarterhebrew",1461,"tserewidehebrew",1461,"tshecyrillic",1115,"tsuperior",63219,"ttabengali",2463,"ttadeva",2335,"ttagujarati",2719,"ttagurmukhi",2591,"tteharabic",1657,"ttehfinalarabic",64359,"ttehinitialarabic",64360,"ttehmedialarabic",64361,"tthabengali",2464,"tthadeva",2336,"tthagujarati",2720,"tthagurmukhi",2592,"tturned",647,"tuhiragana",12388,"tukatakana",12484,"tukatakanahalfwidth",65410,"tusmallhiragana",12387,"tusmallkatakana",12483,"tusmallkatakanahalfwidth",65391,"twelvecircle",9323,"twelveparen",9343,"twelveperiod",9363,"twelveroman",8571,"twentycircle",9331,"twentyhangzhou",21316,"twentyparen",9351,"twentyperiod",9371,"two",50,"twoarabic",1634,"twobengali",2536,"twocircle",9313,"twocircleinversesansserif",10123,"twodeva",2408,"twodotenleader",8229,"twodotleader",8229,"twodotleadervertical",65072,"twogujarati",2792,"twogurmukhi",2664,"twohackarabic",1634,"twohangzhou",12322,"twoideographicparen",12833,"twoinferior",8322,"twomonospace",65298,"twonumeratorbengali",2549,"twooldstyle",63282,"twoparen",9333,"twoperiod",9353,"twopersian",1778,"tworoman",8561,"twostroke",443,"twosuperior",178,"twothai",3666,"twothirds",8532,"u",117,"uacute",250,"ubar",649,"ubengali",2441,"ubopomofo",12584,"ubreve",365,"ucaron",468,"ucircle",9444,"ucircumflex",251,"ucircumflexbelow",7799,"ucyrillic",1091,"udattadeva",2385,"udblacute",369,"udblgrave",533,"udeva",2313,"udieresis",252,"udieresisacute",472,"udieresisbelow",7795,"udieresiscaron",474,"udieresiscyrillic",1265,"udieresisgrave",476,"udieresismacron",470,"udotbelow",7909,"ugrave",249,"ugujarati",2697,"ugurmukhi",2569,"uhiragana",12358,"uhookabove",7911,"uhorn",432,"uhornacute",7913,"uhorndotbelow",7921,"uhorngrave",7915,"uhornhookabove",7917,"uhorntilde",7919,"uhungarumlaut",369,"uhungarumlautcyrillic",1267,"uinvertedbreve",535,"ukatakana",12454,"ukatakanahalfwidth",65395,"ukcyrillic",1145,"ukorean",12636,"umacron",363,"umacroncyrillic",1263,"umacrondieresis",7803,"umatragurmukhi",2625,"umonospace",65365,"underscore",95,"underscoredbl",8215,"underscoremonospace",65343,"underscorevertical",65075,"underscorewavy",65103,"union",8746,"universal",8704,"uogonek",371,"uparen",9392,"upblock",9600,"upperdothebrew",1476,"upsilon",965,"upsilondieresis",971,"upsilondieresistonos",944,"upsilonlatin",650,"upsilontonos",973,"uptackbelowcmb",797,"uptackmod",724,"uragurmukhi",2675,"uring",367,"ushortcyrillic",1118,"usmallhiragana",12357,"usmallkatakana",12453,"usmallkatakanahalfwidth",65385,"ustraightcyrillic",1199,"ustraightstrokecyrillic",1201,"utilde",361,"utildeacute",7801,"utildebelow",7797,"uubengali",2442,"uudeva",2314,"uugujarati",2698,"uugurmukhi",2570,"uumatragurmukhi",2626,"uuvowelsignbengali",2498,"uuvowelsigndeva",2370,"uuvowelsigngujarati",2754,"uvowelsignbengali",2497,"uvowelsigndeva",2369,"uvowelsigngujarati",2753,"v",118,"vadeva",2357,"vagujarati",2741,"vagurmukhi",2613,"vakatakana",12535,"vav",1493,"vavdagesh",64309,"vavdagesh65",64309,"vavdageshhebrew",64309,"vavhebrew",1493,"vavholam",64331,"vavholamhebrew",64331,"vavvavhebrew",1520,"vavyodhebrew",1521,"vcircle",9445,"vdotbelow",7807,"vecyrillic",1074,"veharabic",1700,"vehfinalarabic",64363,"vehinitialarabic",64364,"vehmedialarabic",64365,"vekatakana",12537,"venus",9792,"verticalbar",124,"verticallineabovecmb",781,"verticallinebelowcmb",809,"verticallinelowmod",716,"verticallinemod",712,"vewarmenian",1406,"vhook",651,"vikatakana",12536,"viramabengali",2509,"viramadeva",2381,"viramagujarati",2765,"visargabengali",2435,"visargadeva",2307,"visargagujarati",2691,"vmonospace",65366,"voarmenian",1400,"voicediterationhiragana",12446,"voicediterationkatakana",12542,"voicedmarkkana",12443,"voicedmarkkanahalfwidth",65438,"vokatakana",12538,"vparen",9393,"vtilde",7805,"vturned",652,"vuhiragana",12436,"vukatakana",12532,"w",119,"wacute",7811,"waekorean",12633,"wahiragana",12431,"wakatakana",12527,"wakatakanahalfwidth",65436,"wakorean",12632,"wasmallhiragana",12430,"wasmallkatakana",12526,"wattosquare",13143,"wavedash",12316,"wavyunderscorevertical",65076,"wawarabic",1608,"wawfinalarabic",65262,"wawhamzaabovearabic",1572,"wawhamzaabovefinalarabic",65158,"wbsquare",13277,"wcircle",9446,"wcircumflex",373,"wdieresis",7813,"wdotaccent",7815,"wdotbelow",7817,"wehiragana",12433,"weierstrass",8472,"wekatakana",12529,"wekorean",12638,"weokorean",12637,"wgrave",7809,"whitebullet",9702,"whitecircle",9675,"whitecircleinverse",9689,"whitecornerbracketleft",12302,"whitecornerbracketleftvertical",65091,"whitecornerbracketright",12303,"whitecornerbracketrightvertical",65092,"whitediamond",9671,"whitediamondcontainingblacksmalldiamond",9672,"whitedownpointingsmalltriangle",9663,"whitedownpointingtriangle",9661,"whiteleftpointingsmalltriangle",9667,"whiteleftpointingtriangle",9665,"whitelenticularbracketleft",12310,"whitelenticularbracketright",12311,"whiterightpointingsmalltriangle",9657,"whiterightpointingtriangle",9655,"whitesmallsquare",9643,"whitesmilingface",9786,"whitesquare",9633,"whitestar",9734,"whitetelephone",9743,"whitetortoiseshellbracketleft",12312,"whitetortoiseshellbracketright",12313,"whiteuppointingsmalltriangle",9653,"whiteuppointingtriangle",9651,"wihiragana",12432,"wikatakana",12528,"wikorean",12639,"wmonospace",65367,"wohiragana",12434,"wokatakana",12530,"wokatakanahalfwidth",65382,"won",8361,"wonmonospace",65510,"wowaenthai",3623,"wparen",9394,"wring",7832,"wsuperior",695,"wturned",653,"wynn",447,"x",120,"xabovecmb",829,"xbopomofo",12562,"xcircle",9447,"xdieresis",7821,"xdotaccent",7819,"xeharmenian",1389,"xi",958,"xmonospace",65368,"xparen",9395,"xsuperior",739,"y",121,"yaadosquare",13134,"yabengali",2479,"yacute",253,"yadeva",2351,"yaekorean",12626,"yagujarati",2735,"yagurmukhi",2607,"yahiragana",12420,"yakatakana",12516,"yakatakanahalfwidth",65428,"yakorean",12625,"yamakkanthai",3662,"yasmallhiragana",12419,"yasmallkatakana",12515,"yasmallkatakanahalfwidth",65388,"yatcyrillic",1123,"ycircle",9448,"ycircumflex",375,"ydieresis",255,"ydotaccent",7823,"ydotbelow",7925,"yeharabic",1610,"yehbarreearabic",1746,"yehbarreefinalarabic",64431,"yehfinalarabic",65266,"yehhamzaabovearabic",1574,"yehhamzaabovefinalarabic",65162,"yehhamzaaboveinitialarabic",65163,"yehhamzaabovemedialarabic",65164,"yehinitialarabic",65267,"yehmedialarabic",65268,"yehmeeminitialarabic",64733,"yehmeemisolatedarabic",64600,"yehnoonfinalarabic",64660,"yehthreedotsbelowarabic",1745,"yekorean",12630,"yen",165,"yenmonospace",65509,"yeokorean",12629,"yeorinhieuhkorean",12678,"yerahbenyomohebrew",1450,"yerahbenyomolefthebrew",1450,"yericyrillic",1099,"yerudieresiscyrillic",1273,"yesieungkorean",12673,"yesieungpansioskorean",12675,"yesieungsioskorean",12674,"yetivhebrew",1434,"ygrave",7923,"yhook",436,"yhookabove",7927,"yiarmenian",1397,"yicyrillic",1111,"yikorean",12642,"yinyang",9775,"yiwnarmenian",1410,"ymonospace",65369,"yod",1497,"yoddagesh",64313,"yoddageshhebrew",64313,"yodhebrew",1497,"yodyodhebrew",1522,"yodyodpatahhebrew",64287,"yohiragana",12424,"yoikorean",12681,"yokatakana",12520,"yokatakanahalfwidth",65430,"yokorean",12635,"yosmallhiragana",12423,"yosmallkatakana",12519,"yosmallkatakanahalfwidth",65390,"yotgreek",1011,"yoyaekorean",12680,"yoyakorean",12679,"yoyakthai",3618,"yoyingthai",3597,"yparen",9396,"ypogegrammeni",890,"ypogegrammenigreekcmb",837,"yr",422,"yring",7833,"ysuperior",696,"ytilde",7929,"yturned",654,"yuhiragana",12422,"yuikorean",12684,"yukatakana",12518,"yukatakanahalfwidth",65429,"yukorean",12640,"yusbigcyrillic",1131,"yusbigiotifiedcyrillic",1133,"yuslittlecyrillic",1127,"yuslittleiotifiedcyrillic",1129,"yusmallhiragana",12421,"yusmallkatakana",12517,"yusmallkatakanahalfwidth",65389,"yuyekorean",12683,"yuyeokorean",12682,"yyabengali",2527,"yyadeva",2399,"z",122,"zaarmenian",1382,"zacute",378,"zadeva",2395,"zagurmukhi",2651,"zaharabic",1592,"zahfinalarabic",65222,"zahinitialarabic",65223,"zahiragana",12374,"zahmedialarabic",65224,"zainarabic",1586,"zainfinalarabic",65200,"zakatakana",12470,"zaqefgadolhebrew",1429,"zaqefqatanhebrew",1428,"zarqahebrew",1432,"zayin",1494,"zayindagesh",64310,"zayindageshhebrew",64310,"zayinhebrew",1494,"zbopomofo",12567,"zcaron",382,"zcircle",9449,"zcircumflex",7825,"zcurl",657,"zdot",380,"zdotaccent",380,"zdotbelow",7827,"zecyrillic",1079,"zedescendercyrillic",1177,"zedieresiscyrillic",1247,"zehiragana",12380,"zekatakana",12476,"zero",48,"zeroarabic",1632,"zerobengali",2534,"zerodeva",2406,"zerogujarati",2790,"zerogurmukhi",2662,"zerohackarabic",1632,"zeroinferior",8320,"zeromonospace",65296,"zerooldstyle",63280,"zeropersian",1776,"zerosuperior",8304,"zerothai",3664,"zerowidthjoiner",65279,"zerowidthnonjoiner",8204,"zerowidthspace",8203,"zeta",950,"zhbopomofo",12563,"zhearmenian",1386,"zhebrevecyrillic",1218,"zhecyrillic",1078,"zhedescendercyrillic",1175,"zhedieresiscyrillic",1245,"zihiragana",12376,"zikatakana",12472,"zinorhebrew",1454,"zlinebelow",7829,"zmonospace",65370,"zohiragana",12382,"zokatakana",12478,"zparen",9397,"zretroflexhook",656,"zstroke",438,"zuhiragana",12378,"zukatakana",12474,".notdef",0,"angbracketleftbig",9001,"angbracketleftBig",9001,"angbracketleftbigg",9001,"angbracketleftBigg",9001,"angbracketrightBig",9002,"angbracketrightbig",9002,"angbracketrightBigg",9002,"angbracketrightbigg",9002,"arrowhookleft",8618,"arrowhookright",8617,"arrowlefttophalf",8636,"arrowleftbothalf",8637,"arrownortheast",8599,"arrownorthwest",8598,"arrowrighttophalf",8640,"arrowrightbothalf",8641,"arrowsoutheast",8600,"arrowsouthwest",8601,"backslashbig",8726,"backslashBig",8726,"backslashBigg",8726,"backslashbigg",8726,"bardbl",8214,"bracehtipdownleft",65079,"bracehtipdownright",65079,"bracehtipupleft",65080,"bracehtipupright",65080,"braceleftBig",123,"braceleftbig",123,"braceleftbigg",123,"braceleftBigg",123,"bracerightBig",125,"bracerightbig",125,"bracerightbigg",125,"bracerightBigg",125,"bracketleftbig",91,"bracketleftBig",91,"bracketleftbigg",91,"bracketleftBigg",91,"bracketrightBig",93,"bracketrightbig",93,"bracketrightbigg",93,"bracketrightBigg",93,"ceilingleftbig",8968,"ceilingleftBig",8968,"ceilingleftBigg",8968,"ceilingleftbigg",8968,"ceilingrightbig",8969,"ceilingrightBig",8969,"ceilingrightbigg",8969,"ceilingrightBigg",8969,"circledotdisplay",8857,"circledottext",8857,"circlemultiplydisplay",8855,"circlemultiplytext",8855,"circleplusdisplay",8853,"circleplustext",8853,"contintegraldisplay",8750,"contintegraltext",8750,"coproductdisplay",8720,"coproducttext",8720,"floorleftBig",8970,"floorleftbig",8970,"floorleftbigg",8970,"floorleftBigg",8970,"floorrightbig",8971,"floorrightBig",8971,"floorrightBigg",8971,"floorrightbigg",8971,"hatwide",770,"hatwider",770,"hatwidest",770,"intercal",7488,"integraldisplay",8747,"integraltext",8747,"intersectiondisplay",8898,"intersectiontext",8898,"logicalanddisplay",8743,"logicalandtext",8743,"logicalordisplay",8744,"logicalortext",8744,"parenleftBig",40,"parenleftbig",40,"parenleftBigg",40,"parenleftbigg",40,"parenrightBig",41,"parenrightbig",41,"parenrightBigg",41,"parenrightbigg",41,"prime",8242,"productdisplay",8719,"producttext",8719,"radicalbig",8730,"radicalBig",8730,"radicalBigg",8730,"radicalbigg",8730,"radicalbt",8730,"radicaltp",8730,"radicalvertex",8730,"slashbig",47,"slashBig",47,"slashBigg",47,"slashbigg",47,"summationdisplay",8721,"summationtext",8721,"tildewide",732,"tildewider",732,"tildewidest",732,"uniondisplay",8899,"unionmultidisplay",8846,"unionmultitext",8846,"unionsqdisplay",8852,"unionsqtext",8852,"uniontext",8899,"vextenddouble",8741,"vextendsingle",8739]})),n=(0,a.getArrayLookupTableFactory)((function(){return["space",32,"a1",9985,"a2",9986,"a202",9987,"a3",9988,"a4",9742,"a5",9990,"a119",9991,"a118",9992,"a117",9993,"a11",9755,"a12",9758,"a13",9996,"a14",9997,"a15",9998,"a16",9999,"a105",1e4,"a17",10001,"a18",10002,"a19",10003,"a20",10004,"a21",10005,"a22",10006,"a23",10007,"a24",10008,"a25",10009,"a26",10010,"a27",10011,"a28",10012,"a6",10013,"a7",10014,"a8",10015,"a9",10016,"a10",10017,"a29",10018,"a30",10019,"a31",10020,"a32",10021,"a33",10022,"a34",10023,"a35",9733,"a36",10025,"a37",10026,"a38",10027,"a39",10028,"a40",10029,"a41",10030,"a42",10031,"a43",10032,"a44",10033,"a45",10034,"a46",10035,"a47",10036,"a48",10037,"a49",10038,"a50",10039,"a51",10040,"a52",10041,"a53",10042,"a54",10043,"a55",10044,"a56",10045,"a57",10046,"a58",10047,"a59",10048,"a60",10049,"a61",10050,"a62",10051,"a63",10052,"a64",10053,"a65",10054,"a66",10055,"a67",10056,"a68",10057,"a69",10058,"a70",10059,"a71",9679,"a72",10061,"a73",9632,"a74",10063,"a203",10064,"a75",10065,"a204",10066,"a76",9650,"a77",9660,"a78",9670,"a79",10070,"a81",9687,"a82",10072,"a83",10073,"a84",10074,"a97",10075,"a98",10076,"a99",10077,"a100",10078,"a101",10081,"a102",10082,"a103",10083,"a104",10084,"a106",10085,"a107",10086,"a108",10087,"a112",9827,"a111",9830,"a110",9829,"a109",9824,"a120",9312,"a121",9313,"a122",9314,"a123",9315,"a124",9316,"a125",9317,"a126",9318,"a127",9319,"a128",9320,"a129",9321,"a130",10102,"a131",10103,"a132",10104,"a133",10105,"a134",10106,"a135",10107,"a136",10108,"a137",10109,"a138",10110,"a139",10111,"a140",10112,"a141",10113,"a142",10114,"a143",10115,"a144",10116,"a145",10117,"a146",10118,"a147",10119,"a148",10120,"a149",10121,"a150",10122,"a151",10123,"a152",10124,"a153",10125,"a154",10126,"a155",10127,"a156",10128,"a157",10129,"a158",10130,"a159",10131,"a160",10132,"a161",8594,"a163",8596,"a164",8597,"a196",10136,"a165",10137,"a192",10138,"a166",10139,"a167",10140,"a168",10141,"a169",10142,"a170",10143,"a171",10144,"a172",10145,"a173",10146,"a162",10147,"a174",10148,"a175",10149,"a176",10150,"a177",10151,"a178",10152,"a179",10153,"a193",10154,"a180",10155,"a199",10156,"a181",10157,"a200",10158,"a182",10159,"a201",10161,"a183",10162,"a184",10163,"a197",10164,"a185",10165,"a194",10166,"a198",10167,"a186",10168,"a195",10169,"a187",10170,"a188",10171,"a189",10172,"a190",10173,"a191",10174,"a89",10088,"a90",10089,"a93",10090,"a94",10091,"a91",10092,"a92",10093,"a205",10094,"a85",10095,"a206",10096,"a86",10097,"a87",10098,"a88",10099,"a95",10100,"a96",10101,".notdef",0]}))},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getSymbolsFonts=t.getSupplementalGlyphMapForCalibri=t.getSupplementalGlyphMapForArialBlack=t.getStdFontMap=t.getSerifFonts=t.getNonStdFontMap=t.getGlyphMapForStandardFonts=void 0;var a=r(8);const i=(0,a.getLookupTableFactory)((function(e){e.ArialNarrow="Helvetica",e["ArialNarrow-Bold"]="Helvetica-Bold",e["ArialNarrow-BoldItalic"]="Helvetica-BoldOblique",e["ArialNarrow-Italic"]="Helvetica-Oblique",e.ArialBlack="Helvetica",e["ArialBlack-Bold"]="Helvetica-Bold",e["ArialBlack-BoldItalic"]="Helvetica-BoldOblique",e["ArialBlack-Italic"]="Helvetica-Oblique",e["Arial-Black"]="Helvetica",e["Arial-Black-Bold"]="Helvetica-Bold",e["Arial-Black-BoldItalic"]="Helvetica-BoldOblique",e["Arial-Black-Italic"]="Helvetica-Oblique",e.Arial="Helvetica",e["Arial-Bold"]="Helvetica-Bold",e["Arial-BoldItalic"]="Helvetica-BoldOblique",e["Arial-Italic"]="Helvetica-Oblique",e["Arial-BoldItalicMT"]="Helvetica-BoldOblique",e["Arial-BoldMT"]="Helvetica-Bold",e["Arial-ItalicMT"]="Helvetica-Oblique",e.ArialMT="Helvetica",e["Courier-Bold"]="Courier-Bold",e["Courier-BoldItalic"]="Courier-BoldOblique",e["Courier-Italic"]="Courier-Oblique",e.CourierNew="Courier",e["CourierNew-Bold"]="Courier-Bold",e["CourierNew-BoldItalic"]="Courier-BoldOblique",e["CourierNew-Italic"]="Courier-Oblique",e["CourierNewPS-BoldItalicMT"]="Courier-BoldOblique",e["CourierNewPS-BoldMT"]="Courier-Bold",e["CourierNewPS-ItalicMT"]="Courier-Oblique",e.CourierNewPSMT="Courier",e.Helvetica="Helvetica",e["Helvetica-Bold"]="Helvetica-Bold",e["Helvetica-BoldItalic"]="Helvetica-BoldOblique",e["Helvetica-BoldOblique"]="Helvetica-BoldOblique",e["Helvetica-Italic"]="Helvetica-Oblique",e["Helvetica-Oblique"]="Helvetica-Oblique",e["Symbol-Bold"]="Symbol",e["Symbol-BoldItalic"]="Symbol",e["Symbol-Italic"]="Symbol",e.TimesNewRoman="Times-Roman",e["TimesNewRoman-Bold"]="Times-Bold",e["TimesNewRoman-BoldItalic"]="Times-BoldItalic",e["TimesNewRoman-Italic"]="Times-Italic",e.TimesNewRomanPS="Times-Roman",e["TimesNewRomanPS-Bold"]="Times-Bold",e["TimesNewRomanPS-BoldItalic"]="Times-BoldItalic",e["TimesNewRomanPS-BoldItalicMT"]="Times-BoldItalic",e["TimesNewRomanPS-BoldMT"]="Times-Bold",e["TimesNewRomanPS-Italic"]="Times-Italic",e["TimesNewRomanPS-ItalicMT"]="Times-Italic",e.TimesNewRomanPSMT="Times-Roman",e["TimesNewRomanPSMT-Bold"]="Times-Bold",e["TimesNewRomanPSMT-BoldItalic"]="Times-BoldItalic",e["TimesNewRomanPSMT-Italic"]="Times-Italic"}));t.getStdFontMap=i;const n=(0,a.getLookupTableFactory)((function(e){e.Calibri="Helvetica",e["Calibri-Bold"]="Helvetica-Bold",e["Calibri-BoldItalic"]="Helvetica-BoldOblique",e["Calibri-Italic"]="Helvetica-Oblique",e.CenturyGothic="Helvetica",e["CenturyGothic-Bold"]="Helvetica-Bold",e["CenturyGothic-BoldItalic"]="Helvetica-BoldOblique",e["CenturyGothic-Italic"]="Helvetica-Oblique",e.ComicSansMS="Comic Sans MS",e["ComicSansMS-Bold"]="Comic Sans MS-Bold",e["ComicSansMS-BoldItalic"]="Comic Sans MS-BoldItalic",e["ComicSansMS-Italic"]="Comic Sans MS-Italic",e.LucidaConsole="Courier",e["LucidaConsole-Bold"]="Courier-Bold",e["LucidaConsole-BoldItalic"]="Courier-BoldOblique",e["LucidaConsole-Italic"]="Courier-Oblique",e["LucidaSans-Demi"]="Helvetica-Bold",e["MS-Gothic"]="MS Gothic",e["MS-Gothic-Bold"]="MS Gothic-Bold",e["MS-Gothic-BoldItalic"]="MS Gothic-BoldItalic",e["MS-Gothic-Italic"]="MS Gothic-Italic",e["MS-Mincho"]="MS Mincho",e["MS-Mincho-Bold"]="MS Mincho-Bold",e["MS-Mincho-BoldItalic"]="MS Mincho-BoldItalic",e["MS-Mincho-Italic"]="MS Mincho-Italic",e["MS-PGothic"]="MS PGothic",e["MS-PGothic-Bold"]="MS PGothic-Bold",e["MS-PGothic-BoldItalic"]="MS PGothic-BoldItalic",e["MS-PGothic-Italic"]="MS PGothic-Italic",e["MS-PMincho"]="MS PMincho",e["MS-PMincho-Bold"]="MS PMincho-Bold",e["MS-PMincho-BoldItalic"]="MS PMincho-BoldItalic",e["MS-PMincho-Italic"]="MS PMincho-Italic",e.NuptialScript="Times-Italic",e.SegoeUISymbol="Helvetica",e.Wingdings="ZapfDingbats",e["Wingdings-Regular"]="ZapfDingbats"}));t.getNonStdFontMap=n;const s=(0,a.getLookupTableFactory)((function(e){e["Adobe Jenson"]=!0,e["Adobe Text"]=!0,e.Albertus=!0,e.Aldus=!0,e.Alexandria=!0,e.Algerian=!0,e["American Typewriter"]=!0,e.Antiqua=!0,e.Apex=!0,e.Arno=!0,e.Aster=!0,e.Aurora=!0,e.Baskerville=!0,e.Bell=!0,e.Bembo=!0,e["Bembo Schoolbook"]=!0,e.Benguiat=!0,e["Berkeley Old Style"]=!0,e["Bernhard Modern"]=!0,e["Berthold City"]=!0,e.Bodoni=!0,e["Bauer Bodoni"]=!0,e["Book Antiqua"]=!0,e.Bookman=!0,e["Bordeaux Roman"]=!0,e["Californian FB"]=!0,e.Calisto=!0,e.Calvert=!0,e.Capitals=!0,e.Cambria=!0,e.Cartier=!0,e.Caslon=!0,e.Catull=!0,e.Centaur=!0,e["Century Old Style"]=!0,e["Century Schoolbook"]=!0,e.Chaparral=!0,e["Charis SIL"]=!0,e.Cheltenham=!0,e["Cholla Slab"]=!0,e.Clarendon=!0,e.Clearface=!0,e.Cochin=!0,e.Colonna=!0,e["Computer Modern"]=!0,e["Concrete Roman"]=!0,e.Constantia=!0,e["Cooper Black"]=!0,e.Corona=!0,e.Ecotype=!0,e.Egyptienne=!0,e.Elephant=!0,e.Excelsior=!0,e.Fairfield=!0,e["FF Scala"]=!0,e.Folkard=!0,e.Footlight=!0,e.FreeSerif=!0,e["Friz Quadrata"]=!0,e.Garamond=!0,e.Gentium=!0,e.Georgia=!0,e.Gloucester=!0,e["Goudy Old Style"]=!0,e["Goudy Schoolbook"]=!0,e["Goudy Pro Font"]=!0,e.Granjon=!0,e["Guardian Egyptian"]=!0,e.Heather=!0,e.Hercules=!0,e["High Tower Text"]=!0,e.Hiroshige=!0,e["Hoefler Text"]=!0,e["Humana Serif"]=!0,e.Imprint=!0,e["Ionic No. 5"]=!0,e.Janson=!0,e.Joanna=!0,e.Korinna=!0,e.Lexicon=!0,e["Liberation Serif"]=!0,e["Linux Libertine"]=!0,e.Literaturnaya=!0,e.Lucida=!0,e["Lucida Bright"]=!0,e.Melior=!0,e.Memphis=!0,e.Miller=!0,e.Minion=!0,e.Modern=!0,e["Mona Lisa"]=!0,e["Mrs Eaves"]=!0,e["MS Serif"]=!0,e["Museo Slab"]=!0,e["New York"]=!0,e["Nimbus Roman"]=!0,e["NPS Rawlinson Roadway"]=!0,e.NuptialScript=!0,e.Palatino=!0,e.Perpetua=!0,e.Plantin=!0,e["Plantin Schoolbook"]=!0,e.Playbill=!0,e["Poor Richard"]=!0,e["Rawlinson Roadway"]=!0,e.Renault=!0,e.Requiem=!0,e.Rockwell=!0,e.Roman=!0,e["Rotis Serif"]=!0,e.Sabon=!0,e.Scala=!0,e.Seagull=!0,e.Sistina=!0,e.Souvenir=!0,e.STIX=!0,e["Stone Informal"]=!0,e["Stone Serif"]=!0,e.Sylfaen=!0,e.Times=!0,e.Trajan=!0,e["Trinité"]=!0,e["Trump Mediaeval"]=!0,e.Utopia=!0,e["Vale Type"]=!0,e["Bitstream Vera"]=!0,e["Vera Serif"]=!0,e.Versailles=!0,e.Wanted=!0,e.Weiss=!0,e["Wide Latin"]=!0,e.Windsor=!0,e.XITS=!0}));t.getSerifFonts=s;const o=(0,a.getLookupTableFactory)((function(e){e.Dingbats=!0,e.Symbol=!0,e.ZapfDingbats=!0}));t.getSymbolsFonts=o;const c=(0,a.getLookupTableFactory)((function(e){e[2]=10,e[3]=32,e[4]=33,e[5]=34,e[6]=35,e[7]=36,e[8]=37,e[9]=38,e[10]=39,e[11]=40,e[12]=41,e[13]=42,e[14]=43,e[15]=44,e[16]=45,e[17]=46,e[18]=47,e[19]=48,e[20]=49,e[21]=50,e[22]=51,e[23]=52,e[24]=53,e[25]=54,e[26]=55,e[27]=56,e[28]=57,e[29]=58,e[30]=894,e[31]=60,e[32]=61,e[33]=62,e[34]=63,e[35]=64,e[36]=65,e[37]=66,e[38]=67,e[39]=68,e[40]=69,e[41]=70,e[42]=71,e[43]=72,e[44]=73,e[45]=74,e[46]=75,e[47]=76,e[48]=77,e[49]=78,e[50]=79,e[51]=80,e[52]=81,e[53]=82,e[54]=83,e[55]=84,e[56]=85,e[57]=86,e[58]=87,e[59]=88,e[60]=89,e[61]=90,e[62]=91,e[63]=92,e[64]=93,e[65]=94,e[66]=95,e[67]=96,e[68]=97,e[69]=98,e[70]=99,e[71]=100,e[72]=101,e[73]=102,e[74]=103,e[75]=104,e[76]=105,e[77]=106,e[78]=107,e[79]=108,e[80]=109,e[81]=110,e[82]=111,e[83]=112,e[84]=113,e[85]=114,e[86]=115,e[87]=116,e[88]=117,e[89]=118,e[90]=119,e[91]=120,e[92]=121,e[93]=122,e[94]=123,e[95]=124,e[96]=125,e[97]=126,e[98]=196,e[99]=197,e[100]=199,e[101]=201,e[102]=209,e[103]=214,e[104]=220,e[105]=225,e[106]=224,e[107]=226,e[108]=228,e[109]=227,e[110]=229,e[111]=231,e[112]=233,e[113]=232,e[114]=234,e[115]=235,e[116]=237,e[117]=236,e[118]=238,e[119]=239,e[120]=241,e[121]=243,e[122]=242,e[123]=244,e[124]=246,e[125]=245,e[126]=250,e[127]=249,e[128]=251,e[129]=252,e[130]=8224,e[131]=176,e[132]=162,e[133]=163,e[134]=167,e[135]=8226,e[136]=182,e[137]=223,e[138]=174,e[139]=169,e[140]=8482,e[141]=180,e[142]=168,e[143]=8800,e[144]=198,e[145]=216,e[146]=8734,e[147]=177,e[148]=8804,e[149]=8805,e[150]=165,e[151]=181,e[152]=8706,e[153]=8721,e[154]=8719,e[156]=8747,e[157]=170,e[158]=186,e[159]=8486,e[160]=230,e[161]=248,e[162]=191,e[163]=161,e[164]=172,e[165]=8730,e[166]=402,e[167]=8776,e[168]=8710,e[169]=171,e[170]=187,e[171]=8230,e[210]=218,e[223]=711,e[224]=321,e[225]=322,e[227]=353,e[229]=382,e[234]=253,e[252]=263,e[253]=268,e[254]=269,e[258]=258,e[260]=260,e[261]=261,e[265]=280,e[266]=281,e[268]=283,e[269]=313,e[275]=323,e[276]=324,e[278]=328,e[284]=345,e[285]=346,e[286]=347,e[292]=367,e[295]=377,e[296]=378,e[298]=380,e[305]=963,e[306]=964,e[307]=966,e[308]=8215,e[309]=8252,e[310]=8319,e[311]=8359,e[312]=8592,e[313]=8593,e[337]=9552,e[493]=1039,e[494]=1040,e[705]=1524,e[706]=8362,e[710]=64288,e[711]=64298,e[759]=1617,e[761]=1776,e[763]=1778,e[775]=1652,e[777]=1764,e[778]=1780,e[779]=1781,e[780]=1782,e[782]=771,e[783]=64726,e[786]=8363,e[788]=8532,e[790]=768,e[791]=769,e[792]=768,e[795]=803,e[797]=64336,e[798]=64337,e[799]=64342,e[800]=64343,e[801]=64344,e[802]=64345,e[803]=64362,e[804]=64363,e[805]=64364,e[2424]=7821,e[2425]=7822,e[2426]=7823,e[2427]=7824,e[2428]=7825,e[2429]=7826,e[2430]=7827,e[2433]=7682,e[2678]=8045,e[2679]=8046,e[2830]=1552,e[2838]=686,e[2840]=751,e[2842]=753,e[2843]=754,e[2844]=755,e[2846]=757,e[2856]=767,e[2857]=848,e[2858]=849,e[2862]=853,e[2863]=854,e[2864]=855,e[2865]=861,e[2866]=862,e[2906]=7460,e[2908]=7462,e[2909]=7463,e[2910]=7464,e[2912]=7466,e[2913]=7467,e[2914]=7468,e[2916]=7470,e[2917]=7471,e[2918]=7472,e[2920]=7474,e[2921]=7475,e[2922]=7476,e[2924]=7478,e[2925]=7479,e[2926]=7480,e[2928]=7482,e[2929]=7483,e[2930]=7484,e[2932]=7486,e[2933]=7487,e[2934]=7488,e[2936]=7490,e[2937]=7491,e[2938]=7492,e[2940]=7494,e[2941]=7495,e[2942]=7496,e[2944]=7498,e[2946]=7500,e[2948]=7502,e[2950]=7504,e[2951]=7505,e[2952]=7506,e[2954]=7508,e[2955]=7509,e[2956]=7510,e[2958]=7512,e[2959]=7513,e[2960]=7514,e[2962]=7516,e[2963]=7517,e[2964]=7518,e[2966]=7520,e[2967]=7521,e[2968]=7522,e[2970]=7524,e[2971]=7525,e[2972]=7526,e[2974]=7528,e[2975]=7529,e[2976]=7530,e[2978]=1537,e[2979]=1538,e[2980]=1539,e[2982]=1549,e[2983]=1551,e[2984]=1552,e[2986]=1554,e[2987]=1555,e[2988]=1556,e[2990]=1623,e[2991]=1624,e[2995]=1775,e[2999]=1791,e[3002]=64290,e[3003]=64291,e[3004]=64292,e[3006]=64294,e[3007]=64295,e[3008]=64296,e[3011]=1900,e[3014]=8223,e[3015]=8244,e[3017]=7532,e[3018]=7533,e[3019]=7534,e[3075]=7590,e[3076]=7591,e[3079]=7594,e[3080]=7595,e[3083]=7598,e[3084]=7599,e[3087]=7602,e[3088]=7603,e[3091]=7606,e[3092]=7607,e[3095]=7610,e[3096]=7611,e[3099]=7614,e[3100]=7615,e[3103]=7618,e[3104]=7619,e[3107]=8337,e[3108]=8338,e[3116]=1884,e[3119]=1885,e[3120]=1885,e[3123]=1886,e[3124]=1886,e[3127]=1887,e[3128]=1887,e[3131]=1888,e[3132]=1888,e[3135]=1889,e[3136]=1889,e[3139]=1890,e[3140]=1890,e[3143]=1891,e[3144]=1891,e[3147]=1892,e[3148]=1892,e[3153]=580,e[3154]=581,e[3157]=584,e[3158]=585,e[3161]=588,e[3162]=589,e[3165]=891,e[3166]=892,e[3169]=1274,e[3170]=1275,e[3173]=1278,e[3174]=1279,e[3181]=7622,e[3182]=7623,e[3282]=11799,e[3316]=578,e[3379]=42785,e[3393]=1159,e[3416]=8377}));t.getGlyphMapForStandardFonts=c;const l=(0,a.getLookupTableFactory)((function(e){e[227]=322,e[264]=261,e[291]=346}));t.getSupplementalGlyphMapForArialBlack=l;const h=(0,a.getLookupTableFactory)((function(e){e[1]=32,e[4]=65,e[17]=66,e[18]=67,e[24]=68,e[28]=69,e[38]=70,e[39]=71,e[44]=72,e[47]=73,e[58]=74,e[60]=75,e[62]=76,e[68]=77,e[69]=78,e[75]=79,e[87]=80,e[89]=81,e[90]=82,e[94]=83,e[100]=84,e[104]=85,e[115]=86,e[116]=87,e[121]=88,e[122]=89,e[127]=90,e[258]=97,e[268]=261,e[271]=98,e[272]=99,e[273]=263,e[282]=100,e[286]=101,e[295]=281,e[296]=102,e[336]=103,e[346]=104,e[349]=105,e[361]=106,e[364]=107,e[367]=108,e[371]=322,e[373]=109,e[374]=110,e[381]=111,e[383]=243,e[393]=112,e[395]=113,e[396]=114,e[400]=115,e[401]=347,e[410]=116,e[437]=117,e[448]=118,e[449]=119,e[454]=120,e[455]=121,e[460]=122,e[463]=380,e[853]=44,e[855]=58,e[856]=46,e[876]=47,e[878]=45,e[882]=45,e[894]=40,e[895]=41,e[896]=91,e[897]=93,e[923]=64,e[1004]=48,e[1005]=49,e[1006]=50,e[1007]=51,e[1008]=52,e[1009]=53,e[1010]=54,e[1011]=55,e[1012]=56,e[1013]=57,e[1081]=37,e[1085]=43,e[1086]=45}));t.getSupplementalGlyphMapForCalibri=h},(e,t,r)=>{r.r(t),r.d(t,{getNormalizedUnicodes:()=>l,getUnicodeForGlyph:()=>s,getUnicodeRangeFor:()=>c,mapSpecialUnicodeValues:()=>n,reverseIfRtl:()=>h});var a=r(8);const i=(0,a.getLookupTableFactory)((function(e){e[63721]=169,e[63193]=169,e[63720]=174,e[63194]=174,e[63722]=8482,e[63195]=8482,e[63729]=9127,e[63730]=9128,e[63731]=9129,e[63740]=9131,e[63741]=9132,e[63742]=9133,e[63726]=9121,e[63727]=9122,e[63728]=9123,e[63737]=9124,e[63738]=9125,e[63739]=9126,e[63723]=9115,e[63724]=9116,e[63725]=9117,e[63734]=9118,e[63735]=9119,e[63736]=9120}));function n(e){return e>=65520&&e<=65535?0:e>=62976&&e<=63743?i()[e]||e:173===e?45:e}function s(e,t){let r=t[e];if(void 0!==r)return r;if(!e)return-1;if("u"===e[0]){const t=e.length;let a;if(7===t&&"n"===e[1]&&"i"===e[2])a=e.substring(3);else{if(!(t>=5&&t<=7))return-1;a=e.substring(1)}if(a===a.toUpperCase()&&(r=parseInt(a,16),r>=0))return r}return-1}const o=[{begin:0,end:127},{begin:128,end:255},{begin:256,end:383},{begin:384,end:591},{begin:592,end:687},{begin:688,end:767},{begin:768,end:879},{begin:880,end:1023},{begin:11392,end:11519},{begin:1024,end:1279},{begin:1328,end:1423},{begin:1424,end:1535},{begin:42240,end:42559},{begin:1536,end:1791},{begin:1984,end:2047},{begin:2304,end:2431},{begin:2432,end:2559},{begin:2560,end:2687},{begin:2688,end:2815},{begin:2816,end:2943},{begin:2944,end:3071},{begin:3072,end:3199},{begin:3200,end:3327},{begin:3328,end:3455},{begin:3584,end:3711},{begin:3712,end:3839},{begin:4256,end:4351},{begin:6912,end:7039},{begin:4352,end:4607},{begin:7680,end:7935},{begin:7936,end:8191},{begin:8192,end:8303},{begin:8304,end:8351},{begin:8352,end:8399},{begin:8400,end:8447},{begin:8448,end:8527},{begin:8528,end:8591},{begin:8592,end:8703},{begin:8704,end:8959},{begin:8960,end:9215},{begin:9216,end:9279},{begin:9280,end:9311},{begin:9312,end:9471},{begin:9472,end:9599},{begin:9600,end:9631},{begin:9632,end:9727},{begin:9728,end:9983},{begin:9984,end:10175},{begin:12288,end:12351},{begin:12352,end:12447},{begin:12448,end:12543},{begin:12544,end:12591},{begin:12592,end:12687},{begin:43072,end:43135},{begin:12800,end:13055},{begin:13056,end:13311},{begin:44032,end:55215},{begin:55296,end:57343},{begin:67840,end:67871},{begin:19968,end:40959},{begin:57344,end:63743},{begin:12736,end:12783},{begin:64256,end:64335},{begin:64336,end:65023},{begin:65056,end:65071},{begin:65040,end:65055},{begin:65104,end:65135},{begin:65136,end:65279},{begin:65280,end:65519},{begin:65520,end:65535},{begin:3840,end:4095},{begin:1792,end:1871},{begin:1920,end:1983},{begin:3456,end:3583},{begin:4096,end:4255},{begin:4608,end:4991},{begin:5024,end:5119},{begin:5120,end:5759},{begin:5760,end:5791},{begin:5792,end:5887},{begin:6016,end:6143},{begin:6144,end:6319},{begin:10240,end:10495},{begin:40960,end:42127},{begin:5888,end:5919},{begin:66304,end:66351},{begin:66352,end:66383},{begin:66560,end:66639},{begin:118784,end:119039},{begin:119808,end:120831},{begin:1044480,end:1048573},{begin:65024,end:65039},{begin:917504,end:917631},{begin:6400,end:6479},{begin:6480,end:6527},{begin:6528,end:6623},{begin:6656,end:6687},{begin:11264,end:11359},{begin:11568,end:11647},{begin:19904,end:19967},{begin:43008,end:43055},{begin:65536,end:65663},{begin:65856,end:65935},{begin:66432,end:66463},{begin:66464,end:66527},{begin:66640,end:66687},{begin:66688,end:66735},{begin:67584,end:67647},{begin:68096,end:68191},{begin:119552,end:119647},{begin:73728,end:74751},{begin:119648,end:119679},{begin:7040,end:7103},{begin:7168,end:7247},{begin:7248,end:7295},{begin:43136,end:43231},{begin:43264,end:43311},{begin:43312,end:43359},{begin:43520,end:43615},{begin:65936,end:65999},{begin:66e3,end:66047},{begin:66208,end:66271},{begin:127024,end:127135}];function c(e){for(let t=0,r=o.length;t<r;t++){const r=o[t];if(e>=r.begin&&e<r.end)return t}return-1}const l=(0,a.getArrayLookupTableFactory)((function(){return["¨"," ̈","¯"," ̄","´"," ́","µ","μ","¸"," ̧","Ĳ","IJ","ĳ","ij","Ŀ","L·","ŀ","l·","ŉ","ʼn","ſ","s","Ǆ","DŽ","ǅ","Dž","ǆ","dž","Ǉ","LJ","ǈ","Lj","ǉ","lj","Ǌ","NJ","ǋ","Nj","ǌ","nj","Ǳ","DZ","ǲ","Dz","ǳ","dz","˘"," ̆","˙"," ̇","˚"," ̊","˛"," ̨","˜"," ̃","˝"," ̋","ͺ"," ͅ","΄"," ́","ϐ","β","ϑ","θ","ϒ","Υ","ϕ","φ","ϖ","π","ϰ","κ","ϱ","ρ","ϲ","ς","ϴ","Θ","ϵ","ε","Ϲ","Σ","և","եւ","ٵ","اٴ","ٶ","وٴ","ٷ","ۇٴ","ٸ","يٴ","ำ","ํา","ຳ","ໍາ","ໜ","ຫນ","ໝ","ຫມ","ཷ","ྲཱྀ","ཹ","ླཱྀ","ẚ","aʾ","᾽"," ̓","᾿"," ̓","῀"," ͂","῾"," ̔"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","‗"," ̳","․",".","‥","..","…","...","″","′′","‴","′′′","‶","‵‵","‷","‵‵‵","‼","!!","‾"," ̅","⁇","??","⁈","?!","⁉","!?","⁗","′′′′"," "," ","₨","Rs","℀","a/c","℁","a/s","℃","°C","℅","c/o","℆","c/u","ℇ","Ɛ","℉","°F","№","No","℡","TEL","ℵ","א","ℶ","ב","ℷ","ג","ℸ","ד","℻","FAX","Ⅰ","I","Ⅱ","II","Ⅲ","III","Ⅳ","IV","Ⅴ","V","Ⅵ","VI","Ⅶ","VII","Ⅷ","VIII","Ⅸ","IX","Ⅹ","X","Ⅺ","XI","Ⅻ","XII","Ⅼ","L","Ⅽ","C","Ⅾ","D","Ⅿ","M","ⅰ","i","ⅱ","ii","ⅲ","iii","ⅳ","iv","ⅴ","v","ⅵ","vi","ⅶ","vii","ⅷ","viii","ⅸ","ix","ⅹ","x","ⅺ","xi","ⅻ","xii","ⅼ","l","ⅽ","c","ⅾ","d","ⅿ","m","∬","∫∫","∭","∫∫∫","∯","∮∮","∰","∮∮∮","⑴","(1)","⑵","(2)","⑶","(3)","⑷","(4)","⑸","(5)","⑹","(6)","⑺","(7)","⑻","(8)","⑼","(9)","⑽","(10)","⑾","(11)","⑿","(12)","⒀","(13)","⒁","(14)","⒂","(15)","⒃","(16)","⒄","(17)","⒅","(18)","⒆","(19)","⒇","(20)","⒈","1.","⒉","2.","⒊","3.","⒋","4.","⒌","5.","⒍","6.","⒎","7.","⒏","8.","⒐","9.","⒑","10.","⒒","11.","⒓","12.","⒔","13.","⒕","14.","⒖","15.","⒗","16.","⒘","17.","⒙","18.","⒚","19.","⒛","20.","⒜","(a)","⒝","(b)","⒞","(c)","⒟","(d)","⒠","(e)","⒡","(f)","⒢","(g)","⒣","(h)","⒤","(i)","⒥","(j)","⒦","(k)","⒧","(l)","⒨","(m)","⒩","(n)","⒪","(o)","⒫","(p)","⒬","(q)","⒭","(r)","⒮","(s)","⒯","(t)","⒰","(u)","⒱","(v)","⒲","(w)","⒳","(x)","⒴","(y)","⒵","(z)","⨌","∫∫∫∫","⩴","::=","⩵","==","⩶","===","⺟","母","⻳","龟","⼀","一","⼁","丨","⼂","丶","⼃","丿","⼄","乙","⼅","亅","⼆","二","⼇","亠","⼈","人","⼉","儿","⼊","入","⼋","八","⼌","冂","⼍","冖","⼎","冫","⼏","几","⼐","凵","⼑","刀","⼒","力","⼓","勹","⼔","匕","⼕","匚","⼖","匸","⼗","十","⼘","卜","⼙","卩","⼚","厂","⼛","厶","⼜","又","⼝","口","⼞","囗","⼟","土","⼠","士","⼡","夂","⼢","夊","⼣","夕","⼤","大","⼥","女","⼦","子","⼧","宀","⼨","寸","⼩","小","⼪","尢","⼫","尸","⼬","屮","⼭","山","⼮","巛","⼯","工","⼰","己","⼱","巾","⼲","干","⼳","幺","⼴","广","⼵","廴","⼶","廾","⼷","弋","⼸","弓","⼹","彐","⼺","彡","⼻","彳","⼼","心","⼽","戈","⼾","戶","⼿","手","⽀","支","⽁","攴","⽂","文","⽃","斗","⽄","斤","⽅","方","⽆","无","⽇","日","⽈","曰","⽉","月","⽊","木","⽋","欠","⽌","止","⽍","歹","⽎","殳","⽏","毋","⽐","比","⽑","毛","⽒","氏","⽓","气","⽔","水","⽕","火","⽖","爪","⽗","父","⽘","爻","⽙","爿","⽚","片","⽛","牙","⽜","牛","⽝","犬","⽞","玄","⽟","玉","⽠","瓜","⽡","瓦","⽢","甘","⽣","生","⽤","用","⽥","田","⽦","疋","⽧","疒","⽨","癶","⽩","白","⽪","皮","⽫","皿","⽬","目","⽭","矛","⽮","矢","⽯","石","⽰","示","⽱","禸","⽲","禾","⽳","穴","⽴","立","⽵","竹","⽶","米","⽷","糸","⽸","缶","⽹","网","⽺","羊","⽻","羽","⽼","老","⽽","而","⽾","耒","⽿","耳","⾀","聿","⾁","肉","⾂","臣","⾃","自","⾄","至","⾅","臼","⾆","舌","⾇","舛","⾈","舟","⾉","艮","⾊","色","⾋","艸","⾌","虍","⾍","虫","⾎","血","⾏","行","⾐","衣","⾑","襾","⾒","見","⾓","角","⾔","言","⾕","谷","⾖","豆","⾗","豕","⾘","豸","⾙","貝","⾚","赤","⾛","走","⾜","足","⾝","身","⾞","車","⾟","辛","⾠","辰","⾡","辵","⾢","邑","⾣","酉","⾤","釆","⾥","里","⾦","金","⾧","長","⾨","門","⾩","阜","⾪","隶","⾫","隹","⾬","雨","⾭","靑","⾮","非","⾯","面","⾰","革","⾱","韋","⾲","韭","⾳","音","⾴","頁","⾵","風","⾶","飛","⾷","食","⾸","首","⾹","香","⾺","馬","⾻","骨","⾼","高","⾽","髟","⾾","鬥","⾿","鬯","⿀","鬲","⿁","鬼","⿂","魚","⿃","鳥","⿄","鹵","⿅","鹿","⿆","麥","⿇","麻","⿈","黃","⿉","黍","⿊","黑","⿋","黹","⿌","黽","⿍","鼎","⿎","鼓","⿏","鼠","⿐","鼻","⿑","齊","⿒","齒","⿓","龍","⿔","龜","⿕","龠","〶","〒","〸","十","〹","卄","〺","卅","゛"," ゙","゜"," ゚","ㄱ","ᄀ","ㄲ","ᄁ","ㄳ","ᆪ","ㄴ","ᄂ","ㄵ","ᆬ","ㄶ","ᆭ","ㄷ","ᄃ","ㄸ","ᄄ","ㄹ","ᄅ","ㄺ","ᆰ","ㄻ","ᆱ","ㄼ","ᆲ","ㄽ","ᆳ","ㄾ","ᆴ","ㄿ","ᆵ","ㅀ","ᄚ","ㅁ","ᄆ","ㅂ","ᄇ","ㅃ","ᄈ","ㅄ","ᄡ","ㅅ","ᄉ","ㅆ","ᄊ","ㅇ","ᄋ","ㅈ","ᄌ","ㅉ","ᄍ","ㅊ","ᄎ","ㅋ","ᄏ","ㅌ","ᄐ","ㅍ","ᄑ","ㅎ","ᄒ","ㅏ","ᅡ","ㅐ","ᅢ","ㅑ","ᅣ","ㅒ","ᅤ","ㅓ","ᅥ","ㅔ","ᅦ","ㅕ","ᅧ","ㅖ","ᅨ","ㅗ","ᅩ","ㅘ","ᅪ","ㅙ","ᅫ","ㅚ","ᅬ","ㅛ","ᅭ","ㅜ","ᅮ","ㅝ","ᅯ","ㅞ","ᅰ","ㅟ","ᅱ","ㅠ","ᅲ","ㅡ","ᅳ","ㅢ","ᅴ","ㅣ","ᅵ","ㅤ","ᅠ","ㅥ","ᄔ","ㅦ","ᄕ","ㅧ","ᇇ","ㅨ","ᇈ","ㅩ","ᇌ","ㅪ","ᇎ","ㅫ","ᇓ","ㅬ","ᇗ","ㅭ","ᇙ","ㅮ","ᄜ","ㅯ","ᇝ","ㅰ","ᇟ","ㅱ","ᄝ","ㅲ","ᄞ","ㅳ","ᄠ","ㅴ","ᄢ","ㅵ","ᄣ","ㅶ","ᄧ","ㅷ","ᄩ","ㅸ","ᄫ","ㅹ","ᄬ","ㅺ","ᄭ","ㅻ","ᄮ","ㅼ","ᄯ","ㅽ","ᄲ","ㅾ","ᄶ","ㅿ","ᅀ","ㆀ","ᅇ","ㆁ","ᅌ","ㆂ","ᇱ","ㆃ","ᇲ","ㆄ","ᅗ","ㆅ","ᅘ","ㆆ","ᅙ","ㆇ","ᆄ","ㆈ","ᆅ","ㆉ","ᆈ","ㆊ","ᆑ","ㆋ","ᆒ","ㆌ","ᆔ","ㆍ","ᆞ","ㆎ","ᆡ","㈀","(ᄀ)","㈁","(ᄂ)","㈂","(ᄃ)","㈃","(ᄅ)","㈄","(ᄆ)","㈅","(ᄇ)","㈆","(ᄉ)","㈇","(ᄋ)","㈈","(ᄌ)","㈉","(ᄎ)","㈊","(ᄏ)","㈋","(ᄐ)","㈌","(ᄑ)","㈍","(ᄒ)","㈎","(가)","㈏","(나)","㈐","(다)","㈑","(라)","㈒","(마)","㈓","(바)","㈔","(사)","㈕","(아)","㈖","(자)","㈗","(차)","㈘","(카)","㈙","(타)","㈚","(파)","㈛","(하)","㈜","(주)","㈝","(오전)","㈞","(오후)","㈠","(一)","㈡","(二)","㈢","(三)","㈣","(四)","㈤","(五)","㈥","(六)","㈦","(七)","㈧","(八)","㈨","(九)","㈩","(十)","㈪","(月)","㈫","(火)","㈬","(水)","㈭","(木)","㈮","(金)","㈯","(土)","㈰","(日)","㈱","(株)","㈲","(有)","㈳","(社)","㈴","(名)","㈵","(特)","㈶","(財)","㈷","(祝)","㈸","(労)","㈹","(代)","㈺","(呼)","㈻","(学)","㈼","(監)","㈽","(企)","㈾","(資)","㈿","(協)","㉀","(祭)","㉁","(休)","㉂","(自)","㉃","(至)","㋀","1月","㋁","2月","㋂","3月","㋃","4月","㋄","5月","㋅","6月","㋆","7月","㋇","8月","㋈","9月","㋉","10月","㋊","11月","㋋","12月","㍘","0点","㍙","1点","㍚","2点","㍛","3点","㍜","4点","㍝","5点","㍞","6点","㍟","7点","㍠","8点","㍡","9点","㍢","10点","㍣","11点","㍤","12点","㍥","13点","㍦","14点","㍧","15点","㍨","16点","㍩","17点","㍪","18点","㍫","19点","㍬","20点","㍭","21点","㍮","22点","㍯","23点","㍰","24点","㏠","1日","㏡","2日","㏢","3日","㏣","4日","㏤","5日","㏥","6日","㏦","7日","㏧","8日","㏨","9日","㏩","10日","㏪","11日","㏫","12日","㏬","13日","㏭","14日","㏮","15日","㏯","16日","㏰","17日","㏱","18日","㏲","19日","㏳","20日","㏴","21日","㏵","22日","㏶","23日","㏷","24日","㏸","25日","㏹","26日","㏺","27日","㏻","28日","㏼","29日","㏽","30日","㏾","31日","ﬀ","ff","ﬁ","fi","ﬂ","fl","ﬃ","ffi","ﬄ","ffl","ﬅ","ſt","ﬆ","st","ﬓ","մն","ﬔ","մե","ﬕ","մի","ﬖ","վն","ﬗ","մխ","ﭏ","אל","ﭐ","ٱ","ﭑ","ٱ","ﭒ","ٻ","ﭓ","ٻ","ﭔ","ٻ","ﭕ","ٻ","ﭖ","پ","ﭗ","پ","ﭘ","پ","ﭙ","پ","ﭚ","ڀ","ﭛ","ڀ","ﭜ","ڀ","ﭝ","ڀ","ﭞ","ٺ","ﭟ","ٺ","ﭠ","ٺ","ﭡ","ٺ","ﭢ","ٿ","ﭣ","ٿ","ﭤ","ٿ","ﭥ","ٿ","ﭦ","ٹ","ﭧ","ٹ","ﭨ","ٹ","ﭩ","ٹ","ﭪ","ڤ","ﭫ","ڤ","ﭬ","ڤ","ﭭ","ڤ","ﭮ","ڦ","ﭯ","ڦ","ﭰ","ڦ","ﭱ","ڦ","ﭲ","ڄ","ﭳ","ڄ","ﭴ","ڄ","ﭵ","ڄ","ﭶ","ڃ","ﭷ","ڃ","ﭸ","ڃ","ﭹ","ڃ","ﭺ","چ","ﭻ","چ","ﭼ","چ","ﭽ","چ","ﭾ","ڇ","ﭿ","ڇ","ﮀ","ڇ","ﮁ","ڇ","ﮂ","ڍ","ﮃ","ڍ","ﮄ","ڌ","ﮅ","ڌ","ﮆ","ڎ","ﮇ","ڎ","ﮈ","ڈ","ﮉ","ڈ","ﮊ","ژ","ﮋ","ژ","ﮌ","ڑ","ﮍ","ڑ","ﮎ","ک","ﮏ","ک","ﮐ","ک","ﮑ","ک","ﮒ","گ","ﮓ","گ","ﮔ","گ","ﮕ","گ","ﮖ","ڳ","ﮗ","ڳ","ﮘ","ڳ","ﮙ","ڳ","ﮚ","ڱ","ﮛ","ڱ","ﮜ","ڱ","ﮝ","ڱ","ﮞ","ں","ﮟ","ں","ﮠ","ڻ","ﮡ","ڻ","ﮢ","ڻ","ﮣ","ڻ","ﮤ","ۀ","ﮥ","ۀ","ﮦ","ہ","ﮧ","ہ","ﮨ","ہ","ﮩ","ہ","ﮪ","ھ","ﮫ","ھ","ﮬ","ھ","ﮭ","ھ","ﮮ","ے","ﮯ","ے","ﮰ","ۓ","ﮱ","ۓ","ﯓ","ڭ","ﯔ","ڭ","ﯕ","ڭ","ﯖ","ڭ","ﯗ","ۇ","ﯘ","ۇ","ﯙ","ۆ","ﯚ","ۆ","ﯛ","ۈ","ﯜ","ۈ","ﯝ","ٷ","ﯞ","ۋ","ﯟ","ۋ","ﯠ","ۅ","ﯡ","ۅ","ﯢ","ۉ","ﯣ","ۉ","ﯤ","ې","ﯥ","ې","ﯦ","ې","ﯧ","ې","ﯨ","ى","ﯩ","ى","ﯪ","ئا","ﯫ","ئا","ﯬ","ئە","ﯭ","ئە","ﯮ","ئو","ﯯ","ئو","ﯰ","ئۇ","ﯱ","ئۇ","ﯲ","ئۆ","ﯳ","ئۆ","ﯴ","ئۈ","ﯵ","ئۈ","ﯶ","ئې","ﯷ","ئې","ﯸ","ئې","ﯹ","ئى","ﯺ","ئى","ﯻ","ئى","ﯼ","ی","ﯽ","ی","ﯾ","ی","ﯿ","ی","ﰀ","ئج","ﰁ","ئح","ﰂ","ئم","ﰃ","ئى","ﰄ","ئي","ﰅ","بج","ﰆ","بح","ﰇ","بخ","ﰈ","بم","ﰉ","بى","ﰊ","بي","ﰋ","تج","ﰌ","تح","ﰍ","تخ","ﰎ","تم","ﰏ","تى","ﰐ","تي","ﰑ","ثج","ﰒ","ثم","ﰓ","ثى","ﰔ","ثي","ﰕ","جح","ﰖ","جم","ﰗ","حج","ﰘ","حم","ﰙ","خج","ﰚ","خح","ﰛ","خم","ﰜ","سج","ﰝ","سح","ﰞ","سخ","ﰟ","سم","ﰠ","صح","ﰡ","صم","ﰢ","ضج","ﰣ","ضح","ﰤ","ضخ","ﰥ","ضم","ﰦ","طح","ﰧ","طم","ﰨ","ظم","ﰩ","عج","ﰪ","عم","ﰫ","غج","ﰬ","غم","ﰭ","فج","ﰮ","فح","ﰯ","فخ","ﰰ","فم","ﰱ","فى","ﰲ","في","ﰳ","قح","ﰴ","قم","ﰵ","قى","ﰶ","قي","ﰷ","كا","ﰸ","كج","ﰹ","كح","ﰺ","كخ","ﰻ","كل","ﰼ","كم","ﰽ","كى","ﰾ","كي","ﰿ","لج","ﱀ","لح","ﱁ","لخ","ﱂ","لم","ﱃ","لى","ﱄ","لي","ﱅ","مج","ﱆ","مح","ﱇ","مخ","ﱈ","مم","ﱉ","مى","ﱊ","مي","ﱋ","نج","ﱌ","نح","ﱍ","نخ","ﱎ","نم","ﱏ","نى","ﱐ","ني","ﱑ","هج","ﱒ","هم","ﱓ","هى","ﱔ","هي","ﱕ","يج","ﱖ","يح","ﱗ","يخ","ﱘ","يم","ﱙ","يى","ﱚ","يي","ﱛ","ذٰ","ﱜ","رٰ","ﱝ","ىٰ","ﱞ"," ٌّ","ﱟ"," ٍّ","ﱠ"," َّ","ﱡ"," ُّ","ﱢ"," ِّ","ﱣ"," ّٰ","ﱤ","ئر","ﱥ","ئز","ﱦ","ئم","ﱧ","ئن","ﱨ","ئى","ﱩ","ئي","ﱪ","بر","ﱫ","بز","ﱬ","بم","ﱭ","بن","ﱮ","بى","ﱯ","بي","ﱰ","تر","ﱱ","تز","ﱲ","تم","ﱳ","تن","ﱴ","تى","ﱵ","تي","ﱶ","ثر","ﱷ","ثز","ﱸ","ثم","ﱹ","ثن","ﱺ","ثى","ﱻ","ثي","ﱼ","فى","ﱽ","في","ﱾ","قى","ﱿ","قي","ﲀ","كا","ﲁ","كل","ﲂ","كم","ﲃ","كى","ﲄ","كي","ﲅ","لم","ﲆ","لى","ﲇ","لي","ﲈ","ما","ﲉ","مم","ﲊ","نر","ﲋ","نز","ﲌ","نم","ﲍ","نن","ﲎ","نى","ﲏ","ني","ﲐ","ىٰ","ﲑ","ير","ﲒ","يز","ﲓ","يم","ﲔ","ين","ﲕ","يى","ﲖ","يي","ﲗ","ئج","ﲘ","ئح","ﲙ","ئخ","ﲚ","ئم","ﲛ","ئه","ﲜ","بج","ﲝ","بح","ﲞ","بخ","ﲟ","بم","ﲠ","به","ﲡ","تج","ﲢ","تح","ﲣ","تخ","ﲤ","تم","ﲥ","ته","ﲦ","ثم","ﲧ","جح","ﲨ","جم","ﲩ","حج","ﲪ","حم","ﲫ","خج","ﲬ","خم","ﲭ","سج","ﲮ","سح","ﲯ","سخ","ﲰ","سم","ﲱ","صح","ﲲ","صخ","ﲳ","صم","ﲴ","ضج","ﲵ","ضح","ﲶ","ضخ","ﲷ","ضم","ﲸ","طح","ﲹ","ظم","ﲺ","عج","ﲻ","عم","ﲼ","غج","ﲽ","غم","ﲾ","فج","ﲿ","فح","ﳀ","فخ","ﳁ","فم","ﳂ","قح","ﳃ","قم","ﳄ","كج","ﳅ","كح","ﳆ","كخ","ﳇ","كل","ﳈ","كم","ﳉ","لج","ﳊ","لح","ﳋ","لخ","ﳌ","لم","ﳍ","له","ﳎ","مج","ﳏ","مح","ﳐ","مخ","ﳑ","مم","ﳒ","نج","ﳓ","نح","ﳔ","نخ","ﳕ","نم","ﳖ","نه","ﳗ","هج","ﳘ","هم","ﳙ","هٰ","ﳚ","يج","ﳛ","يح","ﳜ","يخ","ﳝ","يم","ﳞ","يه","ﳟ","ئم","ﳠ","ئه","ﳡ","بم","ﳢ","به","ﳣ","تم","ﳤ","ته","ﳥ","ثم","ﳦ","ثه","ﳧ","سم","ﳨ","سه","ﳩ","شم","ﳪ","شه","ﳫ","كل","ﳬ","كم","ﳭ","لم","ﳮ","نم","ﳯ","نه","ﳰ","يم","ﳱ","يه","ﳲ","ـَّ","ﳳ","ـُّ","ﳴ","ـِّ","ﳵ","طى","ﳶ","طي","ﳷ","عى","ﳸ","عي","ﳹ","غى","ﳺ","غي","ﳻ","سى","ﳼ","سي","ﳽ","شى","ﳾ","شي","ﳿ","حى","ﴀ","حي","ﴁ","جى","ﴂ","جي","ﴃ","خى","ﴄ","خي","ﴅ","صى","ﴆ","صي","ﴇ","ضى","ﴈ","ضي","ﴉ","شج","ﴊ","شح","ﴋ","شخ","ﴌ","شم","ﴍ","شر","ﴎ","سر","ﴏ","صر","ﴐ","ضر","ﴑ","طى","ﴒ","طي","ﴓ","عى","ﴔ","عي","ﴕ","غى","ﴖ","غي","ﴗ","سى","ﴘ","سي","ﴙ","شى","ﴚ","شي","ﴛ","حى","ﴜ","حي","ﴝ","جى","ﴞ","جي","ﴟ","خى","ﴠ","خي","ﴡ","صى","ﴢ","صي","ﴣ","ضى","ﴤ","ضي","ﴥ","شج","ﴦ","شح","ﴧ","شخ","ﴨ","شم","ﴩ","شر","ﴪ","سر","ﴫ","صر","ﴬ","ضر","ﴭ","شج","ﴮ","شح","ﴯ","شخ","ﴰ","شم","ﴱ","سه","ﴲ","شه","ﴳ","طم","ﴴ","سج","ﴵ","سح","ﴶ","سخ","ﴷ","شج","ﴸ","شح","ﴹ","شخ","ﴺ","طم","ﴻ","ظم","ﴼ","اً","ﴽ","اً","ﵐ","تجم","ﵑ","تحج","ﵒ","تحج","ﵓ","تحم","ﵔ","تخم","ﵕ","تمج","ﵖ","تمح","ﵗ","تمخ","ﵘ","جمح","ﵙ","جمح","ﵚ","حمي","ﵛ","حمى","ﵜ","سحج","ﵝ","سجح","ﵞ","سجى","ﵟ","سمح","ﵠ","سمح","ﵡ","سمج","ﵢ","سمم","ﵣ","سمم","ﵤ","صحح","ﵥ","صحح","ﵦ","صمم","ﵧ","شحم","ﵨ","شحم","ﵩ","شجي","ﵪ","شمخ","ﵫ","شمخ","ﵬ","شمم","ﵭ","شمم","ﵮ","ضحى","ﵯ","ضخم","ﵰ","ضخم","ﵱ","طمح","ﵲ","طمح","ﵳ","طمم","ﵴ","طمي","ﵵ","عجم","ﵶ","عمم","ﵷ","عمم","ﵸ","عمى","ﵹ","غمم","ﵺ","غمي","ﵻ","غمى","ﵼ","فخم","ﵽ","فخم","ﵾ","قمح","ﵿ","قمم","ﶀ","لحم","ﶁ","لحي","ﶂ","لحى","ﶃ","لجج","ﶄ","لجج","ﶅ","لخم","ﶆ","لخم","ﶇ","لمح","ﶈ","لمح","ﶉ","محج","ﶊ","محم","ﶋ","محي","ﶌ","مجح","ﶍ","مجم","ﶎ","مخج","ﶏ","مخم","ﶒ","مجخ","ﶓ","همج","ﶔ","همم","ﶕ","نحم","ﶖ","نحى","ﶗ","نجم","ﶘ","نجم","ﶙ","نجى","ﶚ","نمي","ﶛ","نمى","ﶜ","يمم","ﶝ","يمم","ﶞ","بخي","ﶟ","تجي","ﶠ","تجى","ﶡ","تخي","ﶢ","تخى","ﶣ","تمي","ﶤ","تمى","ﶥ","جمي","ﶦ","جحى","ﶧ","جمى","ﶨ","سخى","ﶩ","صحي","ﶪ","شحي","ﶫ","ضحي","ﶬ","لجي","ﶭ","لمي","ﶮ","يحي","ﶯ","يجي","ﶰ","يمي","ﶱ","ممي","ﶲ","قمي","ﶳ","نحي","ﶴ","قمح","ﶵ","لحم","ﶶ","عمي","ﶷ","كمي","ﶸ","نجح","ﶹ","مخي","ﶺ","لجم","ﶻ","كمم","ﶼ","لجم","ﶽ","نجح","ﶾ","جحي","ﶿ","حجي","ﷀ","مجي","ﷁ","فمي","ﷂ","بحي","ﷃ","كمم","ﷄ","عجم","ﷅ","صمم","ﷆ","سخي","ﷇ","نجي","﹉","‾","﹊","‾","﹋","‾","﹌","‾","﹍","_","﹎","_","﹏","_","ﺀ","ء","ﺁ","آ","ﺂ","آ","ﺃ","أ","ﺄ","أ","ﺅ","ؤ","ﺆ","ؤ","ﺇ","إ","ﺈ","إ","ﺉ","ئ","ﺊ","ئ","ﺋ","ئ","ﺌ","ئ","ﺍ","ا","ﺎ","ا","ﺏ","ب","ﺐ","ب","ﺑ","ب","ﺒ","ب","ﺓ","ة","ﺔ","ة","ﺕ","ت","ﺖ","ت","ﺗ","ت","ﺘ","ت","ﺙ","ث","ﺚ","ث","ﺛ","ث","ﺜ","ث","ﺝ","ج","ﺞ","ج","ﺟ","ج","ﺠ","ج","ﺡ","ح","ﺢ","ح","ﺣ","ح","ﺤ","ح","ﺥ","خ","ﺦ","خ","ﺧ","خ","ﺨ","خ","ﺩ","د","ﺪ","د","ﺫ","ذ","ﺬ","ذ","ﺭ","ر","ﺮ","ر","ﺯ","ز","ﺰ","ز","ﺱ","س","ﺲ","س","ﺳ","س","ﺴ","س","ﺵ","ش","ﺶ","ش","ﺷ","ش","ﺸ","ش","ﺹ","ص","ﺺ","ص","ﺻ","ص","ﺼ","ص","ﺽ","ض","ﺾ","ض","ﺿ","ض","ﻀ","ض","ﻁ","ط","ﻂ","ط","ﻃ","ط","ﻄ","ط","ﻅ","ظ","ﻆ","ظ","ﻇ","ظ","ﻈ","ظ","ﻉ","ع","ﻊ","ع","ﻋ","ع","ﻌ","ع","ﻍ","غ","ﻎ","غ","ﻏ","غ","ﻐ","غ","ﻑ","ف","ﻒ","ف","ﻓ","ف","ﻔ","ف","ﻕ","ق","ﻖ","ق","ﻗ","ق","ﻘ","ق","ﻙ","ك","ﻚ","ك","ﻛ","ك","ﻜ","ك","ﻝ","ل","ﻞ","ل","ﻟ","ل","ﻠ","ل","ﻡ","م","ﻢ","م","ﻣ","م","ﻤ","م","ﻥ","ن","ﻦ","ن","ﻧ","ن","ﻨ","ن","ﻩ","ه","ﻪ","ه","ﻫ","ه","ﻬ","ه","ﻭ","و","ﻮ","و","ﻯ","ى","ﻰ","ى","ﻱ","ي","ﻲ","ي","ﻳ","ي","ﻴ","ي","ﻵ","لآ","ﻶ","لآ","ﻷ","لأ","ﻸ","لأ","ﻹ","لإ","ﻺ","لإ","ﻻ","لا","ﻼ","لا"]}));function h(e){const t=e.length;if(t<=1||!function(e){let t=o[13];return e>=t.begin&&e<t.end||(t=o[11],e>=t.begin&&e<t.end)}(e.charCodeAt(0)))return e;const r=[];for(let a=t-1;a>=0;a--)r.push(e[a]);return r.join("")}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.FontRendererFactory=void 0;var a=r(2),i=r(32),n=r(35),s=r(34),o=r(12);const c=function(){function e(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]}function t(e,t){return e[t]<<8|e[t+1]}function r(e){const t=e.length;let r=32768;return t<1240?r=107:t<33900&&(r=1131),r}function c(r,i,n){const s=1===t(r,i+2)?e(r,i+8):e(r,i+16),o=t(r,i+s);let c,l,h;if(4===o){t(r,i+s+2);const e=t(r,i+s+6)>>1;for(l=i+s+14,c=[],h=0;h<e;h++,l+=2)c[h]={end:t(r,l)};for(l+=2,h=0;h<e;h++,l+=2)c[h].start=t(r,l);for(h=0;h<e;h++,l+=2)c[h].idDelta=t(r,l);for(h=0;h<e;h++,l+=2){let e=t(r,l);if(0!==e){c[h].ids=[];for(let a=0,i=c[h].end-c[h].start+1;a<i;a++)c[h].ids[a]=t(r,l+e),e+=2}}return c}if(12===o){e(r,i+s+4);const t=e(r,i+s+12);for(l=i+s+16,c=[],h=0;h<t;h++)c.push({start:e(r,l),end:e(r,l+4),idDelta:e(r,l+8)-e(r,l)}),l+=12;return c}throw new a.FormatError(`unsupported cmap: ${o}`)}function l(e,t,r,a){const n=new i.CFFParser(new o.Stream(e,t,r-t),{},a).parse();return{glyphs:n.charStrings.objects,subrs:n.topDict.privateDict&&n.topDict.privateDict.subrsIndex&&n.topDict.privateDict.subrsIndex.objects,gsubrs:n.globalSubrIndex&&n.globalSubrIndex.objects,isCFFCIDFont:n.isCIDFont,fdSelect:n.fdSelect,fdArray:n.fdArray}}function h(e,t){const r=t.codePointAt(0);let a=0,i=0,n=e.length-1;for(;i<n;){const t=i+n+1>>1;r<e[t].start?n=t-1:i=t}return e[i].start<=r&&r<=e[i].end&&(a=e[i].idDelta+(e[i].ids?e[i].ids[r-e[i].start]:r)&65535),{charCode:r,glyphId:a}}function u(e,t,r){function a(e,r){t.push({cmd:"moveTo",args:[e,r]})}function i(e,r){t.push({cmd:"lineTo",args:[e,r]})}function n(e,r,a,i){t.push({cmd:"quadraticCurveTo",args:[e,r,a,i]})}let s=0;const o=(e[s]<<24|e[s+1]<<16)>>16;let c,l=0,h=0;if(s+=10,o<0)do{c=e[s]<<8|e[s+1];const a=e[s+2]<<8|e[s+3];let i,n;s+=4,1&c?(i=(e[s]<<24|e[s+1]<<16)>>16,n=(e[s+2]<<24|e[s+3]<<16)>>16,s+=4):(i=e[s++],n=e[s++]),2&c?(l=i,h=n):(l=0,h=0);let o=1,d=1,f=0,g=0;8&c?(o=d=(e[s]<<24|e[s+1]<<16)/1073741824,s+=2):64&c?(o=(e[s]<<24|e[s+1]<<16)/1073741824,d=(e[s+2]<<24|e[s+3]<<16)/1073741824,s+=4):128&c&&(o=(e[s]<<24|e[s+1]<<16)/1073741824,f=(e[s+2]<<24|e[s+3]<<16)/1073741824,g=(e[s+4]<<24|e[s+5]<<16)/1073741824,d=(e[s+6]<<24|e[s+7]<<16)/1073741824,s+=8);const p=r.glyphs[a];p&&(t.push({cmd:"save"}),t.push({cmd:"transform",args:[o,f,g,d,l,h]}),u(p,t,r),t.push({cmd:"restore"}))}while(32&c);else{const t=[];let r,u;for(r=0;r<o;r++)t.push(e[s]<<8|e[s+1]),s+=2;s+=2+(e[s]<<8|e[s+1]);const d=t[t.length-1]+1,f=[];for(;f.length<d;){c=e[s++];let t=1;for(8&c&&(t+=e[s++]);t-- >0;)f.push({flags:c})}for(r=0;r<d;r++){switch(18&f[r].flags){case 0:l+=(e[s]<<24|e[s+1]<<16)>>16,s+=2;break;case 2:l-=e[s++];break;case 18:l+=e[s++];break}f[r].x=l}for(r=0;r<d;r++){switch(36&f[r].flags){case 0:h+=(e[s]<<24|e[s+1]<<16)>>16,s+=2;break;case 4:h-=e[s++];break;case 36:h+=e[s++];break}f[r].y=h}let g=0;for(s=0;s<o;s++){const e=t[s],o=f.slice(g,e+1);if(1&o[0].flags)o.push(o[0]);else if(1&o[o.length-1].flags)o.unshift(o[o.length-1]);else{const e={flags:1,x:(o[0].x+o[o.length-1].x)/2,y:(o[0].y+o[o.length-1].y)/2};o.unshift(e),o.push(e)}for(a(o[0].x,o[0].y),r=1,u=o.length;r<u;r++)1&o[r].flags?i(o[r].x,o[r].y):1&o[r+1].flags?(n(o[r].x,o[r].y,o[r+1].x,o[r+1].y),r++):n(o[r].x,o[r].y,(o[r].x+o[r+1].x)/2,(o[r].y+o[r+1].y)/2);g=e+1}}}function d(e,t,i,n){function o(e,r){t.push({cmd:"moveTo",args:[e,r]})}function c(e,r){t.push({cmd:"lineTo",args:[e,r]})}function l(e,r,a,i,n,s){t.push({cmd:"bezierCurveTo",args:[e,r,a,i,n,s]})}const u=[];let f=0,g=0,p=0;!function e(m){let b=0;for(;b<m.length;){let y,w,v,S,k,x,A,C,O,F=!1,I=m[b++];switch(I){case 1:p+=u.length>>1,F=!0;break;case 3:p+=u.length>>1,F=!0;break;case 4:g+=u.pop(),o(f,g),F=!0;break;case 5:for(;u.length>0;)f+=u.shift(),g+=u.shift(),c(f,g);break;case 6:for(;u.length>0&&(f+=u.shift(),c(f,g),0!==u.length);)g+=u.shift(),c(f,g);break;case 7:for(;u.length>0&&(g+=u.shift(),c(f,g),0!==u.length);)f+=u.shift(),c(f,g);break;case 8:for(;u.length>0;)y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+u.shift(),l(y,v,w,S,f,g);break;case 10:if(C=u.pop(),O=null,i.isCFFCIDFont){const e=i.fdSelect.getFDIndex(n);if(e>=0&&e<i.fdArray.length){const t=i.fdArray[e];let a;t.privateDict&&t.privateDict.subrsIndex&&(a=t.privateDict.subrsIndex.objects),a&&(C+=r(a),O=a[C])}else(0,a.warn)("Invalid fd index for glyph index.")}else O=i.subrs[C+i.subrsBias];O&&e(O);break;case 11:return;case 12:switch(I=m[b++],I){case 34:y=f+u.shift(),w=y+u.shift(),k=g+u.shift(),f=w+u.shift(),l(y,g,w,k,f,k),y=f+u.shift(),w=y+u.shift(),f=w+u.shift(),l(y,k,w,g,f,g);break;case 35:y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+u.shift(),l(y,v,w,S,f,g),y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+u.shift(),l(y,v,w,S,f,g),u.pop();break;case 36:y=f+u.shift(),k=g+u.shift(),w=y+u.shift(),x=k+u.shift(),f=w+u.shift(),l(y,k,w,x,f,x),y=f+u.shift(),w=y+u.shift(),A=x+u.shift(),f=w+u.shift(),l(y,x,w,A,f,g);break;case 37:const e=f,t=g;y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+u.shift(),l(y,v,w,S,f,g),y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w,g=S,Math.abs(f-e)>Math.abs(g-t)?f+=u.shift():g+=u.shift(),l(y,v,w,S,f,g);break;default:throw new a.FormatError(`unknown operator: 12 ${I}`)}break;case 14:if(u.length>=4){const e=u.pop(),r=u.pop();g=u.pop(),f=u.pop(),t.push({cmd:"save"}),t.push({cmd:"translate",args:[f,g]});let a=h(i.cmap,String.fromCharCode(i.glyphNameMap[s.StandardEncoding[e]]));d(i.glyphs[a.glyphId],t,i,a.glyphId),t.push({cmd:"restore"}),a=h(i.cmap,String.fromCharCode(i.glyphNameMap[s.StandardEncoding[r]])),d(i.glyphs[a.glyphId],t,i,a.glyphId)}return;case 18:p+=u.length>>1,F=!0;break;case 19:p+=u.length>>1,b+=p+7>>3,F=!0;break;case 20:p+=u.length>>1,b+=p+7>>3,F=!0;break;case 21:g+=u.pop(),f+=u.pop(),o(f,g),F=!0;break;case 22:f+=u.pop(),o(f,g),F=!0;break;case 23:p+=u.length>>1,F=!0;break;case 24:for(;u.length>2;)y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+u.shift(),l(y,v,w,S,f,g);f+=u.shift(),g+=u.shift(),c(f,g);break;case 25:for(;u.length>6;)f+=u.shift(),g+=u.shift(),c(f,g);y=f+u.shift(),v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+u.shift(),l(y,v,w,S,f,g);break;case 26:for(u.length%2&&(f+=u.shift());u.length>0;)y=f,v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w,g=S+u.shift(),l(y,v,w,S,f,g);break;case 27:for(u.length%2&&(g+=u.shift());u.length>0;)y=f+u.shift(),v=g,w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S,l(y,v,w,S,f,g);break;case 28:u.push((m[b]<<24|m[b+1]<<16)>>16),b+=2;break;case 29:C=u.pop()+i.gsubrsBias,O=i.gsubrs[C],O&&e(O);break;case 30:for(;u.length>0&&(y=f,v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+(1===u.length?u.shift():0),l(y,v,w,S,f,g),0!==u.length);)y=f+u.shift(),v=g,w=y+u.shift(),S=v+u.shift(),g=S+u.shift(),f=w+(1===u.length?u.shift():0),l(y,v,w,S,f,g);break;case 31:for(;u.length>0&&(y=f+u.shift(),v=g,w=y+u.shift(),S=v+u.shift(),g=S+u.shift(),f=w+(1===u.length?u.shift():0),l(y,v,w,S,f,g),0!==u.length);)y=f,v=g+u.shift(),w=y+u.shift(),S=v+u.shift(),f=w+u.shift(),g=S+(1===u.length?u.shift():0),l(y,v,w,S,f,g);break;default:if(I<32)throw new a.FormatError(`unknown operator: ${I}`);I<247?u.push(I-139):I<251?u.push(256*(I-247)+m[b++]+108):I<255?u.push(256*-(I-251)-m[b++]-108):(u.push((m[b]<<24|m[b+1]<<16|m[b+2]<<8|m[b+3])/65536),b+=4);break}F&&(u.length=0)}}(e)}const f=[];class g{constructor(e){this.constructor===g&&(0,a.unreachable)("Cannot initialize CompiledFont."),this.fontMatrix=e,this.compiledGlyphs=Object.create(null),this.compiledCharCodeToGlyphId=Object.create(null)}getPathJs(e){const t=h(this.cmap,e);let r=this.compiledGlyphs[t.glyphId];return r||(r=this.compileGlyph(this.glyphs[t.glyphId],t.glyphId),this.compiledGlyphs[t.glyphId]=r),void 0===this.compiledCharCodeToGlyphId[t.charCode]&&(this.compiledCharCodeToGlyphId[t.charCode]=t.glyphId),r}compileGlyph(e,t){if(!e||0===e.length||14===e[0])return f;let r=this.fontMatrix;if(this.isCFFCIDFont){const e=this.fdSelect.getFDIndex(t);if(e>=0&&e<this.fdArray.length){r=this.fdArray[e].getByName("FontMatrix")||a.FONT_IDENTITY_MATRIX}else(0,a.warn)("Invalid fd index for glyph index.")}const i=[];return i.push({cmd:"save"}),i.push({cmd:"transform",args:r.slice()}),i.push({cmd:"scale",args:["size","-size"]}),this.compileGlyphImpl(e,i,t),i.push({cmd:"restore"}),i}compileGlyphImpl(){(0,a.unreachable)("Children classes should implement this.")}hasBuiltPath(e){const t=h(this.cmap,e);return void 0!==this.compiledGlyphs[t.glyphId]&&void 0!==this.compiledCharCodeToGlyphId[t.charCode]}}class p extends g{constructor(e,t,r){super(r||[488e-6,0,0,488e-6,0,0]),this.glyphs=e,this.cmap=t}compileGlyphImpl(e,t){u(e,t,this)}}class m extends g{constructor(e,t,a,i){super(a||[.001,0,0,.001,0,0]),this.glyphs=e.glyphs,this.gsubrs=e.gsubrs||[],this.subrs=e.subrs||[],this.cmap=t,this.glyphNameMap=i||(0,n.getGlyphsUnicode)(),this.gsubrsBias=r(this.gsubrs),this.subrsBias=r(this.subrs),this.isCFFCIDFont=e.isCFFCIDFont,this.fdSelect=e.fdSelect,this.fdArray=e.fdArray}compileGlyphImpl(e,t,r){d(e,t,this,r)}}return{create:function(r,i){const n=new Uint8Array(r.data);let s,o,h,u,d,f;const g=t(n,4);for(let r=0,p=12;r<g;r++,p+=16){const r=(0,a.bytesToString)(n.subarray(p,p+4)),g=e(n,p+8),m=e(n,p+12);switch(r){case"cmap":s=c(n,g);break;case"glyf":o=n.subarray(g,g+m);break;case"loca":h=n.subarray(g,g+m);break;case"head":f=t(n,g+18),d=t(n,g+50);break;case"CFF ":u=l(n,g,g+m,i);break}}if(o){const e=f?[1/f,0,0,1/f,0,0]:r.fontMatrix;return new p(function(e,t,r){let a,i;r?(a=4,i=function(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]}):(a=2,i=function(e,t){return e[t]<<9|e[t+1]<<1});const n=[];let s=i(t,0);for(let r=a;r<t.length;r+=a){const a=i(t,r);n.push(e.subarray(s,a)),s=a}return n}(o,h,d),s,e)}return new m(u,s,r.fontMatrix,r.glyphNameMap)}}}();t.FontRendererFactory=c},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Type1Parser=void 0;var a=r(34),i=r(8),n=r(12),s=r(2);const o=function(){const e=[1],t=[3],r=[4],a=[5],i=[6],n=[7],o=[8],c=[12,35],l=[14],h=[21],u=[22],d=[30],f=[31];return class{constructor(){this.width=0,this.lsb=0,this.flexing=!1,this.output=[],this.stack=[]}convert(g,p,m){const b=g.length;let y,w,v,S=!1;for(let k=0;k<b;k++){let b=g[k];if(b<32){switch(12===b&&(b=(b<<8)+g[++k]),b){case 1:if(1){this.stack=[];break}S=this.executeCommand(2,e);break;case 3:if(1){this.stack=[];break}S=this.executeCommand(2,t);break;case 4:if(this.flexing){if(this.stack.length<1){S=!0;break}const e=this.stack.pop();this.stack.push(0,e);break}S=this.executeCommand(1,r);break;case 5:S=this.executeCommand(2,a);break;case 6:S=this.executeCommand(1,i);break;case 7:S=this.executeCommand(1,n);break;case 8:S=this.executeCommand(6,o);break;case 9:this.stack=[];break;case 10:if(this.stack.length<1){S=!0;break}if(v=this.stack.pop(),!p[v]){S=!0;break}S=this.convert(p[v],p,m);break;case 11:return S;case 13:if(this.stack.length<2){S=!0;break}y=this.stack.pop(),w=this.stack.pop(),this.lsb=w,this.width=y,this.stack.push(y,w),S=this.executeCommand(2,u);break;case 14:this.output.push(l[0]);break;case 21:if(this.flexing)break;S=this.executeCommand(2,h);break;case 22:if(this.flexing){this.stack.push(0);break}S=this.executeCommand(1,u);break;case 30:S=this.executeCommand(4,d);break;case 31:S=this.executeCommand(4,f);break;case 3072:this.stack=[];break;case 3073:if(1){this.stack=[];break}S=this.executeCommand(2,t);break;case 3074:if(1){this.stack=[];break}S=this.executeCommand(2,e);break;case 3078:if(m){const e=this.stack[this.stack.length-5];this.seac=this.stack.splice(-4,4),this.seac[0]+=this.lsb-e,S=this.executeCommand(0,l)}else S=this.executeCommand(4,l);break;case 3079:if(this.stack.length<4){S=!0;break}this.stack.pop(),y=this.stack.pop();const g=this.stack.pop();w=this.stack.pop(),this.lsb=w,this.width=y,this.stack.push(y,w,g),S=this.executeCommand(3,h);break;case 3084:if(this.stack.length<2){S=!0;break}const k=this.stack.pop(),x=this.stack.pop();this.stack.push(x/k);break;case 3088:if(this.stack.length<2){S=!0;break}v=this.stack.pop();const A=this.stack.pop();if(0===v&&3===A){const e=this.stack.splice(this.stack.length-17,17);this.stack.push(e[2]+e[0],e[3]+e[1],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14]),S=this.executeCommand(13,c,!0),this.flexing=!1,this.stack.push(e[15],e[16])}else 1===v&&0===A&&(this.flexing=!0);break;case 3089:break;case 3105:this.stack=[];break;default:(0,s.warn)('Unknown type 1 charstring command of "'+b+'"');break}if(S)break}else b<=246?b-=139:b=b<=250?256*(b-247)+g[++k]+108:b<=254?-256*(b-251)-g[++k]-108:(255&g[++k])<<24|(255&g[++k])<<16|(255&g[++k])<<8|(255&g[++k])<<0,this.stack.push(b)}return S}executeCommand(e,t,r){const a=this.stack.length;if(e>a)return!0;const i=a-e;for(let e=i;e<a;e++){let t=this.stack[e];Number.isInteger(t)?this.output.push(28,t>>8&255,255&t):(t=65536*t|0,this.output.push(255,t>>24&255,t>>16&255,t>>8&255,255&t))}return this.output.push.apply(this.output,t),r?this.stack.splice(i,e):this.stack.length=0,!1}}}(),c=function(){function e(e){return e>=48&&e<=57||e>=65&&e<=70||e>=97&&e<=102}function t(e,t,r){if(r>=e.length)return new Uint8Array(0);let a,i,n=0|t;for(a=0;a<r;a++)n=52845*(e[a]+n)+22719&65535;const s=e.length-r,o=new Uint8Array(s);for(a=r,i=0;i<s;a++,i++){const t=e[a];o[i]=t^n>>8,n=52845*(t+n)+22719&65535}return o}function r(e){return 47===e||91===e||93===e||123===e||125===e||40===e||41===e}return class{constructor(r,a,s){if(a){const a=r.getBytes(),s=!((e(a[0])||(0,i.isWhiteSpace)(a[0]))&&e(a[1])&&e(a[2])&&e(a[3])&&e(a[4])&&e(a[5])&&e(a[6])&&e(a[7]));r=new n.Stream(s?t(a,55665,4):function(t,r,a){let i=0|r;const n=t.length,s=new Uint8Array(n>>>1);let o,c;for(o=0,c=0;o<n;o++){const r=t[o];if(!e(r))continue;let a;for(o++;o<n&&!e(a=t[o]);)o++;if(o<n){const e=parseInt(String.fromCharCode(r,a),16);s[c++]=e^i>>8,i=52845*(e+i)+22719&65535}}return s.slice(a,c)}(a,55665,4))}this.seacAnalysisEnabled=!!s,this.stream=r,this.nextChar()}readNumberArray(){this.getToken();const e=[];for(;;){const t=this.getToken();if(null===t||"]"===t||"}"===t)break;e.push(parseFloat(t||0))}return e}readNumber(){const e=this.getToken();return parseFloat(e||0)}readInt(){const e=this.getToken();return 0|parseInt(e||0,10)}readBoolean(){return"true"===this.getToken()?1:0}nextChar(){return this.currentChar=this.stream.getByte()}getToken(){let e=!1,t=this.currentChar;for(;;){if(-1===t)return null;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(!(0,i.isWhiteSpace)(t))break;t=this.nextChar()}if(r(t))return this.nextChar(),String.fromCharCode(t);let a="";do{a+=String.fromCharCode(t),t=this.nextChar()}while(t>=0&&!(0,i.isWhiteSpace)(t)&&!r(t));return a}readCharStrings(e,r){return-1===r?e:t(e,4330,r)}extractFontProgram(e){const t=this.stream,r=[],a=[],i=Object.create(null);i.lenIV=4;const n={subrs:[],charstrings:[],properties:{privateData:i}};let s,c,l,h,u;for(;null!==(s=this.getToken());)if("/"===s)switch(s=this.getToken(),s){case"CharStrings":for(this.getToken(),this.getToken(),this.getToken(),this.getToken();s=this.getToken(),null!==s&&"end"!==s;){if("/"!==s)continue;const e=this.getToken();c=this.readInt(),this.getToken(),l=c>0?t.getBytes(c):new Uint8Array(0),h=n.properties.privateData.lenIV,u=this.readCharStrings(l,h),this.nextChar(),s=this.getToken(),"noaccess"===s&&this.getToken(),a.push({glyph:e,encoded:u})}break;case"Subrs":for(this.readInt(),this.getToken();"dup"===this.getToken();){const e=this.readInt();c=this.readInt(),this.getToken(),l=c>0?t.getBytes(c):new Uint8Array(0),h=n.properties.privateData.lenIV,u=this.readCharStrings(l,h),this.nextChar(),s=this.getToken(),"noaccess"===s&&this.getToken(),r[e]=u}break;case"BlueValues":case"OtherBlues":case"FamilyBlues":case"FamilyOtherBlues":const e=this.readNumberArray();e.length>0&&e.length,0;break;case"StemSnapH":case"StemSnapV":n.properties.privateData[s]=this.readNumberArray();break;case"StdHW":case"StdVW":n.properties.privateData[s]=this.readNumberArray()[0];break;case"BlueShift":case"lenIV":case"BlueFuzz":case"BlueScale":case"LanguageGroup":case"ExpansionFactor":n.properties.privateData[s]=this.readNumber();break;case"ForceBold":n.properties.privateData[s]=this.readBoolean();break}for(let t=0;t<a.length;t++){const i=a[t].glyph;u=a[t].encoded;const s=new o,c=s.convert(u,r,this.seacAnalysisEnabled);let l=s.output;c&&(l=[14]);const h={glyphName:i,charstring:l,width:s.width,lsb:s.lsb,seac:s.seac};if(".notdef"===i?n.charstrings.unshift(h):n.charstrings.push(h),e.builtInEncoding){const t=e.builtInEncoding.indexOf(i);t>-1&&void 0===e.widths[t]&&t>=e.firstChar&&t<=e.lastChar&&(e.widths[t]=s.width)}}return n}extractFontHeader(e){let t;for(;null!==(t=this.getToken());)if("/"===t)switch(t=this.getToken(),t){case"FontMatrix":const r=this.readNumberArray();e.fontMatrix=r;break;case"Encoding":const i=this.getToken();let n;if(/^\d+$/.test(i)){n=[];const e=0|parseInt(i,10);this.getToken();for(let r=0;r<e;r++){for(t=this.getToken();"dup"!==t&&"def"!==t;)if(t=this.getToken(),null===t)return;if("def"===t)break;const e=this.readInt();this.getToken();const r=this.getToken();n[e]=r,this.getToken()}}else n=(0,a.getEncoding)(i);e.builtInEncoding=n;break;case"FontBBox":const s=this.readNumberArray();e.ascent=Math.max(s[3],s[1]),e.descent=Math.min(s[1],s[3]),e.ascentScaled=!0;break}}}}();t.Type1Parser=c},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getTilingPatternIR=function(e,t,r){const i=t.getArray("Matrix"),n=a.Util.normalizeRect(t.getArray("BBox")),s=t.get("XStep"),o=t.get("YStep"),c=t.get("PaintType"),l=t.get("TilingType");if(n[2]-n[0]==0||n[3]-n[1]==0)throw new a.FormatError(`Invalid getTilingPatternIR /BBox array: [${n}].`);return["TilingPattern",r,e,i,n,s,o,c,l]},t.Pattern=void 0;var a=r(2),i=r(23),n=r(5),s=r(8);const o=2,c=3,l=4,h=5,u=6,d=7,f=function(){function e(){(0,a.unreachable)("should not call Pattern constructor")}return e.prototype={getPattern:function(e){(0,a.unreachable)(`Should not call Pattern.getStyle: ${e}`)}},e.parseShading=function(e,t,r,i,f,p,m){const b=(0,n.isStream)(e)?e.dict:e,y=b.get("ShadingType");try{switch(y){case o:case c:return new g.RadialAxial(b,t,r,i,p,m);case l:case h:case u:case d:return new g.Mesh(e,t,r,i,p,m);default:throw new a.FormatError("Unsupported ShadingType: "+y)}}catch(e){if(e instanceof s.MissingDataException)throw e;return f.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.shadingPattern}),(0,a.warn)(e),new g.Dummy}},e}();t.Pattern=f;const g={};g.SMALL_NUMBER=1e-6,g.RadialAxial=function(){function e(e,t,r,n,s,o){this.matrix=t,this.coordsArr=e.getArray("Coords"),this.shadingType=e.get("ShadingType"),this.type="Pattern";const l=i.ColorSpace.parse({cs:e.getRaw("ColorSpace")||e.getRaw("CS"),xref:r,resources:n,pdfFunctionFactory:s,localColorSpaceCache:o});this.cs=l;const h=e.getArray("BBox");Array.isArray(h)&&4===h.length?this.bbox=a.Util.normalizeRect(h):this.bbox=null;let u=0,d=1;if(e.has("Domain")){const t=e.getArray("Domain");u=t[0],d=t[1]}let f=!1,p=!1;if(e.has("Extend")){const t=e.getArray("Extend");f=t[0],p=t[1]}if(!(this.shadingType!==c||f&&p)){const[e,t,r,i,n,s]=this.coordsArr,o=Math.hypot(e-i,t-n);r<=s+o&&s<=r+o&&(0,a.warn)("Unsupported radial gradient.")}this.extendStart=f,this.extendEnd=p;const m=e.getRaw("Function"),b=s.createFromArray(m),y=(d-u)/10,w=this.colorStops=[];if(u>=d||y<=0)return void(0,a.info)("Bad shading domain.");const v=new Float32Array(l.numComps),S=new Float32Array(1);let k;for(let e=0;e<=10;e++){S[0]=u+e*y,b(S,0,v,0),k=l.getRgb(v,0);const t=a.Util.makeHexColor(k[0],k[1],k[2]);w.push([e/10,t])}let x="transparent";e.has("Background")&&(k=l.getRgb(e.get("Background"),0),x=a.Util.makeHexColor(k[0],k[1],k[2])),f||(w.unshift([0,x]),w[1][0]+=g.SMALL_NUMBER),p||(w[w.length-1][0]-=g.SMALL_NUMBER,w.push([1,x])),this.colorStops=w}return e.prototype={getIR:function(){const e=this.coordsArr,t=this.shadingType;let r,i,n,s,l;t===o?(i=[e[0],e[1]],n=[e[2],e[3]],s=null,l=null,r="axial"):t===c?(i=[e[0],e[1]],n=[e[3],e[4]],s=e[2],l=e[5],r="radial"):(0,a.unreachable)(`getPattern type unknown: ${t}`);const h=this.matrix;if(h&&(i=a.Util.applyTransform(i,h),n=a.Util.applyTransform(n,h),t===c)){const e=a.Util.singularValueDecompose2dScale(h);s*=e[0],l*=e[1]}return["RadialAxial",r,this.bbox,this.colorStops,i,n,s,l]}},e}(),g.Mesh=function(){function e(e,t){this.stream=e,this.context=t,this.buffer=0,this.bufferLength=0;const r=t.numComps;this.tmpCompsBuf=new Float32Array(r);const a=t.colorSpace.numComps;this.tmpCsCompsBuf=t.colorFn?new Float32Array(a):this.tmpCompsBuf}e.prototype={get hasData(){if(this.stream.end)return this.stream.pos<this.stream.end;if(this.bufferLength>0)return!0;const e=this.stream.getByte();return!(e<0)&&(this.buffer=e,this.bufferLength=8,!0)},readBits:function(e){let t=this.buffer,r=this.bufferLength;if(32===e){if(0===r)return(this.stream.getByte()<<24|this.stream.getByte()<<16|this.stream.getByte()<<8|this.stream.getByte())>>>0;t=t<<24|this.stream.getByte()<<16|this.stream.getByte()<<8|this.stream.getByte();const e=this.stream.getByte();return this.buffer=e&(1<<r)-1,(t<<8-r|(255&e)>>r)>>>0}if(8===e&&0===r)return this.stream.getByte();for(;r<e;)t=t<<8|this.stream.getByte(),r+=8;return r-=e,this.bufferLength=r,this.buffer=t&(1<<r)-1,t>>r},align:function(){this.buffer=0,this.bufferLength=0},readFlag:function(){return this.readBits(this.context.bitsPerFlag)},readCoordinate:function(){const e=this.context.bitsPerCoordinate,t=this.readBits(e),r=this.readBits(e),a=this.context.decode,i=e<32?1/((1<<e)-1):2.3283064365386963e-10;return[t*i*(a[1]-a[0])+a[0],r*i*(a[3]-a[2])+a[2]]},readComponents:function(){const e=this.context.numComps,t=this.context.bitsPerComponent,r=t<32?1/((1<<t)-1):2.3283064365386963e-10,a=this.context.decode,i=this.tmpCompsBuf;for(let n=0,s=4;n<e;n++,s+=2){const e=this.readBits(t);i[n]=e*r*(a[s+1]-a[s])+a[s]}const n=this.tmpCsCompsBuf;return this.context.colorFn&&this.context.colorFn(i,0,n,0),this.context.colorSpace.getRgb(n,0)}};const t=function(){const e=[];return function(t){return e[t]||(e[t]=function(e){const t=[];for(let r=0;r<=e;r++){const a=r/e,i=1-a;t.push(new Float32Array([i*i*i,3*a*i*i,3*a*a*i,a*a*a]))}return t}(t)),e[t]}}();function r(e,r){const i=e.figures[r];(0,a.assert)("patch"===i.type,"Unexpected patch mesh figure");const n=e.coords,s=e.colors,o=i.coords,c=i.colors,l=Math.min(n[o[0]][0],n[o[3]][0],n[o[12]][0],n[o[15]][0]),h=Math.min(n[o[0]][1],n[o[3]][1],n[o[12]][1],n[o[15]][1]),u=Math.max(n[o[0]][0],n[o[3]][0],n[o[12]][0],n[o[15]][0]),d=Math.max(n[o[0]][1],n[o[3]][1],n[o[12]][1],n[o[15]][1]);let f=Math.ceil(20*(u-l)/(e.bounds[2]-e.bounds[0]));f=Math.max(3,Math.min(20,f));let g=Math.ceil(20*(d-h)/(e.bounds[3]-e.bounds[1]));g=Math.max(3,Math.min(20,g));const p=f+1,m=new Int32Array((g+1)*p),b=new Int32Array((g+1)*p);let y=0;const w=new Uint8Array(3),v=new Uint8Array(3),S=s[c[0]],k=s[c[1]],x=s[c[2]],A=s[c[3]],C=t(g),O=t(f);for(let e=0;e<=g;e++){w[0]=(S[0]*(g-e)+x[0]*e)/g|0,w[1]=(S[1]*(g-e)+x[1]*e)/g|0,w[2]=(S[2]*(g-e)+x[2]*e)/g|0,v[0]=(k[0]*(g-e)+A[0]*e)/g|0,v[1]=(k[1]*(g-e)+A[1]*e)/g|0,v[2]=(k[2]*(g-e)+A[2]*e)/g|0;for(let t=0;t<=f;t++,y++){if(!(0!==e&&e!==g||0!==t&&t!==f))continue;let r=0,a=0,i=0;for(let s=0;s<=3;s++)for(let c=0;c<=3;c++,i++){const l=C[e][s]*O[t][c];r+=n[o[i]][0]*l,a+=n[o[i]][1]*l}m[y]=n.length,n.push([r,a]),b[y]=s.length;const c=new Uint8Array(3);c[0]=(w[0]*(f-t)+v[0]*t)/f|0,c[1]=(w[1]*(f-t)+v[1]*t)/f|0,c[2]=(w[2]*(f-t)+v[2]*t)/f|0,s.push(c)}}m[0]=o[0],b[0]=c[0],m[f]=o[3],b[f]=c[1],m[p*g]=o[12],b[p*g]=c[2],m[p*g+f]=o[15],b[p*g+f]=c[3],e.figures[r]={type:"lattice",coords:m,colors:b,verticesPerRow:p}}function s(e){let t=e.coords[0][0],r=e.coords[0][1],a=t,i=r;for(let n=1,s=e.coords.length;n<s;n++){const s=e.coords[n][0],o=e.coords[n][1];t=t>s?s:t,r=r>o?o:r,a=a<s?s:a,i=i<o?o:i}e.bounds=[t,r,a,i]}function o(t,o,c,f,g,p){if(!(0,n.isStream)(t))throw new a.FormatError("Mesh data is not a stream");const m=t.dict;this.matrix=o,this.shadingType=m.get("ShadingType"),this.type="Pattern";const b=m.getArray("BBox");Array.isArray(b)&&4===b.length?this.bbox=a.Util.normalizeRect(b):this.bbox=null;const y=i.ColorSpace.parse({cs:m.getRaw("ColorSpace")||m.getRaw("CS"),xref:c,resources:f,pdfFunctionFactory:g,localColorSpaceCache:p});this.cs=y,this.background=m.has("Background")?y.getRgb(m.get("Background"),0):null;const w=m.getRaw("Function"),v=w?g.createFromArray(w):null;this.coords=[],this.colors=[],this.figures=[];const S=new e(t,{bitsPerCoordinate:m.get("BitsPerCoordinate"),bitsPerComponent:m.get("BitsPerComponent"),bitsPerFlag:m.get("BitsPerFlag"),decode:m.getArray("Decode"),colorFn:v,colorSpace:y,numComps:v?1:y.numComps});let k=!1;switch(this.shadingType){case l:!function(e,t){const r=e.coords,i=e.colors,n=[],s=[];let o=0;for(;t.hasData;){const e=t.readFlag(),c=t.readCoordinate(),l=t.readComponents();if(0===o){if(!(0<=e&&e<=2))throw new a.FormatError("Unknown type4 flag");switch(e){case 0:o=3;break;case 1:s.push(s[s.length-2],s[s.length-1]),o=1;break;case 2:s.push(s[s.length-3],s[s.length-1]),o=1;break}n.push(e)}s.push(r.length),r.push(c),i.push(l),o--,t.align()}e.figures.push({type:"triangles",coords:new Int32Array(s),colors:new Int32Array(s)})}(this,S);break;case h:const e=0|m.get("VerticesPerRow");if(e<2)throw new a.FormatError("Invalid VerticesPerRow");!function(e,t,r){const a=e.coords,i=e.colors,n=[];for(;t.hasData;){const e=t.readCoordinate(),r=t.readComponents();n.push(a.length),a.push(e),i.push(r)}e.figures.push({type:"lattice",coords:new Int32Array(n),colors:new Int32Array(n),verticesPerRow:r})}(this,S,e);break;case u:!function(e,t){const r=e.coords,i=e.colors,n=new Int32Array(16),s=new Int32Array(4);for(;t.hasData;){const o=t.readFlag();if(!(0<=o&&o<=3))throw new a.FormatError("Unknown type6 flag");const c=r.length;for(let e=0,a=0!==o?8:12;e<a;e++)r.push(t.readCoordinate());const l=i.length;for(let e=0,r=0!==o?2:4;e<r;e++)i.push(t.readComponents());let h,u,d,f;switch(o){case 0:n[12]=c+3,n[13]=c+4,n[14]=c+5,n[15]=c+6,n[8]=c+2,n[11]=c+7,n[4]=c+1,n[7]=c+8,n[0]=c,n[1]=c+11,n[2]=c+10,n[3]=c+9,s[2]=l+1,s[3]=l+2,s[0]=l,s[1]=l+3;break;case 1:h=n[12],u=n[13],d=n[14],f=n[15],n[12]=f,n[13]=c+0,n[14]=c+1,n[15]=c+2,n[8]=d,n[11]=c+3,n[4]=u,n[7]=c+4,n[0]=h,n[1]=c+7,n[2]=c+6,n[3]=c+5,h=s[2],u=s[3],s[2]=u,s[3]=l,s[0]=h,s[1]=l+1;break;case 2:h=n[15],u=n[11],n[12]=n[3],n[13]=c+0,n[14]=c+1,n[15]=c+2,n[8]=n[7],n[11]=c+3,n[4]=u,n[7]=c+4,n[0]=h,n[1]=c+7,n[2]=c+6,n[3]=c+5,h=s[3],s[2]=s[1],s[3]=l,s[0]=h,s[1]=l+1;break;case 3:n[12]=n[0],n[13]=c+0,n[14]=c+1,n[15]=c+2,n[8]=n[1],n[11]=c+3,n[4]=n[2],n[7]=c+4,n[0]=n[3],n[1]=c+7,n[2]=c+6,n[3]=c+5,s[2]=s[0],s[3]=l,s[0]=s[1],s[1]=l+1;break}n[5]=r.length,r.push([(-4*r[n[0]][0]-r[n[15]][0]+6*(r[n[4]][0]+r[n[1]][0])-2*(r[n[12]][0]+r[n[3]][0])+3*(r[n[13]][0]+r[n[7]][0]))/9,(-4*r[n[0]][1]-r[n[15]][1]+6*(r[n[4]][1]+r[n[1]][1])-2*(r[n[12]][1]+r[n[3]][1])+3*(r[n[13]][1]+r[n[7]][1]))/9]),n[6]=r.length,r.push([(-4*r[n[3]][0]-r[n[12]][0]+6*(r[n[2]][0]+r[n[7]][0])-2*(r[n[0]][0]+r[n[15]][0])+3*(r[n[4]][0]+r[n[14]][0]))/9,(-4*r[n[3]][1]-r[n[12]][1]+6*(r[n[2]][1]+r[n[7]][1])-2*(r[n[0]][1]+r[n[15]][1])+3*(r[n[4]][1]+r[n[14]][1]))/9]),n[9]=r.length,r.push([(-4*r[n[12]][0]-r[n[3]][0]+6*(r[n[8]][0]+r[n[13]][0])-2*(r[n[0]][0]+r[n[15]][0])+3*(r[n[11]][0]+r[n[1]][0]))/9,(-4*r[n[12]][1]-r[n[3]][1]+6*(r[n[8]][1]+r[n[13]][1])-2*(r[n[0]][1]+r[n[15]][1])+3*(r[n[11]][1]+r[n[1]][1]))/9]),n[10]=r.length,r.push([(-4*r[n[15]][0]-r[n[0]][0]+6*(r[n[11]][0]+r[n[14]][0])-2*(r[n[12]][0]+r[n[3]][0])+3*(r[n[2]][0]+r[n[8]][0]))/9,(-4*r[n[15]][1]-r[n[0]][1]+6*(r[n[11]][1]+r[n[14]][1])-2*(r[n[12]][1]+r[n[3]][1])+3*(r[n[2]][1]+r[n[8]][1]))/9]),e.figures.push({type:"patch",coords:new Int32Array(n),colors:new Int32Array(s)})}}(this,S),k=!0;break;case d:!function(e,t){const r=e.coords,i=e.colors,n=new Int32Array(16),s=new Int32Array(4);for(;t.hasData;){const o=t.readFlag();if(!(0<=o&&o<=3))throw new a.FormatError("Unknown type7 flag");const c=r.length;for(let e=0,a=0!==o?12:16;e<a;e++)r.push(t.readCoordinate());const l=i.length;for(let e=0,r=0!==o?2:4;e<r;e++)i.push(t.readComponents());let h,u,d,f;switch(o){case 0:n[12]=c+3,n[13]=c+4,n[14]=c+5,n[15]=c+6,n[8]=c+2,n[9]=c+13,n[10]=c+14,n[11]=c+7,n[4]=c+1,n[5]=c+12,n[6]=c+15,n[7]=c+8,n[0]=c,n[1]=c+11,n[2]=c+10,n[3]=c+9,s[2]=l+1,s[3]=l+2,s[0]=l,s[1]=l+3;break;case 1:h=n[12],u=n[13],d=n[14],f=n[15],n[12]=f,n[13]=c+0,n[14]=c+1,n[15]=c+2,n[8]=d,n[9]=c+9,n[10]=c+10,n[11]=c+3,n[4]=u,n[5]=c+8,n[6]=c+11,n[7]=c+4,n[0]=h,n[1]=c+7,n[2]=c+6,n[3]=c+5,h=s[2],u=s[3],s[2]=u,s[3]=l,s[0]=h,s[1]=l+1;break;case 2:h=n[15],u=n[11],n[12]=n[3],n[13]=c+0,n[14]=c+1,n[15]=c+2,n[8]=n[7],n[9]=c+9,n[10]=c+10,n[11]=c+3,n[4]=u,n[5]=c+8,n[6]=c+11,n[7]=c+4,n[0]=h,n[1]=c+7,n[2]=c+6,n[3]=c+5,h=s[3],s[2]=s[1],s[3]=l,s[0]=h,s[1]=l+1;break;case 3:n[12]=n[0],n[13]=c+0,n[14]=c+1,n[15]=c+2,n[8]=n[1],n[9]=c+9,n[10]=c+10,n[11]=c+3,n[4]=n[2],n[5]=c+8,n[6]=c+11,n[7]=c+4,n[0]=n[3],n[1]=c+7,n[2]=c+6,n[3]=c+5,s[2]=s[0],s[3]=l,s[0]=s[1],s[1]=l+1;break}e.figures.push({type:"patch",coords:new Int32Array(n),colors:new Int32Array(s)})}}(this,S),k=!0;break;default:(0,a.unreachable)("Unsupported mesh type.");break}if(k){s(this);for(let e=0,t=this.figures.length;e<t;e++)r(this,e)}s(this),function(e){let t,r,a,i;const n=e.coords,s=new Float32Array(2*n.length);for(t=0,a=0,r=n.length;t<r;t++){const e=n[t];s[a++]=e[0],s[a++]=e[1]}e.coords=s;const o=e.colors,c=new Uint8Array(3*o.length);for(t=0,a=0,r=o.length;t<r;t++){const e=o[t];c[a++]=e[0],c[a++]=e[1],c[a++]=e[2]}e.colors=c;const l=e.figures;for(t=0,r=l.length;t<r;t++){const e=l[t],r=e.coords,n=e.colors;for(a=0,i=r.length;a<i;a++)r[a]*=2,n[a]*=3}}(this)}return o.prototype={getIR:function(){return["Mesh",this.shadingType,this.coords,this.colors,this.figures,this.bounds,this.matrix,this.bbox,this.background]}},o}(),g.Dummy=function(){function e(){this.type="Pattern"}return e.prototype={getIR:function(){return["Dummy"]}},e}()},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.isPDFFunction=function(e){var t;if("object"!=typeof e)return!1;if((0,a.isDict)(e))t=e;else{if(!(0,a.isStream)(e))return!1;t=e.dict}return t.has("FunctionType")},t.PostScriptEvaluator=t.PostScriptCompiler=t.PDFFunctionFactory=void 0;var a=r(5),i=r(2),n=r(42),s=r(24);function o(e){if(!Array.isArray(e))return null;const t=e.length;for(let r=0;r<t;r++)if("number"!=typeof e[r]){const r=new Array(t);for(let a=0;a<t;a++)r[a]=+e[a];return r}return e}t.PDFFunctionFactory=class{constructor({xref:e,isEvalSupported:t=!0}){this.xref=e,this.isEvalSupported=!1!==t}create(e){const t=this.getCached(e);if(t)return t;const r=c.parse({xref:this.xref,isEvalSupported:this.isEvalSupported,fn:e instanceof a.Ref?this.xref.fetch(e):e});return this._cache(e,r),r}createFromArray(e){const t=this.getCached(e);if(t)return t;const r=c.parseArray({xref:this.xref,isEvalSupported:this.isEvalSupported,fnObj:e instanceof a.Ref?this.xref.fetch(e):e});return this._cache(e,r),r}getCached(e){let t;if(e instanceof a.Ref?t=e:e instanceof a.Dict?t=e.objId:(0,a.isStream)(e)&&(t=e.dict&&e.dict.objId),t){const e=this._localFunctionCache.getByRef(t);if(e)return e}return null}_cache(e,t){if(!t)throw new Error('PDFFunctionFactory._cache - expected "parsedFunction" argument.');let r;e instanceof a.Ref?r=e:e instanceof a.Dict?r=e.objId:(0,a.isStream)(e)&&(r=e.dict&&e.dict.objId),r&&this._localFunctionCache.set(null,r,t)}get _localFunctionCache(){return(0,i.shadow)(this,"_localFunctionCache",new s.LocalFunctionCache)}};var c={getSampleArray(e,t,r,a){var i,n,s=1;for(i=0,n=e.length;i<n;i++)s*=e[i];s*=t;var o=new Array(s),c=0,l=0,h=1/(2**r-1),u=a.getBytes((s*r+7)/8),d=0;for(i=0;i<s;i++){for(;c<r;)l<<=8,l|=u[d++],c+=8;c-=r,o[i]=(l>>c)*h,l&=(1<<c)-1}return o},getIR({xref:e,isEvalSupported:t,fn:r}){var a=r.dict;a||(a=r);var n=[this.constructSampled,null,this.constructInterpolated,this.constructStiched,this.constructPostScript][a.get("FunctionType")];if(!n)throw new i.FormatError("Unknown type of function");return n.call(this,{xref:e,isEvalSupported:t,fn:r,dict:a})},fromIR({xref:e,isEvalSupported:t,IR:r}){switch(r[0]){case 0:return this.constructSampledFromIR({xref:e,isEvalSupported:t,IR:r});case 2:return this.constructInterpolatedFromIR({xref:e,isEvalSupported:t,IR:r});case 3:return this.constructStichedFromIR({xref:e,isEvalSupported:t,IR:r});default:return this.constructPostScriptFromIR({xref:e,isEvalSupported:t,IR:r})}},parse({xref:e,isEvalSupported:t,fn:r}){const a=this.getIR({xref:e,isEvalSupported:t,fn:r});return this.fromIR({xref:e,isEvalSupported:t,IR:a})},parseArray({xref:e,isEvalSupported:t,fnObj:r}){if(!Array.isArray(r))return this.parse({xref:e,isEvalSupported:t,fn:r});for(var a=[],i=0,n=r.length;i<n;i++)a.push(this.parse({xref:e,isEvalSupported:t,fn:e.fetchIfRef(r[i])}));return function(e,t,r,i){for(var n=0,s=a.length;n<s;n++)a[n](e,t,r,i+n)}},constructSampled({xref:e,isEvalSupported:t,fn:r,dict:a}){function n(e){for(var t=e.length,r=[],a=0,i=0;i<t;i+=2)r[a]=[e[i],e[i+1]],++a;return r}var s=o(a.getArray("Domain")),c=o(a.getArray("Range"));if(!s||!c)throw new i.FormatError("No domain or range");var l=s.length/2,h=c.length/2;s=n(s),c=n(c);var u=o(a.getArray("Size")),d=a.get("BitsPerSample"),f=a.get("Order")||1;1!==f&&(0,i.info)("No support for cubic spline interpolation: "+f);var g=o(a.getArray("Encode"));if(g)g=n(g);else{g=[];for(var p=0;p<l;++p)g.push([0,u[p]-1])}var m=o(a.getArray("Decode"));return[0,l,s,g,m=m?n(m):c,this.getSampleArray(u,h,d,r),u,h,2**d-1,c]},constructSampledFromIR({xref:e,isEvalSupported:t,IR:r}){function a(e,t,r,a,i){return a+(i-a)/(r-t)*(e-t)}return function(e,t,i,n){var s,o,c=r[1],l=r[2],h=r[3],u=r[4],d=r[5],f=r[6],g=r[7],p=r[9],m=1<<c,b=new Float64Array(m),y=new Uint32Array(m);for(o=0;o<m;o++)b[o]=1;var w=g,v=1;for(s=0;s<c;++s){var S=l[s][0],k=l[s][1],x=a(Math.min(Math.max(e[t+s],S),k),S,k,h[s][0],h[s][1]),A=f[s],C=(x=Math.min(Math.max(x,0),A-1))<A-1?Math.floor(x):x-1,O=C+1-x,F=x-C,I=C*w,T=I+w;for(o=0;o<m;o++)o&v?(b[o]*=F,y[o]+=T):(b[o]*=O,y[o]+=I);w*=A,v<<=1}for(o=0;o<g;++o){var P=0;for(s=0;s<m;s++)P+=d[y[s]+o]*b[s];P=a(P,0,1,u[o][0],u[o][1]),i[n+o]=Math.min(Math.max(P,p[o][0]),p[o][1])}}},constructInterpolated({xref:e,isEvalSupported:t,fn:r,dict:a}){for(var i=o(a.getArray("C0"))||[0],n=o(a.getArray("C1"))||[1],s=a.get("N"),c=i.length,l=[],h=0;h<c;++h)l.push(n[h]-i[h]);return[2,i,l,s]},constructInterpolatedFromIR({xref:e,isEvalSupported:t,IR:r}){var a=r[1],i=r[2],n=r[3],s=i.length;return function(e,t,r,o){for(var c=1===n?e[t]:e[t]**n,l=0;l<s;++l)r[o+l]=a[l]+c*i[l]}},constructStiched({xref:e,isEvalSupported:t,fn:r,dict:a}){var n=o(a.getArray("Domain"));if(!n)throw new i.FormatError("No domain");if(1!=n.length/2)throw new i.FormatError("Bad domain for stiched function");for(var s=a.get("Functions"),c=[],l=0,h=s.length;l<h;++l)c.push(this.parse({xref:e,isEvalSupported:t,fn:e.fetchIfRef(s[l])}));return[3,n,o(a.getArray("Bounds")),o(a.getArray("Encode")),c]},constructStichedFromIR({xref:e,isEvalSupported:t,IR:r}){var a=r[1],i=r[2],n=r[3],s=r[4],o=new Float32Array(1);return function(e,t,r,c){for(var l=function(e,t,r){return e>r?e=r:e<t&&(e=t),e}(e[t],a[0],a[1]),h=0,u=i.length;h<u&&!(l<i[h]);++h);var d=a[0];h>0&&(d=i[h-1]);var f=a[1];h<i.length&&(f=i[h]);var g=n[2*h],p=n[2*h+1];o[0]=d===f?g:g+(l-d)*(p-g)/(f-d),s[h](o,0,r,c)}},constructPostScript({xref:e,isEvalSupported:t,fn:r,dict:a}){var s=o(a.getArray("Domain")),c=o(a.getArray("Range"));if(!s)throw new i.FormatError("No domain.");if(!c)throw new i.FormatError("No range.");var l=new n.PostScriptLexer(r);return[4,s,c,new n.PostScriptParser(l).parse()]},constructPostScriptFromIR({xref:e,isEvalSupported:t,IR:r}){var a=r[1],n=r[2],s=r[3];if(t&&i.IsEvalSupportedCached.value){const e=(new u).compile(s,a,n);if(e)return new Function("src","srcOffset","dest","destOffset",e)}(0,i.info)("Unable to compile PS function");var o=n.length>>1,c=a.length>>1,l=new h(s),d=Object.create(null),f=8192,g=new Float32Array(c);return function(e,t,r,a){var i,s,h="",u=g;for(i=0;i<c;i++)s=e[t+i],u[i]=s,h+=s+"_";var p=d[h];if(void 0===p){var m=new Float32Array(o),b=l.execute(u),y=b.length-o;for(i=0;i<o;i++){s=b[y+i];var w=n[2*i];(s<w||s>(w=n[2*i+1]))&&(s=w),m[i]=s}f>0&&(f--,d[h]=m),r.set(m,a)}else r.set(p,a)}}};var l=class{constructor(e){this.stack=e?Array.prototype.slice.call(e,0):[]}push(e){if(this.stack.length>=100)throw new Error("PostScript function stack overflow.");this.stack.push(e)}pop(){if(this.stack.length<=0)throw new Error("PostScript function stack underflow.");return this.stack.pop()}copy(e){if(this.stack.length+e>=100)throw new Error("PostScript function stack overflow.");for(var t=this.stack,r=t.length-e,a=e-1;a>=0;a--,r++)t.push(t[r])}index(e){this.push(this.stack[this.stack.length-e-1])}roll(e,t){var r,a,i,n=this.stack,s=n.length-e,o=n.length-1,c=s+(t-Math.floor(t/e)*e);for(r=s,a=o;r<a;r++,a--)i=n[r],n[r]=n[a],n[a]=i;for(r=s,a=c-1;r<a;r++,a--)i=n[r],n[r]=n[a],n[a]=i;for(r=c,a=o;r<a;r++,a--)i=n[r],n[r]=n[a],n[a]=i}};class h{constructor(e){this.operators=e}execute(e){for(var t,r,a,n=new l(e),s=0,o=this.operators,c=o.length;s<c;)if("number"!=typeof(t=o[s++]))switch(t){case"jz":a=n.pop(),(r=n.pop())||(s=a);break;case"j":s=r=n.pop();break;case"abs":r=n.pop(),n.push(Math.abs(r));break;case"add":a=n.pop(),r=n.pop(),n.push(r+a);break;case"and":a=n.pop(),r=n.pop(),(0,i.isBool)(r)&&(0,i.isBool)(a)?n.push(r&&a):n.push(r&a);break;case"atan":r=n.pop(),n.push(Math.atan(r));break;case"bitshift":a=n.pop(),(r=n.pop())>0?n.push(r<<a):n.push(r>>a);break;case"ceiling":r=n.pop(),n.push(Math.ceil(r));break;case"copy":r=n.pop(),n.copy(r);break;case"cos":r=n.pop(),n.push(Math.cos(r));break;case"cvi":r=0|n.pop(),n.push(r);break;case"cvr":break;case"div":a=n.pop(),r=n.pop(),n.push(r/a);break;case"dup":n.copy(1);break;case"eq":a=n.pop(),r=n.pop(),n.push(r===a);break;case"exch":n.roll(2,1);break;case"exp":a=n.pop(),r=n.pop(),n.push(r**a);break;case"false":n.push(!1);break;case"floor":r=n.pop(),n.push(Math.floor(r));break;case"ge":a=n.pop(),r=n.pop(),n.push(r>=a);break;case"gt":a=n.pop(),r=n.pop(),n.push(r>a);break;case"idiv":a=n.pop(),r=n.pop(),n.push(r/a|0);break;case"index":r=n.pop(),n.index(r);break;case"le":a=n.pop(),r=n.pop(),n.push(r<=a);break;case"ln":r=n.pop(),n.push(Math.log(r));break;case"log":r=n.pop(),n.push(Math.log(r)/Math.LN10);break;case"lt":a=n.pop(),r=n.pop(),n.push(r<a);break;case"mod":a=n.pop(),r=n.pop(),n.push(r%a);break;case"mul":a=n.pop(),r=n.pop(),n.push(r*a);break;case"ne":a=n.pop(),r=n.pop(),n.push(r!==a);break;case"neg":r=n.pop(),n.push(-r);break;case"not":r=n.pop(),(0,i.isBool)(r)?n.push(!r):n.push(~r);break;case"or":a=n.pop(),r=n.pop(),(0,i.isBool)(r)&&(0,i.isBool)(a)?n.push(r||a):n.push(r|a);break;case"pop":n.pop();break;case"roll":a=n.pop(),r=n.pop(),n.roll(r,a);break;case"round":r=n.pop(),n.push(Math.round(r));break;case"sin":r=n.pop(),n.push(Math.sin(r));break;case"sqrt":r=n.pop(),n.push(Math.sqrt(r));break;case"sub":a=n.pop(),r=n.pop(),n.push(r-a);break;case"true":n.push(!0);break;case"truncate":r=(r=n.pop())<0?Math.ceil(r):Math.floor(r),n.push(r);break;case"xor":a=n.pop(),r=n.pop(),(0,i.isBool)(r)&&(0,i.isBool)(a)?n.push(r!==a):n.push(r^a);break;default:throw new i.FormatError(`Unknown operator ${t}`)}else n.push(t);return n.stack}}t.PostScriptEvaluator=h;var u=function(){class e{constructor(e){this.type=e}visit(e){(0,i.unreachable)("abstract method")}}class t extends e{constructor(e,t,r){super("args"),this.index=e,this.min=t,this.max=r}visit(e){e.visitArgument(this)}}class r extends e{constructor(e){super("literal"),this.number=e,this.min=e,this.max=e}visit(e){e.visitLiteral(this)}}class a extends e{constructor(e,t,r,a,i){super("binary"),this.op=e,this.arg1=t,this.arg2=r,this.min=a,this.max=i}visit(e){e.visitBinaryOperation(this)}}class n extends e{constructor(e,t){super("max"),this.arg=e,this.min=e.min,this.max=t}visit(e){e.visitMin(this)}}class s extends e{constructor(e,t,r){super("var"),this.index=e,this.min=t,this.max=r}visit(e){e.visitVariable(this)}}class o extends e{constructor(e,t){super("definition"),this.variable=e,this.arg=t}visit(e){e.visitVariableDefinition(this)}}class c{constructor(){this.parts=[]}visitArgument(e){this.parts.push("Math.max(",e.min,", Math.min(",e.max,", src[srcOffset + ",e.index,"]))")}visitVariable(e){this.parts.push("v",e.index)}visitLiteral(e){this.parts.push(e.number)}visitBinaryOperation(e){this.parts.push("("),e.arg1.visit(this),this.parts.push(" ",e.op," "),e.arg2.visit(this),this.parts.push(")")}visitVariableDefinition(e){this.parts.push("var "),e.variable.visit(this),this.parts.push(" = "),e.arg.visit(this),this.parts.push(";")}visitMin(e){this.parts.push("Math.min("),e.arg.visit(this),this.parts.push(", ",e.max,")")}toString(){return this.parts.join("")}}function l(e,t){return"literal"===t.type&&0===t.number?e:"literal"===e.type&&0===e.number?t:"literal"===t.type&&"literal"===e.type?new r(e.number+t.number):new a("+",e,t,e.min+t.min,e.max+t.max)}function h(e,t){if("literal"===t.type){if(0===t.number)return new r(0);if(1===t.number)return e;if("literal"===e.type)return new r(e.number*t.number)}if("literal"===e.type){if(0===e.number)return new r(0);if(1===e.number)return t}var i=Math.min(e.min*t.min,e.min*t.max,e.max*t.min,e.max*t.max),n=Math.max(e.min*t.min,e.min*t.max,e.max*t.min,e.max*t.max);return new a("*",e,t,i,n)}function u(e,t){if("literal"===t.type){if(0===t.number)return e;if("literal"===e.type)return new r(e.number-t.number)}return"binary"===t.type&&"-"===t.op&&"literal"===e.type&&1===e.number&&"literal"===t.arg1.type&&1===t.arg1.number?t.arg2:new a("-",e,t,e.min-t.max,e.max-t.min)}function d(e,t){return e.min>=t?new r(t):e.max<=t?e:new n(e,t)}return class{compile(e,a,i){var n,f,g,p,m,b,y,w,v=[],S=[],k=a.length>>1,x=i.length>>1,A=0;for(let e=0;e<k;e++)v.push(new t(e,a[2*e],a[2*e+1]));for(let t=0,a=e.length;t<a;t++)if("number"!=typeof(w=e[t]))switch(w){case"add":if(v.length<2)return null;p=v.pop(),g=v.pop(),v.push(l(g,p));break;case"cvr":if(v.length<1)return null;break;case"mul":if(v.length<2)return null;p=v.pop(),g=v.pop(),v.push(h(g,p));break;case"sub":if(v.length<2)return null;p=v.pop(),g=v.pop(),v.push(u(g,p));break;case"exch":if(v.length<2)return null;m=v.pop(),b=v.pop(),v.push(m,b);break;case"pop":if(v.length<1)return null;v.pop();break;case"index":if(v.length<1)return null;if("literal"!==(g=v.pop()).type)return null;if((n=g.number)<0||!Number.isInteger(n)||v.length<n)return null;if("literal"===(m=v[v.length-n-1]).type||"var"===m.type){v.push(m);break}y=new s(A++,m.min,m.max),v[v.length-n-1]=y,v.push(y),S.push(new o(y,m));break;case"dup":if(v.length<1)return null;if("number"==typeof e[t+1]&&"gt"===e[t+2]&&e[t+3]===t+7&&"jz"===e[t+4]&&"pop"===e[t+5]&&e[t+6]===e[t+1]){g=v.pop(),v.push(d(g,e[t+1])),t+=6;break}if("literal"===(m=v[v.length-1]).type||"var"===m.type){v.push(m);break}y=new s(A++,m.min,m.max),v[v.length-1]=y,v.push(y),S.push(new o(y,m));break;case"roll":if(v.length<2)return null;if(p=v.pop(),g=v.pop(),"literal"!==p.type||"literal"!==g.type)return null;if(f=p.number,(n=g.number)<=0||!Number.isInteger(n)||!Number.isInteger(f)||v.length<n)return null;if(0===(f=(f%n+n)%n))break;Array.prototype.push.apply(v,v.splice(v.length-n,n-f));break;default:return null}else v.push(new r(w));if(v.length!==x)return null;var C=[];return S.forEach((function(e){var t=new c;e.visit(t),C.push(t.toString())})),v.forEach((function(e,t){var r=new c;e.visit(r);var a=i[2*t],n=i[2*t+1],s=[r.toString()];a>e.min&&(s.unshift("Math.max(",a,", "),s.push(")")),n<e.max&&(s.unshift("Math.min(",n,", "),s.push(")")),s.unshift("dest[destOffset + ",t,"] = "),s.push(";"),C.push(s.join(""))})),C.join("\n")}}}();t.PostScriptCompiler=u},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PostScriptParser=t.PostScriptLexer=void 0;var a=r(2),i=r(5),n=r(8);t.PostScriptParser=class{constructor(e){this.lexer=e,this.operators=[],this.token=null,this.prev=null}nextToken(){this.prev=this.token,this.token=this.lexer.getToken()}accept(e){return this.token.type===e&&(this.nextToken(),!0)}expect(e){if(this.accept(e))return!0;throw new a.FormatError(`Unexpected symbol: found ${this.token.type} expected ${e}.`)}parse(){return this.nextToken(),this.expect(s.LBRACE),this.parseBlock(),this.expect(s.RBRACE),this.operators}parseBlock(){for(;;)if(this.accept(s.NUMBER))this.operators.push(this.prev.value);else if(this.accept(s.OPERATOR))this.operators.push(this.prev.value);else{if(!this.accept(s.LBRACE))return;this.parseCondition()}}parseCondition(){const e=this.operators.length;if(this.operators.push(null,null),this.parseBlock(),this.expect(s.RBRACE),this.accept(s.IF))this.operators[e]=this.operators.length,this.operators[e+1]="jz";else{if(!this.accept(s.LBRACE))throw new a.FormatError("PS Function: error parsing conditional.");{const t=this.operators.length;this.operators.push(null,null);const r=this.operators.length;this.parseBlock(),this.expect(s.RBRACE),this.expect(s.IFELSE),this.operators[t]=this.operators.length,this.operators[t+1]="j",this.operators[e]=r,this.operators[e+1]="jz"}}}};const s={LBRACE:0,RBRACE:1,NUMBER:2,OPERATOR:3,IF:4,IFELSE:5},o=function(){const e=Object.create(null);class t{constructor(e,t){this.type=e,this.value=t}static getOperator(r){const a=e[r];return a||(e[r]=new t(s.OPERATOR,r))}static get LBRACE(){return(0,a.shadow)(this,"LBRACE",new t(s.LBRACE,"{"))}static get RBRACE(){return(0,a.shadow)(this,"RBRACE",new t(s.RBRACE,"}"))}static get IF(){return(0,a.shadow)(this,"IF",new t(s.IF,"IF"))}static get IFELSE(){return(0,a.shadow)(this,"IFELSE",new t(s.IFELSE,"IFELSE"))}}return t}();t.PostScriptLexer=class{constructor(e){this.stream=e,this.nextChar(),this.strBuf=[]}nextChar(){return this.currentChar=this.stream.getByte()}getToken(){let e=!1,t=this.currentChar;for(;;){if(t<0)return i.EOF;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(!(0,n.isWhiteSpace)(t))break;t=this.nextChar()}switch(0|t){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return new o(s.NUMBER,this.getNumber());case 123:return this.nextChar(),o.LBRACE;case 125:return this.nextChar(),o.RBRACE}const r=this.strBuf;for(r.length=0,r[0]=String.fromCharCode(t);(t=this.nextChar())>=0&&(t>=65&&t<=90||t>=97&&t<=122);)r.push(String.fromCharCode(t));const a=r.join("");switch(a.toLowerCase()){case"if":return o.IF;case"ifelse":return o.IFELSE;default:return o.getOperator(a)}}getNumber(){let e=this.currentChar;const t=this.strBuf;for(t.length=0,t[0]=String.fromCharCode(e);(e=this.nextChar())>=0&&(e>=48&&e<=57||45===e||46===e);)t.push(String.fromCharCode(e));const r=parseFloat(t.join(""));if(isNaN(r))throw new a.FormatError(`Invalid floating point number: ${r}`);return r}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.bidi=function(e,t,r){var g=!0,p=e.length;if(0===p||r)return u(e,g,r);d.length=p,f.length=p;var m,b,y=0;for(m=0;m<p;++m){d[m]=e.charAt(m);var w=e.charCodeAt(m),v="L";w<=255?v=i[w]:1424<=w&&w<=1524?v="R":1536<=w&&w<=1791?(v=n[255&w])||(0,a.warn)("Bidi: invalid Unicode character "+w.toString(16)):1792<=w&&w<=2220&&(v="AL"),"R"!==v&&"AL"!==v&&"AN"!==v||y++,f[m]=v}if(0===y)return u(e,g=!0);-1===t&&(y/p<.3?(g=!0,t=0):(g=!1,t=1));var S=[];for(m=0;m<p;++m)S[m]=t;var k,x=s(t)?"R":"L",A=x,C=A,O=A;for(m=0;m<p;++m)"NSM"===f[m]?f[m]=O:O=f[m];for(O=A,m=0;m<p;++m)"EN"===(k=f[m])?f[m]="AL"===O?"AN":"EN":"R"!==k&&"L"!==k&&"AL"!==k||(O=k);for(m=0;m<p;++m)"AL"===(k=f[m])&&(f[m]="R");for(m=1;m<p-1;++m)"ES"===f[m]&&"EN"===f[m-1]&&"EN"===f[m+1]&&(f[m]="EN"),"CS"!==f[m]||"EN"!==f[m-1]&&"AN"!==f[m-1]||f[m+1]!==f[m-1]||(f[m]=f[m-1]);for(m=0;m<p;++m)if("EN"===f[m]){var F;for(F=m-1;F>=0&&"ET"===f[F];--F)f[F]="EN";for(F=m+1;F<p&&"ET"===f[F];++F)f[F]="EN"}for(m=0;m<p;++m)"WS"!==(k=f[m])&&"ES"!==k&&"ET"!==k&&"CS"!==k||(f[m]="ON");for(O=A,m=0;m<p;++m)"EN"===(k=f[m])?f[m]="L"===O?"L":"EN":"R"!==k&&"L"!==k||(O=k);for(m=0;m<p;++m)if("ON"===f[m]){var I=c(f,m+1,"ON"),T=A;m>0&&(T=f[m-1]);var P=C;I+1<p&&(P=f[I+1]),"L"!==T&&(T="R"),"L"!==P&&(P="R"),T===P&&l(f,m,I,T),m=I-1}for(m=0;m<p;++m)"ON"===f[m]&&(f[m]=x);for(m=0;m<p;++m)k=f[m],o(S[m])?"R"===k?S[m]+=1:"AN"!==k&&"EN"!==k||(S[m]+=2):"L"!==k&&"AN"!==k&&"EN"!==k||(S[m]+=1);var E,M=-1,N=99;for(m=0,b=S.length;m<b;++m)E=S[m],M<E&&(M=E),N>E&&s(E)&&(N=E);for(E=M;E>=N;--E){var D=-1;for(m=0,b=S.length;m<b;++m)S[m]<E?D>=0&&(h(d,D,m),D=-1):D<0&&(D=m);D>=0&&h(d,D,S.length)}for(m=0,b=d.length;m<b;++m){var B=d[m];"<"!==B&&">"!==B||(d[m]="")}return u(d.join(""),g)};var a=r(2),i=["BN","BN","BN","BN","BN","BN","BN","BN","BN","S","B","S","WS","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","B","B","B","S","WS","ON","ON","ET","ET","ET","ON","ON","ON","ON","ON","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","ON","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","ON","ON","ON","BN","BN","BN","BN","BN","BN","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","CS","ON","ET","ET","ET","ET","ON","ON","ON","ON","L","ON","ON","BN","ON","ON","ET","ET","EN","EN","ON","L","ON","ON","ON","EN","L","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","L","L","L","L","L","L","L","L"],n=["AN","AN","AN","AN","AN","AN","ON","ON","AL","ET","ET","AL","CS","AL","ON","ON","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","AN","AN","AN","AN","AN","AN","AN","AN","AN","ET","AN","AN","AL","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","ON","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","NSM","NSM","ON","NSM","NSM","NSM","NSM","AL","AL","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","AL","AL","AL","AL","AL","AL"];function s(e){return 0!=(1&e)}function o(e){return 0==(1&e)}function c(e,t,r){for(var a=t,i=e.length;a<i;++a)if(e[a]!==r)return a;return a}function l(e,t,r,a){for(var i=t;i<r;++i)e[i]=a}function h(e,t,r){for(var a=t,i=r-1;a<i;++a,--i){var n=e[a];e[a]=e[i],e[i]=n}}function u(e,t,r=!1){let a="ltr";return r?a="ttb":t||(a="rtl"),{str:e,dir:a}}var d=[],f=[]},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getMetrics=void 0;var a=r(8);const i=(0,a.getLookupTableFactory)((function(e){e.Courier=600,e["Courier-Bold"]=600,e["Courier-BoldOblique"]=600,e["Courier-Oblique"]=600,e.Helvetica=(0,a.getLookupTableFactory)((function(e){e.space=278,e.exclam=278,e.quotedbl=355,e.numbersign=556,e.dollar=556,e.percent=889,e.ampersand=667,e.quoteright=222,e.parenleft=333,e.parenright=333,e.asterisk=389,e.plus=584,e.comma=278,e.hyphen=333,e.period=278,e.slash=278,e.zero=556,e.one=556,e.two=556,e.three=556,e.four=556,e.five=556,e.six=556,e.seven=556,e.eight=556,e.nine=556,e.colon=278,e.semicolon=278,e.less=584,e.equal=584,e.greater=584,e.question=556,e.at=1015,e.A=667,e.B=667,e.C=722,e.D=722,e.E=667,e.F=611,e.G=778,e.H=722,e.I=278,e.J=500,e.K=667,e.L=556,e.M=833,e.N=722,e.O=778,e.P=667,e.Q=778,e.R=722,e.S=667,e.T=611,e.U=722,e.V=667,e.W=944,e.X=667,e.Y=667,e.Z=611,e.bracketleft=278,e.backslash=278,e.bracketright=278,e.asciicircum=469,e.underscore=556,e.quoteleft=222,e.a=556,e.b=556,e.c=500,e.d=556,e.e=556,e.f=278,e.g=556,e.h=556,e.i=222,e.j=222,e.k=500,e.l=222,e.m=833,e.n=556,e.o=556,e.p=556,e.q=556,e.r=333,e.s=500,e.t=278,e.u=556,e.v=500,e.w=722,e.x=500,e.y=500,e.z=500,e.braceleft=334,e.bar=260,e.braceright=334,e.asciitilde=584,e.exclamdown=333,e.cent=556,e.sterling=556,e.fraction=167,e.yen=556,e.florin=556,e.section=556,e.currency=556,e.quotesingle=191,e.quotedblleft=333,e.guillemotleft=556,e.guilsinglleft=333,e.guilsinglright=333,e.fi=500,e.fl=500,e.endash=556,e.dagger=556,e.daggerdbl=556,e.periodcentered=278,e.paragraph=537,e.bullet=350,e.quotesinglbase=222,e.quotedblbase=333,e.quotedblright=333,e.guillemotright=556,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=611,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=1e3,e.ordfeminine=370,e.Lslash=556,e.Oslash=778,e.OE=1e3,e.ordmasculine=365,e.ae=889,e.dotlessi=278,e.lslash=222,e.oslash=611,e.oe=944,e.germandbls=611,e.Idieresis=278,e.eacute=556,e.abreve=556,e.uhungarumlaut=556,e.ecaron=556,e.Ydieresis=667,e.divide=584,e.Yacute=667,e.Acircumflex=667,e.aacute=556,e.Ucircumflex=722,e.yacute=500,e.scommaaccent=500,e.ecircumflex=556,e.Uring=722,e.Udieresis=722,e.aogonek=556,e.Uacute=722,e.uogonek=556,e.Edieresis=667,e.Dcroat=722,e.commaaccent=250,e.copyright=737,e.Emacron=667,e.ccaron=500,e.aring=556,e.Ncommaaccent=722,e.lacute=222,e.agrave=556,e.Tcommaaccent=611,e.Cacute=722,e.atilde=556,e.Edotaccent=667,e.scaron=500,e.scedilla=500,e.iacute=278,e.lozenge=471,e.Rcaron=722,e.Gcommaaccent=778,e.ucircumflex=556,e.acircumflex=556,e.Amacron=667,e.rcaron=333,e.ccedilla=500,e.Zdotaccent=611,e.Thorn=667,e.Omacron=778,e.Racute=722,e.Sacute=667,e.dcaron=643,e.Umacron=722,e.uring=556,e.threesuperior=333,e.Ograve=778,e.Agrave=667,e.Abreve=667,e.multiply=584,e.uacute=556,e.Tcaron=611,e.partialdiff=476,e.ydieresis=500,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=667,e.adieresis=556,e.edieresis=556,e.cacute=500,e.nacute=556,e.umacron=556,e.Ncaron=722,e.Iacute=278,e.plusminus=584,e.brokenbar=260,e.registered=737,e.Gbreve=778,e.Idotaccent=278,e.summation=600,e.Egrave=667,e.racute=333,e.omacron=556,e.Zacute=611,e.Zcaron=611,e.greaterequal=549,e.Eth=722,e.Ccedilla=722,e.lcommaaccent=222,e.tcaron=317,e.eogonek=556,e.Uogonek=722,e.Aacute=667,e.Adieresis=667,e.egrave=556,e.zacute=500,e.iogonek=222,e.Oacute=778,e.oacute=556,e.amacron=556,e.sacute=500,e.idieresis=278,e.Ocircumflex=778,e.Ugrave=722,e.Delta=612,e.thorn=556,e.twosuperior=333,e.Odieresis=778,e.mu=556,e.igrave=278,e.ohungarumlaut=556,e.Eogonek=667,e.dcroat=556,e.threequarters=834,e.Scedilla=667,e.lcaron=299,e.Kcommaaccent=667,e.Lacute=556,e.trademark=1e3,e.edotaccent=556,e.Igrave=278,e.Imacron=278,e.Lcaron=556,e.onehalf=834,e.lessequal=549,e.ocircumflex=556,e.ntilde=556,e.Uhungarumlaut=722,e.Eacute=667,e.emacron=556,e.gbreve=556,e.onequarter=834,e.Scaron=667,e.Scommaaccent=667,e.Ohungarumlaut=778,e.degree=400,e.ograve=556,e.Ccaron=722,e.ugrave=556,e.radical=453,e.Dcaron=722,e.rcommaaccent=333,e.Ntilde=722,e.otilde=556,e.Rcommaaccent=722,e.Lcommaaccent=556,e.Atilde=667,e.Aogonek=667,e.Aring=667,e.Otilde=778,e.zdotaccent=500,e.Ecaron=667,e.Iogonek=278,e.kcommaaccent=500,e.minus=584,e.Icircumflex=278,e.ncaron=556,e.tcommaaccent=278,e.logicalnot=584,e.odieresis=556,e.udieresis=556,e.notequal=549,e.gcommaaccent=556,e.eth=556,e.zcaron=500,e.ncommaaccent=556,e.onesuperior=333,e.imacron=278,e.Euro=556})),e["Helvetica-Bold"]=(0,a.getLookupTableFactory)((function(e){e.space=278,e.exclam=333,e.quotedbl=474,e.numbersign=556,e.dollar=556,e.percent=889,e.ampersand=722,e.quoteright=278,e.parenleft=333,e.parenright=333,e.asterisk=389,e.plus=584,e.comma=278,e.hyphen=333,e.period=278,e.slash=278,e.zero=556,e.one=556,e.two=556,e.three=556,e.four=556,e.five=556,e.six=556,e.seven=556,e.eight=556,e.nine=556,e.colon=333,e.semicolon=333,e.less=584,e.equal=584,e.greater=584,e.question=611,e.at=975,e.A=722,e.B=722,e.C=722,e.D=722,e.E=667,e.F=611,e.G=778,e.H=722,e.I=278,e.J=556,e.K=722,e.L=611,e.M=833,e.N=722,e.O=778,e.P=667,e.Q=778,e.R=722,e.S=667,e.T=611,e.U=722,e.V=667,e.W=944,e.X=667,e.Y=667,e.Z=611,e.bracketleft=333,e.backslash=278,e.bracketright=333,e.asciicircum=584,e.underscore=556,e.quoteleft=278,e.a=556,e.b=611,e.c=556,e.d=611,e.e=556,e.f=333,e.g=611,e.h=611,e.i=278,e.j=278,e.k=556,e.l=278,e.m=889,e.n=611,e.o=611,e.p=611,e.q=611,e.r=389,e.s=556,e.t=333,e.u=611,e.v=556,e.w=778,e.x=556,e.y=556,e.z=500,e.braceleft=389,e.bar=280,e.braceright=389,e.asciitilde=584,e.exclamdown=333,e.cent=556,e.sterling=556,e.fraction=167,e.yen=556,e.florin=556,e.section=556,e.currency=556,e.quotesingle=238,e.quotedblleft=500,e.guillemotleft=556,e.guilsinglleft=333,e.guilsinglright=333,e.fi=611,e.fl=611,e.endash=556,e.dagger=556,e.daggerdbl=556,e.periodcentered=278,e.paragraph=556,e.bullet=350,e.quotesinglbase=278,e.quotedblbase=500,e.quotedblright=500,e.guillemotright=556,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=611,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=1e3,e.ordfeminine=370,e.Lslash=611,e.Oslash=778,e.OE=1e3,e.ordmasculine=365,e.ae=889,e.dotlessi=278,e.lslash=278,e.oslash=611,e.oe=944,e.germandbls=611,e.Idieresis=278,e.eacute=556,e.abreve=556,e.uhungarumlaut=611,e.ecaron=556,e.Ydieresis=667,e.divide=584,e.Yacute=667,e.Acircumflex=722,e.aacute=556,e.Ucircumflex=722,e.yacute=556,e.scommaaccent=556,e.ecircumflex=556,e.Uring=722,e.Udieresis=722,e.aogonek=556,e.Uacute=722,e.uogonek=611,e.Edieresis=667,e.Dcroat=722,e.commaaccent=250,e.copyright=737,e.Emacron=667,e.ccaron=556,e.aring=556,e.Ncommaaccent=722,e.lacute=278,e.agrave=556,e.Tcommaaccent=611,e.Cacute=722,e.atilde=556,e.Edotaccent=667,e.scaron=556,e.scedilla=556,e.iacute=278,e.lozenge=494,e.Rcaron=722,e.Gcommaaccent=778,e.ucircumflex=611,e.acircumflex=556,e.Amacron=722,e.rcaron=389,e.ccedilla=556,e.Zdotaccent=611,e.Thorn=667,e.Omacron=778,e.Racute=722,e.Sacute=667,e.dcaron=743,e.Umacron=722,e.uring=611,e.threesuperior=333,e.Ograve=778,e.Agrave=722,e.Abreve=722,e.multiply=584,e.uacute=611,e.Tcaron=611,e.partialdiff=494,e.ydieresis=556,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=667,e.adieresis=556,e.edieresis=556,e.cacute=556,e.nacute=611,e.umacron=611,e.Ncaron=722,e.Iacute=278,e.plusminus=584,e.brokenbar=280,e.registered=737,e.Gbreve=778,e.Idotaccent=278,e.summation=600,e.Egrave=667,e.racute=389,e.omacron=611,e.Zacute=611,e.Zcaron=611,e.greaterequal=549,e.Eth=722,e.Ccedilla=722,e.lcommaaccent=278,e.tcaron=389,e.eogonek=556,e.Uogonek=722,e.Aacute=722,e.Adieresis=722,e.egrave=556,e.zacute=500,e.iogonek=278,e.Oacute=778,e.oacute=611,e.amacron=556,e.sacute=556,e.idieresis=278,e.Ocircumflex=778,e.Ugrave=722,e.Delta=612,e.thorn=611,e.twosuperior=333,e.Odieresis=778,e.mu=611,e.igrave=278,e.ohungarumlaut=611,e.Eogonek=667,e.dcroat=611,e.threequarters=834,e.Scedilla=667,e.lcaron=400,e.Kcommaaccent=722,e.Lacute=611,e.trademark=1e3,e.edotaccent=556,e.Igrave=278,e.Imacron=278,e.Lcaron=611,e.onehalf=834,e.lessequal=549,e.ocircumflex=611,e.ntilde=611,e.Uhungarumlaut=722,e.Eacute=667,e.emacron=556,e.gbreve=611,e.onequarter=834,e.Scaron=667,e.Scommaaccent=667,e.Ohungarumlaut=778,e.degree=400,e.ograve=611,e.Ccaron=722,e.ugrave=611,e.radical=549,e.Dcaron=722,e.rcommaaccent=389,e.Ntilde=722,e.otilde=611,e.Rcommaaccent=722,e.Lcommaaccent=611,e.Atilde=722,e.Aogonek=722,e.Aring=722,e.Otilde=778,e.zdotaccent=500,e.Ecaron=667,e.Iogonek=278,e.kcommaaccent=556,e.minus=584,e.Icircumflex=278,e.ncaron=611,e.tcommaaccent=333,e.logicalnot=584,e.odieresis=611,e.udieresis=611,e.notequal=549,e.gcommaaccent=611,e.eth=611,e.zcaron=500,e.ncommaaccent=611,e.onesuperior=333,e.imacron=278,e.Euro=556})),e["Helvetica-BoldOblique"]=(0,a.getLookupTableFactory)((function(e){e.space=278,e.exclam=333,e.quotedbl=474,e.numbersign=556,e.dollar=556,e.percent=889,e.ampersand=722,e.quoteright=278,e.parenleft=333,e.parenright=333,e.asterisk=389,e.plus=584,e.comma=278,e.hyphen=333,e.period=278,e.slash=278,e.zero=556,e.one=556,e.two=556,e.three=556,e.four=556,e.five=556,e.six=556,e.seven=556,e.eight=556,e.nine=556,e.colon=333,e.semicolon=333,e.less=584,e.equal=584,e.greater=584,e.question=611,e.at=975,e.A=722,e.B=722,e.C=722,e.D=722,e.E=667,e.F=611,e.G=778,e.H=722,e.I=278,e.J=556,e.K=722,e.L=611,e.M=833,e.N=722,e.O=778,e.P=667,e.Q=778,e.R=722,e.S=667,e.T=611,e.U=722,e.V=667,e.W=944,e.X=667,e.Y=667,e.Z=611,e.bracketleft=333,e.backslash=278,e.bracketright=333,e.asciicircum=584,e.underscore=556,e.quoteleft=278,e.a=556,e.b=611,e.c=556,e.d=611,e.e=556,e.f=333,e.g=611,e.h=611,e.i=278,e.j=278,e.k=556,e.l=278,e.m=889,e.n=611,e.o=611,e.p=611,e.q=611,e.r=389,e.s=556,e.t=333,e.u=611,e.v=556,e.w=778,e.x=556,e.y=556,e.z=500,e.braceleft=389,e.bar=280,e.braceright=389,e.asciitilde=584,e.exclamdown=333,e.cent=556,e.sterling=556,e.fraction=167,e.yen=556,e.florin=556,e.section=556,e.currency=556,e.quotesingle=238,e.quotedblleft=500,e.guillemotleft=556,e.guilsinglleft=333,e.guilsinglright=333,e.fi=611,e.fl=611,e.endash=556,e.dagger=556,e.daggerdbl=556,e.periodcentered=278,e.paragraph=556,e.bullet=350,e.quotesinglbase=278,e.quotedblbase=500,e.quotedblright=500,e.guillemotright=556,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=611,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=1e3,e.ordfeminine=370,e.Lslash=611,e.Oslash=778,e.OE=1e3,e.ordmasculine=365,e.ae=889,e.dotlessi=278,e.lslash=278,e.oslash=611,e.oe=944,e.germandbls=611,e.Idieresis=278,e.eacute=556,e.abreve=556,e.uhungarumlaut=611,e.ecaron=556,e.Ydieresis=667,e.divide=584,e.Yacute=667,e.Acircumflex=722,e.aacute=556,e.Ucircumflex=722,e.yacute=556,e.scommaaccent=556,e.ecircumflex=556,e.Uring=722,e.Udieresis=722,e.aogonek=556,e.Uacute=722,e.uogonek=611,e.Edieresis=667,e.Dcroat=722,e.commaaccent=250,e.copyright=737,e.Emacron=667,e.ccaron=556,e.aring=556,e.Ncommaaccent=722,e.lacute=278,e.agrave=556,e.Tcommaaccent=611,e.Cacute=722,e.atilde=556,e.Edotaccent=667,e.scaron=556,e.scedilla=556,e.iacute=278,e.lozenge=494,e.Rcaron=722,e.Gcommaaccent=778,e.ucircumflex=611,e.acircumflex=556,e.Amacron=722,e.rcaron=389,e.ccedilla=556,e.Zdotaccent=611,e.Thorn=667,e.Omacron=778,e.Racute=722,e.Sacute=667,e.dcaron=743,e.Umacron=722,e.uring=611,e.threesuperior=333,e.Ograve=778,e.Agrave=722,e.Abreve=722,e.multiply=584,e.uacute=611,e.Tcaron=611,e.partialdiff=494,e.ydieresis=556,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=667,e.adieresis=556,e.edieresis=556,e.cacute=556,e.nacute=611,e.umacron=611,e.Ncaron=722,e.Iacute=278,e.plusminus=584,e.brokenbar=280,e.registered=737,e.Gbreve=778,e.Idotaccent=278,e.summation=600,e.Egrave=667,e.racute=389,e.omacron=611,e.Zacute=611,e.Zcaron=611,e.greaterequal=549,e.Eth=722,e.Ccedilla=722,e.lcommaaccent=278,e.tcaron=389,e.eogonek=556,e.Uogonek=722,e.Aacute=722,e.Adieresis=722,e.egrave=556,e.zacute=500,e.iogonek=278,e.Oacute=778,e.oacute=611,e.amacron=556,e.sacute=556,e.idieresis=278,e.Ocircumflex=778,e.Ugrave=722,e.Delta=612,e.thorn=611,e.twosuperior=333,e.Odieresis=778,e.mu=611,e.igrave=278,e.ohungarumlaut=611,e.Eogonek=667,e.dcroat=611,e.threequarters=834,e.Scedilla=667,e.lcaron=400,e.Kcommaaccent=722,e.Lacute=611,e.trademark=1e3,e.edotaccent=556,e.Igrave=278,e.Imacron=278,e.Lcaron=611,e.onehalf=834,e.lessequal=549,e.ocircumflex=611,e.ntilde=611,e.Uhungarumlaut=722,e.Eacute=667,e.emacron=556,e.gbreve=611,e.onequarter=834,e.Scaron=667,e.Scommaaccent=667,e.Ohungarumlaut=778,e.degree=400,e.ograve=611,e.Ccaron=722,e.ugrave=611,e.radical=549,e.Dcaron=722,e.rcommaaccent=389,e.Ntilde=722,e.otilde=611,e.Rcommaaccent=722,e.Lcommaaccent=611,e.Atilde=722,e.Aogonek=722,e.Aring=722,e.Otilde=778,e.zdotaccent=500,e.Ecaron=667,e.Iogonek=278,e.kcommaaccent=556,e.minus=584,e.Icircumflex=278,e.ncaron=611,e.tcommaaccent=333,e.logicalnot=584,e.odieresis=611,e.udieresis=611,e.notequal=549,e.gcommaaccent=611,e.eth=611,e.zcaron=500,e.ncommaaccent=611,e.onesuperior=333,e.imacron=278,e.Euro=556})),e["Helvetica-Oblique"]=(0,a.getLookupTableFactory)((function(e){e.space=278,e.exclam=278,e.quotedbl=355,e.numbersign=556,e.dollar=556,e.percent=889,e.ampersand=667,e.quoteright=222,e.parenleft=333,e.parenright=333,e.asterisk=389,e.plus=584,e.comma=278,e.hyphen=333,e.period=278,e.slash=278,e.zero=556,e.one=556,e.two=556,e.three=556,e.four=556,e.five=556,e.six=556,e.seven=556,e.eight=556,e.nine=556,e.colon=278,e.semicolon=278,e.less=584,e.equal=584,e.greater=584,e.question=556,e.at=1015,e.A=667,e.B=667,e.C=722,e.D=722,e.E=667,e.F=611,e.G=778,e.H=722,e.I=278,e.J=500,e.K=667,e.L=556,e.M=833,e.N=722,e.O=778,e.P=667,e.Q=778,e.R=722,e.S=667,e.T=611,e.U=722,e.V=667,e.W=944,e.X=667,e.Y=667,e.Z=611,e.bracketleft=278,e.backslash=278,e.bracketright=278,e.asciicircum=469,e.underscore=556,e.quoteleft=222,e.a=556,e.b=556,e.c=500,e.d=556,e.e=556,e.f=278,e.g=556,e.h=556,e.i=222,e.j=222,e.k=500,e.l=222,e.m=833,e.n=556,e.o=556,e.p=556,e.q=556,e.r=333,e.s=500,e.t=278,e.u=556,e.v=500,e.w=722,e.x=500,e.y=500,e.z=500,e.braceleft=334,e.bar=260,e.braceright=334,e.asciitilde=584,e.exclamdown=333,e.cent=556,e.sterling=556,e.fraction=167,e.yen=556,e.florin=556,e.section=556,e.currency=556,e.quotesingle=191,e.quotedblleft=333,e.guillemotleft=556,e.guilsinglleft=333,e.guilsinglright=333,e.fi=500,e.fl=500,e.endash=556,e.dagger=556,e.daggerdbl=556,e.periodcentered=278,e.paragraph=537,e.bullet=350,e.quotesinglbase=222,e.quotedblbase=333,e.quotedblright=333,e.guillemotright=556,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=611,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=1e3,e.ordfeminine=370,e.Lslash=556,e.Oslash=778,e.OE=1e3,e.ordmasculine=365,e.ae=889,e.dotlessi=278,e.lslash=222,e.oslash=611,e.oe=944,e.germandbls=611,e.Idieresis=278,e.eacute=556,e.abreve=556,e.uhungarumlaut=556,e.ecaron=556,e.Ydieresis=667,e.divide=584,e.Yacute=667,e.Acircumflex=667,e.aacute=556,e.Ucircumflex=722,e.yacute=500,e.scommaaccent=500,e.ecircumflex=556,e.Uring=722,e.Udieresis=722,e.aogonek=556,e.Uacute=722,e.uogonek=556,e.Edieresis=667,e.Dcroat=722,e.commaaccent=250,e.copyright=737,e.Emacron=667,e.ccaron=500,e.aring=556,e.Ncommaaccent=722,e.lacute=222,e.agrave=556,e.Tcommaaccent=611,e.Cacute=722,e.atilde=556,e.Edotaccent=667,e.scaron=500,e.scedilla=500,e.iacute=278,e.lozenge=471,e.Rcaron=722,e.Gcommaaccent=778,e.ucircumflex=556,e.acircumflex=556,e.Amacron=667,e.rcaron=333,e.ccedilla=500,e.Zdotaccent=611,e.Thorn=667,e.Omacron=778,e.Racute=722,e.Sacute=667,e.dcaron=643,e.Umacron=722,e.uring=556,e.threesuperior=333,e.Ograve=778,e.Agrave=667,e.Abreve=667,e.multiply=584,e.uacute=556,e.Tcaron=611,e.partialdiff=476,e.ydieresis=500,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=667,e.adieresis=556,e.edieresis=556,e.cacute=500,e.nacute=556,e.umacron=556,e.Ncaron=722,e.Iacute=278,e.plusminus=584,e.brokenbar=260,e.registered=737,e.Gbreve=778,e.Idotaccent=278,e.summation=600,e.Egrave=667,e.racute=333,e.omacron=556,e.Zacute=611,e.Zcaron=611,e.greaterequal=549,e.Eth=722,e.Ccedilla=722,e.lcommaaccent=222,e.tcaron=317,e.eogonek=556,e.Uogonek=722,e.Aacute=667,e.Adieresis=667,e.egrave=556,e.zacute=500,e.iogonek=222,e.Oacute=778,e.oacute=556,e.amacron=556,e.sacute=500,e.idieresis=278,e.Ocircumflex=778,e.Ugrave=722,e.Delta=612,e.thorn=556,e.twosuperior=333,e.Odieresis=778,e.mu=556,e.igrave=278,e.ohungarumlaut=556,e.Eogonek=667,e.dcroat=556,e.threequarters=834,e.Scedilla=667,e.lcaron=299,e.Kcommaaccent=667,e.Lacute=556,e.trademark=1e3,e.edotaccent=556,e.Igrave=278,e.Imacron=278,e.Lcaron=556,e.onehalf=834,e.lessequal=549,e.ocircumflex=556,e.ntilde=556,e.Uhungarumlaut=722,e.Eacute=667,e.emacron=556,e.gbreve=556,e.onequarter=834,e.Scaron=667,e.Scommaaccent=667,e.Ohungarumlaut=778,e.degree=400,e.ograve=556,e.Ccaron=722,e.ugrave=556,e.radical=453,e.Dcaron=722,e.rcommaaccent=333,e.Ntilde=722,e.otilde=556,e.Rcommaaccent=722,e.Lcommaaccent=556,e.Atilde=667,e.Aogonek=667,e.Aring=667,e.Otilde=778,e.zdotaccent=500,e.Ecaron=667,e.Iogonek=278,e.kcommaaccent=500,e.minus=584,e.Icircumflex=278,e.ncaron=556,e.tcommaaccent=278,e.logicalnot=584,e.odieresis=556,e.udieresis=556,e.notequal=549,e.gcommaaccent=556,e.eth=556,e.zcaron=500,e.ncommaaccent=556,e.onesuperior=333,e.imacron=278,e.Euro=556})),e.Symbol=(0,a.getLookupTableFactory)((function(e){e.space=250,e.exclam=333,e.universal=713,e.numbersign=500,e.existential=549,e.percent=833,e.ampersand=778,e.suchthat=439,e.parenleft=333,e.parenright=333,e.asteriskmath=500,e.plus=549,e.comma=250,e.minus=549,e.period=250,e.slash=278,e.zero=500,e.one=500,e.two=500,e.three=500,e.four=500,e.five=500,e.six=500,e.seven=500,e.eight=500,e.nine=500,e.colon=278,e.semicolon=278,e.less=549,e.equal=549,e.greater=549,e.question=444,e.congruent=549,e.Alpha=722,e.Beta=667,e.Chi=722,e.Delta=612,e.Epsilon=611,e.Phi=763,e.Gamma=603,e.Eta=722,e.Iota=333,e.theta1=631,e.Kappa=722,e.Lambda=686,e.Mu=889,e.Nu=722,e.Omicron=722,e.Pi=768,e.Theta=741,e.Rho=556,e.Sigma=592,e.Tau=611,e.Upsilon=690,e.sigma1=439,e.Omega=768,e.Xi=645,e.Psi=795,e.Zeta=611,e.bracketleft=333,e.therefore=863,e.bracketright=333,e.perpendicular=658,e.underscore=500,e.radicalex=500,e.alpha=631,e.beta=549,e.chi=549,e.delta=494,e.epsilon=439,e.phi=521,e.gamma=411,e.eta=603,e.iota=329,e.phi1=603,e.kappa=549,e.lambda=549,e.mu=576,e.nu=521,e.omicron=549,e.pi=549,e.theta=521,e.rho=549,e.sigma=603,e.tau=439,e.upsilon=576,e.omega1=713,e.omega=686,e.xi=493,e.psi=686,e.zeta=494,e.braceleft=480,e.bar=200,e.braceright=480,e.similar=549,e.Euro=750,e.Upsilon1=620,e.minute=247,e.lessequal=549,e.fraction=167,e.infinity=713,e.florin=500,e.club=753,e.diamond=753,e.heart=753,e.spade=753,e.arrowboth=1042,e.arrowleft=987,e.arrowup=603,e.arrowright=987,e.arrowdown=603,e.degree=400,e.plusminus=549,e.second=411,e.greaterequal=549,e.multiply=549,e.proportional=713,e.partialdiff=494,e.bullet=460,e.divide=549,e.notequal=549,e.equivalence=549,e.approxequal=549,e.ellipsis=1e3,e.arrowvertex=603,e.arrowhorizex=1e3,e.carriagereturn=658,e.aleph=823,e.Ifraktur=686,e.Rfraktur=795,e.weierstrass=987,e.circlemultiply=768,e.circleplus=768,e.emptyset=823,e.intersection=768,e.union=768,e.propersuperset=713,e.reflexsuperset=713,e.notsubset=713,e.propersubset=713,e.reflexsubset=713,e.element=713,e.notelement=713,e.angle=768,e.gradient=713,e.registerserif=790,e.copyrightserif=790,e.trademarkserif=890,e.product=823,e.radical=549,e.dotmath=250,e.logicalnot=713,e.logicaland=603,e.logicalor=603,e.arrowdblboth=1042,e.arrowdblleft=987,e.arrowdblup=603,e.arrowdblright=987,e.arrowdbldown=603,e.lozenge=494,e.angleleft=329,e.registersans=790,e.copyrightsans=790,e.trademarksans=786,e.summation=713,e.parenlefttp=384,e.parenleftex=384,e.parenleftbt=384,e.bracketlefttp=384,e.bracketleftex=384,e.bracketleftbt=384,e.bracelefttp=494,e.braceleftmid=494,e.braceleftbt=494,e.braceex=494,e.angleright=329,e.integral=274,e.integraltp=686,e.integralex=686,e.integralbt=686,e.parenrighttp=384,e.parenrightex=384,e.parenrightbt=384,e.bracketrighttp=384,e.bracketrightex=384,e.bracketrightbt=384,e.bracerighttp=494,e.bracerightmid=494,e.bracerightbt=494,e.apple=790})),e["Times-Roman"]=(0,a.getLookupTableFactory)((function(e){e.space=250,e.exclam=333,e.quotedbl=408,e.numbersign=500,e.dollar=500,e.percent=833,e.ampersand=778,e.quoteright=333,e.parenleft=333,e.parenright=333,e.asterisk=500,e.plus=564,e.comma=250,e.hyphen=333,e.period=250,e.slash=278,e.zero=500,e.one=500,e.two=500,e.three=500,e.four=500,e.five=500,e.six=500,e.seven=500,e.eight=500,e.nine=500,e.colon=278,e.semicolon=278,e.less=564,e.equal=564,e.greater=564,e.question=444,e.at=921,e.A=722,e.B=667,e.C=667,e.D=722,e.E=611,e.F=556,e.G=722,e.H=722,e.I=333,e.J=389,e.K=722,e.L=611,e.M=889,e.N=722,e.O=722,e.P=556,e.Q=722,e.R=667,e.S=556,e.T=611,e.U=722,e.V=722,e.W=944,e.X=722,e.Y=722,e.Z=611,e.bracketleft=333,e.backslash=278,e.bracketright=333,e.asciicircum=469,e.underscore=500,e.quoteleft=333,e.a=444,e.b=500,e.c=444,e.d=500,e.e=444,e.f=333,e.g=500,e.h=500,e.i=278,e.j=278,e.k=500,e.l=278,e.m=778,e.n=500,e.o=500,e.p=500,e.q=500,e.r=333,e.s=389,e.t=278,e.u=500,e.v=500,e.w=722,e.x=500,e.y=500,e.z=444,e.braceleft=480,e.bar=200,e.braceright=480,e.asciitilde=541,e.exclamdown=333,e.cent=500,e.sterling=500,e.fraction=167,e.yen=500,e.florin=500,e.section=500,e.currency=500,e.quotesingle=180,e.quotedblleft=444,e.guillemotleft=500,e.guilsinglleft=333,e.guilsinglright=333,e.fi=556,e.fl=556,e.endash=500,e.dagger=500,e.daggerdbl=500,e.periodcentered=250,e.paragraph=453,e.bullet=350,e.quotesinglbase=333,e.quotedblbase=444,e.quotedblright=444,e.guillemotright=500,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=444,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=889,e.ordfeminine=276,e.Lslash=611,e.Oslash=722,e.OE=889,e.ordmasculine=310,e.ae=667,e.dotlessi=278,e.lslash=278,e.oslash=500,e.oe=722,e.germandbls=500,e.Idieresis=333,e.eacute=444,e.abreve=444,e.uhungarumlaut=500,e.ecaron=444,e.Ydieresis=722,e.divide=564,e.Yacute=722,e.Acircumflex=722,e.aacute=444,e.Ucircumflex=722,e.yacute=500,e.scommaaccent=389,e.ecircumflex=444,e.Uring=722,e.Udieresis=722,e.aogonek=444,e.Uacute=722,e.uogonek=500,e.Edieresis=611,e.Dcroat=722,e.commaaccent=250,e.copyright=760,e.Emacron=611,e.ccaron=444,e.aring=444,e.Ncommaaccent=722,e.lacute=278,e.agrave=444,e.Tcommaaccent=611,e.Cacute=667,e.atilde=444,e.Edotaccent=611,e.scaron=389,e.scedilla=389,e.iacute=278,e.lozenge=471,e.Rcaron=667,e.Gcommaaccent=722,e.ucircumflex=500,e.acircumflex=444,e.Amacron=722,e.rcaron=333,e.ccedilla=444,e.Zdotaccent=611,e.Thorn=556,e.Omacron=722,e.Racute=667,e.Sacute=556,e.dcaron=588,e.Umacron=722,e.uring=500,e.threesuperior=300,e.Ograve=722,e.Agrave=722,e.Abreve=722,e.multiply=564,e.uacute=500,e.Tcaron=611,e.partialdiff=476,e.ydieresis=500,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=611,e.adieresis=444,e.edieresis=444,e.cacute=444,e.nacute=500,e.umacron=500,e.Ncaron=722,e.Iacute=333,e.plusminus=564,e.brokenbar=200,e.registered=760,e.Gbreve=722,e.Idotaccent=333,e.summation=600,e.Egrave=611,e.racute=333,e.omacron=500,e.Zacute=611,e.Zcaron=611,e.greaterequal=549,e.Eth=722,e.Ccedilla=667,e.lcommaaccent=278,e.tcaron=326,e.eogonek=444,e.Uogonek=722,e.Aacute=722,e.Adieresis=722,e.egrave=444,e.zacute=444,e.iogonek=278,e.Oacute=722,e.oacute=500,e.amacron=444,e.sacute=389,e.idieresis=278,e.Ocircumflex=722,e.Ugrave=722,e.Delta=612,e.thorn=500,e.twosuperior=300,e.Odieresis=722,e.mu=500,e.igrave=278,e.ohungarumlaut=500,e.Eogonek=611,e.dcroat=500,e.threequarters=750,e.Scedilla=556,e.lcaron=344,e.Kcommaaccent=722,e.Lacute=611,e.trademark=980,e.edotaccent=444,e.Igrave=333,e.Imacron=333,e.Lcaron=611,e.onehalf=750,e.lessequal=549,e.ocircumflex=500,e.ntilde=500,e.Uhungarumlaut=722,e.Eacute=611,e.emacron=444,e.gbreve=500,e.onequarter=750,e.Scaron=556,e.Scommaaccent=556,e.Ohungarumlaut=722,e.degree=400,e.ograve=500,e.Ccaron=667,e.ugrave=500,e.radical=453,e.Dcaron=722,e.rcommaaccent=333,e.Ntilde=722,e.otilde=500,e.Rcommaaccent=667,e.Lcommaaccent=611,e.Atilde=722,e.Aogonek=722,e.Aring=722,e.Otilde=722,e.zdotaccent=444,e.Ecaron=611,e.Iogonek=333,e.kcommaaccent=500,e.minus=564,e.Icircumflex=333,e.ncaron=500,e.tcommaaccent=278,e.logicalnot=564,e.odieresis=500,e.udieresis=500,e.notequal=549,e.gcommaaccent=500,e.eth=500,e.zcaron=444,e.ncommaaccent=500,e.onesuperior=300,e.imacron=278,e.Euro=500})),e["Times-Bold"]=(0,a.getLookupTableFactory)((function(e){e.space=250,e.exclam=333,e.quotedbl=555,e.numbersign=500,e.dollar=500,e.percent=1e3,e.ampersand=833,e.quoteright=333,e.parenleft=333,e.parenright=333,e.asterisk=500,e.plus=570,e.comma=250,e.hyphen=333,e.period=250,e.slash=278,e.zero=500,e.one=500,e.two=500,e.three=500,e.four=500,e.five=500,e.six=500,e.seven=500,e.eight=500,e.nine=500,e.colon=333,e.semicolon=333,e.less=570,e.equal=570,e.greater=570,e.question=500,e.at=930,e.A=722,e.B=667,e.C=722,e.D=722,e.E=667,e.F=611,e.G=778,e.H=778,e.I=389,e.J=500,e.K=778,e.L=667,e.M=944,e.N=722,e.O=778,e.P=611,e.Q=778,e.R=722,e.S=556,e.T=667,e.U=722,e.V=722,e.W=1e3,e.X=722,e.Y=722,e.Z=667,e.bracketleft=333,e.backslash=278,e.bracketright=333,e.asciicircum=581,e.underscore=500,e.quoteleft=333,e.a=500,e.b=556,e.c=444,e.d=556,e.e=444,e.f=333,e.g=500,e.h=556,e.i=278,e.j=333,e.k=556,e.l=278,e.m=833,e.n=556,e.o=500,e.p=556,e.q=556,e.r=444,e.s=389,e.t=333,e.u=556,e.v=500,e.w=722,e.x=500,e.y=500,e.z=444,e.braceleft=394,e.bar=220,e.braceright=394,e.asciitilde=520,e.exclamdown=333,e.cent=500,e.sterling=500,e.fraction=167,e.yen=500,e.florin=500,e.section=500,e.currency=500,e.quotesingle=278,e.quotedblleft=500,e.guillemotleft=500,e.guilsinglleft=333,e.guilsinglright=333,e.fi=556,e.fl=556,e.endash=500,e.dagger=500,e.daggerdbl=500,e.periodcentered=250,e.paragraph=540,e.bullet=350,e.quotesinglbase=333,e.quotedblbase=500,e.quotedblright=500,e.guillemotright=500,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=500,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=1e3,e.ordfeminine=300,e.Lslash=667,e.Oslash=778,e.OE=1e3,e.ordmasculine=330,e.ae=722,e.dotlessi=278,e.lslash=278,e.oslash=500,e.oe=722,e.germandbls=556,e.Idieresis=389,e.eacute=444,e.abreve=500,e.uhungarumlaut=556,e.ecaron=444,e.Ydieresis=722,e.divide=570,e.Yacute=722,e.Acircumflex=722,e.aacute=500,e.Ucircumflex=722,e.yacute=500,e.scommaaccent=389,e.ecircumflex=444,e.Uring=722,e.Udieresis=722,e.aogonek=500,e.Uacute=722,e.uogonek=556,e.Edieresis=667,e.Dcroat=722,e.commaaccent=250,e.copyright=747,e.Emacron=667,e.ccaron=444,e.aring=500,e.Ncommaaccent=722,e.lacute=278,e.agrave=500,e.Tcommaaccent=667,e.Cacute=722,e.atilde=500,e.Edotaccent=667,e.scaron=389,e.scedilla=389,e.iacute=278,e.lozenge=494,e.Rcaron=722,e.Gcommaaccent=778,e.ucircumflex=556,e.acircumflex=500,e.Amacron=722,e.rcaron=444,e.ccedilla=444,e.Zdotaccent=667,e.Thorn=611,e.Omacron=778,e.Racute=722,e.Sacute=556,e.dcaron=672,e.Umacron=722,e.uring=556,e.threesuperior=300,e.Ograve=778,e.Agrave=722,e.Abreve=722,e.multiply=570,e.uacute=556,e.Tcaron=667,e.partialdiff=494,e.ydieresis=500,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=667,e.adieresis=500,e.edieresis=444,e.cacute=444,e.nacute=556,e.umacron=556,e.Ncaron=722,e.Iacute=389,e.plusminus=570,e.brokenbar=220,e.registered=747,e.Gbreve=778,e.Idotaccent=389,e.summation=600,e.Egrave=667,e.racute=444,e.omacron=500,e.Zacute=667,e.Zcaron=667,e.greaterequal=549,e.Eth=722,e.Ccedilla=722,e.lcommaaccent=278,e.tcaron=416,e.eogonek=444,e.Uogonek=722,e.Aacute=722,e.Adieresis=722,e.egrave=444,e.zacute=444,e.iogonek=278,e.Oacute=778,e.oacute=500,e.amacron=500,e.sacute=389,e.idieresis=278,e.Ocircumflex=778,e.Ugrave=722,e.Delta=612,e.thorn=556,e.twosuperior=300,e.Odieresis=778,e.mu=556,e.igrave=278,e.ohungarumlaut=500,e.Eogonek=667,e.dcroat=556,e.threequarters=750,e.Scedilla=556,e.lcaron=394,e.Kcommaaccent=778,e.Lacute=667,e.trademark=1e3,e.edotaccent=444,e.Igrave=389,e.Imacron=389,e.Lcaron=667,e.onehalf=750,e.lessequal=549,e.ocircumflex=500,e.ntilde=556,e.Uhungarumlaut=722,e.Eacute=667,e.emacron=444,e.gbreve=500,e.onequarter=750,e.Scaron=556,e.Scommaaccent=556,e.Ohungarumlaut=778,e.degree=400,e.ograve=500,e.Ccaron=722,e.ugrave=556,e.radical=549,e.Dcaron=722,e.rcommaaccent=444,e.Ntilde=722,e.otilde=500,e.Rcommaaccent=722,e.Lcommaaccent=667,e.Atilde=722,e.Aogonek=722,e.Aring=722,e.Otilde=778,e.zdotaccent=444,e.Ecaron=667,e.Iogonek=389,e.kcommaaccent=556,e.minus=570,e.Icircumflex=389,e.ncaron=556,e.tcommaaccent=333,e.logicalnot=570,e.odieresis=500,e.udieresis=556,e.notequal=549,e.gcommaaccent=500,e.eth=500,e.zcaron=444,e.ncommaaccent=556,e.onesuperior=300,e.imacron=278,e.Euro=500})),e["Times-BoldItalic"]=(0,a.getLookupTableFactory)((function(e){e.space=250,e.exclam=389,e.quotedbl=555,e.numbersign=500,e.dollar=500,e.percent=833,e.ampersand=778,e.quoteright=333,e.parenleft=333,e.parenright=333,e.asterisk=500,e.plus=570,e.comma=250,e.hyphen=333,e.period=250,e.slash=278,e.zero=500,e.one=500,e.two=500,e.three=500,e.four=500,e.five=500,e.six=500,e.seven=500,e.eight=500,e.nine=500,e.colon=333,e.semicolon=333,e.less=570,e.equal=570,e.greater=570,e.question=500,e.at=832,e.A=667,e.B=667,e.C=667,e.D=722,e.E=667,e.F=667,e.G=722,e.H=778,e.I=389,e.J=500,e.K=667,e.L=611,e.M=889,e.N=722,e.O=722,e.P=611,e.Q=722,e.R=667,e.S=556,e.T=611,e.U=722,e.V=667,e.W=889,e.X=667,e.Y=611,e.Z=611,e.bracketleft=333,e.backslash=278,e.bracketright=333,e.asciicircum=570,e.underscore=500,e.quoteleft=333,e.a=500,e.b=500,e.c=444,e.d=500,e.e=444,e.f=333,e.g=500,e.h=556,e.i=278,e.j=278,e.k=500,e.l=278,e.m=778,e.n=556,e.o=500,e.p=500,e.q=500,e.r=389,e.s=389,e.t=278,e.u=556,e.v=444,e.w=667,e.x=500,e.y=444,e.z=389,e.braceleft=348,e.bar=220,e.braceright=348,e.asciitilde=570,e.exclamdown=389,e.cent=500,e.sterling=500,e.fraction=167,e.yen=500,e.florin=500,e.section=500,e.currency=500,e.quotesingle=278,e.quotedblleft=500,e.guillemotleft=500,e.guilsinglleft=333,e.guilsinglright=333,e.fi=556,e.fl=556,e.endash=500,e.dagger=500,e.daggerdbl=500,e.periodcentered=250,e.paragraph=500,e.bullet=350,e.quotesinglbase=333,e.quotedblbase=500,e.quotedblright=500,e.guillemotright=500,e.ellipsis=1e3,e.perthousand=1e3,e.questiondown=500,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=1e3,e.AE=944,e.ordfeminine=266,e.Lslash=611,e.Oslash=722,e.OE=944,e.ordmasculine=300,e.ae=722,e.dotlessi=278,e.lslash=278,e.oslash=500,e.oe=722,e.germandbls=500,e.Idieresis=389,e.eacute=444,e.abreve=500,e.uhungarumlaut=556,e.ecaron=444,e.Ydieresis=611,e.divide=570,e.Yacute=611,e.Acircumflex=667,e.aacute=500,e.Ucircumflex=722,e.yacute=444,e.scommaaccent=389,e.ecircumflex=444,e.Uring=722,e.Udieresis=722,e.aogonek=500,e.Uacute=722,e.uogonek=556,e.Edieresis=667,e.Dcroat=722,e.commaaccent=250,e.copyright=747,e.Emacron=667,e.ccaron=444,e.aring=500,e.Ncommaaccent=722,e.lacute=278,e.agrave=500,e.Tcommaaccent=611,e.Cacute=667,e.atilde=500,e.Edotaccent=667,e.scaron=389,e.scedilla=389,e.iacute=278,e.lozenge=494,e.Rcaron=667,e.Gcommaaccent=722,e.ucircumflex=556,e.acircumflex=500,e.Amacron=667,e.rcaron=389,e.ccedilla=444,e.Zdotaccent=611,e.Thorn=611,e.Omacron=722,e.Racute=667,e.Sacute=556,e.dcaron=608,e.Umacron=722,e.uring=556,e.threesuperior=300,e.Ograve=722,e.Agrave=667,e.Abreve=667,e.multiply=570,e.uacute=556,e.Tcaron=611,e.partialdiff=494,e.ydieresis=444,e.Nacute=722,e.icircumflex=278,e.Ecircumflex=667,e.adieresis=500,e.edieresis=444,e.cacute=444,e.nacute=556,e.umacron=556,e.Ncaron=722,e.Iacute=389,e.plusminus=570,e.brokenbar=220,e.registered=747,e.Gbreve=722,e.Idotaccent=389,e.summation=600,e.Egrave=667,e.racute=389,e.omacron=500,e.Zacute=611,e.Zcaron=611,e.greaterequal=549,e.Eth=722,e.Ccedilla=667,e.lcommaaccent=278,e.tcaron=366,e.eogonek=444,e.Uogonek=722,e.Aacute=667,e.Adieresis=667,e.egrave=444,e.zacute=389,e.iogonek=278,e.Oacute=722,e.oacute=500,e.amacron=500,e.sacute=389,e.idieresis=278,e.Ocircumflex=722,e.Ugrave=722,e.Delta=612,e.thorn=500,e.twosuperior=300,e.Odieresis=722,e.mu=576,e.igrave=278,e.ohungarumlaut=500,e.Eogonek=667,e.dcroat=500,e.threequarters=750,e.Scedilla=556,e.lcaron=382,e.Kcommaaccent=667,e.Lacute=611,e.trademark=1e3,e.edotaccent=444,e.Igrave=389,e.Imacron=389,e.Lcaron=611,e.onehalf=750,e.lessequal=549,e.ocircumflex=500,e.ntilde=556,e.Uhungarumlaut=722,e.Eacute=667,e.emacron=444,e.gbreve=500,e.onequarter=750,e.Scaron=556,e.Scommaaccent=556,e.Ohungarumlaut=722,e.degree=400,e.ograve=500,e.Ccaron=667,e.ugrave=556,e.radical=549,e.Dcaron=722,e.rcommaaccent=389,e.Ntilde=722,e.otilde=500,e.Rcommaaccent=667,e.Lcommaaccent=611,e.Atilde=667,e.Aogonek=667,e.Aring=667,e.Otilde=722,e.zdotaccent=389,e.Ecaron=667,e.Iogonek=389,e.kcommaaccent=500,e.minus=606,e.Icircumflex=389,e.ncaron=556,e.tcommaaccent=278,e.logicalnot=606,e.odieresis=500,e.udieresis=556,e.notequal=549,e.gcommaaccent=500,e.eth=500,e.zcaron=389,e.ncommaaccent=556,e.onesuperior=300,e.imacron=278,e.Euro=500})),e["Times-Italic"]=(0,a.getLookupTableFactory)((function(e){e.space=250,e.exclam=333,e.quotedbl=420,e.numbersign=500,e.dollar=500,e.percent=833,e.ampersand=778,e.quoteright=333,e.parenleft=333,e.parenright=333,e.asterisk=500,e.plus=675,e.comma=250,e.hyphen=333,e.period=250,e.slash=278,e.zero=500,e.one=500,e.two=500,e.three=500,e.four=500,e.five=500,e.six=500,e.seven=500,e.eight=500,e.nine=500,e.colon=333,e.semicolon=333,e.less=675,e.equal=675,e.greater=675,e.question=500,e.at=920,e.A=611,e.B=611,e.C=667,e.D=722,e.E=611,e.F=611,e.G=722,e.H=722,e.I=333,e.J=444,e.K=667,e.L=556,e.M=833,e.N=667,e.O=722,e.P=611,e.Q=722,e.R=611,e.S=500,e.T=556,e.U=722,e.V=611,e.W=833,e.X=611,e.Y=556,e.Z=556,e.bracketleft=389,e.backslash=278,e.bracketright=389,e.asciicircum=422,e.underscore=500,e.quoteleft=333,e.a=500,e.b=500,e.c=444,e.d=500,e.e=444,e.f=278,e.g=500,e.h=500,e.i=278,e.j=278,e.k=444,e.l=278,e.m=722,e.n=500,e.o=500,e.p=500,e.q=500,e.r=389,e.s=389,e.t=278,e.u=500,e.v=444,e.w=667,e.x=444,e.y=444,e.z=389,e.braceleft=400,e.bar=275,e.braceright=400,e.asciitilde=541,e.exclamdown=389,e.cent=500,e.sterling=500,e.fraction=167,e.yen=500,e.florin=500,e.section=500,e.currency=500,e.quotesingle=214,e.quotedblleft=556,e.guillemotleft=500,e.guilsinglleft=333,e.guilsinglright=333,e.fi=500,e.fl=500,e.endash=500,e.dagger=500,e.daggerdbl=500,e.periodcentered=250,e.paragraph=523,e.bullet=350,e.quotesinglbase=333,e.quotedblbase=556,e.quotedblright=556,e.guillemotright=500,e.ellipsis=889,e.perthousand=1e3,e.questiondown=500,e.grave=333,e.acute=333,e.circumflex=333,e.tilde=333,e.macron=333,e.breve=333,e.dotaccent=333,e.dieresis=333,e.ring=333,e.cedilla=333,e.hungarumlaut=333,e.ogonek=333,e.caron=333,e.emdash=889,e.AE=889,e.ordfeminine=276,e.Lslash=556,e.Oslash=722,e.OE=944,e.ordmasculine=310,e.ae=667,e.dotlessi=278,e.lslash=278,e.oslash=500,e.oe=667,e.germandbls=500,e.Idieresis=333,e.eacute=444,e.abreve=500,e.uhungarumlaut=500,e.ecaron=444,e.Ydieresis=556,e.divide=675,e.Yacute=556,e.Acircumflex=611,e.aacute=500,e.Ucircumflex=722,e.yacute=444,e.scommaaccent=389,e.ecircumflex=444,e.Uring=722,e.Udieresis=722,e.aogonek=500,e.Uacute=722,e.uogonek=500,e.Edieresis=611,e.Dcroat=722,e.commaaccent=250,e.copyright=760,e.Emacron=611,e.ccaron=444,e.aring=500,e.Ncommaaccent=667,e.lacute=278,e.agrave=500,e.Tcommaaccent=556,e.Cacute=667,e.atilde=500,e.Edotaccent=611,e.scaron=389,e.scedilla=389,e.iacute=278,e.lozenge=471,e.Rcaron=611,e.Gcommaaccent=722,e.ucircumflex=500,e.acircumflex=500,e.Amacron=611,e.rcaron=389,e.ccedilla=444,e.Zdotaccent=556,e.Thorn=611,e.Omacron=722,e.Racute=611,e.Sacute=500,e.dcaron=544,e.Umacron=722,e.uring=500,e.threesuperior=300,e.Ograve=722,e.Agrave=611,e.Abreve=611,e.multiply=675,e.uacute=500,e.Tcaron=556,e.partialdiff=476,e.ydieresis=444,e.Nacute=667,e.icircumflex=278,e.Ecircumflex=611,e.adieresis=500,e.edieresis=444,e.cacute=444,e.nacute=500,e.umacron=500,e.Ncaron=667,e.Iacute=333,e.plusminus=675,e.brokenbar=275,e.registered=760,e.Gbreve=722,e.Idotaccent=333,e.summation=600,e.Egrave=611,e.racute=389,e.omacron=500,e.Zacute=556,e.Zcaron=556,e.greaterequal=549,e.Eth=722,e.Ccedilla=667,e.lcommaaccent=278,e.tcaron=300,e.eogonek=444,e.Uogonek=722,e.Aacute=611,e.Adieresis=611,e.egrave=444,e.zacute=389,e.iogonek=278,e.Oacute=722,e.oacute=500,e.amacron=500,e.sacute=389,e.idieresis=278,e.Ocircumflex=722,e.Ugrave=722,e.Delta=612,e.thorn=500,e.twosuperior=300,e.Odieresis=722,e.mu=500,e.igrave=278,e.ohungarumlaut=500,e.Eogonek=611,e.dcroat=500,e.threequarters=750,e.Scedilla=500,e.lcaron=300,e.Kcommaaccent=667,e.Lacute=556,e.trademark=980,e.edotaccent=444,e.Igrave=333,e.Imacron=333,e.Lcaron=611,e.onehalf=750,e.lessequal=549,e.ocircumflex=500,e.ntilde=500,e.Uhungarumlaut=722,e.Eacute=611,e.emacron=444,e.gbreve=500,e.onequarter=750,e.Scaron=500,e.Scommaaccent=500,e.Ohungarumlaut=722,e.degree=400,e.ograve=500,e.Ccaron=667,e.ugrave=500,e.radical=453,e.Dcaron=722,e.rcommaaccent=389,e.Ntilde=667,e.otilde=500,e.Rcommaaccent=611,e.Lcommaaccent=556,e.Atilde=611,e.Aogonek=611,e.Aring=611,e.Otilde=722,e.zdotaccent=389,e.Ecaron=611,e.Iogonek=333,e.kcommaaccent=444,e.minus=675,e.Icircumflex=333,e.ncaron=500,e.tcommaaccent=278,e.logicalnot=675,e.odieresis=500,e.udieresis=500,e.notequal=549,e.gcommaaccent=500,e.eth=500,e.zcaron=389,e.ncommaaccent=500,e.onesuperior=300,e.imacron=278,e.Euro=500})),e.ZapfDingbats=(0,a.getLookupTableFactory)((function(e){e.space=278,e.a1=974,e.a2=961,e.a202=974,e.a3=980,e.a4=719,e.a5=789,e.a119=790,e.a118=791,e.a117=690,e.a11=960,e.a12=939,e.a13=549,e.a14=855,e.a15=911,e.a16=933,e.a105=911,e.a17=945,e.a18=974,e.a19=755,e.a20=846,e.a21=762,e.a22=761,e.a23=571,e.a24=677,e.a25=763,e.a26=760,e.a27=759,e.a28=754,e.a6=494,e.a7=552,e.a8=537,e.a9=577,e.a10=692,e.a29=786,e.a30=788,e.a31=788,e.a32=790,e.a33=793,e.a34=794,e.a35=816,e.a36=823,e.a37=789,e.a38=841,e.a39=823,e.a40=833,e.a41=816,e.a42=831,e.a43=923,e.a44=744,e.a45=723,e.a46=749,e.a47=790,e.a48=792,e.a49=695,e.a50=776,e.a51=768,e.a52=792,e.a53=759,e.a54=707,e.a55=708,e.a56=682,e.a57=701,e.a58=826,e.a59=815,e.a60=789,e.a61=789,e.a62=707,e.a63=687,e.a64=696,e.a65=689,e.a66=786,e.a67=787,e.a68=713,e.a69=791,e.a70=785,e.a71=791,e.a72=873,e.a73=761,e.a74=762,e.a203=762,e.a75=759,e.a204=759,e.a76=892,e.a77=892,e.a78=788,e.a79=784,e.a81=438,e.a82=138,e.a83=277,e.a84=415,e.a97=392,e.a98=392,e.a99=668,e.a100=668,e.a89=390,e.a90=390,e.a93=317,e.a94=317,e.a91=276,e.a92=276,e.a205=509,e.a85=509,e.a206=410,e.a86=410,e.a87=234,e.a88=234,e.a95=334,e.a96=334,e.a101=732,e.a102=544,e.a103=544,e.a104=910,e.a106=667,e.a107=760,e.a108=760,e.a112=776,e.a111=595,e.a110=694,e.a109=626,e.a120=788,e.a121=788,e.a122=788,e.a123=788,e.a124=788,e.a125=788,e.a126=788,e.a127=788,e.a128=788,e.a129=788,e.a130=788,e.a131=788,e.a132=788,e.a133=788,e.a134=788,e.a135=788,e.a136=788,e.a137=788,e.a138=788,e.a139=788,e.a140=788,e.a141=788,e.a142=788,e.a143=788,e.a144=788,e.a145=788,e.a146=788,e.a147=788,e.a148=788,e.a149=788,e.a150=788,e.a151=788,e.a152=788,e.a153=788,e.a154=788,e.a155=788,e.a156=788,e.a157=788,e.a158=788,e.a159=788,e.a160=894,e.a161=838,e.a163=1016,e.a164=458,e.a196=748,e.a165=924,e.a192=748,e.a166=918,e.a167=927,e.a168=928,e.a169=928,e.a170=834,e.a171=873,e.a172=828,e.a173=924,e.a162=924,e.a174=917,e.a175=930,e.a176=931,e.a177=463,e.a178=883,e.a179=836,e.a193=836,e.a180=867,e.a199=867,e.a181=696,e.a200=696,e.a182=874,e.a201=874,e.a183=760,e.a184=946,e.a197=771,e.a185=865,e.a194=771,e.a198=888,e.a186=967,e.a195=888,e.a187=831,e.a188=873,e.a189=927,e.a190=970,e.a191=918}))}));t.getMetrics=i},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.MurmurHash3_64=void 0;var a=r(2);const i=3285377520,n=4294901760,s=65535;t.MurmurHash3_64=class{constructor(e){this.h1=e?4294967295&e:i,this.h2=e?4294967295&e:i}update(e){let t,r;if((0,a.isString)(e)){t=new Uint8Array(2*e.length),r=0;for(let a=0,i=e.length;a<i;a++){const i=e.charCodeAt(a);i<=255?t[r++]=i:(t[r++]=i>>>8,t[r++]=255&i)}}else{if(!(0,a.isArrayBuffer)(e))throw new Error("Wrong data format in MurmurHash3_64_update. Input must be a string or array.");t=e.slice(),r=t.byteLength}const i=r>>2,o=r-4*i,c=new Uint32Array(t.buffer,0,i);let l=0,h=0,u=this.h1,d=this.h2;const f=3432918353,g=461845907,p=11601,m=13715;for(let e=0;e<i;e++)1&e?(l=c[e],l=l*f&n|l*p&s,l=l<<15|l>>>17,l=l*g&n|l*m&s,u^=l,u=u<<13|u>>>19,u=5*u+3864292196):(h=c[e],h=h*f&n|h*p&s,h=h<<15|h>>>17,h=h*g&n|h*m&s,d^=h,d=d<<13|d>>>19,d=5*d+3864292196);switch(l=0,o){case 3:l^=t[4*i+2]<<16;case 2:l^=t[4*i+1]<<8;case 1:l^=t[4*i],l=l*f&n|l*p&s,l=l<<15|l>>>17,l=l*g&n|l*m&s,1&i?u^=l:d^=l}this.h1=u,this.h2=d}hexdigest(){let e=this.h1,t=this.h2;e^=t>>>1,e=3981806797*e&n|36045*e&s,t=4283543511*t&n|(2950163797*(t<<16|e>>>16)&n)>>>16,e^=t>>>1,e=444984403*e&n|60499*e&s,t=3301882366*t&n|(3120437893*(t<<16|e>>>16)&n)>>>16,e^=t>>>1;const r=(e>>>0).toString(16),a=(t>>>0).toString(16);return r.padStart(8,"0")+a.padStart(8,"0")}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.OperatorList=void 0;var a=r(2);const i=function(){function e(e,t,r,a,i){let n=e;for(let e=0,r=t.length-1;e<r;e++){const r=t[e];n=n[r]||(n[r]=[])}n[t[t.length-1]]={checkFn:r,iterateFn:a,processFn:i}}const t=[];function r(e){this.queue=e,this.state=null,this.context={iCurr:0,fnArray:e.fnArray,argsArray:e.argsArray},this.match=null,this.lastProcessed=0}return e(t,[a.OPS.save,a.OPS.transform,a.OPS.paintInlineImageXObject,a.OPS.restore],null,(function(e,t){const r=e.fnArray,i=(t-(e.iCurr-3))%4;switch(i){case 0:return r[t]===a.OPS.save;case 1:return r[t]===a.OPS.transform;case 2:return r[t]===a.OPS.paintInlineImageXObject;case 3:return r[t]===a.OPS.restore}throw new Error(`iterateInlineImageGroup - invalid pos: ${i}`)}),(function(e,t){const r=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=n-1,l=Math.min(Math.floor((t-s)/4),200);if(l<10)return t-(t-s)%4;let h=0;const u=[];let d=0,f=1,g=1;for(let e=0;e<l;e++){const t=i[o+(e<<2)],r=i[c+(e<<2)][0];f+r.width>1e3&&(h=Math.max(h,f),g+=d+2,f=0,d=0),u.push({transform:t,x:f,y:g,w:r.width,h:r.height}),f+=r.width+2,d=Math.max(d,r.height)}const p=Math.max(h,f)+1,m=g+d+1,b=new Uint8ClampedArray(p*m*4),y=p<<2;for(let e=0;e<l;e++){const t=i[c+(e<<2)][0].data,r=u[e].w<<2;let a=0,n=u[e].x+u[e].y*p<<2;b.set(t.subarray(0,r),n-y);for(let i=0,s=u[e].h;i<s;i++)b.set(t.subarray(a,a+r),n),a+=r,n+=y;for(b.set(t.subarray(a-r,a),n);n>=0;)t[n-4]=t[n],t[n-3]=t[n+1],t[n-2]=t[n+2],t[n-1]=t[n+3],t[n+r]=t[n+r-4],t[n+r+1]=t[n+r-3],t[n+r+2]=t[n+r-2],t[n+r+3]=t[n+r-1],n-=y}return r.splice(s,4*l,a.OPS.paintInlineImageXObjectGroup),i.splice(s,4*l,[{width:p,height:m,kind:a.ImageKind.RGBA_32BPP,data:b},u]),s+1})),e(t,[a.OPS.save,a.OPS.transform,a.OPS.paintImageMaskXObject,a.OPS.restore],null,(function(e,t){const r=e.fnArray,i=(t-(e.iCurr-3))%4;switch(i){case 0:return r[t]===a.OPS.save;case 1:return r[t]===a.OPS.transform;case 2:return r[t]===a.OPS.paintImageMaskXObject;case 3:return r[t]===a.OPS.restore}throw new Error(`iterateImageMaskGroup - invalid pos: ${i}`)}),(function(e,t){const r=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=n-1;let l=Math.floor((t-s)/4);if(l=function(e,t,r,i){const n=e+2;let s;for(s=0;s<t;s++){const e=i[n+4*s],t=1===e.length&&e[0];if(!t||1!==t.width||1!==t.height||t.data.length&&(1!==t.data.length||0!==t.data[0]))break;r[n+4*s]=a.OPS.paintSolidColorImageMask}return t-s}(s,l,r,i),l<10)return t-(t-s)%4;let h,u,d=!1;const f=i[c][0],g=i[o][0],p=i[o][1],m=i[o][2],b=i[o][3];if(p===m){d=!0,h=o+4;let e=c+4;for(let t=1;t<l;t++,h+=4,e+=4)if(u=i[h],i[e][0]!==f||u[0]!==g||u[1]!==p||u[2]!==m||u[3]!==b){t<10?d=!1:l=t;break}}if(d){l=Math.min(l,1e3);const e=new Float32Array(2*l);h=o;for(let t=0;t<l;t++,h+=4)u=i[h],e[t<<1]=u[4],e[1+(t<<1)]=u[5];r.splice(s,4*l,a.OPS.paintImageMaskXObjectRepeat),i.splice(s,4*l,[f,g,p,m,b,e])}else{l=Math.min(l,100);const e=[];for(let t=0;t<l;t++){u=i[o+(t<<2)];const r=i[c+(t<<2)][0];e.push({data:r.data,width:r.width,height:r.height,transform:u})}r.splice(s,4*l,a.OPS.paintImageMaskXObjectGroup),i.splice(s,4*l,[e])}return s+1})),e(t,[a.OPS.save,a.OPS.transform,a.OPS.paintImageXObject,a.OPS.restore],(function(e){const t=e.argsArray,r=e.iCurr-2;return 0===t[r][1]&&0===t[r][2]}),(function(e,t){const r=e.fnArray,i=e.argsArray,n=(t-(e.iCurr-3))%4;switch(n){case 0:return r[t]===a.OPS.save;case 1:if(r[t]!==a.OPS.transform)return!1;const n=e.iCurr-2,s=i[n][0],o=i[n][3];return i[t][0]===s&&0===i[t][1]&&0===i[t][2]&&i[t][3]===o;case 2:if(r[t]!==a.OPS.paintImageXObject)return!1;const c=i[e.iCurr-1][0];return i[t][0]===c;case 3:return r[t]===a.OPS.restore}throw new Error(`iterateImageGroup - invalid pos: ${n}`)}),(function(e,t){const r=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=i[n-1][0],l=i[o][0],h=i[o][3],u=Math.min(Math.floor((t-s)/4),1e3);if(u<3)return t-(t-s)%4;const d=new Float32Array(2*u);let f=o;for(let e=0;e<u;e++,f+=4){const t=i[f];d[e<<1]=t[4],d[1+(e<<1)]=t[5]}const g=[c,l,h,d];return r.splice(s,4*u,a.OPS.paintImageXObjectRepeat),i.splice(s,4*u,g),s+1})),e(t,[a.OPS.beginText,a.OPS.setFont,a.OPS.setTextMatrix,a.OPS.showText,a.OPS.endText],null,(function(e,t){const r=e.fnArray,i=e.argsArray,n=(t-(e.iCurr-4))%5;switch(n){case 0:return r[t]===a.OPS.beginText;case 1:return r[t]===a.OPS.setFont;case 2:return r[t]===a.OPS.setTextMatrix;case 3:if(r[t]!==a.OPS.showText)return!1;const n=e.iCurr-3,s=i[n][0],o=i[n][1];return i[t][0]===s&&i[t][1]===o;case 4:return r[t]===a.OPS.endText}throw new Error(`iterateShowTextGroup - invalid pos: ${n}`)}),(function(e,t){const r=e.fnArray,a=e.argsArray,i=e.iCurr,n=i-4,s=i-3,o=i-2,c=i-1,l=i,h=a[s][0],u=a[s][1];let d=Math.min(Math.floor((t-n)/5),1e3);if(d<3)return t-(t-n)%5;let f=n;n>=4&&r[n-4]===r[s]&&r[n-3]===r[o]&&r[n-2]===r[c]&&r[n-1]===r[l]&&a[n-4][0]===h&&a[n-4][1]===u&&(d++,f-=5);let g=f+4;for(let e=1;e<d;e++)r.splice(g,3),a.splice(g,3),g+=2;return g+1})),r.prototype={_optimize(){const e=this.queue.fnArray;let r=this.lastProcessed,a=e.length,i=this.state,n=this.match;if(!i&&!n&&r+1===a&&!t[e[r]])return void(this.lastProcessed=a);const s=this.context;for(;r<a;){if(n){if((0,n.iterateFn)(s,r)){r++;continue}if(r=(0,n.processFn)(s,r+1),a=e.length,n=null,i=null,r>=a)break}i=(i||t)[e[r]],i&&!Array.isArray(i)?(s.iCurr=r,r++,!i.checkFn||(0,i.checkFn)(s)?(n=i,i=null):i=null):r++}this.state=i,this.match=n,this.lastProcessed=r},push(e,t){this.queue.fnArray.push(e),this.queue.argsArray.push(t),this._optimize()},flush(){for(;this.match;){const e=this.queue.fnArray.length;this.lastProcessed=(0,this.match.processFn)(this.context,e),this.match=null,this.state=null,this._optimize()}},reset(){this.state=null,this.match=null,this.lastProcessed=0}},r}(),n=function(){function e(e){this.queue=e}return e.prototype={push(e,t){this.queue.fnArray.push(e),this.queue.argsArray.push(t)},flush(){},reset(){}},e}(),s=function(){function e(e,t){this._streamSink=t,this.fnArray=[],this.argsArray=[],this.optimizer=t&&"oplist"!==e?new i(this):new n(this),this.dependencies=new Set,this._totalLength=0,this.weight=0,this._resolved=t?null:Promise.resolve()}return e.prototype={get length(){return this.argsArray.length},get ready(){return this._resolved||this._streamSink.ready},get totalLength(){return this._totalLength+this.length},addOp(e,t){this.optimizer.push(e,t),this.weight++,this._streamSink&&(this.weight>=1e3||this.weight>=995&&(e===a.OPS.restore||e===a.OPS.endText))&&this.flush()},addDependency(e){this.dependencies.has(e)||(this.dependencies.add(e),this.addOp(a.OPS.dependency,[e]))},addDependencies(e){for(const t of e)this.addDependency(t)},addOpList(t){if(t instanceof e){for(const e of t.dependencies)this.dependencies.add(e);for(let e=0,r=t.length;e<r;e++)this.addOp(t.fnArray[e],t.argsArray[e])}else(0,a.warn)('addOpList - ignoring invalid "opList" parameter.')},getIR(){return{fnArray:this.fnArray,argsArray:this.argsArray,length:this.length}},get _transfers(){const e=[],{fnArray:t,argsArray:r,length:i}=this;for(let n=0;n<i;n++)switch(t[n]){case a.OPS.paintInlineImageXObject:case a.OPS.paintInlineImageXObjectGroup:case a.OPS.paintImageMaskXObject:const t=r[n][0];t.cached||e.push(t.data.buffer);break}return e},flush(e=!1){this.optimizer.flush();const t=this.length;this._totalLength+=t,this._streamSink.enqueue({fnArray:this.fnArray,argsArray:this.argsArray,lastChunk:e,length:t},1,this._transfers),this.dependencies.clear(),this.fnArray.length=0,this.argsArray.length=0,this.weight=0,this.optimizer.reset()}},e}();t.OperatorList=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFImage=void 0;var a=r(2),i=r(5),n=r(23),s=r(12),o=r(18),c=r(21);function l(e,t,r,a){return(e=t+e*r)<0?e=0:e>a&&(e=a),e}function h(e,t,r,a,i,n){var s=i*n;let o;o=t<=8?new Uint8Array(s):t<=16?new Uint16Array(s):new Uint32Array(s);var c,l,h,u,d=r/i,f=a/n,g=0,p=new Uint16Array(i),m=r;for(c=0;c<i;c++)p[c]=Math.floor(c*d);for(c=0;c<n;c++)for(h=Math.floor(c*f)*m,l=0;l<i;l++)u=h+p[l],o[g++]=e[u];return o}class u{constructor({xref:e,res:t,image:r,isInline:s=!1,smask:o=null,mask:l=null,isMask:h=!1,pdfFunctionFactory:d,localColorSpaceCache:f}){this.image=r;var g=r.dict;const p=g.get("Filter");if((0,i.isName)(p))switch(p.name){case"JPXDecode":var m=new c.JpxImage;m.parseImageProperties(r.stream),r.stream.reset(),r.width=m.width,r.height=m.height,r.bitsPerComponent=m.bitsPerComponent,r.numComps=m.componentsCount;break;case"JBIG2Decode":r.bitsPerComponent=1,r.numComps=1;break}let b=g.get("Width","W"),y=g.get("Height","H");if(Number.isInteger(r.width)&&r.width>0&&Number.isInteger(r.height)&&r.height>0&&(r.width!==b||r.height!==y)&&((0,a.warn)("PDFImage - using the Width/Height of the image data, rather than the image dictionary."),b=r.width,y=r.height),b<1||y<1)throw new a.FormatError(`Invalid image width: ${b} or height: ${y}`);this.width=b,this.height=y,this.interpolate=g.get("Interpolate","I")||!1,this.imageMask=g.get("ImageMask","IM")||!1,this.matte=g.get("Matte")||!1;var w=r.bitsPerComponent;if(!w&&!(w=g.get("BitsPerComponent","BPC"))){if(!this.imageMask)throw new a.FormatError(`Bits per component missing in image: ${this.imageMask}`);w=1}if(this.bpc=w,!this.imageMask){let o=g.getRaw("ColorSpace")||g.getRaw("CS");if(!o)switch((0,a.info)("JPX images (which do not require color spaces)"),r.numComps){case 1:o=i.Name.get("DeviceGray");break;case 3:o=i.Name.get("DeviceRGB");break;case 4:o=i.Name.get("DeviceCMYK");break;default:throw new Error(`JPX images with ${r.numComps} color components not supported.`)}this.colorSpace=n.ColorSpace.parse({cs:o,xref:e,resources:s?t:null,pdfFunctionFactory:d,localColorSpaceCache:f}),this.numComps=this.colorSpace.numComps}if(this.decode=g.getArray("Decode","D"),this.needsDecode=!1,this.decode&&(this.colorSpace&&!this.colorSpace.isDefaultDecode(this.decode,w)||h&&!n.ColorSpace.isDefaultDecode(this.decode,1))){this.needsDecode=!0;var v=(1<<w)-1;this.decodeCoefficients=[],this.decodeAddends=[];const e=this.colorSpace&&"Indexed"===this.colorSpace.name;for(var S=0,k=0;S<this.decode.length;S+=2,++k){var x=this.decode[S],A=this.decode[S+1];this.decodeCoefficients[k]=e?(A-x)/v:A-x,this.decodeAddends[k]=e?x:v*x}}if(o)this.smask=new u({xref:e,res:t,image:o,isInline:s,pdfFunctionFactory:d,localColorSpaceCache:f});else if(l){if((0,i.isStream)(l))l.dict.get("ImageMask","IM")?this.mask=new u({xref:e,res:t,image:l,isInline:s,isMask:!0,pdfFunctionFactory:d,localColorSpaceCache:f}):(0,a.warn)("Ignoring /Mask in image without /ImageMask.");else this.mask=l}}static async buildImage({xref:e,res:t,image:r,isInline:n=!1,pdfFunctionFactory:s,localColorSpaceCache:o}){const c=r;let l=null,h=null;const d=r.dict.get("SMask"),f=r.dict.get("Mask");return d?l=d:f&&((0,i.isStream)(f)||Array.isArray(f)?h=f:(0,a.warn)("Unsupported mask format.")),new u({xref:e,res:t,image:c,isInline:n,smask:l,mask:h,pdfFunctionFactory:s,localColorSpaceCache:o})}static createMask({imgArray:e,width:t,height:r,imageIsFromDecodeStream:a,inverseDecode:i}){var n,s,o=(t+7>>3)*r,c=e.byteLength;if(!a||i&&!(o===c))if(i)for((n=new Uint8ClampedArray(o)).set(e),s=c;s<o;s++)n[s]=255;else(n=new Uint8ClampedArray(c)).set(e);else n=e;if(i)for(s=0;s<c;s++)n[s]^=255;return{data:n,width:t,height:r}}get drawWidth(){return Math.max(this.width,this.smask&&this.smask.width||0,this.mask&&this.mask.width||0)}get drawHeight(){return Math.max(this.height,this.smask&&this.smask.height||0,this.mask&&this.mask.height||0)}decodeBuffer(e){var t,r,a=this.bpc,i=this.numComps,n=this.decodeAddends,s=this.decodeCoefficients,o=(1<<a)-1;if(1!==a){var c=0;for(t=0,r=this.width*this.height;t<r;t++)for(var h=0;h<i;h++)e[c]=l(e[c],n[h],s[h],o),c++}else for(t=0,r=e.length;t<r;t++)e[t]=+!e[t]}getComponents(e){var t=this.bpc;if(8===t)return e;var r=this.width,a=this.height,i=this.numComps,n=r*a*i,s=0;let o;o=t<=8?new Uint8Array(n):t<=16?new Uint16Array(n):new Uint32Array(n);var c,l,h=r*i,u=(1<<t)-1,d=0;if(1===t)for(var f,g,p,m=0;m<a;m++){for(g=d+(-8&h),p=d+h;d<g;)l=e[s++],o[d]=l>>7&1,o[d+1]=l>>6&1,o[d+2]=l>>5&1,o[d+3]=l>>4&1,o[d+4]=l>>3&1,o[d+5]=l>>2&1,o[d+6]=l>>1&1,o[d+7]=1&l,d+=8;if(d<p)for(l=e[s++],f=128;d<p;)o[d++]=+!!(l&f),f>>=1}else{var b=0;for(l=0,d=0,c=n;d<c;++d){for(d%h==0&&(l=0,b=0);b<t;)l=l<<8|e[s++],b+=8;var y=b-t;let r=l>>y;r<0?r=0:r>u&&(r=u),o[d]=r,l&=(1<<y)-1,b=y}}return o}fillOpacity(e,t,r,i,n){var s,o,c,l,d,f,g=this.smask,p=this.mask;if(g)o=g.width,c=g.height,s=new Uint8ClampedArray(o*c),g.fillGrayBuffer(s),o===t&&c===r||(s=h(s,g.bpc,o,c,t,r));else if(p)if(p instanceof u){for(o=p.width,c=p.height,s=new Uint8ClampedArray(o*c),p.numComps=1,p.fillGrayBuffer(s),l=0,d=o*c;l<d;++l)s[l]=255-s[l];o===t&&c===r||(s=h(s,p.bpc,o,c,t,r))}else{if(!Array.isArray(p))throw new a.FormatError("Unknown mask format.");s=new Uint8ClampedArray(t*r);var m=this.numComps;for(l=0,d=t*r;l<d;++l){var b=0,y=l*m;for(f=0;f<m;++f){var w=n[y+f],v=2*f;if(w<p[v]||w>p[v+1]){b=255;break}}s[l]=b}}if(s)for(l=0,f=3,d=t*i;l<d;++l,f+=4)e[f]=s[l];else for(l=0,f=3,d=t*i;l<d;++l,f+=4)e[f]=255}undoPreblend(e,t,r){var a=this.smask&&this.smask.matte;if(a)for(var i=this.colorSpace.getRgb(a,0),n=i[0],s=i[1],o=i[2],c=t*r*4,l=0;l<c;l+=4){var h=e[l+3];if(0!==h){var u=255/h;e[l]=(e[l]-n)*u+n,e[l+1]=(e[l+1]-s)*u+s,e[l+2]=(e[l+2]-o)*u+o}else e[l]=255,e[l+1]=255,e[l+2]=255}}createImageData(e=!1){var t,r=this.drawWidth,i=this.drawHeight,n={width:r,height:i,kind:0,data:null},c=this.numComps,l=this.width,h=this.height,u=this.bpc,d=l*c*u+7>>3;if(!e){var f;if("DeviceGray"===this.colorSpace.name&&1===u?f=a.ImageKind.GRAYSCALE_1BPP:"DeviceRGB"!==this.colorSpace.name||8!==u||this.needsDecode||(f=a.ImageKind.RGB_24BPP),f&&!this.smask&&!this.mask&&r===l&&i===h){if(n.kind=f,t=this.getImageBytes(h*d),this.image instanceof s.DecodeStream)n.data=t;else{var g=new Uint8ClampedArray(t.length);g.set(t),n.data=g}if(this.needsDecode){(0,a.assert)(f===a.ImageKind.GRAYSCALE_1BPP,"PDFImage.createImageData: The image must be grayscale.");for(var p=n.data,m=0,b=p.length;m<b;m++)p[m]^=255}return n}if(this.image instanceof o.JpegStream&&!this.smask&&!this.mask){let e=h*d;switch(this.colorSpace.name){case"DeviceGray":e*=3;case"DeviceRGB":case"DeviceCMYK":return n.kind=a.ImageKind.RGB_24BPP,n.data=this.getImageBytes(e,r,i,!0),n}}}var y,w,v=0|(t=this.getImageBytes(h*d)).length/d*i/h,S=this.getComponents(t);return e||this.smask||this.mask?(n.kind=a.ImageKind.RGBA_32BPP,n.data=new Uint8ClampedArray(r*i*4),y=1,w=!0,this.fillOpacity(n.data,r,i,v,S)):(n.kind=a.ImageKind.RGB_24BPP,n.data=new Uint8ClampedArray(r*i*3),y=0,w=!1),this.needsDecode&&this.decodeBuffer(S),this.colorSpace.fillRgb(n.data,l,h,r,i,v,u,S,y),w&&this.undoPreblend(n.data,r,v),n}fillGrayBuffer(e){var t=this.numComps;if(1!==t)throw new a.FormatError(`Reading gray scale from a color image: ${t}`);var r,i,n=this.width,s=this.height,o=this.bpc,c=n*t*o+7>>3,l=this.getImageBytes(s*c),h=this.getComponents(l);if(1!==o){this.needsDecode&&this.decodeBuffer(h),i=n*s;var u=255/((1<<o)-1);for(r=0;r<i;++r)e[r]=u*h[r]}else if(i=n*s,this.needsDecode)for(r=0;r<i;++r)e[r]=h[r]-1&255;else for(r=0;r<i;++r)e[r]=255&-h[r]}getImageBytes(e,t,r,a=!1){return this.image.reset(),this.image.drawWidth=t||this.width,this.image.drawHeight=r||this.height,this.image.forceRGB=!!a,this.image.getBytes(e,!0)}}t.PDFImage=u},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.incrementalUpdate=function({originalData:e,xrefInfo:t,newRefs:r,xref:l=null,datasetsRef:d=null}){!function(e,t,r){if(null===e||null===r)return;const i=r.fetchIfRef(e),o=(0,a.bytesToString)(i.getBytes()),c=new s.SimpleXMLParser({hasAttributes:!0}).parseFromString(o);for(const{xfa:e}of t){if(!e)continue;const{path:t,value:r}=e;if(!t)continue;const i=c.documentElement.searchNode((0,n.parseXFAPath)(t),0);i?i.childNodes=[new s.SimpleDOMNode("#text",r)]:(0,a.warn)(`Node not found for path: ${t}`)}const l=[];c.documentElement.dump(l);let h=l.join("");const u=r.encrypt;if(u){h=u.createCipherTransform(e.num,e.gen).encryptString(h)}const d=`${e.num} ${e.gen} obj\n<< /Type /EmbeddedFile /Length ${h.length}>>\nstream\n`+h+"\nendstream\nendobj\n";t.push({ref:e,data:d})}(d,r,l);const f=new i.Dict(null),g=t.newRef;let p,m;const b=e[e.length-1];10===b||13===b?(p=[],m=e.length):(p=["\n"],m=e.length+1);f.set("Size",g.num+1),f.set("Prev",t.startXRef),f.set("Type",i.Name.get("XRef")),null!==t.rootRef&&f.set("Root",t.rootRef);null!==t.infoRef&&f.set("Info",t.infoRef);null!==t.encrypt&&f.set("Encrypt",t.encrypt);r.push({ref:g,data:""}),r=r.sort(((e,t)=>e.ref.num-t.ref.num));const y=[[0,1,65535]],w=[0,1];let v=0;for(const{ref:e,data:t}of r)v=Math.max(v,m),y.push([1,m,Math.min(e.gen,65535)]),m+=t.length,w.push(e.num),w.push(1),p.push(t);if(f.set("Index",w),0!==t.fileIds.length){const e=function(e,t){const r=Math.floor(Date.now()/1e3),i=t.filename||"",n=[r.toString(),i,e.toString()];let s=n.reduce(((e,t)=>e+t.length),0);for(const e of Object.values(t.info))n.push(e),s+=e.length;const c=new Uint8Array(s);let l=0;for(const e of n)u(e,l,c),l+=e.length;return(0,a.bytesToString)((0,o.calculateMD5)(c))}(m,t);f.set("ID",[t.fileIds[0],e])}const S=[1,Math.ceil(Math.log2(v)/8),2],k=(S[0]+S[1]+S[2])*y.length;f.set("W",S),f.set("Length",k),p.push(`${g.num} ${g.gen} obj\n`),c(f,p,null),p.push(" stream\n");const x=p.reduce(((e,t)=>e+t.length),0),A=`\nendstream\nendobj\nstartxref\n${m}\n%%EOF\n`,C=new Uint8Array(e.length+x+k+A.length);C.set(e);let O=e.length;for(const e of p)u(e,O,C),O+=e.length;for(const[e,t,r]of y)O=h(e,S[0],O,C),O=h(t,S[1],O,C),O=h(r,S[2],O,C);return u(A,O,C),C},t.writeDict=c;var a=r(2),i=r(5),n=r(8),s=r(26),o=r(22);function c(e,t,r){t.push("<<");for(const a of e.getKeys())t.push(` /${(0,n.escapePDFName)(a)} `),l(e.getRaw(a),t,r);t.push(">>")}function l(e,t,r){(0,i.isName)(e)?t.push(`/${(0,n.escapePDFName)(e.name)}`):(0,i.isRef)(e)?t.push(`${e.num} ${e.gen} R`):Array.isArray(e)?function(e,t,r){t.push("[");let a=!0;for(const i of e)a?a=!1:t.push(" "),l(i,t,r);t.push("]")}(e,t,r):"string"==typeof e?(null!==r&&(e=r.encryptString(e)),t.push(`(${(0,a.escapeString)(e)})`)):"number"==typeof e?t.push(function(e){if(Number.isInteger(e))return e.toString();const t=Math.round(100*e);return t%100==0?(t/100).toString():t%10==0?e.toFixed(1):e.toFixed(2)}(e)):(0,i.isDict)(e)?c(e,t,r):(0,i.isStream)(e)&&function(e,t,r){c(e.dict,t,r),t.push(" stream\n");let i=(0,a.bytesToString)(e.getBytes());null!==r&&(i=r.encryptString(i)),t.push(i),t.push("\nendstream\n")}(e,t,r)}function h(e,t,r,a){for(let i=t+r-1;i>r-1;i--)a[i]=255&e,e>>=8;return r+t}function u(e,t,r){for(let a=0,i=e.length;a<i;a++)r[t+a]=255&e.charCodeAt(a)}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XFAFactory=void 0;var a=r(50),i=r(53),n=r(57);class s{constructor(e){try{this.root=(new n.XFAParser).parse(s._createDocument(e)),this.form=new i.Binder(this.root).bind(),this.pages=this.form[a.$toHTML]()}catch(e){}}getPage(e){return this.pages.children[e]}get numberPages(){return this.pages.children.length}static _createDocument(e){return e["/xdp:xdp"]?Object.values(e).join(""):e["xdp:xdp"]}}t.XFAFactory=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XmlObject=t.XFAObjectArray=t.XFAObject=t.XFAAttribute=t.StringObject=t.OptionObject=t.Option10=t.Option01=t.IntegerObject=t.ContentObject=t.$uid=t.$toStyle=t.$toHTML=t.$text=t.$setValue=t.$setSetAttributes=t.$setId=t.$resolvePrototypes=t.$removeChild=t.$onText=t.$onChildCheck=t.$onChild=t.$nsAttributes=t.$nodeName=t.$namespaceId=t.$isTransparent=t.$isDescendent=t.$isDataValue=t.$insertAt=t.$indexOf=t.$hasSettableValue=t.$hasItem=t.$global=t.$getRealChildrenByNameIt=t.$getParent=t.$getChildrenByNameIt=t.$getChildrenByName=t.$getChildrenByClass=t.$getChildren=t.$getAttributeIt=t.$finalize=t.$extra=t.$dump=t.$data=t.$content=t.$consumed=t.$clone=t.$cleanup=t.$clean=t.$childrenToHTML=t.$appendChild=void 0;var a=r(51),i=r(2),n=r(52);const s=Symbol();t.$appendChild=s;const o=Symbol();t.$childrenToHTML=o;const c=Symbol();t.$clean=c;const l=Symbol();t.$cleanup=l;const h=Symbol();t.$clone=h;const u=Symbol();t.$consumed=u;const d=Symbol("content");t.$content=d;const f=Symbol("data");t.$data=f;const g=Symbol();t.$dump=g;const p=Symbol("extra");t.$extra=p;const m=Symbol();t.$finalize=m;const b=Symbol();t.$getAttributeIt=b;const y=Symbol();t.$getChildrenByClass=y;const w=Symbol();t.$getChildrenByName=w;const v=Symbol();t.$getChildrenByNameIt=v;const S=Symbol();t.$getRealChildrenByNameIt=S;const k=Symbol();t.$getChildren=k;const x=Symbol();t.$getParent=x;const A=Symbol();t.$global=A;const C=Symbol();t.$hasItem=C;const O=Symbol();t.$hasSettableValue=O;const F=Symbol();t.$indexOf=F;const I=Symbol();t.$insertAt=I;const T=Symbol();t.$isDataValue=T;const P=Symbol();t.$isDescendent=P;const E=Symbol();t.$isTransparent=E;const M=Symbol(),N=Symbol("namespaceId");t.$namespaceId=N;const D=Symbol("nodeName");t.$nodeName=D;const B=Symbol();t.$nsAttributes=B;const j=Symbol();t.$onChild=j;const L=Symbol();t.$onChildCheck=L;const R=Symbol();t.$onText=R;const _=Symbol();t.$removeChild=_;const U=Symbol();t.$resolvePrototypes=U;const X=Symbol();t.$setId=X;const $=Symbol();t.$setSetAttributes=$;const q=Symbol();t.$setValue=q;const z=Symbol();t.$text=z;const H=Symbol();t.$toHTML=H;const G=Symbol();t.$toStyle=G;const V=Symbol("uid");t.$uid=V;const W=Symbol(),K=Symbol(),Y=Symbol(),J=Symbol("_children"),Z=Symbol(),Q=Symbol(),ee=Symbol(),te=Symbol(),re=Symbol(),ae=Symbol(),ie=Symbol(),ne=Symbol(),se=Symbol("parent"),oe=Symbol(),ce=Symbol();let le=0;class he{constructor(e,t,r=!1){this[N]=e,this[D]=t,this[ae]=r,this[se]=null,this[J]=[],this[V]=`${t}${le++}`}[j](e){if(!this[ae]||!this[L](e))return!1;const t=e[D],r=this[t];if(!(r instanceof ue))return null!==r&&this[_](r),this[t]=e,this[s](e),!0;if(r.push(e))return this[s](e),!0;let a="";return this.id?a=` (id: ${this.id})`:this.name&&(a=` (name: ${this.name} ${this.h.value})`),(0,i.warn)(`XFA - node "${this[D]}"${a} has already enough "${t}"!`),!1}[L](e){return this.hasOwnProperty(e[D])&&e[N]===this[N]}[X](e){this.id&&this[N]===n.NamespaceIds.template.id&&e.set(this.id,this)}[s](e){e[se]=this,this[J].push(e)}[_](e){const t=this[J].indexOf(e);this[J].splice(t,1)}[O](){return this.hasOwnProperty("value")}[q](e){}[R](e){}[m](){}[c](e){delete this[ae],this[l]&&(e.clean(this[l]),delete this[l])}[C](){return!1}[F](e){return this[J].indexOf(e)}[I](e,t){t[se]=this,this[J].splice(e,0,t)}[E](){return""===this.name}[M](){return""}[z](){return 0===this[J].length?this[d]:this[J].map((e=>e[z]())).join("")}get[Y](){const e=Object.getPrototypeOf(this);if(!e._attributes){const t=e._attributes=new Set;for(const e of Object.getOwnPropertyNames(this)){if(null===this[e]||this[e]instanceof he||this[e]instanceof ue)break;t.add(e)}}return(0,i.shadow)(this,Y,e._attributes)}[P](e){let t=this;for(;t;){if(t===e)return!0;t=t[x]()}return!1}[x](){return this[se]}[k](e=null){return e?this[e]:this[J]}[g](){const e=Object.create(null);this[d]&&(e.$content=this[d]);for(const t of Object.getOwnPropertyNames(this)){const r=this[t];null!==r&&(r instanceof he?e[t]=r[g]():r instanceof ue?r.isEmpty()||(e[t]=r.dump()):e[t]=r)}return e}[G](){return null}[H](){return null}[o]({filter:e=null,include:t=!0}){const r=[];return this[k]().forEach((a=>{if(!e||t===e.has(a[D])){const e=a[H]();e&&r.push(e)}})),r}[$](e){(e.use||e.id)&&(this[oe]=new Set(Object.keys(e)))}[re](e){const t=this[Y],r=this[oe];return[...e].filter((e=>t.has(e)&&!r.has(e)))}[U](e,t=new Set){for(const r of this[J]){const a=r[te](e,t);a?r[W](a,e,t):r[U](e,t)}}[te](e,t){const{use:r}=this;if(r&&r.startsWith("#")){const a=r.slice(1),n=e.get(a);if(this.use="",!n)return(0,i.warn)(`XFA - Invalid prototype id: ${a}.`),null;if(n[D]!==this[D])return(0,i.warn)(`XFA - Incompatible prototype: ${n[D]} !== ${this[D]}.`),null;if(t.has(n))return(0,i.warn)("XFA - Cycle detected in prototypes use."),null;t.add(n);const s=n[te](e,t);return s?(n[W](s,e,t),t.delete(n),n):(t.delete(n),n)}return null}[W](e,t,r){if(r.has(e))return void(0,i.warn)("XFA - Cycle detected in prototypes use.");!this[d]&&e[d]&&(this[d]=e[d]);const a=new Set(r);a.add(e);for(const t of this[re](e[oe]))this[t]=e[t],this[oe]&&this[oe].add(t);for(const i of Object.getOwnPropertyNames(this)){if(this[Y].has(i))continue;const n=this[i],s=e[i];if(n instanceof ue){for(const e of n[J])e[U](t,r);for(let r=n[J].length,i=s[J].length;r<i;r++){const i=e[J][r][h]();if(!n.push(i))break;i[se]=this,this[J].push(i),i[U](t,a)}}else if(null===n){if(null!==s){const e=s[h]();e[se]=this,this[i]=e,this[J].push(e),e[U](t,a)}}else n[U](t,r)}}static[Z](e){return Array.isArray(e)?e.map((e=>he[Z](e))):e instanceof Object?Object.assign({},e):e}[h](){const e=Object.create(Object.getPrototypeOf(this));for(const t of Object.getOwnPropertySymbols(this))try{e[t]=this[t]}catch(r){(0,i.shadow)(e,t,this[t])}e[J]=[];for(const t of Object.getOwnPropertyNames(this)){if(this[Y].has(t)){e[t]=he[Z](this[t]);continue}const r=this[t];e[t]=r instanceof ue?new ue(r[ie]):null}for(const t of this[J]){const r=t[D],a=t[h]();e[J].push(a),a[se]=e,null===e[r]?e[r]=a:e[r][J].push(a)}return e}[k](e=null){return e?this[J].filter((t=>t[D]===e)):this[J]}[y](e){return this[e]}[w](e,t,r=!0){return Array.from(this[v](e,t,r))}*[v](e,t,r=!0){if("parent"!==e){for(const r of this[J])r[D]===e&&(yield r),r.name===e&&(yield r),(t||r[E]())&&(yield*r[v](e,t,!1));r&&this[Y].has(e)&&(yield new de(this,e,this[e]))}else yield this[se]}}t.XFAObject=he;class ue{constructor(e=1/0){this[ie]=e,this[J]=[]}push(e){return this[J].length<=this[ie]?(this[J].push(e),!0):((0,i.warn)(`XFA - node "${e[D]}" accepts no more than ${this[ie]} children`),!1)}isEmpty(){return 0===this[J].length}dump(){return 1===this[J].length?this[J][0][g]():this[J].map((e=>e[g]()))}[h](){const e=new ue(this[ie]);return e[J]=this[J].map((e=>e[h]())),e}get children(){return this[J]}clear(){this[J].length=0}}t.XFAObjectArray=ue;class de{constructor(e,t,r){this[se]=e,this[D]=t,this[d]=r,this[u]=!1}[x](){return this[se]}[T](){return!0}[z](){return this[d]}[P](e){return this[se]===e||this[se][P](e)}}t.XFAAttribute=de;class fe extends he{constructor(e,t,r={}){if(super(e,t),this[d]="",this[Q]=null,"#text"!==t){const e=new Map;this[K]=e;for(const[t,a]of Object.entries(r))e.set(t,new de(this,t,a));if(r.hasOwnProperty(B)){const e=r[B].xfa.dataNode;void 0!==e&&("dataGroup"===e?this[Q]=!1:"dataValue"===e&&(this[Q]=!0))}}this[u]=!1}[j](e){if(this[d]){const e=new fe(this[N],"#text");this[s](e),e[d]=this[d],this[d]=""}return this[s](e),!0}[R](e){this[d]+=e}[m](){if(this[d]&&this[J].length>0){const e=new fe(this[N],"#text");this[s](e),e[d]=this[d],delete this[d]}}[H](){return"#text"===this[D]?{name:"#text",value:this[d]}:null}[k](e=null){return e?this[J].filter((t=>t[D]===e)):this[J]}[y](e){const t=this[K].get(e);return void 0!==t?t:this[k](e)}*[v](e,t){const r=this[K].get(e);r&&(yield r);for(const r of this[J])r[D]===e&&(yield r),t&&(yield*r[v](e,t))}*[b](e,t){const r=this[K].get(e);!r||t&&r[u]||(yield r);for(const r of this[J])yield*r[b](e,t)}*[S](e,t,r){for(const a of this[J])a[D]!==e||r&&a[u]||(yield a),t&&(yield*a[S](e,t,r))}[T](){return null===this[Q]?0===this[J].length:this[Q]}[g](){const e=Object.create(null);this[d]&&(e.$content=this[d]),e.$name=this[D],e.children=[];for(const t of this[J])e.children.push(t[g]());e.attributes=Object.create(null);for(const[t,r]of this[K])e.attributes[t]=r[d];return e}}t.XmlObject=fe;class ge extends he{constructor(e,t){super(e,t),this[d]=""}[R](e){this[d]+=e}[m](){}}t.ContentObject=ge;t.OptionObject=class extends ge{constructor(e,t,r){super(e,t),this[ne]=r}[m](){this[d]=(0,a.getKeyword)({data:this[d],defaultValue:this[ne][0],validate:e=>this[ne].includes(e)})}[c](e){super[c](e),delete this[ne]}};t.StringObject=class extends ge{[m](){this[d]=this[d].trim()}};class pe extends ge{constructor(e,t,r,a){super(e,t),this[ee]=r,this[ce]=a}[m](){this[d]=(0,a.getInteger)({data:this[d],defaultValue:this[ee],validate:this[ce]})}[c](e){super[c](e),delete this[ee],delete this[ce]}}t.IntegerObject=pe;t.Option01=class extends pe{constructor(e,t){super(e,t,0,(e=>1===e))}};t.Option10=class extends pe{constructor(e,t){super(e,t,1,(e=>0===e))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getBBox=function(e){const t=-1;if(!e)return{x:t,y:t,width:t,height:t};const r=e.trim().split(/\s*,\s*/).map((e=>n(e,"-1")));if(r.length<4||r[2]<0||r[3]<0)return{x:t,y:t,width:t,height:t};const[a,i,s,o]=r;return{x:a,y:i,width:s,height:o}},t.getColor=function(e,t=[0,0,0]){let[r,a,i]=t;if(!e)return{r:r,g:a,b:i};const n=e.trim().split(/\s*,\s*/).map((e=>Math.min(Math.max(0,parseInt(e.trim(),10)),255))).map((e=>isNaN(e)?0:e));if(n.length<3)return{r:r,g:a,b:i};return[r,a,i]=n,{r:r,g:a,b:i}},t.getFloat=function({data:e,defaultValue:t,validate:r}){if(!e)return t;e=e.trim();const a=parseFloat(e);if(!isNaN(a)&&r(a))return a;return t},t.getInteger=function({data:e,defaultValue:t,validate:r}){if(!e)return t;e=e.trim();const a=parseInt(e,10);if(!isNaN(a)&&r(a))return a;return t},t.getKeyword=i,t.getMeasurement=n,t.getRatio=function(e){if(!e)return{num:1,den:1};const t=e.trim().split(/\s*:\s*/).map((e=>parseFloat(e))).filter((e=>!isNaN(e)));1===t.length&&t.push(1);if(0===t.length)return{num:1,den:1};const[r,a]=t;return{num:r,den:a}},t.getRelevant=function(e){if(!e)return[];return e.trim().split(/\s+/).map((e=>({excluded:"-"===e[0],viewname:e.substring(1)})))},t.getStringOption=function(e,t){return i({data:e,defaultValue:t[0],validate:e=>t.includes(e)})};const r={pt:e=>e,cm:e=>e/2.54*72,mm:e=>e/25.4*72,in:e=>72*e},a=/([+-]?[0-9]+\.?[0-9]*)(.*)/;function i({data:e,defaultValue:t,validate:r}){return e&&r(e=e.trim())?e:t}function n(e,t="0"){if(t=t||"0",!e)return n(t);const i=e.trim().match(a);if(!i)return n(t);const[,s,o]=i,c=parseFloat(s);if(isNaN(c))return n(t);if(0===c)return 0;const l=r[o];return l?l(c):c}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.NamespaceIds=t.$buildXFAObject=void 0;const r=Symbol();t.$buildXFAObject=r;t.NamespaceIds={config:{id:0,check:e=>e.startsWith("http://www.xfa.org/schema/xci/")},connectionSet:{id:1,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-connection-set/")},datasets:{id:2,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-data/")},form:{id:3,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-form/")},localeSet:{id:4,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-locale-set/")},pdf:{id:5,check:e=>"http://ns.adobe.com/xdp/pdf/"===e},signature:{id:6,check:e=>"http://www.w3.org/2000/09/xmldsig#"===e},sourceSet:{id:7,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-source-set/")},stylesheet:{id:8,check:e=>"http://www.w3.org/1999/XSL/Transform"===e},template:{id:9,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-template/")},xdc:{id:10,check:e=>e.startsWith("http://www.xfa.org/schema/xdc/")},xdp:{id:11,check:e=>"http://ns.adobe.com/xdp/"===e},xfdf:{id:12,check:e=>"http://ns.adobe.com/xfdf/"===e},xhtml:{id:13,check:e=>"http://www.w3.org/1999/xhtml"===e},xmpmeta:{id:14,check:e=>"http://ns.adobe.com/xmpmeta/"===e}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Binder=void 0;var a=r(50),i=r(54),n=r(56),s=r(52),o=r(2);function c(e){const t=new i.Text({});return t[a.$content]=e,t}t.Binder=class{constructor(e){this.root=e,this.datasets=e.datasets,e.datasets&&e.datasets.data?(this.emptyMerge=!1,this.data=e.datasets.data):(this.emptyMerge=!0,this.data=new a.XmlObject(s.NamespaceIds.datasets.id,"data")),this.root.form=this.form=e.template[a.$clone]()}_isConsumeData(){return!this.emptyMerge&&this._mergeMode}_isMatchTemplate(){return!this._isConsumeData()}bind(){return this._bindElement(this.form,this.data),this.form}getData(){return this.data}_bindValue(e,t,r){if(e[a.$hasSettableValue]())if(t[a.$isDataValue]()){const r=t[a.$content].trim();e[a.$setValue](c(r)),e[a.$data]=t}else if(e instanceof i.Field&&e.ui&&e.ui.choiceList&&"multiSelect"===e.ui.choiceList.open){const r=t[a.$getChildren]().map((e=>e[a.$content].trim())).join("\n");e[a.$setValue](c(r)),e[a.$data]=t}else this._isConsumeData()&&(0,o.warn)("XFA - Nodes haven't the same type.");else!t[a.$isDataValue]()||this._isMatchTemplate()?(this._bindElement(e,t),e[a.$data]=t):(0,o.warn)("XFA - Nodes haven't the same type.")}_findDataByNameToConsume(e,t,r){if(!e)return null;let i,n;for(let r=0;r<3;r++){if(i=t[a.$getRealChildrenByNameIt](e,!1,!0),n=i.next().value,n)return n;if(t[a.$namespaceId]===s.NamespaceIds.datasets.id&&"data"===t[a.$nodeName])break;t=t[a.$getParent]()}if(!r)return null;for(i=this.datasets[a.$getRealChildrenByNameIt](e,!1,!1);n=i.next().value,n;)if(n[a.$global])return n;return i=this.data[a.$getAttributeIt](e,!0),n=i.next().value,n&&n[a.$isDataValue]()?n:null}_setProperties(e,t){if(e.hasOwnProperty("setProperty"))for(const{ref:r,target:s,connection:c}of e.setProperty.children){if(c)continue;if(!r)continue;const[l]=(0,n.searchNode)(this.root,t,r,!1,!1);if(!l){(0,o.warn)(`XFA - Invalid reference: ${r}.`);continue}if(!l[a.$isDescendent](this.data)){(0,o.warn)("XFA - Invalid node: must be a data node.");continue}const[h]=(0,n.searchNode)(this.root,e,s,!1,!1);if(!h){(0,o.warn)(`XFA - Invalid target: ${s}.`);continue}if(!h[a.$isDescendent](e)){(0,o.warn)("XFA - Invalid target: must be a property or subproperty.");continue}const u=h[a.$getParent]();if(h instanceof i.SetProperty||u instanceof i.SetProperty){(0,o.warn)("XFA - Invalid target: cannot be a setProperty or one of its properties.");continue}if(h instanceof i.BindItems||u instanceof i.BindItems){(0,o.warn)("XFA - Invalid target: cannot be a bindItems or one of its properties.");continue}const d=l[a.$text](),f=h[a.$nodeName];if(h instanceof a.XFAAttribute){const e=Object.create(null);e[f]=d;const t=Reflect.construct(Object.getPrototypeOf(u).constructor,[e]);u[f]=t[f]}else h.hasOwnProperty(a.$content)?(h[a.$data]=l,h[a.$content]=d,h[a.$finalize]()):(0,o.warn)("XFA - Invalid node to use in setProperty")}}_bindItems(e,t){if(!e.hasOwnProperty("items")||!e.hasOwnProperty("bindItems")||e.bindItems.isEmpty())return;for(const t of e.items.children)e[a.$removeChild](t);e.items.clear();const r=new i.Items({}),s=new i.Items({});e[a.$appendChild](r),e.items.push(r),e[a.$appendChild](s),e.items.push(s);for(const{ref:i,labelRef:l,valueRef:h,connection:u}of e.bindItems.children){if(u)continue;if(!i)continue;const e=(0,n.searchNode)(this.root,t,i,!1,!1);if(e)for(const t of e){if(!t[a.$isDescendent](this.datasets)){(0,o.warn)(`XFA - Invalid ref (${i}): must be a datasets child.`);continue}const[e]=(0,n.searchNode)(this.root,t,l,!0,!1);if(!e){(0,o.warn)(`XFA - Invalid label: ${l}.`);continue}if(!e[a.$isDescendent](this.datasets)){(0,o.warn)("XFA - Invalid label: must be a datasets child.");continue}const[u]=(0,n.searchNode)(this.root,t,h,!0,!1);if(!u){(0,o.warn)(`XFA - Invalid value: ${h}.`);continue}if(!u[a.$isDescendent](this.datasets)){(0,o.warn)("XFA - Invalid value: must be a datasets child.");continue}const d=c(e[a.$text]()),f=c(u[a.$text]());r[a.$appendChild](d),r.text.push(d),s[a.$appendChild](f),s.text.push(f)}else(0,o.warn)(`XFA - Invalid reference: ${i}.`)}}_bindOccurrences(e,t,r){let i;if(t.length>1&&(i=e[a.$clone]()),this._bindValue(e,t[0],r),this._setProperties(e,t[0]),this._bindItems(e,t[0]),1===t.length)return;const n=e[a.$getParent](),s=e[a.$nodeName],o=n[a.$indexOf](e);for(let e=1,c=t.length;e<c;e++){const c=t[e],l=i[a.$clone]();l.occur.min=1,l.occur.max=1,l.occur.initial=1,n[s].push(l),n[a.$insertAt](o+e,l),this._bindValue(l,c,r),this._setProperties(l,c),this._bindItems(l,c)}}_createOccurrences(e){if(!this.emptyMerge)return;const{occur:t}=e;if(!t||t.initial<=1)return;const r=e[a.$getParent](),i=e[a.$nodeName];for(let n=0,s=t.initial;n<s;n++){const t=e[a.$clone]();t.occur.min=1,t.occur.max=1,t.occur.initial=1,r[i].push(t),r[a.$appendChild](t)}}_getOccurInfo(e){const{occur:t}=e,r=e.name;if(!t||!r)return[1,1];const a=-1===t.max?1/0:t.max;return[t.min,a]}_bindElement(e,t){const r=[];this._createOccurrences(e);for(const i of e[a.$getChildren]()){if(i[a.$data])continue;void 0===this._mergeMode&&"subform"===i[a.$nodeName]&&(this._mergeMode="consumeData"===i.mergeMode);let s=!1,c=null,l=null,h=null;if(i.bind){switch(i.bind.match){case"none":continue;case"global":s=!0;break;case"dataRef":if(!i.bind.ref){(0,o.warn)(`XFA - ref is empty in node ${i[a.$nodeName]}.`);continue}l=i.bind.ref;break;default:break}i.bind.picture&&(c=i.bind.picture[a.$content])}const[u,d]=this._getOccurInfo(i);if(l)h=(0,n.searchNode)(this.root,t,l,!0,!1),null===h?(h=(0,n.createDataNode)(this.data,t,l),this._isConsumeData()&&(h[a.$consumed]=!0),h=[h]):(this._isConsumeData()&&(h=h.filter((e=>!e[a.$consumed]))),h.length>d?h=h.slice(0,d):0===h.length&&(h=null),h&&this._isConsumeData()&&h.forEach((e=>{e[a.$consumed]=!0})));else{if(!i.name){this._bindElement(i,t);continue}if(this._isConsumeData()){const e=[];for(;e.length<d;){const r=this._findDataByNameToConsume(i.name,t,s);if(!r)break;r[a.$consumed]=!0,e.push(r)}h=e.length>0?e:null}else h=t[a.$getRealChildrenByNameIt](i.name,!1,!1).next().value,h||(h=new a.XmlObject(t[a.$namespaceId],i.name),t[a.$appendChild](h)),h=[h]}if(h){if(h.length<u){(0,o.warn)(`XFA - Must have at least ${u} occurrences: ${e[a.$nodeName]}.`);continue}this._bindOccurrences(i,h,c)}else u>0?this._bindElement(i,t):r.push(i)}r.forEach((e=>e[a.$getParent]()[a.$removeChild](e)))}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Value=t.Text=t.TemplateNamespace=t.Template=t.SetProperty=t.Items=t.Field=t.BindItems=void 0;var a=r(50),i=r(52),n=r(51),s=r(55),o=r(2);const c=i.NamespaceIds.template.id;function l(e,t){if(!e.value){const t=new ft({});e[a.$appendChild](t),e.value=t}e.value[a.$setValue](t)}class h extends a.StringObject{constructor(e){super(c,"appearanceFilter"),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||""}}class u extends a.XFAObject{constructor(e){super(c,"arc",!0),this.circular=(0,n.getInteger)({data:e.circular,defaultValue:0,validate:e=>1===e}),this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]),this.id=e.id||"",this.startAngle=(0,n.getFloat)({data:e.startAngle,defaultValue:0,validate:e=>!0}),this.sweepAngle=(0,n.getFloat)({data:e.sweepAngle,defaultValue:360,validate:e=>!0}),this.use=e.use||"",this.usehref=e.usehref||"",this.edge=null,this.fill=null}}class d extends a.XFAObject{constructor(e){super(c,"area",!0),this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1}),this.id=e.id||"",this.name=e.name||"",this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.x=(0,n.getMeasurement)(e.x,"0pt"),this.y=(0,n.getMeasurement)(e.y,"0pt"),this.desc=null,this.extras=null,this.area=new a.XFAObjectArray,this.draw=new a.XFAObjectArray,this.exObject=new a.XFAObjectArray,this.exclGroup=new a.XFAObjectArray,this.field=new a.XFAObjectArray,this.subform=new a.XFAObjectArray,this.subformSet=new a.XFAObjectArray}[a.$isTransparent](){return!0}}class f extends a.XFAObject{constructor(e){super(c,"assist",!0),this.id=e.id||"",this.role=e.role||"",this.use=e.use||"",this.usehref=e.usehref||"",this.speak=null,this.toolTip=null}}class g extends a.XFAObject{constructor(e){super(c,"barcode",!0),this.charEncoding=(0,n.getKeyword)({data:e.charEncoding?e.charEncoding.toLowerCase():"",defaultValue:"",validate:e=>["utf-8","big-five","fontspecific","gbk","gb-18030","gb-2312","ksc-5601","none","shift-jis","ucs-2","utf-16"].includes(e)||e.match(/iso-8859-[0-9]{2}/)}),this.checksum=(0,n.getStringOption)(e.checksum,["none","1mod10","1mod10_1mod11","2mod10","auto"]),this.dataColumnCount=(0,n.getInteger)({data:e.dataColumnCount,defaultValue:-1,validate:e=>e>=0}),this.dataLength=(0,n.getInteger)({data:e.dataLength,defaultValue:-1,validate:e=>e>=0}),this.dataPrep=(0,n.getStringOption)(e.dataPrep,["none","flateCompress"]),this.dataRowCount=(0,n.getInteger)({data:e.dataRowCount,defaultValue:-1,validate:e=>e>=0}),this.endChar=e.endChar||"",this.errorCorrectionLevel=(0,n.getInteger)({data:e.errorCorrectionLevel,defaultValue:-1,validate:e=>e>=0&&e<=8}),this.id=e.id||"",this.moduleHeight=(0,n.getMeasurement)(e.moduleHeight,"5mm"),this.moduleWidth=(0,n.getMeasurement)(e.moduleWidth,"0.25mm"),this.printCheckDigit=(0,n.getInteger)({data:e.printCheckDigit,defaultValue:0,validate:e=>1===e}),this.rowColumnRatio=(0,n.getRatio)(e.rowColumnRatio),this.startChar=e.startChar||"",this.textLocation=(0,n.getStringOption)(e.textLocation,["below","above","aboveEmbedded","belowEmbedded","none"]),this.truncate=(0,n.getInteger)({data:e.truncate,defaultValue:0,validate:e=>1===e}),this.type=(0,n.getStringOption)(e.type?e.type.toLowerCase():"",["aztec","codabar","code2of5industrial","code2of5interleaved","code2of5matrix","code2of5standard","code3of9","code3of9extended","code11","code49","code93","code128","code128a","code128b","code128c","code128sscc","datamatrix","ean8","ean8add2","ean8add5","ean13","ean13add2","ean13add5","ean13pwcd","fim","logmars","maxicode","msi","pdf417","pdf417macro","plessey","postauscust2","postauscust3","postausreplypaid","postausstandard","postukrm4scc","postusdpbc","postusimb","postusstandard","postus5zip","qrcode","rfid","rss14","rss14expanded","rss14limited","rss14stacked","rss14stackedomni","rss14truncated","telepen","ucc128","ucc128random","ucc128sscc","upca","upcaadd2","upcaadd5","upcapwcd","upce","upceadd2","upceadd5","upcean2","upcean5","upsmaxicode"]),this.upsMode=(0,n.getStringOption)(e.upsMode,["usCarrier","internationalCarrier","secureSymbol","standardSymbol"]),this.use=e.use||"",this.usehref=e.usehref||"",this.wideNarrowRatio=(0,n.getRatio)(e.wideNarrowRatio),this.encrypt=null,this.extras=null}}class p extends a.XFAObject{constructor(e){super(c,"bind",!0),this.match=(0,n.getStringOption)(e.match,["once","dataRef","global","none"]),this.ref=e.ref||"",this.picture=null}}class m extends a.XFAObject{constructor(e){super(c,"bindItems"),this.connection=e.connection||"",this.labelRef=e.labelRef||"",this.ref=e.ref||"",this.valueRef=e.valueRef||""}}t.BindItems=m;class b extends a.XFAObject{constructor(e){super(c,"bookend"),this.id=e.id||"",this.leader=e.leader||"",this.trailer=e.trailer||"",this.use=e.use||"",this.usehref=e.usehref||""}}class y extends a.Option01{constructor(e){super(c,"boolean"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$toHTML](){return 1===this[a.$content]}}class w extends a.XFAObject{constructor(e){super(c,"border",!0),this.break=(0,n.getStringOption)(e.break,["close","open"]),this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]),this.id=e.id||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.corner=new a.XFAObjectArray(4),this.edge=new a.XFAObjectArray(4),this.extras=null,this.fill=null,this.margin=null}[a.$toStyle](e,t){const r=this.edge.children.map((e=>e[a.$toStyle]())),i=this.edge.children.map((e=>e[a.$toStyle]()));let n;if(this.margin?(n=this.margin[a.$toStyle](),t&&t.push(this.margin.topInset,this.margin.rightInset,this.margin.bottomInset,this.margin.leftInset)):(n=Object.create(null),t&&t.push(0,0,0,0)),this.fill&&Object.assign(n,this.fill[a.$toStyle]()),r.length>0){if(e&&(this.edge.children.forEach((t=>e.push(t.thickness))),e.length<4)){const t=e[e.length-1];for(let r=e.length;r<4;r++)e.push(t)}if(2===r.length||3===r.length){const e=r[r.length-1];for(let t=r.length;t<4;t++)r.push(e)}n.borderWidth=r.map((e=>e.width)).join(" "),n.borderColor=r.map((e=>e.color)).join(" "),n.borderStyle=r.map((e=>e.style)).join(" ")}else e&&e.push(0,0,0,0);if(i.length>0){if(2===i.length||3===i.length){const e=i[i.length-1];for(let t=i.length;t<4;t++)i.push(e)}n.borderRadius=i.map((e=>e.radius)).join(" ")}switch(this.presence){case"invisible":case"hidden":n.borderStyle="";break;case"inactive":n.borderStyle="none";break}return n}}class v extends a.XFAObject{constructor(e){super(c,"break",!0),this.after=(0,n.getStringOption)(e.after,["auto","contentArea","pageArea","pageEven","pageOdd"]),this.afterTarget=e.afterTarget||"",this.before=(0,n.getStringOption)(e.before,["auto","contentArea","pageArea","pageEven","pageOdd"]),this.beforeTarget=e.beforeTarget||"",this.bookendLeader=e.bookendLeader||"",this.bookendTrailer=e.bookendTrailer||"",this.id=e.id||"",this.overflowLeader=e.overflowLeader||"",this.overflowTarget=e.overflowTarget||"",this.overflowTrailer=e.overflowTrailer||"",this.startNew=(0,n.getInteger)({data:e.startNew,defaultValue:0,validate:e=>1===e}),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}}class S extends a.XFAObject{constructor(e){super(c,"breakAfter",!0),this.id=e.id||"",this.leader=e.leader||"",this.startNew=(0,n.getInteger)({data:e.startNew,defaultValue:0,validate:e=>1===e}),this.target=e.target||"",this.targetType=(0,n.getStringOption)(e.targetType,["auto","contentArea","pageArea","pageEven","pageOdd"]),this.trailer=e.trailer||"",this.use=e.use||"",this.usehref=e.usehref||"",this.script=null}}class k extends a.XFAObject{constructor(e){super(c,"breakBefore",!0),this.id=e.id||"",this.leader=e.leader||"",this.startNew=(0,n.getInteger)({data:e.startNew,defaultValue:0,validate:e=>1===e}),this.target=e.target||"",this.targetType=(0,n.getStringOption)(e.targetType,["auto","contentArea","pageArea","pageEven","pageOdd"]),this.trailer=e.trailer||"",this.use=e.use||"",this.usehref=e.usehref||"",this.script=null}}class x extends a.XFAObject{constructor(e){super(c,"button",!0),this.highlight=(0,n.getStringOption)(e.highlight,["inverted","none","outline","push"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}[a.$toHTML](){return{name:"button",attributes:{class:"xfaButton",style:{}}}}}class A extends a.XFAObject{constructor(e){super(c,"calculate",!0),this.id=e.id||"",this.override=(0,n.getStringOption)(e.override,["disabled","error","ignore","warning"]),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.message=null,this.script=null}}class C extends a.XFAObject{constructor(e){super(c,"caption",!0),this.id=e.id||"",this.placement=(0,n.getStringOption)(e.placement,["left","bottom","inline","right","top"]),this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.reserve=(0,n.getMeasurement)(e.reserve),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.font=null,this.margin=null,this.para=null,this.value=null}[a.$setValue](e){l(this,e)}[a.$toHTML](){if(!this.value)return null;const e=this.value[a.$toHTML]();if(!e)return null;const t=[];"string"==typeof e?t.push({name:"#text",value:e}):t.push(e);const r=(0,s.toStyle)(this,"font","margin","para","visibility");switch(this.placement){case"left":case"right":r.minWidth=(0,s.measureToString)(this.reserve);break;case"top":case"bottom":r.minHeight=(0,s.measureToString)(this.reserve);break}return{name:"div",attributes:{style:r},children:t}}}class O extends a.StringObject{constructor(e){super(c,"certificate"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class F extends a.XFAObject{constructor(e){super(c,"certificates",!0),this.credentialServerPolicy=(0,n.getStringOption)(e.credentialServerPolicy,["optional","required"]),this.id=e.id||"",this.url=e.url||"",this.urlPolicy=e.urlPolicy||"",this.use=e.use||"",this.usehref=e.usehref||"",this.encryption=null,this.issuers=null,this.keyUsage=null,this.oids=null,this.signing=null,this.subjectDNs=null}}class I extends a.XFAObject{constructor(e){super(c,"checkButton",!0),this.id=e.id||"",this.mark=(0,n.getStringOption)(e.mark,["default","check","circle","cross","diamond","square","star"]),this.shape=(0,n.getStringOption)(e.shape,["square","round"]),this.size=(0,n.getMeasurement)(e.size,"10pt"),this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.extras=null,this.margin=null}[a.$toHTML](){const e=(0,s.toStyle)(this,"border","margin"),t=(0,s.measureToString)(this.size);let r,a;if(e.width=e.height=t,"square"===this.shape?(r="■",a="10%"):(r="●",a="50%"),e.borderRadius||(e.borderRadius=a),"default"!==this.mark)switch(this.mark){case"check":r="✓";break;case"circle":r="●";break;case"cross":r="✕";break;case"diamond":r="♦";break;case"square":r="■";break;case"star":r="★";break}return"10px"!==t&&(e.fontSize=t,e.lineHeight=t,e.width=t,e.height=t),{name:"label",attributes:{class:"xfaLabel"},children:[{name:"input",attributes:{class:"xfaCheckbox",type:"checkbox"}},{name:"span",attributes:{class:"xfaCheckboxMark",mark:r,style:e}}]}}}class T extends a.XFAObject{constructor(e){super(c,"choiceList",!0),this.commitOn=(0,n.getStringOption)(e.commitOn,["select","exit"]),this.id=e.id||"",this.open=(0,n.getStringOption)(e.open,["userControl","always","multiSelect","onEntry"]),this.textEntry=(0,n.getInteger)({data:e.textEntry,defaultValue:0,validate:e=>1===e}),this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.extras=null,this.margin=null}[a.$toHTML](){const e=(0,s.toStyle)(this,"border","margin");return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"select",attributes:{class:"xfaSxelect",multiple:"multiSelect"===this.open,style:e}}]}}}class P extends a.XFAObject{constructor(e){super(c,"color",!0),this.cSpace=(0,n.getStringOption)(e.cSpace,["SRGB"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.value=(0,n.getColor)(e.value),this.extras=null}[a.$hasSettableValue](){return!1}[a.$toStyle](){return o.Util.makeHexColor(this.value.r,this.value.g,this.value.b)}}class E extends a.XFAObject{constructor(e){super(c,"comb"),this.id=e.id||"",this.numberOfCells=(0,n.getInteger)({data:e.numberOfCells,defaultValue:0,validate:e=>e>=0}),this.use=e.use||"",this.usehref=e.usehref||""}}class M extends a.XFAObject{constructor(e){super(c,"connect",!0),this.connection=e.connection||"",this.id=e.id||"",this.ref=e.ref||"",this.usage=(0,n.getStringOption)(e.usage,["exportAndImport","exportOnly","importOnly"]),this.use=e.use||"",this.usehref=e.usehref||"",this.picture=null}}class N extends a.XFAObject{constructor(e){super(c,"contentArea",!0),this.h=(0,n.getMeasurement)(e.h),this.id=e.id||"",this.name=e.name||"",this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.w=(0,n.getMeasurement)(e.w),this.x=(0,n.getMeasurement)(e.x,"0pt"),this.y=(0,n.getMeasurement)(e.y,"0pt"),this.desc=null,this.extras=null}[a.$toHTML](){return{name:"div",children:[],attributes:{style:{position:"absolute",left:(0,s.measureToString)(this.x),top:(0,s.measureToString)(this.y),width:(0,s.measureToString)(this.w),height:(0,s.measureToString)(this.h)},class:"xfaContentarea",id:this[a.$uid]}}}}class D extends a.XFAObject{constructor(e){super(c,"corner",!0),this.id=e.id||"",this.inverted=(0,n.getInteger)({data:e.inverted,defaultValue:0,validate:e=>1===e}),this.join=(0,n.getStringOption)(e.join,["square","round"]),this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.radius=(0,n.getMeasurement)(e.radius),this.stroke=(0,n.getStringOption)(e.stroke,["solid","dashDot","dashDotDot","dashed","dotted","embossed","etched","lowered","raised"]),this.thickness=(0,n.getMeasurement)(e.thickness,"0.5pt"),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null}[a.$toStyle](){const e=(0,s.toStyle)(this,"visibility");return e.radius=(0,s.measureToString)(this.radius),e}}class B extends a.ContentObject{constructor(e){super(c,"date"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Date(this[a.$content].trim())}[a.$toHTML](){return this[a.$content].toString()}}class j extends a.ContentObject{constructor(e){super(c,"dateTime"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Date(this[a.$content].trim())}[a.$toHTML](){return this[a.$content].toString()}}class L extends a.XFAObject{constructor(e){super(c,"dateTimeEdit",!0),this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]),this.id=e.id||"",this.picker=(0,n.getStringOption)(e.picker,["host","none"]),this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.comb=null,this.extras=null,this.margin=null}[a.$toHTML](){return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"input",attributes:{type:"text",class:"xfaTextfield",style:(0,s.toStyle)(this,"border","font","margin")}}]}}}class R extends a.ContentObject{constructor(e){super(c,"decimal"),this.fracDigits=(0,n.getInteger)({data:e.fracDigits,defaultValue:2,validate:e=>!0}),this.id=e.id||"",this.leadDigits=(0,n.getInteger)({data:e.leadDigits,defaultValue:-1,validate:e=>!0}),this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){const e=parseFloat(this[a.$content].trim());this[a.$content]=isNaN(e)?null:e}[a.$toHTML](){return null!==this[a.$content]?this[a.$content].toString():""}}class _ extends a.XFAObject{constructor(e){super(c,"defaultUi",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}}class U extends a.XFAObject{constructor(e){super(c,"desc",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.boolean=new a.XFAObjectArray,this.date=new a.XFAObjectArray,this.dateTime=new a.XFAObjectArray,this.decimal=new a.XFAObjectArray,this.exData=new a.XFAObjectArray,this.float=new a.XFAObjectArray,this.image=new a.XFAObjectArray,this.integer=new a.XFAObjectArray,this.text=new a.XFAObjectArray,this.time=new a.XFAObjectArray}}class X extends a.OptionObject{constructor(e){super(c,"digestMethod",["","SHA1","SHA256","SHA512","RIPEMD160"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||""}}class $ extends a.XFAObject{constructor(e){super(c,"digestMethods",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.digestMethod=new a.XFAObjectArray}}class q extends a.XFAObject{constructor(e){super(c,"draw",!0),this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]),this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1}),this.h=e.h?(0,n.getMeasurement)(e.h):"",this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]),this.id=e.id||"",this.locale=e.locale||"",this.maxH=(0,n.getMeasurement)(e.maxH,"0pt"),this.maxW=(0,n.getMeasurement)(e.maxW,"0pt"),this.minH=(0,n.getMeasurement)(e.minH,"0pt"),this.minW=(0,n.getMeasurement)(e.minW,"0pt"),this.name=e.name||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.relevant=(0,n.getRelevant)(e.relevant),this.rotate=(0,n.getInteger)({data:e.rotate,defaultValue:0,validate:e=>e%90==0}),this.use=e.use||"",this.usehref=e.usehref||"",this.w=e.w?(0,n.getMeasurement)(e.w):"",this.x=(0,n.getMeasurement)(e.x,"0pt"),this.y=(0,n.getMeasurement)(e.y,"0pt"),this.assist=null,this.border=null,this.caption=null,this.desc=null,this.extras=null,this.font=null,this.keep=null,this.margin=null,this.para=null,this.traversal=null,this.ui=null,this.value=null,this.setProperty=new a.XFAObjectArray}[a.$setValue](e){l(this,e)}[a.$toHTML](){if(!this.value)return null;const e=(0,s.toStyle)(this,"font","dimensions","position","presence","rotate","anchorType"),t=["xfaDraw"];this.font&&t.push("xfaFont");const r={style:e,id:this[a.$uid],class:t.join(" ")};return this.name&&(r.xfaName=this.name),{name:"div",attributes:r,children:[]}}}class z extends a.XFAObject{constructor(e){super(c,"edge",!0),this.cap=(0,n.getStringOption)(e.cap,["square","butt","round"]),this.id=e.id||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.stroke=(0,n.getStringOption)(e.stroke,["solid","dashDot","dashDotDot","dashed","dotted","embossed","etched","lowered","raised"]),this.thickness=(0,n.getMeasurement)(e.thickness,"0.5pt"),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null}[a.$toStyle](){const e=(0,s.toStyle)(this,"visibility");if(Object.assign(e,{linecap:this.cap,width:(0,s.measureToString)(this.thickness),color:this.color?this.color[a.$toHTML]():"#000000",style:""}),"visible"!==this.presence)e.style="none";else switch(this.stroke){case"solid":e.style="solid";break;case"dashDot":e.style="dashed";break;case"dashDotDot":e.style="dashed";break;case"dashed":e.style="dashed";break;case"dotted":e.style="dotted";break;case"embossed":e.style="ridge";break;case"etched":e.style="groove";break;case"lowered":e.style="inset";break;case"raised":e.style="outset";break}return e}}class H extends a.OptionObject{constructor(e){super(c,"encoding",["adbe.x509.rsa_sha1","adbe.pkcs7.detached","adbe.pkcs7.sha1"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||""}}class G extends a.XFAObject{constructor(e){super(c,"encodings",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.encoding=new a.XFAObjectArray}}class V extends a.XFAObject{constructor(e){super(c,"encrypt",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.certificate=null}}class W extends a.XFAObject{constructor(e){super(c,"encryptData",!0),this.id=e.id||"",this.operation=(0,n.getStringOption)(e.operation,["encrypt","decrypt"]),this.target=e.target||"",this.use=e.use||"",this.usehref=e.usehref||"",this.filter=null,this.manifest=null}}class K extends a.XFAObject{constructor(e){super(c,"encryption",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.certificate=new a.XFAObjectArray}}class Y extends a.OptionObject{constructor(e){super(c,"encryptionMethod",["","AES256-CBC","TRIPLEDES-CBC","AES128-CBC","AES192-CBC"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||""}}class J extends a.XFAObject{constructor(e){super(c,"encryptionMethods",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.encryptionMethod=new a.XFAObjectArray}}class Z extends a.XFAObject{constructor(e){super(c,"event",!0),this.activity=(0,n.getStringOption)(e.activity,["click","change","docClose","docReady","enter","exit","full","indexChange","initialize","mouseDown","mouseEnter","mouseExit","mouseUp","postExecute","postOpen","postPrint","postSave","postSign","postSubmit","preExecute","preOpen","prePrint","preSave","preSign","preSubmit","ready","validationState"]),this.id=e.id||"",this.listen=(0,n.getStringOption)(e.listen,["refOnly","refAndDescendents"]),this.name=e.name||"",this.ref=e.ref||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.encryptData=null,this.execute=null,this.script=null,this.signData=null,this.submit=null}}class Q extends a.ContentObject{constructor(e){super(c,"exData"),this.contentType=e.contentType||"",this.href=e.href||"",this.id=e.id||"",this.maxLength=(0,n.getInteger)({data:e.maxLength,defaultValue:-1,validate:e=>e>=-1}),this.name=e.name||"",this.rid=e.rid||"",this.transferEncoding=(0,n.getStringOption)(e.transferEncoding,["none","base64","package"]),this.use=e.use||"",this.usehref=e.usehref||""}[a.$onChild](e){return("text/html"===this.contentType&&e[a.$namespaceId]===i.NamespaceIds.xhtml.id||"text/xml"===this.contentType)&&(this[a.$content]=e,!0)}}class ee extends a.XFAObject{constructor(e){super(c,"exObject",!0),this.archive=e.archive||"",this.classId=e.classId||"",this.codeBase=e.codeBase||"",this.codeType=e.codeType||"",this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.boolean=new a.XFAObjectArray,this.date=new a.XFAObjectArray,this.dateTime=new a.XFAObjectArray,this.decimal=new a.XFAObjectArray,this.exData=new a.XFAObjectArray,this.exObject=new a.XFAObjectArray,this.float=new a.XFAObjectArray,this.image=new a.XFAObjectArray,this.integer=new a.XFAObjectArray,this.text=new a.XFAObjectArray,this.time=new a.XFAObjectArray}}class te extends a.XFAObject{constructor(e){super(c,"exclGroup",!0),this.access=(0,n.getStringOption)(e.access,["open","nonInteractive","protected","readOnly"]),this.accessKey=e.accessKey||"",this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]),this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1}),this.h=e.h?(0,n.getMeasurement)(e.h):"",this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]),this.id=e.id||"",this.layout=(0,n.getStringOption)(e.layout,["position","lr-tb","rl-row","rl-tb","row","table","tb"]),this.maxH=(0,n.getMeasurement)(e.maxH,"0pt"),this.maxW=(0,n.getMeasurement)(e.maxW,"0pt"),this.minH=(0,n.getMeasurement)(e.minH,"0pt"),this.minW=(0,n.getMeasurement)(e.minW,"0pt"),this.name=e.name||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.w=e.w?(0,n.getMeasurement)(e.w):"",this.x=(0,n.getMeasurement)(e.x,"0pt"),this.y=(0,n.getMeasurement)(e.y,"0pt"),this.assist=null,this.bind=null,this.border=null,this.calculate=null,this.caption=null,this.desc=null,this.extras=null,this.margin=null,this.para=null,this.traversal=null,this.validate=null,this.connect=new a.XFAObjectArray,this.event=new a.XFAObjectArray,this.field=new a.XFAObjectArray,this.setProperty=new a.XFAObjectArray}[a.$hasSettableValue](){return!0}[a.$setValue](e){for(const t of this.field.children){if(!t.value){const e=new ft({});t[a.$appendChild](e),t.value=e}const r=new y({});r[a.$content]=0;for(const i of t.items.children)if(i[a.$hasItem](e)){r[a.$content]=1;break}t.value[a.$setValue](r)}}[a.$toHTML](){if(!this.value)return null;return{name:"div",attributes:{style:(0,s.toStyle)(this,"dimensions","position","anchorType"),id:this[a.$uid],class:"xfaExclgroup"},children:this[a.$childrenToHTML]({filter:new Set(["field"]),include:!0})}}}class re extends a.XFAObject{constructor(e){super(c,"execute"),this.connection=e.connection||"",this.executeType=(0,n.getStringOption)(e.executeType,["import","remerge"]),this.id=e.id||"",this.runAt=(0,n.getStringOption)(e.runAt,["client","both","server"]),this.use=e.use||"",this.usehref=e.usehref||""}}class ae extends a.XFAObject{constructor(e){super(c,"extras",!0),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||"",this.boolean=new a.XFAObjectArray,this.date=new a.XFAObjectArray,this.dateTime=new a.XFAObjectArray,this.decimal=new a.XFAObjectArray,this.exData=new a.XFAObjectArray,this.extras=new a.XFAObjectArray,this.float=new a.XFAObjectArray,this.image=new a.XFAObjectArray,this.integer=new a.XFAObjectArray,this.text=new a.XFAObjectArray,this.time=new a.XFAObjectArray}}class ie extends a.XFAObject{constructor(e){super(c,"field",!0),this.access=(0,n.getStringOption)(e.access,["open","nonInteractive","protected","readOnly"]),this.accessKey=e.accessKey||"",this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]),this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1}),this.h=e.h?(0,n.getMeasurement)(e.h):"",this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]),this.id=e.id||"",this.locale=e.locale||"",this.maxH=(0,n.getMeasurement)(e.maxH,"0pt"),this.maxW=(0,n.getMeasurement)(e.maxW,"0pt"),this.minH=(0,n.getMeasurement)(e.minH,"0pt"),this.minW=(0,n.getMeasurement)(e.minW,"0pt"),this.name=e.name||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.relevant=(0,n.getRelevant)(e.relevant),this.rotate=(0,n.getInteger)({data:e.rotate,defaultValue:0,validate:e=>e%90==0}),this.use=e.use||"",this.usehref=e.usehref||"",this.w=e.w?(0,n.getMeasurement)(e.w):"",this.x=(0,n.getMeasurement)(e.x,"0pt"),this.y=(0,n.getMeasurement)(e.y,"0pt"),this.assist=null,this.bind=null,this.border=null,this.calculate=null,this.caption=null,this.desc=null,this.extras=null,this.font=null,this.format=null,this.items=new a.XFAObjectArray(2),this.keep=null,this.margin=null,this.para=null,this.traversal=null,this.ui=null,this.validate=null,this.value=null,this.bindItems=new a.XFAObjectArray,this.connect=new a.XFAObjectArray,this.event=new a.XFAObjectArray,this.setProperty=new a.XFAObjectArray}[a.$setValue](e){l(this,e)}[a.$toHTML](){if(!this.ui)return null;const e=(0,s.toStyle)(this,"font","dimensions","position","rotate","anchorType","presence"),t=[],r=[];this.border&&Object.assign(e,this.border[a.$toStyle](t,r)),this.margin?(e.paddingTop=(0,s.measureToString)(this.margin.topInset-t[0]-r[0]),e.paddingRight=(0,s.measureToString)(this.margin.rightInset-t[1]-r[1]),e.paddingBottom=(0,s.measureToString)(this.margin.bottomInset-t[2]-r[2]),e.paddingLeft=(0,s.measureToString)(this.margin.leftInset-t[3]-r[3])):(e.paddingTop=(0,s.measureToString)(-t[0]-r[0]),e.paddingRight=(0,s.measureToString)(-t[1]-r[1]),e.paddingBottom=(0,s.measureToString)(-t[2]-r[2]),e.paddingLeft=(0,s.measureToString)(-t[3]-r[3]));const i=["xfaField"];this.font&&i.push("xfaFont");const n={style:e,id:this[a.$uid],class:i.join(" ")};this.name&&(n.xfaName=this.name);const o=[],c={name:"div",attributes:n,children:o},l=this.ui?this.ui[a.$toHTML]():null;if(!l)return c;l.attributes.style||(l.attributes.style=Object.create(null)),o.push(l),this.value&&"button"!==l.name&&(l.children[0].attributes.value=this.value[a.$toHTML]());const h=this.caption?this.caption[a.$toHTML]():null;if(!h)return c;if("button"===l.name)return l.attributes.style.background=e.color,delete e.color,"div"===h.name&&(h.name="span"),l.children=[h],c;switch(l.children.splice(0,0,h),this.caption.placement){case"left":l.attributes.style.flexDirection="row";break;case"right":l.attributes.style.flexDirection="row-reverse";break;case"top":l.attributes.style.flexDirection="column";break;case"bottom":l.attributes.style.flexDirection="column-reverse";break;case"inline":delete l.attributes.class,h.attributes.style.float="left";break}return c}}t.Field=ie;class ne extends a.XFAObject{constructor(e){super(c,"fill",!0),this.id=e.id||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null,this.linear=null,this.pattern=null,this.radial=null,this.solid=null,this.stipple=null}[a.$toStyle](){for(const e of Object.getOwnPropertyNames(this)){if("extras"===e||"color"===e)continue;const t=this[e];if(t instanceof a.XFAObject)return{color:t[a.$toStyle](this.color)}}return{color:this.color?this.color[a.$toStyle]():"#000000"}}}class se extends a.XFAObject{constructor(e){super(c,"filter",!0),this.addRevocationInfo=(0,n.getStringOption)(e.addRevocationInfo,["","required","optional","none"]),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||"",this.version=(0,n.getInteger)({data:this.version,defaultValue:5,validate:e=>e>=1&&e<=5}),this.appearanceFilter=null,this.certificates=null,this.digestMethods=null,this.encodings=null,this.encryptionMethods=null,this.handler=null,this.lockDocument=null,this.mdp=null,this.reasons=null,this.timeStamp=null}}class oe extends a.ContentObject{constructor(e){super(c,"float"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){const e=parseFloat(this[a.$content].trim());this[a.$content]=isNaN(e)?null:e}[a.$toHTML](){return null!==this[a.$content]?this[a.$content].toString():""}}class ce extends a.XFAObject{constructor(e){super(c,"font",!0),this.baselineShift=(0,n.getMeasurement)(e.baselineShift),this.fontHorizontalScale=(0,n.getFloat)({data:e.fontHorizontalScale,defaultValue:100,validate:e=>e>=0}),this.fontVerticalScale=(0,n.getFloat)({data:e.fontVerticalScale,defaultValue:100,validate:e=>e>=0}),this.id=e.id||"",this.kerningMode=(0,n.getStringOption)(e.kerningMode,["none","pair"]),this.letterSpacing=(0,n.getMeasurement)(e.letterSpacing,"0"),this.lineThrough=(0,n.getInteger)({data:e.lineThrough,defaultValue:0,validate:e=>1===e||2===e}),this.lineThroughPeriod=(0,n.getStringOption)(e.lineThroughPeriod,["all","word"]),this.overline=(0,n.getInteger)({data:e.overline,defaultValue:0,validate:e=>1===e||2===e}),this.overlinePeriod=(0,n.getStringOption)(e.overlinePeriod,["all","word"]),this.posture=(0,n.getStringOption)(e.posture,["normal","italic"]),this.size=(0,n.getMeasurement)(e.size,"10pt"),this.typeface=e.typeface||"",this.underline=(0,n.getInteger)({data:e.underline,defaultValue:0,validate:e=>1===e||2===e}),this.underlinePeriod=(0,n.getStringOption)(e.underlinePeriod,["all","word"]),this.use=e.use||"",this.usehref=e.usehref||"",this.weight=(0,n.getStringOption)(e.weight,["normal","bold"]),this.extras=null,this.fill=null}[a.$toStyle](){const e=(0,s.toStyle)(this,"fill");e.color&&(e.color.startsWith("#")?"#000000"===e.color&&delete e.color:(e.backgroundClip="text",e.background=e.color,e.color="transparent")),this.baselineShift&&(e.verticalAlign=(0,s.measureToString)(this.baselineShift)),"none"!==this.kerningMode&&(e.fontKerning="normal"),this.letterSpacing&&(e.letterSpacing=(0,s.measureToString)(this.letterSpacing)),0!==this.lineThrough&&(e.textDecoration="line-through",2===this.lineThrough&&(e.textDecorationStyle="double")),0!==this.overline&&(e.textDecoration="overline",2===this.overline&&(e.textDecorationStyle="double")),"normal"!==this.posture&&(e.fontStyle=this.posture);const t=(0,s.measureToString)(this.size);return"10px"!==t&&(e.fontSize=t),e.fontFamily=this.typeface,0!==this.underline&&(e.textDecoration="underline",2===this.underline&&(e.textDecorationStyle="double")),"normal"!==this.weight&&(e.fontWeight=this.weight),e}}class le extends a.XFAObject{constructor(e){super(c,"format",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.picture=null}}class he extends a.StringObject{constructor(e){super(c,"handler"),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||""}}class ue extends a.XFAObject{constructor(e){super(c,"hyphenation"),this.excludeAllCaps=(0,n.getInteger)({data:e.excludeAllCaps,defaultValue:0,validate:e=>1===e}),this.excludeInitialCap=(0,n.getInteger)({data:e.excludeInitialCap,defaultValue:0,validate:e=>1===e}),this.hyphenate=(0,n.getInteger)({data:e.hyphenate,defaultValue:0,validate:e=>1===e}),this.id=e.id||"",this.pushCharacterCount=(0,n.getInteger)({data:e.pushCharacterCount,defaultValue:3,validate:e=>e>=0}),this.remainCharacterCount=(0,n.getInteger)({data:e.remainCharacterCount,defaultValue:3,validate:e=>e>=0}),this.use=e.use||"",this.usehref=e.usehref||"",this.wordCharacterCount=(0,n.getInteger)({data:e.wordCharacterCount,defaultValue:7,validate:e=>e>=0})}}class de extends a.StringObject{constructor(e){super(c,"image"),this.aspect=(0,n.getStringOption)(e.aspect,["fit","actual","height","none","width"]),this.contentType=e.contentType||"",this.href=e.href||"",this.id=e.id||"",this.name=e.name||"",this.transferEncoding=(0,n.getStringOption)(e.transferEncoding,["base64","none","package"]),this.use=e.use||"",this.usehref=e.usehref||""}[a.$toHTML](){const e={name:"img",attributes:{style:{}}};if(this.href)return e.attributes.src=new URL(this.href),e;if("base64"===this.transferEncoding){const t=Uint8Array.from(atob(this[a.$content]),(e=>e.charCodeAt(0))),r=new Blob([t],{type:this.contentType});return e.attributes.src=URL.createObjectURL(r),e}return null}}class fe extends a.XFAObject{constructor(e){super(c,"imageEdit",!0),this.data=(0,n.getStringOption)(e.data,["link","embed"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.extras=null,this.margin=null}}class ge extends a.ContentObject{constructor(e){super(c,"integer"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){const e=parseInt(this[a.$content].trim(),10);this[a.$content]=isNaN(e)?null:e}[a.$toHTML](){return null!==this[a.$content]?this[a.$content].toString():""}}class pe extends a.XFAObject{constructor(e){super(c,"issuers",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.certificate=new a.XFAObjectArray}}class me extends a.XFAObject{constructor(e){super(c,"items",!0),this.id=e.id||"",this.name=e.name||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.ref=e.ref||"",this.save=(0,n.getInteger)({data:e.save,defaultValue:0,validate:e=>1===e}),this.use=e.use||"",this.usehref=e.usehref||"",this.boolean=new a.XFAObjectArray,this.date=new a.XFAObjectArray,this.dateTime=new a.XFAObjectArray,this.decimal=new a.XFAObjectArray,this.exData=new a.XFAObjectArray,this.float=new a.XFAObjectArray,this.image=new a.XFAObjectArray,this.integer=new a.XFAObjectArray,this.text=new a.XFAObjectArray,this.time=new a.XFAObjectArray}[a.$hasItem](e){return this.hasOwnProperty(e[a.$nodeName])&&this[e[a.$nodeName]].children.some((t=>t[a.$content]===e[a.$content]))}}t.Items=me;class be extends a.XFAObject{constructor(e){super(c,"keep",!0),this.id=e.id||"";const t=["none","contentArea","pageArea"];this.intact=(0,n.getStringOption)(e.intact,t),this.next=(0,n.getStringOption)(e.next,t),this.previous=(0,n.getStringOption)(e.previous,t),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}}class ye extends a.XFAObject{constructor(e){super(c,"keyUsage");const t=["","yes","no"];this.crlSign=(0,n.getStringOption)(e.crlSign,t),this.dataEncipherment=(0,n.getStringOption)(e.dataEncipherment,t),this.decipherOnly=(0,n.getStringOption)(e.decipherOnly,t),this.digitalSignature=(0,n.getStringOption)(e.digitalSignature,t),this.encipherOnly=(0,n.getStringOption)(e.encipherOnly,t),this.id=e.id||"",this.keyAgreement=(0,n.getStringOption)(e.keyAgreement,t),this.keyCertSign=(0,n.getStringOption)(e.keyCertSign,t),this.keyEncipherment=(0,n.getStringOption)(e.keyEncipherment,t),this.nonRepudiation=(0,n.getStringOption)(e.nonRepudiation,t),this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||""}}class we extends a.XFAObject{constructor(e){super(c,"line",!0),this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]),this.id=e.id||"",this.slope=(0,n.getStringOption)(e.slope,["\\","/"]),this.use=e.use||"",this.usehref=e.usehref||"",this.edge=null}}class ve extends a.XFAObject{constructor(e){super(c,"linear",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["toRight","toBottom","toLeft","toTop"]),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null}[a.$toStyle](e){e=e?e[a.$toStyle]():"#FFFFFF";return`linear-gradient(${this.type.replace(/([RBLT])/," $1").toLowerCase()}, ${e}, ${this.color?this.color[a.$toStyle]():"#000000"})`}}class Se extends a.ContentObject{constructor(e){super(c,"lockDocument"),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=(0,n.getStringOption)(this[a.$content],["auto","0","1"])}}class ke extends a.XFAObject{constructor(e){super(c,"manifest",!0),this.action=(0,n.getStringOption)(e.action,["include","all","exclude"]),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.ref=new a.XFAObjectArray}}class xe extends a.XFAObject{constructor(e){super(c,"margin",!0),this.bottomInset=(0,n.getMeasurement)(e.bottomInset,"0"),this.id=e.id||"",this.leftInset=(0,n.getMeasurement)(e.leftInset,"0"),this.rightInset=(0,n.getMeasurement)(e.rightInset,"0"),this.topInset=(0,n.getMeasurement)(e.topInset,"0"),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}[a.$toStyle](){return{marginLeft:(0,s.measureToString)(this.leftInset),marginRight:(0,s.measureToString)(this.rightInset),marginTop:(0,s.measureToString)(this.topInset),marginBottom:(0,s.measureToString)(this.bottomInset)}}}class Ae extends a.XFAObject{constructor(e){super(c,"mdp"),this.id=e.id||"",this.permissions=(0,n.getInteger)({data:e.permissions,defaultValue:2,validate:e=>1===e||3===e}),this.signatureType=(0,n.getStringOption)(e.signatureType,["filler","author"]),this.use=e.use||"",this.usehref=e.usehref||""}}class Ce extends a.XFAObject{constructor(e){super(c,"medium"),this.id=e.id||"",this.imagingBBox=(0,n.getBBox)(e.imagingBBox),this.long=(0,n.getMeasurement)(e.long),this.orientation=(0,n.getStringOption)(e.orientation,["portrait","landscape"]),this.short=(0,n.getMeasurement)(e.short),this.stock=e.stock||"",this.trayIn=(0,n.getStringOption)(e.trayIn,["auto","delegate","pageFront"]),this.trayOut=(0,n.getStringOption)(e.trayOut,["auto","delegate"]),this.use=e.use||"",this.usehref=e.usehref||""}}class Oe extends a.XFAObject{constructor(e){super(c,"message",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.text=new a.XFAObjectArray}}class Fe extends a.XFAObject{constructor(e){super(c,"numericEdit",!0),this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.comb=null,this.extras=null,this.margin=null}[a.$toHTML](){return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"input",attributes:{type:"text",class:"xfaTextfield",style:(0,s.toStyle)(this,"border","font","margin")}}]}}}class Ie extends a.XFAObject{constructor(e){super(c,"occur",!0),this.id=e.id||"",this.initial=(0,n.getInteger)({data:e.initial,defaultValue:1,validate:e=>!0}),this.max=(0,n.getInteger)({data:e.max,defaultValue:1,validate:e=>!0}),this.min=(0,n.getInteger)({data:e.min,defaultValue:1,validate:e=>!0}),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}}class Te extends a.StringObject{constructor(e){super(c,"oid"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class Pe extends a.XFAObject{constructor(e){super(c,"oids",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.oid=new a.XFAObjectArray}}class Ee extends a.XFAObject{constructor(e){super(c,"overflow"),this.id=e.id||"",this.leader=e.leader||"",this.target=e.target||"",this.trailer=e.trailer||"",this.use=e.use||"",this.usehref=e.usehref||""}}class Me extends a.XFAObject{constructor(e){super(c,"pageArea",!0),this.blankOrNotBlank=(0,n.getStringOption)(e.blankOrNotBlank,["any","blank","notBlank"]),this.id=e.id||"",this.initialNumber=(0,n.getInteger)({data:e.initialNumber,defaultValue:1,validate:e=>!0}),this.name=e.name||"",this.numbered=(0,n.getInteger)({data:e.numbered,defaultValue:1,validate:e=>!0}),this.oddOrEven=(0,n.getStringOption)(e.oddOrEven,["any","even","odd"]),this.pagePosition=(0,n.getStringOption)(e.pagePosition,["any","first","last","only","rest"]),this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.desc=null,this.extras=null,this.medium=null,this.occur=null,this.area=new a.XFAObjectArray,this.contentArea=new a.XFAObjectArray,this.draw=new a.XFAObjectArray,this.exclGroup=new a.XFAObjectArray,this.field=new a.XFAObjectArray,this.subform=new a.XFAObjectArray}[a.$toHTML](){if(0===this.contentArea.children.length)return null;const e=this[a.$childrenToHTML]({filter:new Set(["area","draw","field","subform","contentArea"]),include:!0}),t=e.find((e=>"xfaContentarea"===e.attributes.class)),r=Object.create(null);return this.medium&&this.medium.short&&this.medium.long&&(r.width=(0,s.measureToString)(this.medium.short),r.height=(0,s.measureToString)(this.medium.long)),{name:"div",children:e,attributes:{id:this[a.$uid],style:r},contentArea:t}}}class Ne extends a.XFAObject{constructor(e){super(c,"pageSet",!0),this.duplexImposition=(0,n.getStringOption)(e.duplexImposition,["longEdge","shortEdge"]),this.id=e.id||"",this.name=e.name||"",this.relation=(0,n.getStringOption)(e.relation,["orderedOccurrence","duplexPaginated","simplexPaginated"]),this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.occur=null,this.pageArea=new a.XFAObjectArray,this.pageSet=new a.XFAObjectArray}[a.$toHTML](){return{name:"div",children:this[a.$childrenToHTML]({filter:new Set(["pageArea","pageSet"]),include:!0}),attributes:{id:this[a.$uid]}}}}class De extends a.XFAObject{constructor(e){super(c,"para",!0),this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]),this.id=e.id||"",this.lineHeight=(0,n.getMeasurement)(e.lineHeight,"0pt"),this.marginLeft=(0,n.getMeasurement)(e.marginLeft,"0"),this.marginRight=(0,n.getMeasurement)(e.marginRight,"0"),this.orphans=(0,n.getInteger)({data:e.orphans,defaultValue:0,validate:e=>e>=0}),this.preserve=e.preserve||"",this.radixOffset=(0,n.getMeasurement)(e.radixOffset,"0"),this.spaceAbove=(0,n.getMeasurement)(e.spaceAbove,"0"),this.spaceBelow=(0,n.getMeasurement)(e.spaceBelow,"0"),this.tabDefault=e.tabDefault?(0,n.getMeasurement)(this.tabDefault):null,this.tabStops=(e.tabStops||"").trim().split(/\s+/).map(((e,t)=>t%2==1?(0,n.getMeasurement)(e):e)),this.textIndent=(0,n.getMeasurement)(e.textIndent,"0"),this.use=e.use||"",this.usehref=e.usehref||"",this.vAlign=(0,n.getStringOption)(e.vAlign,["top","bottom","middle"]),this.widows=(0,n.getInteger)({data:e.widows,defaultValue:0,validate:e=>e>=0}),this.hyphenation=null}[a.$toHTML](){const e={marginLeft:(0,s.measureToString)(this.marginLeft),marginRight:(0,s.measureToString)(this.marginRight),paddingTop:(0,s.measureToString)(this.spaceAbove),paddingBottom:(0,s.measureToString)(this.spaceBelow),textIndent:(0,s.measureToString)(this.textIndent),verticalAlign:this.vAlign};return this.lineHeight.value>=0&&(e.lineHeight=(0,s.measureToString)(this.lineHeight)),this.tabDefault&&(e.tabSize=(0,s.measureToString)(this.tabDefault)),this.tabStops.length,this.hyphenatation&&Object.assign(e,this.hyphenatation[a.$toHTML]()),e}}class Be extends a.XFAObject{constructor(e){super(c,"passwordEdit",!0),this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]),this.id=e.id||"",this.passwordChar=e.passwordChar||"*",this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.extras=null,this.margin=null}}class je extends a.XFAObject{constructor(e){super(c,"pattern",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["crossHatch","crossDiagonal","diagonalLeft","diagonalRight","horizontal","vertical"]),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null}[a.$toStyle](e){e=e?e[a.$toStyle]():"#FFFFFF";const t=this.color?this.color[a.$toStyle]():"#000000",r="repeating-linear-gradient",i=`${e},${e} 5px,${t} 5px,${t} 10px`;switch(this.type){case"crossHatch":return`${r}(to top,${i}) ${r}(to right,${i})`;case"crossDiagonal":return`${r}(45deg,${i}) ${r}(-45deg,${i})`;case"diagonalLeft":return`${r}(45deg,${i})`;case"diagonalRight":return`${r}(-45deg,${i})`;case"horizontal":return`${r}(to top,${i})`;case"vertical":return`${r}(to right,${i})`}return""}}class Le extends a.StringObject{constructor(e){super(c,"picture"),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||""}}class Re extends a.XFAObject{constructor(e){super(c,"proto",!0),this.appearanceFilter=new a.XFAObjectArray,this.arc=new a.XFAObjectArray,this.area=new a.XFAObjectArray,this.assist=new a.XFAObjectArray,this.barcode=new a.XFAObjectArray,this.bindItems=new a.XFAObjectArray,this.bookend=new a.XFAObjectArray,this.boolean=new a.XFAObjectArray,this.border=new a.XFAObjectArray,this.break=new a.XFAObjectArray,this.breakAfter=new a.XFAObjectArray,this.breakBefore=new a.XFAObjectArray,this.button=new a.XFAObjectArray,this.calculate=new a.XFAObjectArray,this.caption=new a.XFAObjectArray,this.certificate=new a.XFAObjectArray,this.certificates=new a.XFAObjectArray,this.checkButton=new a.XFAObjectArray,this.choiceList=new a.XFAObjectArray,this.color=new a.XFAObjectArray,this.comb=new a.XFAObjectArray,this.connect=new a.XFAObjectArray,this.contentArea=new a.XFAObjectArray,this.corner=new a.XFAObjectArray,this.date=new a.XFAObjectArray,this.dateTime=new a.XFAObjectArray,this.dateTimeEdit=new a.XFAObjectArray,this.decimal=new a.XFAObjectArray,this.defaultUi=new a.XFAObjectArray,this.desc=new a.XFAObjectArray,this.digestMethod=new a.XFAObjectArray,this.digestMethods=new a.XFAObjectArray,this.draw=new a.XFAObjectArray,this.edge=new a.XFAObjectArray,this.encoding=new a.XFAObjectArray,this.encodings=new a.XFAObjectArray,this.encrypt=new a.XFAObjectArray,this.encryptData=new a.XFAObjectArray,this.encryption=new a.XFAObjectArray,this.encryptionMethod=new a.XFAObjectArray,this.encryptionMethods=new a.XFAObjectArray,this.event=new a.XFAObjectArray,this.exData=new a.XFAObjectArray,this.exObject=new a.XFAObjectArray,this.exclGroup=new a.XFAObjectArray,this.execute=new a.XFAObjectArray,this.extras=new a.XFAObjectArray,this.field=new a.XFAObjectArray,this.fill=new a.XFAObjectArray,this.filter=new a.XFAObjectArray,this.float=new a.XFAObjectArray,this.font=new a.XFAObjectArray,this.format=new a.XFAObjectArray,this.handler=new a.XFAObjectArray,this.hyphenation=new a.XFAObjectArray,this.image=new a.XFAObjectArray,this.imageEdit=new a.XFAObjectArray,this.integer=new a.XFAObjectArray,this.issuers=new a.XFAObjectArray,this.items=new a.XFAObjectArray,this.keep=new a.XFAObjectArray,this.keyUsage=new a.XFAObjectArray,this.line=new a.XFAObjectArray,this.linear=new a.XFAObjectArray,this.lockDocument=new a.XFAObjectArray,this.manifest=new a.XFAObjectArray,this.margin=new a.XFAObjectArray,this.mdp=new a.XFAObjectArray,this.medium=new a.XFAObjectArray,this.message=new a.XFAObjectArray,this.numericEdit=new a.XFAObjectArray,this.occur=new a.XFAObjectArray,this.oid=new a.XFAObjectArray,this.oids=new a.XFAObjectArray,this.overflow=new a.XFAObjectArray,this.pageArea=new a.XFAObjectArray,this.pageSet=new a.XFAObjectArray,this.para=new a.XFAObjectArray,this.passwordEdit=new a.XFAObjectArray,this.pattern=new a.XFAObjectArray,this.picture=new a.XFAObjectArray,this.radial=new a.XFAObjectArray,this.reason=new a.XFAObjectArray,this.reasons=new a.XFAObjectArray,this.rectangle=new a.XFAObjectArray,this.ref=new a.XFAObjectArray,this.script=new a.XFAObjectArray,this.setProperty=new a.XFAObjectArray,this.signData=new a.XFAObjectArray,this.signature=new a.XFAObjectArray,this.signing=new a.XFAObjectArray,this.solid=new a.XFAObjectArray,this.speak=new a.XFAObjectArray,this.stipple=new a.XFAObjectArray,this.subform=new a.XFAObjectArray,this.subformSet=new a.XFAObjectArray,this.subjectDN=new a.XFAObjectArray,this.subjectDNs=new a.XFAObjectArray,this.submit=new a.XFAObjectArray,this.text=new a.XFAObjectArray,this.textEdit=new a.XFAObjectArray,this.time=new a.XFAObjectArray,this.timeStamp=new a.XFAObjectArray,this.toolTip=new a.XFAObjectArray,this.traversal=new a.XFAObjectArray,this.traverse=new a.XFAObjectArray,this.ui=new a.XFAObjectArray,this.validate=new a.XFAObjectArray,this.value=new a.XFAObjectArray,this.variables=new a.XFAObjectArray}}class _e extends a.XFAObject{constructor(e){super(c,"radial",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["toEdge","toCenter"]),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null}[a.$toStyle](e){e=e?e[a.$toStyle]():"#FFFFFF";const t=this.color?this.color[a.$toStyle]():"#000000";return`radial-gradient(circle to center, ${"toEdge"===this.type?`${e},${t}`:`${t},${e}`})`}}class Ue extends a.StringObject{constructor(e){super(c,"reason"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class Xe extends a.XFAObject{constructor(e){super(c,"reasons",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.reason=new a.XFAObjectArray}}class $e extends a.XFAObject{constructor(e){super(c,"rectangle",!0),this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.corner=new a.XFAObjectArray(4),this.edge=new a.XFAObjectArray(4),this.fill=null}}class qe extends a.StringObject{constructor(e){super(c,"ref"),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||""}}class ze extends a.StringObject{constructor(e){super(c,"script"),this.binding=e.binding||"",this.contentType=e.contentType||"",this.id=e.id||"",this.name=e.name||"",this.runAt=(0,n.getStringOption)(e.runAt,["client","both","server"]),this.use=e.use||"",this.usehref=e.usehref||""}}class He extends a.XFAObject{constructor(e){super(c,"setProperty"),this.connection=e.connection||"",this.ref=e.ref||"",this.target=e.target||""}}t.SetProperty=He;class Ge extends a.XFAObject{constructor(e){super(c,"signData",!0),this.id=e.id||"",this.operation=(0,n.getStringOption)(e.operation,["sign","clear","verify"]),this.ref=e.ref||"",this.target=e.target||"",this.use=e.use||"",this.usehref=e.usehref||"",this.filter=null,this.manifest=null}}class Ve extends a.XFAObject{constructor(e){super(c,"signature",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["PDF1.3","PDF1.6"]),this.use=e.use||"",this.usehref=e.usehref||"",this.border=null,this.extras=null,this.filter=null,this.manifest=null,this.margin=null}}class We extends a.XFAObject{constructor(e){super(c,"signing",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.certificate=new a.XFAObjectArray}}class Ke extends a.XFAObject{constructor(e){super(c,"solid",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null}[a.$toStyle](e){return e?e[a.$toStyle]():"#FFFFFF"}}class Ye extends a.StringObject{constructor(e){super(c,"speak"),this.disable=(0,n.getInteger)({data:e.disable,defaultValue:0,validate:e=>1===e}),this.id=e.id||"",this.priority=(0,n.getStringOption)(e.priority,["custom","caption","name","toolTip"]),this.rid=e.rid||"",this.use=e.use||"",this.usehref=e.usehref||""}}class Je extends a.XFAObject{constructor(e){super(c,"stipple",!0),this.id=e.id||"",this.rate=(0,n.getInteger)({data:e.rate,defaultValue:50,validate:e=>e>=0&&e<=100}),this.use=e.use||"",this.usehref=e.usehref||"",this.color=null,this.extras=null}[a.$toStyle](e){const t=this.rate/100;return o.Util.makeHexColor(Math.round(e.value.r*(1-t)+this.value.r*t),Math.round(e.value.g*(1-t)+this.value.g*t),Math.round(e.value.b*(1-t)+this.value.b*t))}}class Ze extends a.XFAObject{constructor(e){super(c,"subform",!0),this.access=(0,n.getStringOption)(e.access,["open","nonInteractive","protected","readOnly"]),this.allowMacro=(0,n.getInteger)({data:e.allowMacro,defaultValue:0,validate:e=>1===e}),this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]),this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1}),this.columnWidths=(e.columnWidths||"").trim().split(/\s+/).map((e=>"-1"===e?-1:(0,n.getMeasurement)(e))),this.h=e.h?(0,n.getMeasurement)(e.h):"",this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]),this.id=e.id||"",this.layout=(0,n.getStringOption)(e.layout,["position","lr-tb","rl-row","rl-tb","row","table","tb"]),this.locale=e.locale||"",this.maxH=(0,n.getMeasurement)(e.maxH,"0pt"),this.maxW=(0,n.getMeasurement)(e.maxW,"0pt"),this.mergeMode=(0,n.getStringOption)(e.mergeMode,["consumeData","matchTemplate"]),this.minH=(0,n.getMeasurement)(e.minH,"0pt"),this.minW=(0,n.getMeasurement)(e.minW,"0pt"),this.name=e.name||"",this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]),this.relevant=(0,n.getRelevant)(e.relevant),this.restoreState=(0,n.getStringOption)(e.restoreState,["manual","auto"]),this.scope=(0,n.getStringOption)(e.scope,["name","none"]),this.use=e.use||"",this.usehref=e.usehref||"",this.w=e.w?(0,n.getMeasurement)(e.w):"",this.x=(0,n.getMeasurement)(e.x,"0pt"),this.y=(0,n.getMeasurement)(e.y,"0pt"),this.assist=null,this.bind=null,this.bookend=null,this.border=null,this.break=null,this.calculate=null,this.desc=null,this.extras=null,this.keep=null,this.margin=null,this.occur=null,this.overflow=null,this.pageSet=null,this.para=null,this.traversal=null,this.validate=null,this.variables=null,this.area=new a.XFAObjectArray,this.breakAfter=new a.XFAObjectArray,this.breakBefore=new a.XFAObjectArray,this.connect=new a.XFAObjectArray,this.draw=new a.XFAObjectArray,this.event=new a.XFAObjectArray,this.exObject=new a.XFAObjectArray,this.exclGroup=new a.XFAObjectArray,this.field=new a.XFAObjectArray,this.proto=new a.XFAObjectArray,this.setProperty=new a.XFAObjectArray,this.subform=new a.XFAObjectArray,this.subformSet=new a.XFAObjectArray}[a.$toHTML](){this[a.$extra]=Object.create(null);const e=this[a.$getParent]();let t=null;if("template"===e[a.$nodeName])null!==this.pageSet?this[a.$extra].pageNumber=0:(0,o.warn)("XFA - No pageSet in root subform");else if(e[a.$extra]&&void 0!==e[a.$extra].pageNumber){const r=e[a.$extra].pageNumber,i=e.pageSet.pageArea.children;e[a.$extra].pageNumber=(e[a.$extra].pageNumber+1)%i.length,t=i[r][a.$toHTML]()}const r=(0,s.toStyle)(this,"dimensions","position","presence"),i=["xfaSubform"],n=(0,s.layoutClass)(this);n&&i.push(n);const c={style:r,id:this[a.$uid],class:i.join(" ")};this.name&&(c.xfaName=this.name);const l={name:"div",attributes:c,children:this[a.$childrenToHTML]({filter:new Set(["area","draw","field","subform","subformSet"]),include:!0})};return t?(t.contentArea.children.push(l),delete t.contentArea,t):l}}class Qe extends a.XFAObject{constructor(e){super(c,"subformSet",!0),this.id=e.id||"",this.name=e.name||"",this.relation=(0,n.getStringOption)(e.relation,["ordered","choice","unordered"]),this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.bookend=null,this.break=null,this.desc=null,this.extras=null,this.occur=null,this.overflow=null,this.breakAfter=new a.XFAObjectArray,this.breakBefore=new a.XFAObjectArray,this.subform=new a.XFAObjectArray,this.subformSet=new a.XFAObjectArray}}class et extends a.ContentObject{constructor(e){super(c,"subjectDN"),this.delimiter=e.delimiter||",",this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Map(this[a.$content].split(this.delimiter).map((e=>((e=e.split("=",2))[0]=e[0].trim(),e))))}}class tt extends a.XFAObject{constructor(e){super(c,"subjectDNs",!0),this.id=e.id||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||"",this.subjectDN=new a.XFAObjectArray}}class rt extends a.XFAObject{constructor(e){super(c,"submit",!0),this.embedPDF=(0,n.getInteger)({data:e.embedPDF,defaultValue:0,validate:e=>1===e}),this.format=(0,n.getStringOption)(e.format,["xdp","formdata","pdf","urlencoded","xfd","xml"]),this.id=e.id||"",this.target=e.target||"",this.textEncoding=(0,n.getKeyword)({data:e.textEncoding?e.textEncoding.toLowerCase():"",defaultValue:"",validate:e=>["utf-8","big-five","fontspecific","gbk","gb-18030","gb-2312","ksc-5601","none","shift-jis","ucs-2","utf-16"].includes(e)||e.match(/iso-8859-[0-9]{2}/)}),this.use=e.use||"",this.usehref=e.usehref||"",this.xdpContent=e.xdpContent||"",this.encrypt=null,this.encryptData=new a.XFAObjectArray,this.signData=new a.XFAObjectArray}}class at extends a.XFAObject{constructor(e){super(c,"template",!0),this.baseProfile=(0,n.getStringOption)(e.baseProfile,["full","interactiveForms"]),this.extras=null,this.subform=new a.XFAObjectArray}[a.$finalize](){0===this.subform.children.length&&(0,o.warn)("XFA - No subforms in template node."),this.subform.children.length>=2&&(0,o.warn)("XFA - Several subforms in template node: please file a bug.")}[a.$toHTML](){return this.subform.children.length>0?this.subform.children[0][a.$toHTML]():{name:"div",children:[]}}}t.Template=at;class it extends a.ContentObject{constructor(e){super(c,"text"),this.id=e.id||"",this.maxChars=(0,n.getInteger)({data:e.maxChars,defaultValue:0,validate:e=>e>=0}),this.name=e.name||"",this.rid=e.rid||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$onChild](e){return e[a.$namespaceId]===i.NamespaceIds.xhtml.id?(this[a.$content]=e,!0):((0,o.warn)(`XFA - Invalid content in Text: ${e[a.$nodeName]}.`),!1)}[a.$toHTML](){return"string"==typeof this[a.$content]?this[a.$content]:this[a.$content][a.$toHTML]()}}t.Text=it;class nt extends a.XFAObject{constructor(e){super(c,"textEdit",!0),this.allowRichText=(0,n.getInteger)({data:e.allowRichText,defaultValue:0,validate:e=>1===e}),this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]),this.id=e.id||"",this.multiLine=(0,n.getInteger)({data:e.multiLine,defaultValue:1,validate:e=>0===e}),this.use=e.use||"",this.usehref=e.usehref||"",this.vScrollPolicy=(0,n.getStringOption)(e.vScrollPolicy,["auto","off","on"]),this.border=null,this.comb=null,this.extras=null,this.margin=null}[a.$toHTML](){const e=(0,s.toStyle)(this,"border","font","margin");let t;return t=1===this.multiline?{name:"textarea",attributes:{style:e}}:{name:"input",attributes:{type:"text",class:"xfaTextfield",style:e}},{name:"label",attributes:{class:"xfaLabel"},children:[t]}}}class st extends a.StringObject{constructor(e){super(c,"time"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Date(this[a.$content])}[a.$toHTML](){return this[a.$content].toString()}}class ot extends a.XFAObject{constructor(e){super(c,"timeStamp"),this.id=e.id||"",this.server=e.server||"",this.type=(0,n.getStringOption)(e.type,["optional","required"]),this.use=e.use||"",this.usehref=e.usehref||""}}class ct extends a.StringObject{constructor(e){super(c,"toolTip"),this.id=e.id||"",this.rid=e.rid||"",this.use=e.use||"",this.usehref=e.usehref||""}}class lt extends a.XFAObject{constructor(e){super(c,"traversal",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.traverse=new a.XFAObjectArray}}class ht extends a.XFAObject{constructor(e){super(c,"traverse",!0),this.id=e.id||"",this.operation=(0,n.getStringOption)(e.operation,["next","back","down","first","left","right","up"]),this.ref=e.ref||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.script=null}get name(){return this.operation}[a.$isTransparent](){return!1}}class ut extends a.XFAObject{constructor(e){super(c,"ui",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.picture=null,this.barcode=null,this.button=null,this.checkButton=null,this.choiceList=null,this.dateTimeEdit=null,this.defaultUi=null,this.imageEdit=null,this.numericEdit=null,this.passwordEdit=null,this.signature=null,this.textEdit=null}[a.$toHTML](){for(const e of Object.getOwnPropertyNames(this)){if("extras"===e||"picture"===e)continue;const t=this[e];if(t instanceof a.XFAObject)return t[a.$toHTML]()}return null}}class dt extends a.XFAObject{constructor(e){super(c,"validate",!0),this.formatTest=(0,n.getStringOption)(e.formatTest,["warning","disabled","error"]),this.id=e.id||"",this.nullTest=(0,n.getStringOption)(e.nullTest,["disabled","error","warning"]),this.scriptTest=(0,n.getStringOption)(e.scriptTest,["error","disabled","warning"]),this.use=e.use||"",this.usehref=e.usehref||"",this.extras=null,this.message=null,this.picture=null,this.script=null}}class ft extends a.XFAObject{constructor(e){super(c,"value",!0),this.id=e.id||"",this.override=(0,n.getInteger)({data:e.override,defaultValue:0,validate:e=>1===e}),this.relevant=(0,n.getRelevant)(e.relevant),this.use=e.use||"",this.usehref=e.usehref||"",this.arc=null,this.boolean=null,this.date=null,this.dateTime=null,this.decimal=null,this.exData=null,this.float=null,this.image=null,this.integer=null,this.line=null,this.rectangle=null,this.text=null,this.time=null}[a.$setValue](e){const t=e[a.$nodeName];if(null===this[t]){for(const e of Object.getOwnPropertyNames(this)){const t=this[e];t instanceof a.XFAObject&&(this[e]=null,this[a.$removeChild](t))}this[e[a.$nodeName]]=e,this[a.$appendChild](e)}else this[t][a.$content]=e[a.$content]}[a.$toHTML](){for(const e of Object.getOwnPropertyNames(this)){const t=this[e];if(t instanceof a.XFAObject)return t[a.$toHTML]()}return null}}t.Value=ft;class gt extends a.XFAObject{constructor(e){super(c,"variables",!0),this.id=e.id||"",this.use=e.use||"",this.usehref=e.usehref||"",this.boolean=new a.XFAObjectArray,this.date=new a.XFAObjectArray,this.dateTime=new a.XFAObjectArray,this.decimal=new a.XFAObjectArray,this.exData=new a.XFAObjectArray,this.float=new a.XFAObjectArray,this.image=new a.XFAObjectArray,this.integer=new a.XFAObjectArray,this.manifest=new a.XFAObjectArray,this.script=new a.XFAObjectArray,this.text=new a.XFAObjectArray,this.time=new a.XFAObjectArray}[a.$isTransparent](){return!0}}class pt{static[i.$buildXFAObject](e,t){if(pt.hasOwnProperty(e)){const r=pt[e](t);return r[a.$setSetAttributes](t),r}}static appearanceFilter(e){return new h(e)}static arc(e){return new u(e)}static area(e){return new d(e)}static assist(e){return new f(e)}static barcode(e){return new g(e)}static bind(e){return new p(e)}static bindItems(e){return new m(e)}static bookend(e){return new b(e)}static boolean(e){return new y(e)}static border(e){return new w(e)}static break(e){return new v(e)}static breakAfter(e){return new S(e)}static breakBefore(e){return new k(e)}static button(e){return new x(e)}static calculate(e){return new A(e)}static caption(e){return new C(e)}static certificate(e){return new O(e)}static certificates(e){return new F(e)}static checkButton(e){return new I(e)}static choiceList(e){return new T(e)}static color(e){return new P(e)}static comb(e){return new E(e)}static connect(e){return new M(e)}static contentArea(e){return new N(e)}static corner(e){return new D(e)}static date(e){return new B(e)}static dateTime(e){return new j(e)}static dateTimeEdit(e){return new L(e)}static decimal(e){return new R(e)}static defaultUi(e){return new _(e)}static desc(e){return new U(e)}static digestMethod(e){return new X(e)}static digestMethods(e){return new $(e)}static draw(e){return new q(e)}static edge(e){return new z(e)}static encoding(e){return new H(e)}static encodings(e){return new G(e)}static encrypt(e){return new V(e)}static encryptData(e){return new W(e)}static encryption(e){return new K(e)}static encryptionMethod(e){return new Y(e)}static encryptionMethods(e){return new J(e)}static event(e){return new Z(e)}static exData(e){return new Q(e)}static exObject(e){return new ee(e)}static exclGroup(e){return new te(e)}static execute(e){return new re(e)}static extras(e){return new ae(e)}static field(e){return new ie(e)}static fill(e){return new ne(e)}static filter(e){return new se(e)}static float(e){return new oe(e)}static font(e){return new ce(e)}static format(e){return new le(e)}static handler(e){return new he(e)}static hyphenation(e){return new ue(e)}static image(e){return new de(e)}static imageEdit(e){return new fe(e)}static integer(e){return new ge(e)}static issuers(e){return new pe(e)}static items(e){return new me(e)}static keep(e){return new be(e)}static keyUsage(e){return new ye(e)}static line(e){return new we(e)}static linear(e){return new ve(e)}static lockDocument(e){return new Se(e)}static manifest(e){return new ke(e)}static margin(e){return new xe(e)}static mdp(e){return new Ae(e)}static medium(e){return new Ce(e)}static message(e){return new Oe(e)}static numericEdit(e){return new Fe(e)}static occur(e){return new Ie(e)}static oid(e){return new Te(e)}static oids(e){return new Pe(e)}static overflow(e){return new Ee(e)}static pageArea(e){return new Me(e)}static pageSet(e){return new Ne(e)}static para(e){return new De(e)}static passwordEdit(e){return new Be(e)}static pattern(e){return new je(e)}static picture(e){return new Le(e)}static proto(e){return new Re(e)}static radial(e){return new _e(e)}static reason(e){return new Ue(e)}static reasons(e){return new Xe(e)}static rectangle(e){return new $e(e)}static ref(e){return new qe(e)}static script(e){return new ze(e)}static setProperty(e){return new He(e)}static signData(e){return new Ge(e)}static signature(e){return new Ve(e)}static signing(e){return new We(e)}static solid(e){return new Ke(e)}static speak(e){return new Ye(e)}static stipple(e){return new Je(e)}static subform(e){return new Ze(e)}static subformSet(e){return new Qe(e)}static subjectDN(e){return new et(e)}static subjectDNs(e){return new tt(e)}static submit(e){return new rt(e)}static template(e){return new at(e)}static text(e){return new it(e)}static textEdit(e){return new nt(e)}static time(e){return new st(e)}static timeStamp(e){return new ot(e)}static toolTip(e){return new ct(e)}static traversal(e){return new lt(e)}static traverse(e){return new ht(e)}static ui(e){return new ut(e)}static validate(e){return new dt(e)}static value(e){return new ft(e)}static variables(e){return new gt(e)}}t.TemplateNamespace=pt},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.layoutClass=function(e){switch(e.layout){case"position":return"xfaPosition";case"lr-tb":return"xfaLrTb";case"rl-row":return"xfaRlRow";case"rl-tb":return"xfaRlTb";case"row":return"xfaRow";case"table":return"xfaTable";case"tb":return"xfaTb";default:return"xfaPosition"}},t.measureToString=n,t.toStyle=function(e,...t){const r=Object.create(null);for(const n of t){const t=e[n];if(null!==t)if(t instanceof a.XFAObject){const e=t[a.$toStyle]();e?Object.assign(r,e):(0,i.warn)(`(DEBUG) - XFA - style for ${n} not implemented yet`)}else s.hasOwnProperty(n)&&s[n](e,r)}return r};var a=r(50),i=r(2);function n(e){return"string"==typeof e?"0px":Number.isInteger(e)?`${e}px`:`${e.toFixed(2)}px`}const s={anchorType(e,t){switch("transform"in t||(t.transform=""),e.anchorType){case"bottomCenter":t.transform+="translate(-50%, -100%)";break;case"bottomLeft":t.transform+="translate(0,-100%)";break;case"bottomRight":t.transform+="translate(-100%,-100%)";break;case"middleCenter":t.transform+="translate(-50%,-50%)";break;case"middleLeft":t.transform+="translate(0,-50%)";break;case"middleRight":t.transform+="translate(-100%,-50%)";break;case"topCenter":t.transform+="translate(-50%,0)";break;case"topRight":t.transform+="translate(-100%,0)";break}},dimensions(e,t){e.w?t.width=n(e.w):(t.width="auto",e.maxW>0&&(t.maxWidth=n(e.maxW)),t.minWidth=n(e.minW)),e.h?t.height=n(e.h):(t.height="auto",e.maxH>0&&(t.maxHeight=n(e.maxH)),t.minHeight=n(e.minH))},position(e,t){const r=e[a.$getParent]();r&&r.layout&&"position"!==r.layout||(t.position="absolute",t.left=n(e.x),t.top=n(e.y))},rotate(e,t){e.rotate&&("transform"in t||(t.transform=""),t.transform+=`rotate(-${e.rotate}deg)`,t.transformOrigin="top left")},presence(e,t){switch(e.presence){case"invisible":t.visibility="hidden";break;case"hidden":case"inactive":t.display="none";break}}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.createDataNode=function(e,t,r){const n=g(r);if(!n)return null;if(n.some((e=>e.operator===c)))return null;const s=d.get(n[0].name);let o=0;s?(e=s(e,t),o=1):e=t||e;for(let t=n.length;o<t;o++){const{cacheName:t,index:r}=n[o];if(!isFinite(r))return n[o].index=0,p(e,n.slice(o));const s=f.get(e);if(!s)return(0,i.warn)("XFA - createDataNode must be called after searchNode."),null;const c=s.get(t);if(0===c.length)return p(e,n.slice(o));if(!(r<c.length))return n[o].index=c.length-r,p(e,n.slice(o));{const t=c[r];if(!(t instanceof a.XFAObject))return(0,i.warn)("XFA - Cannot create a node."),null;e=t}}return null},t.searchNode=function(e,t,r,i=!0,n=!0){const s=g(r,i);if(!s)return null;const h=d.get(s[0].name);let u,p=0;h?(u=!0,e=[h(e,t)],p=1):(u=null===t,e=[t||e]);for(let r=s.length;p<r;p++){const{name:r,cacheName:i,operator:h,index:d}=s[p],g=[];for(const t of e){if(!(t instanceof a.XFAObject))continue;let e,s;if(n&&(s=f.get(t),s||(s=new Map,f.set(t,s)),e=s.get(i)),!e){switch(h){case o:e=t[a.$getChildrenByName](r,!1);break;case c:e=t[a.$getChildrenByName](r,!0);break;case l:e=t[a.$getChildrenByClass](r),e=e instanceof a.XFAObjectArray?e.children:[e];break;default:break}n&&s.set(i,e)}e.length>0&&g.push(e)}if(0!==g.length||u||0!==p)e=isFinite(d)?g.filter((e=>d<e.length)).map((e=>e[d])):g.reduce(((e,t)=>e.concat(t)),[]);else{const r=t[a.$getParent]();if(!(t=r))return null;p=-1,e=[t]}}if(0===e.length)return null;return e};var a=r(50),i=r(2);const n=/^[^.[]+/,s=/^[^\]]+/,o=0,c=1,l=2,h=3,u=4,d=new Map([["$data",(e,t)=>e.datasets.data],["$template",(e,t)=>e.template],["$connectionSet",(e,t)=>e.connectionSet],["$form",(e,t)=>e.form],["$layout",(e,t)=>e.layout],["$host",(e,t)=>e.host],["$dataWindow",(e,t)=>e.dataWindow],["$event",(e,t)=>e.event],["!",(e,t)=>e.datasets],["$xfa",(e,t)=>e],["xfa",(e,t)=>e],["$",(e,t)=>t]]),f=new WeakMap;function g(e,t){let r=e.match(n);if(!r)return null;let[a]=r;const d=[{name:a,cacheName:"."+a,index:0,js:null,formCalc:null,operator:o}];let f=a.length;for(;f<e.length;){const p=f;if("["===e.charAt(f++)){if(r=e.slice(f).match(s),!r)return(0,i.warn)("XFA - Invalid index in SOM expression"),null;d[d.length-1].index="*"===(g=(g=r[0]).trim())?1/0:parseInt(g,10)||0,f+=r[0].length+1;continue}let m;switch(e.charAt(f)){case".":if(!t)return null;f++,m=c;break;case"#":f++,m=l;break;case"[":m=h;break;case"(":m=u;break;default:m=o;break}if(r=e.slice(f).match(n),!r)break;[a]=r,f+=a.length,d.push({name:a,cacheName:e.slice(p,f),operator:m,index:0,js:null,formCalc:null})}var g;return d}function p(e,t){let r=null;for(const{name:i,index:n}of t){for(let t=0;t<=n;t++)r=new a.XmlObject(e[a.$namespaceId],i),e[a.$appendChild](r);e=r}return r}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XFAParser=void 0;var a=r(50),i=r(26),n=r(58),s=r(2);class o extends i.XMLParserBase{constructor(){super(),this._builder=new n.Builder,this._stack=[],this._ids=new Map,this._current=this._builder.buildRoot(this._ids),this._errorCode=i.XMLParserErrorCode.NoError,this._whiteRegex=/^\s+$/}parse(e){if(this.parseXml(e),this._errorCode===i.XMLParserErrorCode.NoError)return this._current[a.$finalize](),this._current.element}onText(e){this._whiteRegex.test(e)||this._current[a.$onText](e.trim())}onCdata(e){this._current[a.$onText](e)}_mkAttributes(e,t){let r=null,i=null;const n=Object.create({});for(const{name:o,value:c}of e)if("xmlns"===o)r?(0,s.warn)(`XFA - multiple namespace definition in <${t}>`):r=c;else if(o.startsWith("xmlns:")){const e=o.substring("xmlns:".length);i||(i=[]),i.push({prefix:e,value:c})}else{const e=o.indexOf(":");if(-1===e)n[o]=c;else{let t=n[a.$nsAttributes];t||(t=n[a.$nsAttributes]=Object.create(null));const[r,i]=[o.slice(0,e),o.slice(e+1)];let s=t[r];s||(s=t[r]=Object.create(null)),s[i]=c}}return[r,i,n]}_getNameAndPrefix(e){const t=e.indexOf(":");return-1===t?[e,null]:[e.substring(t+1),e.substring(0,t)]}onBeginElement(e,t,r){const[i,n,s]=this._mkAttributes(t,e),[o,c]=this._getNameAndPrefix(e),l=this._builder.build({nsPrefix:c,name:o,attributes:s,namespace:i,prefixes:n});if(r)return l[a.$finalize](),this._current[a.$onChild](l)&&l[a.$setId](this._ids),void l[a.$clean](this._builder);this._stack.push(this._current),this._current=l}onEndElement(e){const t=this._current;t[a.$finalize](),this._current=this._stack.pop(),this._current[a.$onChild](t)&&t[a.$setId](this._ids),t[a.$clean](this._builder)}onError(e){this._errorCode=e}}t.XFAParser=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Builder=void 0;var a=r(52),i=r(50),n=r(59),s=r(54),o=r(68),c=r(2);const l=Symbol();class h extends i.XFAObject{constructor(e){super(-1,"root",Object.create(null)),this.element=null,this[l]=e}[i.$onChild](e){return this.element=e,!0}[i.$finalize](){super[i.$finalize](),this.element.template instanceof s.Template&&this.element.template[i.$resolvePrototypes](this[l])}}class u extends i.XFAObject{constructor(){super(-1,"",Object.create(null))}[i.$onChild](e){return!1}}t.Builder=class{constructor(){this._namespaceStack=[],this._namespacePrefixes=new Map,this._namespaces=new Map,this._nextNsId=Math.max(...Object.values(a.NamespaceIds).map((({id:e})=>e))),this._currentNamespace=new o.UnknownNamespace(++this._nextNsId)}buildRoot(e){return new h(e)}build({nsPrefix:e,name:t,attributes:r,namespace:s,prefixes:o}){const c=null!==s;if(c&&(this._namespaceStack.push(this._currentNamespace),this._currentNamespace=this._searchNamespace(s)),o&&this._addNamespacePrefix(o),r.hasOwnProperty(i.$nsAttributes)){const e=n.NamespaceSetUp.datasets,t=r[i.$nsAttributes];let a=null;for(const[r,i]of Object.entries(t)){if(this._getNamespaceToUse(r)===e){a={xfa:i};break}}a?r[i.$nsAttributes]=a:delete r[i.$nsAttributes]}const l=this._getNamespaceToUse(e),h=l&&l[a.$buildXFAObject](t,r)||new u;return(c||o)&&(h[i.$cleanup]={hasNamespace:c,prefixes:o}),h}_searchNamespace(e){let t=this._namespaces.get(e);if(t)return t;for(const[r,{check:i}]of Object.entries(a.NamespaceIds))if(i(e)){if(t=n.NamespaceSetUp[r],t)return this._namespaces.set(e,t),t;break}return t=new o.UnknownNamespace(++this._nextNsId),this._namespaces.set(e,t),t}_addNamespacePrefix(e){for(const{prefix:t,value:r}of e){const e=this._searchNamespace(r);let a=this._namespacePrefixes.get(t);a||(a=[],this._namespacePrefixes.set(t,a)),a.push(e)}}_getNamespaceToUse(e){if(!e)return this._currentNamespace;const t=this._namespacePrefixes.get(e);return t&&t.length>0?t[t.length-1]:((0,c.warn)(`Unknown namespace prefix: ${e}.`),null)}clean(e){const{hasNamespace:t,prefixes:r}=e;t&&(this._currentNamespace=this._namespaceStack.pop()),r&&r.forEach((({prefix:e})=>{this._namespacePrefixes.get(e).pop()}))}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.NamespaceSetUp=void 0;var a=r(60),i=r(61),n=r(62),s=r(63),o=r(64),c=r(65),l=r(54),h=r(66),u=r(67);const d={config:a.ConfigNamespace,connection:i.ConnectionSetNamespace,datasets:n.DatasetsNamespace,localeSet:s.LocaleSetNamespace,signature:o.SignatureNamespace,stylesheet:c.StylesheetNamespace,template:l.TemplateNamespace,xdp:h.XdpNamespace,xhtml:u.XhtmlNamespace};t.NamespaceSetUp=d},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ConfigNamespace=void 0;var a=r(52),i=r(50),n=r(51),s=r(2);const o=a.NamespaceIds.config.id;class c extends i.XFAObject{constructor(e){super(o,"acrobat",!0),this.acrobat7=null,this.autoSave=null,this.common=null,this.validate=null,this.validateApprovalSignatures=null,this.submitUrl=new i.XFAObjectArray}}class l extends i.XFAObject{constructor(e){super(o,"acrobat7",!0),this.dynamicRender=null}}class h extends i.OptionObject{constructor(e){super(o,"ADBE_JSConsole",["delegate","Enable","Disable"])}}class u extends i.OptionObject{constructor(e){super(o,"ADBE_JSDebugger",["delegate","Enable","Disable"])}}class d extends i.Option01{constructor(e){super(o,"addSilentPrint")}}class f extends i.Option01{constructor(e){super(o,"addViewerPreferences")}}class g extends i.Option10{constructor(e){super(o,"adjustData")}}class p extends i.IntegerObject{constructor(e){super(o,"adobeExtensionLevel",0,(e=>e>=1&&e<=8))}}class m extends i.XFAObject{constructor(e){super(o,"agent",!0),this.name=e.name?e.name.trim():"",this.common=new i.XFAObjectArray}}class b extends i.ContentObject{constructor(e){super(o,"alwaysEmbed")}}class y extends i.StringObject{constructor(e){super(o,"amd")}}class w extends i.XFAObject{constructor(e){super(o,"area"),this.level=(0,n.getInteger)({data:e.level,defaultValue:0,validator:e=>e>=1&&e<=3}),this.name=(0,n.getStringOption)(e.name,["","barcode","coreinit","deviceDriver","font","general","layout","merge","script","signature","sourceSet","templateCache"])}}class v extends i.OptionObject{constructor(e){super(o,"attributes",["preserve","delegate","ignore"])}}class S extends i.OptionObject{constructor(e){super(o,"autoSave",["disabled","enabled"])}}class k extends i.StringObject{constructor(e){super(o,"base")}}class x extends i.XFAObject{constructor(e){super(o,"batchOutput"),this.format=(0,n.getStringOption)(e.format,["none","concat","zip","zipCompress"])}}class A extends i.ContentObject{constructor(e){super(o,"behaviorOverride")}[i.$finalize](){this[i.$content]=new Map(this[i.$content].trim().split(/\s+/).filter((e=>!!e&&e.include(":"))).map((e=>e.split(":",2))))}}class C extends i.XFAObject{constructor(e){super(o,"cache",!0),this.templateCache=null}}class O extends i.Option01{constructor(e){super(o,"change")}}class F extends i.XFAObject{constructor(e){super(o,"common",!0),this.data=null,this.locale=null,this.localeSet=null,this.messaging=null,this.suppressBanner=null,this.template=null,this.validationMessaging=null,this.versionControl=null,this.log=new i.XFAObjectArray}}class I extends i.XFAObject{constructor(e){super(o,"compress"),this.scope=(0,n.getStringOption)(e.scope,["imageOnly","document"])}}class T extends i.Option01{constructor(e){super(o,"compressLogicalStructure")}}class P extends i.Option10{constructor(e){super(o,"compressObjectStream")}}class E extends i.XFAObject{constructor(e){super(o,"compression",!0),this.compressLogicalStructure=null,this.compressObjectStream=null,this.level=null,this.type=null}}class M extends i.XFAObject{constructor(e){super(o,"config",!0),this.acrobat=null,this.present=null,this.trace=null,this.agent=new i.XFAObjectArray}}class N extends i.OptionObject{constructor(e){super(o,"conformance",["A","B"])}}class D extends i.Option01{constructor(e){super(o,"contentCopy")}}class B extends i.IntegerObject{constructor(e){super(o,"copies",1,(e=>e>=1))}}class j extends i.StringObject{constructor(e){super(o,"creator")}}class L extends i.IntegerObject{constructor(e){super(o,"currentPage",0,(e=>e>=0))}}class R extends i.XFAObject{constructor(e){super(o,"data",!0),this.adjustData=null,this.attributes=null,this.incrementalLoad=null,this.outputXSL=null,this.range=null,this.record=null,this.startNode=null,this.uri=null,this.window=null,this.xsl=null,this.excludeNS=new i.XFAObjectArray,this.transform=new i.XFAObjectArray}}class _ extends i.XFAObject{constructor(e){super(o,"debug",!0),this.uri=null}}class U extends i.ContentObject{constructor(e){super(o,"defaultTypeface"),this.writingScript=(0,n.getStringOption)(e.writingScript,["*","Arabic","Cyrillic","EastEuropeanRoman","Greek","Hebrew","Japanese","Korean","Roman","SimplifiedChinese","Thai","TraditionalChinese","Vietnamese"])}}class X extends i.OptionObject{constructor(e){super(o,"destination",["pdf","pcl","ps","webClient","zpl"])}}class $ extends i.Option01{constructor(e){super(o,"documentAssembly")}}class q extends i.XFAObject{constructor(e){super(o,"driver",!0),this.name=e.name?e.name.trim():"",this.fontInfo=null,this.xdc=null}}class z extends i.OptionObject{constructor(e){super(o,"duplexOption",["simplex","duplexFlipLongEdge","duplexFlipShortEdge"])}}class H extends i.OptionObject{constructor(e){super(o,"dynamicRender",["forbidden","required"])}}class G extends i.Option01{constructor(e){super(o,"embed")}}class V extends i.Option01{constructor(e){super(o,"encrypt")}}class W extends i.XFAObject{constructor(e){super(o,"encryption",!0),this.encrypt=null,this.encryptionLevel=null,this.permissions=null}}class K extends i.OptionObject{constructor(e){super(o,"encryptionLevel",["40bit","128bit"])}}class Y extends i.StringObject{constructor(e){super(o,"enforce")}}class J extends i.XFAObject{constructor(e){super(o,"equate"),this.force=(0,n.getInteger)({data:e.force,defaultValue:1,validator:e=>0===e}),this.from=e.from||"",this.to=e.to||""}}class Z extends i.XFAObject{constructor(e){super(o,"equateRange"),this.from=e.from||"",this.to=e.to||"",this._unicodeRange=e.unicodeRange||""}get unicodeRange(){const e=[],t=/U\+([0-9a-fA-F]+)/,r=this._unicodeRange;for(let a of r.split(",").map((e=>e.trim())).filter((e=>!!e)))a=a.split("-",2).map((e=>{const r=e.match(t);return r?parseInt(r[1],16):0})),1===a.length&&a.push(a[0]),e.push(a);return(0,s.shadow)(this,"unicodeRange",e)}}class Q extends i.ContentObject{constructor(e){super(o,"exclude")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s+/).filter((e=>e&&["calculate","close","enter","exit","initialize","ready","validate"].includes(e)))}}class ee extends i.StringObject{constructor(e){super(o,"excludeNS")}}class te extends i.OptionObject{constructor(e){super(o,"flipLabel",["usePrinterSetting","on","off"])}}class re extends i.XFAObject{constructor(e){super(o,"fontInfo",!0),this.embed=null,this.map=null,this.subsetBelow=null,this.alwaysEmbed=new i.XFAObjectArray,this.defaultTypeface=new i.XFAObjectArray,this.neverEmbed=new i.XFAObjectArray}}class ae extends i.Option01{constructor(e){super(o,"formFieldFilling")}}class ie extends i.StringObject{constructor(e){super(o,"groupParent")}}class ne extends i.OptionObject{constructor(e){super(o,"ifEmpty",["dataValue","dataGroup","ignore","remove"])}}class se extends i.StringObject{constructor(e){super(o,"includeXDPContent")}}class oe extends i.OptionObject{constructor(e){super(o,"incrementalLoad",["none","forwardOnly"])}}class ce extends i.Option01{constructor(e){super(o,"incrementalMerge")}}class le extends i.Option01{constructor(e){super(o,"interactive")}}class he extends i.OptionObject{constructor(e){super(o,"jog",["usePrinterSetting","none","pageSet"])}}class ue extends i.XFAObject{constructor(e){super(o,"labelPrinter",!0),this.name=(0,n.getStringOption)(e.name,["zpl","dpl","ipl","tcpl"]),this.batchOutput=null,this.flipLabel=null,this.fontInfo=null,this.xdc=null}}class de extends i.OptionObject{constructor(e){super(o,"layout",["paginate","panel"])}}class fe extends i.IntegerObject{constructor(e){super(o,"level",0,(e=>e>0))}}class ge extends i.Option01{constructor(e){super(o,"linearized")}}class pe extends i.StringObject{constructor(e){super(o,"locale")}}class me extends i.StringObject{constructor(e){super(o,"localeSet")}}class be extends i.XFAObject{constructor(e){super(o,"log",!0),this.mode=null,this.threshold=null,this.to=null,this.uri=null}}class ye extends i.XFAObject{constructor(e){super(o,"map",!0),this.equate=new i.XFAObjectArray,this.equateRange=new i.XFAObjectArray}}class we extends i.XFAObject{constructor(e){super(o,"mediumInfo",!0),this.map=null}}class ve extends i.XFAObject{constructor(e){super(o,"message",!0),this.msgId=null,this.severity=null}}class Se extends i.XFAObject{constructor(e){super(o,"messaging",!0),this.message=new i.XFAObjectArray}}class ke extends i.OptionObject{constructor(e){super(o,"mode",["append","overwrite"])}}class xe extends i.Option01{constructor(e){super(o,"modifyAnnots")}}class Ae extends i.IntegerObject{constructor(e){super(o,"msgId",1,(e=>e>=1))}}class Ce extends i.StringObject{constructor(e){super(o,"nameAttr")}}class Oe extends i.ContentObject{constructor(e){super(o,"neverEmbed")}}class Fe extends i.IntegerObject{constructor(e){super(o,"numberOfCopies",null,(e=>e>=2&&e<=5))}}class Ie extends i.XFAObject{constructor(e){super(o,"openAction",!0),this.destination=null}}class Te extends i.XFAObject{constructor(e){super(o,"output",!0),this.to=null,this.type=null,this.uri=null}}class Pe extends i.StringObject{constructor(e){super(o,"outputBin")}}class Ee extends i.XFAObject{constructor(e){super(o,"outputXSL",!0),this.uri=null}}class Me extends i.OptionObject{constructor(e){super(o,"overprint",["none","both","draw","field"])}}class Ne extends i.StringObject{constructor(e){super(o,"packets")}[i.$finalize](){"*"!==this[i.$content]&&(this[i.$content]=this[i.$content].trim().split(/\s+/).filter((e=>["config","datasets","template","xfdf","xslt"].includes(e))))}}class De extends i.XFAObject{constructor(e){super(o,"pageOffset"),this.x=(0,n.getInteger)({data:e.x,defaultValue:"useXDCSetting",validator:e=>!0}),this.y=(0,n.getInteger)({data:e.y,defaultValue:"useXDCSetting",validator:e=>!0})}}class Be extends i.StringObject{constructor(e){super(o,"pageRange")}[i.$finalize](){const e=this[i.$content].trim().split(/\s+/).map((e=>parseInt(e,10))),t=[];for(let r=0,a=e.length;r<a;r+=2)t.push(e.slice(r,r+2));this[i.$content]=t}}class je extends i.OptionObject{constructor(e){super(o,"pagination",["simplex","duplexShortEdge","duplexLongEdge"])}}class Le extends i.OptionObject{constructor(e){super(o,"paginationOverride",["none","forceDuplex","forceDuplexLongEdge","forceDuplexShortEdge","forceSimplex"])}}class Re extends i.IntegerObject{constructor(e){super(o,"part",1,(e=>!1))}}class _e extends i.XFAObject{constructor(e){super(o,"pcl",!0),this.name=e.name||"",this.batchOutput=null,this.fontInfo=null,this.jog=null,this.mediumInfo=null,this.outputBin=null,this.pageOffset=null,this.staple=null,this.xdc=null}}class Ue extends i.XFAObject{constructor(e){super(o,"pdf",!0),this.name=e.name||"",this.adobeExtensionLevel=null,this.batchOutput=null,this.compression=null,this.creator=null,this.encryption=null,this.fontInfo=null,this.interactive=null,this.linearized=null,this.openAction=null,this.pdfa=null,this.producer=null,this.renderPolicy=null,this.scriptModel=null,this.silentPrint=null,this.submitFormat=null,this.tagged=null,this.version=null,this.viewerPreferences=null,this.xdc=null}}class Xe extends i.XFAObject{constructor(e){super(o,"pdfa",!0),this.amd=null,this.conformance=null,this.includeXDPContent=null,this.part=null}}class $e extends i.XFAObject{constructor(e){super(o,"permissions",!0),this.accessibleContent=null,this.change=null,this.contentCopy=null,this.documentAssembly=null,this.formFieldFilling=null,this.modifyAnnots=null,this.plaintextMetadata=null,this.print=null,this.printHighQuality=null}}class qe extends i.Option01{constructor(e){super(o,"pickTrayByPDFSize")}}class ze extends i.StringObject{constructor(e){super(o,"picture")}}class He extends i.Option01{constructor(e){super(o,"plaintextMetadata")}}class Ge extends i.OptionObject{constructor(e){super(o,"presence",["preserve","dissolve","dissolveStructure","ignore","remove"])}}class Ve extends i.XFAObject{constructor(e){super(o,"present",!0),this.behaviorOverride=null,this.cache=null,this.common=null,this.copies=null,this.destination=null,this.incrementalMerge=null,this.layout=null,this.output=null,this.overprint=null,this.pagination=null,this.paginationOverride=null,this.script=null,this.validate=null,this.xdp=null,this.driver=new i.XFAObjectArray,this.labelPrinter=new i.XFAObjectArray,this.pcl=new i.XFAObjectArray,this.pdf=new i.XFAObjectArray,this.ps=new i.XFAObjectArray,this.submitUrl=new i.XFAObjectArray,this.webClient=new i.XFAObjectArray,this.zpl=new i.XFAObjectArray}}class We extends i.Option01{constructor(e){super(o,"print")}}class Ke extends i.Option01{constructor(e){super(o,"printHighQuality")}}class Ye extends i.OptionObject{constructor(e){super(o,"printScaling",["appdefault","noScaling"])}}class Je extends i.StringObject{constructor(e){super(o,"printerName")}}class Ze extends i.StringObject{constructor(e){super(o,"producer")}}class Qe extends i.XFAObject{constructor(e){super(o,"ps",!0),this.name=e.name||"",this.batchOutput=null,this.fontInfo=null,this.jog=null,this.mediumInfo=null,this.outputBin=null,this.staple=null,this.xdc=null}}class et extends i.ContentObject{constructor(e){super(o,"range")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s*,\s*/,2).map((e=>e.split("-").map((e=>parseInt(e.trim(),10))))).filter((e=>e.every((e=>!isNaN(e))))).map((e=>(1===e.length&&e.push(e[0]),e)))}}class tt extends i.ContentObject{constructor(e){super(o,"record")}[i.$finalize](){this[i.$content]=this[i.$content].trim();const e=parseInt(this[i.$content],10);!isNaN(e)&&e>=0&&(this[i.$content]=e)}}class rt extends i.ContentObject{constructor(e){super(o,"relevant")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s+/)}}class at extends i.ContentObject{constructor(e){super(o,"rename")}[i.$finalize](){this[i.$content]=this[i.$content].trim(),(this[i.$content].toLowerCase().startsWith("xml")||this[i.$content].match(new RegExp("[\\p{L}_][\\p{L}\\d._\\p{M}-]*","u")))&&(0,s.warn)("XFA - Rename: invalid XFA name")}}class it extends i.OptionObject{constructor(e){super(o,"renderPolicy",["server","client"])}}class nt extends i.OptionObject{constructor(e){super(o,"runScripts",["both","client","none","server"])}}class st extends i.XFAObject{constructor(e){super(o,"script",!0),this.currentPage=null,this.exclude=null,this.runScripts=null}}class ot extends i.OptionObject{constructor(e){super(o,"scriptModel",["XFA","none"])}}class ct extends i.OptionObject{constructor(e){super(o,"severity",["ignore","error","information","trace","warning"])}}class lt extends i.XFAObject{constructor(e){super(o,"silentPrint",!0),this.addSilentPrint=null,this.printerName=null}}class ht extends i.XFAObject{constructor(e){super(o,"staple"),this.mode=(0,n.getStringOption)(e.mode,["usePrinterSetting","on","off"])}}class ut extends i.StringObject{constructor(e){super(o,"startNode")}}class dt extends i.IntegerObject{constructor(e){super(o,"startPage",0,(e=>!0))}}class ft extends i.OptionObject{constructor(e){super(o,"submitFormat",["html","delegate","fdf","xml","pdf"])}}class gt extends i.StringObject{constructor(e){super(o,"submitUrl")}}class pt extends i.IntegerObject{constructor(e){super(o,"subsetBelow",100,(e=>e>=0&&e<=100))}}class mt extends i.Option01{constructor(e){super(o,"suppressBanner")}}class bt extends i.Option01{constructor(e){super(o,"tagged")}}class yt extends i.XFAObject{constructor(e){super(o,"template",!0),this.base=null,this.relevant=null,this.startPage=null,this.uri=null,this.xsl=null}}class wt extends i.OptionObject{constructor(e){super(o,"threshold",["trace","error","information","warning"])}}class vt extends i.OptionObject{constructor(e){super(o,"to",["null","memory","stderr","stdout","system","uri"])}}class St extends i.XFAObject{constructor(e){super(o,"templateCache"),this.maxEntries=(0,n.getInteger)({data:e.maxEntries,defaultValue:5,validator:e=>e>=0})}}class kt extends i.XFAObject{constructor(e){super(o,"trace",!0),this.area=new i.XFAObjectArray}}class xt extends i.XFAObject{constructor(e){super(o,"transform",!0),this.groupParent=null,this.ifEmpty=null,this.nameAttr=null,this.picture=null,this.presence=null,this.rename=null,this.whitespace=null}}class At extends i.OptionObject{constructor(e){super(o,"type",["none","ascii85","asciiHex","ccittfax","flate","lzw","runLength","native","xdp","mergedXDP"])}}class Ct extends i.StringObject{constructor(e){super(o,"uri")}}class Ot extends i.OptionObject{constructor(e){super(o,"validate",["preSubmit","prePrint","preExecute","preSave"])}}class Ft extends i.ContentObject{constructor(e){super(o,"validateApprovalSignatures")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s+/).filter((e=>["docReady","postSign"].includes(e)))}}class It extends i.OptionObject{constructor(e){super(o,"validationMessaging",["allMessagesIndividually","allMessagesTogether","firstMessageOnly","noMessages"])}}class Tt extends i.OptionObject{constructor(e){super(o,"version",["1.7","1.6","1.5","1.4","1.3","1.2"])}}class Pt extends i.XFAObject{constructor(e){super(o,"VersionControl"),this.outputBelow=(0,n.getStringOption)(e.outputBelow,["warn","error","update"]),this.sourceAbove=(0,n.getStringOption)(e.sourceAbove,["warn","error"]),this.sourceBelow=(0,n.getStringOption)(e.sourceBelow,["update","maintain"])}}class Et extends i.XFAObject{constructor(e){super(o,"viewerPreferences",!0),this.ADBE_JSConsole=null,this.ADBE_JSDebugger=null,this.addViewerPreferences=null,this.duplexOption=null,this.enforce=null,this.numberOfCopies=null,this.pageRange=null,this.pickTrayByPDFSize=null,this.printScaling=null}}class Mt extends i.XFAObject{constructor(e){super(o,"webClient",!0),this.name=e.name?e.name.trim():"",this.fontInfo=null,this.xdc=null}}class Nt extends i.OptionObject{constructor(e){super(o,"whitespace",["preserve","ltrim","normalize","rtrim","trim"])}}class Dt extends i.ContentObject{constructor(e){super(o,"window")}[i.$finalize](){const e=this[i.$content].trim().split(/\s*,\s*/,2).map((e=>parseInt(e,10)));e.some((e=>isNaN(e)))?this[i.$content]=[0,0]:(1===e.length&&e.push(e[0]),this[i.$content]=e)}}class Bt extends i.XFAObject{constructor(e){super(o,"xdc",!0),this.uri=new i.XFAObjectArray,this.xsl=new i.XFAObjectArray}}class jt extends i.XFAObject{constructor(e){super(o,"xdp",!0),this.packets=null}}class Lt extends i.XFAObject{constructor(e){super(o,"xsl",!0),this.debug=null,this.uri=null}}class Rt extends i.XFAObject{constructor(e){super(o,"zpl",!0),this.name=e.name?e.name.trim():"",this.batchOutput=null,this.flipLabel=null,this.fontInfo=null,this.xdc=null}}class _t{static[a.$buildXFAObject](e,t){if(_t.hasOwnProperty(e))return _t[e](t)}static acrobat(e){return new c(e)}static acrobat7(e){return new l(e)}static ADBE_JSConsole(e){return new h(e)}static ADBE_JSDebugger(e){return new u(e)}static addSilentPrint(e){return new d(e)}static addViewerPreferences(e){return new f(e)}static adjustData(e){return new g(e)}static adobeExtensionLevel(e){return new p(e)}static agent(e){return new m(e)}static alwaysEmbed(e){return new b(e)}static amd(e){return new y(e)}static area(e){return new w(e)}static attributes(e){return new v(e)}static autoSave(e){return new S(e)}static base(e){return new k(e)}static batchOutput(e){return new x(e)}static behaviorOverride(e){return new A(e)}static cache(e){return new C(e)}static change(e){return new O(e)}static common(e){return new F(e)}static compress(e){return new I(e)}static compressLogicalStructure(e){return new T(e)}static compressObjectStream(e){return new P(e)}static compression(e){return new E(e)}static config(e){return new M(e)}static conformance(e){return new N(e)}static contentCopy(e){return new D(e)}static copies(e){return new B(e)}static creator(e){return new j(e)}static currentPage(e){return new L(e)}static data(e){return new R(e)}static debug(e){return new _(e)}static defaultTypeface(e){return new U(e)}static destination(e){return new X(e)}static documentAssembly(e){return new $(e)}static driver(e){return new q(e)}static duplexOption(e){return new z(e)}static dynamicRender(e){return new H(e)}static embed(e){return new G(e)}static encrypt(e){return new V(e)}static encryption(e){return new W(e)}static encryptionLevel(e){return new K(e)}static enforce(e){return new Y(e)}static equate(e){return new J(e)}static equateRange(e){return new Z(e)}static exclude(e){return new Q(e)}static excludeNS(e){return new ee(e)}static flipLabel(e){return new te(e)}static fontInfo(e){return new re(e)}static formFieldFilling(e){return new ae(e)}static groupParent(e){return new ie(e)}static ifEmpty(e){return new ne(e)}static includeXDPContent(e){return new se(e)}static incrementalLoad(e){return new oe(e)}static incrementalMerge(e){return new ce(e)}static interactive(e){return new le(e)}static jog(e){return new he(e)}static labelPrinter(e){return new ue(e)}static layout(e){return new de(e)}static level(e){return new fe(e)}static linearized(e){return new ge(e)}static locale(e){return new pe(e)}static localeSet(e){return new me(e)}static log(e){return new be(e)}static map(e){return new ye(e)}static mediumInfo(e){return new we(e)}static message(e){return new ve(e)}static messaging(e){return new Se(e)}static mode(e){return new ke(e)}static modifyAnnots(e){return new xe(e)}static msgId(e){return new Ae(e)}static nameAttr(e){return new Ce(e)}static neverEmbed(e){return new Oe(e)}static numberOfCopies(e){return new Fe(e)}static openAction(e){return new Ie(e)}static output(e){return new Te(e)}static outputBin(e){return new Pe(e)}static outputXSL(e){return new Ee(e)}static overprint(e){return new Me(e)}static packets(e){return new Ne(e)}static pageOffset(e){return new De(e)}static pageRange(e){return new Be(e)}static pagination(e){return new je(e)}static paginationOverride(e){return new Le(e)}static part(e){return new Re(e)}static pcl(e){return new _e(e)}static pdf(e){return new Ue(e)}static pdfa(e){return new Xe(e)}static permissions(e){return new $e(e)}static pickTrayByPDFSize(e){return new qe(e)}static picture(e){return new ze(e)}static plaintextMetadata(e){return new He(e)}static presence(e){return new Ge(e)}static present(e){return new Ve(e)}static print(e){return new We(e)}static printHighQuality(e){return new Ke(e)}static printScaling(e){return new Ye(e)}static printerName(e){return new Je(e)}static producer(e){return new Ze(e)}static ps(e){return new Qe(e)}static range(e){return new et(e)}static record(e){return new tt(e)}static relevant(e){return new rt(e)}static rename(e){return new at(e)}static renderPolicy(e){return new it(e)}static runScripts(e){return new nt(e)}static script(e){return new st(e)}static scriptModel(e){return new ot(e)}static severity(e){return new ct(e)}static silentPrint(e){return new lt(e)}static staple(e){return new ht(e)}static startNode(e){return new ut(e)}static startPage(e){return new dt(e)}static submitFormat(e){return new ft(e)}static submitUrl(e){return new gt(e)}static subsetBelow(e){return new pt(e)}static suppressBanner(e){return new mt(e)}static tagged(e){return new bt(e)}static template(e){return new yt(e)}static templateCache(e){return new St(e)}static threshold(e){return new wt(e)}static to(e){return new vt(e)}static trace(e){return new kt(e)}static transform(e){return new xt(e)}static type(e){return new At(e)}static uri(e){return new Ct(e)}static validate(e){return new Ot(e)}static validateApprovalSignatures(e){return new Ft(e)}static validationMessaging(e){return new It(e)}static version(e){return new Tt(e)}static versionControl(e){return new Pt(e)}static viewerPreferences(e){return new Et(e)}static webClient(e){return new Mt(e)}static whitespace(e){return new Nt(e)}static window(e){return new Dt(e)}static xdc(e){return new Bt(e)}static xdp(e){return new jt(e)}static xsl(e){return new Lt(e)}static zpl(e){return new Rt(e)}}t.ConfigNamespace=_t},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ConnectionSetNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.connectionSet.id;class s extends i.XFAObject{constructor(e){super(n,"connectionSet",!0),this.wsdlConnection=new i.XFAObjectArray,this.xmlConnection=new i.XFAObjectArray,this.xsdConnection=new i.XFAObjectArray}}class o extends i.XFAObject{constructor(e){super(n,"effectiveInputPolicy"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class c extends i.XFAObject{constructor(e){super(n,"effectiveOutputPolicy"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class l extends i.StringObject{constructor(e){super(n,"operation"),this.id=e.id||"",this.input=e.input||"",this.name=e.name||"",this.output=e.output||"",this.use=e.use||"",this.usehref=e.usehref||""}}class h extends i.StringObject{constructor(e){super(n,"rootElement"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class u extends i.StringObject{constructor(e){super(n,"soapAction"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class d extends i.StringObject{constructor(e){super(n,"soapAddress"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class f extends i.StringObject{constructor(e){super(n,"uri"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class g extends i.StringObject{constructor(e){super(n,"wsdlAddress"),this.id=e.id||"",this.name=e.name||"",this.use=e.use||"",this.usehref=e.usehref||""}}class p extends i.XFAObject{constructor(e){super(n,"wsdlConnection",!0),this.dataDescription=e.dataDescription||"",this.name=e.name||"",this.effectiveInputPolicy=null,this.effectiveOutputPolicy=null,this.operation=null,this.soapAction=null,this.soapAddress=null,this.wsdlAddress=null}}class m extends i.XFAObject{constructor(e){super(n,"xmlConnection",!0),this.dataDescription=e.dataDescription||"",this.name=e.name||"",this.uri=null}}class b extends i.XFAObject{constructor(e){super(n,"xsdConnection",!0),this.dataDescription=e.dataDescription||"",this.name=e.name||"",this.rootElement=null,this.uri=null}}class y{static[a.$buildXFAObject](e,t){if(y.hasOwnProperty(e))return y[e](t)}static connectionSet(e){return new s(e)}static effectiveInputPolicy(e){return new o(e)}static effectiveOutputPolicy(e){return new c(e)}static operation(e){return new l(e)}static rootElement(e){return new h(e)}static soapAction(e){return new u(e)}static soapAddress(e){return new d(e)}static uri(e){return new f(e)}static wsdlAddress(e){return new g(e)}static wsdlConnection(e){return new p(e)}static xmlConnection(e){return new m(e)}static xsdConnection(e){return new b(e)}}t.ConnectionSetNamespace=y},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.DatasetsNamespace=void 0;var a=r(50),i=r(52);const n=i.NamespaceIds.datasets.id;class s extends a.XmlObject{constructor(e){super(n,"data",e)}}class o extends a.XFAObject{constructor(e){super(n,"datasets",!0),this.data=null,this.Signature=null}[a.$onChild](e){const t=e[a.$nodeName];"data"===t&&e[a.$namespaceId]===n||"Signature"===t&&e[a.$namespaceId]===i.NamespaceIds.signature.id?this[t]=e:e[a.$global]=!0,this[a.$appendChild](e)}}class c{static[i.$buildXFAObject](e,t){if(c.hasOwnProperty(e))return c[e](t)}static datasets(e){return new o(e)}static data(e){return new s(e)}}t.DatasetsNamespace=c},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.LocaleSetNamespace=void 0;var a=r(52),i=r(50),n=r(51);const s=a.NamespaceIds.localeSet.id;class o extends i.XFAObject{constructor(e){super(s,"calendarSymbols",!0),this.name="gregorian",this.dayNames=new i.XFAObjectArray(2),this.eraNames=null,this.meridiemNames=null,this.monthNames=new i.XFAObjectArray(2)}}class c extends i.StringObject{constructor(e){super(s,"currencySymbol"),this.name=(0,n.getStringOption)(e.name,["symbol","isoname","decimal"])}}class l extends i.XFAObject{constructor(e){super(s,"currencySymbols",!0),this.currencySymbol=new i.XFAObjectArray(3)}}class h extends i.StringObject{constructor(e){super(s,"datePattern"),this.name=(0,n.getStringOption)(e.name,["full","long","med","short"])}}class u extends i.XFAObject{constructor(e){super(s,"datePatterns",!0),this.datePattern=new i.XFAObjectArray(4)}}class d extends i.ContentObject{constructor(e){super(s,"dateTimeSymbols")}}class f extends i.StringObject{constructor(e){super(s,"day")}}class g extends i.XFAObject{constructor(e){super(s,"dayNames",!0),this.abbr=(0,n.getInteger)({data:e.abbr,defaultValue:0,validate:e=>1===e}),this.day=new i.XFAObjectArray(7)}}class p extends i.StringObject{constructor(e){super(s,"era")}}class m extends i.XFAObject{constructor(e){super(s,"eraNames",!0),this.era=new i.XFAObjectArray(2)}}class b extends i.XFAObject{constructor(e){super(s,"locale",!0),this.desc=e.desc||"",this.name="isoname",this.calendarSymbols=null,this.currencySymbols=null,this.datePatterns=null,this.dateTimeSymbols=null,this.numberPatterns=null,this.numberSymbols=null,this.timePatterns=null,this.typeFaces=null}}class y extends i.XFAObject{constructor(e){super(s,"localeSet",!0),this.locale=new i.XFAObjectArray}}class w extends i.StringObject{constructor(e){super(s,"meridiem")}}class v extends i.XFAObject{constructor(e){super(s,"meridiemNames",!0),this.meridiem=new i.XFAObjectArray(2)}}class S extends i.StringObject{constructor(e){super(s,"month")}}class k extends i.XFAObject{constructor(e){super(s,"monthNames",!0),this.abbr=(0,n.getInteger)({data:e.abbr,defaultValue:0,validate:e=>1===e}),this.month=new i.XFAObjectArray(12)}}class x extends i.StringObject{constructor(e){super(s,"numberPattern"),this.name=(0,n.getStringOption)(e.name,["full","long","med","short"])}}class A extends i.XFAObject{constructor(e){super(s,"numberPatterns",!0),this.numberPattern=new i.XFAObjectArray(4)}}class C extends i.StringObject{constructor(e){super(s,"numberSymbol"),this.name=(0,n.getStringOption)(e.name,["decimal","grouping","percent","minus","zero"])}}class O extends i.XFAObject{constructor(e){super(s,"numberSymbols",!0),this.numberSymbol=new i.XFAObjectArray(5)}}class F extends i.StringObject{constructor(e){super(s,"timePattern"),this.name=(0,n.getStringOption)(e.name,["full","long","med","short"])}}class I extends i.XFAObject{constructor(e){super(s,"timePatterns",!0),this.timePattern=new i.XFAObjectArray(4)}}class T extends i.XFAObject{constructor(e){super(s,"typeFace",!0),this.name=""|e.name}}class P extends i.XFAObject{constructor(e){super(s,"typeFaces",!0),this.typeFace=new i.XFAObjectArray}}class E{static[a.$buildXFAObject](e,t){if(E.hasOwnProperty(e))return E[e](t)}static calendarSymbols(e){return new o(e)}static currencySymbol(e){return new c(e)}static currencySymbols(e){return new l(e)}static datePattern(e){return new h(e)}static datePatterns(e){return new u(e)}static dateTimeSymbols(e){return new d(e)}static day(e){return new f(e)}static dayNames(e){return new g(e)}static era(e){return new p(e)}static eraNames(e){return new m(e)}static locale(e){return new b(e)}static localeSet(e){return new y(e)}static meridiem(e){return new w(e)}static meridiemNames(e){return new v(e)}static month(e){return new S(e)}static monthNames(e){return new k(e)}static numberPattern(e){return new x(e)}static numberPatterns(e){return new A(e)}static numberSymbol(e){return new C(e)}static numberSymbols(e){return new O(e)}static timePattern(e){return new F(e)}static timePatterns(e){return new I(e)}static typeFace(e){return new T(e)}static typeFaces(e){return new P(e)}}t.LocaleSetNamespace=E},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.SignatureNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.signature.id;class s extends i.XFAObject{constructor(e){super(n,"signature",!0)}}class o{static[a.$buildXFAObject](e,t){if(o.hasOwnProperty(e))return o[e](t)}static signature(e){return new s(e)}}t.SignatureNamespace=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.StylesheetNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.stylesheet.id;class s extends i.XFAObject{constructor(e){super(n,"stylesheet",!0)}}class o{static[a.$buildXFAObject](e,t){if(o.hasOwnProperty(e))return o[e](t)}static stylesheet(e){return new s(e)}}t.StylesheetNamespace=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XdpNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.xdp.id;class s extends i.XFAObject{constructor(e){super(n,"xdp",!0),this.uuid=e.uuid||"",this.timeStamp=e.timeStamp||"",this.config=null,this.connectionSet=null,this.datasets=null,this.localeSet=null,this.stylesheet=new i.XFAObjectArray,this.template=null}[i.$onChildCheck](e){const t=a.NamespaceIds[e[i.$nodeName]];return t&&e[i.$namespaceId]===t.id}}class o{static[a.$buildXFAObject](e,t){if(o.hasOwnProperty(e))return o[e](t)}static xdp(e){return new s(e)}}t.XdpNamespace=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XhtmlNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.xhtml.id,s=new Set(["color","font","font-family","font-size","font-stretch","font-style","font-weight","margin","margin-bottom","margin-left","margin-right","margin-top","letter-spacing","line-height","orphans","page-break-after","page-break-before","page-break-inside","tab-interval","tab-stop","text-decoration","text-indent","vertical-align","widows","kerning-mode","xfa-font-horizontal-scale","xfa-font-vertical-scale","xfa-tab-stops"]);function o(e){return e?e.trim().split(/\s*;\s*/).filter((e=>!!e)).map((e=>e.split(/\s*:\s*/,2))).filter((([e])=>s.has(e))).map((e=>e.join(":"))).join(";"):""}class c extends i.XmlObject{constructor(e){super(n,"a"),this.href=e.href||"",this.style=o(e.style)}}class l extends i.XmlObject{constructor(e){super(n,"b"),this.style=o(e.style)}}class h extends i.XmlObject{constructor(e){super(n,"body"),this.style=o(e.style)}}class u extends i.XmlObject{constructor(e){super(n,"br"),this.style=o(e.style)}[i.$text](){return"\n"}}class d extends i.XmlObject{constructor(e){super(n,"html"),this.style=o(e.style)}}class f extends i.XmlObject{constructor(e){super(n,"i"),this.style=o(e.style)}}class g extends i.XmlObject{constructor(e){super(n,"li"),this.style=o(e.style)}}class p extends i.XmlObject{constructor(e){super(n,"ol"),this.style=o(e.style)}}class m extends i.XmlObject{constructor(e){super(n,"p"),this.style=o(e.style)}}class b extends i.XmlObject{constructor(e){super(n,"span"),this.style=o(e.style)}}class y extends i.XmlObject{constructor(e){super(n,"sub"),this.style=o(e.style)}}class w extends i.XmlObject{constructor(e){super(n,"sup"),this.style=o(e.style)}}class v extends i.XmlObject{constructor(e){super(n,"ul"),this.style=o(e.style)}}class S{static[a.$buildXFAObject](e,t){if(S.hasOwnProperty(e))return S[e](t)}static a(e){return new c(e)}static b(e){return new l(e)}static body(e){return new h(e)}static br(e){return new u(e)}static html(e){return new d(e)}static i(e){return new f(e)}static li(e){return new g(e)}static ol(e){return new p(e)}static p(e){return new m(e)}static span(e){return new b(e)}static sub(e){return new y(e)}static sup(e){return new w(e)}static ul(e){return new v(e)}}t.XhtmlNamespace=S},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.UnknownNamespace=void 0;var a=r(52),i=r(50);class n{constructor(e){this.namespaceId=e}[a.$buildXFAObject](e,t){return new i.XmlObject(this.namespaceId,e,t)}}t.UnknownNamespace=n},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.MessageHandler=void 0;var a=r(2);const i=1,n=2,s=1,o=2,c=3,l=4,h=5,u=6,d=7,f=8;function g(e){if("object"!=typeof e||null===e)return e;switch(e.name){case"AbortException":return new a.AbortException(e.message);case"MissingPDFException":return new a.MissingPDFException(e.message);case"UnexpectedResponseException":return new a.UnexpectedResponseException(e.message,e.status);case"UnknownErrorException":return new a.UnknownErrorException(e.message,e.details);default:return new a.UnknownErrorException(e.message,e.toString())}}t.MessageHandler=class{constructor(e,t,r){this.sourceName=e,this.targetName=t,this.comObj=r,this.callbackId=1,this.streamId=1,this.postMessageTransfers=!0,this.streamSinks=Object.create(null),this.streamControllers=Object.create(null),this.callbackCapabilities=Object.create(null),this.actionHandler=Object.create(null),this._onComObjOnMessage=e=>{const t=e.data;if(t.targetName!==this.sourceName)return;if(t.stream)return void this._processStreamMessage(t);if(t.callback){const e=t.callbackId,r=this.callbackCapabilities[e];if(!r)throw new Error(`Cannot resolve callback ${e}`);if(delete this.callbackCapabilities[e],t.callback===i)r.resolve(t.data);else{if(t.callback!==n)throw new Error("Unexpected callback case");r.reject(g(t.reason))}return}const a=this.actionHandler[t.action];if(!a)throw new Error(`Unknown action from worker: ${t.action}`);if(t.callbackId){const e=this.sourceName,s=t.sourceName;new Promise((function(e){e(a(t.data))})).then((function(a){r.postMessage({sourceName:e,targetName:s,callback:i,callbackId:t.callbackId,data:a})}),(function(a){r.postMessage({sourceName:e,targetName:s,callback:n,callbackId:t.callbackId,reason:g(a)})}))}else t.streamId?this._createStreamSink(t):a(t.data)},r.addEventListener("message",this._onComObjOnMessage)}on(e,t){const r=this.actionHandler;if(r[e])throw new Error(`There is already an actionName called "${e}"`);r[e]=t}send(e,t,r){this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,data:t},r)}sendWithPromise(e,t,r){const i=this.callbackId++,n=(0,a.createPromiseCapability)();this.callbackCapabilities[i]=n;try{this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,callbackId:i,data:t},r)}catch(e){n.reject(e)}return n.promise}sendWithStream(e,t,r,i){const n=this.streamId++,o=this.sourceName,c=this.targetName,l=this.comObj;return new ReadableStream({start:r=>{const s=(0,a.createPromiseCapability)();return this.streamControllers[n]={controller:r,startCall:s,pullCall:null,cancelCall:null,isClosed:!1},this._postMessage({sourceName:o,targetName:c,action:e,streamId:n,data:t,desiredSize:r.desiredSize},i),s.promise},pull:e=>{const t=(0,a.createPromiseCapability)();return this.streamControllers[n].pullCall=t,l.postMessage({sourceName:o,targetName:c,stream:u,streamId:n,desiredSize:e.desiredSize}),t.promise},cancel:e=>{(0,a.assert)(e instanceof Error,"cancel must have a valid reason");const t=(0,a.createPromiseCapability)();return this.streamControllers[n].cancelCall=t,this.streamControllers[n].isClosed=!0,l.postMessage({sourceName:o,targetName:c,stream:s,streamId:n,reason:g(e)}),t.promise}},r)}_createStreamSink(e){const t=this,r=this.actionHandler[e.action],i=e.streamId,n=this.sourceName,s=e.sourceName,o=this.comObj,u={enqueue(e,r=1,o){if(this.isCancelled)return;const c=this.desiredSize;this.desiredSize-=r,c>0&&this.desiredSize<=0&&(this.sinkCapability=(0,a.createPromiseCapability)(),this.ready=this.sinkCapability.promise),t._postMessage({sourceName:n,targetName:s,stream:l,streamId:i,chunk:e},o)},close(){this.isCancelled||(this.isCancelled=!0,o.postMessage({sourceName:n,targetName:s,stream:c,streamId:i}),delete t.streamSinks[i])},error(e){(0,a.assert)(e instanceof Error,"error must have a valid reason"),this.isCancelled||(this.isCancelled=!0,o.postMessage({sourceName:n,targetName:s,stream:h,streamId:i,reason:g(e)}))},sinkCapability:(0,a.createPromiseCapability)(),onPull:null,onCancel:null,isCancelled:!1,desiredSize:e.desiredSize,ready:null};u.sinkCapability.resolve(),u.ready=u.sinkCapability.promise,this.streamSinks[i]=u,new Promise((function(t){t(r(e.data,u))})).then((function(){o.postMessage({sourceName:n,targetName:s,stream:f,streamId:i,success:!0})}),(function(e){o.postMessage({sourceName:n,targetName:s,stream:f,streamId:i,reason:g(e)})}))}_processStreamMessage(e){const t=e.streamId,r=this.sourceName,i=e.sourceName,n=this.comObj;switch(e.stream){case f:e.success?this.streamControllers[t].startCall.resolve():this.streamControllers[t].startCall.reject(g(e.reason));break;case d:e.success?this.streamControllers[t].pullCall.resolve():this.streamControllers[t].pullCall.reject(g(e.reason));break;case u:if(!this.streamSinks[t]){n.postMessage({sourceName:r,targetName:i,stream:d,streamId:t,success:!0});break}this.streamSinks[t].desiredSize<=0&&e.desiredSize>0&&this.streamSinks[t].sinkCapability.resolve(),this.streamSinks[t].desiredSize=e.desiredSize;const{onPull:p}=this.streamSinks[e.streamId];new Promise((function(e){e(p&&p())})).then((function(){n.postMessage({sourceName:r,targetName:i,stream:d,streamId:t,success:!0})}),(function(e){n.postMessage({sourceName:r,targetName:i,stream:d,streamId:t,reason:g(e)})}));break;case l:if((0,a.assert)(this.streamControllers[t],"enqueue should have stream controller"),this.streamControllers[t].isClosed)break;this.streamControllers[t].controller.enqueue(e.chunk);break;case c:if((0,a.assert)(this.streamControllers[t],"close should have stream controller"),this.streamControllers[t].isClosed)break;this.streamControllers[t].isClosed=!0,this.streamControllers[t].controller.close(),this._deleteStreamController(t);break;case h:(0,a.assert)(this.streamControllers[t],"error should have stream controller"),this.streamControllers[t].controller.error(g(e.reason)),this._deleteStreamController(t);break;case o:e.success?this.streamControllers[t].cancelCall.resolve():this.streamControllers[t].cancelCall.reject(g(e.reason)),this._deleteStreamController(t);break;case s:if(!this.streamSinks[t])break;const{onCancel:m}=this.streamSinks[e.streamId];new Promise((function(t){t(m&&m(g(e.reason)))})).then((function(){n.postMessage({sourceName:r,targetName:i,stream:o,streamId:t,success:!0})}),(function(e){n.postMessage({sourceName:r,targetName:i,stream:o,streamId:t,reason:g(e)})})),this.streamSinks[t].sinkCapability.reject(g(e.reason)),this.streamSinks[t].isCancelled=!0,delete this.streamSinks[t];break;default:throw new Error("Unexpected stream case")}}async _deleteStreamController(e){await Promise.allSettled([this.streamControllers[e].startCall,this.streamControllers[e].pullCall,this.streamControllers[e].cancelCall].map((function(e){return e&&e.promise}))),delete this.streamControllers[e]}_postMessage(e,t){t&&this.postMessageTransfers?this.comObj.postMessage(e,t):this.comObj.postMessage(e)}destroy(){this.comObj.removeEventListener("message",this._onComObjOnMessage)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFWorkerStream=void 0;var a=r(2);t.PDFWorkerStream=class{constructor(e){this._msgHandler=e,this._contentLength=null,this._fullRequestReader=null,this._rangeRequestReaders=[]}getFullReader(){return(0,a.assert)(!this._fullRequestReader,"PDFWorkerStream.getFullReader can only be called once."),this._fullRequestReader=new i(this._msgHandler),this._fullRequestReader}getRangeReader(e,t){const r=new n(e,t,this._msgHandler);return this._rangeRequestReaders.push(r),r}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);this._rangeRequestReaders.slice(0).forEach((function(t){t.cancel(e)}))}};class i{constructor(e){this._msgHandler=e,this.onProgress=null,this._contentLength=null,this._isRangeSupported=!1,this._isStreamingSupported=!1;const t=this._msgHandler.sendWithStream("GetReader");this._reader=t.getReader(),this._headersReady=this._msgHandler.sendWithPromise("ReaderHeadersReady").then((e=>{this._isStreamingSupported=e.isStreamingSupported,this._isRangeSupported=e.isRangeSupported,this._contentLength=e.contentLength}))}get headersReady(){return this._headersReady}get contentLength(){return this._contentLength}get isStreamingSupported(){return this._isStreamingSupported}get isRangeSupported(){return this._isRangeSupported}async read(){const{value:e,done:t}=await this._reader.read();return t?{value:void 0,done:!0}:{value:e.buffer,done:!1}}cancel(e){this._reader.cancel(e)}}class n{constructor(e,t,r){this._msgHandler=r,this.onProgress=null;const a=this._msgHandler.sendWithStream("GetRangeReader",{begin:e,end:t});this._reader=a.getReader()}get isStreamingSupported(){return!1}async read(){const{value:e,done:t}=await this._reader.read();return t?{value:void 0,done:!0}:{value:e.buffer,done:!1}}cancel(e){this._reader.cancel(e)}}}],t={};function r(a){var i=t[a];if(void 0!==i)return i.exports;var n=t[a]={exports:{}};return e[a](n,n.exports,r),n.exports}r.d=(e,t)=>{for(var a in t)r.o(t,a)&&!r.o(e,a)&&Object.defineProperty(e,a,{enumerable:!0,get:t[a]})},r.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var a={};return(()=>{var e=a;Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"WorkerMessageHandler",{enumerable:!0,get:function(){return t.WorkerMessageHandler}});var t=r(1)})(),a})()}));